/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;

class ClasspathAlignmentChecker {
    static final List<String> WELL_KNOWN_PACKAGES = Collections.unmodifiableList(Arrays.asList("org.junit.jupiter.api", "org.junit.jupiter.engine", "org.junit.jupiter.migrationsupport", "org.junit.jupiter.params", "org.junit.platform.commons", "org.junit.platform.console", "org.junit.platform.engine", "org.junit.platform.jfr", "org.junit.platform.launcher", "org.junit.platform.reporting", "org.junit.platform.runner", "org.junit.platform.suite.api", "org.junit.platform.suite.commons", "org.junit.platform.suite.engine", "org.junit.platform.testkit", "org.junit.vintage.engine"));

    ClasspathAlignmentChecker() {
    }

    static Optional<JUnitException> check(LinkageError error) {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(ClasspathAlignmentChecker.class);
        Function<String, Package> packageLookup = name -> ReflectionSupport.findMethod(ClassLoader.class, (String)"getDefinedPackage", (Class[])new Class[]{String.class}).map(m -> (Package)ReflectionSupport.invokeMethod((Method)m, (Object)classLoader, (Object[])new Object[]{name})).orElseGet(() -> ClasspathAlignmentChecker.getPackage(name));
        return ClasspathAlignmentChecker.check(error, packageLookup);
    }

    static Optional<JUnitException> check(LinkageError error, Function<String, Package> packageLookup) {
        HashMap packagesByVersions = new HashMap();
        WELL_KNOWN_PACKAGES.stream().map(packageLookup).filter(Objects::nonNull).forEach(pkg -> {
            String version = pkg.getImplementationVersion();
            if (version != null) {
                if (pkg.getName().startsWith("org.junit.platform") && version.contains(".")) {
                    version = ClasspathAlignmentChecker.platformToJupiterVersion(version);
                }
                packagesByVersions.computeIfAbsent(version, __ -> new ArrayList()).add(pkg);
            }
        });
        if (packagesByVersions.size() > 1) {
            StringBuilder message = new StringBuilder();
            String lineBreak = System.lineSeparator();
            message.append("The wrapped ").append(error.getClass().getSimpleName()).append(" is likely caused by the versions of JUnit jars on the classpath/module path ").append("not being properly aligned. ").append(lineBreak).append("Please ensure consistent versions are used (see https://junit.org/junit5/docs/").append(ClasspathAlignmentChecker.platformToJupiterVersion(ClasspathAlignmentChecker.class.getPackage().getImplementationVersion())).append("/user-guide/#dependency-metadata).").append(lineBreak).append("The following conflicting versions were detected:").append(lineBreak);
            packagesByVersions.values().stream().flatMap(Collection::stream).sorted(Comparator.comparing(Package::getName)).map(pkg -> String.format("- %s: %s%n", pkg.getName(), pkg.getImplementationVersion())).forEach(message::append);
            return Optional.of(new JUnitException(message.toString(), (Throwable)error));
        }
        return Optional.empty();
    }

    private static String platformToJupiterVersion(String version) {
        int majorVersion = Integer.parseInt(version.substring(0, version.indexOf("."))) + 4;
        return majorVersion + version.substring(version.indexOf("."));
    }

    private static Package getPackage(String name) {
        return Package.getPackage(name);
    }
}

