# coding=UTF-8
# SPDX-License-Identifier: GPL-2.0-or-later
# Original plugin.video.mlbbasesloaded © jakecar
# Code integrated here as change_monitor

from resources.lib.utils import Util
from resources.lib.globals import *
from resources.lib.mlb import *

class MLBMonitor(xbmc.Monitor):
    stream_started = False
    verify = True
    broadcast_start_timestamp = None
    window = None
    overlay = None
    mlb_monitor_started = ''
    mlb_monitor_file = ''

    #Skip monitor
    skip_adjust_start = 0
    skip_adjust_end = 0
    #These are the break events to skip
    BREAK_TYPES = ['Game Advisory', 'Pitching Substitution', 'Offensive Substitution', 'Defensive Sub', 'Defensive Switch', 'Runner Placed On Base', 'Injury']
    #These are the action events to keep, in addition to the last event of each at-bat, if we're skipping non-decision pitches
    ACTION_TYPES = ['Wild Pitch', 'Passed Ball', 'Stolen Base', 'Caught Stealing', 'Pickoff', 'Error', 'Out', 'Balk', 'Defensive Indiff', 'Other Advance']
    #These are some idle events to skip
    IDLE_TYPES = ['Mound Visit', 'Batter Timeout', 'Pitcher Step Off', 'challenge']
    #Pad events at both start (-) and end (+)
    EVENT_START_PADDING = -6
    PITCH_END_PADDING = 0
    ACTION_END_PADDING = 5
    #Only skip if a break is at least this long
    MINIMUM_BREAK_DURATION = 5
    #Additional padding for MLB games (2025)
    MLB_PADDING = 2
    
    #Additional Game Changer padding for MLB games, in increments of 10
    MLB_GAMECHANGER_PADDING = 10

    #Change monitor
    MAX_LEVERAGE = 11
    
    #Stream Finder
    stream_finder_settings = {}

    #Structure of game state to store for each game
    GameState = namedtuple('GameState',
    ['teams',
     'away_score',
     'home_score',
     'inning_half',
     'inning_num',
     'outs',
     'runners_on_base',
     'game_pk',
     'new_batter',
     'leverage_adjust'])

    #Base situation table for Stream Finder
    BASESIT_TABLE = {
      '0': {
        '0': {
          '0': 1,
          '1': 5
        },
        '1': {
          '0': 3,
          '1': 7
        }
      },
      '1': {
        '0': {
          '0': 2,
          '1': 6
        },
        '1': {
          '0': 4,
          '1': 8
        }
      }
    }
    
    #Leverage index table, used to comput leverage index from game state
    LI_TABLE = {
        1: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.6, 0.7, 0.8, 0.9, 0.0, 0.0, 0.0, 0.0],
                    1: [0.3, 0.4, 0.5, 0.6, 0.6, 0.0, 0.0, 0.0, 0.0],
                    2: [0.2, 0.3, 0.3, 0.4, 0.4, 0.0, 0.0, 0.0, 0.0],
                },
                "1 _ _": {
                    0: [0.7, 0.9, 1.1, 1.3, 1.4, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 0.7, 0.9, 1.0, 1.1, 0.0, 0.0, 0.0, 0.0],
                    2: [0.4, 0.5, 0.6, 0.7, 0.8, 0.0, 0.0, 0.0, 0.0],
                },
                "_ 2 _": {
                    0: [0.6, 0.7, 0.9, 1.0, 1.2, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 0.8, 0.9, 1.1, 1.2, 0.0, 0.0, 0.0, 0.0],
                    2: [0.6, 0.7, 0.9, 1.0, 1.1, 0.0, 0.0, 0.0, 0.0],
                },
                "_ _ 3": {
                    0: [0.5, 0.6, 0.8, 0.9, 1.0, 0.0, 0.0, 0.0, 0.0],
                    1: [0.7, 0.9, 1.0, 1.2, 1.3, 0.0, 0.0, 0.0, 0.0],
                    2: [0.7, 0.9, 1.0, 1.2, 1.3, 0.0, 0.0, 0.0, 0.0],
                },
                "1 2 _": {
                    0: [0.8, 1.1, 1.3, 1.6, 1.8, 0.0, 0.0, 0.0, 0.0],
                    1: [0.9, 1.2, 1.5, 1.7, 1.9, 0.0, 0.0, 0.0, 0.0],
                    2: [0.8, 1.0, 1.3, 1.5, 1.6, 0.0, 0.0, 0.0, 0.0],
                },
                "1 _ 3": {
                    0: [0.6, 0.8, 1.1, 1.3, 1.5, 0.0, 0.0, 0.0, 0.0],
                    1: [0.9, 1.1, 1.3, 1.6, 1.7, 0.0, 0.0, 0.0, 0.0],
                    2: [0.9, 1.1, 1.4, 1.6, 1.7, 0.0, 0.0, 0.0, 0.0],
                },
                "_ 2 3": {
                    0: [0.6, 0.8, 1.0, 1.2, 1.3, 0.0, 0.0, 0.0, 0.0],
                    1: [0.7, 0.9, 1.1, 1.3, 1.4, 0.0, 0.0, 0.0, 0.0],
                    2: [1.0, 1.2, 1.5, 1.7, 1.9, 0.0, 0.0, 0.0, 0.0],
                },
                "1 2 3": {
                    0: [0.8, 1.1, 1.4, 1.7, 2.0, 0.0, 0.0, 0.0, 0.0],
                    1: [1.1, 1.5, 1.8, 2.1, 2.4, 0.0, 0.0, 0.0, 0.0],
                    2: [1.4, 1.8, 2.1, 2.5, 2.7, 0.0, 0.0, 0.0, 0.0],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.7, 0.8, 0.9, 0.9, 0.9, 0.8, 0.6, 0.5, 0.4],
                    1: [0.5, 0.6, 0.6, 0.7, 0.6, 0.6, 0.5, 0.4, 0.3],
                    2: [0.3, 0.4, 0.4, 0.4, 0.4, 0.4, 0.3, 0.3, 0.2],
                },
                "1 _ _": {
                    0: [1.2, 1.4, 1.5, 1.5, 1.4, 1.2, 1.0, 0.8, 0.6],
                    1: [1.0, 1.1, 1.2, 1.2, 1.1, 1.0, 0.8, 0.7, 0.5],
                    2: [0.6, 0.7, 0.8, 0.8, 0.8, 0.7, 0.6, 0.5, 0.4],
                },
                "_ 2 _": {
                    0: [1.1, 1.2, 1.3, 1.2, 1.1, 1.0, 0.8, 0.6, 0.5],
                    1: [1.0, 1.1, 1.2, 1.2, 1.2, 1.0, 0.9, 0.7, 0.5],
                    2: [0.8, 1.0, 1.1, 1.1, 1.1, 1.0, 0.8, 0.7, 0.5],
                },
                "_ _ 3": {
                    0: [1.0, 1.1, 1.1, 1.1, 1.0, 0.8, 0.7, 0.5, 0.4],
                    1: [1.0, 1.1, 1.3, 1.3, 1.3, 1.1, 1.0, 0.8, 0.6],
                    2: [1.0, 1.1, 1.3, 1.3, 1.3, 1.2, 1.0, 0.8, 0.6],
                },
                "1 2 _": {
                    0: [1.7, 1.9, 2.0, 1.9, 1.7, 1.5, 1.2, 0.9, 0.7],
                    1: [1.7, 1.9, 2.0, 2.0, 1.8, 1.6, 1.3, 1.0, 0.8],
                    2: [1.3, 1.5, 1.6, 1.7, 1.6, 1.4, 1.2, 0.9, 0.7],
                },
                "1 _ 3": {
                    0: [1.6, 1.7, 1.7, 1.6, 1.4, 1.2, 1.0, 0.7, 0.5],
                    1: [1.5, 1.7, 1.8, 1.8, 1.7, 1.5, 1.2, 1.0, 0.8],
                    2: [1.4, 1.6, 1.7, 1.8, 1.7, 1.5, 1.3, 1.0, 0.8],
                },
                "_ 2 3": {
                    0: [1.4, 1.5, 1.5, 1.4, 1.3, 1.1, 0.9, 0.7, 0.5],
                    1: [1.4, 1.5, 1.6, 1.5, 1.4, 1.2, 1.0, 0.8, 0.6],
                    2: [1.6, 1.8, 2.0, 2.0, 1.9, 1.7, 1.4, 1.1, 0.8],
                },
                "1 2 3": {
                    0: [2.2, 2.3, 2.3, 2.1, 1.9, 1.6, 1.2, 0.9, 0.7],
                    1: [2.4, 2.6, 2.6, 2.6, 2.3, 2.0, 1.6, 1.3, 1.0],
                    2: [2.4, 2.7, 2.9, 2.9, 2.7, 2.4, 2.0, 1.5, 1.2],
                },
            },
        },
        2: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.6, 0.7, 0.8, 0.9, 1.0, 0.9, 0.8, 0.7],
                    1: [0.3, 0.4, 0.5, 0.6, 0.7, 0.7, 0.6, 0.6, 0.5],
                    2: [0.2, 0.3, 0.3, 0.4, 0.4, 0.4, 0.4, 0.3, 0.3],
                },
                "1 _ _": {
                    0: [0.7, 0.9, 1.1, 1.3, 1.5, 1.5, 1.5, 1.4, 1.2],
                    1: [0.6, 0.7, 0.9, 1.1, 1.2, 1.3, 1.2, 1.1, 0.9],
                    2: [0.4, 0.5, 0.7, 0.8, 0.8, 0.9, 0.8, 0.7, 0.6],
                },
                "_ 2 _": {
                    0: [0.5, 0.7, 0.9, 1.1, 1.2, 1.3, 1.3, 1.2, 1.0],
                    1: [0.6, 0.8, 1.0, 1.1, 1.2, 1.3, 1.2, 1.1, 0.9],
                    2: [0.6, 0.8, 0.9, 1.1, 1.2, 1.2, 1.1, 0.9, 0.8],
                },
                "_ _ 3": {
                    0: [0.4, 0.6, 0.8, 0.9, 1.1, 1.1, 1.2, 1.1, 0.9],
                    1: [0.7, 0.9, 1.1, 1.2, 1.3, 1.3, 1.3, 1.1, 0.9],
                    2: [0.7, 0.9, 1.1, 1.3, 1.4, 1.4, 1.2, 1.1, 0.9],
                },
                "1 2 _": {
                    0: [0.8, 1.1, 1.4, 1.6, 1.9, 2.0, 2.0, 1.9, 1.7],
                    1: [0.9, 1.2, 1.5, 1.8, 2.0, 2.1, 2.0, 1.8, 1.6],
                    2: [0.8, 1.0, 1.3, 1.5, 1.7, 1.7, 1.6, 1.4, 1.2],
                },
                "1 _ 3": {
                    0: [0.6, 0.8, 1.1, 1.3, 1.6, 1.7, 1.8, 1.7, 1.5],
                    1: [0.9, 1.1, 1.4, 1.6, 1.8, 1.8, 1.8, 1.6, 1.4],
                    2: [0.9, 1.1, 1.4, 1.6, 1.8, 1.8, 1.7, 1.5, 1.3],
                },
                "_ 2 3": {
                    0: [0.6, 0.8, 1.0, 1.2, 1.4, 1.5, 1.6, 1.5, 1.4],
                    1: [0.7, 0.9, 1.1, 1.3, 1.5, 1.6, 1.6, 1.5, 1.3],
                    2: [1.0, 1.2, 1.5, 1.8, 2.0, 2.1, 2.0, 1.7, 1.4],
                },
                "1 2 3": {
                    0: [0.8, 1.1, 1.4, 1.7, 2.0, 2.3, 2.4, 2.3, 2.1],
                    1: [1.1, 1.5, 1.8, 2.2, 2.5, 2.7, 2.7, 2.6, 2.3],
                    2: [1.3, 1.7, 2.2, 2.6, 2.9, 3.0, 2.9, 2.6, 2.2],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 0.9, 1.0, 1.0, 0.9, 0.8, 0.6, 0.5, 0.4],
                    1: [0.5, 0.6, 0.7, 0.7, 0.7, 0.6, 0.5, 0.4, 0.3],
                    2: [0.3, 0.4, 0.4, 0.5, 0.4, 0.4, 0.3, 0.2, 0.2],
                },
                "1 _ _": {
                    0: [1.3, 1.5, 1.6, 1.6, 1.5, 1.2, 1.0, 0.8, 0.6],
                    1: [1.0, 1.2, 1.3, 1.3, 1.2, 1.0, 0.8, 0.6, 0.5],
                    2: [0.6, 0.8, 0.9, 0.9, 0.8, 0.7, 0.6, 0.5, 0.3],
                },
                "_ 2 _": {
                    0: [1.1, 1.3, 1.3, 1.3, 1.2, 1.0, 0.8, 0.6, 0.4],
                    1: [1.0, 1.2, 1.3, 1.3, 1.2, 1.1, 0.9, 0.7, 0.5],
                    2: [0.8, 1.0, 1.2, 1.2, 1.2, 1.0, 0.9, 0.7, 0.5],
                },
                "_ _ 3": {
                    0: [1.0, 1.2, 1.2, 1.2, 1.0, 0.9, 0.7, 0.5, 0.4],
                    1: [1.0, 1.2, 1.3, 1.4, 1.4, 1.2, 1.0, 0.8, 0.6],
                    2: [1.0, 1.2, 1.3, 1.4, 1.4, 1.2, 1.0, 0.8, 0.6],
                },
                "1 2 _": {
                    0: [1.8, 2.0, 2.1, 2.0, 1.8, 1.5, 1.2, 0.9, 0.7],
                    1: [1.7, 2.0, 2.1, 2.1, 2.0, 1.7, 1.3, 1.0, 0.7],
                    2: [1.3, 1.6, 1.8, 1.8, 1.7, 1.5, 1.2, 0.9, 0.7],
                },
                "1 _ 3": {
                    0: [1.6, 1.8, 1.8, 1.7, 1.5, 1.2, 0.9, 0.7, 0.5],
                    1: [1.5, 1.8, 1.9, 1.9, 1.8, 1.6, 1.3, 1.0, 0.7],
                    2: [1.4, 1.7, 1.9, 1.9, 1.8, 1.6, 1.3, 1.0, 0.7],
                },
                "_ 2 3": {
                    0: [1.5, 1.6, 1.6, 1.5, 1.3, 1.1, 0.9, 0.7, 0.5],
                    1: [1.4, 1.6, 1.7, 1.6, 1.5, 1.3, 1.0, 0.8, 0.6],
                    2: [1.6, 1.9, 2.1, 2.1, 2.0, 1.7, 1.4, 1.1, 0.8],
                },
                "1 2 3": {
                    0: [2.3, 2.4, 2.4, 2.2, 1.9, 1.6, 1.2, 0.9, 0.6],
                    1: [2.5, 2.7, 2.8, 2.7, 2.4, 2.1, 1.7, 1.3, 0.9],
                    2: [2.5, 2.8, 3.1, 3.1, 2.9, 2.5, 2.0, 1.5, 1.1],
                },
            },
        },
        3: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.6, 0.7, 0.9, 1.0, 1.0, 1.0, 0.9, 0.7],
                    1: [0.3, 0.4, 0.5, 0.6, 0.7, 0.7, 0.7, 0.6, 0.5],
                    2: [0.2, 0.3, 0.4, 0.4, 0.5, 0.5, 0.4, 0.4, 0.3],
                },
                "1 _ _": {
                    0: [0.6, 0.9, 1.1, 1.4, 1.6, 1.7, 1.6, 1.4, 1.2],
                    1: [0.5, 0.7, 1.0, 1.2, 1.3, 1.4, 1.3, 1.1, 0.9],
                    2: [0.4, 0.5, 0.7, 0.8, 0.9, 0.9, 0.8, 0.7, 0.6],
                },
                "_ 2 _": {
                    0: [0.5, 0.7, 0.9, 1.1, 1.3, 1.4, 1.4, 1.2, 1.0],
                    1: [0.6, 0.8, 1.0, 1.2, 1.3, 1.4, 1.3, 1.1, 0.9],
                    2: [0.6, 0.8, 1.0, 1.1, 1.3, 1.3, 1.1, 1.0, 0.8],
                },
                "_ _ 3": {
                    0: [0.4, 0.6, 0.8, 1.0, 1.1, 1.2, 1.2, 1.1, 1.0],
                    1: [0.6, 0.9, 1.1, 1.3, 1.5, 1.5, 1.3, 1.1, 0.9],
                    2: [0.7, 0.9, 1.1, 1.3, 1.5, 1.5, 1.3, 1.1, 0.9],
                },
                "1 2 _": {
                    0: [0.8, 1.0, 1.4, 1.7, 2.0, 2.2, 2.1, 2.0, 1.7],
                    1: [0.9, 1.2, 1.5, 1.8, 2.1, 2.2, 2.1, 1.9, 1.6],
                    2: [0.8, 1.0, 1.3, 1.6, 1.8, 1.9, 1.8, 1.5, 1.2],
                },
                "1 _ 3": {
                    0: [0.6, 0.8, 1.1, 1.4, 1.6, 1.8, 1.9, 1.8, 1.6],
                    1: [0.8, 1.1, 1.4, 1.7, 1.9, 2.0, 1.9, 1.7, 1.5],
                    2: [0.8, 1.1, 1.4, 1.7, 1.9, 2.0, 1.9, 1.6, 1.3],
                },
                "_ 2 3": {
                    0: [0.5, 0.8, 1.0, 1.2, 1.5, 1.6, 1.7, 1.6, 1.4],
                    1: [0.7, 0.9, 1.2, 1.4, 1.6, 1.7, 1.7, 1.6, 1.3],
                    2: [0.9, 1.2, 1.6, 1.9, 2.2, 2.2, 2.1, 1.8, 1.5],
                },
                "1 2 3": {
                    0: [0.7, 1.0, 1.4, 1.8, 2.1, 2.4, 2.6, 2.5, 2.3],
                    1: [1.1, 1.4, 1.9, 2.3, 2.7, 2.9, 2.9, 2.7, 2.4],
                    2: [1.3, 1.7, 2.2, 2.7, 3.1, 3.3, 3.1, 2.7, 2.3],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 0.9, 1.0, 1.1, 1.0, 0.8, 0.6, 0.5, 0.3],
                    1: [0.5, 0.7, 0.7, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3],
                    2: [0.3, 0.4, 0.5, 0.5, 0.5, 0.4, 0.3, 0.2, 0.2],
                },
                "1 _ _": {
                    0: [1.3, 1.6, 1.7, 1.7, 1.5, 1.3, 1.0, 0.7, 0.5],
                    1: [1.0, 1.2, 1.4, 1.4, 1.3, 1.1, 0.8, 0.6, 0.4],
                    2: [0.6, 0.8, 0.9, 1.0, 0.9, 0.8, 0.6, 0.5, 0.3],
                },
                "_ 2 _": {
                    0: [1.2, 1.3, 1.5, 1.4, 1.3, 1.1, 0.8, 0.6, 0.4],
                    1: [1.0, 1.3, 1.4, 1.4, 1.3, 1.1, 0.9, 0.6, 0.5],
                    2: [0.9, 1.1, 1.3, 1.3, 1.3, 1.1, 0.9, 0.6, 0.5],
                },
                "_ _ 3": {
                    0: [1.1, 1.2, 1.3, 1.2, 1.1, 0.9, 0.7, 0.5, 0.3],
                    1: [1.0, 1.3, 1.4, 1.5, 1.5, 1.3, 1.0, 0.7, 0.5],
                    2: [1.0, 1.2, 1.4, 1.6, 1.5, 1.3, 1.0, 0.8, 0.5],
                },
                "1 2 _": {
                    0: [1.9, 2.1, 2.3, 2.2, 1.9, 1.6, 1.2, 0.9, 0.6],
                    1: [1.8, 2.1, 2.3, 2.3, 2.1, 1.7, 1.3, 1.0, 0.7],
                    2: [1.4, 1.7, 1.9, 2.0, 1.8, 1.5, 1.2, 0.9, 0.6],
                },
                "1 _ 3": {
                    0: [1.7, 1.9, 2.0, 1.8, 1.5, 1.2, 0.9, 0.7, 0.4],
                    1: [1.6, 1.9, 2.0, 2.1, 1.9, 1.6, 1.3, 0.9, 0.7],
                    2: [1.4, 1.8, 2.0, 2.1, 1.9, 1.6, 1.3, 1.0, 0.7],
                },
                "_ 2 3": {
                    0: [1.6, 1.7, 1.8, 1.6, 1.4, 1.1, 0.9, 0.6, 0.4],
                    1: [1.5, 1.7, 1.8, 1.7, 1.6, 1.3, 1.0, 0.8, 0.5],
                    2: [1.6, 2.0, 2.3, 2.3, 2.2, 1.8, 1.4, 1.0, 0.7],
                },
                "1 2 3": {
                    0: [2.4, 2.6, 2.6, 2.4, 2.0, 1.6, 1.2, 0.8, 0.6],
                    1: [2.6, 2.9, 3.1, 2.9, 2.6, 2.1, 1.6, 1.2, 0.8],
                    2: [2.5, 3.0, 3.3, 3.4, 3.1, 2.5, 2.0, 1.5, 1.0],
                },
            },
        },
        4: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.5, 0.7, 0.9, 1.1, 1.1, 1.1, 0.9, 0.7],
                    1: [0.3, 0.4, 0.5, 0.7, 0.8, 0.8, 0.7, 0.6, 0.5],
                    2: [0.2, 0.3, 0.4, 0.5, 0.5, 0.5, 0.5, 0.4, 0.3],
                },
                "1 _ _": {
                    0: [0.6, 0.8, 1.1, 1.4, 1.7, 1.8, 1.7, 1.5, 1.2],
                    1: [0.5, 0.7, 1.0, 1.2, 1.4, 1.5, 1.4, 1.2, 0.9],
                    2: [0.4, 0.5, 0.7, 0.9, 1.0, 1.0, 0.9, 0.7, 0.6],
                },
                "_ 2 _": {
                    0: [0.5, 0.7, 0.9, 1.2, 1.4, 1.5, 1.5, 1.3, 1.1],
                    1: [0.5, 0.7, 1.0, 1.2, 1.5, 1.5, 1.4, 1.2, 0.9],
                    2: [0.5, 0.7, 1.0, 1.2, 1.4, 1.4, 1.2, 1.0, 0.7],
                },
                "_ _ 3": {
                    0: [0.4, 0.6, 0.8, 1.0, 1.2, 1.3, 1.3, 1.2, 1.0],
                    1: [0.6, 0.9, 1.1, 1.4, 1.6, 1.6, 1.4, 1.2, 0.9],
                    2: [0.6, 0.9, 1.2, 1.4, 1.6, 1.6, 1.4, 1.1, 0.8],
                },
                "1 2 _": {
                    0: [0.7, 1.0, 1.4, 1.8, 2.1, 2.3, 2.3, 2.1, 1.8],
                    1: [0.8, 1.1, 1.5, 1.9, 2.3, 2.4, 2.3, 2.0, 1.6],
                    2: [0.7, 1.0, 1.4, 1.7, 2.0, 2.1, 1.9, 1.6, 1.2],
                },
                "1 _ 3": {
                    0: [0.5, 0.8, 1.0, 1.4, 1.7, 2.0, 2.1, 1.9, 1.7],
                    1: [0.8, 1.1, 1.4, 1.8, 2.1, 2.2, 2.1, 1.8, 1.5],
                    2: [0.8, 1.1, 1.5, 1.8, 2.1, 2.2, 2.0, 1.7, 1.3],
                },
                "_ 2 3": {
                    0: [0.5, 0.7, 1.0, 1.3, 1.6, 1.8, 1.8, 1.7, 1.5],
                    1: [0.6, 0.9, 1.2, 1.5, 1.7, 1.9, 1.9, 1.7, 1.4],
                    2: [0.9, 1.2, 1.6, 2.0, 2.4, 2.5, 2.3, 1.9, 1.5],
                },
                "1 2 3": {
                    0: [0.7, 1.0, 1.4, 1.8, 2.2, 2.6, 2.8, 2.7, 2.4],
                    1: [1.0, 1.4, 1.9, 2.4, 2.9, 3.1, 3.2, 2.9, 2.4],
                    2: [1.2, 1.7, 2.3, 2.9, 3.4, 3.6, 3.4, 2.9, 2.3],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 1.0, 1.1, 1.2, 1.1, 0.9, 0.6, 0.4, 0.3],
                    1: [0.5, 0.7, 0.8, 0.9, 0.8, 0.6, 0.5, 0.3, 0.2],
                    2: [0.3, 0.4, 0.5, 0.6, 0.5, 0.4, 0.3, 0.2, 0.2],
                },
                "1 _ _": {
                    0: [1.4, 1.7, 1.9, 1.9, 1.7, 1.3, 1.0, 0.7, 0.5],
                    1: [1.0, 1.3, 1.5, 1.6, 1.4, 1.1, 0.8, 0.6, 0.4],
                    2: [0.7, 0.8, 1.0, 1.1, 1.0, 0.8, 0.6, 0.4, 0.3],
                },
                "_ 2 _": {
                    0: [1.2, 1.4, 1.6, 1.6, 1.4, 1.1, 0.8, 0.5, 0.4],
                    1: [1.1, 1.3, 1.5, 1.6, 1.4, 1.2, 0.9, 0.6, 0.4],
                    2: [0.9, 1.1, 1.4, 1.5, 1.4, 1.1, 0.9, 0.6, 0.4],
                },
                "_ _ 3": {
                    0: [1.1, 1.3, 1.4, 1.4, 1.1, 0.9, 0.6, 0.4, 0.3],
                    1: [1.0, 1.3, 1.6, 1.7, 1.6, 1.3, 1.0, 0.7, 0.5],
                    2: [1.0, 1.3, 1.6, 1.7, 1.6, 1.3, 1.0, 0.7, 0.5],
                },
                "1 2 _": {
                    0: [2.0, 2.3, 2.5, 2.4, 2.0, 1.6, 1.1, 0.8, 0.5],
                    1: [1.8, 2.2, 2.5, 2.5, 2.2, 1.8, 1.3, 0.9, 0.6],
                    2: [1.4, 1.8, 2.1, 2.2, 2.0, 1.6, 1.2, 0.8, 0.6],
                },
                "1 _ 3": {
                    0: [1.8, 2.1, 2.1, 2.0, 1.6, 1.2, 0.9, 0.6, 0.4],
                    1: [1.7, 2.0, 2.2, 2.3, 2.1, 1.7, 1.3, 0.9, 0.6],
                    2: [1.5, 1.9, 2.2, 2.3, 2.1, 1.7, 1.3, 0.9, 0.6],
                },
                "_ 2 3": {
                    0: [1.7, 1.9, 1.9, 1.8, 1.5, 1.1, 0.8, 0.6, 0.4],
                    1: [1.6, 1.8, 2.0, 1.9, 1.7, 1.4, 1.0, 0.7, 0.5],
                    2: [1.7, 2.1, 2.5, 2.6, 2.3, 1.9, 1.4, 1.0, 0.7],
                },
                "1 2 3": {
                    0: [2.6, 2.8, 2.8, 2.6, 2.1, 1.6, 1.1, 0.8, 0.5],
                    1: [2.7, 3.2, 3.3, 3.2, 2.8, 2.2, 1.6, 1.1, 0.7],
                    2: [2.6, 3.2, 3.6, 3.7, 3.3, 2.6, 1.9, 1.4, 0.9],
                },
            },
        },
        5: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.5, 0.7, 1.0, 1.2, 1.3, 1.1, 0.9, 0.7],
                    1: [0.3, 0.4, 0.6, 0.7, 0.9, 0.9, 0.8, 0.6, 0.5],
                    2: [0.2, 0.3, 0.4, 0.5, 0.6, 0.6, 0.5, 0.4, 0.3],
                },
                "1 _ _": {
                    0: [0.5, 0.8, 1.1, 1.5, 1.9, 2.0, 1.9, 1.6, 1.2],
                    1: [0.5, 0.7, 1.0, 1.3, 1.6, 1.7, 1.5, 1.2, 0.9],
                    2: [0.3, 0.5, 0.7, 0.9, 1.1, 1.1, 1.0, 0.8, 0.6],
                },
                "_ 2 _": {
                    0: [0.4, 0.6, 0.9, 1.2, 1.5, 1.7, 1.6, 1.4, 1.1],
                    1: [0.5, 0.7, 1.0, 1.3, 1.6, 1.7, 1.5, 1.2, 0.9],
                    2: [0.5, 0.7, 1.0, 1.3, 1.6, 1.6, 1.3, 1.0, 0.7],
                },
                "_ _ 3": {
                    0: [0.3, 0.5, 0.7, 1.0, 1.3, 1.5, 1.5, 1.3, 1.1],
                    1: [0.6, 0.8, 1.1, 1.5, 1.8, 1.8, 1.5, 1.2, 0.9],
                    2: [0.6, 0.8, 1.2, 1.5, 1.8, 1.8, 1.5, 1.1, 0.8],
                },
                "1 2 _": {
                    0: [0.6, 0.9, 1.3, 1.8, 2.3, 2.6, 2.5, 2.3, 1.8],
                    1: [0.7, 1.1, 1.5, 2.0, 2.5, 2.7, 2.5, 2.1, 1.6],
                    2: [0.7, 1.0, 1.4, 1.8, 2.2, 2.3, 2.1, 1.6, 1.2],
                },
                "1 _ 3": {
                    0: [0.5, 0.7, 1.0, 1.4, 1.8, 2.2, 2.3, 2.1, 1.7],
                    1: [0.7, 1.0, 1.4, 1.9, 2.3, 2.4, 2.3, 1.9, 1.5],
                    2: [0.7, 1.1, 1.5, 1.9, 2.4, 2.5, 2.2, 1.7, 1.3],
                },
                "_ 2 3": {
                    0: [0.4, 0.7, 1.0, 1.3, 1.7, 1.9, 2.0, 1.9, 1.6],
                    1: [0.6, 0.8, 1.2, 1.5, 1.9, 2.1, 2.1, 1.8, 1.4],
                    2: [0.8, 1.1, 1.6, 2.1, 2.6, 2.8, 2.5, 2.0, 1.4],
                },
                "1 2 3": {
                    0: [0.6, 0.9, 1.3, 1.8, 2.4, 2.8, 3.0, 2.9, 2.5],
                    1: [0.9, 1.3, 1.9, 2.5, 3.1, 3.5, 3.5, 3.1, 2.5],
                    2: [1.1, 1.6, 2.2, 3.0, 3.7, 4.0, 3.7, 3.0, 2.3],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 1.1, 1.3, 1.3, 1.2, 0.9, 0.6, 0.4, 0.3],
                    1: [0.5, 0.7, 0.9, 1.0, 0.9, 0.7, 0.5, 0.3, 0.2],
                    2: [0.3, 0.4, 0.6, 0.6, 0.6, 0.4, 0.3, 0.2, 0.1],
                },
                "1 _ _": {
                    0: [1.4, 1.8, 2.1, 2.1, 1.8, 1.3, 0.9, 0.6, 0.4],
                    1: [1.1, 1.4, 1.7, 1.8, 1.5, 1.2, 0.8, 0.5, 0.3],
                    2: [0.6, 0.9, 1.1, 1.2, 1.1, 0.8, 0.6, 0.4, 0.2],
                },
                "_ 2 _": {
                    0: [1.2, 1.6, 1.8, 1.8, 1.5, 1.1, 0.7, 0.5, 0.3],
                    1: [1.1, 1.4, 1.7, 1.8, 1.6, 1.2, 0.8, 0.5, 0.3],
                    2: [0.8, 1.2, 1.5, 1.7, 1.6, 1.2, 0.8, 0.6, 0.4],
                },
                "_ _ 3": {
                    0: [1.2, 1.5, 1.6, 1.5, 1.2, 0.9, 0.6, 0.4, 0.2],
                    1: [1.0, 1.4, 1.7, 2.0, 1.8, 1.4, 1.0, 0.6, 0.4],
                    2: [0.9, 1.3, 1.7, 2.0, 1.9, 1.4, 1.0, 0.7, 0.4],
                },
                "1 2 _": {
                    0: [2.1, 2.5, 2.7, 2.6, 2.2, 1.6, 1.1, 0.7, 0.4],
                    1: [1.9, 2.4, 2.8, 2.8, 2.4, 1.8, 1.2, 0.8, 0.5],
                    2: [1.4, 1.9, 2.3, 2.5, 2.2, 1.6, 1.1, 0.8, 0.5],
                },
                "1 _ 3": {
                    0: [1.9, 2.3, 2.4, 2.2, 1.7, 1.2, 0.8, 0.5, 0.3],
                    1: [1.7, 2.2, 2.5, 2.6, 2.3, 1.7, 1.2, 0.8, 0.5],
                    2: [1.5, 2.0, 2.4, 2.6, 2.4, 1.8, 1.2, 0.8, 0.5],
                },
                "_ 2 3": {
                    0: [1.8, 2.1, 2.1, 2.0, 1.6, 1.1, 0.8, 0.5, 0.3],
                    1: [1.6, 2.0, 2.2, 2.1, 1.9, 1.4, 1.0, 0.6, 0.4],
                    2: [1.7, 2.3, 2.8, 3.0, 2.6, 1.9, 1.3, 0.9, 0.6],
                },
                "1 2 3": {
                    0: [2.8, 3.1, 3.1, 2.8, 2.2, 1.5, 1.0, 0.7, 0.4],
                    1: [2.9, 3.4, 3.7, 3.5, 3.0, 2.2, 1.5, 1.0, 0.6],
                    2: [2.7, 3.4, 4.0, 4.2, 3.6, 2.7, 1.8, 1.2, 0.8],
                },
            },
        },
        6: {
            "top": {
                "_ _ _": {
                    0: [0.3, 0.5, 0.7, 1.0, 1.3, 1.4, 1.3, 1.0, 0.7],
                    1: [0.2, 0.4, 0.5, 0.8, 1.0, 1.1, 0.9, 0.7, 0.4],
                    2: [0.2, 0.3, 0.4, 0.5, 0.7, 0.7, 0.5, 0.4, 0.2],
                },
                "1 _ _": {
                    0: [0.5, 0.7, 1.1, 1.6, 2.1, 2.3, 2.1, 1.7, 1.2],
                    1: [0.4, 0.6, 0.9, 1.3, 1.8, 1.9, 1.7, 1.3, 0.9],
                    2: [0.3, 0.5, 0.7, 1.0, 1.3, 1.3, 1.1, 0.8, 0.5],
                },
                "_ 2 _": {
                    0: [0.4, 0.6, 0.9, 1.3, 1.7, 1.9, 1.8, 1.5, 1.1],
                    1: [0.4, 0.6, 1.0, 1.4, 1.8, 2.0, 1.7, 1.3, 0.9],
                    2: [0.4, 0.7, 1.0, 1.4, 1.8, 1.8, 1.4, 1.0, 0.7],
                },
                "_ _ 3": {
                    0: [0.3, 0.5, 0.7, 1.0, 1.4, 1.7, 1.7, 1.4, 1.1],
                    1: [0.5, 0.8, 1.1, 1.6, 2.0, 2.1, 1.6, 1.3, 0.9],
                    2: [0.5, 0.8, 1.2, 1.6, 2.1, 2.1, 1.6, 1.1, 0.7],
                },
                "1 2 _": {
                    0: [0.5, 0.8, 1.3, 1.8, 2.5, 2.9, 2.8, 2.4, 1.9],
                    1: [0.6, 1.0, 1.5, 2.1, 2.8, 3.1, 2.8, 2.2, 1.6],
                    2: [0.6, 0.9, 1.3, 1.9, 2.5, 2.6, 2.3, 1.7, 1.1],
                },
                "1 _ 3": {
                    0: [0.4, 0.6, 0.9, 1.4, 1.9, 2.4, 2.6, 2.3, 1.8],
                    1: [0.6, 0.9, 1.4, 2.0, 2.6, 2.8, 2.5, 2.1, 1.5],
                    2: [0.6, 1.0, 1.4, 2.0, 2.7, 2.8, 2.4, 1.8, 1.2],
                },
                "_ 2 3": {
                    0: [0.4, 0.6, 0.9, 1.3, 1.8, 2.2, 2.3, 2.1, 1.7],
                    1: [0.5, 0.8, 1.1, 1.6, 2.1, 2.3, 2.3, 1.9, 1.5],
                    2: [0.7, 1.0, 1.6, 2.2, 2.9, 3.2, 2.7, 2.0, 1.4],
                },
                "1 2 3": {
                    0: [0.5, 0.8, 1.2, 1.8, 2.5, 3.1, 3.4, 3.2, 2.7],
                    1: [0.8, 1.2, 1.8, 2.6, 3.4, 3.9, 3.9, 3.3, 2.6],
                    2: [0.9, 1.4, 2.2, 3.1, 4.1, 4.5, 4.1, 3.2, 2.3],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 1.1, 1.4, 1.6, 1.3, 0.9, 0.6, 0.3, 0.2],
                    1: [0.5, 0.8, 1.0, 1.2, 1.0, 0.7, 0.4, 0.3, 0.2],
                    2: [0.3, 0.4, 0.6, 0.8, 0.7, 0.5, 0.3, 0.2, 0.1],
                },
                "1 _ _": {
                    0: [1.4, 1.9, 2.3, 2.4, 2.0, 1.3, 0.8, 0.5, 0.3],
                    1: [1.0, 1.5, 1.9, 2.1, 1.7, 1.1, 0.7, 0.4, 0.3],
                    2: [0.6, 0.9, 1.2, 1.5, 1.3, 0.8, 0.5, 0.3, 0.2],
                },
                "_ 2 _": {
                    0: [1.3, 1.7, 2.0, 2.0, 1.6, 1.1, 0.7, 0.4, 0.2],
                    1: [1.1, 1.5, 1.9, 2.1, 1.8, 1.2, 0.8, 0.5, 0.3],
                    2: [0.8, 1.2, 1.6, 2.0, 1.8, 1.2, 0.8, 0.5, 0.3],
                },
                "_ _ 3": {
                    0: [1.2, 1.6, 1.8, 1.7, 1.3, 0.8, 0.5, 0.3, 0.2],
                    1: [1.0, 1.4, 1.9, 2.3, 2.1, 1.4, 0.9, 0.5, 0.3],
                    2: [0.9, 1.3, 1.9, 2.4, 2.2, 1.4, 0.9, 0.6, 0.3],
                },
                "1 2 _": {
                    0: [2.2, 2.7, 3.1, 3.0, 2.3, 1.5, 0.9, 0.6, 0.3],
                    1: [1.9, 2.6, 3.1, 3.3, 2.7, 1.8, 1.1, 0.7, 0.4],
                    2: [1.4, 2.0, 2.6, 2.9, 2.5, 1.6, 1.0, 0.6, 0.4],
                },
                "1 _ 3": {
                    0: [2.0, 2.5, 2.7, 2.4, 1.7, 1.1, 0.7, 0.4, 0.2],
                    1: [1.8, 2.4, 2.8, 3.0, 2.6, 1.7, 1.1, 0.7, 0.4],
                    2: [1.4, 2.1, 2.7, 3.1, 2.7, 1.8, 1.1, 0.7, 0.4],
                },
                "_ 2 3": {
                    0: [1.9, 2.3, 2.4, 2.2, 1.7, 1.1, 0.7, 0.4, 0.2],
                    1: [1.7, 2.2, 2.5, 2.5, 2.1, 1.4, 0.9, 0.5, 0.3],
                    2: [1.6, 2.4, 3.1, 3.5, 2.9, 1.9, 1.2, 0.7, 0.4],
                },
                "1 2 3": {
                    0: [3.0, 3.5, 3.6, 3.1, 2.2, 1.4, 0.9, 0.5, 0.3],
                    1: [3.0, 3.8, 4.2, 4.0, 3.3, 2.2, 1.4, 0.8, 0.5],
                    2: [2.7, 3.7, 4.5, 4.9, 4.0, 2.6, 1.7, 1.0, 0.6],
                },
            },
        },
        7: {
            "top": {
                "_ _ _": {
                    0: [0.2, 0.4, 0.7, 1.0, 1.5, 1.7, 1.4, 1.0, 0.6],
                    1: [0.2, 0.3, 0.5, 0.8, 1.2, 1.3, 1.0, 0.6, 0.4],
                    2: [0.1, 0.2, 0.4, 0.5, 0.8, 0.8, 0.6, 0.3, 0.2],
                },
                "1 _ _": {
                    0: [0.4, 0.6, 1.0, 1.6, 2.4, 2.7, 2.3, 1.7, 1.2],
                    1: [0.3, 0.5, 0.9, 1.4, 2.0, 2.3, 1.8, 1.3, 0.8],
                    2: [0.2, 0.4, 0.6, 1.0, 1.5, 1.6, 1.2, 0.7, 0.4],
                },
                "_ 2 _": {
                    0: [0.3, 0.5, 0.8, 1.2, 1.9, 2.3, 2.0, 1.5, 1.1],
                    1: [0.3, 0.6, 0.9, 1.4, 2.1, 2.3, 1.8, 1.3, 0.8],
                    2: [0.3, 0.6, 0.9, 1.4, 2.1, 2.2, 1.5, 0.9, 0.6],
                },
                "_ _ 3": {
                    0: [0.2, 0.4, 0.6, 1.0, 1.5, 2.0, 1.9, 1.5, 1.1],
                    1: [0.4, 0.7, 1.1, 1.6, 2.4, 2.5, 1.8, 1.3, 0.8],
                    2: [0.4, 0.7, 1.1, 1.7, 2.5, 2.5, 1.7, 1.1, 0.6],
                },
                "1 2 _": {
                    0: [0.4, 0.7, 1.1, 1.8, 2.7, 3.4, 3.2, 2.6, 1.9],
                    1: [0.5, 0.8, 1.3, 2.1, 3.2, 3.6, 3.1, 2.3, 1.6],
                    2: [0.4, 0.8, 1.2, 1.9, 2.9, 3.2, 2.5, 1.7, 1.0],
                },
                "1 _ 3": {
                    0: [0.3, 0.5, 0.8, 1.3, 2.0, 2.8, 3.0, 2.5, 1.8],
                    1: [0.5, 0.8, 1.3, 2.0, 3.1, 3.3, 2.9, 2.2, 1.5],
                    2: [0.5, 0.8, 1.4, 2.1, 3.1, 3.4, 2.6, 1.7, 1.1],
                },
                "_ 2 3": {
                    0: [0.3, 0.5, 0.8, 1.3, 2.0, 2.5, 2.6, 2.3, 1.7],
                    1: [0.4, 0.7, 1.1, 1.6, 2.5, 2.8, 2.7, 2.1, 1.4],
                    2: [0.5, 0.9, 1.5, 2.3, 3.4, 3.9, 3.1, 2.0, 1.2],
                },
                "1 2 3": {
                    0: [0.4, 0.6, 1.1, 1.7, 2.6, 3.5, 3.9, 3.6, 2.8],
                    1: [0.6, 1.0, 1.6, 2.6, 3.9, 4.5, 4.4, 3.6, 2.6],
                    2: [0.7, 1.2, 2.0, 3.1, 4.7, 5.4, 4.5, 3.3, 2.1],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 1.2, 1.6, 1.9, 1.5, 0.8, 0.4, 0.2, 0.1],
                    1: [0.5, 0.8, 1.1, 1.4, 1.2, 0.6, 0.3, 0.2, 0.1],
                    2: [0.2, 0.4, 0.7, 1.0, 0.8, 0.4, 0.2, 0.1, 0.1],
                },
                "1 _ _": {
                    0: [1.4, 2.0, 2.6, 3.0, 2.3, 1.2, 0.7, 0.4, 0.2],
                    1: [1.0, 1.5, 2.1, 2.5, 2.0, 1.1, 0.6, 0.3, 0.2],
                    2: [0.5, 0.9, 1.4, 1.8, 1.5, 0.8, 0.4, 0.2, 0.1],
                },
                "_ 2 _": {
                    0: [1.3, 1.8, 2.3, 2.4, 1.8, 0.9, 0.5, 0.3, 0.1],
                    1: [1.0, 1.5, 2.1, 2.6, 2.1, 1.1, 0.6, 0.3, 0.2],
                    2: [0.7, 1.1, 1.8, 2.6, 2.2, 1.1, 0.7, 0.4, 0.2],
                },
                "_ _ 3": {
                    0: [1.3, 1.8, 2.2, 2.0, 1.5, 0.8, 0.4, 0.2, 0.1],
                    1: [1.0, 1.5, 2.1, 2.9, 2.5, 1.3, 0.7, 0.4, 0.2],
                    2: [0.8, 1.3, 2.0, 3.0, 2.6, 1.4, 0.8, 0.4, 0.2],
                },
                "1 2 _": {
                    0: [2.2, 3.0, 3.6, 3.5, 2.5, 1.3, 0.8, 0.4, 0.2],
                    1: [1.9, 2.7, 3.6, 4.0, 3.0, 1.6, 0.9, 0.5, 0.3],
                    2: [1.2, 2.0, 2.9, 3.6, 2.9, 1.5, 0.8, 0.5, 0.2],
                },
                "1 _ 3": {
                    0: [2.1, 2.8, 3.3, 2.8, 1.7, 0.9, 0.5, 0.3, 0.1],
                    1: [1.8, 2.6, 3.2, 3.7, 3.1, 1.6, 0.9, 0.5, 0.3],
                    2: [1.3, 2.1, 3.0, 3.8, 3.1, 1.6, 0.9, 0.5, 0.3],
                },
                "_ 2 3": {
                    0: [2.0, 2.6, 2.9, 2.6, 1.7, 0.9, 0.5, 0.3, 0.1],
                    1: [1.7, 2.4, 3.0, 3.0, 2.5, 1.3, 0.7, 0.4, 0.2],
                    2: [1.5, 2.4, 3.6, 4.3, 3.3, 1.7, 1.0, 0.5, 0.3],
                },
                "1 2 3": {
                    0: [3.3, 4.0, 4.1, 3.5, 2.3, 1.2, 0.7, 0.4, 0.2],
                    1: [3.1, 4.2, 4.9, 4.8, 3.7, 2.0, 1.1, 0.6, 0.3],
                    2: [2.6, 3.9, 5.2, 5.9, 4.5, 2.4, 1.3, 0.7, 0.4],
                },
            },
        },
        8: {
            "top": {
                "_ _ _": {
                    0: [0.2, 0.3, 0.6, 1.0, 1.9, 2.2, 1.5, 0.9, 0.6],
                    1: [0.1, 0.2, 0.4, 0.7, 1.4, 1.6, 1.0, 0.6, 0.3],
                    2: [0.1, 0.2, 0.3, 0.5, 1.0, 1.1, 0.6, 0.3, 0.1],
                },
                "1 _ _": {
                    0: [0.2, 0.4, 0.8, 1.5, 2.8, 3.4, 2.6, 1.7, 1.0],
                    1: [0.2, 0.4, 0.7, 1.3, 2.4, 2.9, 2.0, 1.2, 0.7],
                    2: [0.2, 0.3, 0.5, 1.0, 1.8, 2.1, 1.3, 0.7, 0.3],
                },
                "_ 2 _": {
                    0: [0.2, 0.4, 0.6, 1.1, 2.2, 2.8, 2.3, 1.6, 1.0],
                    1: [0.2, 0.4, 0.8, 1.3, 2.5, 2.9, 2.0, 1.2, 0.7],
                    2: [0.2, 0.4, 0.8, 1.4, 2.7, 2.8, 1.5, 0.8, 0.4],
                },
                "_ _ 3": {
                    0: [0.2, 0.3, 0.5, 0.9, 1.8, 2.4, 2.3, 1.6, 1.0],
                    1: [0.3, 0.5, 0.9, 1.6, 3.1, 3.2, 2.0, 1.3, 0.7],
                    2: [0.3, 0.5, 0.9, 1.6, 3.2, 3.3, 1.7, 0.9, 0.4],
                },
                "1 2 _": {
                    0: [0.3, 0.5, 0.9, 1.6, 3.1, 4.1, 3.7, 2.8, 1.8],
                    1: [0.3, 0.6, 1.1, 2.0, 3.7, 4.5, 3.5, 2.4, 1.4],
                    2: [0.3, 0.6, 1.0, 1.8, 3.5, 4.0, 2.7, 1.6, 0.8],
                },
                "1 _ 3": {
                    0: [0.2, 0.3, 0.6, 1.1, 2.1, 3.3, 3.6, 2.8, 1.8],
                    1: [0.3, 0.6, 1.1, 2.0, 3.8, 4.2, 3.3, 2.3, 1.4],
                    2: [0.3, 0.6, 1.1, 2.0, 3.8, 4.3, 2.8, 1.6, 0.8],
                },
                "_ 2 3": {
                    0: [0.2, 0.3, 0.6, 1.1, 2.1, 3.1, 3.2, 2.6, 1.7],
                    1: [0.3, 0.5, 0.9, 1.6, 3.0, 3.4, 3.2, 2.2, 1.3],
                    2: [0.3, 0.7, 1.2, 2.1, 4.0, 4.9, 3.5, 1.9, 1.0],
                },
                "1 2 3": {
                    0: [0.2, 0.4, 0.8, 1.5, 2.8, 4.1, 4.6, 4.0, 3.0],
                    1: [0.4, 0.7, 1.4, 2.4, 4.6, 5.6, 5.2, 3.9, 2.6],
                    2: [0.5, 0.9, 1.6, 2.9, 5.6, 6.8, 5.1, 3.3, 1.9],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.7, 1.1, 1.8, 2.5, 1.8, 0.6, 0.3, 0.1, 0.1],
                    1: [0.4, 0.7, 1.2, 1.9, 1.4, 0.5, 0.2, 0.1, 0.0],
                    2: [0.2, 0.4, 0.7, 1.3, 1.1, 0.3, 0.2, 0.1, 0.0],
                },
                "1 _ _": {
                    0: [1.3, 2.1, 3.1, 3.8, 2.6, 0.9, 0.4, 0.2, 0.1],
                    1: [0.8, 1.5, 2.4, 3.4, 2.4, 0.8, 0.4, 0.2, 0.1],
                    2: [0.4, 0.8, 1.6, 2.5, 1.8, 0.6, 0.3, 0.1, 0.1],
                },
                "_ 2 _": {
                    0: [1.2, 1.9, 2.7, 3.1, 2.0, 0.7, 0.3, 0.1, 0.1],
                    1: [0.8, 1.5, 2.4, 3.4, 2.5, 0.8, 0.4, 0.2, 0.1],
                    2: [0.5, 1.0, 1.9, 3.5, 2.8, 0.9, 0.4, 0.2, 0.1],
                },
                "_ _ 3": {
                    0: [1.2, 1.9, 2.7, 2.5, 1.7, 0.6, 0.3, 0.1, 0.1],
                    1: [0.9, 1.5, 2.4, 3.9, 3.2, 1.0, 0.5, 0.2, 0.1],
                    2: [0.5, 1.1, 2.1, 4.1, 3.4, 1.0, 0.5, 0.2, 0.1],
                },
                "1 2 _": {
                    0: [2.2, 3.3, 4.2, 4.4, 2.8, 0.9, 0.4, 0.2, 0.1],
                    1: [1.7, 2.9, 4.1, 5.1, 3.5, 1.1, 0.5, 0.3, 0.1],
                    2: [1.0, 2.0, 3.3, 4.7, 3.5, 1.1, 0.5, 0.2, 0.1],
                },
                "1 _ 3": {
                    0: [2.2, 3.2, 4.1, 3.3, 1.8, 0.6, 0.3, 0.1, 0.1],
                    1: [1.7, 2.7, 3.9, 4.9, 3.8, 1.2, 0.6, 0.3, 0.1],
                    2: [1.0, 2.0, 3.4, 5.1, 3.8, 1.2, 0.6, 0.3, 0.1],
                },
                "_ 2 3": {
                    0: [2.1, 3.0, 3.6, 3.3, 1.8, 0.6, 0.3, 0.1, 0.1],
                    1: [1.6, 2.6, 3.7, 4.0, 3.0, 0.9, 0.4, 0.2, 0.1],
                    2: [1.2, 2.3, 4.2, 5.8, 3.9, 1.3, 0.6, 0.3, 0.1],
                },
                "1 2 3": {
                    0: [3.5, 4.6, 5.0, 4.2, 2.2, 0.8, 0.4, 0.2, 0.1],
                    1: [3.1, 4.6, 5.9, 6.2, 4.4, 1.4, 0.7, 0.3, 0.1],
                    2: [2.3, 4.0, 6.1, 7.7, 5.3, 1.7, 0.8, 0.4, 0.2],
                },
            },
        },
        9: {
            "top": {
                "_ _ _": {
                    0: [0.1, 0.2, 0.3, 0.7, 2.4, 2.9, 1.6, 0.8, 0.4],
                    1: [0.1, 0.1, 0.3, 0.6, 1.9, 2.2, 1.0, 0.5, 0.2],
                    2: [0.0, 0.1, 0.2, 0.4, 1.4, 1.5, 0.5, 0.2, 0.1],
                },
                "1 _ _": {
                    0: [0.1, 0.2, 0.5, 1.1, 3.4, 4.6, 2.9, 1.6, 0.8],
                    1: [0.1, 0.2, 0.5, 1.0, 3.1, 3.9, 2.2, 1.0, 0.4],
                    2: [0.1, 0.2, 0.3, 0.7, 2.4, 2.9, 1.3, 0.4, 0.1],
                },
                "_ 2 _": {
                    0: [0.1, 0.2, 0.4, 0.8, 2.6, 3.7, 2.7, 1.5, 0.8],
                    1: [0.1, 0.2, 0.5, 1.0, 3.3, 4.0, 2.2, 1.0, 0.5],
                    2: [0.1, 0.2, 0.5, 1.1, 3.7, 4.0, 1.4, 0.5, 0.2],
                },
                "_ _ 3": {
                    0: [0.1, 0.2, 0.3, 0.7, 2.3, 3.1, 2.9, 1.6, 0.8],
                    1: [0.1, 0.3, 0.6, 1.2, 4.3, 4.4, 2.3, 1.1, 0.5],
                    2: [0.1, 0.3, 0.6, 1.3, 4.4, 4.6, 1.4, 0.5, 0.2],
                },
                "1 2 _": {
                    0: [0.1, 0.3, 0.6, 1.2, 3.6, 5.3, 4.4, 2.9, 1.6],
                    1: [0.1, 0.3, 0.7, 1.4, 4.6, 6.1, 4.0, 2.3, 1.1],
                    2: [0.1, 0.3, 0.7, 1.4, 4.5, 5.5, 2.9, 1.3, 0.4],
                },
                "1 _ 3": {
                    0: [0.1, 0.2, 0.4, 0.8, 2.3, 4.2, 4.6, 3.0, 1.7],
                    1: [0.1, 0.3, 0.7, 1.5, 5.0, 5.7, 4.0, 2.3, 1.1],
                    2: [0.2, 0.3, 0.7, 1.5, 5.0, 5.9, 2.9, 1.3, 0.4],
                },
                "_ 2 3": {
                    0: [0.1, 0.2, 0.4, 0.8, 2.4, 4.0, 4.0, 2.9, 1.6],
                    1: [0.1, 0.3, 0.6, 1.2, 3.9, 4.6, 3.9, 2.3, 1.1],
                    2: [0.2, 0.3, 0.7, 1.6, 5.1, 6.9, 3.9, 1.4, 0.5],
                },
                "1 2 3": {
                    0: [0.1, 0.2, 0.5, 1.0, 2.9, 5.2, 5.7, 4.6, 3.1],
                    1: [0.2, 0.4, 0.8, 1.8, 5.7, 7.3, 6.2, 4.2, 2.4],
                    2: [0.2, 0.5, 1.0, 2.1, 6.9, 9.1, 5.7, 3.1, 1.4],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.5, 1.0, 2.0, 3.6, 2.3, 0.0, 0.0, 0.0, 0.0],
                    1: [0.2, 0.6, 1.3, 2.8, 1.9, 0.0, 0.0, 0.0, 0.0],
                    2: [0.1, 0.2, 0.6, 1.9, 1.5, 0.0, 0.0, 0.0, 0.0],
                },
                "1 _ _": {
                    0: [1.0, 2.0, 3.6, 5.4, 3.1, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 1.3, 2.8, 4.8, 3.0, 0.0, 0.0, 0.0, 0.0],
                    2: [0.2, 0.5, 1.7, 3.7, 2.4, 0.0, 0.0, 0.0, 0.0],
                },
                "_ 2 _": {
                    0: [1.0, 1.9, 3.3, 4.3, 2.5, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 1.3, 2.7, 5.0, 3.2, 0.0, 0.0, 0.0, 0.0],
                    2: [0.2, 0.6, 1.8, 5.2, 3.9, 0.0, 0.0, 0.0, 0.0],
                },
                "_ _ 3": {
                    0: [1.1, 2.0, 3.6, 3.5, 2.1, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 1.4, 2.9, 5.8, 4.5, 0.0, 0.0, 0.0, 0.0],
                    2: [0.2, 0.7, 1.8, 6.1, 4.7, 0.0, 0.0, 0.0, 0.0],
                },
                "1 2 _": {
                    0: [2.0, 3.6, 5.2, 6.0, 3.2, 0.0, 0.0, 0.0, 0.0],
                    1: [1.3, 2.9, 4.8, 7.2, 4.3, 0.0, 0.0, 0.0, 0.0],
                    2: [0.6, 1.7, 3.7, 6.8, 4.4, 0.0, 0.0, 0.0, 0.0],
                },
                "1 _ 3": {
                    0: [2.1, 3.7, 5.5, 4.3, 2.1, 0.0, 0.0, 0.0, 0.0],
                    1: [1.4, 2.9, 4.9, 7.1, 5.0, 0.0, 0.0, 0.0, 0.0],
                    2: [0.6, 1.7, 3.7, 7.4, 5.0, 0.0, 0.0, 0.0, 0.0],
                },
                "_ 2 3": {
                    0: [2.0, 3.5, 4.7, 4.3, 2.0, 0.0, 0.0, 0.0, 0.0],
                    1: [1.4, 2.8, 4.8, 5.7, 4.0, 0.0, 0.0, 0.0, 0.0],
                    2: [0.7, 1.8, 5.1, 8.4, 4.7, 0.0, 0.0, 0.0, 0.0],
                },
                "1 2 3": {
                    0: [3.7, 5.4, 6.4, 5.3, 2.4, 0.0, 0.0, 0.0, 0.0],
                    1: [3.0, 5.1, 7.3, 8.6, 5.4, 0.0, 0.0, 0.0, 0.0],
                    2: [1.8, 3.9, 7.0, 10.9, 6.4, 0.0, 0.0, 0.0, 0.0],
                },
            },
        },
    }


    def __init__(self, *args, **kwargs):
        xbmc.log("MLB Monitor init")
        self.monitor = xbmc.Monitor()

    # override the onSettingsChanged method to detect if a new MLB monitor has started (so we can close this one)
    def onSettingsChanged(self):
        xbmc.log("MLB Monitor detected settings changed")
        if self.mlb_monitor_started != '':
            settings = xbmcaddon.Addon(id='plugin.video.mlbtv')
            new_mlb_monitor_started = str(settings.getSetting(id="mlb_monitor_started"))
            if new_mlb_monitor_started != '' and self.mlb_monitor_started != new_mlb_monitor_started:
                xbmc.log("MLB Monitor from " + self.mlb_monitor_started + " closing due to another monitor starting on " + new_mlb_monitor_started)
                self.mlb_monitor_started = ''
            # also update skip adjust values
            self.skip_adjust_start = int(settings.getSetting(id="skip_adjust_start"))
            self.skip_adjust_end = int(settings.getSetting(id="skip_adjust_end"))
            # also update Stream Finder settings
            self.stream_finder_settings = json.loads(settings.getSetting(id="stream_finder_settings"))

    def get_playing_file(self, player):
        try:
            return player.getPlayingFile()
        except:
            return ''

    def wait_for_stream(self, game_pk):
        monitor_name = 'Wait for stream monitor for ' + game_pk
        self.stream_started = False
        stream_start_tries = 10

        # initialize player to monitor playing file
        player = xbmc.Player()

        while not self.monitor.abortRequested():
            if self.monitor.waitForAbort(1):
                xbmc.log(monitor_name + " aborting")
                break
            elif xbmc.getCondVisibility("Player.HasMedia") and self.mlb_monitor_file != self.get_playing_file(player):
                xbmc.log(monitor_name + ' detected stream start')
                self.stream_started = True
                self.mlb_monitor_file = self.get_playing_file(player)
                # just for fun, we can log our stream duration, to compare it against skip time detected
                try:
                    total_stream_time = player.getTotalTime()
                    xbmc.log(monitor_name + ' total stream time ' + str(timedelta(seconds=total_stream_time)))
                except:
                    pass
                break
            else:
                xbmc.log(monitor_name + " waiting for stream to start")
                stream_start_tries -= 1
                if stream_start_tries < 1:
                    xbmc.log(monitor_name + " stopping due to stream not starting")
                    break

        return self.stream_started


    def start_overlay(self, game_pk):
        monitor_name = 'Overlay monitor for ' + game_pk
        # use local stream_started flag, so as not to interfere with subsequent monitors
        stream_started = False
        self.window = xbmcgui.Window(12005)

        # initialize player to monitor playing file
        player = xbmc.Player()

        # wait an extra 2 seconds, to get the correct window size
        #xbmc.sleep(2000)
        # Bally ticker is size 640x42 at coordinates 640,654 within a 1280x720 video frame
        # we need to calulate that size/position relative to Kodi fullscreen video player window size
        self.window = xbmcgui.Window(12005)
        w = self.window.getWidth()
        h = self.window.getHeight()
        vh = 0.5625 * w
        ox = int(w / 2)
        oy = int(((h - vh) / 2) + (vh * (654/720)))
        ow = ox
        oh = int(0.0328125 * w)
        # for debugging overlay position and size, if necessary
        #xbmc.log(monitor_name + " overlay position " + str(ox) + ":" + str(oy) + ", size " + str(ow) + "x" + str(oh) + " within " + str(w) + "x" + str(h) + " window")
        self.overlay = xbmcgui.ControlImage(ox, oy, ow, oh, BLACK_IMAGE)
        self.window.addControl(self.overlay)
        xbmc.log(monitor_name + " overlay started")

    def stop_overlay(self, monitor_name):
        if self.window is not None and self.overlay is not None:
            try:
                self.window.removeControl(self.overlay)
            except:
                pass
            self.window = None
            self.overlay = None
            xbmc.log(monitor_name + ' overlay stopped')

    def stop_captions(self, game_pk):
        monitor_name = 'Captions monitor for ' + game_pk

        # initialize player
        player = xbmc.Player()

        player.showSubtitles(False)
        xbmc.log(monitor_name + " captions disabled")

    def game_monitor(self, skip_type, game_pk, broadcast_start_timestamp, stream_url, is_live, start_inning, start_inning_half, milb=False):
        xbmc.log("Game monitor for " + game_pk + " starting")

        self.mlb_monitor_started = str(datetime.now())
        settings.setSetting(id='mlb_monitor_started', value=self.mlb_monitor_started)

        # skip monitor
        if (skip_type > 0 or start_inning > 0) and broadcast_start_timestamp is not None:
            monitor_name = 'Skip'
            if self.overlay is not None:
                monitor_name += ' and Overlay'
            # get initial skip adjust values
            self.skip_adjust_start = int(settings.getSetting(id="skip_adjust_start"))
            self.skip_adjust_end = int(settings.getSetting(id="skip_adjust_end"))
        # overlay only monitor
        else:
            monitor_name = 'Overlay'

        monitor_name += ' monitor for ' + game_pk
        xbmc.log(monitor_name + ' started at ' + self.mlb_monitor_started)

        # initialize player to monitor play time and/or playing file
        player = xbmc.Player()

        # skip monitor, if necessary
        if (skip_type > 0 or start_inning > 0) and broadcast_start_timestamp is not None:
            last_time = None

            # fetch skip markers
            self.skip_to_players = None
            skip_markers, self.skip_to_players = self.get_skip_markers(skip_type, game_pk, broadcast_start_timestamp, monitor_name, self.skip_to_players, stream_url, 0, start_inning, start_inning_half, milb)
            xbmc.log(monitor_name + ' skip markers : ' + str(skip_markers))

            while not self.monitor.abortRequested():
                if self.monitor.waitForAbort(1):
                    xbmc.log(monitor_name + " aborting")
                    self.stop_overlay(monitor_name)
                    break
                elif len(skip_markers) == 0:
                    xbmc.log(monitor_name + " closing due to no more skip markers")
                    break
                elif self.stream_started == True and (not xbmc.getCondVisibility("Player.HasMedia") or (self.mlb_monitor_file != self.get_playing_file(player))):
                    xbmc.log(monitor_name + " closing due to stream stopped or changed")
                    self.stop_overlay(monitor_name)
                    break
                elif self.mlb_monitor_started == '':
                    xbmc.log(monitor_name + " closing due to reset")
                    self.stop_overlay(monitor_name)
                    break
                elif xbmc.getCondVisibility("Player.HasMedia"):
                    current_time = player.getTime()
                    # make sure we're not paused, and current time is valid (less than 10 hours) -- sometimes Kodi was returning a crazy large current time as the stream was starting
                    if current_time > 0 and current_time != last_time and current_time < 36000:
                        last_time = current_time
                        if skip_markers[0][0] > 0:
                            current_break_start = skip_markers[0][0] + self.skip_adjust_end
                        else:
                            current_break_start = skip_markers[0][0]
                        current_break_end = skip_markers[0][1] + self.skip_adjust_start
                        # remove any past skip markers so user can seek backward freely
                        while len(skip_markers) > 0 and current_time > current_break_end:
                            xbmc.log(monitor_name + " removed skip marker at " + str(current_break_end) + ", before current time " + str(current_time))
                            skip_markers.pop(0)
                            current_break_end = skip_markers[0][1] + self.skip_adjust_start
                        # seek to end of break if we fall within skip marker range, then remove marker so user can seek backward freely
                        if len(skip_markers) > 0 and current_time >= current_break_start and current_time < current_break_end:
                            xbmc.log(monitor_name + " processed skip marker at " + str(current_break_end))
                            player.seekTime(current_break_end)
                            skip_markers.pop(0)
                            # since we just processed a skip marker, we can delay further processing a little bit
                            xbmc.sleep(2000)
                        # if we've run out of skip markers and it's a live event and we're skipping things, check for more
                        if len(skip_markers) == 0 and is_live == True and skip_type > 0:
                            # refresh current time, and look ahead slightly
                            current_time = player.getTime() + 10
                            xbmc.log(monitor_name + ' refreshing skip markers from ' + str(current_time))
                            skip_markers, self.skip_to_players = self.get_skip_markers(skip_type, game_pk, broadcast_start_timestamp, monitor_name, self.skip_to_players, stream_url, current_time, milb)
                            xbmc.log(monitor_name + ' refreshed skip markers : ' + str(skip_markers))

        # continue monitoring if overlay is still active
        if self.overlay is not None:
            monitor_name = 'Overlay monitor for ' + game_pk
            while not self.monitor.abortRequested():
                if self.monitor.waitForAbort(1):
                    xbmc.log(monitor_name + " overlay aborting")
                    break
                elif self.stream_started == True and (not xbmc.getCondVisibility("Player.HasMedia") or (self.mlb_monitor_file != self.get_playing_file(player))):
                    xbmc.log(monitor_name + " overlay closing due to stream stopped or changed")
                    break
                elif self.mlb_monitor_started == '':
                    xbmc.log(monitor_name + " overlay closing due to reset")
                    break

        # stop overlay if necessary
        self.stop_overlay(monitor_name)

        xbmc.log(monitor_name + " closed")


    # get the gameday data, which contains the event timestamps
    def get_gameday_data(self, game_pk, monitor_name):
        xbmc.log(monitor_name + ' getting gameday data')

        url = API_URL + '/api/v1.1/game/' + game_pk + '/feed/live'
        headers = {
            'User-agent': UA_PC,
            'Origin': 'https://www.mlb.com',
            'Accept-Encoding': 'gzip, deflate, br',
            'Content-type': 'application/json'
        }
        r = requests.get(url, headers=headers, verify=self.verify)
        json_source = r.json()
        return json_source


    # get playlist
    def get_playlist(self, stream_url, monitor_name):
        xbmc.log(monitor_name + ' getting playlist')

        headers = {
            'User-agent': UA_PC,
            'Origin': 'https://www.mlb.com',
            'Accept-Encoding': 'gzip, deflate, br',
            'Content-type': 'application/json'
        }
        r = requests.get(stream_url, headers=headers, verify=self.verify)
        text_source = r.text
        line_array = text_source.splitlines()
        return line_array


    # calculate skip markers from gameday events
    def get_skip_markers(self, skip_type, game_pk, broadcast_start_timestamp, monitor_name, skip_to_players, stream_url, current_time=0, start_inning=0, start_inning_half='top', milb=False):
        xbmc.log(monitor_name + ' getting skip markers for skip type ' + str(skip_type))
        if current_time > 0:
            xbmc.log(monitor_name + ' searching beyond ' + str(current_time))

        # initialize our list of skip times
        skip_markers = []

        json_source = self.get_gameday_data(game_pk, monitor_name)

        settings = xbmcaddon.Addon(id='plugin.video.mlbtv')

        # calculate total skip time (for fun)
        total_skip_time = 0
        
        event_start_padding = self.EVENT_START_PADDING
        pitch_end_padding = self.PITCH_END_PADDING
        action_end_padding = self.ACTION_END_PADDING
        #extra padding for MLB games (2025)
        if milb is False:
        	event_start_padding += self.MLB_PADDING
        	pitch_end_padding += self.MLB_PADDING
        	action_end_padding += self.MLB_PADDING

        # make sure we have play data
        if 'liveData' in json_source and 'plays' in json_source['liveData'] and 'allPlays' in json_source['liveData']['plays']:
            # assume the game starts in a break
            break_start = 0

            # keep track of inning, for skipping inning breaks
            previous_inning = 0
            previous_inning_half = None

            # make sure start inning is valid
            if start_inning > 0:
                last_play_index = len(json_source['liveData']['plays']['allPlays']) - 1
                final_inning = json_source['liveData']['plays']['allPlays'][last_play_index]['about']['inning']
                if start_inning >= final_inning:
                    if start_inning > final_inning:
                        start_inning = final_inning
                    final_inning_half = json_source['liveData']['plays']['allPlays'][last_play_index]['about']['halfInning']
                    if start_inning_half == 'bottom' and final_inning_half == 'top':
                        start_inning_half = final_inning_half

            # if skip_type is for specific batters or pitchers, present another dialog to select player name(s)
            if skip_type == 4 and skip_to_players is None:
                xbmc.log(monitor_name + ' prompting for player selection')
                skip_to_players = []
                all_batters = []
                all_pitchers = []
                for play in json_source['liveData']['plays']['allPlays']:
                    current_inning = play['about']['inning']
                    current_inning_half = play['about']['halfInning']
                    # make sure we're past our start inning
                    if current_inning > start_inning or (current_inning == start_inning and (current_inning_half == start_inning_half or current_inning_half == 'bottom')):
                        if 'matchup' in play:
                            if 'batter' in play['matchup'] and 'fullName' in play['matchup']['batter'] and play['matchup']['batter']['fullName'] not in all_batters:
                                all_batters.append(play['matchup']['batter']['fullName'])
                            if 'pitcher' in play['matchup'] and 'fullName' in play['matchup']['pitcher'] and play['matchup']['pitcher']['fullName'] not in all_pitchers and play['matchup']['pitcher']['fullName'] not in all_batters:
                                all_pitchers.append(play['matchup']['pitcher']['fullName'])
                all_players = all_batters + all_pitchers
                player_index = 0
                while player_index > -1:
                    dialog = xbmcgui.Dialog()
                    player_index = dialog.select(LOCAL_STRING(30422), all_players)
                    if player_index > -1:
                        xbmc.log(monitor_name + ' specified player ' + all_players[player_index])
                        skip_to_players.append(all_players[player_index])
                        all_players.pop(player_index)

            # loop through all plays
            for play in json_source['liveData']['plays']['allPlays']:
                # exit loop after found inning, if not skipping any breaks
                if skip_type == 0 and len(skip_markers) == 1:
                    break
                current_inning = play['about']['inning']
                current_inning_half = play['about']['halfInning']
                # make sure we're past our start inning
                if current_inning > start_inning or (current_inning == start_inning and (current_inning_half == start_inning_half or current_inning_half == 'bottom')):
                    # skip commercial breaks by examining a variant playlist for insertion tags
                    if skip_type == 1:
                        # finish initial inning skip, if necessary
                        break_end = 0
                        if start_inning > 0:
                            # loop through events within the play
                            for playEvent in play['playEvents']:
                                # ignore break types when finding starting inning
                                if 'event' in playEvent['details'] and playEvent['details']['event'] in self.BREAK_TYPES:
                                    continue
                                else:
                                    break_end = (parse(playEvent['startTime']) - broadcast_start_timestamp).total_seconds() + event_start_padding
                                    xbmc.log(monitor_name + ' finishing initial inning skip at ' + str(break_end))
                                    skip_markers.append([break_start, break_end])
                                    total_skip_time += break_end - break_start
                                    break

                        # look for variant playlist
                        variant_url = stream_url.replace('.m3u8', '_5600K.m3u8')
                        # remove proxy prefix/suffix if necessary
                        if variant_url.startswith('http://127.0.0.1:'):
                            prefix_list = variant_url.split('/', 3)
                            suffix_list = prefix_list[len(prefix_list)-1].split('?')
                            variant_url = suffix_list[0]
                        xbmc.log(monitor_name + ' fetching playlist at ' + variant_url)
                        line_array = self.get_playlist(variant_url, monitor_name)
                        segment_length = 0
                        playlist_position = 0
                        break_start = None
                        for line in line_array:
                            if line.startswith('#EXTINF:'):
                                segment_length = float(line.split(':')[1][:-1])
                            elif line.startswith('#EXT-OATCLS-SCTE35:') and break_start is None and playlist_position > break_end:
                                break_start = playlist_position
                                xbmc.log(monitor_name + ' found commercial break starting at ' + str(playlist_position))
                            elif '#EXT-X-CUE-IN' in line and break_start is not None:
                                break_end = playlist_position
                                if break_end > current_time:
                                    xbmc.log(monitor_name + ' found commercial break ending at ' + str(playlist_position))
                                    skip_markers.append([break_start, break_end])
                                    total_skip_time += break_end - break_start
                                break_start = None
                                break_end = 0
                            elif not line.startswith('#'):
                                playlist_position += segment_length
                        break

                    # check for player, if specified
                    if skip_type == 4 and skip_to_players is not None and len(skip_to_players) > 0:
                        skip_to_player_found = False
                        for player in skip_to_players:
                            if 'matchup' in play and 'batter' in play['matchup'] and 'fullName' in play['matchup']['batter'] and 'pitcher' in play['matchup'] and 'fullName' in play['matchup']['pitcher'] and (player == play['matchup']['batter']['fullName'] or player == play['matchup']['pitcher']['fullName']):
                                xbmc.log(monitor_name + ' found specified player ' + player + ' in ' + play['matchup']['pitcher']['fullName'] + ' vs ' + play['matchup']['batter']['fullName'])
                                skip_to_player_found = True
                                break
                        if skip_to_player_found is False:
                            if 'matchup' in play and 'batter' in play['matchup'] and 'fullName' in play['matchup']['batter'] and 'pitcher' in play['matchup'] and 'fullName' in play['matchup']['pitcher']:
                                xbmc.log(monitor_name + ' did not find specified player in ' + play['matchup']['pitcher']['fullName'] + ' vs ' + play['matchup']['batter']['fullName'])
                            else:
                                xbmc.log(monitor_name + ' did not find specified player')
                            continue

                    # loop through events within each play
                    for index, playEvent in enumerate(play['playEvents']):
                        # use action end padding by default, but we'll adjust this to pitch end padding as necessary for break types 3 and 4
                        this_event_end_padding = action_end_padding
                        # always exclude break types
                        if 'event' in playEvent['details'] and playEvent['details']['event'] in self.BREAK_TYPES:
                            # if we're in the process of skipping all breaks, treat the first break type we find as another inning break
                            if skip_type == 2 and previous_inning > 0:
                                break_start = (parse(playEvent['startTime']) - broadcast_start_timestamp).total_seconds() + action_end_padding
                                previous_inning = 0
                            continue
                        else:
                            action_index = None
                            # skip type 2 (all breaks) will look at all plays with an endTime
                            if skip_type == 2 and 'endTime' in playEvent:
                                action_index = index
                            # skip type 3 (idle time) and 4 (specific batters/pitchers) will look at all non-idle plays with an endTime
                            elif skip_type <= 4 and 'endTime' in playEvent and ('details' not in playEvent or 'description' not in playEvent['details'] or not any(substring in playEvent['details']['description'] for substring in self.IDLE_TYPES)):
                                action_index = index
                                # use pitch end padding for non-action plays
                                if index < (len(play['playEvents'])-1) and ('details' not in playEvent or 'event' not in playEvent['details'] or not any(substring in playEvent['details']['event'] for substring in self.ACTION_TYPES)):
                                    this_event_end_padding = pitch_end_padding
                            elif skip_type == 5:
                                # skip type 5 excludes non-action pitches (events that aren't last in the at-bat and don't fall under action types)
                                if index < (len(play['playEvents'])-1) and ('details' not in playEvent or 'event' not in playEvent['details'] or not any(substring in playEvent['details']['event'] for substring in self.ACTION_TYPES)):
                                    continue
                                else:
                                    # if the action is associated with another play or the event doesn't have an end time, use the previous event instead
                                    if ('actionPlayId' in playEvent or 'endTime' not in playEvent) and index > 0:
                                        action_index = index - 1
                                    else:
                                        action_index = index
                            if action_index is None:
                                continue
                            else:
                                break_end = (parse(play['playEvents'][action_index]['startTime']) - broadcast_start_timestamp).total_seconds() + event_start_padding

                                # attempt to fix erroneous timestamps, like NYY-SEA 2022-08-09, bottom 11
                                if break_end < break_start:
                                    xbmc.log(monitor_name + ' adjusting break start for ' + str(break_start) + ', because it is less than ' + str(break_end))
                                    break_start = break_end - 10

                                    prev_break = len(skip_markers) - 1
                                    if prev_break > 0 and break_start < skip_markers[prev_break][1] and skip_markers[prev_break][0] < (skip_markers[prev_break][1] - 40):
                                        xbmc.log(monitor_name + ' adjusting previous break end for ' + str(skip_markers[prev_break][1]) + ', because it is greater than ' + str(break_start) + ' and more than 40 seconds greater than ' + str(skip_markers[prev_break][0]))
                                        skip_markers[prev_break][1] = skip_markers[prev_break][0] + 30

                                # if the break end should be greater than the current playback time
                                # and the break duration should be greater than than our specified minimum
                                # and if skip type is not 2 (all breaks) or the inning has changed
                                # then we'll add the skip marker
                                # otherwise we'll ignore it and move on to the next one
                                if break_end > current_time and (break_end - break_start) >= self.MINIMUM_BREAK_DURATION and (skip_type != 2 or current_inning != previous_inning or current_inning_half != previous_inning_half):
                                    skip_markers.append([break_start, break_end])
                                    total_skip_time += break_end - break_start
                                    previous_inning = current_inning
                                    previous_inning_half = current_inning_half
                                    # exit loop after found inning, if not skipping breaks
                                    if skip_type == 0:
                                        break
                                break_start = (parse(play['playEvents'][action_index]['endTime']) - broadcast_start_timestamp).total_seconds() + this_event_end_padding
                                # add extra padding for overturned review plays
                                if 'reviewDetails' in play:
                                    isOverturned = play['reviewDetails']['isOverturned']
                                    if isOverturned == False and 'additionalReviews' in play['reviewDetails'] and len(play['reviewDetails']['additionalReviews']) > 0:
                                        for additionalReview in play['reviewDetails']['additionalReviews']:
                                            isOverturned = additionalReview['isOverturned']
                                            if isOverturned == True:
                                                break
                                    if isOverturned == True:
                                        break_start += 40

        xbmc.log(monitor_name + ' found ' + str(timedelta(seconds=total_skip_time)) + ' total skip time')

        return skip_markers, skip_to_players


    def getCurrentGame(self, game, team_data):
        return team_data[str(game['away_team_id'])]['teamName'] + ' @ ' + team_data[str(game['home_team_id'])]['teamName']


    def setCurrentGame(self, cur_game_pk, game, team_data, monitor_name, priority):
        if cur_game_pk != game['game_pk']:
            xbmc.log(monitor_name + ' set current game to ' + self.getCurrentGame(game, team_data) + ' due to ' + priority['type'] + ' ' + priority['data'])
        return game['game_pk'], game['batter']
        
    
    def finder_monitor(self, blackouts):
        xbmc.log("Finder monitor starting")

        self.mlb_monitor_started = str(datetime.now())
        settings.setSetting(id='mlb_monitor_started', value=self.mlb_monitor_started)
        monitor_name = 'Finder monitor from ' + self.mlb_monitor_started
        xbmc.log(monitor_name + ' started')
    
        self.stream_finder_settings = json.loads(settings.getSetting(id="stream_finder_settings"))
        
        html_source = self.get_stream_finder_data()
        
        team_data = json.loads(re.findall(r'var team_data\s*=\s*([{][^;]+);', html_source, re.MULTILINE)[0])
        
        posPlayers = json.loads(re.findall(r'var posPlayers\s*=\s*([{][^}]+[}])', html_source, re.MULTILINE)[0])
        
        games_CLI = json.loads(re.findall(r'var games_CLI\s+=\s+([{][^}]*[}])', html_source, re.MULTILINE)[0])
        
        LI_table = json.loads(re.findall(r'var LI\s+=\s+([{][^;]+);', html_source, re.MULTILINE)[0])
        
        # initialize player to monitor video title
        player = xbmc.Player()
        video_title = LOCAL_STRING(30444) + ' ' + self.mlb_monitor_started

        game_refresh_sec = 5
        stream_refresh_sec = 1
        # check games every `refresh_sec` but return data from `delay_sec` ago to account for stream delay/buffering
        refresh_sec = game_refresh_sec

        cur_game_pk = None
        cur_batter = None
        cur_game_high_LI_flag = 'N'
        cur_game_high_LI = -3
        cur_pitchers = {}
        pitching_changes  = {}

        u_params = '&name=' + video_title + '&description=' + urllib.quote_plus(LOCAL_STRING(30445)) + '&icon=' + urllib.quote_plus(STREAM_FINDER_ICON) + '&fanart=' + urllib.quote_plus(FANART) + '&gamechanger=True'

        today = localToEastern()
        date_string = today

        while not self.monitor.abortRequested():
            if refresh_sec != stream_refresh_sec:
                games = self.get_stream_finder_games()
                
                if len(games) == 0:
                    continue
                
                active_games = []
                
                same_batter = 'N'
                
                now = datetime.now()
                
                for game in games:
                    run1 = None
                    run2 = None
                    run3 = None
                    
                    if str(game['gamePk']) in blackouts:
                        continue
                    
                    if str(game['teams']['away']['team']['id']) not in team_data or str(game['teams']['home']['team']['id']) not in team_data:
                        continue
                    
                    if game['linescore']['outs'] == 3:
                        continue
                    
                    if 'inningState' in game['linescore'] and game['linescore']['inningState'] not in ['Top', 'Bottom']:
                        continue
                        
                    if 'status' not in game or game['status'] != 'active':
                        continue
                          
                    # Goes through ignore list to see if game should be skipped
                    if 'ignore' in self.stream_finder_settings:
                        ignore = False
                        for ignore_team in self.stream_finder_settings['ignore']:
                            if ignore_team == str(game['teams']['away']['team']['id']) or ignore_team == str(game['teams']['home']['team']['id']):
                                ignore = True
                                break
                        if ignore == True:
                            continue
                        
                    gamePk = str(game['gamePk'])
                    if gamePk in pitching_changes:
                        if pitching_changes[gamePk] > now:
                            xbmc.log(monitor_name + ' pitching change in progress in game ' + gamePk)
                            continue
                        else:
                            xbmc.log(monitor_name + ' pitching change complete in game ' + gamePk)
                            del pitching_changes[gamePk]
                            
                    pitching_team_id = None
                    if game['linescore']['half'] == 1:
                        pitching_team_id = str(game['teams']['home']['team']['id'])
                    elif game['linescore']['half'] == 2:
                        pitching_team_id == str(game['teams']['away']['team']['id'])
                    
                    if pitching_team_id is not None:
                        if gamePk not in cur_pitchers:
                            cur_pitchers[gamePk] = {}
                        if pitching_team_id not in cur_pitchers[gamePk]:
                            cur_pitchers[gamePk][pitching_team_id] = game['linescore']['defense']['pitcher']['id']
                        else:
                            if game['linescore']['defense']['pitcher']['id'] != cur_pitchers[gamePk][pitching_team_id]:
                                xbmc.log(monitor_name + ' pitching change begun in game ' + gamePk + ' for ' + team_data[pitching_team_id]['teamName'])
                                pitching_changes[gamePk] = now + timedelta(seconds=114)
                                cur_pitchers[gamePk][pitching_team_id] = game['linescore']['defense']['pitcher']['id']
                                continue
                        
                    try:
                        play_LI = float(LI_table[str(game['linescore']['InnBaseOut'])][str(game['linescore']['RunDiff'])])
                    except:
                        play_LI = 0.0
                            
                    home_team = str(game['teams']['home']['team']['id'])
                    if 'include_CLI' in self.stream_finder_settings and self.stream_finder_settings['include_CLI'] == 'Y' and home_team in games_CLI and games_CLI[home_team] != '':
                        CLI = float(games_CLI[home_team])
                        LI = play_LI * CLI
                    else:
                        LI = play_LI   
                               
                    # Baserunners
                    if game['linescore']['BaseSit'] > 1:
                        if 'first' in game['linescore']['offense']:
                            run1 = game['linescore']['offense']['first']['id']
                        if 'second' in game['linescore']['offense']:
                            run2 = game['linescore']['offense']['second']['id']
                        if 'third' in game['linescore']['offense']:
                            run3 = game['linescore']['offense']['third']['id']
                                
                    # Flag to stay on current game if same batter is still at bat
                    if game['gamePk'] == cur_game_pk and game['linescore']['offense']['batter']['id'] == cur_batter and game['linescore']['outs'] < 3 and (('balls' in game['linescore'] and game['linescore']['balls'] not in [0,4]) or ('strikes' in game['linescore'] and game['linescore']['strikes'] not in [0,3])):
                        same_batter = 'Y'
                              
                    # If this is the current game showing
                    if game['gamePk'] == cur_game_pk:
                        cur_game_high_LI = LI
                        # Grabs that games LI to compare to the new high lev game
                        cur_batter = game['linescore']['offense']['batter']['id']
                        
                    # Places data into array
                    active_games.append({
                      'LI': LI,
                      'outs': game['linescore']['outs'],
                      'game_pk': game['gamePk'],
                      'away_team_id': game['teams']['away']['team']['id'],
                      'home_team_id': game['teams']['home']['team']['id'],
                      'batter': game['linescore']['offense']['batter']['id'],
                      'pitcher': game['linescore']['defense']['pitcher']['id'],
                      'ondeck': game['linescore']['offense']['onDeck']['id'],
                      'run1': run1,
                      'run2': run2,
                      'run3': run3,
                      'inning': game['linescore']['currentInning'],
                      'half': game['linescore']['half'],
                      'away_hits': game['linescore']['teams']['away']['hits'],
                      'home_hits': game['linescore']['teams']['home']['hits'],
                      'away_runs': game['linescore']['teams']['away']['runs'],
                      'home_runs': game['linescore']['teams']['home']['runs'],
                      'codedGameState': game['codedGameState'],
                      'scheduledInnings': game['scheduledInnings']
                    })
                
                if cur_game_pk is None and len(active_games) == 0:
                    dialog = xbmcgui.Dialog()
                    dialog.ok(LOCAL_STRING(30444),LOCAL_STRING(30419))
                    break
                
                games = sorted(active_games, key=lambda x: x['LI'], reverse=True)
                xbmc.log(monitor_name + ' active games ' + json.dumps(games))
                xbmc.log(monitor_name + ' current pitchers ' + json.dumps(cur_pitchers))
                for key, value in pitching_changes.items():
                    xbmc.log(monitor_name + ' pitching change in game ' + key + ' until ' + str(value))
                
                if len(active_games) == 0:
                    continue
                
                game_pk = None
                if 'priority' in self.stream_finder_settings:
                    for priority in self.stream_finder_settings['priority']:
                        if same_batter == 'N' or priority['immediate'] == 'Y':
                            for game in games:
                                # Batter
                                if priority['type'] == 'bat' and (int(priority['data']) == game['batter'] or (int(priority['data']) == game['ondeck'] and 'on_deck' in self.stream_finder_settings and self.stream_finder_settings['on_deck'] == 'Y' and game['outs'] < 2)):
                                    game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                    break
                                # Pitcher
                                elif priority['type'] == 'pit' and int(priority['data']) == game['pitcher']:
                                    game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                    break
                                # Runner
                                elif priority['type'] == 'run' and ((int(priority['data']) == game['run1'] and game['run2'] is None) or (int(priority['data']) == game['run2'] and game['run3'] is None)):
                                    game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                    break
                                # Team
                                elif priority['type'] == 'team' and (int(priority['data']) == game['away_team_id'] or int(priority['data']) == game['home_team_id']):
                                    game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                    break
                                # Batting Team
                                elif priority['type'] == 'team_bat' and ((int(priority['data']) == game['away_team_id'] and game['half'] == 1) or (int(priority['data']) == game['home_team_id'] and game['half'] == 2)):
                                    game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                    break
                                # Pitching Team
                                elif priority['type'] == 'team_pit' and ((int(priority['data']) == game['away_team_id'] and game['half'] == 2) or (int(priority['data']) == game['home_team_id'] and game['half'] == 1)):
                                    game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                    break
                                # Leverage Index
                                elif priority['type'] == 'LI' and float(priority['data']) <= game['LI']:
                                    game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                    break
                                # No Hitter
                                elif priority['type'] == 'NoNo' and game['inning'] > int(priority['data']) and ((game['half'] == 1 and game['away_hits'] == 0) or (game['half'] == 2 and game['home_hits'] == 0)):
                                    game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                    break
                                # Game Situation
                                elif priority['type'] == 'GameSit':
                                    if priority['data'] == 'through5_tie' and game['inning'] > 5 and game['away_runs'] == game['home_runs']:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    elif priority['data'] == 'through6_tie' and game['inning'] > 6 and game['away_runs'] == game['home_runs']:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    elif priority['data'] == 'through7_tie' and game['inning'] > 7 and game['away_runs'] == game['home_runs']:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    elif priority['data'] == 'through8_tie' and game['inning'] > 8 and game['away_runs'] == game['home_runs']:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    elif priority['data'] == 'through5_1run' and game['inning'] > 5 and abs(game['away_runs'] - game['home_runs']) == 1:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    elif priority['data'] == 'through6_1run' and game['inning'] > 6 and abs(game['away_runs'] - game['home_runs']) == 1:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    elif priority['data'] == 'through7_1run' and game['inning'] > 7 and abs(game['away_runs'] - game['home_runs']) == 1:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    elif priority['data'] == 'through8_1run' and game['inning'] > 8 and abs(game['away_runs'] - game['home_runs']) == 1:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                # Misc
                                elif priority['type'] == 'Misc':
                                    # Position player pitching
                                    if priority['data'] == 'PosP_pit' and game['pitcher'] in posPlayers:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    # Extra innings
                                    elif priority['data'] == 'extra' and game['inning'] > game['scheduledInnings']:
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                    # Replay
                                    elif priority['data'] == 'replay' and ('M' in game['codedGameState'] or 'N' in game['codedGameState']):
                                        game_pk, cur_batter = self.setCurrentGame(cur_game_pk, game, team_data, monitor_name, priority)
                                        break
                                
                            if game_pk is not None:
                                break
                            
                # If no preference items were met
                if game_pk is None:
                    # if same batter is still at plate
                    if same_batter == 'Y':
                        game_pk = cur_game_pk
                    else:
                        # Ignore if current game is not default high LI game
                        if cur_game_high_LI is None:
                            cur_game_high_LI = -3
                        # When the current game showing is the high leverage game (not chosen from priority list) and there is now a different game that is the highest LI game.
                        # New game's LI must be 0.5 higher than current game to switch
                        if (cur_game_high_LI_flag == 'Y' and games[0]['LI'] > (cur_game_high_LI + 0.5) and (games[0]['LI'] > 1 or cur_game_high_LI == -3)) or cur_game_high_LI_flag == 'N':
                            game_pk, cur_batter = self.setCurrentGame(cur_game_pk, games[0], team_data, monitor_name, {'type': 'default', 'data': 'highest leverage'})
                        else:
                            game_pk = cur_game_pk # Stay on current game
                            # cur_batter and cur_game were set earlier while looping through games
                            
                        cur_game_high_LI_flag = 'Y' # For next time through
                        cur_game_high_LI = -3 # Sets to -3, just in case this game ends
                else:
                    cur_game_high_LI_flag = 'N' # game was set by priority list
                    
                # Only update if this is a different game
                if game_pk != cur_game_pk:
                    if cur_game_pk is not None and 'delay' in self.stream_finder_settings and int(self.stream_finder_settings['delay']) > 0:
                        xbmc.log(monitor_name + ' delaying switch by ' + str(int(self.stream_finder_settings['delay'])))
                        xbmc.sleep(int(self.stream_finder_settings['delay']))
                    xbmc.log(monitor_name + ' loading game ' + str(game_pk))
                    self.stream_started = False
                    refresh_sec = stream_refresh_sec
                    #player.stop()
                    # stop overlay if necessary
                    self.stop_overlay(monitor_name)
                    needs_overlay = stream_select(str(game_pk), 'True', 'False', 'False', 'False', LOCAL_STRING(30444), video_title, ICON, None, autoplay=True, overlay_check='True')
                    # next line helps avoid a crash per https://github.com/xbmc/xbmc/issues/14838#issuecomment-750289254
                    xbmc.executebuiltin('Dialog.Close(all,true)')
                    try:
                        self.mlb_monitor_file = self.get_playing_file(player)
                    except:
                        pass
                    #xbmc.Player().play('plugin://plugin.video.mlbtv/?mode=102&game_pk='+game['state'].game_pk+u_params)
                    xbmc.executebuiltin('PlayMedia("plugin://plugin.video.mlbtv/?mode=102&game_pk='+str(game_pk)+u_params+'")')
                    xbmcplugin.endOfDirectory(addon_handle)
                    # wait for stream start before proceeding
                    if self.wait_for_stream(str(game_pk)) is True:
                        xbmc.log(monitor_name + ' loaded stream for ' + str(game_pk))
                        refresh_sec = game_refresh_sec
                        if needs_overlay is True or DISABLE_CLOSED_CAPTIONS == 'true':
                            # wait an extra second
                            #xbmc.sleep(1000)
                            if needs_overlay is True:
                                self.start_overlay(str(game_pk))
                            if DISABLE_CLOSED_CAPTIONS == 'true':
                                self.stop_captions(str(game_pk))
                        xbmc.log(monitor_name + ' loaded game ' + str(game_pk))
                    cur_game_pk = game_pk
                      

            if self.monitor.waitForAbort(refresh_sec):
                xbmc.log(monitor_name + " aborting")
                break
            elif self.stream_started == True and (not xbmc.getCondVisibility("Player.HasMedia") or (self.mlb_monitor_file != self.get_playing_file(player)) or (player.getVideoInfoTag().getTitle() != video_title)):
                xbmc.log(monitor_name + " closing due to stream stopped or changed")
                break
            elif self.mlb_monitor_started == '':
                xbmc.log(monitor_name + " closing due to reset")
                break

        # stop overlay if necessary
        self.stop_overlay(monitor_name)

        xbmc.log(monitor_name + " closed")
                

    def change_monitor(self, blackouts):
        xbmc.log("Change monitor starting")

        self.mlb_monitor_started = str(datetime.now())
        settings.setSetting(id='mlb_monitor_started', value=self.mlb_monitor_started)
        monitor_name = 'Change monitor from ' + self.mlb_monitor_started
        xbmc.log(monitor_name + ' started')

        # initialize player to monitor video title
        player = xbmc.Player()
        video_title = LOCAL_STRING(30417) + ' ' + self.mlb_monitor_started

        game_refresh_sec = 10
        stream_refresh_sec = 1
        # check games every `refresh_sec` but return data from `delay_sec` ago to account for stream delay/buffering
        refresh_sec = game_refresh_sec
        delay_sec = GAME_CHANGER_DELAY + self.MLB_GAMECHANGER_PADDING
        games_buffer = deque(maxlen=int((delay_sec / refresh_sec) + 1))
        players_buffer = deque(maxlen=int((delay_sec / refresh_sec) + 1))
        innings_buffer = deque(maxlen=int((delay_sec / refresh_sec) + 1))

        games = []
        players = dict()
        innings = dict()
        self.break_expiries = dict()
        curr_game = None

        u_params = '&name=' + video_title + '&description=' + urllib.quote_plus(LOCAL_STRING(30418)) + '&icon=' + urllib.quote_plus(ICON) + '&gamechanger=True'

        today = localToEastern()
        #date_string = today[0:4] + '/month_' + today[5:7] + '/day_' + today[8:10]
        date_string = today

        while not self.monitor.abortRequested():
            if refresh_sec != stream_refresh_sec:
                new_games, new_players, new_innings = self.get_best_games(date_string, blackouts, monitor_name, players, innings, curr_game)
                games_buffer.append(new_games)
                players_buffer.append(new_players)
                innings_buffer.append(new_innings)
                games = games_buffer[0]
                if delay_sec > 0:
                    xbmc.log(monitor_name + ' ' + str(delay_sec) + ' second delayed data ' + json.dumps(games))
                players = players_buffer[0]
                innings = innings_buffer[0]

                if curr_game is not None and len(games) == 0:
                    xbmc.log(monitor_name + ' not switching from ' + curr_game['state'].teams + ' because there are no active games')
                elif curr_game is not None and len(games) > 0 and curr_game['state'].game_pk == games[0]['state'].game_pk:
                    xbmc.log(monitor_name + ' not switching because ' + curr_game['state'].teams + ' is still the best/only game')
                elif curr_game is None and len(games) == 0:
                    dialog = xbmcgui.Dialog()
                    dialog.ok(LOCAL_STRING(30417),LOCAL_STRING(30419))
                    break
                else:
                    # Update state of curr_game
                    if curr_game is not None:
                        new_curr_game = [game for game in games if game['state'].game_pk == curr_game['state'].game_pk]
                        if not new_curr_game:
                            curr_game = None
                        else:
                            curr_game = new_curr_game[0]

                    # Only switch games if:
                    #  curr_game is None (either no curr_game or it's in commercial break)
                    #  The change in leverage is > 1.5 and there's a new batter in curr_game
                    #  game has a better leverage than curr_game and curr_game is below average leverage (1.0) and there's a new batter in curr_game
                    curr_game_none = curr_game is None
                    new_batter = curr_game and curr_game['state'].new_batter
                    curr_game_below_avg = curr_game and curr_game['leverage_index'] < 1.0
                    for game in games:
                        large_leverage_diff = curr_game and (game['leverage_index'] - curr_game['leverage_index'] > 1.5)
                        game_better = curr_game and game['leverage_index'] > curr_game['leverage_index']
                        if curr_game_none or (new_batter and (large_leverage_diff or (curr_game_below_avg and game_better))):
                            curr_game = game
                            xbmc.log(monitor_name + ' loading game ' + game['state'].teams)
                            self.stream_started = False
                            refresh_sec = stream_refresh_sec
                            #player.stop()
                            # stop overlay if necessary
                            self.stop_overlay(monitor_name)
                            needs_overlay = stream_select(game['state'].game_pk, 'True', 'False', 'False', 'False', LOCAL_STRING(30418), video_title, ICON, None, autoplay=True, overlay_check='True')
                            # next line helps avoid a crash per https://github.com/xbmc/xbmc/issues/14838#issuecomment-750289254
                            xbmc.executebuiltin('Dialog.Close(all,true)')
                            try:
                                self.mlb_monitor_file = self.get_playing_file(player)
                            except:
                                pass
                            #xbmc.Player().play('plugin://plugin.video.mlbtv/?mode=102&game_pk='+game['state'].game_pk+u_params)
                            xbmc.executebuiltin('PlayMedia("plugin://plugin.video.mlbtv/?mode=102&game_pk='+game['state'].game_pk+u_params+'")')
                            xbmcplugin.endOfDirectory(addon_handle)
                            # wait for stream start before proceeding
                            if self.wait_for_stream(game['state'].game_pk) is True:
                                xbmc.log(monitor_name + ' loaded stream for ' + game['state'].teams)
                                refresh_sec = game_refresh_sec
                                if needs_overlay is True or DISABLE_CLOSED_CAPTIONS == 'true':
                                    # wait an extra second
                                    #xbmc.sleep(1000)
                                    if needs_overlay is True:
                                        self.start_overlay(game['state'].game_pk)
                                    if DISABLE_CLOSED_CAPTIONS == 'true':
                                        self.stop_captions(game['state'].game_pk)
                                xbmc.log(monitor_name + ' loaded game ' + game['state'].teams)
                            break
                        elif large_leverage_diff:
                            xbmc.log(monitor_name + ' ' + game['state'].teams + ' is a better game, but ' + curr_game['state'].teams + ' still has a batter at the plate')
                        elif game_better:
                            xbmc.log(monitor_name + ' ' + game['state'].teams + ' is better game, but not enough better to switch from ' + curr_game['state'].teams)

            if self.monitor.waitForAbort(refresh_sec):
                xbmc.log(monitor_name + " aborting")
                break
            elif self.stream_started == True and (not xbmc.getCondVisibility("Player.HasMedia") or (self.mlb_monitor_file != self.get_playing_file(player)) or (player.getVideoInfoTag().getTitle() != video_title)):
                xbmc.log(monitor_name + " closing due to stream stopped or changed")
                break
            elif self.mlb_monitor_started == '':
                xbmc.log(monitor_name + " closing due to reset")
                break

        # stop overlay if necessary
        self.stop_overlay(monitor_name)

        xbmc.log(monitor_name + " closed")


    # get Stream Finder data
    def get_stream_finder_data(self):
        url = 'https://www.baseball-reference.com/stream-finder.shtml'
        headers = {
            'User-Agent': UA_PC,
            'Referer': 'https://www.baseball-reference.com/',
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
            'Accept-Encoding': 'gzip, deflate, br, zstd'
        }
        r = requests.get(url,headers=headers, verify=VERIFY)
        html_source = r.text
        
        return html_source


    def is_runner(self, base):
        if base is None:
            return '0'
        else:
            return '1'
            
    def basesit(self, first, second, third):
        return self.BASESIT_TABLE[self.is_runner(first)][self.is_runner(second)][self.is_runner(third)]            
    
    # get game data for stream finder
    def get_stream_finder_games(self):
        url = 'http://statsapi.mlb.com/api/v1/schedule?sportId=1&hydrate=linescore,team,flags,gameInfo'
        headers = {
            'User-Agent': UA_PC,
            'Origin': 'https://www.mlb.com',
            'Referer': 'https://www.mlb.com/',
            'Content-Type': 'application/json',
            'Accept-Encoding': 'gzip, deflate, br'
        }
        r = requests.get(url,headers=headers, verify=VERIFY)
        json_source = r.json()
        
        games = []

        if 'dates' in json_source and len(json_source['dates']) == 1 and 'games' in json_source['dates'][0] and len(json_source['dates'][0]['games']) > 0:
            for game in json_source['dates'][0]['games']:
                if 'linescore' not in game:
                    continue
                currentInning = 1
                if 'currentInning' in game['linescore']:
                    currentInning = game['linescore']['currentInning']
                inningState = 'Top'
                if 'inningState' in game['linescore']:
                    inningState = game['linescore']['inningState']
                balls = 0
                if 'balls' in game['linescore']:
                    balls = game['linescore']['balls']
                strikes = 0
                if 'strikes' in game['linescore']:
                    strikes = game['linescore']['strikes']
                outs = 0
                if 'outs' in game['linescore']:
                    outs = game['linescore']['outs']
                status = 'scheduled'
                if game['status']['detailedState'] == 'In Progress':
                    status = 'active'
                half = 1
                if 'inningHalf' in game['linescore']:
                    if game['linescore']['inningHalf'] == 'Bottom':
                        half = 2
                away_runs = 0
                if 'runs' in game['linescore']['teams']['away']:
                    away_runs = game['linescore']['teams']['away']['runs']
                away_hits = 0
                if 'hits' in game['linescore']['teams']['away']:
                    away_hits = game['linescore']['teams']['away']['hits']
                home_runs = 0
                if 'runs' in game['linescore']['teams']['home']:
                    home_runs = game['linescore']['teams']['home']['runs']
                home_hits = 0
                if 'hits' in game['linescore']['teams']['home']:
                    home_hits = game['linescore']['teams']['home']['hits']
                pitcher = None
                if 'pitcher' in game['linescore']['defense']:
                    pitcher = game['linescore']['defense']['pitcher']['id']
                batter = None
                if 'batter' in game['linescore']['offense']:
                    batter = game['linescore']['offense']['batter']['id']
                onDeck = None
                if 'onDeck' in game['linescore']['offense']:
                    onDeck = game['linescore']['offense']['onDeck']['id']
                first = None
                if 'first' in game['linescore']['offense']:
                    first = game['linescore']['offense']['first']['id']
                second = None
                if 'second' in game['linescore']['offense']:
                    second = game['linescore']['offense']['second']['id']
                third = None
                if 'third' in game['linescore']['offense']:
                    third = game['linescore']['offense']['third']['id']
                
                basesit = self.basesit(first, second, third)
                innbaseout = str(currentInning) + str(half) + str(basesit) + str(outs)
                
                games.append({
                  'gamePk': game['gamePk'],
                  'codedGameState': game['status']['codedGameState'],
                  'status': status,
                  'scheduledInnings': game['scheduledInnings'],
                  'teams': {
                    'away': {
                      'team': {
                        'id': game['teams']['away']['team']['id']
                      }
                    },
                    'home': {
                      'team': {
                        'id': game['teams']['home']['team']['id']
                      }
                    }
                  },
                  'linescore': {
                    'InnBaseOut': innbaseout,
                    'RunDiff': abs(away_runs - home_runs),
                    'BaseSit': basesit,
                    'balls': balls,
                    'strikes': strikes,
                    'outs': outs,
                    'currentInning': currentInning,
                    'inningState': inningState,
                    'half': half,
                    'teams': {
                      'away': {
                        'runs': home_runs,
                        'hits': home_hits
                      },
                      'home': {
                        'runs': home_runs,
                        'hits': home_hits
                      }
                    },
                    'defense': {
                      'pitcher': {
                        'id': pitcher
                      }
                    },
                    'offense': {
                      'onDeck': {
                        'id': onDeck
                      },
                      'third': {
                        'id': third
                      },
                      'second': {
                        'id': second
                      },
                      'first': {
                        'id': first
                      },
                      'batter': {
                        'id': batter
                      }
                    }
                  }
                })
        
        return games


    # get active live games ordered by leverage
    def get_best_games(self, date_string, blackouts, monitor_name, players, innings, curr_game):
        #url = 'http://gd2.mlb.com/components/game/mlb/year_' + date_string + '/master_scoreboard.json'
        #headers = {
        #    'User-Agent': UA_PC
        #}
        #url = 'http://statsapi.mlb.com/api/v1/schedule?sportId=1&startDate=' + date_string + '&endDate=' + date_string + '&hydrate=game(content(media(epg))),linescore,team,flags,gameInfo'
        url = 'http://statsapi.mlb.com/api/v1/schedule?sportId=1&startDate=' + date_string + '&endDate=' + date_string + '&hydrate=broadcasts(all),linescore,team,flags,gameInfo'
        headers = {
            'User-Agent': UA_PC,
            'Origin': 'https://www.mlb.com',
            'Referer': 'https://www.mlb.com/',
            'Content-Type': 'application/json',
            'Accept-Encoding': 'gzip, deflate, br'
        }
        r = requests.get(url,headers=headers, verify=VERIFY)
        json_source = r.json()
        #xbmc.log('Change monitor ' + self.mlb_monitor_started + ' json source : ' + json.dumps(json_source))

        now = datetime.now()

        best_games = []
        new_players = dict()
        new_innings = dict()
        omitted_games = {}

        #if 'data' in json_source and 'games' in json_source['data'] and 'game' in json_source['data']['games']:
        if 'dates' in json_source and len(json_source['dates']) == 1 and 'games' in json_source['dates'][0] and len(json_source['dates'][0]['games']) > 0:
            games = []
            # if we don't have a current game, and nothing is found on loop #1, expand the criteria to include:
            # 2. challenge/replay review games
            # 3. games in break
            # 4. warmup
            for x in range(1,5):
                new_innings = dict()
                omitted_games = {'no_broadcast': [], 'blackout': [], 'warmup': [], 'inactive': [], 'break': [], 'pitching_change': [], 'review': []}

                # reset all break expiries if we're on our third loop and including games in break
                if x == 3:
                    self.break_expiries = dict()

                #for game in json_source['data']['games']['game']:
                for game in json_source['dates'][0]['games']:
                    #teams = game['away_name_abbrev'] + '@' + game['home_name_abbrev']
                    #game_pk = str(game['game_pk'])
                    away_name_abbrev = game['teams']['away']['team']['abbreviation']
                    home_name_abbrev = game['teams']['home']['team']['abbreviation']
                    game_pk = str(game['gamePk'])

                    teams = away_name_abbrev + '@' + home_name_abbrev

                    # Check break expiry, if available
                    if game_pk in self.break_expiries and self.break_expiries[game_pk] > now:
                        xbmc.log(monitor_name + ' ' + teams + ' still in break')
                        omitted_games['break'].append(teams)
                        continue

                    # Game is not broadcast
                    #if 'content' not in game or 'media' not in game['content'] or 'epg' not in game['content']['media'] or len(game['content']['media']['epg']) == 0 or game['content']['media']['epg'][0]['title'] != 'MLBTV' or 'items' not in game['content']['media']['epg'][0] or len(game['content']['media']['epg'][0]['items']) == 0:
                    if 'broadcasts' not in game or len(game['broadcasts']) == 0:
                        omitted_games['no_broadcast'].append(teams)
                        continue
                    else:
                        tv_broadcast = False
                        for broadcast in game['broadcasts']:
                            if broadcast['type'] == 'TV':
                                tv_broadcast = True
                                break
                        if tv_broadcast is False:
                            omitted_games['no_broadcast'].append(teams)
                            continue

                    # Game is blacked out
                    if game_pk in blackouts:
                        omitted_games['blackout'].append(teams)
                        continue

                    #game_status = game['status']
                    game_status = game['status']['detailedState']

                    #if 'challenge' in game_status['status'].lower() or 'replay' in game_status['status'].lower():
                    if 'challenge' in game_status.lower() or 'replay' in game_status.lower():
                        # Game is in challenge/replay review
                        if x < 2:
                            omitted_games['review'].append(teams)
                            continue
                    elif game_status == 'Warmup':
                        # Game is in warmup
                        if x < 4:
                            omitted_games['warmup'].append(teams)
                            continue
                    #elif 'inning' not in game_status or 'o' not in game_status or game_status != 'In Progress':
                    elif game_status != 'In Progress':
                        # Game is otherwise not active (not started or game over)
                        omitted_games['inactive'].append(teams)
                        continue

                    #inning_half = self.convert_inning_half(game_status['inning_state'])
                    #inning_num = int(game_status['inning'])
                    #outs = int(game_status['o'])
                    #runners_on_base = self.convert_runners_on_base(game['runners_on_base'])
                    #balls = int(game_status['b'])
                    #strikes = int(game_status['s'])
                    #away_score = int(game['linescore']['r']['away'])
                    #home_score = int(game['linescore']['r']['home'])

                    inning_half = self.convert_inning_half(game['linescore']['inningHalf'])
                    inning_num = int(game['linescore']['currentInning'])
                    outs = int(game['linescore']['outs'])
                    runners_on_base = self.convert_runners_on_base(game['linescore']['offense'])
                    balls = int(game['linescore']['balls'])
                    strikes = int(game['linescore']['strikes'])
                    away_score = int(game['linescore']['teams']['away']['runs'])
                    home_score = int(game['linescore']['teams']['home']['runs'])

                    # Game hasn't started yet
                    if x < 4 and inning_num == 1 and inning_half == 'top' and outs == 0 and balls == 0 and strikes == 0 and away_score == 0 and runners_on_base == '_ _ _':
                        omitted_games['inactive'].append(teams)
                        continue

                    # Game is between innings
                    if inning_half == 'Middle' or inning_half == 'End' or outs == 3:
                        if outs == 3:
                            if inning_half == 'top':
                                inning_half = 'Middle'
                            elif inning_half == 'bot':
                                inning_half = 'End'

                        if inning_half == 'Middle' or inning_half == 'End':
                            if inning_half == 'Middle':
                                # check for finished games
                                if inning_num == 9 and away_score < home_score:
                                    omitted_games['inactive'].append(teams)
                                    continue
                                inning_half = 'bot'
                            elif inning_half == 'End':
                                # check for finished games
                                if inning_num >= 9 and away_score != home_score:
                                    omitted_games['inactive'].append(teams)
                                    continue
                                inning_half = 'top'
                                inning_num += 1
                            outs = 0
                            runners_on_base = '_ _ _'
                            balls = 0
                            strikes = 0

                        if x < 3:
                            xbmc.log(monitor_name + ' ' + teams + ' inning break started or in progress')
                            omitted_games['break'].append(teams)

                            # only set break expiry for active games (that already have a stored inning state)
                            if game_pk in innings:
                                self.set_break_expiry(game_pk, now)

                            continue

                    inning_state = inning_half + ',' + str(inning_num)
                    new_innings[game_pk] = inning_state

                    # if the inning has changed, assume a break
                    if x < 3 and game_pk in innings and inning_state != innings[game_pk]:
                        xbmc.log(monitor_name + ' ' + teams + ' inning break detected')
                        omitted_games['break'].append(teams)
                        self.set_break_expiry(game_pk, now)
                        continue

                    # if the pitcher has changed, assume a break
                    if 'linescore' in game and 'defense' in game['linescore'] and 'pitcher' in game['linescore']['defense'] and 'id' in game['linescore']['defense']['pitcher']:
                        #pitcher = game['pitcher']['id']
                        pitcher = game['linescore']['defense']['pitcher']['id']
                        new_pitcher = game_pk in players and 'pitcher' in players[game_pk] and players[game_pk]['pitcher'] != pitcher
                        if x < 3 and new_pitcher:
                            xbmc.log(monitor_name + ' ' + teams + ' pitching change break detected')
                            omitted_games['pitching_change'].append(teams)
                            self.set_break_expiry(game_pk, now)
                            continue

                    if 'linescore' in game and 'offense' in game['linescore'] and 'batter' in game['linescore']['offense'] and 'id' in game['linescore']['offense']['batter']:
                        #batter = game['batter']['id']
                        batter = game['linescore']['offense']['batter']['id']
                        new_batter = (balls == 0 and strikes == 0) or balls == 4 or strikes == 3 or (game_pk in players and 'batter' in players[game_pk] and players[game_pk]['batter'] != batter)

                    # bump perfect games or no hitters in the 9th inning to the top of the leverage list
                    leverage_adjust = 0
                    #if inning_num == 9 and (game_status['is_perfect_game'] == 'Y' or game_status['is_no_hitter'] == 'Y'):
                    if inning_num == 9 and (game['flags']['perfectGame'] == True or game['flags']['noHitter'] == True):
                        #away_hits = int(game['linescore']['h']['away'])
                        away_hits = int(game['linescore']['teams']['away']['hits'])
                        if (away_hits == 0 and inning_half == 'top') or (inning_half == 'bot'):
                            #if game_status['is_perfect_game'] == 'Y':
                            if game['flags']['perfectGame'] == True:
                                xbmc.log(monitor_name + ' adjusting ' + teams + ' for perfect game')
                                leverage_adjust = MAX_LEVERAGE * 2
                            else:
                                xbmc.log(monitor_name + ' adjusting ' + teams + ' for no hitter')
                                leverage_adjust = MAX_LEVERAGE

                    state = self.GameState(
                        teams,
                        away_score,
                        home_score,
                        inning_half,
                        inning_num,
                        outs,
                        runners_on_base,
                        game_pk,
                        new_batter,
                        leverage_adjust)
                    games.append(state)

                    new_players[game_pk] = {'batter': batter, 'pitcher': pitcher}

                # exit loop if we have a current game or we've found new games above
                if curr_game is not None or len(games) > 0:
                    break

            xbmc.log(monitor_name + ' omitted games ' + json.dumps(omitted_games))

            leverage_indices = [{
                                "leverage_index": self.get_li(game.inning_num, game.inning_half, game.runners_on_base, game.outs, game.away_score, game.home_score) + game.leverage_adjust,
                                "state": game
                            } for game in games]
            if len(leverage_indices) > 0:
                best_games = sorted(leverage_indices, key=lambda x: x['leverage_index'], reverse=True)
                xbmc.log(monitor_name + ' live data ' + json.dumps(best_games))
                xbmc.log(monitor_name + ' break expiries ' + json.dumps(self.break_expiries, default=str))

        return best_games, new_players, new_innings


    def convert_inning_half(self, inning_state):
        if inning_state == 'Bottom':
            return 'bot'
        elif inning_state == 'Top':
            return 'top'
        else:
            return inning_state


    def convert_runners_on_base(self, runners_on_base):
        runners_on_str = ''
        #runners_on_str += '1 ' if 'runner_on_1b' in runners_on_base else '_ '
        #runners_on_str += '2 ' if 'runner_on_2b' in runners_on_base else '_ '
        #runners_on_str += '3'  if 'runner_on_3b' in runners_on_base else '_'
        runners_on_str += '1 ' if 'first' in runners_on_base else '_ '
        runners_on_str += '2 ' if 'second' in runners_on_base else '_ '
        runners_on_str += '3'  if 'third' in runners_on_base else '_'
        return runners_on_str


    def get_run_differential(self, away_score, home_score):
        MINIMUM = -4
        MAXIMUM = 4
        differential = home_score - away_score
        clamped_differential = max(MINIMUM, min(differential, MAXIMUM))
        return clamped_differential


    def get_li(self, inning_num, inning_half, runners_on_base, num_outs, away_score, home_score):
        run_differential_index = self.get_run_differential(away_score, home_score) + 4
        inning_num_index = min(inning_num, 9)

        return self.LI_TABLE[inning_num_index][inning_half][runners_on_base][num_outs][run_differential_index]


    def set_break_expiry(self, game_pk, now):
        self.break_expiries[game_pk] = now + timedelta(seconds=109)
