/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import java.util.Collection;
import java.util.Locale;

public final class CastMediaControlIntent {
    @Deprecated
    public static final String CATEGORY_CAST = "com.google.android.gms.cast.CATEGORY_CAST";
    public static final String DEFAULT_MEDIA_RECEIVER_APPLICATION_ID = "CC1AD845";
    public static final String ACTION_SYNC_STATUS = "com.google.android.gms.cast.ACTION_SYNC_STATUS";
    public static final String EXTRA_CUSTOM_DATA = "com.google.android.gms.cast.EXTRA_CUSTOM_DATA";
    public static final String EXTRA_CAST_APPLICATION_ID = "com.google.android.gms.cast.EXTRA_CAST_APPLICATION_ID";
    public static final String EXTRA_CAST_RELAUNCH_APPLICATION = "com.google.android.gms.cast.EXTRA_CAST_RELAUNCH_APPLICATION";
    public static final String EXTRA_CAST_LANGUAGE_CODE = "com.google.android.gms.cast.EXTRA_CAST_LANGUAGE_CODE";
    public static final String EXTRA_CAST_STOP_APPLICATION_WHEN_SESSION_ENDS = "com.google.android.gms.cast.EXTRA_CAST_STOP_APPLICATION_WHEN_SESSION_ENDS";
    public static final String EXTRA_DEBUG_LOGGING_ENABLED = "com.google.android.gms.cast.EXTRA_DEBUG_LOGGING_ENABLED";
    public static final String EXTRA_ERROR_CODE = "com.google.android.gms.cast.EXTRA_ERROR_CODE";
    public static final int ERROR_CODE_REQUEST_FAILED = 1;
    public static final int ERROR_CODE_SESSION_START_FAILED = 2;
    public static final int ERROR_CODE_TEMPORARILY_DISCONNECTED = 3;

    public static String categoryForRemotePlayback(String applicationId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)applicationId)) {
            throw new IllegalArgumentException("applicationId cannot be null or empty");
        }
        return CastMediaControlIntent.zza("com.google.android.gms.cast.CATEGORY_CAST_REMOTE_PLAYBACK", applicationId, null);
    }

    public static String categoryForRemotePlayback() {
        return CastMediaControlIntent.zza("com.google.android.gms.cast.CATEGORY_CAST_REMOTE_PLAYBACK", null, null);
    }

    public static String categoryForCast(String applicationId) throws IllegalArgumentException {
        if (applicationId == null) {
            throw new IllegalArgumentException("applicationId cannot be null");
        }
        return CastMediaControlIntent.zza(CATEGORY_CAST, applicationId, null);
    }

    public static String categoryForCast(Collection<String> namespaces) throws IllegalArgumentException {
        if (namespaces == null) {
            throw new IllegalArgumentException("namespaces cannot be null");
        }
        return CastMediaControlIntent.zza(CATEGORY_CAST, null, namespaces);
    }

    public static String categoryForCast(String applicationId, Collection<String> namespaces) {
        if (applicationId == null) {
            throw new IllegalArgumentException("applicationId cannot be null");
        }
        if (namespaces == null) {
            throw new IllegalArgumentException("namespaces cannot be null");
        }
        return CastMediaControlIntent.zza(CATEGORY_CAST, applicationId, namespaces);
    }

    private static String zza(String string2, String string3, Collection<String> collection) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (string3 != null) {
            String string4 = string3.toUpperCase();
            if (!string4.matches("[A-F0-9]+")) {
                throw new IllegalArgumentException("Invalid application ID: " + string3);
            }
            stringBuilder.append("/").append(string4);
        }
        if (collection != null) {
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Must specify at least one namespace");
            }
            if (string3 == null) {
                stringBuilder.append("/");
            }
            stringBuilder.append("/");
            boolean bl = true;
            for (String string5 : collection) {
                zzf.zzbD(string5);
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(zzf.zzbF(string5));
            }
        }
        return stringBuilder.toString();
    }

    public static String languageTagForLocale(Locale locale) {
        return zzf.zzb(locale);
    }

    private CastMediaControlIntent() {
    }
}

