/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataHolder
implements SafeParcelable {
    public static final zze CREATOR = new zze();
    private final int zzCY;
    private final String[] zzYw;
    Bundle zzYx;
    private final CursorWindow[] zzYy;
    private final int zzTS;
    private final Bundle zzYz;
    int[] zzYA;
    int zzYB;
    boolean mClosed = false;
    private Object zzYC;
    private boolean zzYD = true;
    private static final zza zzYE = new zza(new String[0], null){};

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.zzCY = versionCode;
        this.zzYw = columns;
        this.zzYy = windows;
        this.zzTS = statusCode;
        this.zzYz = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.zzCY = 1;
        this.zzYw = zzu.zzu(columns);
        this.zzYy = zzu.zzu(windows);
        this.zzTS = statusCode;
        this.zzYz = metadata;
        this.zznf();
    }

    public void zzp(Object object) {
        this.zzYC = object;
    }

    private DataHolder(zza builder, int statusCode, Bundle metadata) {
        this(builder.zzYw, DataHolder.zza(builder, -1), statusCode, metadata);
    }

    public void zznf() {
        int n;
        this.zzYx = new Bundle();
        for (n = 0; n < this.zzYw.length; ++n) {
            this.zzYx.putInt(this.zzYw[n], n);
        }
        this.zzYA = new int[this.zzYy.length];
        n = 0;
        for (int i = 0; i < this.zzYy.length; ++i) {
            this.zzYA[i] = n;
            int n2 = this.zzYy[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzYy[i].getNumRows() - n3;
        }
        this.zzYB = n;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags);
    }

    int getVersionCode() {
        return this.zzCY;
    }

    String[] zzng() {
        return this.zzYw;
    }

    CursorWindow[] zznh() {
        return this.zzYy;
    }

    public int getStatusCode() {
        return this.zzTS;
    }

    public Bundle zznb() {
        return this.zzYz;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzYw.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.zzYF.size() ? zza2.zzYF : zza2.zzYF.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzYw.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzYw.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (int j = 0; j < zza2.zzYw.length && bl2; ++j) {
                    String string2 = zza2.zzYw[j];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, j);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, j);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, j);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, j);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, j);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, j);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, j);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, j);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v);
                }
                if (!bl2) {
                    if (bl) {
                        String string3 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string3);
                    }
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzYw.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzg(String string2, int n) {
        if (this.zzYx == null || !this.zzYx.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzYB) {
            throw new CursorIndexOutOfBoundsException(n, this.zzYB);
        }
    }

    public boolean zzbV(String string2) {
        return this.zzYx.containsKey(string2);
    }

    public long zzb(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzYy[n2].getLong(n, this.zzYx.getInt(string2));
    }

    public int zzc(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzYy[n2].getInt(n, this.zzYx.getInt(string2));
    }

    public String zzd(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzYy[n2].getString(n, this.zzYx.getInt(string2));
    }

    public boolean zze(String string2, int n, int n2) {
        this.zzg(string2, n);
        Long l = this.zzYy[n2].getLong(n, this.zzYx.getInt(string2));
        return l == 1L;
    }

    public float zzf(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzYy[n2].getFloat(n, this.zzYx.getInt(string2));
    }

    public byte[] zzg(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzYy[n2].getBlob(n, this.zzYx.getInt(string2));
    }

    public Uri zzh(String string2, int n, int n2) {
        String string3 = this.zzd(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzg(string2, n);
        this.zzYy[n2].copyStringToBuffer(n, this.zzYx.getInt(string2), charArrayBuffer);
    }

    public boolean zzi(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzYy[n2].isNull(n, this.zzYx.getInt(string2));
    }

    public int getCount() {
        return this.zzYB;
    }

    public int zzbh(int n) {
        int n2;
        zzu.zzU(n >= 0 && n < this.zzYB);
        for (n2 = 0; n2 < this.zzYA.length; ++n2) {
            if (n >= this.zzYA[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzYA.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzYy.length; ++i) {
                    this.zzYy[i].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.zzYD && this.zzYy.length > 0 && !this.isClosed()) {
                String string2 = this.zzYC == null ? "internal object: " + this.toString() : this.zzYC.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static DataHolder zzbi(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(zzYE, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzYw;
        private final ArrayList<HashMap<String, Object>> zzYF;
        private final String zzYG;
        private final HashMap<Object, Integer> zzYH;
        private boolean zzYI;
        private String zzYJ;

        private zza(String[] stringArray, String string2) {
            this.zzYw = zzu.zzu(stringArray);
            this.zzYF = new ArrayList();
            this.zzYG = string2;
            this.zzYH = new HashMap();
            this.zzYI = false;
            this.zzYJ = null;
        }
    }
}

