/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzu;
import com.google.android.gms.internal.zzlu;
import com.google.android.gms.internal.zzmu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int zzCY;
    private final Session zzajJ;
    private final List<DataSet> zzajS;
    private final List<DataPoint> zzamC;
    private final zzmu zzalN;
    private final String zzMZ;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzu();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, IBinder callback, String packageName) {
        this.zzCY = versionCode;
        this.zzajJ = session;
        this.zzajS = Collections.unmodifiableList(dataSets);
        this.zzamC = Collections.unmodifiableList(aggregateDataPoints);
        this.zzalN = callback == null ? null : zzmu.zza.zzbF(callback);
        this.zzMZ = packageName;
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzajJ, builder.zzajS, builder.zzamC, null, null);
    }

    public SessionInsertRequest(SessionInsertRequest request, zzmu callback, String packageName) {
        this(request.zzajJ, request.zzajS, request.zzamC, callback, packageName);
    }

    public SessionInsertRequest(Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, zzmu callback, String packageName) {
        this.zzCY = 2;
        this.zzajJ = session;
        this.zzajS = Collections.unmodifiableList(dataSets);
        this.zzamC = Collections.unmodifiableList(aggregateDataPoints);
        this.zzalN = callback;
        this.zzMZ = packageName;
    }

    public Session getSession() {
        return this.zzajJ;
    }

    public List<DataSet> getDataSets() {
        return this.zzajS;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzamC;
    }

    public IBinder zzqU() {
        return this.zzalN == null ? null : this.zzalN.asBinder();
    }

    public String getPackageName() {
        return this.zzMZ;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)o);
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzt.equal(this.zzajJ, sessionInsertRequest.zzajJ) && zzt.equal(this.zzajS, sessionInsertRequest.zzajS) && zzt.equal(this.zzamC, sessionInsertRequest.zzamC);
    }

    public int hashCode() {
        return zzt.hashCode(this.zzajJ, this.zzajS, this.zzamC);
    }

    public String toString() {
        return zzt.zzt(this).zzg("session", this.zzajJ).zzg("dataSets", this.zzajS).zzg("aggregateDataPoints", this.zzamC).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzu.zza(this, dest, flags);
    }

    public static class Builder {
        private Session zzajJ;
        private List<DataSet> zzajS = new ArrayList<DataSet>();
        private List<DataPoint> zzamC = new ArrayList<DataPoint>();
        private List<DataSource> zzamD = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzajJ = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            com.google.android.gms.common.internal.zzu.zzb(dataSet != null, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            com.google.android.gms.common.internal.zzu.zza(!this.zzamD.contains(dataSource), "Data set for this data source %s is already added.", dataSource);
            List<DataPoint> list = dataSet.getDataPoints();
            com.google.android.gms.common.internal.zzu.zzb(!list.isEmpty(), (Object)"No data points specified in the input data set.");
            this.zzamD.add(dataSource);
            this.zzajS.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            com.google.android.gms.common.internal.zzu.zzb(aggregateDataPoint != null, (Object)"Must specify a valid aggregate data point.");
            long l = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            com.google.android.gms.common.internal.zzu.zzb(l > 0L && l2 > l, "Aggregate data point should have valid start and end times: %s", aggregateDataPoint);
            DataSource dataSource = aggregateDataPoint.getDataSource();
            com.google.android.gms.common.internal.zzu.zza(!this.zzamD.contains(dataSource), "Data set/Aggregate data point for this data source %s is already added.", dataSource);
            this.zzamD.add(dataSource);
            this.zzamC.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            com.google.android.gms.common.internal.zzu.zza(this.zzajJ != null, (Object)"Must specify a valid session.");
            com.google.android.gms.common.internal.zzu.zza(this.zzajJ.getEndTime(TimeUnit.MILLISECONDS) != 0L, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzrn();
            return new SessionInsertRequest(this);
        }

        private void zzd(DataPoint dataPoint) {
            this.zzf(dataPoint);
            this.zze(dataPoint);
        }

        private void zze(DataPoint dataPoint) {
            long l = this.zzajJ.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzajJ.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzlu.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                com.google.android.gms.common.internal.zzu.zza(l3 >= l && l4 <= l2, "Data point %s has start and end times outside session interval [%d, %d]", dataPoint, l, l2);
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzf(DataPoint dataPoint) {
            long l = this.zzajJ.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzajJ.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzlu.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                com.google.android.gms.common.internal.zzu.zza(l3 >= l && l3 <= l2, "Data point %s has time stamp outside session interval [%d, %d]", dataPoint, l, l2);
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzrn() {
            for (DataSet safeParcelable : this.zzajS) {
                for (DataPoint dataPoint : safeParcelable.getDataPoints()) {
                    this.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzamC) {
                this.zzd(dataPoint);
            }
        }
    }
}

