/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AuthAccountRequest;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.ResolveAccountRequest;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.signin.internal.AuthAccountResult;
import com.google.android.gms.signin.internal.CheckServerAuthResult;
import com.google.android.gms.signin.internal.zzd;
import com.google.android.gms.signin.internal.zze;
import com.google.android.gms.signin.internal.zzf;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class zzh
extends zzi<zzf>
implements zzps {
    private final boolean zzaKa;
    private final com.google.android.gms.common.internal.zze zzXa;
    private final zzpt zzZU;
    private Integer zzZV;
    private final ExecutorService zzaKb;

    public zzh(Context context, Looper looper, boolean bl, com.google.android.gms.common.internal.zze zze2, zzpt zzpt2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ExecutorService executorService) {
        super(context, looper, 44, connectionCallbacks, onConnectionFailedListener, zze2);
        this.zzaKa = bl;
        this.zzXa = zze2;
        this.zzZU = zzpt2;
        this.zzZV = zze2.zznC();
        this.zzaKb = executorService;
    }

    @Override
    public boolean requiresSignIn() {
        return this.zzaKa;
    }

    @Override
    public void zza(zzq zzq2) {
        zzu.zzb(zzq2, (Object)"Expecting a valid IResolveAccountCallbacks");
        try {
            Account account = this.zzXa.zznt();
            ((zzf)this.zznM()).zza(new ResolveAccountRequest(account, this.zzZV), zzq2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when resolveAccount is called");
            try {
                zzq2.zzb(new ResolveAccountResponse(8));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"IResolveAccountCallbacks#onAccountResolutionComplete should be executed from the same process, unexpected RemoteException.");
            }
        }
    }

    @Override
    public void zza(IAccountAccessor iAccountAccessor, boolean bl) {
        try {
            ((zzf)this.zznM()).zza(iAccountAccessor, this.zzZV, bl);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
        }
    }

    @Override
    public void zzxY() {
        try {
            ((zzf)this.zznM()).zziQ(this.zzZV);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
        }
    }

    @Override
    public void zza(IAccountAccessor iAccountAccessor, Set<Scope> set, zze zze2) {
        zzu.zzb(zze2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            ((zzf)this.zznM()).zza(new AuthAccountRequest(iAccountAccessor, set), zze2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when authAccount is called");
            try {
                zze2.zza(new ConnectionResult(8, null), new AuthAccountResult());
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onAuthAccount should be executed from the same process, unexpected RemoteException.");
            }
        }
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.signin.service.START";
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected zzf zzdE(IBinder iBinder) {
        return zzf.zza.zzdD(iBinder);
    }

    @Override
    protected Bundle zzkR() {
        Bundle bundle = zzh.zza(this.zzZU, this.zzXa.zznC(), this.zzaKb);
        String string2 = this.zzXa.zzny();
        if (!this.getContext().getPackageName().equals(string2)) {
            bundle.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzXa.zzny());
        }
        return bundle;
    }

    @Override
    public void connect() {
        this.connect(new zzi.zzf());
    }

    public static Bundle zza(zzpt zzpt2, Integer n, ExecutorService executorService) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzpt2.zzxZ());
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzpt2.zzya());
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzpt2.zzxt());
        if (zzpt2.zzyb() != null) {
            IBinder iBinder = new zza(zzpt2, executorService).asBinder();
            bundle.putParcelable("com.google.android.gms.signin.internal.signInCallbacks", (Parcelable)new BinderWrapper(iBinder));
        }
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        return bundle;
    }

    @Override
    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzdE(iBinder);
    }

    private static class zza
    extends zzd.zza {
        private final zzpt zzZU;
        private final ExecutorService zzaKb;

        public zza(zzpt zzpt2, ExecutorService executorService) {
            this.zzZU = zzpt2;
            this.zzaKb = executorService;
        }

        @Override
        public void zza(final String string2, final List<Scope> list, final zzf zzf2) throws RemoteException {
            this.zzaKb.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        GoogleApiClient.ServerAuthCodeCallbacks serverAuthCodeCallbacks = zza.this.zzyb();
                        Set<Scope> set = Collections.unmodifiableSet(new HashSet(list));
                        GoogleApiClient.ServerAuthCodeCallbacks.CheckResult checkResult = serverAuthCodeCallbacks.onCheckServerAuthorization(string2, set);
                        CheckServerAuthResult checkServerAuthResult = new CheckServerAuthResult(checkResult.zzmA(), checkResult.zzmB());
                        zzf2.zza(checkServerAuthResult);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing checkServerAuthorization callback", (Throwable)remoteException);
                    }
                }
            });
        }

        @Override
        public void zza(final String string2, final String string3, final zzf zzf2) throws RemoteException {
            this.zzaKb.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean bl = zza.this.zzyb().onUploadServerAuthCode(string2, string3);
                        zzf2.zzal(bl);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing uploadServerAuthCode callback", (Throwable)remoteException);
                    }
                }
            });
        }

        private GoogleApiClient.ServerAuthCodeCallbacks zzyb() throws RemoteException {
            return this.zzZU.zzyb();
        }
    }
}

