/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.internal.constants.TimeSpan;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] zzatw = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String zzaty;
    private String zzTL;
    private int zzTS;
    private HashMap<Integer, Result> zzauc;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.zzTS = dataHolder.getStatusCode();
        this.zzauc = new HashMap();
        int n = dataHolder.getCount();
        zzu.zzV(n == 3);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = dataHolder.zzbh(i);
            if (i == 0) {
                this.zzaty = dataHolder.zzd("leaderboardId", i, n2);
                this.zzTL = dataHolder.zzd("playerId", i, n2);
            }
            if (!(bl = dataHolder.zze("hasResult", i, n2))) continue;
            Result result = new Result(dataHolder.zzb("rawScore", i, n2), dataHolder.zzd("formattedScore", i, n2), dataHolder.zzd("scoreTag", i, n2), dataHolder.zze("newBest", i, n2));
            this.zza(result, dataHolder.zzc("timeSpan", i, n2));
        }
    }

    public String getLeaderboardId() {
        return this.zzaty;
    }

    public String getPlayerId() {
        return this.zzTL;
    }

    public Result getScoreResult(int timeSpan) {
        return this.zzauc.get(timeSpan);
    }

    private void zza(Result result, int n) {
        this.zzauc.put(n, result);
    }

    public String toString() {
        zzt.zza zza2 = zzt.zzt(this).zzg("PlayerId", this.zzTL).zzg("StatusCode", this.zzTS);
        for (int i = 0; i < 3; ++i) {
            Result result = this.zzauc.get(i);
            zza2.zzg("TimesSpan", TimeSpan.zzfG(i));
            zza2.zzg("Result", result == null ? "null" : result.toString());
        }
        return zza2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return zzt.zzt(this).zzg("RawScore", this.rawScore).zzg("FormattedScore", this.formattedScore).zzg("ScoreTag", this.scoreTag).zzg("NewBest", this.newBest).toString();
        }
    }
}

