/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipScanner;

public class ZipFileSet
extends FileSet {
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private File srcFile = null;
    private String prefix = "";
    private String fullpath = "";
    private boolean hasDir = false;
    private int fileMode = 33188;
    private int dirMode = 16877;

    public ZipFileSet() {
    }

    protected ZipFileSet(FileSet fileset) {
        super(fileset);
    }

    protected ZipFileSet(ZipFileSet fileset) {
        super(fileset);
        this.srcFile = fileset.srcFile;
        this.prefix = fileset.prefix;
        this.fullpath = fileset.fullpath;
        this.hasDir = fileset.hasDir;
        this.fileMode = fileset.fileMode;
        this.dirMode = fileset.dirMode;
    }

    public void setDir(File dir) throws BuildException {
        if (this.srcFile != null) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        super.setDir(dir);
        this.hasDir = true;
    }

    public void setSrc(File srcFile) {
        if (this.hasDir) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        this.srcFile = srcFile;
    }

    public File getSrc() {
        return this.srcFile;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setFullpath(String fullpath) {
        this.fullpath = fullpath;
    }

    public String getFullpath() {
        return this.fullpath;
    }

    public DirectoryScanner getDirectoryScanner(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDirectoryScanner(p);
        }
        if (this.srcFile != null) {
            ZipScanner zs = new ZipScanner();
            zs.setSrc(this.srcFile);
            super.setDir(p.getBaseDir());
            this.setupDirectoryScanner(zs, p);
            zs.init();
            return zs;
        }
        return super.getDirectoryScanner(p);
    }

    public void setFileMode(String octalString) {
        this.fileMode = 0x8000 | Integer.parseInt(octalString, 8);
    }

    public int getFileMode() {
        return this.fileMode;
    }

    public void setDirMode(String octalString) {
        this.dirMode = 0x4000 | Integer.parseInt(octalString, 8);
    }

    public int getDirMode() {
        return this.dirMode;
    }

    protected AbstractFileSet getRef(Project p) {
        Object o;
        if (!this.checked) {
            Stack<ZipFileSet> stk = new Stack<ZipFileSet>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        if (!((o = this.ref.getReferencedObject(p)) instanceof FileSet)) {
            String msg = this.ref.getRefId() + " doesn't denote a fileset";
            throw new BuildException(msg);
        }
        return (AbstractFileSet)o;
    }
}

