10 PRINT "PROGRAM FILE 141: MAXIMUM OF GROUP TEST OF RND FUNCTION."
20 PRINT "    ANSI STANDARD 8.4"
30 PRINT
40 PRINT "SECTION 141.1: MAXIMUM OF GROUP TEST OF RND FUNCTION."
50 PRINT
60 PRINT "THIS PROGRAM FINDS THE MAXIMUM RANDOM NUMBER AMONG FIXED-"
70 PRINT "SIZE GROUPS AND DETERMINES WHETHER THE DISTRIBUTION OF THE"
80 PRINT "MAXIMA IS SUFFICIENTLY CLOSE TO THE EXPECTED DISTRIBUTION"
90 PRINT "FOR UNIFORM RANDOM NUMBERS OF F(X) = X^T, WHERE T IS THE"
100 PRINT "SIZE OF THE GROUPS. THE KOMOLGOROV-SMIRNOV TEST IS USED"
110 PRINT "TO MEASURE HOW WELL THE RESULTS MATCH THE EXPECTATION."
120 PRINT
130 PRINT "***** THIS TEST IS INFORMATIVE ONLY *****"
140 PRINT
150 PRINT "                     BEGIN TEST"
160 PRINT
170 DIM P(1000)
180 REM SET SIZE OF GROUP
190 LET T=3
200 REM SET NUMBER OF TRIALS
210 LET N=1000
220 FOR I=1 TO N
230 REM MARK AS EMPTY
240 LET P(I)=3
250 NEXT I
260 FOR I=1 TO N
270 LET M=0
280 FOR J=1 TO T
290 LET X=RND
300 IF X<M THEN 320
310 LET M=X
320 NEXT J
330 REM M IS MAX OF GROUP
340 REM X1 IS BEST GUESS FOR LOCATION OF M, BASED ON
350 REM EXPECTED DISTRIBUTION OF F(X) = M^T
360 LET X1=INT((M^T)*N) + 1
370 IF P(X1)<>3 THEN 420
380 REM PRIMARY SLOT EMPTY - FILL IN WITH M
390 LET P(X1)=M
400 GOTO 550
410 REM IF PRIMARY SLOT FILLED, SEARCH FOR NEAREST EMPTY SLOT
420 FOR J=1 TO N
430 IF X1-J<1 THEN 470
440 IF P(X1-J)<>3 THEN 470
450 LET P(X1-J)=M
460 GOTO 550
470 IF X1+J>N THEN 510
480 IF P(X1+J)<>3 THEN 510
490 LET P(X1+J)=M
500 GOTO 550
510 NEXT J
520 PRINT "RED ALERT - NO SLOT FOUND",I,M
530 PRINT "ERROR IN SORT ALGORITHM - PROGRAM TERMINATES."
540 GOTO 1050
550 NEXT I
560 REM BUBBLE-SORT TABLE VALUES
570 LET B1=1
580 LET B3=1
590 REM A3=0 IMPLIES NO SWAPPING DONE YET
600 LET A3=0
610 FOR I=B1 TO N-B1 STEP B3
620 IF P(I)<=P(I+1) THEN 670
630 LET W=P(I)
640 LET P(I)=P(I+1)
650 LET P(I+1)=W
660 LET A3=3
670 NEXT I
680 REM B1 AND B3 CAUSE THE BUBBLE-SORT TO ALTERNATELY SCAN THE ARRAY
690 REM FORWARDS AND BACKWARDS
700 LET B1=N-B1
710 LET B3=-B3
720 IF A3<>0 THEN 600
730 LET M1=-1E38
740 LET M2=-1E38
750 REM FIND K+ AND K- ON PRIMARY DATA
760 FOR I=1 TO N
770 LET P1=P(I)^T
780 LET N1=(I/N) - P1
790 LET N2=P1 - ((I-1)/N)
800 IF N1<M1 THEN 820
810 LET M1=N1
820 IF N2<M2 THEN 840
830 LET M2=N2
840 NEXT I
850 LET N5=SQR(N)
860 LET M1=M1*N5
870 LET M2=M2*N5
880 PRINT
890 REM EXPECTED DISTRIBUTION FOR K+ AND K- WHEN N IS LARGE.
900 LET P1=1 - (EXP(-2*M1*M1))
910 LET P2=1 - (EXP(-2*M2*M2))
920 PRINT "    K+ = ";M1,"   PERCENTILE FOR K+ = ";P1
930 PRINT "    K- = ";M2,"   PERCENTILE FOR K- = ";P2
940 PRINT
950 PRINT "PERCENTILES SHOULD BE BETWEEN .05 AND .95"
960 PRINT
970 IF P1<.05 THEN 1030
980 IF P1>.95 THEN 1030
990 IF P2<.05 THEN 1030
1000 IF P2>.95 THEN 1030
1010 PRINT "*** INFORMATIVE TEST PASSED ***"
1020 GOTO 1040
1030 PRINT "*** INFORMATIVE TEST FAILED ***"
1040 PRINT
1050 PRINT "                END TEST"
1060 PRINT
1070 PRINT "END PROGRAM 141"
1080 END
