package list_test

import (
	"slices"
	"testing"

	"codeberg.org/gruf/go-list"
)

func TestList(t *testing.T) {
	var l list.List[any]

	e1 := l.PushBack(0)
	e2 := l.PushBack(1)
	e3 := l.PushBack(2)
	e4 := l.PushBack(3)
	listContains(t, &l, []any{0, 1, 2, 3})

	l.Remove(e1)
	l.Remove(e2)
	l.Remove(e3)
	l.Remove(e4)
	listContains(t, &l, []any{})

	e1 = l.PushBack("hello")
	e2 = l.PushBack("world")
	e3 = l.PushBack("come")
	e4 = l.PushBack("again?")
	listContains(t, &l, []any{"hello", "world", "come", "again?"})

	l.Remove(e2)
	listContains(t, &l, []any{"hello", "come", "again?"})

	l.Remove(e4)
	listContains(t, &l, []any{"hello", "come"})

	l.InsertElemAfter(e2, e1)
	listContains(t, &l, []any{"hello", "world", "come"})

	l.InsertElemAfter(e4, e3)
	listContains(t, &l, []any{"hello", "world", "come", "again?"})

	e5 := l.InsertAfter(nil, e4)
	listContains(t, &l, []any{"hello", "world", "come", "again?", nil})

	e6 := l.InsertBefore(nil, l.Head)
	listContains(t, &l, []any{nil, "hello", "world", "come", "again?", nil})

	l.Remove(e5)
	l.Remove(e6)
	listContains(t, &l, []any{"hello", "world", "come", "again?"})
}

func listContains(t *testing.T, l *list.List[any], contains []any) {
	if l.Len() != len(contains) {
		t.Errorf("incorrect list length: have=%d want=%d", l.Len(), len(contains))
		return
	}

	var forward []any

	l.Range(func(e *list.Elem[any]) {
		forward = append(forward, e.Value)
	})

	if !slices.Equal(contains, forward) {
		t.Errorf("forwards does not contain expected: expected=%v contains=%v\n", contains, forward)
		return
	}

	var backward []any

	l.RangeReverse(func(e *list.Elem[any]) {
		backward = append(backward, e.Value)
	})

	slices.Reverse(backward)

	if !slices.Equal(contains, backward) {
		t.Errorf("backwards does not contain expected: expected=%v contains=%v\n", contains, backward)
		return
	}
}
