// Code generated by dbus-codegen-go DO NOT EDIT.
package menu

import (
	"context"
	"errors"
	"fmt"

	"github.com/godbus/dbus/v5"
	"github.com/godbus/dbus/v5/introspect"
)

var (
	// Introspection for com.canonical.dbusmenu
	IntrospectDataDbusmenu = introspect.Interface{
		Name: "com.canonical.dbusmenu",
		Methods: []introspect.Method{{Name: "GetLayout", Args: []introspect.Arg{
			{Name: "parentId", Type: "i", Direction: "in"},
			{Name: "recursionDepth", Type: "i", Direction: "in"},
			{Name: "propertyNames", Type: "as", Direction: "in"},
			{Name: "revision", Type: "u", Direction: "out"},
			{Name: "layout", Type: "(ia{sv}av)", Direction: "out"},
		}},
			{Name: "GetGroupProperties", Args: []introspect.Arg{
				{Name: "ids", Type: "ai", Direction: "in"},
				{Name: "propertyNames", Type: "as", Direction: "in"},
				{Name: "properties", Type: "a(ia{sv})", Direction: "out"},
			}},
			{Name: "GetProperty", Args: []introspect.Arg{
				{Name: "id", Type: "i", Direction: "in"},
				{Name: "name", Type: "s", Direction: "in"},
				{Name: "value", Type: "v", Direction: "out"},
			}},
			{Name: "Event", Args: []introspect.Arg{
				{Name: "id", Type: "i", Direction: "in"},
				{Name: "eventId", Type: "s", Direction: "in"},
				{Name: "data", Type: "v", Direction: "in"},
				{Name: "timestamp", Type: "u", Direction: "in"},
			}},
			{Name: "EventGroup", Args: []introspect.Arg{
				{Name: "events", Type: "a(isvu)", Direction: "in"},
				{Name: "idErrors", Type: "ai", Direction: "out"},
			}},
			{Name: "AboutToShow", Args: []introspect.Arg{
				{Name: "id", Type: "i", Direction: "in"},
				{Name: "needUpdate", Type: "b", Direction: "out"},
			}},
			{Name: "AboutToShowGroup", Args: []introspect.Arg{
				{Name: "ids", Type: "ai", Direction: "in"},
				{Name: "updatesNeeded", Type: "ai", Direction: "out"},
				{Name: "idErrors", Type: "ai", Direction: "out"},
			}},
		},
		Signals: []introspect.Signal{{Name: "ItemsPropertiesUpdated", Args: []introspect.Arg{
			{Name: "updatedProps", Type: "a(ia{sv})", Direction: "out"},
			{Name: "removedProps", Type: "a(ias)", Direction: "out"},
		}},
			{Name: "LayoutUpdated", Args: []introspect.Arg{
				{Name: "revision", Type: "u", Direction: "out"},
				{Name: "parent", Type: "i", Direction: "out"},
			}},
			{Name: "ItemActivationRequested", Args: []introspect.Arg{
				{Name: "id", Type: "i", Direction: "out"},
				{Name: "timestamp", Type: "u", Direction: "out"},
			}},
		},
		Properties: []introspect.Property{{Name: "Version", Type: "u", Access: "read"},
			{Name: "TextDirection", Type: "s", Access: "read"},
			{Name: "Status", Type: "s", Access: "read"},
			{Name: "IconThemePath", Type: "as", Access: "read"},
		},
		Annotations: []introspect.Annotation{},
	}
)

// Signal is a common interface for all signals.
type Signal interface {
	Name() string
	Interface() string
	Sender() string

	path() dbus.ObjectPath
	values() []interface{}
}

// Emit sends the given signal to the bus.
func Emit(conn *dbus.Conn, s Signal) error {
	return conn.Emit(s.path(), s.Interface()+"."+s.Name(), s.values()...)
}

// ErrUnknownSignal is returned by LookupSignal when a signal cannot be resolved.
var ErrUnknownSignal = errors.New("unknown signal")

// LookupSignal converts the given raw D-Bus signal with variable body
// into one with typed structured body or returns ErrUnknownSignal error.
func LookupSignal(signal *dbus.Signal) (Signal, error) {
	switch signal.Name {
	case InterfaceDbusmenu + "." + "ItemsPropertiesUpdated":
		v0, ok := signal.Body[0].([]struct {
			V0 int32
			V1 map[string]dbus.Variant
		})
		if !ok {
			return nil, fmt.Errorf("prop .UpdatedProps is %T, not []struct {V0 int32;V1 map[string]dbus.Variant}", signal.Body[0])
		}
		v1, ok := signal.Body[1].([]struct {
			V0 int32
			V1 []string
		})
		if !ok {
			return nil, fmt.Errorf("prop .RemovedProps is %T, not []struct {V0 int32;V1 []string}", signal.Body[1])
		}
		return &Dbusmenu_ItemsPropertiesUpdatedSignal{
			sender: signal.Sender,
			Path:   signal.Path,
			Body: &Dbusmenu_ItemsPropertiesUpdatedSignalBody{
				UpdatedProps: v0,
				RemovedProps: v1,
			},
		}, nil
	case InterfaceDbusmenu + "." + "LayoutUpdated":
		v0, ok := signal.Body[0].(uint32)
		if !ok {
			return nil, fmt.Errorf("prop .Revision is %T, not uint32", signal.Body[0])
		}
		v1, ok := signal.Body[1].(int32)
		if !ok {
			return nil, fmt.Errorf("prop .Parent is %T, not int32", signal.Body[1])
		}
		return &Dbusmenu_LayoutUpdatedSignal{
			sender: signal.Sender,
			Path:   signal.Path,
			Body: &Dbusmenu_LayoutUpdatedSignalBody{
				Revision: v0,
				Parent:   v1,
			},
		}, nil
	case InterfaceDbusmenu + "." + "ItemActivationRequested":
		v0, ok := signal.Body[0].(int32)
		if !ok {
			return nil, fmt.Errorf("prop .Id is %T, not int32", signal.Body[0])
		}
		v1, ok := signal.Body[1].(uint32)
		if !ok {
			return nil, fmt.Errorf("prop .Timestamp is %T, not uint32", signal.Body[1])
		}
		return &Dbusmenu_ItemActivationRequestedSignal{
			sender: signal.Sender,
			Path:   signal.Path,
			Body: &Dbusmenu_ItemActivationRequestedSignalBody{
				Id:        v0,
				Timestamp: v1,
			},
		}, nil
	default:
		return nil, ErrUnknownSignal
	}
}

// AddMatchSignal registers a match rule for the given signal,
// opts are appended to the automatically generated signal's rules.
func AddMatchSignal(conn *dbus.Conn, s Signal, opts ...dbus.MatchOption) error {
	return conn.AddMatchSignal(append([]dbus.MatchOption{
		dbus.WithMatchInterface(s.Interface()),
		dbus.WithMatchMember(s.Name()),
	}, opts...)...)
}

// RemoveMatchSignal unregisters the previously registered subscription.
func RemoveMatchSignal(conn *dbus.Conn, s Signal, opts ...dbus.MatchOption) error {
	return conn.RemoveMatchSignal(append([]dbus.MatchOption{
		dbus.WithMatchInterface(s.Interface()),
		dbus.WithMatchMember(s.Name()),
	}, opts...)...)
}

// Interface name constants.
const (
	InterfaceDbusmenu = "com.canonical.dbusmenu"
)

// Dbusmenuer is com.canonical.dbusmenu interface.
type Dbusmenuer interface {
	// GetLayout is com.canonical.dbusmenu.GetLayout method.
	GetLayout(parentId int32, recursionDepth int32, propertyNames []string) (revision uint32, layout struct {
		V0 int32
		V1 map[string]dbus.Variant
		V2 []dbus.Variant
	}, err *dbus.Error)
	// GetGroupProperties is com.canonical.dbusmenu.GetGroupProperties method.
	GetGroupProperties(ids []int32, propertyNames []string) (properties []struct {
		V0 int32
		V1 map[string]dbus.Variant
	}, err *dbus.Error)
	// GetProperty is com.canonical.dbusmenu.GetProperty method.
	GetProperty(id int32, name string) (value dbus.Variant, err *dbus.Error)
	// Event is com.canonical.dbusmenu.Event method.
	Event(id int32, eventId string, data dbus.Variant, timestamp uint32) (err *dbus.Error)
	// EventGroup is com.canonical.dbusmenu.EventGroup method.
	EventGroup(events []struct {
		V0 int32
		V1 string
		V2 dbus.Variant
		V3 uint32
	}) (idErrors []int32, err *dbus.Error)
	// AboutToShow is com.canonical.dbusmenu.AboutToShow method.
	AboutToShow(id int32) (needUpdate bool, err *dbus.Error)
	// AboutToShowGroup is com.canonical.dbusmenu.AboutToShowGroup method.
	AboutToShowGroup(ids []int32) (updatesNeeded []int32, idErrors []int32, err *dbus.Error)
}

// ExportDbusmenu exports the given object that implements com.canonical.dbusmenu on the bus.
func ExportDbusmenu(conn *dbus.Conn, path dbus.ObjectPath, v Dbusmenuer) error {
	return conn.ExportSubtreeMethodTable(map[string]interface{}{
		"GetLayout":          v.GetLayout,
		"GetGroupProperties": v.GetGroupProperties,
		"GetProperty":        v.GetProperty,
		"Event":              v.Event,
		"EventGroup":         v.EventGroup,
		"AboutToShow":        v.AboutToShow,
		"AboutToShowGroup":   v.AboutToShowGroup,
	}, path, InterfaceDbusmenu)
}

// UnexportDbusmenu unexports com.canonical.dbusmenu interface on the named path.
func UnexportDbusmenu(conn *dbus.Conn, path dbus.ObjectPath) error {
	return conn.Export(nil, path, InterfaceDbusmenu)
}

// UnimplementedDbusmenu can be embedded to have forward compatible server implementations.
type UnimplementedDbusmenu struct{}

func (*UnimplementedDbusmenu) iface() string {
	return InterfaceDbusmenu
}

func (*UnimplementedDbusmenu) GetLayout(parentId int32, recursionDepth int32, propertyNames []string) (revision uint32, layout struct {
	V0 int32
	V1 map[string]dbus.Variant
	V2 []dbus.Variant
}, err *dbus.Error) {
	err = &dbus.ErrMsgUnknownMethod
	return
}

func (*UnimplementedDbusmenu) GetGroupProperties(ids []int32, propertyNames []string) (properties []struct {
	V0 int32
	V1 map[string]dbus.Variant
}, err *dbus.Error) {
	err = &dbus.ErrMsgUnknownMethod
	return
}

func (*UnimplementedDbusmenu) GetProperty(id int32, name string) (value dbus.Variant, err *dbus.Error) {
	err = &dbus.ErrMsgUnknownMethod
	return
}

func (*UnimplementedDbusmenu) Event(id int32, eventId string, data dbus.Variant, timestamp uint32) (err *dbus.Error) {
	err = &dbus.ErrMsgUnknownMethod
	return
}

func (*UnimplementedDbusmenu) EventGroup(events []struct {
	V0 int32
	V1 string
	V2 dbus.Variant
	V3 uint32
}) (idErrors []int32, err *dbus.Error) {
	err = &dbus.ErrMsgUnknownMethod
	return
}

func (*UnimplementedDbusmenu) AboutToShow(id int32) (needUpdate bool, err *dbus.Error) {
	err = &dbus.ErrMsgUnknownMethod
	return
}

func (*UnimplementedDbusmenu) AboutToShowGroup(ids []int32) (updatesNeeded []int32, idErrors []int32, err *dbus.Error) {
	err = &dbus.ErrMsgUnknownMethod
	return
}

// NewDbusmenu creates and allocates com.canonical.dbusmenu.
func NewDbusmenu(object dbus.BusObject) *Dbusmenu {
	return &Dbusmenu{object}
}

// Dbusmenu implements com.canonical.dbusmenu D-Bus interface.
type Dbusmenu struct {
	object dbus.BusObject
}

// GetLayout calls com.canonical.dbusmenu.GetLayout method.
func (o *Dbusmenu) GetLayout(ctx context.Context, parentId int32, recursionDepth int32, propertyNames []string) (revision uint32, layout struct {
	V0 int32
	V1 map[string]dbus.Variant
	V2 []dbus.Variant
}, err error) {
	err = o.object.CallWithContext(ctx, InterfaceDbusmenu+".GetLayout", 0, parentId, recursionDepth, propertyNames).Store(&revision, &layout)
	return
}

// GetGroupProperties calls com.canonical.dbusmenu.GetGroupProperties method.
func (o *Dbusmenu) GetGroupProperties(ctx context.Context, ids []int32, propertyNames []string) (properties []struct {
	V0 int32
	V1 map[string]dbus.Variant
}, err error) {
	err = o.object.CallWithContext(ctx, InterfaceDbusmenu+".GetGroupProperties", 0, ids, propertyNames).Store(&properties)
	return
}

// GetProperty calls com.canonical.dbusmenu.GetProperty method.
func (o *Dbusmenu) GetProperty(ctx context.Context, id int32, name string) (value dbus.Variant, err error) {
	err = o.object.CallWithContext(ctx, InterfaceDbusmenu+".GetProperty", 0, id, name).Store(&value)
	return
}

// Event calls com.canonical.dbusmenu.Event method.
func (o *Dbusmenu) Event(ctx context.Context, id int32, eventId string, data dbus.Variant, timestamp uint32) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDbusmenu+".Event", 0, id, eventId, data, timestamp).Store()
	return
}

// EventGroup calls com.canonical.dbusmenu.EventGroup method.
func (o *Dbusmenu) EventGroup(ctx context.Context, events []struct {
	V0 int32
	V1 string
	V2 dbus.Variant
	V3 uint32
}) (idErrors []int32, err error) {
	err = o.object.CallWithContext(ctx, InterfaceDbusmenu+".EventGroup", 0, events).Store(&idErrors)
	return
}

// AboutToShow calls com.canonical.dbusmenu.AboutToShow method.
func (o *Dbusmenu) AboutToShow(ctx context.Context, id int32) (needUpdate bool, err error) {
	err = o.object.CallWithContext(ctx, InterfaceDbusmenu+".AboutToShow", 0, id).Store(&needUpdate)
	return
}

// AboutToShowGroup calls com.canonical.dbusmenu.AboutToShowGroup method.
func (o *Dbusmenu) AboutToShowGroup(ctx context.Context, ids []int32) (updatesNeeded []int32, idErrors []int32, err error) {
	err = o.object.CallWithContext(ctx, InterfaceDbusmenu+".AboutToShowGroup", 0, ids).Store(&updatesNeeded, &idErrors)
	return
}

// GetVersion gets com.canonical.dbusmenu.Version property.
func (o *Dbusmenu) GetVersion(ctx context.Context) (version uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDbusmenu, "Version").Store(&version)
	return
}

// GetTextDirection gets com.canonical.dbusmenu.TextDirection property.
func (o *Dbusmenu) GetTextDirection(ctx context.Context) (textDirection string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDbusmenu, "TextDirection").Store(&textDirection)
	return
}

// GetStatus gets com.canonical.dbusmenu.Status property.
func (o *Dbusmenu) GetStatus(ctx context.Context) (status string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDbusmenu, "Status").Store(&status)
	return
}

// GetIconThemePath gets com.canonical.dbusmenu.IconThemePath property.
func (o *Dbusmenu) GetIconThemePath(ctx context.Context) (iconThemePath []string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDbusmenu, "IconThemePath").Store(&iconThemePath)
	return
}

// Dbusmenu_ItemsPropertiesUpdatedSignal represents com.canonical.dbusmenu.ItemsPropertiesUpdated signal.
type Dbusmenu_ItemsPropertiesUpdatedSignal struct {
	sender string
	Path   dbus.ObjectPath
	Body   *Dbusmenu_ItemsPropertiesUpdatedSignalBody
}

// Name returns the signal's name.
func (s *Dbusmenu_ItemsPropertiesUpdatedSignal) Name() string {
	return "ItemsPropertiesUpdated"
}

// Interface returns the signal's interface.
func (s *Dbusmenu_ItemsPropertiesUpdatedSignal) Interface() string {
	return InterfaceDbusmenu
}

// Sender returns the signal's sender unique name.
func (s *Dbusmenu_ItemsPropertiesUpdatedSignal) Sender() string {
	return s.sender
}

func (s *Dbusmenu_ItemsPropertiesUpdatedSignal) path() dbus.ObjectPath {
	return s.Path
}

func (s *Dbusmenu_ItemsPropertiesUpdatedSignal) values() []interface{} {
	return []interface{}{s.Body.UpdatedProps, s.Body.RemovedProps}
}

// Dbusmenu_ItemsPropertiesUpdatedSignalBody is body container.
type Dbusmenu_ItemsPropertiesUpdatedSignalBody struct {
	UpdatedProps []struct {
		V0 int32
		V1 map[string]dbus.Variant
	}
	RemovedProps []struct {
		V0 int32
		V1 []string
	}
}

// Dbusmenu_LayoutUpdatedSignal represents com.canonical.dbusmenu.LayoutUpdated signal.
type Dbusmenu_LayoutUpdatedSignal struct {
	sender string
	Path   dbus.ObjectPath
	Body   *Dbusmenu_LayoutUpdatedSignalBody
}

// Name returns the signal's name.
func (s *Dbusmenu_LayoutUpdatedSignal) Name() string {
	return "LayoutUpdated"
}

// Interface returns the signal's interface.
func (s *Dbusmenu_LayoutUpdatedSignal) Interface() string {
	return InterfaceDbusmenu
}

// Sender returns the signal's sender unique name.
func (s *Dbusmenu_LayoutUpdatedSignal) Sender() string {
	return s.sender
}

func (s *Dbusmenu_LayoutUpdatedSignal) path() dbus.ObjectPath {
	return s.Path
}

func (s *Dbusmenu_LayoutUpdatedSignal) values() []interface{} {
	return []interface{}{s.Body.Revision, s.Body.Parent}
}

// Dbusmenu_LayoutUpdatedSignalBody is body container.
type Dbusmenu_LayoutUpdatedSignalBody struct {
	Revision uint32
	Parent   int32
}

// Dbusmenu_ItemActivationRequestedSignal represents com.canonical.dbusmenu.ItemActivationRequested signal.
type Dbusmenu_ItemActivationRequestedSignal struct {
	sender string
	Path   dbus.ObjectPath
	Body   *Dbusmenu_ItemActivationRequestedSignalBody
}

// Name returns the signal's name.
func (s *Dbusmenu_ItemActivationRequestedSignal) Name() string {
	return "ItemActivationRequested"
}

// Interface returns the signal's interface.
func (s *Dbusmenu_ItemActivationRequestedSignal) Interface() string {
	return InterfaceDbusmenu
}

// Sender returns the signal's sender unique name.
func (s *Dbusmenu_ItemActivationRequestedSignal) Sender() string {
	return s.sender
}

func (s *Dbusmenu_ItemActivationRequestedSignal) path() dbus.ObjectPath {
	return s.Path
}

func (s *Dbusmenu_ItemActivationRequestedSignal) values() []interface{} {
	return []interface{}{s.Body.Id, s.Body.Timestamp}
}

// Dbusmenu_ItemActivationRequestedSignalBody is body container.
type Dbusmenu_ItemActivationRequestedSignalBody struct {
	Id        int32
	Timestamp uint32
}
