#!/bin/sh

# This test checks that the shebang handling for rq is working correctly,
# meaning that if the first argument is an extant file, it should imply rq
# script unless it is the name of a subcommand.

set -e
set -u
set -x

echo "checking that we can run a script at all ..."
OUT="$("$RQ" script ./script.rego)"
if [ "$OUT" != "bar" ] ; then
	printf "expected output 'bar' but got:\n%s\n" "$OUT"
	exit 1
fi
unset OUT

echo "checking that an extant file implies the script subcommand..."
OUT="$("$RQ" ./script.rego)"
if [ "$OUT" != "bar" ] ; then
	printf "expected output 'bar' but got:\n%s\n" "$OUT"
	exit 1
fi
unset OUT

echo "checking that rq query takes precedence of a file named 'query'"
OUT="$("$RQ" query '"foo"')"
if [ "$OUT" != "\"foo\"" ] ; then
	printf "expected output '\"foo\"' but got:\n%s\n" "$OUT"
	exit 1
fi
unset OUT

echo "checking that rq query takes precedence of a file named 'list-formats'"
OUT="$("$RQ" list-formats)"
if [ "$(echo "$OUT" | wc -l)" -lt 5 ] ; then
	printf "output shorter than 5 lines, this is probably not a correct list-formats result...\n%s\n" "$OUT"
	exit 1
fi
unset OUT
