package managementgroupsapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2018-01-01-preview/managementgroups"
	"github.com/Azure/go-autorest/autorest"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	CheckNameAvailability(ctx context.Context, checkNameAvailabilityRequest managementgroups.CheckNameAvailabilityRequest) (result managementgroups.CheckNameAvailabilityResult, err error)
}

var _ BaseClientAPI = (*managementgroups.BaseClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	CreateOrUpdate(ctx context.Context, groupID string, createManagementGroupRequest managementgroups.CreateManagementGroupRequest, cacheControl string) (result managementgroups.CreateOrUpdateFuture, err error)
	Delete(ctx context.Context, groupID string, cacheControl string) (result managementgroups.DeleteFuture, err error)
	Get(ctx context.Context, groupID string, expand string, recurse *bool, filter string, cacheControl string) (result managementgroups.ManagementGroup, err error)
	List(ctx context.Context, cacheControl string) (result managementgroups.ListResultPage, err error)
	ListComplete(ctx context.Context, cacheControl string) (result managementgroups.ListResultIterator, err error)
	Update(ctx context.Context, groupID string, patchGroupRequest managementgroups.PatchManagementGroupRequest, cacheControl string) (result managementgroups.ManagementGroup, err error)
}

var _ ClientAPI = (*managementgroups.Client)(nil)

// SubscriptionsClientAPI contains the set of methods on the SubscriptionsClient type.
type SubscriptionsClientAPI interface {
	Create(ctx context.Context, groupID string, subscriptionID string, cacheControl string) (result autorest.Response, err error)
	Delete(ctx context.Context, groupID string, subscriptionID string, cacheControl string) (result autorest.Response, err error)
}

var _ SubscriptionsClientAPI = (*managementgroups.SubscriptionsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result managementgroups.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result managementgroups.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*managementgroups.OperationsClient)(nil)

// EntitiesClientAPI contains the set of methods on the EntitiesClient type.
type EntitiesClientAPI interface {
	List(ctx context.Context, groupName string, cacheControl string) (result managementgroups.EntityListResultPage, err error)
	ListComplete(ctx context.Context, groupName string, cacheControl string) (result managementgroups.EntityListResultIterator, err error)
}

var _ EntitiesClientAPI = (*managementgroups.EntitiesClient)(nil)
