package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDasPro invokes the das.EnableDasPro API synchronously
func (client *Client) EnableDasPro(request *EnableDasProRequest) (response *EnableDasProResponse, err error) {
	response = CreateEnableDasProResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDasProWithChan invokes the das.EnableDasPro API asynchronously
func (client *Client) EnableDasProWithChan(request *EnableDasProRequest) (<-chan *EnableDasProResponse, <-chan error) {
	responseChan := make(chan *EnableDasProResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDasPro(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDasProWithCallback invokes the das.EnableDasPro API asynchronously
func (client *Client) EnableDasProWithCallback(request *EnableDasProRequest, callback func(response *EnableDasProResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDasProResponse
		var err error
		defer close(result)
		response, err = client.EnableDasPro(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDasProRequest is the request struct for api EnableDasPro
type EnableDasProRequest struct {
	*requests.RpcRequest
	SqlRetention requests.Integer `position:"Query" name:"SqlRetention"`
	UserId       string           `position:"Query" name:"UserId"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
}

// EnableDasProResponse is the response struct for api EnableDasPro
type EnableDasProResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateEnableDasProRequest creates a request to invoke EnableDasPro API
func CreateEnableDasProRequest() (request *EnableDasProRequest) {
	request = &EnableDasProRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "EnableDasPro", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableDasProResponse creates a response to parse from EnableDasPro response
func CreateEnableDasProResponse() (response *EnableDasProResponse) {
	response = &EnableDasProResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
