package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EstablishRelationTableToBusiness invokes the dataworks_public.EstablishRelationTableToBusiness API synchronously
func (client *Client) EstablishRelationTableToBusiness(request *EstablishRelationTableToBusinessRequest) (response *EstablishRelationTableToBusinessResponse, err error) {
	response = CreateEstablishRelationTableToBusinessResponse()
	err = client.DoAction(request, response)
	return
}

// EstablishRelationTableToBusinessWithChan invokes the dataworks_public.EstablishRelationTableToBusiness API asynchronously
func (client *Client) EstablishRelationTableToBusinessWithChan(request *EstablishRelationTableToBusinessRequest) (<-chan *EstablishRelationTableToBusinessResponse, <-chan error) {
	responseChan := make(chan *EstablishRelationTableToBusinessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EstablishRelationTableToBusiness(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EstablishRelationTableToBusinessWithCallback invokes the dataworks_public.EstablishRelationTableToBusiness API asynchronously
func (client *Client) EstablishRelationTableToBusinessWithCallback(request *EstablishRelationTableToBusinessRequest, callback func(response *EstablishRelationTableToBusinessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EstablishRelationTableToBusinessResponse
		var err error
		defer close(result)
		response, err = client.EstablishRelationTableToBusiness(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EstablishRelationTableToBusinessRequest is the request struct for api EstablishRelationTableToBusiness
type EstablishRelationTableToBusinessRequest struct {
	*requests.RpcRequest
	TableGuid         string           `position:"Body" name:"TableGuid"`
	BusinessId        string           `position:"Body" name:"BusinessId"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	ProjectIdentifier string           `position:"Body" name:"ProjectIdentifier"`
	FolderId          string           `position:"Body" name:"FolderId"`
}

// EstablishRelationTableToBusinessResponse is the response struct for api EstablishRelationTableToBusiness
type EstablishRelationTableToBusinessResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateEstablishRelationTableToBusinessRequest creates a request to invoke EstablishRelationTableToBusiness API
func CreateEstablishRelationTableToBusinessRequest() (request *EstablishRelationTableToBusinessRequest) {
	request = &EstablishRelationTableToBusinessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "EstablishRelationTableToBusiness", "", "")
	request.Method = requests.POST
	return
}

// CreateEstablishRelationTableToBusinessResponse creates a response to parse from EstablishRelationTableToBusiness response
func CreateEstablishRelationTableToBusinessResponse() (response *EstablishRelationTableToBusinessResponse) {
	response = &EstablishRelationTableToBusinessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
