package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIpSets invokes the ga.UpdateIpSets API synchronously
func (client *Client) UpdateIpSets(request *UpdateIpSetsRequest) (response *UpdateIpSetsResponse, err error) {
	response = CreateUpdateIpSetsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateIpSetsWithChan invokes the ga.UpdateIpSets API asynchronously
func (client *Client) UpdateIpSetsWithChan(request *UpdateIpSetsRequest) (<-chan *UpdateIpSetsResponse, <-chan error) {
	responseChan := make(chan *UpdateIpSetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIpSets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateIpSetsWithCallback invokes the ga.UpdateIpSets API asynchronously
func (client *Client) UpdateIpSetsWithCallback(request *UpdateIpSetsRequest, callback func(response *UpdateIpSetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateIpSetsResponse
		var err error
		defer close(result)
		response, err = client.UpdateIpSets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateIpSetsRequest is the request struct for api UpdateIpSets
type UpdateIpSetsRequest struct {
	*requests.RpcRequest
	IpSets *[]UpdateIpSetsIpSets `position:"Query" name:"IpSets"  type:"Repeated"`
}

// UpdateIpSetsIpSets is a repeated param struct in UpdateIpSetsRequest
type UpdateIpSetsIpSets struct {
	Bandwidth string `name:"Bandwidth"`
	IpSetId   string `name:"IpSetId"`
}

// UpdateIpSetsResponse is the response struct for api UpdateIpSets
type UpdateIpSetsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateIpSetsRequest creates a request to invoke UpdateIpSets API
func CreateUpdateIpSetsRequest() (request *UpdateIpSetsRequest) {
	request = &UpdateIpSetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "UpdateIpSets", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateIpSetsResponse creates a response to parse from UpdateIpSets response
func CreateUpdateIpSetsResponse() (response *UpdateIpSetsResponse) {
	response = &UpdateIpSetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
