package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGatewayPacketStat invokes the linkwan.GetGatewayPacketStat API synchronously
func (client *Client) GetGatewayPacketStat(request *GetGatewayPacketStatRequest) (response *GetGatewayPacketStatResponse, err error) {
	response = CreateGetGatewayPacketStatResponse()
	err = client.DoAction(request, response)
	return
}

// GetGatewayPacketStatWithChan invokes the linkwan.GetGatewayPacketStat API asynchronously
func (client *Client) GetGatewayPacketStatWithChan(request *GetGatewayPacketStatRequest) (<-chan *GetGatewayPacketStatResponse, <-chan error) {
	responseChan := make(chan *GetGatewayPacketStatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGatewayPacketStat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGatewayPacketStatWithCallback invokes the linkwan.GetGatewayPacketStat API asynchronously
func (client *Client) GetGatewayPacketStatWithCallback(request *GetGatewayPacketStatRequest, callback func(response *GetGatewayPacketStatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGatewayPacketStatResponse
		var err error
		defer close(result)
		response, err = client.GetGatewayPacketStat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGatewayPacketStatRequest is the request struct for api GetGatewayPacketStat
type GetGatewayPacketStatRequest struct {
	*requests.RpcRequest
	EndMillis     requests.Integer `position:"Query" name:"EndMillis"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	GwEui         string           `position:"Query" name:"GwEui"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	BeginMillis   requests.Integer `position:"Query" name:"BeginMillis"`
}

// GetGatewayPacketStatResponse is the response struct for api GetGatewayPacketStat
type GetGatewayPacketStatResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetGatewayPacketStatRequest creates a request to invoke GetGatewayPacketStat API
func CreateGetGatewayPacketStatRequest() (request *GetGatewayPacketStatRequest) {
	request = &GetGatewayPacketStatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetGatewayPacketStat", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetGatewayPacketStatResponse creates a response to parse from GetGatewayPacketStat response
func CreateGetGatewayPacketStatResponse() (response *GetGatewayPacketStatResponse) {
	response = &GetGatewayPacketStatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
