package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGatewayTupleOrder invokes the linkwan.GetGatewayTupleOrder API synchronously
func (client *Client) GetGatewayTupleOrder(request *GetGatewayTupleOrderRequest) (response *GetGatewayTupleOrderResponse, err error) {
	response = CreateGetGatewayTupleOrderResponse()
	err = client.DoAction(request, response)
	return
}

// GetGatewayTupleOrderWithChan invokes the linkwan.GetGatewayTupleOrder API asynchronously
func (client *Client) GetGatewayTupleOrderWithChan(request *GetGatewayTupleOrderRequest) (<-chan *GetGatewayTupleOrderResponse, <-chan error) {
	responseChan := make(chan *GetGatewayTupleOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGatewayTupleOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGatewayTupleOrderWithCallback invokes the linkwan.GetGatewayTupleOrder API asynchronously
func (client *Client) GetGatewayTupleOrderWithCallback(request *GetGatewayTupleOrderRequest, callback func(response *GetGatewayTupleOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGatewayTupleOrderResponse
		var err error
		defer close(result)
		response, err = client.GetGatewayTupleOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGatewayTupleOrderRequest is the request struct for api GetGatewayTupleOrder
type GetGatewayTupleOrderRequest struct {
	*requests.RpcRequest
	OrderId     string `position:"Query" name:"OrderId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// GetGatewayTupleOrderResponse is the response struct for api GetGatewayTupleOrder
type GetGatewayTupleOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetGatewayTupleOrderRequest creates a request to invoke GetGatewayTupleOrder API
func CreateGetGatewayTupleOrderRequest() (request *GetGatewayTupleOrderRequest) {
	request = &GetGatewayTupleOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetGatewayTupleOrder", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetGatewayTupleOrderResponse creates a response to parse from GetGatewayTupleOrder response
func CreateGetGatewayTupleOrderResponse() (response *GetGatewayTupleOrderResponse) {
	response = &GetGatewayTupleOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
