package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCasterRtcInfo invokes the live.DescribeCasterRtcInfo API synchronously
func (client *Client) DescribeCasterRtcInfo(request *DescribeCasterRtcInfoRequest) (response *DescribeCasterRtcInfoResponse, err error) {
	response = CreateDescribeCasterRtcInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCasterRtcInfoWithChan invokes the live.DescribeCasterRtcInfo API asynchronously
func (client *Client) DescribeCasterRtcInfoWithChan(request *DescribeCasterRtcInfoRequest) (<-chan *DescribeCasterRtcInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeCasterRtcInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCasterRtcInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCasterRtcInfoWithCallback invokes the live.DescribeCasterRtcInfo API asynchronously
func (client *Client) DescribeCasterRtcInfoWithCallback(request *DescribeCasterRtcInfoRequest, callback func(response *DescribeCasterRtcInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCasterRtcInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeCasterRtcInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCasterRtcInfoRequest is the request struct for api DescribeCasterRtcInfo
type DescribeCasterRtcInfoRequest struct {
	*requests.RpcRequest
	CasterId string           `position:"Query" name:"CasterId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCasterRtcInfoResponse is the response struct for api DescribeCasterRtcInfo
type DescribeCasterRtcInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CasterId  string `json:"CasterId" xml:"CasterId"`
	AuthToken string `json:"AuthToken" xml:"AuthToken"`
}

// CreateDescribeCasterRtcInfoRequest creates a request to invoke DescribeCasterRtcInfo API
func CreateDescribeCasterRtcInfoRequest() (request *DescribeCasterRtcInfoRequest) {
	request = &DescribeCasterRtcInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeCasterRtcInfo", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCasterRtcInfoResponse creates a response to parse from DescribeCasterRtcInfo response
func CreateDescribeCasterRtcInfoResponse() (response *DescribeCasterRtcInfoResponse) {
	response = &DescribeCasterRtcInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
