package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOperatorByRole invokes the oam.ListOperatorByRole API synchronously
// api document: https://help.aliyun.com/api/oam/listoperatorbyrole.html
func (client *Client) ListOperatorByRole(request *ListOperatorByRoleRequest) (response *ListOperatorByRoleResponse, err error) {
	response = CreateListOperatorByRoleResponse()
	err = client.DoAction(request, response)
	return
}

// ListOperatorByRoleWithChan invokes the oam.ListOperatorByRole API asynchronously
// api document: https://help.aliyun.com/api/oam/listoperatorbyrole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListOperatorByRoleWithChan(request *ListOperatorByRoleRequest) (<-chan *ListOperatorByRoleResponse, <-chan error) {
	responseChan := make(chan *ListOperatorByRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOperatorByRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOperatorByRoleWithCallback invokes the oam.ListOperatorByRole API asynchronously
// api document: https://help.aliyun.com/api/oam/listoperatorbyrole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListOperatorByRoleWithCallback(request *ListOperatorByRoleRequest, callback func(response *ListOperatorByRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOperatorByRoleResponse
		var err error
		defer close(result)
		response, err = client.ListOperatorByRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOperatorByRoleRequest is the request struct for api ListOperatorByRole
type ListOperatorByRoleRequest struct {
	*requests.RpcRequest
	RoleName  string           `position:"Query" name:"RoleName"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
}

// ListOperatorByRoleResponse is the response struct for api ListOperatorByRole
type ListOperatorByRoleResponse struct {
	*responses.BaseResponse
	Code     string                   `json:"Code" xml:"Code"`
	Message  string                   `json:"Message" xml:"Message"`
	PageInfo PageInfo                 `json:"PageInfo" xml:"PageInfo"`
	Data     DataInListOperatorByRole `json:"Data" xml:"Data"`
}

// CreateListOperatorByRoleRequest creates a request to invoke ListOperatorByRole API
func CreateListOperatorByRoleRequest() (request *ListOperatorByRoleRequest) {
	request = &ListOperatorByRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ListOperatorByRole", "", "")
	request.Method = requests.POST
	return
}

// CreateListOperatorByRoleResponse creates a response to parse from ListOperatorByRole response
func CreateListOperatorByRoleResponse() (response *ListOperatorByRoleResponse) {
	response = &ListOperatorByRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
