package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSyncEcsHostTask invokes the pvtz.DescribeSyncEcsHostTask API synchronously
func (client *Client) DescribeSyncEcsHostTask(request *DescribeSyncEcsHostTaskRequest) (response *DescribeSyncEcsHostTaskResponse, err error) {
	response = CreateDescribeSyncEcsHostTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSyncEcsHostTaskWithChan invokes the pvtz.DescribeSyncEcsHostTask API asynchronously
func (client *Client) DescribeSyncEcsHostTaskWithChan(request *DescribeSyncEcsHostTaskRequest) (<-chan *DescribeSyncEcsHostTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeSyncEcsHostTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSyncEcsHostTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSyncEcsHostTaskWithCallback invokes the pvtz.DescribeSyncEcsHostTask API asynchronously
func (client *Client) DescribeSyncEcsHostTaskWithCallback(request *DescribeSyncEcsHostTaskRequest, callback func(response *DescribeSyncEcsHostTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSyncEcsHostTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeSyncEcsHostTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSyncEcsHostTaskRequest is the request struct for api DescribeSyncEcsHostTask
type DescribeSyncEcsHostTaskRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	ZoneId       string `position:"Query" name:"ZoneId"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeSyncEcsHostTaskResponse is the response struct for api DescribeSyncEcsHostTask
type DescribeSyncEcsHostTaskResponse struct {
	*responses.BaseResponse
	Status     string                           `json:"Status" xml:"Status"`
	ZoneId     string                           `json:"ZoneId" xml:"ZoneId"`
	RequestId  string                           `json:"RequestId" xml:"RequestId"`
	Success    bool                             `json:"Success" xml:"Success"`
	Regions    RegionsInDescribeSyncEcsHostTask `json:"Regions" xml:"Regions"`
	EcsRegions EcsRegions                       `json:"EcsRegions" xml:"EcsRegions"`
}

// CreateDescribeSyncEcsHostTaskRequest creates a request to invoke DescribeSyncEcsHostTask API
func CreateDescribeSyncEcsHostTaskRequest() (request *DescribeSyncEcsHostTaskRequest) {
	request = &DescribeSyncEcsHostTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeSyncEcsHostTask", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSyncEcsHostTaskResponse creates a response to parse from DescribeSyncEcsHostTask response
func CreateDescribeSyncEcsHostTaskResponse() (response *DescribeSyncEcsHostTaskResponse) {
	response = &DescribeSyncEcsHostTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
