package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserToken invokes the scsp.GetUserToken API synchronously
func (client *Client) GetUserToken(request *GetUserTokenRequest) (response *GetUserTokenResponse, err error) {
	response = CreateGetUserTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserTokenWithChan invokes the scsp.GetUserToken API asynchronously
func (client *Client) GetUserTokenWithChan(request *GetUserTokenRequest) (<-chan *GetUserTokenResponse, <-chan error) {
	responseChan := make(chan *GetUserTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserTokenWithCallback invokes the scsp.GetUserToken API asynchronously
func (client *Client) GetUserTokenWithCallback(request *GetUserTokenRequest, callback func(response *GetUserTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserTokenResponse
		var err error
		defer close(result)
		response, err = client.GetUserToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserTokenRequest is the request struct for api GetUserToken
type GetUserTokenRequest struct {
	*requests.RpcRequest
	Nick       string `position:"Body"`
	InstanceId string `position:"Body"`
	AppKey     string `position:"Body"`
	UserId     string `position:"Body"`
}

// GetUserTokenResponse is the response struct for api GetUserToken
type GetUserTokenResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetUserTokenRequest creates a request to invoke GetUserToken API
func CreateGetUserTokenRequest() (request *GetUserTokenRequest) {
	request = &GetUserTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetUserToken", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUserTokenResponse creates a response to parse from GetUserToken response
func CreateGetUserTokenResponse() (response *GetUserTokenResponse) {
	response = &GetUserTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
