package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AuditTTSVoice invokes the voicenavigator.AuditTTSVoice API synchronously
func (client *Client) AuditTTSVoice(request *AuditTTSVoiceRequest) (response *AuditTTSVoiceResponse, err error) {
	response = CreateAuditTTSVoiceResponse()
	err = client.DoAction(request, response)
	return
}

// AuditTTSVoiceWithChan invokes the voicenavigator.AuditTTSVoice API asynchronously
func (client *Client) AuditTTSVoiceWithChan(request *AuditTTSVoiceRequest) (<-chan *AuditTTSVoiceResponse, <-chan error) {
	responseChan := make(chan *AuditTTSVoiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AuditTTSVoice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AuditTTSVoiceWithCallback invokes the voicenavigator.AuditTTSVoice API asynchronously
func (client *Client) AuditTTSVoiceWithCallback(request *AuditTTSVoiceRequest, callback func(response *AuditTTSVoiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AuditTTSVoiceResponse
		var err error
		defer close(result)
		response, err = client.AuditTTSVoice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AuditTTSVoiceRequest is the request struct for api AuditTTSVoice
type AuditTTSVoiceRequest struct {
	*requests.RpcRequest
	Voice      string `position:"Query" name:"Voice"`
	Volume     string `position:"Query" name:"Volume"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Text       string `position:"Query" name:"Text"`
	SpeechRate string `position:"Query" name:"SpeechRate"`
}

// AuditTTSVoiceResponse is the response struct for api AuditTTSVoice
type AuditTTSVoiceResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	AuditionUrl string `json:"AuditionUrl" xml:"AuditionUrl"`
}

// CreateAuditTTSVoiceRequest creates a request to invoke AuditTTSVoice API
func CreateAuditTTSVoiceRequest() (request *AuditTTSVoiceRequest) {
	request = &AuditTTSVoiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "AuditTTSVoice", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAuditTTSVoiceResponse creates a response to parse from AuditTTSVoice response
func CreateAuditTTSVoiceResponse() (response *AuditTTSVoiceResponse) {
	response = &AuditTTSVoiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
