// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemakergeospatial

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteEarthObservationJob = "DeleteEarthObservationJob"

// DeleteEarthObservationJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEarthObservationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEarthObservationJob for more information on using the DeleteEarthObservationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEarthObservationJobRequest method.
//	req, resp := client.DeleteEarthObservationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/DeleteEarthObservationJob
func (c *SageMakerGeospatial) DeleteEarthObservationJobRequest(input *DeleteEarthObservationJobInput) (req *request.Request, output *DeleteEarthObservationJobOutput) {
	op := &request.Operation{
		Name:       opDeleteEarthObservationJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/earth-observation-jobs/{Arn}",
	}

	if input == nil {
		input = &DeleteEarthObservationJobInput{}
	}

	output = &DeleteEarthObservationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEarthObservationJob API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to delete an Earth Observation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation DeleteEarthObservationJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/DeleteEarthObservationJob
func (c *SageMakerGeospatial) DeleteEarthObservationJob(input *DeleteEarthObservationJobInput) (*DeleteEarthObservationJobOutput, error) {
	req, out := c.DeleteEarthObservationJobRequest(input)
	return out, req.Send()
}

// DeleteEarthObservationJobWithContext is the same as DeleteEarthObservationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEarthObservationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) DeleteEarthObservationJobWithContext(ctx aws.Context, input *DeleteEarthObservationJobInput, opts ...request.Option) (*DeleteEarthObservationJobOutput, error) {
	req, out := c.DeleteEarthObservationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVectorEnrichmentJob = "DeleteVectorEnrichmentJob"

// DeleteVectorEnrichmentJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVectorEnrichmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVectorEnrichmentJob for more information on using the DeleteVectorEnrichmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVectorEnrichmentJobRequest method.
//	req, resp := client.DeleteVectorEnrichmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/DeleteVectorEnrichmentJob
func (c *SageMakerGeospatial) DeleteVectorEnrichmentJobRequest(input *DeleteVectorEnrichmentJobInput) (req *request.Request, output *DeleteVectorEnrichmentJobOutput) {
	op := &request.Operation{
		Name:       opDeleteVectorEnrichmentJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/vector-enrichment-jobs/{Arn}",
	}

	if input == nil {
		input = &DeleteVectorEnrichmentJobInput{}
	}

	output = &DeleteVectorEnrichmentJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVectorEnrichmentJob API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to delete a Vector Enrichment job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation DeleteVectorEnrichmentJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/DeleteVectorEnrichmentJob
func (c *SageMakerGeospatial) DeleteVectorEnrichmentJob(input *DeleteVectorEnrichmentJobInput) (*DeleteVectorEnrichmentJobOutput, error) {
	req, out := c.DeleteVectorEnrichmentJobRequest(input)
	return out, req.Send()
}

// DeleteVectorEnrichmentJobWithContext is the same as DeleteVectorEnrichmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVectorEnrichmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) DeleteVectorEnrichmentJobWithContext(ctx aws.Context, input *DeleteVectorEnrichmentJobInput, opts ...request.Option) (*DeleteVectorEnrichmentJobOutput, error) {
	req, out := c.DeleteVectorEnrichmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportEarthObservationJob = "ExportEarthObservationJob"

// ExportEarthObservationJobRequest generates a "aws/request.Request" representing the
// client's request for the ExportEarthObservationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportEarthObservationJob for more information on using the ExportEarthObservationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportEarthObservationJobRequest method.
//	req, resp := client.ExportEarthObservationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportEarthObservationJob
func (c *SageMakerGeospatial) ExportEarthObservationJobRequest(input *ExportEarthObservationJobInput) (req *request.Request, output *ExportEarthObservationJobOutput) {
	op := &request.Operation{
		Name:       opExportEarthObservationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/export-earth-observation-job",
	}

	if input == nil {
		input = &ExportEarthObservationJobInput{}
	}

	output = &ExportEarthObservationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportEarthObservationJob API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to export results of an Earth Observation job and optionally
// source images used as input to the EOJ to an Amazon S3 location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation ExportEarthObservationJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You have exceeded the service quota.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportEarthObservationJob
func (c *SageMakerGeospatial) ExportEarthObservationJob(input *ExportEarthObservationJobInput) (*ExportEarthObservationJobOutput, error) {
	req, out := c.ExportEarthObservationJobRequest(input)
	return out, req.Send()
}

// ExportEarthObservationJobWithContext is the same as ExportEarthObservationJob with the addition of
// the ability to pass a context and additional request options.
//
// See ExportEarthObservationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ExportEarthObservationJobWithContext(ctx aws.Context, input *ExportEarthObservationJobInput, opts ...request.Option) (*ExportEarthObservationJobOutput, error) {
	req, out := c.ExportEarthObservationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportVectorEnrichmentJob = "ExportVectorEnrichmentJob"

// ExportVectorEnrichmentJobRequest generates a "aws/request.Request" representing the
// client's request for the ExportVectorEnrichmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportVectorEnrichmentJob for more information on using the ExportVectorEnrichmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportVectorEnrichmentJobRequest method.
//	req, resp := client.ExportVectorEnrichmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportVectorEnrichmentJob
func (c *SageMakerGeospatial) ExportVectorEnrichmentJobRequest(input *ExportVectorEnrichmentJobInput) (req *request.Request, output *ExportVectorEnrichmentJobOutput) {
	op := &request.Operation{
		Name:       opExportVectorEnrichmentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/export-vector-enrichment-jobs",
	}

	if input == nil {
		input = &ExportVectorEnrichmentJobInput{}
	}

	output = &ExportVectorEnrichmentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportVectorEnrichmentJob API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to copy results of a Vector Enrichment job to an Amazon
// S3 location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation ExportVectorEnrichmentJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You have exceeded the service quota.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ExportVectorEnrichmentJob
func (c *SageMakerGeospatial) ExportVectorEnrichmentJob(input *ExportVectorEnrichmentJobInput) (*ExportVectorEnrichmentJobOutput, error) {
	req, out := c.ExportVectorEnrichmentJobRequest(input)
	return out, req.Send()
}

// ExportVectorEnrichmentJobWithContext is the same as ExportVectorEnrichmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See ExportVectorEnrichmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ExportVectorEnrichmentJobWithContext(ctx aws.Context, input *ExportVectorEnrichmentJobInput, opts ...request.Option) (*ExportVectorEnrichmentJobOutput, error) {
	req, out := c.ExportVectorEnrichmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEarthObservationJob = "GetEarthObservationJob"

// GetEarthObservationJobRequest generates a "aws/request.Request" representing the
// client's request for the GetEarthObservationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEarthObservationJob for more information on using the GetEarthObservationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEarthObservationJobRequest method.
//	req, resp := client.GetEarthObservationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetEarthObservationJob
func (c *SageMakerGeospatial) GetEarthObservationJobRequest(input *GetEarthObservationJobInput) (req *request.Request, output *GetEarthObservationJobOutput) {
	op := &request.Operation{
		Name:       opGetEarthObservationJob,
		HTTPMethod: "GET",
		HTTPPath:   "/earth-observation-jobs/{Arn}",
	}

	if input == nil {
		input = &GetEarthObservationJobInput{}
	}

	output = &GetEarthObservationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEarthObservationJob API operation for Amazon SageMaker geospatial capabilities.
//
// Get the details for a previously initiated Earth Observation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation GetEarthObservationJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetEarthObservationJob
func (c *SageMakerGeospatial) GetEarthObservationJob(input *GetEarthObservationJobInput) (*GetEarthObservationJobOutput, error) {
	req, out := c.GetEarthObservationJobRequest(input)
	return out, req.Send()
}

// GetEarthObservationJobWithContext is the same as GetEarthObservationJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetEarthObservationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) GetEarthObservationJobWithContext(ctx aws.Context, input *GetEarthObservationJobInput, opts ...request.Option) (*GetEarthObservationJobOutput, error) {
	req, out := c.GetEarthObservationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRasterDataCollection = "GetRasterDataCollection"

// GetRasterDataCollectionRequest generates a "aws/request.Request" representing the
// client's request for the GetRasterDataCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRasterDataCollection for more information on using the GetRasterDataCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRasterDataCollectionRequest method.
//	req, resp := client.GetRasterDataCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetRasterDataCollection
func (c *SageMakerGeospatial) GetRasterDataCollectionRequest(input *GetRasterDataCollectionInput) (req *request.Request, output *GetRasterDataCollectionOutput) {
	op := &request.Operation{
		Name:       opGetRasterDataCollection,
		HTTPMethod: "GET",
		HTTPPath:   "/raster-data-collection/{Arn}",
	}

	if input == nil {
		input = &GetRasterDataCollectionInput{}
	}

	output = &GetRasterDataCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRasterDataCollection API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to get details of a specific raster data collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation GetRasterDataCollection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetRasterDataCollection
func (c *SageMakerGeospatial) GetRasterDataCollection(input *GetRasterDataCollectionInput) (*GetRasterDataCollectionOutput, error) {
	req, out := c.GetRasterDataCollectionRequest(input)
	return out, req.Send()
}

// GetRasterDataCollectionWithContext is the same as GetRasterDataCollection with the addition of
// the ability to pass a context and additional request options.
//
// See GetRasterDataCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) GetRasterDataCollectionWithContext(ctx aws.Context, input *GetRasterDataCollectionInput, opts ...request.Option) (*GetRasterDataCollectionOutput, error) {
	req, out := c.GetRasterDataCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTile = "GetTile"

// GetTileRequest generates a "aws/request.Request" representing the
// client's request for the GetTile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTile for more information on using the GetTile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTileRequest method.
//	req, resp := client.GetTileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetTile
func (c *SageMakerGeospatial) GetTileRequest(input *GetTileInput) (req *request.Request, output *GetTileOutput) {
	op := &request.Operation{
		Name:       opGetTile,
		HTTPMethod: "GET",
		HTTPPath:   "/tile/{z}/{x}/{y}",
	}

	if input == nil {
		input = &GetTileInput{}
	}

	output = &GetTileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTile API operation for Amazon SageMaker geospatial capabilities.
//
// Gets a web mercator tile for the given Earth Observation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation GetTile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetTile
func (c *SageMakerGeospatial) GetTile(input *GetTileInput) (*GetTileOutput, error) {
	req, out := c.GetTileRequest(input)
	return out, req.Send()
}

// GetTileWithContext is the same as GetTile with the addition of
// the ability to pass a context and additional request options.
//
// See GetTile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) GetTileWithContext(ctx aws.Context, input *GetTileInput, opts ...request.Option) (*GetTileOutput, error) {
	req, out := c.GetTileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVectorEnrichmentJob = "GetVectorEnrichmentJob"

// GetVectorEnrichmentJobRequest generates a "aws/request.Request" representing the
// client's request for the GetVectorEnrichmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVectorEnrichmentJob for more information on using the GetVectorEnrichmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVectorEnrichmentJobRequest method.
//	req, resp := client.GetVectorEnrichmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetVectorEnrichmentJob
func (c *SageMakerGeospatial) GetVectorEnrichmentJobRequest(input *GetVectorEnrichmentJobInput) (req *request.Request, output *GetVectorEnrichmentJobOutput) {
	op := &request.Operation{
		Name:       opGetVectorEnrichmentJob,
		HTTPMethod: "GET",
		HTTPPath:   "/vector-enrichment-jobs/{Arn}",
	}

	if input == nil {
		input = &GetVectorEnrichmentJobInput{}
	}

	output = &GetVectorEnrichmentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVectorEnrichmentJob API operation for Amazon SageMaker geospatial capabilities.
//
// Retrieves details of a Vector Enrichment Job for a given job Amazon Resource
// Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation GetVectorEnrichmentJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/GetVectorEnrichmentJob
func (c *SageMakerGeospatial) GetVectorEnrichmentJob(input *GetVectorEnrichmentJobInput) (*GetVectorEnrichmentJobOutput, error) {
	req, out := c.GetVectorEnrichmentJobRequest(input)
	return out, req.Send()
}

// GetVectorEnrichmentJobWithContext is the same as GetVectorEnrichmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetVectorEnrichmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) GetVectorEnrichmentJobWithContext(ctx aws.Context, input *GetVectorEnrichmentJobInput, opts ...request.Option) (*GetVectorEnrichmentJobOutput, error) {
	req, out := c.GetVectorEnrichmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEarthObservationJobs = "ListEarthObservationJobs"

// ListEarthObservationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEarthObservationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEarthObservationJobs for more information on using the ListEarthObservationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEarthObservationJobsRequest method.
//	req, resp := client.ListEarthObservationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListEarthObservationJobs
func (c *SageMakerGeospatial) ListEarthObservationJobsRequest(input *ListEarthObservationJobsInput) (req *request.Request, output *ListEarthObservationJobsOutput) {
	op := &request.Operation{
		Name:       opListEarthObservationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/list-earth-observation-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEarthObservationJobsInput{}
	}

	output = &ListEarthObservationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEarthObservationJobs API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to get a list of the Earth Observation jobs associated
// with the calling Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation ListEarthObservationJobs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListEarthObservationJobs
func (c *SageMakerGeospatial) ListEarthObservationJobs(input *ListEarthObservationJobsInput) (*ListEarthObservationJobsOutput, error) {
	req, out := c.ListEarthObservationJobsRequest(input)
	return out, req.Send()
}

// ListEarthObservationJobsWithContext is the same as ListEarthObservationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEarthObservationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ListEarthObservationJobsWithContext(ctx aws.Context, input *ListEarthObservationJobsInput, opts ...request.Option) (*ListEarthObservationJobsOutput, error) {
	req, out := c.ListEarthObservationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEarthObservationJobsPages iterates over the pages of a ListEarthObservationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEarthObservationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEarthObservationJobs operation.
//	pageNum := 0
//	err := client.ListEarthObservationJobsPages(params,
//	    func(page *sagemakergeospatial.ListEarthObservationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SageMakerGeospatial) ListEarthObservationJobsPages(input *ListEarthObservationJobsInput, fn func(*ListEarthObservationJobsOutput, bool) bool) error {
	return c.ListEarthObservationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEarthObservationJobsPagesWithContext same as ListEarthObservationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ListEarthObservationJobsPagesWithContext(ctx aws.Context, input *ListEarthObservationJobsInput, fn func(*ListEarthObservationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEarthObservationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEarthObservationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEarthObservationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRasterDataCollections = "ListRasterDataCollections"

// ListRasterDataCollectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListRasterDataCollections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRasterDataCollections for more information on using the ListRasterDataCollections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRasterDataCollectionsRequest method.
//	req, resp := client.ListRasterDataCollectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListRasterDataCollections
func (c *SageMakerGeospatial) ListRasterDataCollectionsRequest(input *ListRasterDataCollectionsInput) (req *request.Request, output *ListRasterDataCollectionsOutput) {
	op := &request.Operation{
		Name:       opListRasterDataCollections,
		HTTPMethod: "GET",
		HTTPPath:   "/raster-data-collections",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRasterDataCollectionsInput{}
	}

	output = &ListRasterDataCollectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRasterDataCollections API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to get raster data collections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation ListRasterDataCollections for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListRasterDataCollections
func (c *SageMakerGeospatial) ListRasterDataCollections(input *ListRasterDataCollectionsInput) (*ListRasterDataCollectionsOutput, error) {
	req, out := c.ListRasterDataCollectionsRequest(input)
	return out, req.Send()
}

// ListRasterDataCollectionsWithContext is the same as ListRasterDataCollections with the addition of
// the ability to pass a context and additional request options.
//
// See ListRasterDataCollections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ListRasterDataCollectionsWithContext(ctx aws.Context, input *ListRasterDataCollectionsInput, opts ...request.Option) (*ListRasterDataCollectionsOutput, error) {
	req, out := c.ListRasterDataCollectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRasterDataCollectionsPages iterates over the pages of a ListRasterDataCollections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRasterDataCollections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRasterDataCollections operation.
//	pageNum := 0
//	err := client.ListRasterDataCollectionsPages(params,
//	    func(page *sagemakergeospatial.ListRasterDataCollectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SageMakerGeospatial) ListRasterDataCollectionsPages(input *ListRasterDataCollectionsInput, fn func(*ListRasterDataCollectionsOutput, bool) bool) error {
	return c.ListRasterDataCollectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRasterDataCollectionsPagesWithContext same as ListRasterDataCollectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ListRasterDataCollectionsPagesWithContext(ctx aws.Context, input *ListRasterDataCollectionsInput, fn func(*ListRasterDataCollectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRasterDataCollectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRasterDataCollectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRasterDataCollectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListTagsForResource
func (c *SageMakerGeospatial) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon SageMaker geospatial capabilities.
//
// Lists the tags attached to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListTagsForResource
func (c *SageMakerGeospatial) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVectorEnrichmentJobs = "ListVectorEnrichmentJobs"

// ListVectorEnrichmentJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListVectorEnrichmentJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVectorEnrichmentJobs for more information on using the ListVectorEnrichmentJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVectorEnrichmentJobsRequest method.
//	req, resp := client.ListVectorEnrichmentJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListVectorEnrichmentJobs
func (c *SageMakerGeospatial) ListVectorEnrichmentJobsRequest(input *ListVectorEnrichmentJobsInput) (req *request.Request, output *ListVectorEnrichmentJobsOutput) {
	op := &request.Operation{
		Name:       opListVectorEnrichmentJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/list-vector-enrichment-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVectorEnrichmentJobsInput{}
	}

	output = &ListVectorEnrichmentJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVectorEnrichmentJobs API operation for Amazon SageMaker geospatial capabilities.
//
// Retrieves a list of vector enrichment jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation ListVectorEnrichmentJobs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/ListVectorEnrichmentJobs
func (c *SageMakerGeospatial) ListVectorEnrichmentJobs(input *ListVectorEnrichmentJobsInput) (*ListVectorEnrichmentJobsOutput, error) {
	req, out := c.ListVectorEnrichmentJobsRequest(input)
	return out, req.Send()
}

// ListVectorEnrichmentJobsWithContext is the same as ListVectorEnrichmentJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListVectorEnrichmentJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ListVectorEnrichmentJobsWithContext(ctx aws.Context, input *ListVectorEnrichmentJobsInput, opts ...request.Option) (*ListVectorEnrichmentJobsOutput, error) {
	req, out := c.ListVectorEnrichmentJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVectorEnrichmentJobsPages iterates over the pages of a ListVectorEnrichmentJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVectorEnrichmentJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVectorEnrichmentJobs operation.
//	pageNum := 0
//	err := client.ListVectorEnrichmentJobsPages(params,
//	    func(page *sagemakergeospatial.ListVectorEnrichmentJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SageMakerGeospatial) ListVectorEnrichmentJobsPages(input *ListVectorEnrichmentJobsInput, fn func(*ListVectorEnrichmentJobsOutput, bool) bool) error {
	return c.ListVectorEnrichmentJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVectorEnrichmentJobsPagesWithContext same as ListVectorEnrichmentJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) ListVectorEnrichmentJobsPagesWithContext(ctx aws.Context, input *ListVectorEnrichmentJobsInput, fn func(*ListVectorEnrichmentJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVectorEnrichmentJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVectorEnrichmentJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVectorEnrichmentJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchRasterDataCollection = "SearchRasterDataCollection"

// SearchRasterDataCollectionRequest generates a "aws/request.Request" representing the
// client's request for the SearchRasterDataCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchRasterDataCollection for more information on using the SearchRasterDataCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchRasterDataCollectionRequest method.
//	req, resp := client.SearchRasterDataCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/SearchRasterDataCollection
func (c *SageMakerGeospatial) SearchRasterDataCollectionRequest(input *SearchRasterDataCollectionInput) (req *request.Request, output *SearchRasterDataCollectionOutput) {
	op := &request.Operation{
		Name:       opSearchRasterDataCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/search-raster-data-collection",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchRasterDataCollectionInput{}
	}

	output = &SearchRasterDataCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchRasterDataCollection API operation for Amazon SageMaker geospatial capabilities.
//
// Allows you run image query on a specific raster data collection to get a
// list of the satellite imagery matching the selected filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation SearchRasterDataCollection for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/SearchRasterDataCollection
func (c *SageMakerGeospatial) SearchRasterDataCollection(input *SearchRasterDataCollectionInput) (*SearchRasterDataCollectionOutput, error) {
	req, out := c.SearchRasterDataCollectionRequest(input)
	return out, req.Send()
}

// SearchRasterDataCollectionWithContext is the same as SearchRasterDataCollection with the addition of
// the ability to pass a context and additional request options.
//
// See SearchRasterDataCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) SearchRasterDataCollectionWithContext(ctx aws.Context, input *SearchRasterDataCollectionInput, opts ...request.Option) (*SearchRasterDataCollectionOutput, error) {
	req, out := c.SearchRasterDataCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchRasterDataCollectionPages iterates over the pages of a SearchRasterDataCollection operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchRasterDataCollection method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchRasterDataCollection operation.
//	pageNum := 0
//	err := client.SearchRasterDataCollectionPages(params,
//	    func(page *sagemakergeospatial.SearchRasterDataCollectionOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SageMakerGeospatial) SearchRasterDataCollectionPages(input *SearchRasterDataCollectionInput, fn func(*SearchRasterDataCollectionOutput, bool) bool) error {
	return c.SearchRasterDataCollectionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchRasterDataCollectionPagesWithContext same as SearchRasterDataCollectionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) SearchRasterDataCollectionPagesWithContext(ctx aws.Context, input *SearchRasterDataCollectionInput, fn func(*SearchRasterDataCollectionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchRasterDataCollectionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRasterDataCollectionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchRasterDataCollectionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartEarthObservationJob = "StartEarthObservationJob"

// StartEarthObservationJobRequest generates a "aws/request.Request" representing the
// client's request for the StartEarthObservationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEarthObservationJob for more information on using the StartEarthObservationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartEarthObservationJobRequest method.
//	req, resp := client.StartEarthObservationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StartEarthObservationJob
func (c *SageMakerGeospatial) StartEarthObservationJobRequest(input *StartEarthObservationJobInput) (req *request.Request, output *StartEarthObservationJobOutput) {
	op := &request.Operation{
		Name:       opStartEarthObservationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/earth-observation-jobs",
	}

	if input == nil {
		input = &StartEarthObservationJobInput{}
	}

	output = &StartEarthObservationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEarthObservationJob API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to create an Earth observation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation StartEarthObservationJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You have exceeded the service quota.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StartEarthObservationJob
func (c *SageMakerGeospatial) StartEarthObservationJob(input *StartEarthObservationJobInput) (*StartEarthObservationJobOutput, error) {
	req, out := c.StartEarthObservationJobRequest(input)
	return out, req.Send()
}

// StartEarthObservationJobWithContext is the same as StartEarthObservationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartEarthObservationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) StartEarthObservationJobWithContext(ctx aws.Context, input *StartEarthObservationJobInput, opts ...request.Option) (*StartEarthObservationJobOutput, error) {
	req, out := c.StartEarthObservationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartVectorEnrichmentJob = "StartVectorEnrichmentJob"

// StartVectorEnrichmentJobRequest generates a "aws/request.Request" representing the
// client's request for the StartVectorEnrichmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartVectorEnrichmentJob for more information on using the StartVectorEnrichmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartVectorEnrichmentJobRequest method.
//	req, resp := client.StartVectorEnrichmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StartVectorEnrichmentJob
func (c *SageMakerGeospatial) StartVectorEnrichmentJobRequest(input *StartVectorEnrichmentJobInput) (req *request.Request, output *StartVectorEnrichmentJobOutput) {
	op := &request.Operation{
		Name:       opStartVectorEnrichmentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/vector-enrichment-jobs",
	}

	if input == nil {
		input = &StartVectorEnrichmentJobInput{}
	}

	output = &StartVectorEnrichmentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartVectorEnrichmentJob API operation for Amazon SageMaker geospatial capabilities.
//
// Creates a Vector Enrichment job for the supplied job type. Currently, there
// are two supported job types: reverse geocoding and map matching.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation StartVectorEnrichmentJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You have exceeded the service quota.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StartVectorEnrichmentJob
func (c *SageMakerGeospatial) StartVectorEnrichmentJob(input *StartVectorEnrichmentJobInput) (*StartVectorEnrichmentJobOutput, error) {
	req, out := c.StartVectorEnrichmentJobRequest(input)
	return out, req.Send()
}

// StartVectorEnrichmentJobWithContext is the same as StartVectorEnrichmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartVectorEnrichmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) StartVectorEnrichmentJobWithContext(ctx aws.Context, input *StartVectorEnrichmentJobInput, opts ...request.Option) (*StartVectorEnrichmentJobOutput, error) {
	req, out := c.StartVectorEnrichmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEarthObservationJob = "StopEarthObservationJob"

// StopEarthObservationJobRequest generates a "aws/request.Request" representing the
// client's request for the StopEarthObservationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEarthObservationJob for more information on using the StopEarthObservationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopEarthObservationJobRequest method.
//	req, resp := client.StopEarthObservationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StopEarthObservationJob
func (c *SageMakerGeospatial) StopEarthObservationJobRequest(input *StopEarthObservationJobInput) (req *request.Request, output *StopEarthObservationJobOutput) {
	op := &request.Operation{
		Name:       opStopEarthObservationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/earth-observation-jobs/stop",
	}

	if input == nil {
		input = &StopEarthObservationJobInput{}
	}

	output = &StopEarthObservationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopEarthObservationJob API operation for Amazon SageMaker geospatial capabilities.
//
// Use this operation to stop an existing earth observation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation StopEarthObservationJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StopEarthObservationJob
func (c *SageMakerGeospatial) StopEarthObservationJob(input *StopEarthObservationJobInput) (*StopEarthObservationJobOutput, error) {
	req, out := c.StopEarthObservationJobRequest(input)
	return out, req.Send()
}

// StopEarthObservationJobWithContext is the same as StopEarthObservationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopEarthObservationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) StopEarthObservationJobWithContext(ctx aws.Context, input *StopEarthObservationJobInput, opts ...request.Option) (*StopEarthObservationJobOutput, error) {
	req, out := c.StopEarthObservationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopVectorEnrichmentJob = "StopVectorEnrichmentJob"

// StopVectorEnrichmentJobRequest generates a "aws/request.Request" representing the
// client's request for the StopVectorEnrichmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopVectorEnrichmentJob for more information on using the StopVectorEnrichmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopVectorEnrichmentJobRequest method.
//	req, resp := client.StopVectorEnrichmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StopVectorEnrichmentJob
func (c *SageMakerGeospatial) StopVectorEnrichmentJobRequest(input *StopVectorEnrichmentJobInput) (req *request.Request, output *StopVectorEnrichmentJobOutput) {
	op := &request.Operation{
		Name:       opStopVectorEnrichmentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/vector-enrichment-jobs/stop",
	}

	if input == nil {
		input = &StopVectorEnrichmentJobInput{}
	}

	output = &StopVectorEnrichmentJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopVectorEnrichmentJob API operation for Amazon SageMaker geospatial capabilities.
//
// Stops the Vector Enrichment job for a given job ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation StopVectorEnrichmentJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/StopVectorEnrichmentJob
func (c *SageMakerGeospatial) StopVectorEnrichmentJob(input *StopVectorEnrichmentJobInput) (*StopVectorEnrichmentJobOutput, error) {
	req, out := c.StopVectorEnrichmentJobRequest(input)
	return out, req.Send()
}

// StopVectorEnrichmentJobWithContext is the same as StopVectorEnrichmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopVectorEnrichmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) StopVectorEnrichmentJobWithContext(ctx aws.Context, input *StopVectorEnrichmentJobInput, opts ...request.Option) (*StopVectorEnrichmentJobOutput, error) {
	req, out := c.StopVectorEnrichmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/TagResource
func (c *SageMakerGeospatial) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon SageMaker geospatial capabilities.
//
// The resource you want to tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/TagResource
func (c *SageMakerGeospatial) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/UntagResource
func (c *SageMakerGeospatial) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon SageMaker geospatial capabilities.
//
// The resource you want to untag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker geospatial capabilities's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-geospatial-2020-05-27/UntagResource
func (c *SageMakerGeospatial) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerGeospatial) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The geographic extent of the Earth Observation job.
type AreaOfInterest struct {
	_ struct{} `type:"structure"`

	// A GeoJSON object representing the geographic extent in the coordinate space.
	AreaOfInterestGeometry *AreaOfInterestGeometry `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AreaOfInterest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AreaOfInterest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AreaOfInterest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AreaOfInterest"}
	if s.AreaOfInterestGeometry != nil {
		if err := s.AreaOfInterestGeometry.Validate(); err != nil {
			invalidParams.AddNested("AreaOfInterestGeometry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAreaOfInterestGeometry sets the AreaOfInterestGeometry field's value.
func (s *AreaOfInterest) SetAreaOfInterestGeometry(v *AreaOfInterestGeometry) *AreaOfInterest {
	s.AreaOfInterestGeometry = v
	return s
}

// A GeoJSON object representing the geographic extent in the coordinate space.
type AreaOfInterestGeometry struct {
	_ struct{} `type:"structure"`

	// The structure representing the MultiPolygon Geometry.
	MultiPolygonGeometry *MultiPolygonGeometryInput_ `type:"structure"`

	// The structure representing Polygon Geometry.
	PolygonGeometry *PolygonGeometryInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AreaOfInterestGeometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AreaOfInterestGeometry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AreaOfInterestGeometry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AreaOfInterestGeometry"}
	if s.MultiPolygonGeometry != nil {
		if err := s.MultiPolygonGeometry.Validate(); err != nil {
			invalidParams.AddNested("MultiPolygonGeometry", err.(request.ErrInvalidParams))
		}
	}
	if s.PolygonGeometry != nil {
		if err := s.PolygonGeometry.Validate(); err != nil {
			invalidParams.AddNested("PolygonGeometry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiPolygonGeometry sets the MultiPolygonGeometry field's value.
func (s *AreaOfInterestGeometry) SetMultiPolygonGeometry(v *MultiPolygonGeometryInput_) *AreaOfInterestGeometry {
	s.MultiPolygonGeometry = v
	return s
}

// SetPolygonGeometry sets the PolygonGeometry field's value.
func (s *AreaOfInterestGeometry) SetPolygonGeometry(v *PolygonGeometryInput_) *AreaOfInterestGeometry {
	s.PolygonGeometry = v
	return s
}

// The structure containing the asset properties.
type AssetValue struct {
	_ struct{} `type:"structure"`

	// Link to the asset object.
	Href *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetValue) GoString() string {
	return s.String()
}

// SetHref sets the Href field's value.
func (s *AssetValue) SetHref(v string) *AssetValue {
	s.Href = &v
	return s
}

// Input structure for the BandMath operation type. Defines Predefined and CustomIndices
// to be computed using BandMath.
type BandMathConfigInput_ struct {
	_ struct{} `type:"structure"`

	// CustomIndices that are computed.
	CustomIndices *CustomIndicesInput_ `type:"structure"`

	// One or many of the supported predefined indices to compute. Allowed values:
	// NDVI, EVI2, MSAVI, NDWI, NDMI, NDSI, and WDRVI.
	PredefinedIndices []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BandMathConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BandMathConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BandMathConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BandMathConfigInput_"}
	if s.PredefinedIndices != nil && len(s.PredefinedIndices) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PredefinedIndices", 1))
	}
	if s.CustomIndices != nil {
		if err := s.CustomIndices.Validate(); err != nil {
			invalidParams.AddNested("CustomIndices", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomIndices sets the CustomIndices field's value.
func (s *BandMathConfigInput_) SetCustomIndices(v *CustomIndicesInput_) *BandMathConfigInput_ {
	s.CustomIndices = v
	return s
}

// SetPredefinedIndices sets the PredefinedIndices field's value.
func (s *BandMathConfigInput_) SetPredefinedIndices(v []*string) *BandMathConfigInput_ {
	s.PredefinedIndices = v
	return s
}

// Input structure for CloudMasking operation type.
type CloudMaskingConfigInput_ struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudMaskingConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudMaskingConfigInput_) GoString() string {
	return s.String()
}

// Input structure for Cloud Removal Operation type
type CloudRemovalConfigInput_ struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm used for cloud removal.
	AlgorithmName *string `type:"string" enum:"AlgorithmNameCloudRemoval"`

	// The interpolation value you provide for cloud removal.
	InterpolationValue *string `type:"string"`

	// TargetBands to be returned in the output of CloudRemoval operation.
	TargetBands []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudRemovalConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudRemovalConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudRemovalConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudRemovalConfigInput_"}
	if s.TargetBands != nil && len(s.TargetBands) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetBands", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *CloudRemovalConfigInput_) SetAlgorithmName(v string) *CloudRemovalConfigInput_ {
	s.AlgorithmName = &v
	return s
}

// SetInterpolationValue sets the InterpolationValue field's value.
func (s *CloudRemovalConfigInput_) SetInterpolationValue(v string) *CloudRemovalConfigInput_ {
	s.InterpolationValue = &v
	return s
}

// SetTargetBands sets the TargetBands field's value.
func (s *CloudRemovalConfigInput_) SetTargetBands(v []*string) *CloudRemovalConfigInput_ {
	s.TargetBands = v
	return s
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource affected.
	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Input object defining the custom BandMath indices to compute.
type CustomIndicesInput_ struct {
	_ struct{} `type:"structure"`

	// A list of BandMath indices to compute.
	Operations []*Operation `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomIndicesInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomIndicesInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomIndicesInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomIndicesInput_"}
	if s.Operations != nil && len(s.Operations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Operations", 1))
	}
	if s.Operations != nil {
		for i, v := range s.Operations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Operations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperations sets the Operations field's value.
func (s *CustomIndicesInput_) SetOperations(v []*Operation) *CustomIndicesInput_ {
	s.Operations = v
	return s
}

type DeleteEarthObservationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Earth Observation job being deleted.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEarthObservationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEarthObservationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEarthObservationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEarthObservationJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteEarthObservationJobInput) SetArn(v string) *DeleteEarthObservationJobInput {
	s.Arn = &v
	return s
}

type DeleteEarthObservationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEarthObservationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEarthObservationJobOutput) GoString() string {
	return s.String()
}

type DeleteVectorEnrichmentJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Vector Enrichment job being deleted.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVectorEnrichmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVectorEnrichmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVectorEnrichmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVectorEnrichmentJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteVectorEnrichmentJobInput) SetArn(v string) *DeleteVectorEnrichmentJobInput {
	s.Arn = &v
	return s
}

type DeleteVectorEnrichmentJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVectorEnrichmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVectorEnrichmentJobOutput) GoString() string {
	return s.String()
}

// The structure representing the errors in an EarthObservationJob.
type EarthObservationJobErrorDetails struct {
	_ struct{} `type:"structure"`

	// A detailed message describing the error in an Earth Observation job.
	Message *string `type:"string"`

	// The type of error in an Earth Observation job.
	Type *string `type:"string" enum:"EarthObservationJobErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EarthObservationJobErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EarthObservationJobErrorDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *EarthObservationJobErrorDetails) SetMessage(v string) *EarthObservationJobErrorDetails {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *EarthObservationJobErrorDetails) SetType(v string) *EarthObservationJobErrorDetails {
	s.Type = &v
	return s
}

// The structure representing the EoCloudCover filter.
type EoCloudCoverInput_ struct {
	_ struct{} `type:"structure"`

	// Lower bound for EoCloudCover.
	//
	// LowerBound is a required field
	LowerBound *float64 `type:"float" required:"true"`

	// Upper bound for EoCloudCover.
	//
	// UpperBound is a required field
	UpperBound *float64 `type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EoCloudCoverInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EoCloudCoverInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EoCloudCoverInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EoCloudCoverInput_"}
	if s.LowerBound == nil {
		invalidParams.Add(request.NewErrParamRequired("LowerBound"))
	}
	if s.UpperBound == nil {
		invalidParams.Add(request.NewErrParamRequired("UpperBound"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLowerBound sets the LowerBound field's value.
func (s *EoCloudCoverInput_) SetLowerBound(v float64) *EoCloudCoverInput_ {
	s.LowerBound = &v
	return s
}

// SetUpperBound sets the UpperBound field's value.
func (s *EoCloudCoverInput_) SetUpperBound(v float64) *EoCloudCoverInput_ {
	s.UpperBound = &v
	return s
}

type ExportEarthObservationJobInput struct {
	_ struct{} `type:"structure"`

	// The input Amazon Resource Name (ARN) of the Earth Observation job being exported.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A unique token that guarantees that the call to this API is idempotent.
	ClientToken *string `min:"36" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// job.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// The source images provided to the Earth Observation job being exported.
	ExportSourceImages *bool `type:"boolean"`

	// An object containing information about the output file.
	//
	// OutputConfig is a required field
	OutputConfig *OutputConfigInput_ `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportEarthObservationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportEarthObservationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportEarthObservationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportEarthObservationJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ExportEarthObservationJobInput) SetArn(v string) *ExportEarthObservationJobInput {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ExportEarthObservationJobInput) SetClientToken(v string) *ExportEarthObservationJobInput {
	s.ClientToken = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *ExportEarthObservationJobInput) SetExecutionRoleArn(v string) *ExportEarthObservationJobInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetExportSourceImages sets the ExportSourceImages field's value.
func (s *ExportEarthObservationJobInput) SetExportSourceImages(v bool) *ExportEarthObservationJobInput {
	s.ExportSourceImages = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *ExportEarthObservationJobInput) SetOutputConfig(v *OutputConfigInput_) *ExportEarthObservationJobInput {
	s.OutputConfig = v
	return s
}

type ExportEarthObservationJobOutput struct {
	_ struct{} `type:"structure"`

	// The output Amazon Resource Name (ARN) of the Earth Observation job being
	// exported.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// job.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// The source images provided to the Earth Observation job being exported.
	ExportSourceImages *bool `type:"boolean"`

	// The status of the results of the Earth Observation job being exported.
	//
	// ExportStatus is a required field
	ExportStatus *string `type:"string" required:"true" enum:"EarthObservationJobExportStatus"`

	// An object containing information about the output file.
	//
	// OutputConfig is a required field
	OutputConfig *OutputConfigInput_ `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportEarthObservationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportEarthObservationJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExportEarthObservationJobOutput) SetArn(v string) *ExportEarthObservationJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExportEarthObservationJobOutput) SetCreationTime(v time.Time) *ExportEarthObservationJobOutput {
	s.CreationTime = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *ExportEarthObservationJobOutput) SetExecutionRoleArn(v string) *ExportEarthObservationJobOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetExportSourceImages sets the ExportSourceImages field's value.
func (s *ExportEarthObservationJobOutput) SetExportSourceImages(v bool) *ExportEarthObservationJobOutput {
	s.ExportSourceImages = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *ExportEarthObservationJobOutput) SetExportStatus(v string) *ExportEarthObservationJobOutput {
	s.ExportStatus = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *ExportEarthObservationJobOutput) SetOutputConfig(v *OutputConfigInput_) *ExportEarthObservationJobOutput {
	s.OutputConfig = v
	return s
}

// The structure for returning the export error details in a GetEarthObservationJob.
type ExportErrorDetails struct {
	_ struct{} `type:"structure"`

	// The structure for returning the export error details while exporting results
	// of an Earth Observation job.
	ExportResults *ExportErrorDetailsOutput_ `type:"structure"`

	// The structure for returning the export error details while exporting the
	// source images of an Earth Observation job.
	ExportSourceImages *ExportErrorDetailsOutput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportErrorDetails) GoString() string {
	return s.String()
}

// SetExportResults sets the ExportResults field's value.
func (s *ExportErrorDetails) SetExportResults(v *ExportErrorDetailsOutput_) *ExportErrorDetails {
	s.ExportResults = v
	return s
}

// SetExportSourceImages sets the ExportSourceImages field's value.
func (s *ExportErrorDetails) SetExportSourceImages(v *ExportErrorDetailsOutput_) *ExportErrorDetails {
	s.ExportSourceImages = v
	return s
}

// The structure representing the errors in an export EarthObservationJob operation.
type ExportErrorDetailsOutput_ struct {
	_ struct{} `type:"structure"`

	// A detailed message describing the error in an export EarthObservationJob
	// operation.
	Message *string `type:"string"`

	// The type of error in an export EarthObservationJob operation.
	Type *string `type:"string" enum:"ExportErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportErrorDetailsOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportErrorDetailsOutput_) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ExportErrorDetailsOutput_) SetMessage(v string) *ExportErrorDetailsOutput_ {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExportErrorDetailsOutput_) SetType(v string) *ExportErrorDetailsOutput_ {
	s.Type = &v
	return s
}

// The structure containing the Amazon S3 path to export the Earth Observation
// job output.
type ExportS3DataInput_ struct {
	_ struct{} `type:"structure"`

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The URL to the Amazon S3 data input.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportS3DataInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportS3DataInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportS3DataInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportS3DataInput_"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ExportS3DataInput_) SetKmsKeyId(v string) *ExportS3DataInput_ {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *ExportS3DataInput_) SetS3Uri(v string) *ExportS3DataInput_ {
	s.S3Uri = &v
	return s
}

type ExportVectorEnrichmentJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Vector Enrichment job.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A unique token that guarantees that the call to this API is idempotent.
	ClientToken *string `min:"36" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM rolewith permission to upload to
	// the location in OutputConfig.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// Output location information for exporting Vector Enrichment Job results.
	//
	// OutputConfig is a required field
	OutputConfig *ExportVectorEnrichmentJobOutputConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportVectorEnrichmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportVectorEnrichmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportVectorEnrichmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportVectorEnrichmentJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ExportVectorEnrichmentJobInput) SetArn(v string) *ExportVectorEnrichmentJobInput {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ExportVectorEnrichmentJobInput) SetClientToken(v string) *ExportVectorEnrichmentJobInput {
	s.ClientToken = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *ExportVectorEnrichmentJobInput) SetExecutionRoleArn(v string) *ExportVectorEnrichmentJobInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *ExportVectorEnrichmentJobInput) SetOutputConfig(v *ExportVectorEnrichmentJobOutputConfig) *ExportVectorEnrichmentJobInput {
	s.OutputConfig = v
	return s
}

type ExportVectorEnrichmentJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Vector Enrichment job being exported.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permission to upload
	// to the location in OutputConfig.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// The status of the results the Vector Enrichment job being exported.
	//
	// ExportStatus is a required field
	ExportStatus *string `type:"string" required:"true" enum:"VectorEnrichmentJobExportStatus"`

	// Output location information for exporting Vector Enrichment Job results.
	//
	// OutputConfig is a required field
	OutputConfig *ExportVectorEnrichmentJobOutputConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportVectorEnrichmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportVectorEnrichmentJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExportVectorEnrichmentJobOutput) SetArn(v string) *ExportVectorEnrichmentJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ExportVectorEnrichmentJobOutput) SetCreationTime(v time.Time) *ExportVectorEnrichmentJobOutput {
	s.CreationTime = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *ExportVectorEnrichmentJobOutput) SetExecutionRoleArn(v string) *ExportVectorEnrichmentJobOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *ExportVectorEnrichmentJobOutput) SetExportStatus(v string) *ExportVectorEnrichmentJobOutput {
	s.ExportStatus = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *ExportVectorEnrichmentJobOutput) SetOutputConfig(v *ExportVectorEnrichmentJobOutputConfig) *ExportVectorEnrichmentJobOutput {
	s.OutputConfig = v
	return s
}

// An object containing information about the output file.
type ExportVectorEnrichmentJobOutputConfig struct {
	_ struct{} `type:"structure"`

	// The input structure for Amazon S3 data; representing the Amazon S3 location
	// of the input data objects.
	//
	// S3Data is a required field
	S3Data *VectorEnrichmentJobS3Data `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportVectorEnrichmentJobOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportVectorEnrichmentJobOutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportVectorEnrichmentJobOutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportVectorEnrichmentJobOutputConfig"}
	if s.S3Data == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Data"))
	}
	if s.S3Data != nil {
		if err := s.S3Data.Validate(); err != nil {
			invalidParams.AddNested("S3Data", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Data sets the S3Data field's value.
func (s *ExportVectorEnrichmentJobOutputConfig) SetS3Data(v *VectorEnrichmentJobS3Data) *ExportVectorEnrichmentJobOutputConfig {
	s.S3Data = v
	return s
}

// The structure representing the filters supported by a RasterDataCollection.
type Filter struct {
	_ struct{} `type:"structure"`

	// The maximum value of the filter.
	Maximum *float64 `type:"float"`

	// The minimum value of the filter.
	Minimum *float64 `type:"float"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The type of the filter being used.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// SetMaximum sets the Maximum field's value.
func (s *Filter) SetMaximum(v float64) *Filter {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *Filter) SetMinimum(v float64) *Filter {
	s.Minimum = &v
	return s
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Filter) SetType(v string) *Filter {
	s.Type = &v
	return s
}

// Input configuration information for the geomosaic.
type GeoMosaicConfigInput_ struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm being used for geomosaic.
	AlgorithmName *string `type:"string" enum:"AlgorithmNameGeoMosaic"`

	// The target bands for geomosaic.
	TargetBands []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeoMosaicConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeoMosaicConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoMosaicConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoMosaicConfigInput_"}
	if s.TargetBands != nil && len(s.TargetBands) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetBands", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *GeoMosaicConfigInput_) SetAlgorithmName(v string) *GeoMosaicConfigInput_ {
	s.AlgorithmName = &v
	return s
}

// SetTargetBands sets the TargetBands field's value.
func (s *GeoMosaicConfigInput_) SetTargetBands(v []*string) *GeoMosaicConfigInput_ {
	s.TargetBands = v
	return s
}

// The structure representing a Geometry in terms of Type and Coordinates as
// per GeoJson spec.
type Geometry struct {
	_ struct{} `type:"structure"`

	// The coordinates of the GeoJson Geometry.
	//
	// Coordinates is a required field
	Coordinates [][][]*float64 `min:"1" type:"list" required:"true"`

	// GeoJson Geometry types like Polygon and MultiPolygon.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Geometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Geometry) GoString() string {
	return s.String()
}

// SetCoordinates sets the Coordinates field's value.
func (s *Geometry) SetCoordinates(v [][][]*float64) *Geometry {
	s.Coordinates = v
	return s
}

// SetType sets the Type field's value.
func (s *Geometry) SetType(v string) *Geometry {
	s.Type = &v
	return s
}

type GetEarthObservationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Earth Observation job.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEarthObservationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEarthObservationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEarthObservationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEarthObservationJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetEarthObservationJobInput) SetArn(v string) *GetEarthObservationJobInput {
	s.Arn = &v
	return s
}

type GetEarthObservationJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Earth Observation job.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The creation time of the initiated Earth Observation job.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The duration of Earth Observation job, in seconds.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `type:"integer" required:"true"`

	// Details about the errors generated during the Earth Observation job.
	ErrorDetails *EarthObservationJobErrorDetails `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// job.
	ExecutionRoleArn *string `min:"20" type:"string"`

	// Details about the errors generated during ExportEarthObservationJob.
	ExportErrorDetails *ExportErrorDetails `type:"structure"`

	// The status of the Earth Observation job.
	ExportStatus *string `type:"string" enum:"EarthObservationJobExportStatus"`

	// Input data for the Earth Observation job.
	//
	// InputConfig is a required field
	InputConfig *InputConfigOutput_ `type:"structure" required:"true"`

	// An object containing information about the job configuration.
	//
	// JobConfig is a required field
	JobConfig *JobConfigInput_ `type:"structure" required:"true"`

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The name of the Earth Observation job.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Bands available in the output of an operation.
	OutputBands []*OutputBand `type:"list"`

	// The status of a previously initiated Earth Observation job.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"EarthObservationJobStatus"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEarthObservationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEarthObservationJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetEarthObservationJobOutput) SetArn(v string) *GetEarthObservationJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetEarthObservationJobOutput) SetCreationTime(v time.Time) *GetEarthObservationJobOutput {
	s.CreationTime = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *GetEarthObservationJobOutput) SetDurationInSeconds(v int64) *GetEarthObservationJobOutput {
	s.DurationInSeconds = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *GetEarthObservationJobOutput) SetErrorDetails(v *EarthObservationJobErrorDetails) *GetEarthObservationJobOutput {
	s.ErrorDetails = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *GetEarthObservationJobOutput) SetExecutionRoleArn(v string) *GetEarthObservationJobOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetExportErrorDetails sets the ExportErrorDetails field's value.
func (s *GetEarthObservationJobOutput) SetExportErrorDetails(v *ExportErrorDetails) *GetEarthObservationJobOutput {
	s.ExportErrorDetails = v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *GetEarthObservationJobOutput) SetExportStatus(v string) *GetEarthObservationJobOutput {
	s.ExportStatus = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *GetEarthObservationJobOutput) SetInputConfig(v *InputConfigOutput_) *GetEarthObservationJobOutput {
	s.InputConfig = v
	return s
}

// SetJobConfig sets the JobConfig field's value.
func (s *GetEarthObservationJobOutput) SetJobConfig(v *JobConfigInput_) *GetEarthObservationJobOutput {
	s.JobConfig = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *GetEarthObservationJobOutput) SetKmsKeyId(v string) *GetEarthObservationJobOutput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEarthObservationJobOutput) SetName(v string) *GetEarthObservationJobOutput {
	s.Name = &v
	return s
}

// SetOutputBands sets the OutputBands field's value.
func (s *GetEarthObservationJobOutput) SetOutputBands(v []*OutputBand) *GetEarthObservationJobOutput {
	s.OutputBands = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetEarthObservationJobOutput) SetStatus(v string) *GetEarthObservationJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEarthObservationJobOutput) SetTags(v map[string]*string) *GetEarthObservationJobOutput {
	s.Tags = v
	return s
}

type GetRasterDataCollectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the raster data collection.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRasterDataCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRasterDataCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRasterDataCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRasterDataCollectionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetRasterDataCollectionInput) SetArn(v string) *GetRasterDataCollectionInput {
	s.Arn = &v
	return s
}

type GetRasterDataCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the raster data collection.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A description of the raster data collection.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The URL of the description page.
	//
	// DescriptionPageUrl is a required field
	DescriptionPageUrl *string `type:"string" required:"true"`

	// The list of image source bands in the raster data collection.
	//
	// ImageSourceBands is a required field
	ImageSourceBands []*string `type:"list" required:"true"`

	// The name of the raster data collection.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The filters supported by the raster data collection.
	//
	// SupportedFilters is a required field
	SupportedFilters []*Filter `type:"list" required:"true"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`

	// The raster data collection type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataCollectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRasterDataCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRasterDataCollectionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetRasterDataCollectionOutput) SetArn(v string) *GetRasterDataCollectionOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetRasterDataCollectionOutput) SetDescription(v string) *GetRasterDataCollectionOutput {
	s.Description = &v
	return s
}

// SetDescriptionPageUrl sets the DescriptionPageUrl field's value.
func (s *GetRasterDataCollectionOutput) SetDescriptionPageUrl(v string) *GetRasterDataCollectionOutput {
	s.DescriptionPageUrl = &v
	return s
}

// SetImageSourceBands sets the ImageSourceBands field's value.
func (s *GetRasterDataCollectionOutput) SetImageSourceBands(v []*string) *GetRasterDataCollectionOutput {
	s.ImageSourceBands = v
	return s
}

// SetName sets the Name field's value.
func (s *GetRasterDataCollectionOutput) SetName(v string) *GetRasterDataCollectionOutput {
	s.Name = &v
	return s
}

// SetSupportedFilters sets the SupportedFilters field's value.
func (s *GetRasterDataCollectionOutput) SetSupportedFilters(v []*Filter) *GetRasterDataCollectionOutput {
	s.SupportedFilters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetRasterDataCollectionOutput) SetTags(v map[string]*string) *GetRasterDataCollectionOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *GetRasterDataCollectionOutput) SetType(v string) *GetRasterDataCollectionOutput {
	s.Type = &v
	return s
}

type GetTileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the tile operation.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"Arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that you specify.
	ExecutionRoleArn *string `location:"querystring" locationName:"ExecutionRoleArn" min:"20" type:"string"`

	// The particular assets or bands to tile.
	//
	// ImageAssets is a required field
	ImageAssets []*string `location:"querystring" locationName:"ImageAssets" min:"1" type:"list" required:"true"`

	// Determines whether or not to return a valid data mask.
	ImageMask *bool `location:"querystring" locationName:"ImageMask" type:"boolean"`

	// The output data type of the tile operation.
	OutputDataType *string `location:"querystring" locationName:"OutputDataType" type:"string" enum:"OutputType"`

	// The data format of the output tile. The formats include .npy, .png and .jpg.
	OutputFormat *string `location:"querystring" locationName:"OutputFormat" type:"string"`

	// Property filters for the imagery to tile.
	PropertyFilters *string `location:"querystring" locationName:"PropertyFilters" type:"string"`

	// Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT'
	// are the valid options.
	//
	// Target is a required field
	Target *string `location:"querystring" locationName:"Target" type:"string" required:"true" enum:"TargetOptions"`

	// Time range filter applied to imagery to find the images to tile.
	TimeRangeFilter *string `location:"querystring" locationName:"TimeRangeFilter" type:"string"`

	// The x coordinate of the tile input.
	//
	// X is a required field
	X *int64 `location:"uri" locationName:"x" type:"integer" required:"true"`

	// The y coordinate of the tile input.
	//
	// Y is a required field
	Y *int64 `location:"uri" locationName:"y" type:"integer" required:"true"`

	// The z coordinate of the tile input.
	//
	// Z is a required field
	Z *int64 `location:"uri" locationName:"z" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTileInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.ImageAssets == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageAssets"))
	}
	if s.ImageAssets != nil && len(s.ImageAssets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageAssets", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.X == nil {
		invalidParams.Add(request.NewErrParamRequired("X"))
	}
	if s.Y == nil {
		invalidParams.Add(request.NewErrParamRequired("Y"))
	}
	if s.Z == nil {
		invalidParams.Add(request.NewErrParamRequired("Z"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetTileInput) SetArn(v string) *GetTileInput {
	s.Arn = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *GetTileInput) SetExecutionRoleArn(v string) *GetTileInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetImageAssets sets the ImageAssets field's value.
func (s *GetTileInput) SetImageAssets(v []*string) *GetTileInput {
	s.ImageAssets = v
	return s
}

// SetImageMask sets the ImageMask field's value.
func (s *GetTileInput) SetImageMask(v bool) *GetTileInput {
	s.ImageMask = &v
	return s
}

// SetOutputDataType sets the OutputDataType field's value.
func (s *GetTileInput) SetOutputDataType(v string) *GetTileInput {
	s.OutputDataType = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *GetTileInput) SetOutputFormat(v string) *GetTileInput {
	s.OutputFormat = &v
	return s
}

// SetPropertyFilters sets the PropertyFilters field's value.
func (s *GetTileInput) SetPropertyFilters(v string) *GetTileInput {
	s.PropertyFilters = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *GetTileInput) SetTarget(v string) *GetTileInput {
	s.Target = &v
	return s
}

// SetTimeRangeFilter sets the TimeRangeFilter field's value.
func (s *GetTileInput) SetTimeRangeFilter(v string) *GetTileInput {
	s.TimeRangeFilter = &v
	return s
}

// SetX sets the X field's value.
func (s *GetTileInput) SetX(v int64) *GetTileInput {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *GetTileInput) SetY(v int64) *GetTileInput {
	s.Y = &v
	return s
}

// SetZ sets the Z field's value.
func (s *GetTileInput) SetZ(v int64) *GetTileInput {
	s.Z = &v
	return s
}

type GetTileOutput struct {
	_ struct{} `type:"structure" payload:"BinaryFile"`

	// The output binary file.
	BinaryFile io.ReadCloser `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTileOutput) GoString() string {
	return s.String()
}

// SetBinaryFile sets the BinaryFile field's value.
func (s *GetTileOutput) SetBinaryFile(v io.ReadCloser) *GetTileOutput {
	s.BinaryFile = v
	return s
}

type GetVectorEnrichmentJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Vector Enrichment job.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVectorEnrichmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVectorEnrichmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVectorEnrichmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVectorEnrichmentJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetVectorEnrichmentJobInput) SetArn(v string) *GetVectorEnrichmentJobInput {
	s.Arn = &v
	return s
}

type GetVectorEnrichmentJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Vector Enrichment job.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The duration of the Vector Enrichment job, in seconds.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `type:"integer" required:"true"`

	// Details about the errors generated during the Vector Enrichment job.
	ErrorDetails *VectorEnrichmentJobErrorDetails `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// job.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// Details about the errors generated during the ExportVectorEnrichmentJob.
	ExportErrorDetails *VectorEnrichmentJobExportErrorDetails `type:"structure"`

	// The export status of the Vector Enrichment job being initiated.
	ExportStatus *string `type:"string" enum:"VectorEnrichmentJobExportStatus"`

	// Input configuration information for the Vector Enrichment job.
	//
	// InputConfig is a required field
	InputConfig *VectorEnrichmentJobInputConfig `type:"structure" required:"true"`

	// An object containing information about the job configuration.
	//
	// JobConfig is a required field
	JobConfig *VectorEnrichmentJobConfig `type:"structure" required:"true"`

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The name of the Vector Enrichment job.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The status of the initiated Vector Enrichment job.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"VectorEnrichmentJobStatus"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`

	// The type of the Vector Enrichment job being initiated.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"VectorEnrichmentJobType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVectorEnrichmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVectorEnrichmentJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetVectorEnrichmentJobOutput) SetArn(v string) *GetVectorEnrichmentJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetVectorEnrichmentJobOutput) SetCreationTime(v time.Time) *GetVectorEnrichmentJobOutput {
	s.CreationTime = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *GetVectorEnrichmentJobOutput) SetDurationInSeconds(v int64) *GetVectorEnrichmentJobOutput {
	s.DurationInSeconds = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *GetVectorEnrichmentJobOutput) SetErrorDetails(v *VectorEnrichmentJobErrorDetails) *GetVectorEnrichmentJobOutput {
	s.ErrorDetails = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *GetVectorEnrichmentJobOutput) SetExecutionRoleArn(v string) *GetVectorEnrichmentJobOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetExportErrorDetails sets the ExportErrorDetails field's value.
func (s *GetVectorEnrichmentJobOutput) SetExportErrorDetails(v *VectorEnrichmentJobExportErrorDetails) *GetVectorEnrichmentJobOutput {
	s.ExportErrorDetails = v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *GetVectorEnrichmentJobOutput) SetExportStatus(v string) *GetVectorEnrichmentJobOutput {
	s.ExportStatus = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *GetVectorEnrichmentJobOutput) SetInputConfig(v *VectorEnrichmentJobInputConfig) *GetVectorEnrichmentJobOutput {
	s.InputConfig = v
	return s
}

// SetJobConfig sets the JobConfig field's value.
func (s *GetVectorEnrichmentJobOutput) SetJobConfig(v *VectorEnrichmentJobConfig) *GetVectorEnrichmentJobOutput {
	s.JobConfig = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *GetVectorEnrichmentJobOutput) SetKmsKeyId(v string) *GetVectorEnrichmentJobOutput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetVectorEnrichmentJobOutput) SetName(v string) *GetVectorEnrichmentJobOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetVectorEnrichmentJobOutput) SetStatus(v string) *GetVectorEnrichmentJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetVectorEnrichmentJobOutput) SetTags(v map[string]*string) *GetVectorEnrichmentJobOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *GetVectorEnrichmentJobOutput) SetType(v string) *GetVectorEnrichmentJobOutput {
	s.Type = &v
	return s
}

// Input configuration information.
type InputConfigInput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the previous Earth Observation job.
	PreviousEarthObservationJobArn *string `type:"string"`

	// The structure representing the RasterDataCollection Query consisting of the
	// Area of Interest, RasterDataCollectionArn,TimeRange and Property Filters.
	RasterDataCollectionQuery *RasterDataCollectionQueryInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputConfigInput_"}
	if s.RasterDataCollectionQuery != nil {
		if err := s.RasterDataCollectionQuery.Validate(); err != nil {
			invalidParams.AddNested("RasterDataCollectionQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPreviousEarthObservationJobArn sets the PreviousEarthObservationJobArn field's value.
func (s *InputConfigInput_) SetPreviousEarthObservationJobArn(v string) *InputConfigInput_ {
	s.PreviousEarthObservationJobArn = &v
	return s
}

// SetRasterDataCollectionQuery sets the RasterDataCollectionQuery field's value.
func (s *InputConfigInput_) SetRasterDataCollectionQuery(v *RasterDataCollectionQueryInput_) *InputConfigInput_ {
	s.RasterDataCollectionQuery = v
	return s
}

// The InputConfig for an EarthObservationJob response.
type InputConfigOutput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the previous Earth Observation job.
	PreviousEarthObservationJobArn *string `type:"string"`

	// The structure representing the RasterDataCollection Query consisting of the
	// Area of Interest, RasterDataCollectionArn, RasterDataCollectionName, TimeRange,
	// and Property Filters.
	RasterDataCollectionQuery *RasterDataCollectionQueryOutput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputConfigOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputConfigOutput_) GoString() string {
	return s.String()
}

// SetPreviousEarthObservationJobArn sets the PreviousEarthObservationJobArn field's value.
func (s *InputConfigOutput_) SetPreviousEarthObservationJobArn(v string) *InputConfigOutput_ {
	s.PreviousEarthObservationJobArn = &v
	return s
}

// SetRasterDataCollectionQuery sets the RasterDataCollectionQuery field's value.
func (s *InputConfigOutput_) SetRasterDataCollectionQuery(v *RasterDataCollectionQueryOutput_) *InputConfigOutput_ {
	s.RasterDataCollectionQuery = v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The structure representing the items in the response for SearchRasterDataCollection.
type ItemSource struct {
	_ struct{} `type:"structure"`

	// This is a dictionary of Asset Objects data associated with the Item that
	// can be downloaded or streamed, each with a unique key.
	Assets map[string]*AssetValue `type:"map"`

	// The searchable date and time of the item, in UTC.
	//
	// DateTime is a required field
	DateTime *time.Time `type:"timestamp" required:"true"`

	// The item Geometry in GeoJson format.
	//
	// Geometry is a required field
	Geometry *Geometry `type:"structure" required:"true"`

	// A unique Id for the source item.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// This field contains additional properties of the item.
	Properties *Properties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItemSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItemSource) GoString() string {
	return s.String()
}

// SetAssets sets the Assets field's value.
func (s *ItemSource) SetAssets(v map[string]*AssetValue) *ItemSource {
	s.Assets = v
	return s
}

// SetDateTime sets the DateTime field's value.
func (s *ItemSource) SetDateTime(v time.Time) *ItemSource {
	s.DateTime = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *ItemSource) SetGeometry(v *Geometry) *ItemSource {
	s.Geometry = v
	return s
}

// SetId sets the Id field's value.
func (s *ItemSource) SetId(v string) *ItemSource {
	s.Id = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *ItemSource) SetProperties(v *Properties) *ItemSource {
	s.Properties = v
	return s
}

// The input structure for the JobConfig in an EarthObservationJob.
type JobConfigInput_ struct {
	_ struct{} `type:"structure"`

	// An object containing information about the job configuration for BandMath.
	BandMathConfig *BandMathConfigInput_ `type:"structure"`

	// An object containing information about the job configuration for cloud masking.
	CloudMaskingConfig *CloudMaskingConfigInput_ `type:"structure"`

	// An object containing information about the job configuration for cloud removal.
	CloudRemovalConfig *CloudRemovalConfigInput_ `type:"structure"`

	// An object containing information about the job configuration for geomosaic.
	GeoMosaicConfig *GeoMosaicConfigInput_ `type:"structure"`

	// An object containing information about the job configuration for land cover
	// segmentation.
	LandCoverSegmentationConfig *LandCoverSegmentationConfigInput_ `type:"structure"`

	// An object containing information about the job configuration for resampling.
	ResamplingConfig *ResamplingConfigInput_ `type:"structure"`

	// An object containing information about the job configuration for a Stacking
	// Earth Observation job.
	StackConfig *StackConfigInput_ `type:"structure"`

	// An object containing information about the job configuration for temporal
	// statistics.
	TemporalStatisticsConfig *TemporalStatisticsConfigInput_ `type:"structure"`

	// An object containing information about the job configuration for zonal statistics.
	ZonalStatisticsConfig *ZonalStatisticsConfigInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobConfigInput_"}
	if s.BandMathConfig != nil {
		if err := s.BandMathConfig.Validate(); err != nil {
			invalidParams.AddNested("BandMathConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudRemovalConfig != nil {
		if err := s.CloudRemovalConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudRemovalConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.GeoMosaicConfig != nil {
		if err := s.GeoMosaicConfig.Validate(); err != nil {
			invalidParams.AddNested("GeoMosaicConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ResamplingConfig != nil {
		if err := s.ResamplingConfig.Validate(); err != nil {
			invalidParams.AddNested("ResamplingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.StackConfig != nil {
		if err := s.StackConfig.Validate(); err != nil {
			invalidParams.AddNested("StackConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.TemporalStatisticsConfig != nil {
		if err := s.TemporalStatisticsConfig.Validate(); err != nil {
			invalidParams.AddNested("TemporalStatisticsConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ZonalStatisticsConfig != nil {
		if err := s.ZonalStatisticsConfig.Validate(); err != nil {
			invalidParams.AddNested("ZonalStatisticsConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandMathConfig sets the BandMathConfig field's value.
func (s *JobConfigInput_) SetBandMathConfig(v *BandMathConfigInput_) *JobConfigInput_ {
	s.BandMathConfig = v
	return s
}

// SetCloudMaskingConfig sets the CloudMaskingConfig field's value.
func (s *JobConfigInput_) SetCloudMaskingConfig(v *CloudMaskingConfigInput_) *JobConfigInput_ {
	s.CloudMaskingConfig = v
	return s
}

// SetCloudRemovalConfig sets the CloudRemovalConfig field's value.
func (s *JobConfigInput_) SetCloudRemovalConfig(v *CloudRemovalConfigInput_) *JobConfigInput_ {
	s.CloudRemovalConfig = v
	return s
}

// SetGeoMosaicConfig sets the GeoMosaicConfig field's value.
func (s *JobConfigInput_) SetGeoMosaicConfig(v *GeoMosaicConfigInput_) *JobConfigInput_ {
	s.GeoMosaicConfig = v
	return s
}

// SetLandCoverSegmentationConfig sets the LandCoverSegmentationConfig field's value.
func (s *JobConfigInput_) SetLandCoverSegmentationConfig(v *LandCoverSegmentationConfigInput_) *JobConfigInput_ {
	s.LandCoverSegmentationConfig = v
	return s
}

// SetResamplingConfig sets the ResamplingConfig field's value.
func (s *JobConfigInput_) SetResamplingConfig(v *ResamplingConfigInput_) *JobConfigInput_ {
	s.ResamplingConfig = v
	return s
}

// SetStackConfig sets the StackConfig field's value.
func (s *JobConfigInput_) SetStackConfig(v *StackConfigInput_) *JobConfigInput_ {
	s.StackConfig = v
	return s
}

// SetTemporalStatisticsConfig sets the TemporalStatisticsConfig field's value.
func (s *JobConfigInput_) SetTemporalStatisticsConfig(v *TemporalStatisticsConfigInput_) *JobConfigInput_ {
	s.TemporalStatisticsConfig = v
	return s
}

// SetZonalStatisticsConfig sets the ZonalStatisticsConfig field's value.
func (s *JobConfigInput_) SetZonalStatisticsConfig(v *ZonalStatisticsConfigInput_) *JobConfigInput_ {
	s.ZonalStatisticsConfig = v
	return s
}

// The input structure for Land Cover Operation type.
type LandCoverSegmentationConfigInput_ struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LandCoverSegmentationConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LandCoverSegmentationConfigInput_) GoString() string {
	return s.String()
}

// The structure representing Land Cloud Cover property for Landsat data collection.
type LandsatCloudCoverLandInput_ struct {
	_ struct{} `type:"structure"`

	// The minimum value for Land Cloud Cover property filter. This will filter
	// items having Land Cloud Cover greater than or equal to this value.
	//
	// LowerBound is a required field
	LowerBound *float64 `type:"float" required:"true"`

	// The maximum value for Land Cloud Cover property filter. This will filter
	// items having Land Cloud Cover less than or equal to this value.
	//
	// UpperBound is a required field
	UpperBound *float64 `type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LandsatCloudCoverLandInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LandsatCloudCoverLandInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LandsatCloudCoverLandInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LandsatCloudCoverLandInput_"}
	if s.LowerBound == nil {
		invalidParams.Add(request.NewErrParamRequired("LowerBound"))
	}
	if s.UpperBound == nil {
		invalidParams.Add(request.NewErrParamRequired("UpperBound"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLowerBound sets the LowerBound field's value.
func (s *LandsatCloudCoverLandInput_) SetLowerBound(v float64) *LandsatCloudCoverLandInput_ {
	s.LowerBound = &v
	return s
}

// SetUpperBound sets the UpperBound field's value.
func (s *LandsatCloudCoverLandInput_) SetUpperBound(v float64) *LandsatCloudCoverLandInput_ {
	s.UpperBound = &v
	return s
}

// An object containing information about the output file.
type ListEarthObservationJobOutputConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the list of the Earth Observation jobs.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The duration of the session, in seconds.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `type:"integer" required:"true"`

	// The names of the Earth Observation jobs in the list.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The operation type for an Earth Observation job.
	//
	// OperationType is a required field
	OperationType *string `type:"string" required:"true"`

	// The status of the list of the Earth Observation jobs.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"EarthObservationJobStatus"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEarthObservationJobOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEarthObservationJobOutputConfig) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListEarthObservationJobOutputConfig) SetArn(v string) *ListEarthObservationJobOutputConfig {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ListEarthObservationJobOutputConfig) SetCreationTime(v time.Time) *ListEarthObservationJobOutputConfig {
	s.CreationTime = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *ListEarthObservationJobOutputConfig) SetDurationInSeconds(v int64) *ListEarthObservationJobOutputConfig {
	s.DurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListEarthObservationJobOutputConfig) SetName(v string) *ListEarthObservationJobOutputConfig {
	s.Name = &v
	return s
}

// SetOperationType sets the OperationType field's value.
func (s *ListEarthObservationJobOutputConfig) SetOperationType(v string) *ListEarthObservationJobOutputConfig {
	s.OperationType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListEarthObservationJobOutputConfig) SetStatus(v string) *ListEarthObservationJobOutputConfig {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListEarthObservationJobOutputConfig) SetTags(v map[string]*string) *ListEarthObservationJobOutputConfig {
	s.Tags = v
	return s
}

type ListEarthObservationJobsInput struct {
	_ struct{} `type:"structure"`

	// The total number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was truncated, you receive this token. Use it in
	// your next request to receive the next set of results.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListEarthObservationJobsInput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`

	// The parameter by which to sort the results.
	SortBy *string `type:"string"`

	// An optional value that specifies whether you want the results sorted in Ascending
	// or Descending order.
	SortOrder *string `type:"string" enum:"SortOrder"`

	// A filter that retrieves only jobs with a specific status.
	StatusEquals *string `type:"string" enum:"EarthObservationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEarthObservationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEarthObservationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEarthObservationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEarthObservationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEarthObservationJobsInput) SetMaxResults(v int64) *ListEarthObservationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEarthObservationJobsInput) SetNextToken(v string) *ListEarthObservationJobsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListEarthObservationJobsInput) SetSortBy(v string) *ListEarthObservationJobsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListEarthObservationJobsInput) SetSortOrder(v string) *ListEarthObservationJobsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListEarthObservationJobsInput) SetStatusEquals(v string) *ListEarthObservationJobsInput {
	s.StatusEquals = &v
	return s
}

type ListEarthObservationJobsOutput struct {
	_ struct{} `type:"structure"`

	// Contains summary information about the Earth Observation jobs.
	//
	// EarthObservationJobSummaries is a required field
	EarthObservationJobSummaries []*ListEarthObservationJobOutputConfig `type:"list" required:"true"`

	// If the previous response was truncated, you receive this token. Use it in
	// your next request to receive the next set of results.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListEarthObservationJobsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEarthObservationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEarthObservationJobsOutput) GoString() string {
	return s.String()
}

// SetEarthObservationJobSummaries sets the EarthObservationJobSummaries field's value.
func (s *ListEarthObservationJobsOutput) SetEarthObservationJobSummaries(v []*ListEarthObservationJobOutputConfig) *ListEarthObservationJobsOutput {
	s.EarthObservationJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEarthObservationJobsOutput) SetNextToken(v string) *ListEarthObservationJobsOutput {
	s.NextToken = &v
	return s
}

type ListRasterDataCollectionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The total number of items to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// If the previous response was truncated, you receive this token. Use it in
	// your next request to receive the next set of results.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListRasterDataCollectionsInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRasterDataCollectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRasterDataCollectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRasterDataCollectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRasterDataCollectionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRasterDataCollectionsInput) SetMaxResults(v int64) *ListRasterDataCollectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRasterDataCollectionsInput) SetNextToken(v string) *ListRasterDataCollectionsInput {
	s.NextToken = &v
	return s
}

type ListRasterDataCollectionsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was truncated, you receive this token. Use it in
	// your next request to receive the next set of results.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListRasterDataCollectionsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`

	// Contains summary information about the raster data collection.
	//
	// RasterDataCollectionSummaries is a required field
	RasterDataCollectionSummaries []*RasterDataCollectionMetadata `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRasterDataCollectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRasterDataCollectionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRasterDataCollectionsOutput) SetNextToken(v string) *ListRasterDataCollectionsOutput {
	s.NextToken = &v
	return s
}

// SetRasterDataCollectionSummaries sets the RasterDataCollectionSummaries field's value.
func (s *ListRasterDataCollectionsOutput) SetRasterDataCollectionSummaries(v []*RasterDataCollectionMetadata) *ListRasterDataCollectionsOutput {
	s.RasterDataCollectionSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// An object containing information about the output file.
type ListVectorEnrichmentJobOutputConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the list of the Vector Enrichment jobs.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The duration of the session, in seconds.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `type:"integer" required:"true"`

	// The names of the Vector Enrichment jobs in the list.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The status of the Vector Enrichment jobs list.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"VectorEnrichmentJobStatus"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`

	// The type of the list of Vector Enrichment jobs.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"VectorEnrichmentJobType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVectorEnrichmentJobOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVectorEnrichmentJobOutputConfig) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListVectorEnrichmentJobOutputConfig) SetArn(v string) *ListVectorEnrichmentJobOutputConfig {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ListVectorEnrichmentJobOutputConfig) SetCreationTime(v time.Time) *ListVectorEnrichmentJobOutputConfig {
	s.CreationTime = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *ListVectorEnrichmentJobOutputConfig) SetDurationInSeconds(v int64) *ListVectorEnrichmentJobOutputConfig {
	s.DurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListVectorEnrichmentJobOutputConfig) SetName(v string) *ListVectorEnrichmentJobOutputConfig {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListVectorEnrichmentJobOutputConfig) SetStatus(v string) *ListVectorEnrichmentJobOutputConfig {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListVectorEnrichmentJobOutputConfig) SetTags(v map[string]*string) *ListVectorEnrichmentJobOutputConfig {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ListVectorEnrichmentJobOutputConfig) SetType(v string) *ListVectorEnrichmentJobOutputConfig {
	s.Type = &v
	return s
}

type ListVectorEnrichmentJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was truncated, you receive this token. Use it in
	// your next request to receive the next set of results.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListVectorEnrichmentJobsInput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`

	// The parameter by which to sort the results.
	SortBy *string `type:"string"`

	// An optional value that specifies whether you want the results sorted in Ascending
	// or Descending order.
	SortOrder *string `type:"string" enum:"SortOrder"`

	// A filter that retrieves only jobs with a specific status.
	StatusEquals *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVectorEnrichmentJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVectorEnrichmentJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVectorEnrichmentJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVectorEnrichmentJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVectorEnrichmentJobsInput) SetMaxResults(v int64) *ListVectorEnrichmentJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVectorEnrichmentJobsInput) SetNextToken(v string) *ListVectorEnrichmentJobsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListVectorEnrichmentJobsInput) SetSortBy(v string) *ListVectorEnrichmentJobsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListVectorEnrichmentJobsInput) SetSortOrder(v string) *ListVectorEnrichmentJobsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListVectorEnrichmentJobsInput) SetStatusEquals(v string) *ListVectorEnrichmentJobsInput {
	s.StatusEquals = &v
	return s
}

type ListVectorEnrichmentJobsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was truncated, you receive this token. Use it in
	// your next request to receive the next set of results.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListVectorEnrichmentJobsOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`

	// Contains summary information about the Vector Enrichment jobs.
	//
	// VectorEnrichmentJobSummaries is a required field
	VectorEnrichmentJobSummaries []*ListVectorEnrichmentJobOutputConfig `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVectorEnrichmentJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVectorEnrichmentJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVectorEnrichmentJobsOutput) SetNextToken(v string) *ListVectorEnrichmentJobsOutput {
	s.NextToken = &v
	return s
}

// SetVectorEnrichmentJobSummaries sets the VectorEnrichmentJobSummaries field's value.
func (s *ListVectorEnrichmentJobsOutput) SetVectorEnrichmentJobSummaries(v []*ListVectorEnrichmentJobOutputConfig) *ListVectorEnrichmentJobsOutput {
	s.VectorEnrichmentJobSummaries = v
	return s
}

// The input structure for Map Matching operation type.
type MapMatchingConfig struct {
	_ struct{} `type:"structure"`

	// The field name for the data that describes the identifier representing a
	// collection of GPS points belonging to an individual trace.
	//
	// IdAttributeName is a required field
	IdAttributeName *string `type:"string" required:"true"`

	// The name of the timestamp attribute.
	//
	// TimestampAttributeName is a required field
	TimestampAttributeName *string `type:"string" required:"true"`

	// The name of the X-attribute
	//
	// XAttributeName is a required field
	XAttributeName *string `type:"string" required:"true"`

	// The name of the Y-attribute
	//
	// YAttributeName is a required field
	YAttributeName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MapMatchingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MapMatchingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MapMatchingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MapMatchingConfig"}
	if s.IdAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdAttributeName"))
	}
	if s.TimestampAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TimestampAttributeName"))
	}
	if s.XAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("XAttributeName"))
	}
	if s.YAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("YAttributeName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdAttributeName sets the IdAttributeName field's value.
func (s *MapMatchingConfig) SetIdAttributeName(v string) *MapMatchingConfig {
	s.IdAttributeName = &v
	return s
}

// SetTimestampAttributeName sets the TimestampAttributeName field's value.
func (s *MapMatchingConfig) SetTimestampAttributeName(v string) *MapMatchingConfig {
	s.TimestampAttributeName = &v
	return s
}

// SetXAttributeName sets the XAttributeName field's value.
func (s *MapMatchingConfig) SetXAttributeName(v string) *MapMatchingConfig {
	s.XAttributeName = &v
	return s
}

// SetYAttributeName sets the YAttributeName field's value.
func (s *MapMatchingConfig) SetYAttributeName(v string) *MapMatchingConfig {
	s.YAttributeName = &v
	return s
}

// The structure representing Polygon Geometry based on the GeoJson spec (https://www.rfc-editor.org/rfc/rfc7946#section-3.1.6).
type MultiPolygonGeometryInput_ struct {
	_ struct{} `type:"structure"`

	// The coordinates of the multipolygon geometry.
	//
	// Coordinates is a required field
	Coordinates [][][][]*float64 `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiPolygonGeometryInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiPolygonGeometryInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiPolygonGeometryInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiPolygonGeometryInput_"}
	if s.Coordinates == nil {
		invalidParams.Add(request.NewErrParamRequired("Coordinates"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoordinates sets the Coordinates field's value.
func (s *MultiPolygonGeometryInput_) SetCoordinates(v [][][][]*float64) *MultiPolygonGeometryInput_ {
	s.Coordinates = v
	return s
}

// Represents an arithmetic operation to compute spectral index.
type Operation struct {
	_ struct{} `type:"structure"`

	// Textual representation of the math operation; Equation used to compute the
	// spectral index.
	//
	// Equation is a required field
	Equation *string `type:"string" required:"true"`

	// The name of the operation.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The type of the operation.
	OutputType *string `type:"string" enum:"OutputType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Operation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Operation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Operation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Operation"}
	if s.Equation == nil {
		invalidParams.Add(request.NewErrParamRequired("Equation"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEquation sets the Equation field's value.
func (s *Operation) SetEquation(v string) *Operation {
	s.Equation = &v
	return s
}

// SetName sets the Name field's value.
func (s *Operation) SetName(v string) *Operation {
	s.Name = &v
	return s
}

// SetOutputType sets the OutputType field's value.
func (s *Operation) SetOutputType(v string) *Operation {
	s.OutputType = &v
	return s
}

// A single EarthObservationJob output band.
type OutputBand struct {
	_ struct{} `type:"structure"`

	// The name of the band.
	//
	// BandName is a required field
	BandName *string `type:"string" required:"true"`

	// The datatype of the output band.
	//
	// OutputDataType is a required field
	OutputDataType *string `type:"string" required:"true" enum:"OutputType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputBand) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputBand) GoString() string {
	return s.String()
}

// SetBandName sets the BandName field's value.
func (s *OutputBand) SetBandName(v string) *OutputBand {
	s.BandName = &v
	return s
}

// SetOutputDataType sets the OutputDataType field's value.
func (s *OutputBand) SetOutputDataType(v string) *OutputBand {
	s.OutputDataType = &v
	return s
}

// The response structure for an OutputConfig returned by an ExportEarthObservationJob.
type OutputConfigInput_ struct {
	_ struct{} `type:"structure"`

	// Path to Amazon S3 storage location for the output configuration file.
	//
	// S3Data is a required field
	S3Data *ExportS3DataInput_ `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputConfigInput_"}
	if s.S3Data == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Data"))
	}
	if s.S3Data != nil {
		if err := s.S3Data.Validate(); err != nil {
			invalidParams.AddNested("S3Data", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Data sets the S3Data field's value.
func (s *OutputConfigInput_) SetS3Data(v *ExportS3DataInput_) *OutputConfigInput_ {
	s.S3Data = v
	return s
}

// OutputResolution Configuration indicating the target resolution for the output
// of Resampling operation.
type OutputResolutionResamplingInput_ struct {
	_ struct{} `type:"structure"`

	// User Defined Resolution for the output of Resampling operation defined by
	// value and unit.
	//
	// UserDefined is a required field
	UserDefined *UserDefined `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputResolutionResamplingInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputResolutionResamplingInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputResolutionResamplingInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputResolutionResamplingInput_"}
	if s.UserDefined == nil {
		invalidParams.Add(request.NewErrParamRequired("UserDefined"))
	}
	if s.UserDefined != nil {
		if err := s.UserDefined.Validate(); err != nil {
			invalidParams.AddNested("UserDefined", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserDefined sets the UserDefined field's value.
func (s *OutputResolutionResamplingInput_) SetUserDefined(v *UserDefined) *OutputResolutionResamplingInput_ {
	s.UserDefined = v
	return s
}

// The input structure representing Output Resolution for Stacking Operation.
type OutputResolutionStackInput_ struct {
	_ struct{} `type:"structure"`

	// A string value representing Predefined Output Resolution for a stacking operation.
	// Allowed values are HIGHEST, LOWEST, and AVERAGE.
	Predefined *string `type:"string" enum:"PredefinedResolution"`

	// The structure representing User Output Resolution for a Stacking operation
	// defined as a value and unit.
	UserDefined *UserDefined `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputResolutionStackInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputResolutionStackInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputResolutionStackInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputResolutionStackInput_"}
	if s.UserDefined != nil {
		if err := s.UserDefined.Validate(); err != nil {
			invalidParams.AddNested("UserDefined", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefined sets the Predefined field's value.
func (s *OutputResolutionStackInput_) SetPredefined(v string) *OutputResolutionStackInput_ {
	s.Predefined = &v
	return s
}

// SetUserDefined sets the UserDefined field's value.
func (s *OutputResolutionStackInput_) SetUserDefined(v *UserDefined) *OutputResolutionStackInput_ {
	s.UserDefined = v
	return s
}

// The input structure for specifying Platform. Platform refers to the unique
// name of the specific platform the instrument is attached to. For satellites
// it is the name of the satellite, eg. landsat-8 (Landsat-8), sentinel-2a.
type PlatformInput_ struct {
	_ struct{} `type:"structure"`

	// The ComparisonOperator to use with PlatformInput.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// The value of the platform.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlatformInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlatformInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PlatformInput_"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *PlatformInput_) SetComparisonOperator(v string) *PlatformInput_ {
	s.ComparisonOperator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PlatformInput_) SetValue(v string) *PlatformInput_ {
	s.Value = &v
	return s
}

// The structure representing Polygon Geometry based on the GeoJson spec (https://www.rfc-editor.org/rfc/rfc7946#section-3.1.6).
type PolygonGeometryInput_ struct {
	_ struct{} `type:"structure"`

	// Coordinates representing a Polygon based on the GeoJson spec (https://www.rfc-editor.org/rfc/rfc7946#section-3.1.6).
	//
	// Coordinates is a required field
	Coordinates [][][]*float64 `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolygonGeometryInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolygonGeometryInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolygonGeometryInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolygonGeometryInput_"}
	if s.Coordinates == nil {
		invalidParams.Add(request.NewErrParamRequired("Coordinates"))
	}
	if s.Coordinates != nil && len(s.Coordinates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Coordinates", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoordinates sets the Coordinates field's value.
func (s *PolygonGeometryInput_) SetCoordinates(v [][][]*float64) *PolygonGeometryInput_ {
	s.Coordinates = v
	return s
}

// Properties associated with the Item.
type Properties struct {
	_ struct{} `type:"structure"`

	// Estimate of cloud cover.
	EoCloudCover *float64 `type:"float"`

	// Land cloud cover for Landsat Data Collection.
	LandsatCloudCoverLand *float64 `type:"float"`

	// Platform property. Platform refers to the unique name of the specific platform
	// the instrument is attached to. For satellites it is the name of the satellite,
	// eg. landsat-8 (Landsat-8), sentinel-2a.
	Platform *string `type:"string"`

	// The angle from the sensor between nadir (straight down) and the scene center.
	// Measured in degrees (0-90).
	ViewOffNadir *float64 `type:"float"`

	// The sun azimuth angle. From the scene center point on the ground, this is
	// the angle between truth north and the sun. Measured clockwise in degrees
	// (0-360).
	ViewSunAzimuth *float64 `type:"float"`

	// The sun elevation angle. The angle from the tangent of the scene center point
	// to the sun. Measured from the horizon in degrees (-90-90). Negative values
	// indicate the sun is below the horizon, e.g. sun elevation of -10° means
	// the data was captured during nautical twilight (https://www.timeanddate.com/astronomy/different-types-twilight.html).
	ViewSunElevation *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Properties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Properties) GoString() string {
	return s.String()
}

// SetEoCloudCover sets the EoCloudCover field's value.
func (s *Properties) SetEoCloudCover(v float64) *Properties {
	s.EoCloudCover = &v
	return s
}

// SetLandsatCloudCoverLand sets the LandsatCloudCoverLand field's value.
func (s *Properties) SetLandsatCloudCoverLand(v float64) *Properties {
	s.LandsatCloudCoverLand = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Properties) SetPlatform(v string) *Properties {
	s.Platform = &v
	return s
}

// SetViewOffNadir sets the ViewOffNadir field's value.
func (s *Properties) SetViewOffNadir(v float64) *Properties {
	s.ViewOffNadir = &v
	return s
}

// SetViewSunAzimuth sets the ViewSunAzimuth field's value.
func (s *Properties) SetViewSunAzimuth(v float64) *Properties {
	s.ViewSunAzimuth = &v
	return s
}

// SetViewSunElevation sets the ViewSunElevation field's value.
func (s *Properties) SetViewSunElevation(v float64) *Properties {
	s.ViewSunElevation = &v
	return s
}

// Represents a single searchable property to search on.
type Property struct {
	_ struct{} `type:"structure"`

	// The structure representing EoCloudCover property filter containing a lower
	// bound and upper bound.
	EoCloudCover *EoCloudCoverInput_ `type:"structure"`

	// The structure representing Land Cloud Cover property filter for Landsat collection
	// containing a lower bound and upper bound.
	LandsatCloudCoverLand *LandsatCloudCoverLandInput_ `type:"structure"`

	// The structure representing Platform property filter consisting of value and
	// comparison operator.
	Platform *PlatformInput_ `type:"structure"`

	// The structure representing ViewOffNadir property filter containing a lower
	// bound and upper bound.
	ViewOffNadir *ViewOffNadirInput_ `type:"structure"`

	// The structure representing ViewSunAzimuth property filter containing a lower
	// bound and upper bound.
	ViewSunAzimuth *ViewSunAzimuthInput_ `type:"structure"`

	// The structure representing ViewSunElevation property filter containing a
	// lower bound and upper bound.
	ViewSunElevation *ViewSunElevationInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Property) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Property) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Property) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Property"}
	if s.EoCloudCover != nil {
		if err := s.EoCloudCover.Validate(); err != nil {
			invalidParams.AddNested("EoCloudCover", err.(request.ErrInvalidParams))
		}
	}
	if s.LandsatCloudCoverLand != nil {
		if err := s.LandsatCloudCoverLand.Validate(); err != nil {
			invalidParams.AddNested("LandsatCloudCoverLand", err.(request.ErrInvalidParams))
		}
	}
	if s.Platform != nil {
		if err := s.Platform.Validate(); err != nil {
			invalidParams.AddNested("Platform", err.(request.ErrInvalidParams))
		}
	}
	if s.ViewOffNadir != nil {
		if err := s.ViewOffNadir.Validate(); err != nil {
			invalidParams.AddNested("ViewOffNadir", err.(request.ErrInvalidParams))
		}
	}
	if s.ViewSunAzimuth != nil {
		if err := s.ViewSunAzimuth.Validate(); err != nil {
			invalidParams.AddNested("ViewSunAzimuth", err.(request.ErrInvalidParams))
		}
	}
	if s.ViewSunElevation != nil {
		if err := s.ViewSunElevation.Validate(); err != nil {
			invalidParams.AddNested("ViewSunElevation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEoCloudCover sets the EoCloudCover field's value.
func (s *Property) SetEoCloudCover(v *EoCloudCoverInput_) *Property {
	s.EoCloudCover = v
	return s
}

// SetLandsatCloudCoverLand sets the LandsatCloudCoverLand field's value.
func (s *Property) SetLandsatCloudCoverLand(v *LandsatCloudCoverLandInput_) *Property {
	s.LandsatCloudCoverLand = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Property) SetPlatform(v *PlatformInput_) *Property {
	s.Platform = v
	return s
}

// SetViewOffNadir sets the ViewOffNadir field's value.
func (s *Property) SetViewOffNadir(v *ViewOffNadirInput_) *Property {
	s.ViewOffNadir = v
	return s
}

// SetViewSunAzimuth sets the ViewSunAzimuth field's value.
func (s *Property) SetViewSunAzimuth(v *ViewSunAzimuthInput_) *Property {
	s.ViewSunAzimuth = v
	return s
}

// SetViewSunElevation sets the ViewSunElevation field's value.
func (s *Property) SetViewSunElevation(v *ViewSunElevationInput_) *Property {
	s.ViewSunElevation = v
	return s
}

// The structure representing a single PropertyFilter.
type PropertyFilter struct {
	_ struct{} `type:"structure"`

	// Represents a single property to match with when searching a raster data collection.
	//
	// Property is a required field
	Property *Property `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyFilter"}
	if s.Property == nil {
		invalidParams.Add(request.NewErrParamRequired("Property"))
	}
	if s.Property != nil {
		if err := s.Property.Validate(); err != nil {
			invalidParams.AddNested("Property", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProperty sets the Property field's value.
func (s *PropertyFilter) SetProperty(v *Property) *PropertyFilter {
	s.Property = v
	return s
}

// A list of PropertyFilter objects.
type PropertyFilters struct {
	_ struct{} `type:"structure"`

	// The Logical Operator used to combine the Property Filters.
	LogicalOperator *string `type:"string" enum:"LogicalOperator"`

	// A list of Property Filters.
	Properties []*PropertyFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyFilters"}
	if s.Properties != nil {
		for i, v := range s.Properties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Properties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalOperator sets the LogicalOperator field's value.
func (s *PropertyFilters) SetLogicalOperator(v string) *PropertyFilters {
	s.LogicalOperator = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *PropertyFilters) SetProperties(v []*PropertyFilter) *PropertyFilters {
	s.Properties = v
	return s
}

// Response object containing details for a specific RasterDataCollection.
type RasterDataCollectionMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the raster data collection.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A description of the raster data collection.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The description URL of the raster data collection.
	DescriptionPageUrl *string `type:"string"`

	// The name of the raster data collection.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The list of filters supported by the raster data collection.
	//
	// SupportedFilters is a required field
	SupportedFilters []*Filter `type:"list" required:"true"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`

	// The type of raster data collection.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataCollectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RasterDataCollectionMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RasterDataCollectionMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RasterDataCollectionMetadata) SetArn(v string) *RasterDataCollectionMetadata {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RasterDataCollectionMetadata) SetDescription(v string) *RasterDataCollectionMetadata {
	s.Description = &v
	return s
}

// SetDescriptionPageUrl sets the DescriptionPageUrl field's value.
func (s *RasterDataCollectionMetadata) SetDescriptionPageUrl(v string) *RasterDataCollectionMetadata {
	s.DescriptionPageUrl = &v
	return s
}

// SetName sets the Name field's value.
func (s *RasterDataCollectionMetadata) SetName(v string) *RasterDataCollectionMetadata {
	s.Name = &v
	return s
}

// SetSupportedFilters sets the SupportedFilters field's value.
func (s *RasterDataCollectionMetadata) SetSupportedFilters(v []*Filter) *RasterDataCollectionMetadata {
	s.SupportedFilters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RasterDataCollectionMetadata) SetTags(v map[string]*string) *RasterDataCollectionMetadata {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *RasterDataCollectionMetadata) SetType(v string) *RasterDataCollectionMetadata {
	s.Type = &v
	return s
}

// The input structure for Raster Data Collection Query containing the Area
// of Interest, TimeRange Filters, and Property Filters.
type RasterDataCollectionQueryInput_ struct {
	_ struct{} `type:"structure"`

	// The area of interest being queried for the raster data collection.
	AreaOfInterest *AreaOfInterest `type:"structure"`

	// The list of Property filters used in the Raster Data Collection Query.
	PropertyFilters *PropertyFilters `type:"structure"`

	// The Amazon Resource Name (ARN) of the raster data collection.
	//
	// RasterDataCollectionArn is a required field
	RasterDataCollectionArn *string `type:"string" required:"true"`

	// The TimeRange Filter used in the RasterDataCollection Query.
	//
	// TimeRangeFilter is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RasterDataCollectionQueryInput_'s
	// String and GoString methods.
	//
	// TimeRangeFilter is a required field
	TimeRangeFilter *TimeRangeFilterInput_ `type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RasterDataCollectionQueryInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RasterDataCollectionQueryInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RasterDataCollectionQueryInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RasterDataCollectionQueryInput_"}
	if s.RasterDataCollectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RasterDataCollectionArn"))
	}
	if s.TimeRangeFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeRangeFilter"))
	}
	if s.AreaOfInterest != nil {
		if err := s.AreaOfInterest.Validate(); err != nil {
			invalidParams.AddNested("AreaOfInterest", err.(request.ErrInvalidParams))
		}
	}
	if s.PropertyFilters != nil {
		if err := s.PropertyFilters.Validate(); err != nil {
			invalidParams.AddNested("PropertyFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.TimeRangeFilter != nil {
		if err := s.TimeRangeFilter.Validate(); err != nil {
			invalidParams.AddNested("TimeRangeFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAreaOfInterest sets the AreaOfInterest field's value.
func (s *RasterDataCollectionQueryInput_) SetAreaOfInterest(v *AreaOfInterest) *RasterDataCollectionQueryInput_ {
	s.AreaOfInterest = v
	return s
}

// SetPropertyFilters sets the PropertyFilters field's value.
func (s *RasterDataCollectionQueryInput_) SetPropertyFilters(v *PropertyFilters) *RasterDataCollectionQueryInput_ {
	s.PropertyFilters = v
	return s
}

// SetRasterDataCollectionArn sets the RasterDataCollectionArn field's value.
func (s *RasterDataCollectionQueryInput_) SetRasterDataCollectionArn(v string) *RasterDataCollectionQueryInput_ {
	s.RasterDataCollectionArn = &v
	return s
}

// SetTimeRangeFilter sets the TimeRangeFilter field's value.
func (s *RasterDataCollectionQueryInput_) SetTimeRangeFilter(v *TimeRangeFilterInput_) *RasterDataCollectionQueryInput_ {
	s.TimeRangeFilter = v
	return s
}

// The output structure contains the Raster Data Collection Query input along
// with some additional metadata.
type RasterDataCollectionQueryOutput_ struct {
	_ struct{} `type:"structure"`

	// The Area of Interest used in the search.
	AreaOfInterest *AreaOfInterest `type:"structure"`

	// Property filters used in the search.
	PropertyFilters *PropertyFilters `type:"structure"`

	// The ARN of the Raster Data Collection against which the search is done.
	//
	// RasterDataCollectionArn is a required field
	RasterDataCollectionArn *string `type:"string" required:"true"`

	// The name of the raster data collection.
	//
	// RasterDataCollectionName is a required field
	RasterDataCollectionName *string `type:"string" required:"true"`

	// The TimeRange filter used in the search.
	//
	// TimeRangeFilter is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RasterDataCollectionQueryOutput_'s
	// String and GoString methods.
	//
	// TimeRangeFilter is a required field
	TimeRangeFilter *TimeRangeFilterOutput_ `type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RasterDataCollectionQueryOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RasterDataCollectionQueryOutput_) GoString() string {
	return s.String()
}

// SetAreaOfInterest sets the AreaOfInterest field's value.
func (s *RasterDataCollectionQueryOutput_) SetAreaOfInterest(v *AreaOfInterest) *RasterDataCollectionQueryOutput_ {
	s.AreaOfInterest = v
	return s
}

// SetPropertyFilters sets the PropertyFilters field's value.
func (s *RasterDataCollectionQueryOutput_) SetPropertyFilters(v *PropertyFilters) *RasterDataCollectionQueryOutput_ {
	s.PropertyFilters = v
	return s
}

// SetRasterDataCollectionArn sets the RasterDataCollectionArn field's value.
func (s *RasterDataCollectionQueryOutput_) SetRasterDataCollectionArn(v string) *RasterDataCollectionQueryOutput_ {
	s.RasterDataCollectionArn = &v
	return s
}

// SetRasterDataCollectionName sets the RasterDataCollectionName field's value.
func (s *RasterDataCollectionQueryOutput_) SetRasterDataCollectionName(v string) *RasterDataCollectionQueryOutput_ {
	s.RasterDataCollectionName = &v
	return s
}

// SetTimeRangeFilter sets the TimeRangeFilter field's value.
func (s *RasterDataCollectionQueryOutput_) SetTimeRangeFilter(v *TimeRangeFilterOutput_) *RasterDataCollectionQueryOutput_ {
	s.TimeRangeFilter = v
	return s
}

// This is a RasterDataCollectionQueryInput containing AreaOfInterest, Time
// Range filter and Property filters.
type RasterDataCollectionQueryWithBandFilterInput_ struct {
	_ struct{} `type:"structure"`

	// The Area of interest to be used in the search query.
	AreaOfInterest *AreaOfInterest `type:"structure"`

	// The list of Bands to be displayed in the result for each item.
	BandFilter []*string `min:"1" type:"list"`

	// The Property Filters used in the search query.
	PropertyFilters *PropertyFilters `type:"structure"`

	// The TimeRange Filter used in the search query.
	//
	// TimeRangeFilter is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RasterDataCollectionQueryWithBandFilterInput_'s
	// String and GoString methods.
	//
	// TimeRangeFilter is a required field
	TimeRangeFilter *TimeRangeFilterInput_ `type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RasterDataCollectionQueryWithBandFilterInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RasterDataCollectionQueryWithBandFilterInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RasterDataCollectionQueryWithBandFilterInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RasterDataCollectionQueryWithBandFilterInput_"}
	if s.BandFilter != nil && len(s.BandFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BandFilter", 1))
	}
	if s.TimeRangeFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeRangeFilter"))
	}
	if s.AreaOfInterest != nil {
		if err := s.AreaOfInterest.Validate(); err != nil {
			invalidParams.AddNested("AreaOfInterest", err.(request.ErrInvalidParams))
		}
	}
	if s.PropertyFilters != nil {
		if err := s.PropertyFilters.Validate(); err != nil {
			invalidParams.AddNested("PropertyFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.TimeRangeFilter != nil {
		if err := s.TimeRangeFilter.Validate(); err != nil {
			invalidParams.AddNested("TimeRangeFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAreaOfInterest sets the AreaOfInterest field's value.
func (s *RasterDataCollectionQueryWithBandFilterInput_) SetAreaOfInterest(v *AreaOfInterest) *RasterDataCollectionQueryWithBandFilterInput_ {
	s.AreaOfInterest = v
	return s
}

// SetBandFilter sets the BandFilter field's value.
func (s *RasterDataCollectionQueryWithBandFilterInput_) SetBandFilter(v []*string) *RasterDataCollectionQueryWithBandFilterInput_ {
	s.BandFilter = v
	return s
}

// SetPropertyFilters sets the PropertyFilters field's value.
func (s *RasterDataCollectionQueryWithBandFilterInput_) SetPropertyFilters(v *PropertyFilters) *RasterDataCollectionQueryWithBandFilterInput_ {
	s.PropertyFilters = v
	return s
}

// SetTimeRangeFilter sets the TimeRangeFilter field's value.
func (s *RasterDataCollectionQueryWithBandFilterInput_) SetTimeRangeFilter(v *TimeRangeFilterInput_) *RasterDataCollectionQueryWithBandFilterInput_ {
	s.TimeRangeFilter = v
	return s
}

// The structure representing input for resampling operation.
type ResamplingConfigInput_ struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm used for resampling.
	AlgorithmName *string `type:"string" enum:"AlgorithmNameResampling"`

	// The structure representing output resolution (in target georeferenced units)
	// of the result of resampling operation.
	//
	// OutputResolution is a required field
	OutputResolution *OutputResolutionResamplingInput_ `type:"structure" required:"true"`

	// Bands used in the operation. If no target bands are specified, it uses all
	// bands available in the input.
	TargetBands []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResamplingConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResamplingConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResamplingConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResamplingConfigInput_"}
	if s.OutputResolution == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputResolution"))
	}
	if s.TargetBands != nil && len(s.TargetBands) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetBands", 1))
	}
	if s.OutputResolution != nil {
		if err := s.OutputResolution.Validate(); err != nil {
			invalidParams.AddNested("OutputResolution", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *ResamplingConfigInput_) SetAlgorithmName(v string) *ResamplingConfigInput_ {
	s.AlgorithmName = &v
	return s
}

// SetOutputResolution sets the OutputResolution field's value.
func (s *ResamplingConfigInput_) SetOutputResolution(v *OutputResolutionResamplingInput_) *ResamplingConfigInput_ {
	s.OutputResolution = v
	return s
}

// SetTargetBands sets the TargetBands field's value.
func (s *ResamplingConfigInput_) SetTargetBands(v []*string) *ResamplingConfigInput_ {
	s.TargetBands = v
	return s
}

// The request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource that was not found.
	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input structure for Reverse Geocoding operation type.
type ReverseGeocodingConfig struct {
	_ struct{} `type:"structure"`

	// The field name for the data that describes x-axis coordinate, eg. longitude
	// of a point.
	//
	// XAttributeName is a required field
	XAttributeName *string `type:"string" required:"true"`

	// The field name for the data that describes y-axis coordinate, eg. latitude
	// of a point.
	//
	// YAttributeName is a required field
	YAttributeName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReverseGeocodingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReverseGeocodingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReverseGeocodingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReverseGeocodingConfig"}
	if s.XAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("XAttributeName"))
	}
	if s.YAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("YAttributeName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetXAttributeName sets the XAttributeName field's value.
func (s *ReverseGeocodingConfig) SetXAttributeName(v string) *ReverseGeocodingConfig {
	s.XAttributeName = &v
	return s
}

// SetYAttributeName sets the YAttributeName field's value.
func (s *ReverseGeocodingConfig) SetYAttributeName(v string) *ReverseGeocodingConfig {
	s.YAttributeName = &v
	return s
}

type SearchRasterDataCollectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the raster data collection.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// If the previous response was truncated, you receive this token. Use it in
	// your next request to receive the next set of results.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchRasterDataCollectionInput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`

	// RasterDataCollectionQuery consisting of AreaOfInterest(AOI) (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html),
	// PropertyFilters (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html)
	// and TimeRangeFilterInput (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html)
	// used in SearchRasterDataCollection (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_SearchRasterDataCollection.html).
	//
	// RasterDataCollectionQuery is a required field
	RasterDataCollectionQuery *RasterDataCollectionQueryWithBandFilterInput_ `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRasterDataCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRasterDataCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchRasterDataCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchRasterDataCollectionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.RasterDataCollectionQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("RasterDataCollectionQuery"))
	}
	if s.RasterDataCollectionQuery != nil {
		if err := s.RasterDataCollectionQuery.Validate(); err != nil {
			invalidParams.AddNested("RasterDataCollectionQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *SearchRasterDataCollectionInput) SetArn(v string) *SearchRasterDataCollectionInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchRasterDataCollectionInput) SetNextToken(v string) *SearchRasterDataCollectionInput {
	s.NextToken = &v
	return s
}

// SetRasterDataCollectionQuery sets the RasterDataCollectionQuery field's value.
func (s *SearchRasterDataCollectionInput) SetRasterDataCollectionQuery(v *RasterDataCollectionQueryWithBandFilterInput_) *SearchRasterDataCollectionInput {
	s.RasterDataCollectionQuery = v
	return s
}

type SearchRasterDataCollectionOutput struct {
	_ struct{} `type:"structure"`

	// Approximate number of results in the response.
	//
	// ApproximateResultCount is a required field
	ApproximateResultCount *int64 `type:"integer" required:"true"`

	// List of items matching the Raster DataCollectionQuery.
	Items []*ItemSource `type:"list"`

	// If the previous response was truncated, you receive this token. Use it in
	// your next request to receive the next set of results.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchRasterDataCollectionOutput's
	// String and GoString methods.
	NextToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRasterDataCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchRasterDataCollectionOutput) GoString() string {
	return s.String()
}

// SetApproximateResultCount sets the ApproximateResultCount field's value.
func (s *SearchRasterDataCollectionOutput) SetApproximateResultCount(v int64) *SearchRasterDataCollectionOutput {
	s.ApproximateResultCount = &v
	return s
}

// SetItems sets the Items field's value.
func (s *SearchRasterDataCollectionOutput) SetItems(v []*ItemSource) *SearchRasterDataCollectionOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchRasterDataCollectionOutput) SetNextToken(v string) *SearchRasterDataCollectionOutput {
	s.NextToken = &v
	return s
}

// You have exceeded the service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource affected.
	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input structure for Stacking Operation.
type StackConfigInput_ struct {
	_ struct{} `type:"structure"`

	// The structure representing output resolution (in target georeferenced units)
	// of the result of stacking operation.
	OutputResolution *OutputResolutionStackInput_ `type:"structure"`

	// A list of bands to be stacked in the specified order. When the parameter
	// is not provided, all the available bands in the data collection are stacked
	// in the alphabetical order of their asset names.
	TargetBands []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StackConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StackConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StackConfigInput_"}
	if s.TargetBands != nil && len(s.TargetBands) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetBands", 1))
	}
	if s.OutputResolution != nil {
		if err := s.OutputResolution.Validate(); err != nil {
			invalidParams.AddNested("OutputResolution", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutputResolution sets the OutputResolution field's value.
func (s *StackConfigInput_) SetOutputResolution(v *OutputResolutionStackInput_) *StackConfigInput_ {
	s.OutputResolution = v
	return s
}

// SetTargetBands sets the TargetBands field's value.
func (s *StackConfigInput_) SetTargetBands(v []*string) *StackConfigInput_ {
	s.TargetBands = v
	return s
}

type StartEarthObservationJobInput struct {
	_ struct{} `type:"structure"`

	// A unique token that guarantees that the call to this API is idempotent.
	ClientToken *string `min:"36" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// job.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// Input configuration information for the Earth Observation job.
	//
	// InputConfig is a required field
	InputConfig *InputConfigInput_ `type:"structure" required:"true"`

	// An object containing information about the job configuration.
	//
	// JobConfig is a required field
	JobConfig *JobConfigInput_ `type:"structure" required:"true"`

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The name of the Earth Observation job.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEarthObservationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEarthObservationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEarthObservationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEarthObservationJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.InputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfig"))
	}
	if s.JobConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("JobConfig"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.InputConfig != nil {
		if err := s.InputConfig.Validate(); err != nil {
			invalidParams.AddNested("InputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.JobConfig != nil {
		if err := s.JobConfig.Validate(); err != nil {
			invalidParams.AddNested("JobConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartEarthObservationJobInput) SetClientToken(v string) *StartEarthObservationJobInput {
	s.ClientToken = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *StartEarthObservationJobInput) SetExecutionRoleArn(v string) *StartEarthObservationJobInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *StartEarthObservationJobInput) SetInputConfig(v *InputConfigInput_) *StartEarthObservationJobInput {
	s.InputConfig = v
	return s
}

// SetJobConfig sets the JobConfig field's value.
func (s *StartEarthObservationJobInput) SetJobConfig(v *JobConfigInput_) *StartEarthObservationJobInput {
	s.JobConfig = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *StartEarthObservationJobInput) SetKmsKeyId(v string) *StartEarthObservationJobInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartEarthObservationJobInput) SetName(v string) *StartEarthObservationJobInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartEarthObservationJobInput) SetTags(v map[string]*string) *StartEarthObservationJobInput {
	s.Tags = v
	return s
}

type StartEarthObservationJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Earth Observation job.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The duration of the session, in seconds.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// job.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// Input configuration information for the Earth Observation job.
	InputConfig *InputConfigOutput_ `type:"structure"`

	// An object containing information about the job configuration.
	//
	// JobConfig is a required field
	JobConfig *JobConfigInput_ `type:"structure" required:"true"`

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The name of the Earth Observation job.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The status of the Earth Observation job.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"EarthObservationJobStatus"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEarthObservationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEarthObservationJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartEarthObservationJobOutput) SetArn(v string) *StartEarthObservationJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *StartEarthObservationJobOutput) SetCreationTime(v time.Time) *StartEarthObservationJobOutput {
	s.CreationTime = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *StartEarthObservationJobOutput) SetDurationInSeconds(v int64) *StartEarthObservationJobOutput {
	s.DurationInSeconds = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *StartEarthObservationJobOutput) SetExecutionRoleArn(v string) *StartEarthObservationJobOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *StartEarthObservationJobOutput) SetInputConfig(v *InputConfigOutput_) *StartEarthObservationJobOutput {
	s.InputConfig = v
	return s
}

// SetJobConfig sets the JobConfig field's value.
func (s *StartEarthObservationJobOutput) SetJobConfig(v *JobConfigInput_) *StartEarthObservationJobOutput {
	s.JobConfig = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *StartEarthObservationJobOutput) SetKmsKeyId(v string) *StartEarthObservationJobOutput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartEarthObservationJobOutput) SetName(v string) *StartEarthObservationJobOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartEarthObservationJobOutput) SetStatus(v string) *StartEarthObservationJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartEarthObservationJobOutput) SetTags(v map[string]*string) *StartEarthObservationJobOutput {
	s.Tags = v
	return s
}

type StartVectorEnrichmentJobInput struct {
	_ struct{} `type:"structure"`

	// A unique token that guarantees that the call to this API is idempotent.
	ClientToken *string `min:"36" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// job.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// Input configuration information for the Vector Enrichment job.
	//
	// InputConfig is a required field
	InputConfig *VectorEnrichmentJobInputConfig `type:"structure" required:"true"`

	// An object containing information about the job configuration.
	//
	// JobConfig is a required field
	JobConfig *VectorEnrichmentJobConfig `type:"structure" required:"true"`

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The name of the Vector Enrichment job.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartVectorEnrichmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartVectorEnrichmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartVectorEnrichmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartVectorEnrichmentJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 20))
	}
	if s.InputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfig"))
	}
	if s.JobConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("JobConfig"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.InputConfig != nil {
		if err := s.InputConfig.Validate(); err != nil {
			invalidParams.AddNested("InputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.JobConfig != nil {
		if err := s.JobConfig.Validate(); err != nil {
			invalidParams.AddNested("JobConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartVectorEnrichmentJobInput) SetClientToken(v string) *StartVectorEnrichmentJobInput {
	s.ClientToken = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *StartVectorEnrichmentJobInput) SetExecutionRoleArn(v string) *StartVectorEnrichmentJobInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *StartVectorEnrichmentJobInput) SetInputConfig(v *VectorEnrichmentJobInputConfig) *StartVectorEnrichmentJobInput {
	s.InputConfig = v
	return s
}

// SetJobConfig sets the JobConfig field's value.
func (s *StartVectorEnrichmentJobInput) SetJobConfig(v *VectorEnrichmentJobConfig) *StartVectorEnrichmentJobInput {
	s.JobConfig = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *StartVectorEnrichmentJobInput) SetKmsKeyId(v string) *StartVectorEnrichmentJobInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartVectorEnrichmentJobInput) SetName(v string) *StartVectorEnrichmentJobInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartVectorEnrichmentJobInput) SetTags(v map[string]*string) *StartVectorEnrichmentJobInput {
	s.Tags = v
	return s
}

type StartVectorEnrichmentJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Vector Enrichment job.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The duration of the Vector Enrichment job, in seconds.
	//
	// DurationInSeconds is a required field
	DurationInSeconds *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the
	// job.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"20" type:"string" required:"true"`

	// Input configuration information for starting the Vector Enrichment job.
	//
	// InputConfig is a required field
	InputConfig *VectorEnrichmentJobInputConfig `type:"structure" required:"true"`

	// An object containing information about the job configuration.
	//
	// JobConfig is a required field
	JobConfig *VectorEnrichmentJobConfig `type:"structure" required:"true"`

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The name of the Vector Enrichment job.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The status of the Vector Enrichment job being started.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"VectorEnrichmentJobStatus"`

	// Each tag consists of a key and a value.
	Tags map[string]*string `type:"map"`

	// The type of the Vector Enrichment job.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"VectorEnrichmentJobType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartVectorEnrichmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartVectorEnrichmentJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartVectorEnrichmentJobOutput) SetArn(v string) *StartVectorEnrichmentJobOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *StartVectorEnrichmentJobOutput) SetCreationTime(v time.Time) *StartVectorEnrichmentJobOutput {
	s.CreationTime = &v
	return s
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *StartVectorEnrichmentJobOutput) SetDurationInSeconds(v int64) *StartVectorEnrichmentJobOutput {
	s.DurationInSeconds = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *StartVectorEnrichmentJobOutput) SetExecutionRoleArn(v string) *StartVectorEnrichmentJobOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *StartVectorEnrichmentJobOutput) SetInputConfig(v *VectorEnrichmentJobInputConfig) *StartVectorEnrichmentJobOutput {
	s.InputConfig = v
	return s
}

// SetJobConfig sets the JobConfig field's value.
func (s *StartVectorEnrichmentJobOutput) SetJobConfig(v *VectorEnrichmentJobConfig) *StartVectorEnrichmentJobOutput {
	s.JobConfig = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *StartVectorEnrichmentJobOutput) SetKmsKeyId(v string) *StartVectorEnrichmentJobOutput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartVectorEnrichmentJobOutput) SetName(v string) *StartVectorEnrichmentJobOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartVectorEnrichmentJobOutput) SetStatus(v string) *StartVectorEnrichmentJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartVectorEnrichmentJobOutput) SetTags(v map[string]*string) *StartVectorEnrichmentJobOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *StartVectorEnrichmentJobOutput) SetType(v string) *StartVectorEnrichmentJobOutput {
	s.Type = &v
	return s
}

type StopEarthObservationJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Earth Observation job being stopped.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEarthObservationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEarthObservationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEarthObservationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEarthObservationJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StopEarthObservationJobInput) SetArn(v string) *StopEarthObservationJobInput {
	s.Arn = &v
	return s
}

type StopEarthObservationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEarthObservationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEarthObservationJobOutput) GoString() string {
	return s.String()
}

type StopVectorEnrichmentJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Vector Enrichment job.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopVectorEnrichmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopVectorEnrichmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopVectorEnrichmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopVectorEnrichmentJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StopVectorEnrichmentJobInput) SetArn(v string) *StopVectorEnrichmentJobInput {
	s.Arn = &v
	return s
}

type StopVectorEnrichmentJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopVectorEnrichmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopVectorEnrichmentJobOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// Each tag consists of a key and a value.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The structure representing the configuration for Temporal Statistics operation.
type TemporalStatisticsConfigInput_ struct {
	_ struct{} `type:"structure"`

	// The input for the temporal statistics grouping by time frequency option.
	GroupBy *string `type:"string" enum:"GroupBy"`

	// The list of the statistics method options.
	//
	// Statistics is a required field
	Statistics []*string `min:"1" type:"list" required:"true" enum:"TemporalStatistics"`

	// The list of target band names for the temporal statistic to calculate.
	TargetBands []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemporalStatisticsConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemporalStatisticsConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemporalStatisticsConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemporalStatisticsConfigInput_"}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Statistics != nil && len(s.Statistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistics", 1))
	}
	if s.TargetBands != nil && len(s.TargetBands) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetBands", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupBy sets the GroupBy field's value.
func (s *TemporalStatisticsConfigInput_) SetGroupBy(v string) *TemporalStatisticsConfigInput_ {
	s.GroupBy = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *TemporalStatisticsConfigInput_) SetStatistics(v []*string) *TemporalStatisticsConfigInput_ {
	s.Statistics = v
	return s
}

// SetTargetBands sets the TargetBands field's value.
func (s *TemporalStatisticsConfigInput_) SetTargetBands(v []*string) *TemporalStatisticsConfigInput_ {
	s.TargetBands = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input for the time-range filter.
type TimeRangeFilterInput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The end time for the time-range filter.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The start time for the time-range filter.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRangeFilterInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRangeFilterInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeRangeFilterInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeRangeFilterInput_"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRangeFilterInput_) SetEndTime(v time.Time) *TimeRangeFilterInput_ {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRangeFilterInput_) SetStartTime(v time.Time) *TimeRangeFilterInput_ {
	s.StartTime = &v
	return s
}

// The output structure of the time range filter.
type TimeRangeFilterOutput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The ending time for the time range filter.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The starting time for the time range filter.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRangeFilterOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRangeFilterOutput_) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRangeFilterOutput_) SetEndTime(v time.Time) *TimeRangeFilterOutput_ {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRangeFilterOutput_) SetStartTime(v time.Time) *TimeRangeFilterOutput_ {
	s.StartTime = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// Keys of the tags you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The output resolution (in target georeferenced units) of the result of the
// operation
type UserDefined struct {
	_ struct{} `type:"structure"`

	// The units for output resolution of the result.
	//
	// Unit is a required field
	Unit *string `type:"string" required:"true" enum:"Unit"`

	// The value for output resolution of the result.
	//
	// Value is a required field
	Value *float64 `type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserDefined) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserDefined) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserDefined) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserDefined"}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnit sets the Unit field's value.
func (s *UserDefined) SetUnit(v string) *UserDefined {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UserDefined) SetValue(v float64) *UserDefined {
	s.Value = &v
	return s
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// It contains configs such as ReverseGeocodingConfig and MapMatchingConfig.
type VectorEnrichmentJobConfig struct {
	_ struct{} `type:"structure"`

	// The input structure for Map Matching operation type.
	MapMatchingConfig *MapMatchingConfig `type:"structure"`

	// The input structure for Reverse Geocoding operation type.
	ReverseGeocodingConfig *ReverseGeocodingConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VectorEnrichmentJobConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VectorEnrichmentJobConfig"}
	if s.MapMatchingConfig != nil {
		if err := s.MapMatchingConfig.Validate(); err != nil {
			invalidParams.AddNested("MapMatchingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ReverseGeocodingConfig != nil {
		if err := s.ReverseGeocodingConfig.Validate(); err != nil {
			invalidParams.AddNested("ReverseGeocodingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapMatchingConfig sets the MapMatchingConfig field's value.
func (s *VectorEnrichmentJobConfig) SetMapMatchingConfig(v *MapMatchingConfig) *VectorEnrichmentJobConfig {
	s.MapMatchingConfig = v
	return s
}

// SetReverseGeocodingConfig sets the ReverseGeocodingConfig field's value.
func (s *VectorEnrichmentJobConfig) SetReverseGeocodingConfig(v *ReverseGeocodingConfig) *VectorEnrichmentJobConfig {
	s.ReverseGeocodingConfig = v
	return s
}

// The input structure for the data source that represents the storage type
// of the input data objects.
type VectorEnrichmentJobDataSourceConfigInput_ struct {
	_ struct{} `type:"structure"`

	// The input structure for the Amazon S3 data that represents the Amazon S3
	// location of the input data objects.
	S3Data *VectorEnrichmentJobS3Data `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobDataSourceConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobDataSourceConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VectorEnrichmentJobDataSourceConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VectorEnrichmentJobDataSourceConfigInput_"}
	if s.S3Data != nil {
		if err := s.S3Data.Validate(); err != nil {
			invalidParams.AddNested("S3Data", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Data sets the S3Data field's value.
func (s *VectorEnrichmentJobDataSourceConfigInput_) SetS3Data(v *VectorEnrichmentJobS3Data) *VectorEnrichmentJobDataSourceConfigInput_ {
	s.S3Data = v
	return s
}

// VectorEnrichmentJob error details in response from GetVectorEnrichmentJob.
type VectorEnrichmentJobErrorDetails struct {
	_ struct{} `type:"structure"`

	// A message that you define and then is processed and rendered by the Vector
	// Enrichment job when the error occurs.
	ErrorMessage *string `type:"string"`

	// The type of error generated during the Vector Enrichment job.
	ErrorType *string `type:"string" enum:"VectorEnrichmentJobErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobErrorDetails) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *VectorEnrichmentJobErrorDetails) SetErrorMessage(v string) *VectorEnrichmentJobErrorDetails {
	s.ErrorMessage = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *VectorEnrichmentJobErrorDetails) SetErrorType(v string) *VectorEnrichmentJobErrorDetails {
	s.ErrorType = &v
	return s
}

// VectorEnrichmentJob export error details in response from GetVectorEnrichmentJob.
type VectorEnrichmentJobExportErrorDetails struct {
	_ struct{} `type:"structure"`

	// The message providing details about the errors generated during the Vector
	// Enrichment job.
	Message *string `type:"string"`

	// The output error details for an Export operation on a Vector Enrichment job.
	Type *string `type:"string" enum:"VectorEnrichmentJobExportErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobExportErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobExportErrorDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *VectorEnrichmentJobExportErrorDetails) SetMessage(v string) *VectorEnrichmentJobExportErrorDetails {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *VectorEnrichmentJobExportErrorDetails) SetType(v string) *VectorEnrichmentJobExportErrorDetails {
	s.Type = &v
	return s
}

// The input structure for the InputConfig in a VectorEnrichmentJob.
type VectorEnrichmentJobInputConfig struct {
	_ struct{} `type:"structure"`

	// The input structure for the data source that represents the storage type
	// of the input data objects.
	//
	// DataSourceConfig is a required field
	DataSourceConfig *VectorEnrichmentJobDataSourceConfigInput_ `type:"structure" required:"true"`

	// The input structure that defines the data source file type.
	//
	// DocumentType is a required field
	DocumentType *string `type:"string" required:"true" enum:"VectorEnrichmentJobDocumentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobInputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobInputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VectorEnrichmentJobInputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VectorEnrichmentJobInputConfig"}
	if s.DataSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceConfig"))
	}
	if s.DocumentType == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentType"))
	}
	if s.DataSourceConfig != nil {
		if err := s.DataSourceConfig.Validate(); err != nil {
			invalidParams.AddNested("DataSourceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceConfig sets the DataSourceConfig field's value.
func (s *VectorEnrichmentJobInputConfig) SetDataSourceConfig(v *VectorEnrichmentJobDataSourceConfigInput_) *VectorEnrichmentJobInputConfig {
	s.DataSourceConfig = v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *VectorEnrichmentJobInputConfig) SetDocumentType(v string) *VectorEnrichmentJobInputConfig {
	s.DocumentType = &v
	return s
}

// The Amazon S3 data for the Vector Enrichment job.
type VectorEnrichmentJobS3Data struct {
	_ struct{} `type:"structure"`

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The URL to the Amazon S3 data for the Vector Enrichment job.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobS3Data) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorEnrichmentJobS3Data) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VectorEnrichmentJobS3Data) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VectorEnrichmentJobS3Data"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *VectorEnrichmentJobS3Data) SetKmsKeyId(v string) *VectorEnrichmentJobS3Data {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *VectorEnrichmentJobS3Data) SetS3Uri(v string) *VectorEnrichmentJobS3Data {
	s.S3Uri = &v
	return s
}

// The input structure for specifying ViewOffNadir property filter. ViewOffNadir
// refers to the angle from the sensor between nadir (straight down) and the
// scene center. Measured in degrees (0-90).
type ViewOffNadirInput_ struct {
	_ struct{} `type:"structure"`

	// The minimum value for ViewOffNadir property filter. This filters items having
	// ViewOffNadir greater than or equal to this value.
	//
	// LowerBound is a required field
	LowerBound *float64 `type:"float" required:"true"`

	// The maximum value for ViewOffNadir property filter. This filters items having
	// ViewOffNadir lesser than or equal to this value.
	//
	// UpperBound is a required field
	UpperBound *float64 `type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewOffNadirInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewOffNadirInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ViewOffNadirInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ViewOffNadirInput_"}
	if s.LowerBound == nil {
		invalidParams.Add(request.NewErrParamRequired("LowerBound"))
	}
	if s.UpperBound == nil {
		invalidParams.Add(request.NewErrParamRequired("UpperBound"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLowerBound sets the LowerBound field's value.
func (s *ViewOffNadirInput_) SetLowerBound(v float64) *ViewOffNadirInput_ {
	s.LowerBound = &v
	return s
}

// SetUpperBound sets the UpperBound field's value.
func (s *ViewOffNadirInput_) SetUpperBound(v float64) *ViewOffNadirInput_ {
	s.UpperBound = &v
	return s
}

// The input structure for specifying ViewSunAzimuth property filter. ViewSunAzimuth
// refers to the Sun azimuth angle. From the scene center point on the ground,
// this is the angle between truth north and the sun. Measured clockwise in
// degrees (0-360).
type ViewSunAzimuthInput_ struct {
	_ struct{} `type:"structure"`

	// The minimum value for ViewSunAzimuth property filter. This filters items
	// having ViewSunAzimuth greater than or equal to this value.
	//
	// LowerBound is a required field
	LowerBound *float64 `type:"float" required:"true"`

	// The maximum value for ViewSunAzimuth property filter. This filters items
	// having ViewSunAzimuth lesser than or equal to this value.
	//
	// UpperBound is a required field
	UpperBound *float64 `type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewSunAzimuthInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewSunAzimuthInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ViewSunAzimuthInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ViewSunAzimuthInput_"}
	if s.LowerBound == nil {
		invalidParams.Add(request.NewErrParamRequired("LowerBound"))
	}
	if s.UpperBound == nil {
		invalidParams.Add(request.NewErrParamRequired("UpperBound"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLowerBound sets the LowerBound field's value.
func (s *ViewSunAzimuthInput_) SetLowerBound(v float64) *ViewSunAzimuthInput_ {
	s.LowerBound = &v
	return s
}

// SetUpperBound sets the UpperBound field's value.
func (s *ViewSunAzimuthInput_) SetUpperBound(v float64) *ViewSunAzimuthInput_ {
	s.UpperBound = &v
	return s
}

// The input structure for specifying ViewSunElevation angle property filter.
type ViewSunElevationInput_ struct {
	_ struct{} `type:"structure"`

	// The lower bound to view the sun elevation.
	//
	// LowerBound is a required field
	LowerBound *float64 `type:"float" required:"true"`

	// The upper bound to view the sun elevation.
	//
	// UpperBound is a required field
	UpperBound *float64 `type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewSunElevationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewSunElevationInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ViewSunElevationInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ViewSunElevationInput_"}
	if s.LowerBound == nil {
		invalidParams.Add(request.NewErrParamRequired("LowerBound"))
	}
	if s.UpperBound == nil {
		invalidParams.Add(request.NewErrParamRequired("UpperBound"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLowerBound sets the LowerBound field's value.
func (s *ViewSunElevationInput_) SetLowerBound(v float64) *ViewSunElevationInput_ {
	s.LowerBound = &v
	return s
}

// SetUpperBound sets the UpperBound field's value.
func (s *ViewSunElevationInput_) SetUpperBound(v float64) *ViewSunElevationInput_ {
	s.UpperBound = &v
	return s
}

// The structure representing input configuration of ZonalStatistics operation.
type ZonalStatisticsConfigInput_ struct {
	_ struct{} `type:"structure"`

	// List of zonal statistics to compute.
	//
	// Statistics is a required field
	Statistics []*string `min:"1" type:"list" required:"true" enum:"ZonalStatistics"`

	// Bands used in the operation. If no target bands are specified, it uses all
	// bands available input.
	TargetBands []*string `min:"1" type:"list"`

	// The Amazon S3 path pointing to the GeoJSON containing the polygonal zones.
	//
	// ZoneS3Path is a required field
	ZoneS3Path *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) or an ID of a Amazon Web Services Key Management
	// Service (Amazon Web Services KMS) key that Amazon SageMaker uses to decrypt
	// your output artifacts with Amazon S3 server-side encryption. The SageMaker
	// execution role must have kms:GenerateDataKey permission.
	//
	// The KmsKeyId can be any of the following formats:
	//
	//    * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:<region>:<account>:key/<key-id-12ab-34cd-56ef-1234567890ab>"
	//
	// For more information about key identifiers, see Key identifiers (KeyID) (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id)
	// in the Amazon Web Services Key Management Service (Amazon Web Services KMS)
	// documentation.
	ZoneS3PathKmsKeyId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalStatisticsConfigInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZonalStatisticsConfigInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZonalStatisticsConfigInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZonalStatisticsConfigInput_"}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Statistics != nil && len(s.Statistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistics", 1))
	}
	if s.TargetBands != nil && len(s.TargetBands) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetBands", 1))
	}
	if s.ZoneS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneS3Path"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatistics sets the Statistics field's value.
func (s *ZonalStatisticsConfigInput_) SetStatistics(v []*string) *ZonalStatisticsConfigInput_ {
	s.Statistics = v
	return s
}

// SetTargetBands sets the TargetBands field's value.
func (s *ZonalStatisticsConfigInput_) SetTargetBands(v []*string) *ZonalStatisticsConfigInput_ {
	s.TargetBands = v
	return s
}

// SetZoneS3Path sets the ZoneS3Path field's value.
func (s *ZonalStatisticsConfigInput_) SetZoneS3Path(v string) *ZonalStatisticsConfigInput_ {
	s.ZoneS3Path = &v
	return s
}

// SetZoneS3PathKmsKeyId sets the ZoneS3PathKmsKeyId field's value.
func (s *ZonalStatisticsConfigInput_) SetZoneS3PathKmsKeyId(v string) *ZonalStatisticsConfigInput_ {
	s.ZoneS3PathKmsKeyId = &v
	return s
}

const (
	// AlgorithmNameCloudRemovalInterpolation is a AlgorithmNameCloudRemoval enum value
	AlgorithmNameCloudRemovalInterpolation = "INTERPOLATION"
)

// AlgorithmNameCloudRemoval_Values returns all elements of the AlgorithmNameCloudRemoval enum
func AlgorithmNameCloudRemoval_Values() []string {
	return []string{
		AlgorithmNameCloudRemovalInterpolation,
	}
}

const (
	// AlgorithmNameGeoMosaicNear is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicNear = "NEAR"

	// AlgorithmNameGeoMosaicBilinear is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicBilinear = "BILINEAR"

	// AlgorithmNameGeoMosaicCubic is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicCubic = "CUBIC"

	// AlgorithmNameGeoMosaicCubicspline is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicCubicspline = "CUBICSPLINE"

	// AlgorithmNameGeoMosaicLanczos is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicLanczos = "LANCZOS"

	// AlgorithmNameGeoMosaicAverage is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicAverage = "AVERAGE"

	// AlgorithmNameGeoMosaicRms is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicRms = "RMS"

	// AlgorithmNameGeoMosaicMode is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicMode = "MODE"

	// AlgorithmNameGeoMosaicMax is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicMax = "MAX"

	// AlgorithmNameGeoMosaicMin is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicMin = "MIN"

	// AlgorithmNameGeoMosaicMed is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicMed = "MED"

	// AlgorithmNameGeoMosaicQ1 is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicQ1 = "Q1"

	// AlgorithmNameGeoMosaicQ3 is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicQ3 = "Q3"

	// AlgorithmNameGeoMosaicSum is a AlgorithmNameGeoMosaic enum value
	AlgorithmNameGeoMosaicSum = "SUM"
)

// AlgorithmNameGeoMosaic_Values returns all elements of the AlgorithmNameGeoMosaic enum
func AlgorithmNameGeoMosaic_Values() []string {
	return []string{
		AlgorithmNameGeoMosaicNear,
		AlgorithmNameGeoMosaicBilinear,
		AlgorithmNameGeoMosaicCubic,
		AlgorithmNameGeoMosaicCubicspline,
		AlgorithmNameGeoMosaicLanczos,
		AlgorithmNameGeoMosaicAverage,
		AlgorithmNameGeoMosaicRms,
		AlgorithmNameGeoMosaicMode,
		AlgorithmNameGeoMosaicMax,
		AlgorithmNameGeoMosaicMin,
		AlgorithmNameGeoMosaicMed,
		AlgorithmNameGeoMosaicQ1,
		AlgorithmNameGeoMosaicQ3,
		AlgorithmNameGeoMosaicSum,
	}
}

const (
	// AlgorithmNameResamplingNear is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingNear = "NEAR"

	// AlgorithmNameResamplingBilinear is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingBilinear = "BILINEAR"

	// AlgorithmNameResamplingCubic is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingCubic = "CUBIC"

	// AlgorithmNameResamplingCubicspline is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingCubicspline = "CUBICSPLINE"

	// AlgorithmNameResamplingLanczos is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingLanczos = "LANCZOS"

	// AlgorithmNameResamplingAverage is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingAverage = "AVERAGE"

	// AlgorithmNameResamplingRms is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingRms = "RMS"

	// AlgorithmNameResamplingMode is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingMode = "MODE"

	// AlgorithmNameResamplingMax is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingMax = "MAX"

	// AlgorithmNameResamplingMin is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingMin = "MIN"

	// AlgorithmNameResamplingMed is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingMed = "MED"

	// AlgorithmNameResamplingQ1 is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingQ1 = "Q1"

	// AlgorithmNameResamplingQ3 is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingQ3 = "Q3"

	// AlgorithmNameResamplingSum is a AlgorithmNameResampling enum value
	AlgorithmNameResamplingSum = "SUM"
)

// AlgorithmNameResampling_Values returns all elements of the AlgorithmNameResampling enum
func AlgorithmNameResampling_Values() []string {
	return []string{
		AlgorithmNameResamplingNear,
		AlgorithmNameResamplingBilinear,
		AlgorithmNameResamplingCubic,
		AlgorithmNameResamplingCubicspline,
		AlgorithmNameResamplingLanczos,
		AlgorithmNameResamplingAverage,
		AlgorithmNameResamplingRms,
		AlgorithmNameResamplingMode,
		AlgorithmNameResamplingMax,
		AlgorithmNameResamplingMin,
		AlgorithmNameResamplingMed,
		AlgorithmNameResamplingQ1,
		AlgorithmNameResamplingQ3,
		AlgorithmNameResamplingSum,
	}
}

const (
	// ComparisonOperatorEquals is a ComparisonOperator enum value
	ComparisonOperatorEquals = "EQUALS"

	// ComparisonOperatorNotEquals is a ComparisonOperator enum value
	ComparisonOperatorNotEquals = "NOT_EQUALS"

	// ComparisonOperatorStartsWith is a ComparisonOperator enum value
	ComparisonOperatorStartsWith = "STARTS_WITH"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorEquals,
		ComparisonOperatorNotEquals,
		ComparisonOperatorStartsWith,
	}
}

const (
	// DataCollectionTypePublic is a DataCollectionType enum value
	DataCollectionTypePublic = "PUBLIC"

	// DataCollectionTypePremium is a DataCollectionType enum value
	DataCollectionTypePremium = "PREMIUM"

	// DataCollectionTypeUser is a DataCollectionType enum value
	DataCollectionTypeUser = "USER"
)

// DataCollectionType_Values returns all elements of the DataCollectionType enum
func DataCollectionType_Values() []string {
	return []string{
		DataCollectionTypePublic,
		DataCollectionTypePremium,
		DataCollectionTypeUser,
	}
}

const (
	// EarthObservationJobErrorTypeClientError is a EarthObservationJobErrorType enum value
	EarthObservationJobErrorTypeClientError = "CLIENT_ERROR"

	// EarthObservationJobErrorTypeServerError is a EarthObservationJobErrorType enum value
	EarthObservationJobErrorTypeServerError = "SERVER_ERROR"
)

// EarthObservationJobErrorType_Values returns all elements of the EarthObservationJobErrorType enum
func EarthObservationJobErrorType_Values() []string {
	return []string{
		EarthObservationJobErrorTypeClientError,
		EarthObservationJobErrorTypeServerError,
	}
}

const (
	// EarthObservationJobExportStatusInProgress is a EarthObservationJobExportStatus enum value
	EarthObservationJobExportStatusInProgress = "IN_PROGRESS"

	// EarthObservationJobExportStatusSucceeded is a EarthObservationJobExportStatus enum value
	EarthObservationJobExportStatusSucceeded = "SUCCEEDED"

	// EarthObservationJobExportStatusFailed is a EarthObservationJobExportStatus enum value
	EarthObservationJobExportStatusFailed = "FAILED"
)

// EarthObservationJobExportStatus_Values returns all elements of the EarthObservationJobExportStatus enum
func EarthObservationJobExportStatus_Values() []string {
	return []string{
		EarthObservationJobExportStatusInProgress,
		EarthObservationJobExportStatusSucceeded,
		EarthObservationJobExportStatusFailed,
	}
}

const (
	// EarthObservationJobStatusInitializing is a EarthObservationJobStatus enum value
	EarthObservationJobStatusInitializing = "INITIALIZING"

	// EarthObservationJobStatusInProgress is a EarthObservationJobStatus enum value
	EarthObservationJobStatusInProgress = "IN_PROGRESS"

	// EarthObservationJobStatusStopping is a EarthObservationJobStatus enum value
	EarthObservationJobStatusStopping = "STOPPING"

	// EarthObservationJobStatusCompleted is a EarthObservationJobStatus enum value
	EarthObservationJobStatusCompleted = "COMPLETED"

	// EarthObservationJobStatusStopped is a EarthObservationJobStatus enum value
	EarthObservationJobStatusStopped = "STOPPED"

	// EarthObservationJobStatusFailed is a EarthObservationJobStatus enum value
	EarthObservationJobStatusFailed = "FAILED"

	// EarthObservationJobStatusDeleting is a EarthObservationJobStatus enum value
	EarthObservationJobStatusDeleting = "DELETING"

	// EarthObservationJobStatusDeleted is a EarthObservationJobStatus enum value
	EarthObservationJobStatusDeleted = "DELETED"
)

// EarthObservationJobStatus_Values returns all elements of the EarthObservationJobStatus enum
func EarthObservationJobStatus_Values() []string {
	return []string{
		EarthObservationJobStatusInitializing,
		EarthObservationJobStatusInProgress,
		EarthObservationJobStatusStopping,
		EarthObservationJobStatusCompleted,
		EarthObservationJobStatusStopped,
		EarthObservationJobStatusFailed,
		EarthObservationJobStatusDeleting,
		EarthObservationJobStatusDeleted,
	}
}

const (
	// ExportErrorTypeClientError is a ExportErrorType enum value
	ExportErrorTypeClientError = "CLIENT_ERROR"

	// ExportErrorTypeServerError is a ExportErrorType enum value
	ExportErrorTypeServerError = "SERVER_ERROR"
)

// ExportErrorType_Values returns all elements of the ExportErrorType enum
func ExportErrorType_Values() []string {
	return []string{
		ExportErrorTypeClientError,
		ExportErrorTypeServerError,
	}
}

const (
	// GroupByAll is a GroupBy enum value
	GroupByAll = "ALL"

	// GroupByYearly is a GroupBy enum value
	GroupByYearly = "YEARLY"
)

// GroupBy_Values returns all elements of the GroupBy enum
func GroupBy_Values() []string {
	return []string{
		GroupByAll,
		GroupByYearly,
	}
}

const (
	// LogicalOperatorAnd is a LogicalOperator enum value
	LogicalOperatorAnd = "AND"
)

// LogicalOperator_Values returns all elements of the LogicalOperator enum
func LogicalOperator_Values() []string {
	return []string{
		LogicalOperatorAnd,
	}
}

const (
	// OutputTypeInt32 is a OutputType enum value
	OutputTypeInt32 = "INT32"

	// OutputTypeFloat32 is a OutputType enum value
	OutputTypeFloat32 = "FLOAT32"

	// OutputTypeInt16 is a OutputType enum value
	OutputTypeInt16 = "INT16"

	// OutputTypeFloat64 is a OutputType enum value
	OutputTypeFloat64 = "FLOAT64"

	// OutputTypeUint16 is a OutputType enum value
	OutputTypeUint16 = "UINT16"
)

// OutputType_Values returns all elements of the OutputType enum
func OutputType_Values() []string {
	return []string{
		OutputTypeInt32,
		OutputTypeFloat32,
		OutputTypeInt16,
		OutputTypeFloat64,
		OutputTypeUint16,
	}
}

const (
	// PredefinedResolutionHighest is a PredefinedResolution enum value
	PredefinedResolutionHighest = "HIGHEST"

	// PredefinedResolutionLowest is a PredefinedResolution enum value
	PredefinedResolutionLowest = "LOWEST"

	// PredefinedResolutionAverage is a PredefinedResolution enum value
	PredefinedResolutionAverage = "AVERAGE"
)

// PredefinedResolution_Values returns all elements of the PredefinedResolution enum
func PredefinedResolution_Values() []string {
	return []string{
		PredefinedResolutionHighest,
		PredefinedResolutionLowest,
		PredefinedResolutionAverage,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}

const (
	// TargetOptionsInput is a TargetOptions enum value
	TargetOptionsInput = "INPUT"

	// TargetOptionsOutput is a TargetOptions enum value
	TargetOptionsOutput = "OUTPUT"
)

// TargetOptions_Values returns all elements of the TargetOptions enum
func TargetOptions_Values() []string {
	return []string{
		TargetOptionsInput,
		TargetOptionsOutput,
	}
}

const (
	// TemporalStatisticsMean is a TemporalStatistics enum value
	TemporalStatisticsMean = "MEAN"

	// TemporalStatisticsMedian is a TemporalStatistics enum value
	TemporalStatisticsMedian = "MEDIAN"

	// TemporalStatisticsStandardDeviation is a TemporalStatistics enum value
	TemporalStatisticsStandardDeviation = "STANDARD_DEVIATION"
)

// TemporalStatistics_Values returns all elements of the TemporalStatistics enum
func TemporalStatistics_Values() []string {
	return []string{
		TemporalStatisticsMean,
		TemporalStatisticsMedian,
		TemporalStatisticsStandardDeviation,
	}
}

const (
	// UnitMeters is a Unit enum value
	UnitMeters = "METERS"
)

// Unit_Values returns all elements of the Unit enum
func Unit_Values() []string {
	return []string{
		UnitMeters,
	}
}

const (
	// VectorEnrichmentJobDocumentTypeCsv is a VectorEnrichmentJobDocumentType enum value
	VectorEnrichmentJobDocumentTypeCsv = "CSV"
)

// VectorEnrichmentJobDocumentType_Values returns all elements of the VectorEnrichmentJobDocumentType enum
func VectorEnrichmentJobDocumentType_Values() []string {
	return []string{
		VectorEnrichmentJobDocumentTypeCsv,
	}
}

const (
	// VectorEnrichmentJobErrorTypeClientError is a VectorEnrichmentJobErrorType enum value
	VectorEnrichmentJobErrorTypeClientError = "CLIENT_ERROR"

	// VectorEnrichmentJobErrorTypeServerError is a VectorEnrichmentJobErrorType enum value
	VectorEnrichmentJobErrorTypeServerError = "SERVER_ERROR"
)

// VectorEnrichmentJobErrorType_Values returns all elements of the VectorEnrichmentJobErrorType enum
func VectorEnrichmentJobErrorType_Values() []string {
	return []string{
		VectorEnrichmentJobErrorTypeClientError,
		VectorEnrichmentJobErrorTypeServerError,
	}
}

const (
	// VectorEnrichmentJobExportErrorTypeClientError is a VectorEnrichmentJobExportErrorType enum value
	VectorEnrichmentJobExportErrorTypeClientError = "CLIENT_ERROR"

	// VectorEnrichmentJobExportErrorTypeServerError is a VectorEnrichmentJobExportErrorType enum value
	VectorEnrichmentJobExportErrorTypeServerError = "SERVER_ERROR"
)

// VectorEnrichmentJobExportErrorType_Values returns all elements of the VectorEnrichmentJobExportErrorType enum
func VectorEnrichmentJobExportErrorType_Values() []string {
	return []string{
		VectorEnrichmentJobExportErrorTypeClientError,
		VectorEnrichmentJobExportErrorTypeServerError,
	}
}

const (
	// VectorEnrichmentJobExportStatusInProgress is a VectorEnrichmentJobExportStatus enum value
	VectorEnrichmentJobExportStatusInProgress = "IN_PROGRESS"

	// VectorEnrichmentJobExportStatusSucceeded is a VectorEnrichmentJobExportStatus enum value
	VectorEnrichmentJobExportStatusSucceeded = "SUCCEEDED"

	// VectorEnrichmentJobExportStatusFailed is a VectorEnrichmentJobExportStatus enum value
	VectorEnrichmentJobExportStatusFailed = "FAILED"
)

// VectorEnrichmentJobExportStatus_Values returns all elements of the VectorEnrichmentJobExportStatus enum
func VectorEnrichmentJobExportStatus_Values() []string {
	return []string{
		VectorEnrichmentJobExportStatusInProgress,
		VectorEnrichmentJobExportStatusSucceeded,
		VectorEnrichmentJobExportStatusFailed,
	}
}

const (
	// VectorEnrichmentJobStatusInitializing is a VectorEnrichmentJobStatus enum value
	VectorEnrichmentJobStatusInitializing = "INITIALIZING"

	// VectorEnrichmentJobStatusInProgress is a VectorEnrichmentJobStatus enum value
	VectorEnrichmentJobStatusInProgress = "IN_PROGRESS"

	// VectorEnrichmentJobStatusStopping is a VectorEnrichmentJobStatus enum value
	VectorEnrichmentJobStatusStopping = "STOPPING"

	// VectorEnrichmentJobStatusStopped is a VectorEnrichmentJobStatus enum value
	VectorEnrichmentJobStatusStopped = "STOPPED"

	// VectorEnrichmentJobStatusCompleted is a VectorEnrichmentJobStatus enum value
	VectorEnrichmentJobStatusCompleted = "COMPLETED"

	// VectorEnrichmentJobStatusFailed is a VectorEnrichmentJobStatus enum value
	VectorEnrichmentJobStatusFailed = "FAILED"

	// VectorEnrichmentJobStatusDeleting is a VectorEnrichmentJobStatus enum value
	VectorEnrichmentJobStatusDeleting = "DELETING"

	// VectorEnrichmentJobStatusDeleted is a VectorEnrichmentJobStatus enum value
	VectorEnrichmentJobStatusDeleted = "DELETED"
)

// VectorEnrichmentJobStatus_Values returns all elements of the VectorEnrichmentJobStatus enum
func VectorEnrichmentJobStatus_Values() []string {
	return []string{
		VectorEnrichmentJobStatusInitializing,
		VectorEnrichmentJobStatusInProgress,
		VectorEnrichmentJobStatusStopping,
		VectorEnrichmentJobStatusStopped,
		VectorEnrichmentJobStatusCompleted,
		VectorEnrichmentJobStatusFailed,
		VectorEnrichmentJobStatusDeleting,
		VectorEnrichmentJobStatusDeleted,
	}
}

const (
	// VectorEnrichmentJobTypeReverseGeocoding is a VectorEnrichmentJobType enum value
	VectorEnrichmentJobTypeReverseGeocoding = "REVERSE_GEOCODING"

	// VectorEnrichmentJobTypeMapMatching is a VectorEnrichmentJobType enum value
	VectorEnrichmentJobTypeMapMatching = "MAP_MATCHING"
)

// VectorEnrichmentJobType_Values returns all elements of the VectorEnrichmentJobType enum
func VectorEnrichmentJobType_Values() []string {
	return []string{
		VectorEnrichmentJobTypeReverseGeocoding,
		VectorEnrichmentJobTypeMapMatching,
	}
}

const (
	// ZonalStatisticsMean is a ZonalStatistics enum value
	ZonalStatisticsMean = "MEAN"

	// ZonalStatisticsMedian is a ZonalStatistics enum value
	ZonalStatisticsMedian = "MEDIAN"

	// ZonalStatisticsStandardDeviation is a ZonalStatistics enum value
	ZonalStatisticsStandardDeviation = "STANDARD_DEVIATION"

	// ZonalStatisticsMax is a ZonalStatistics enum value
	ZonalStatisticsMax = "MAX"

	// ZonalStatisticsMin is a ZonalStatistics enum value
	ZonalStatisticsMin = "MIN"

	// ZonalStatisticsSum is a ZonalStatistics enum value
	ZonalStatisticsSum = "SUM"
)

// ZonalStatistics_Values returns all elements of the ZonalStatistics enum
func ZonalStatistics_Values() []string {
	return []string{
		ZonalStatisticsMean,
		ZonalStatisticsMedian,
		ZonalStatisticsStandardDeviation,
		ZonalStatisticsMax,
		ZonalStatisticsMin,
		ZonalStatisticsSum,
	}
}
