/*
 * Decompiled with CFR 0.152.
 */
package org.webpki.jcs;

import java.io.IOException;
import java.math.BigInteger;

public final class NumberToJSON {
    private static boolean DEBUG = false;
    private static final int DOUBLE_MANTISSA_BITS = 52;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int DOUBLE_EXPONENT_BITS = 11;
    private static final int DOUBLE_EXPONENT_MASK = 2047;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final int POS_TABLE_SIZE = 326;
    private static final int NEG_TABLE_SIZE = 291;
    private static final long ZERO_PATTERN = Long.MAX_VALUE;
    private static final long INVALID_PATTERN = 0x7FF0000000000000L;
    private static final BigInteger[] POW5 = new BigInteger[326];
    private static final BigInteger[] POW5_INV = new BigInteger[291];
    private static final int POW5_BITCOUNT = 121;
    private static final int POW5_QUARTER_BITCOUNT = 31;
    private static final int[][] POW5_SPLIT = new int[326][4];
    private static final int POW5_INV_BITCOUNT = 122;
    private static final int POW5_INV_QUARTER_BITCOUNT = 31;
    private static final int[][] POW5_INV_SPLIT = new int[291][4];

    public static String serializeNumber(double value) throws IOException {
        long output;
        int vplength;
        int exp;
        int e10;
        long dm;
        long dp;
        long dv;
        int q;
        boolean sign;
        long m2;
        int e2;
        long bits = Double.doubleToLongBits(value);
        if ((bits & Long.MAX_VALUE) == 0L) {
            return "0";
        }
        if ((bits & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            throw new IOException("NaN/Infinity not allowed in JSON");
        }
        int ieeeExponent = (int)(bits >>> 52 & 0x7FFL);
        long ieeeMantissa = bits & 0xFFFFFFFFFFFFFL;
        if (ieeeExponent == 0) {
            e2 = -1074;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 1023 - 52;
            m2 = ieeeMantissa | 0x10000000000000L;
        }
        boolean bl = sign = bits < 0L;
        if (DEBUG) {
            System.out.println("IN=" + Long.toBinaryString(bits));
            System.out.println("   S=" + (sign ? "-" : "+") + " E=" + e2 + " M=" + m2);
        }
        boolean even = (m2 & 1L) == 0L;
        long mv = 4L * m2;
        long mp = 4L * m2 + 2L;
        int mmShift = m2 != 0x10000000000000L || ieeeExponent <= 1 ? 1 : 0;
        long mm = 4L * m2 - 1L - (long)mmShift;
        e2 -= 2;
        if (DEBUG) {
            int e102;
            String sm;
            String sp;
            String sv;
            if (e2 >= 0) {
                sv = BigInteger.valueOf(mv).shiftLeft(e2).toString();
                sp = BigInteger.valueOf(mp).shiftLeft(e2).toString();
                sm = BigInteger.valueOf(mm).shiftLeft(e2).toString();
                e102 = 0;
            } else {
                BigInteger factor = BigInteger.valueOf(5L).pow(-e2);
                sv = BigInteger.valueOf(mv).multiply(factor).toString();
                sp = BigInteger.valueOf(mp).multiply(factor).toString();
                sm = BigInteger.valueOf(mm).multiply(factor).toString();
                e102 = e2;
            }
            System.out.println("E =" + (e102 += sp.length() - 1));
            System.out.println("d+=" + sp);
            System.out.println("d =" + sv);
            System.out.println("d-=" + sm);
            System.out.println("e2=" + e2);
        }
        boolean dmIsTrailingZeros = false;
        boolean dvIsTrailingZeros = false;
        if (e2 >= 0) {
            q = Math.max(0, (e2 * 78913 >>> 18) - 1);
            int k = 122 + NumberToJSON.pow5bits(q) - 1;
            int i = -e2 + q + k;
            dv = NumberToJSON.mulPow5InvDivPow2(mv, q, i);
            dp = NumberToJSON.mulPow5InvDivPow2(mp, q, i);
            dm = NumberToJSON.mulPow5InvDivPow2(mm, q, i);
            e10 = q;
            if (DEBUG) {
                System.out.println(mv + " * 2^" + e2);
                System.out.println("V+=" + dp);
                System.out.println("V =" + dv);
                System.out.println("V-=" + dm);
            }
            if (DEBUG) {
                long exact = POW5_INV[q].multiply(BigInteger.valueOf(mv)).shiftRight(-e2 + q + k).longValueExact();
                System.out.println(exact + " " + POW5_INV[q].bitCount());
                if (dv != exact) {
                    throw new IllegalStateException();
                }
            }
            if (q <= 21) {
                if (mv % 5L == 0L) {
                    dvIsTrailingZeros = NumberToJSON.multipleOfPowerOf5(mv, q);
                } else if (even) {
                    dmIsTrailingZeros = NumberToJSON.multipleOfPowerOf5(mm, q);
                } else if (NumberToJSON.multipleOfPowerOf5(mp, q)) {
                    --dp;
                }
            }
        } else {
            q = Math.max(0, (-e2 * 732923 >>> 20) - 1);
            int i = -e2 - q;
            int k = NumberToJSON.pow5bits(i) - 121;
            int j = q - k;
            dv = NumberToJSON.mulPow5divPow2(mv, i, j);
            dp = NumberToJSON.mulPow5divPow2(mp, i, j);
            dm = NumberToJSON.mulPow5divPow2(mm, i, j);
            e10 = q + e2;
            if (DEBUG) {
                System.out.println(mv + " * 5^" + -e2 + " / 10^" + q);
            }
            if (q <= 1) {
                dvIsTrailingZeros = true;
                if (even) {
                    dmIsTrailingZeros = mmShift == 1;
                } else {
                    --dp;
                }
            } else if (q < 63) {
                boolean bl2 = dvIsTrailingZeros = (mv & (1L << q - 1) - 1L) == 0L;
            }
        }
        if (DEBUG) {
            System.out.println("d+=" + dp);
            System.out.println("d =" + dv);
            System.out.println("d-=" + dm);
            System.out.println("e10=" + e10);
            System.out.println("d-10=" + dmIsTrailingZeros);
            System.out.println("d   =" + dvIsTrailingZeros);
            System.out.println("Accept upper=" + even);
            System.out.println("Accept lower=" + even);
        }
        boolean scientificNotation = (exp = e10 + (vplength = NumberToJSON.decimalLength(dp)) - 1) < -6 || exp >= 21;
        int removed = 0;
        int lastRemovedDigit = 0;
        if (dmIsTrailingZeros || dvIsTrailingZeros) {
            while (dp / 10L > dm / 10L) {
                dmIsTrailingZeros &= dm % 10L == 0L;
                dvIsTrailingZeros &= lastRemovedDigit == 0;
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            if (dmIsTrailingZeros && even) {
                while (dm % 10L == 0L) {
                    dvIsTrailingZeros &= lastRemovedDigit == 0;
                    lastRemovedDigit = (int)(dv % 10L);
                    dp /= 10L;
                    dv /= 10L;
                    dm /= 10L;
                    ++removed;
                }
            }
            if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2L == 0L) {
                lastRemovedDigit = 4;
            }
            output = dv + (long)(dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        } else {
            while (dp / 10L > dm / 10L) {
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            output = dv + (long)(dv == dm || lastRemovedDigit >= 5 ? 1 : 0);
        }
        int olength = vplength - removed;
        if (DEBUG) {
            System.out.println("LAST_REMOVED_DIGIT=" + lastRemovedDigit);
            System.out.println("VP=" + dp);
            System.out.println("VR=" + dv);
            System.out.println("VM=" + dm);
            System.out.println("O=" + output);
            System.out.println("OLEN=" + olength);
            System.out.println("EXP=" + exp);
        }
        char[] result = new char[25];
        int index = 0;
        if (sign) {
            result[index++] = 45;
        }
        if (scientificNotation) {
            for (int i = 0; i < olength - 1; ++i) {
                int c = (int)(output % 10L);
                output /= 10L;
                result[index + olength - i] = (char)(48 + c);
            }
            result[index] = (char)(48L + output % 10L);
            if (olength > 1) {
                result[index + 1] = 46;
            } else {
                --index;
            }
            index += olength + 1;
            result[index++] = 101;
            if (exp < 0) {
                result[index++] = 45;
                exp = -exp;
            } else {
                result[index++] = 43;
            }
            if (exp >= 100) {
                result[index++] = (char)(48 + exp / 100);
                result[index++] = (char)(48 + (exp %= 100) / 10);
            } else if (exp >= 10) {
                result[index++] = (char)(48 + exp / 10);
            }
            result[index++] = (char)(48 + exp % 10);
            return new String(result, 0, index);
        }
        if (exp < 0) {
            result[index++] = 48;
            result[index++] = 46;
            for (int i = -1; i > exp; --i) {
                result[index++] = 48;
            }
            int current = index;
            for (int i = 0; i < olength; ++i) {
                result[current + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i;
            for (i = 0; i < olength; ++i) {
                result[index + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
            }
            index += olength;
            for (i = olength; i < exp + 1; ++i) {
                result[index++] = 48;
            }
        } else {
            int current = index + 1;
            for (int i = 0; i < olength; ++i) {
                if (olength - i - 1 == exp) {
                    result[current + olength - i - 1] = 46;
                    --current;
                }
                result[current + olength - i - 1] = (char)(48L + output % 10L);
                output /= 10L;
            }
            index += olength + 1;
        }
        return new String(result, 0, index);
    }

    private static int pow5bits(int e) {
        return (e * 1217359 >>> 19) + 1;
    }

    private static int decimalLength(long v) {
        if (v >= 1000000000000000000L) {
            return 19;
        }
        if (v >= 100000000000000000L) {
            return 18;
        }
        if (v >= 10000000000000000L) {
            return 17;
        }
        if (v >= 1000000000000000L) {
            return 16;
        }
        if (v >= 100000000000000L) {
            return 15;
        }
        if (v >= 10000000000000L) {
            return 14;
        }
        if (v >= 1000000000000L) {
            return 13;
        }
        if (v >= 100000000000L) {
            return 12;
        }
        if (v >= 10000000000L) {
            return 11;
        }
        if (v >= 1000000000L) {
            return 10;
        }
        if (v >= 100000000L) {
            return 9;
        }
        if (v >= 10000000L) {
            return 8;
        }
        if (v >= 1000000L) {
            return 7;
        }
        if (v >= 100000L) {
            return 6;
        }
        if (v >= 10000L) {
            return 5;
        }
        if (v >= 1000L) {
            return 4;
        }
        if (v >= 100L) {
            return 3;
        }
        if (v >= 10L) {
            return 2;
        }
        return 1;
    }

    private static boolean multipleOfPowerOf5(long value, int q) {
        return NumberToJSON.pow5Factor(value) >= q;
    }

    private static int pow5Factor(long value) {
        if (value % 5L != 0L) {
            return 0;
        }
        if (value % 25L != 0L) {
            return 1;
        }
        if (value % 125L != 0L) {
            return 2;
        }
        if (value % 625L != 0L) {
            return 3;
        }
        int count = 4;
        value /= 625L;
        while (value > 0L) {
            if (value % 5L != 0L) {
                return count;
            }
            value /= 5L;
            ++count;
        }
        throw new IllegalArgumentException("" + value);
    }

    private static long mulPow5divPow2(long m, int i, int j) {
        long mHigh = m >>> 31;
        long mLow = m & Integer.MAX_VALUE;
        long bits13 = mHigh * (long)POW5_SPLIT[i][0];
        long bits03 = mLow * (long)POW5_SPLIT[i][0];
        long bits12 = mHigh * (long)POW5_SPLIT[i][1];
        long bits02 = mLow * (long)POW5_SPLIT[i][1];
        long bits11 = mHigh * (long)POW5_SPLIT[i][2];
        long bits01 = mLow * (long)POW5_SPLIT[i][2];
        long bits10 = mHigh * (long)POW5_SPLIT[i][3];
        long bits00 = mLow * (long)POW5_SPLIT[i][3];
        int actualShift = j - 93 - 21;
        if (actualShift < 0) {
            throw new IllegalArgumentException("" + actualShift);
        }
        return ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
    }

    private static long mulPow5InvDivPow2(long m, int i, int j) {
        long mHigh = m >>> 31;
        long mLow = m & Integer.MAX_VALUE;
        long bits13 = mHigh * (long)POW5_INV_SPLIT[i][0];
        long bits03 = mLow * (long)POW5_INV_SPLIT[i][0];
        long bits12 = mHigh * (long)POW5_INV_SPLIT[i][1];
        long bits02 = mLow * (long)POW5_INV_SPLIT[i][1];
        long bits11 = mHigh * (long)POW5_INV_SPLIT[i][2];
        long bits01 = mLow * (long)POW5_INV_SPLIT[i][2];
        long bits10 = mHigh * (long)POW5_INV_SPLIT[i][3];
        long bits00 = mLow * (long)POW5_INV_SPLIT[i][3];
        int actualShift = j - 93 - 21;
        if (actualShift < 0) {
            throw new IllegalArgumentException("" + actualShift);
        }
        return ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
    }

    static {
        BigInteger mask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        BigInteger invMask = BigInteger.valueOf(1L).shiftLeft(31).subtract(BigInteger.ONE);
        for (int i = 0; i < Math.max(POW5.length, POW5_INV.length); ++i) {
            BigInteger inv;
            int j;
            BigInteger pow = BigInteger.valueOf(5L).pow(i);
            int pow5len = pow.bitLength();
            int expectedPow5Bits = NumberToJSON.pow5bits(i);
            if (expectedPow5Bits != pow5len) {
                throw new IllegalStateException(pow5len + " != " + expectedPow5Bits);
            }
            if (i < POW5.length) {
                NumberToJSON.POW5[i] = pow;
            }
            if (i < POW5_SPLIT.length) {
                for (j = 0; j < 4; ++j) {
                    NumberToJSON.POW5_SPLIT[i][j] = pow.shiftRight(pow5len - 121 + (3 - j) * 31).and(mask).intValueExact();
                }
            }
            if (i >= POW5_INV_SPLIT.length) continue;
            j = pow5len - 1 + 122;
            NumberToJSON.POW5_INV[i] = inv = BigInteger.ONE.shiftLeft(j).divide(pow).add(BigInteger.ONE);
            for (int k = 0; k < 4; ++k) {
                NumberToJSON.POW5_INV_SPLIT[i][k] = k == 0 ? inv.shiftRight((3 - k) * 31).intValueExact() : inv.shiftRight((3 - k) * 31).and(invMask).intValueExact();
            }
        }
    }
}

