// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListTGWAttachmentsParams creates a new ListTGWAttachmentsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListTGWAttachmentsParams() *ListTGWAttachmentsParams {
	return &ListTGWAttachmentsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListTGWAttachmentsParamsWithTimeout creates a new ListTGWAttachmentsParams object
// with the ability to set a timeout on a request.
func NewListTGWAttachmentsParamsWithTimeout(timeout time.Duration) *ListTGWAttachmentsParams {
	return &ListTGWAttachmentsParams{
		timeout: timeout,
	}
}

// NewListTGWAttachmentsParamsWithContext creates a new ListTGWAttachmentsParams object
// with the ability to set a context for a request.
func NewListTGWAttachmentsParamsWithContext(ctx context.Context) *ListTGWAttachmentsParams {
	return &ListTGWAttachmentsParams{
		Context: ctx,
	}
}

// NewListTGWAttachmentsParamsWithHTTPClient creates a new ListTGWAttachmentsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListTGWAttachmentsParamsWithHTTPClient(client *http.Client) *ListTGWAttachmentsParams {
	return &ListTGWAttachmentsParams{
		HTTPClient: client,
	}
}

/*
ListTGWAttachmentsParams contains all the parameters to send to the API endpoint

	for the list t g w attachments operation.

	Typically these are written to a http.Request.
*/
type ListTGWAttachmentsParams struct {

	/* HvnDescription.

	     description is a human-friendly description for this link. This is
	used primarily for informational purposes such as error messages.
	*/
	HvnDescription *string

	/* HvnID.

	   id is the identifier for this resource.
	*/
	HvnID string

	/* HvnLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	HvnLocationOrganizationID string

	/* HvnLocationProjectID.

	   project_id is the projects id.
	*/
	HvnLocationProjectID string

	/* HvnLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	HvnLocationRegionProvider *string

	/* HvnLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	HvnLocationRegionRegion *string

	/* HvnType.

	     type is the unique type of the resource. Each service publishes a
	unique set of types. The type value is recommended to be formatted
	in "<org>.<type>" such as "hashicorp.hvn". This is to prevent conflicts
	in the future, but any string value will work.
	*/
	HvnType *string

	/* HvnUUID.

	   uuid is the unique UUID for this resource.
	*/
	HvnUUID *string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* States.

	     States is an optional parameter to list only TGW Attachments in a certain states
	if not specified all TGW Attachments will be returned.
	*/
	States []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list t g w attachments params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListTGWAttachmentsParams) WithDefaults() *ListTGWAttachmentsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list t g w attachments params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListTGWAttachmentsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithTimeout(timeout time.Duration) *ListTGWAttachmentsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithContext(ctx context.Context) *ListTGWAttachmentsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHTTPClient(client *http.Client) *ListTGWAttachmentsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHvnDescription adds the hvnDescription to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHvnDescription(hvnDescription *string) *ListTGWAttachmentsParams {
	o.SetHvnDescription(hvnDescription)
	return o
}

// SetHvnDescription adds the hvnDescription to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHvnDescription(hvnDescription *string) {
	o.HvnDescription = hvnDescription
}

// WithHvnID adds the hvnID to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHvnID(hvnID string) *ListTGWAttachmentsParams {
	o.SetHvnID(hvnID)
	return o
}

// SetHvnID adds the hvnId to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHvnID(hvnID string) {
	o.HvnID = hvnID
}

// WithHvnLocationOrganizationID adds the hvnLocationOrganizationID to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHvnLocationOrganizationID(hvnLocationOrganizationID string) *ListTGWAttachmentsParams {
	o.SetHvnLocationOrganizationID(hvnLocationOrganizationID)
	return o
}

// SetHvnLocationOrganizationID adds the hvnLocationOrganizationId to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHvnLocationOrganizationID(hvnLocationOrganizationID string) {
	o.HvnLocationOrganizationID = hvnLocationOrganizationID
}

// WithHvnLocationProjectID adds the hvnLocationProjectID to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHvnLocationProjectID(hvnLocationProjectID string) *ListTGWAttachmentsParams {
	o.SetHvnLocationProjectID(hvnLocationProjectID)
	return o
}

// SetHvnLocationProjectID adds the hvnLocationProjectId to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHvnLocationProjectID(hvnLocationProjectID string) {
	o.HvnLocationProjectID = hvnLocationProjectID
}

// WithHvnLocationRegionProvider adds the hvnLocationRegionProvider to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHvnLocationRegionProvider(hvnLocationRegionProvider *string) *ListTGWAttachmentsParams {
	o.SetHvnLocationRegionProvider(hvnLocationRegionProvider)
	return o
}

// SetHvnLocationRegionProvider adds the hvnLocationRegionProvider to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHvnLocationRegionProvider(hvnLocationRegionProvider *string) {
	o.HvnLocationRegionProvider = hvnLocationRegionProvider
}

// WithHvnLocationRegionRegion adds the hvnLocationRegionRegion to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHvnLocationRegionRegion(hvnLocationRegionRegion *string) *ListTGWAttachmentsParams {
	o.SetHvnLocationRegionRegion(hvnLocationRegionRegion)
	return o
}

// SetHvnLocationRegionRegion adds the hvnLocationRegionRegion to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHvnLocationRegionRegion(hvnLocationRegionRegion *string) {
	o.HvnLocationRegionRegion = hvnLocationRegionRegion
}

// WithHvnType adds the hvnType to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHvnType(hvnType *string) *ListTGWAttachmentsParams {
	o.SetHvnType(hvnType)
	return o
}

// SetHvnType adds the hvnType to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHvnType(hvnType *string) {
	o.HvnType = hvnType
}

// WithHvnUUID adds the hvnUUID to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithHvnUUID(hvnUUID *string) *ListTGWAttachmentsParams {
	o.SetHvnUUID(hvnUUID)
	return o
}

// SetHvnUUID adds the hvnUuid to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetHvnUUID(hvnUUID *string) {
	o.HvnUUID = hvnUUID
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListTGWAttachmentsParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithPaginationPageSize(paginationPageSize *int64) *ListTGWAttachmentsParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListTGWAttachmentsParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithStates adds the states to the list t g w attachments params
func (o *ListTGWAttachmentsParams) WithStates(states []string) *ListTGWAttachmentsParams {
	o.SetStates(states)
	return o
}

// SetStates adds the states to the list t g w attachments params
func (o *ListTGWAttachmentsParams) SetStates(states []string) {
	o.States = states
}

// WriteToRequest writes these params to a swagger request
func (o *ListTGWAttachmentsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.HvnDescription != nil {

		// query param hvn.description
		var qrHvnDescription string

		if o.HvnDescription != nil {
			qrHvnDescription = *o.HvnDescription
		}
		qHvnDescription := qrHvnDescription
		if qHvnDescription != "" {

			if err := r.SetQueryParam("hvn.description", qHvnDescription); err != nil {
				return err
			}
		}
	}

	// path param hvn.id
	if err := r.SetPathParam("hvn.id", o.HvnID); err != nil {
		return err
	}

	// path param hvn.location.organization_id
	if err := r.SetPathParam("hvn.location.organization_id", o.HvnLocationOrganizationID); err != nil {
		return err
	}

	// path param hvn.location.project_id
	if err := r.SetPathParam("hvn.location.project_id", o.HvnLocationProjectID); err != nil {
		return err
	}

	if o.HvnLocationRegionProvider != nil {

		// query param hvn.location.region.provider
		var qrHvnLocationRegionProvider string

		if o.HvnLocationRegionProvider != nil {
			qrHvnLocationRegionProvider = *o.HvnLocationRegionProvider
		}
		qHvnLocationRegionProvider := qrHvnLocationRegionProvider
		if qHvnLocationRegionProvider != "" {

			if err := r.SetQueryParam("hvn.location.region.provider", qHvnLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.HvnLocationRegionRegion != nil {

		// query param hvn.location.region.region
		var qrHvnLocationRegionRegion string

		if o.HvnLocationRegionRegion != nil {
			qrHvnLocationRegionRegion = *o.HvnLocationRegionRegion
		}
		qHvnLocationRegionRegion := qrHvnLocationRegionRegion
		if qHvnLocationRegionRegion != "" {

			if err := r.SetQueryParam("hvn.location.region.region", qHvnLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.HvnType != nil {

		// query param hvn.type
		var qrHvnType string

		if o.HvnType != nil {
			qrHvnType = *o.HvnType
		}
		qHvnType := qrHvnType
		if qHvnType != "" {

			if err := r.SetQueryParam("hvn.type", qHvnType); err != nil {
				return err
			}
		}
	}

	if o.HvnUUID != nil {

		// query param hvn.uuid
		var qrHvnUUID string

		if o.HvnUUID != nil {
			qrHvnUUID = *o.HvnUUID
		}
		qHvnUUID := qrHvnUUID
		if qHvnUUID != "" {

			if err := r.SetQueryParam("hvn.uuid", qHvnUUID); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.States != nil {

		// binding items for states
		joinedStates := o.bindParamStates(reg)

		// query array param states
		if err := r.SetQueryParam("states", joinedStates...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListTGWAttachments binds the parameter states
func (o *ListTGWAttachmentsParams) bindParamStates(formats strfmt.Registry) []string {
	statesIR := o.States

	var statesIC []string
	for _, statesIIR := range statesIR { // explode []string

		statesIIV := statesIIR // string as string
		statesIC = append(statesIC, statesIIV)
	}

	// items.CollectionFormat: "multi"
	statesIS := swag.JoinByFormat(statesIC, "multi")

	return statesIS
}
