// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2021-04-30/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceCreateRegistryReader is a Reader for the PackerServiceCreateRegistry structure.
type PackerServiceCreateRegistryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceCreateRegistryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceCreateRegistryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceCreateRegistryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceCreateRegistryOK creates a PackerServiceCreateRegistryOK with default headers values
func NewPackerServiceCreateRegistryOK() *PackerServiceCreateRegistryOK {
	return &PackerServiceCreateRegistryOK{}
}

/*
PackerServiceCreateRegistryOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceCreateRegistryOK struct {
	Payload *models.HashicorpCloudPackerCreateRegistryResponse
}

// IsSuccess returns true when this packer service create registry o k response has a 2xx status code
func (o *PackerServiceCreateRegistryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service create registry o k response has a 3xx status code
func (o *PackerServiceCreateRegistryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service create registry o k response has a 4xx status code
func (o *PackerServiceCreateRegistryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service create registry o k response has a 5xx status code
func (o *PackerServiceCreateRegistryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service create registry o k response a status code equal to that given
func (o *PackerServiceCreateRegistryOK) IsCode(code int) bool {
	return code == 200
}

func (o *PackerServiceCreateRegistryOK) Error() string {
	return fmt.Sprintf("[PUT /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceCreateRegistryOK  %+v", 200, o.Payload)
}

func (o *PackerServiceCreateRegistryOK) String() string {
	return fmt.Sprintf("[PUT /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceCreateRegistryOK  %+v", 200, o.Payload)
}

func (o *PackerServiceCreateRegistryOK) GetPayload() *models.HashicorpCloudPackerCreateRegistryResponse {
	return o.Payload
}

func (o *PackerServiceCreateRegistryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPackerCreateRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceCreateRegistryDefault creates a PackerServiceCreateRegistryDefault with default headers values
func NewPackerServiceCreateRegistryDefault(code int) *PackerServiceCreateRegistryDefault {
	return &PackerServiceCreateRegistryDefault{
		_statusCode: code,
	}
}

/*
PackerServiceCreateRegistryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceCreateRegistryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// Code gets the status code for the packer service create registry default response
func (o *PackerServiceCreateRegistryDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this packer service create registry default response has a 2xx status code
func (o *PackerServiceCreateRegistryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service create registry default response has a 3xx status code
func (o *PackerServiceCreateRegistryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service create registry default response has a 4xx status code
func (o *PackerServiceCreateRegistryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service create registry default response has a 5xx status code
func (o *PackerServiceCreateRegistryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service create registry default response a status code equal to that given
func (o *PackerServiceCreateRegistryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *PackerServiceCreateRegistryDefault) Error() string {
	return fmt.Sprintf("[PUT /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_CreateRegistry default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceCreateRegistryDefault) String() string {
	return fmt.Sprintf("[PUT /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_CreateRegistry default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceCreateRegistryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceCreateRegistryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PackerServiceCreateRegistryBody packer service create registry body
swagger:model PackerServiceCreateRegistryBody
*/
type PackerServiceCreateRegistryBody struct {

	// Feature tier of the Registry.
	FeatureTier *models.HashicorpCloudPackerRegistryConfigTier `json:"feature_tier,omitempty"`

	// location
	Location *PackerServiceCreateRegistryParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this packer service create registry body
func (o *PackerServiceCreateRegistryBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFeatureTier(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceCreateRegistryBody) validateFeatureTier(formats strfmt.Registry) error {
	if swag.IsZero(o.FeatureTier) { // not required
		return nil
	}

	if o.FeatureTier != nil {
		if err := o.FeatureTier.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "feature_tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "feature_tier")
			}
			return err
		}
	}

	return nil
}

func (o *PackerServiceCreateRegistryBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this packer service create registry body based on the context it is used
func (o *PackerServiceCreateRegistryBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFeatureTier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceCreateRegistryBody) contextValidateFeatureTier(ctx context.Context, formats strfmt.Registry) error {

	if o.FeatureTier != nil {
		if err := o.FeatureTier.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "feature_tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "feature_tier")
			}
			return err
		}
	}

	return nil
}

func (o *PackerServiceCreateRegistryBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {
		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PackerServiceCreateRegistryBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PackerServiceCreateRegistryBody) UnmarshalBinary(b []byte) error {
	var res PackerServiceCreateRegistryBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PackerServiceCreateRegistryParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model PackerServiceCreateRegistryParamsBodyLocation
*/
type PackerServiceCreateRegistryParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this packer service create registry params body location
func (o *PackerServiceCreateRegistryParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceCreateRegistryParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this packer service create registry params body location based on the context it is used
func (o *PackerServiceCreateRegistryParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceCreateRegistryParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {
		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PackerServiceCreateRegistryParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PackerServiceCreateRegistryParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res PackerServiceCreateRegistryParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
