// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeregisterLinkedClusterParams creates a new DeregisterLinkedClusterParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeregisterLinkedClusterParams() *DeregisterLinkedClusterParams {
	return &DeregisterLinkedClusterParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeregisterLinkedClusterParamsWithTimeout creates a new DeregisterLinkedClusterParams object
// with the ability to set a timeout on a request.
func NewDeregisterLinkedClusterParamsWithTimeout(timeout time.Duration) *DeregisterLinkedClusterParams {
	return &DeregisterLinkedClusterParams{
		timeout: timeout,
	}
}

// NewDeregisterLinkedClusterParamsWithContext creates a new DeregisterLinkedClusterParams object
// with the ability to set a context for a request.
func NewDeregisterLinkedClusterParamsWithContext(ctx context.Context) *DeregisterLinkedClusterParams {
	return &DeregisterLinkedClusterParams{
		Context: ctx,
	}
}

// NewDeregisterLinkedClusterParamsWithHTTPClient creates a new DeregisterLinkedClusterParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeregisterLinkedClusterParamsWithHTTPClient(client *http.Client) *DeregisterLinkedClusterParams {
	return &DeregisterLinkedClusterParams{
		HTTPClient: client,
	}
}

/*
DeregisterLinkedClusterParams contains all the parameters to send to the API endpoint

	for the deregister linked cluster operation.

	Typically these are written to a http.Request.
*/
type DeregisterLinkedClusterParams struct {

	/* ClusterLinkDescription.

	     description is a human-friendly description for this link. This is
	used primarily for informational purposes such as error messages.
	*/
	ClusterLinkDescription *string

	/* ClusterLinkID.

	   id is the identifier for this resource.
	*/
	ClusterLinkID *string

	/* ClusterLinkLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	ClusterLinkLocationOrganizationID string

	/* ClusterLinkLocationProjectID.

	   project_id is the projects id.
	*/
	ClusterLinkLocationProjectID string

	/* ClusterLinkLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	ClusterLinkLocationRegionProvider *string

	/* ClusterLinkLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	ClusterLinkLocationRegionRegion *string

	/* ClusterLinkType.

	     type is the unique type of the resource. Each service publishes a
	unique set of types. The type value is recommended to be formatted
	in "<org>.<type>" such as "hashicorp.hvn". This is to prevent conflicts
	in the future, but any string value will work.
	*/
	ClusterLinkType *string

	/* ClusterLinkUUID.

	   uuid is the unique UUID for this resource.
	*/
	ClusterLinkUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the deregister linked cluster params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeregisterLinkedClusterParams) WithDefaults() *DeregisterLinkedClusterParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the deregister linked cluster params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeregisterLinkedClusterParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithTimeout(timeout time.Duration) *DeregisterLinkedClusterParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithContext(ctx context.Context) *DeregisterLinkedClusterParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithHTTPClient(client *http.Client) *DeregisterLinkedClusterParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterLinkDescription adds the clusterLinkDescription to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithClusterLinkDescription(clusterLinkDescription *string) *DeregisterLinkedClusterParams {
	o.SetClusterLinkDescription(clusterLinkDescription)
	return o
}

// SetClusterLinkDescription adds the clusterLinkDescription to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetClusterLinkDescription(clusterLinkDescription *string) {
	o.ClusterLinkDescription = clusterLinkDescription
}

// WithClusterLinkID adds the clusterLinkID to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithClusterLinkID(clusterLinkID *string) *DeregisterLinkedClusterParams {
	o.SetClusterLinkID(clusterLinkID)
	return o
}

// SetClusterLinkID adds the clusterLinkId to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetClusterLinkID(clusterLinkID *string) {
	o.ClusterLinkID = clusterLinkID
}

// WithClusterLinkLocationOrganizationID adds the clusterLinkLocationOrganizationID to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithClusterLinkLocationOrganizationID(clusterLinkLocationOrganizationID string) *DeregisterLinkedClusterParams {
	o.SetClusterLinkLocationOrganizationID(clusterLinkLocationOrganizationID)
	return o
}

// SetClusterLinkLocationOrganizationID adds the clusterLinkLocationOrganizationId to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetClusterLinkLocationOrganizationID(clusterLinkLocationOrganizationID string) {
	o.ClusterLinkLocationOrganizationID = clusterLinkLocationOrganizationID
}

// WithClusterLinkLocationProjectID adds the clusterLinkLocationProjectID to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithClusterLinkLocationProjectID(clusterLinkLocationProjectID string) *DeregisterLinkedClusterParams {
	o.SetClusterLinkLocationProjectID(clusterLinkLocationProjectID)
	return o
}

// SetClusterLinkLocationProjectID adds the clusterLinkLocationProjectId to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetClusterLinkLocationProjectID(clusterLinkLocationProjectID string) {
	o.ClusterLinkLocationProjectID = clusterLinkLocationProjectID
}

// WithClusterLinkLocationRegionProvider adds the clusterLinkLocationRegionProvider to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithClusterLinkLocationRegionProvider(clusterLinkLocationRegionProvider *string) *DeregisterLinkedClusterParams {
	o.SetClusterLinkLocationRegionProvider(clusterLinkLocationRegionProvider)
	return o
}

// SetClusterLinkLocationRegionProvider adds the clusterLinkLocationRegionProvider to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetClusterLinkLocationRegionProvider(clusterLinkLocationRegionProvider *string) {
	o.ClusterLinkLocationRegionProvider = clusterLinkLocationRegionProvider
}

// WithClusterLinkLocationRegionRegion adds the clusterLinkLocationRegionRegion to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithClusterLinkLocationRegionRegion(clusterLinkLocationRegionRegion *string) *DeregisterLinkedClusterParams {
	o.SetClusterLinkLocationRegionRegion(clusterLinkLocationRegionRegion)
	return o
}

// SetClusterLinkLocationRegionRegion adds the clusterLinkLocationRegionRegion to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetClusterLinkLocationRegionRegion(clusterLinkLocationRegionRegion *string) {
	o.ClusterLinkLocationRegionRegion = clusterLinkLocationRegionRegion
}

// WithClusterLinkType adds the clusterLinkType to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithClusterLinkType(clusterLinkType *string) *DeregisterLinkedClusterParams {
	o.SetClusterLinkType(clusterLinkType)
	return o
}

// SetClusterLinkType adds the clusterLinkType to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetClusterLinkType(clusterLinkType *string) {
	o.ClusterLinkType = clusterLinkType
}

// WithClusterLinkUUID adds the clusterLinkUUID to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) WithClusterLinkUUID(clusterLinkUUID *string) *DeregisterLinkedClusterParams {
	o.SetClusterLinkUUID(clusterLinkUUID)
	return o
}

// SetClusterLinkUUID adds the clusterLinkUuid to the deregister linked cluster params
func (o *DeregisterLinkedClusterParams) SetClusterLinkUUID(clusterLinkUUID *string) {
	o.ClusterLinkUUID = clusterLinkUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DeregisterLinkedClusterParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterLinkDescription != nil {

		// query param cluster_link.description
		var qrClusterLinkDescription string

		if o.ClusterLinkDescription != nil {
			qrClusterLinkDescription = *o.ClusterLinkDescription
		}
		qClusterLinkDescription := qrClusterLinkDescription
		if qClusterLinkDescription != "" {

			if err := r.SetQueryParam("cluster_link.description", qClusterLinkDescription); err != nil {
				return err
			}
		}
	}

	if o.ClusterLinkID != nil {

		// query param cluster_link.id
		var qrClusterLinkID string

		if o.ClusterLinkID != nil {
			qrClusterLinkID = *o.ClusterLinkID
		}
		qClusterLinkID := qrClusterLinkID
		if qClusterLinkID != "" {

			if err := r.SetQueryParam("cluster_link.id", qClusterLinkID); err != nil {
				return err
			}
		}
	}

	// path param cluster_link.location.organization_id
	if err := r.SetPathParam("cluster_link.location.organization_id", o.ClusterLinkLocationOrganizationID); err != nil {
		return err
	}

	// path param cluster_link.location.project_id
	if err := r.SetPathParam("cluster_link.location.project_id", o.ClusterLinkLocationProjectID); err != nil {
		return err
	}

	if o.ClusterLinkLocationRegionProvider != nil {

		// query param cluster_link.location.region.provider
		var qrClusterLinkLocationRegionProvider string

		if o.ClusterLinkLocationRegionProvider != nil {
			qrClusterLinkLocationRegionProvider = *o.ClusterLinkLocationRegionProvider
		}
		qClusterLinkLocationRegionProvider := qrClusterLinkLocationRegionProvider
		if qClusterLinkLocationRegionProvider != "" {

			if err := r.SetQueryParam("cluster_link.location.region.provider", qClusterLinkLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.ClusterLinkLocationRegionRegion != nil {

		// query param cluster_link.location.region.region
		var qrClusterLinkLocationRegionRegion string

		if o.ClusterLinkLocationRegionRegion != nil {
			qrClusterLinkLocationRegionRegion = *o.ClusterLinkLocationRegionRegion
		}
		qClusterLinkLocationRegionRegion := qrClusterLinkLocationRegionRegion
		if qClusterLinkLocationRegionRegion != "" {

			if err := r.SetQueryParam("cluster_link.location.region.region", qClusterLinkLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.ClusterLinkType != nil {

		// query param cluster_link.type
		var qrClusterLinkType string

		if o.ClusterLinkType != nil {
			qrClusterLinkType = *o.ClusterLinkType
		}
		qClusterLinkType := qrClusterLinkType
		if qClusterLinkType != "" {

			if err := r.SetQueryParam("cluster_link.type", qClusterLinkType); err != nil {
				return err
			}
		}
	}

	if o.ClusterLinkUUID != nil {

		// query param cluster_link.uuid
		var qrClusterLinkUUID string

		if o.ClusterLinkUUID != nil {
			qrClusterLinkUUID = *o.ClusterLinkUUID
		}
		qClusterLinkUUID := qrClusterLinkUUID
		if qClusterLinkUUID != "" {

			if err := r.SetQueryParam("cluster_link.uuid", qClusterLinkUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
