// DO NOT EDIT: This file is autogenerated via the builtin command.

package regexp

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	"regexp"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 105,
					Line:   50,
				},
				File:   "replaceAllString_test.flux",
				Source: "package regexp_test\n\nimport \"testing\"\nimport \"regexp\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,long,string\n#group,false,false,true,true,true,true,true,false,false,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,host,_time,_value,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:26Z,15204688,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:36Z,15204894,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:46Z,15205102,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:56Z,15205226,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:54:06Z,15205499,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:54:16Z,15205755,disk9\n\"\n\nre = regexp.compile(v: \".*0\")\n\nt_filter_by_regex = (table=<-) =>\ntable\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => r[\"name\"] =~ /.*0/)\n  |> map(fn: (r) =>\n                ({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")}))\n\ntest _filter_by_regex = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "replaceAllString_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "replaceAllString_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "replaceAllString_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "replaceAllString_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "replaceAllString_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "replaceAllString_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   25,
					},
					File:   "replaceAllString_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "replaceAllString_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   25,
						},
						File:   "replaceAllString_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   38,
					},
					File:   "replaceAllString_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,long,string\n#group,false,false,true,true,true,true,true,false,false,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,host,_time,_value,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:26Z,15204688,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:36Z,15204894,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:46Z,15205102,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:56Z,15205226,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:54:06Z,15205499,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:54:16Z,15205755,disk9\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   27,
						},
						File:   "replaceAllString_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   38,
						},
						File:   "replaceAllString_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,long,string\n#group,false,false,true,true,true,true,true,false,false,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,host,_time,_value,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:26Z,15204688,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:36Z,15204894,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:46Z,15205102,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:56Z,15205226,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:54:06Z,15205499,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:54:16Z,15205755,disk9\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   27,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,long,string\n#group,false,false,true,true,true,true,true,false,false,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,host,_time,_value,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:26Z,15204688,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:36Z,15204894,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:46Z,15205102,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:53:56Z,15205226,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:54:06Z,15205499,disk9\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,diskio,io_time,host.local,2018-05-22T19:54:16Z,15205755,disk9\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   40,
					},
					File:   "replaceAllString_test.flux",
					Source: "re = regexp.compile(v: \".*0\")",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   40,
						},
						File:   "replaceAllString_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   40,
							},
							File:   "replaceAllString_test.flux",
							Source: "v: \".*0\"",
							Start: ast.Position{
								Column: 21,
								Line:   40,
							},
						},
					},
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   40,
								},
								File:   "replaceAllString_test.flux",
								Source: "v: \".*0\"",
								Start: ast.Position{
									Column: 21,
									Line:   40,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   40,
									},
									File:   "replaceAllString_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   40,
									},
								},
							},
							Name: "v",
						},
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   40,
									},
									File:   "replaceAllString_test.flux",
									Source: "\".*0\"",
									Start: ast.Position{
										Column: 24,
										Line:   40,
									},
								},
							},
							Value: ".*0",
						},
					}},
					With: nil,
				}},
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   40,
						},
						File:   "replaceAllString_test.flux",
						Source: "regexp.compile(v: \".*0\")",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   40,
							},
							File:   "replaceAllString_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   40,
								},
								File:   "replaceAllString_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   40,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   40,
								},
								File:   "replaceAllString_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   40,
								},
							},
						},
						Name: "compile",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 88,
						Line:   47,
					},
					File:   "replaceAllString_test.flux",
					Source: "t_filter_by_regex = (table=<-) =>\ntable\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => r[\"name\"] =~ /.*0/)\n  |> map(fn: (r) =>\n                ({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")}))",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   42,
						},
						File:   "replaceAllString_test.flux",
						Source: "t_filter_by_regex",
						Start: ast.Position{
							Column: 1,
							Line:   42,
						},
					},
				},
				Name: "t_filter_by_regex",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 88,
							Line:   47,
						},
						File:   "replaceAllString_test.flux",
						Source: "(table=<-) =>\ntable\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => r[\"name\"] =~ /.*0/)\n  |> map(fn: (r) =>\n                ({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")}))",
						Start: ast.Position{
							Column: 21,
							Line:   42,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   43,
										},
										File:   "replaceAllString_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 1,
											Line:   43,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   44,
									},
									File:   "replaceAllString_test.flux",
									Source: "table\n  |> range(start: 2018-05-20T19:53:26Z)",
									Start: ast.Position{
										Column: 1,
										Line:   43,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   44,
											},
											File:   "replaceAllString_test.flux",
											Source: "start: 2018-05-20T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   44,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   44,
												},
												File:   "replaceAllString_test.flux",
												Source: "start: 2018-05-20T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   44,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   44,
													},
													File:   "replaceAllString_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   44,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   44,
													},
													File:   "replaceAllString_test.flux",
													Source: "2018-05-20T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   44,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-20T19:53:26Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   44,
										},
										File:   "replaceAllString_test.flux",
										Source: "range(start: 2018-05-20T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   44,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   44,
											},
											File:   "replaceAllString_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   44,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   45,
								},
								File:   "replaceAllString_test.flux",
								Source: "table\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => r[\"name\"] =~ /.*0/)",
								Start: ast.Position{
									Column: 1,
									Line:   43,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   45,
										},
										File:   "replaceAllString_test.flux",
										Source: "fn: (r) => r[\"name\"] =~ /.*0/",
										Start: ast.Position{
											Column: 13,
											Line:   45,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   45,
											},
											File:   "replaceAllString_test.flux",
											Source: "fn: (r) => r[\"name\"] =~ /.*0/",
											Start: ast.Position{
												Column: 13,
												Line:   45,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   45,
												},
												File:   "replaceAllString_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 13,
													Line:   45,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   45,
												},
												File:   "replaceAllString_test.flux",
												Source: "(r) => r[\"name\"] =~ /.*0/",
												Start: ast.Position{
													Column: 17,
													Line:   45,
												},
											},
										},
										Body: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   45,
													},
													File:   "replaceAllString_test.flux",
													Source: "r[\"name\"] =~ /.*0/",
													Start: ast.Position{
														Column: 24,
														Line:   45,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   45,
														},
														File:   "replaceAllString_test.flux",
														Source: "r[\"name\"]",
														Start: ast.Position{
															Column: 24,
															Line:   45,
														},
													},
												},
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   45,
															},
															File:   "replaceAllString_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   45,
															},
														},
													},
													Name: "r",
												},
												Property: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   45,
															},
															File:   "replaceAllString_test.flux",
															Source: "\"name\"",
															Start: ast.Position{
																Column: 26,
																Line:   45,
															},
														},
													},
													Value: "name",
												},
											},
											Operator: 19,
											Right: &ast.RegexpLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   45,
														},
														File:   "replaceAllString_test.flux",
														Source: "/.*0/",
														Start: ast.Position{
															Column: 37,
															Line:   45,
														},
													},
												},
												Value: regexp.MustCompile(".*0"),
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   45,
													},
													File:   "replaceAllString_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 18,
														Line:   45,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   45,
														},
														File:   "replaceAllString_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 18,
															Line:   45,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   45,
									},
									File:   "replaceAllString_test.flux",
									Source: "filter(fn: (r) => r[\"name\"] =~ /.*0/)",
									Start: ast.Position{
										Column: 6,
										Line:   45,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   45,
										},
										File:   "replaceAllString_test.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 6,
											Line:   45,
										},
									},
								},
								Name: "filter",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   47,
							},
							File:   "replaceAllString_test.flux",
							Source: "table\n  |> range(start: 2018-05-20T19:53:26Z)\n  |> filter(fn: (r) => r[\"name\"] =~ /.*0/)\n  |> map(fn: (r) =>\n                ({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")}))",
							Start: ast.Position{
								Column: 1,
								Line:   43,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 87,
										Line:   47,
									},
									File:   "replaceAllString_test.flux",
									Source: "fn: (r) =>\n                ({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")})",
									Start: ast.Position{
										Column: 10,
										Line:   46,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 87,
											Line:   47,
										},
										File:   "replaceAllString_test.flux",
										Source: "fn: (r) =>\n                ({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")})",
										Start: ast.Position{
											Column: 10,
											Line:   46,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   46,
											},
											File:   "replaceAllString_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 10,
												Line:   46,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   47,
											},
											File:   "replaceAllString_test.flux",
											Source: "(r) =>\n                ({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")})",
											Start: ast.Position{
												Column: 14,
												Line:   46,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   47,
												},
												File:   "replaceAllString_test.flux",
												Source: "({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")})",
												Start: ast.Position{
													Column: 17,
													Line:   47,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   47,
													},
													File:   "replaceAllString_test.flux",
													Source: "{r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")}",
													Start: ast.Position{
														Column: 18,
														Line:   47,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   47,
														},
														File:   "replaceAllString_test.flux",
														Source: "name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")",
														Start: ast.Position{
															Column: 26,
															Line:   47,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   47,
															},
															File:   "replaceAllString_test.flux",
															Source: "name",
															Start: ast.Position{
																Column: 26,
																Line:   47,
															},
														},
													},
													Name: "name",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   47,
																},
																File:   "replaceAllString_test.flux",
																Source: "r: re, v: r.name, t: \"disk9\"",
																Start: ast.Position{
																	Column: 56,
																	Line:   47,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   47,
																	},
																	File:   "replaceAllString_test.flux",
																	Source: "r: re",
																	Start: ast.Position{
																		Column: 56,
																		Line:   47,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   47,
																		},
																		File:   "replaceAllString_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 56,
																			Line:   47,
																		},
																	},
																},
																Name: "r",
															},
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   47,
																		},
																		File:   "replaceAllString_test.flux",
																		Source: "re",
																		Start: ast.Position{
																			Column: 59,
																			Line:   47,
																		},
																	},
																},
																Name: "re",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   47,
																	},
																	File:   "replaceAllString_test.flux",
																	Source: "v: r.name",
																	Start: ast.Position{
																		Column: 63,
																		Line:   47,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   47,
																		},
																		File:   "replaceAllString_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 63,
																			Line:   47,
																		},
																	},
																},
																Name: "v",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   47,
																		},
																		File:   "replaceAllString_test.flux",
																		Source: "r.name",
																		Start: ast.Position{
																			Column: 66,
																			Line:   47,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   47,
																			},
																			File:   "replaceAllString_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 66,
																				Line:   47,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 72,
																				Line:   47,
																			},
																			File:   "replaceAllString_test.flux",
																			Source: "name",
																			Start: ast.Position{
																				Column: 68,
																				Line:   47,
																			},
																		},
																	},
																	Name: "name",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 84,
																		Line:   47,
																	},
																	File:   "replaceAllString_test.flux",
																	Source: "t: \"disk9\"",
																	Start: ast.Position{
																		Column: 74,
																		Line:   47,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   47,
																		},
																		File:   "replaceAllString_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 74,
																			Line:   47,
																		},
																	},
																},
																Name: "t",
															},
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 84,
																			Line:   47,
																		},
																		File:   "replaceAllString_test.flux",
																		Source: "\"disk9\"",
																		Start: ast.Position{
																			Column: 77,
																			Line:   47,
																		},
																	},
																},
																Value: "disk9",
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   47,
															},
															File:   "replaceAllString_test.flux",
															Source: "regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")",
															Start: ast.Position{
																Column: 32,
																Line:   47,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   47,
																},
																File:   "replaceAllString_test.flux",
																Source: "regexp.replaceAllString",
																Start: ast.Position{
																	Column: 32,
																	Line:   47,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   47,
																	},
																	File:   "replaceAllString_test.flux",
																	Source: "regexp",
																	Start: ast.Position{
																		Column: 32,
																		Line:   47,
																	},
																},
															},
															Name: "regexp",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   47,
																	},
																	File:   "replaceAllString_test.flux",
																	Source: "replaceAllString",
																	Start: ast.Position{
																		Column: 39,
																		Line:   47,
																	},
																},
															},
															Name: "replaceAllString",
														},
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   47,
														},
														File:   "replaceAllString_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   47,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   46,
												},
												File:   "replaceAllString_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 15,
													Line:   46,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   46,
													},
													File:   "replaceAllString_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   46,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   47,
								},
								File:   "replaceAllString_test.flux",
								Source: "map(fn: (r) =>\n                ({r with name: regexp.replaceAllString(r: re, v: r.name, t: \"disk9\")}))",
								Start: ast.Position{
									Column: 6,
									Line:   46,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   46,
									},
									File:   "replaceAllString_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 6,
										Line:   46,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   42,
							},
							File:   "replaceAllString_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   42,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   42,
								},
								File:   "replaceAllString_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   42,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   42,
							},
							File:   "replaceAllString_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   42,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 105,
							Line:   50,
						},
						File:   "replaceAllString_test.flux",
						Source: "_filter_by_regex = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
						Start: ast.Position{
							Column: 6,
							Line:   49,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   49,
							},
							File:   "replaceAllString_test.flux",
							Source: "_filter_by_regex",
							Start: ast.Position{
								Column: 6,
								Line:   49,
							},
						},
					},
					Name: "_filter_by_regex",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   50,
							},
							File:   "replaceAllString_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
							Start: ast.Position{
								Column: 25,
								Line:   49,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   50,
								},
								File:   "replaceAllString_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
								Start: ast.Position{
									Column: 2,
									Line:   50,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 104,
										Line:   50,
									},
									File:   "replaceAllString_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex}",
									Start: ast.Position{
										Column: 3,
										Line:   50,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   50,
										},
										File:   "replaceAllString_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   50,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   50,
											},
											File:   "replaceAllString_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   50,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   50,
												},
												File:   "replaceAllString_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   50,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   50,
													},
													File:   "replaceAllString_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   50,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   50,
														},
														File:   "replaceAllString_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   50,
														},
														File:   "replaceAllString_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   50,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   50,
											},
											File:   "replaceAllString_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   50,
												},
												File:   "replaceAllString_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   50,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   50,
													},
													File:   "replaceAllString_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   50,
													},
													File:   "replaceAllString_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   50,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   50,
										},
										File:   "replaceAllString_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   50,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   50,
											},
											File:   "replaceAllString_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   50,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   50,
												},
												File:   "replaceAllString_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   50,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   50,
													},
													File:   "replaceAllString_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   50,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   50,
														},
														File:   "replaceAllString_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   50,
														},
														File:   "replaceAllString_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   50,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   50,
											},
											File:   "replaceAllString_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   50,
												},
												File:   "replaceAllString_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   50,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   50,
													},
													File:   "replaceAllString_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   50,
													},
													File:   "replaceAllString_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   50,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   50,
										},
										File:   "replaceAllString_test.flux",
										Source: "fn: t_filter_by_regex",
										Start: ast.Position{
											Column: 82,
											Line:   50,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   50,
											},
											File:   "replaceAllString_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   50,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   50,
											},
											File:   "replaceAllString_test.flux",
											Source: "t_filter_by_regex",
											Start: ast.Position{
												Column: 86,
												Line:   50,
											},
										},
									},
									Name: "t_filter_by_regex",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 105,
						Line:   50,
					},
					File:   "replaceAllString_test.flux",
					Source: "test _filter_by_regex = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "replaceAllString_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "replaceAllString_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   4,
					},
					File:   "replaceAllString_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   4,
						},
						File:   "replaceAllString_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "replaceAllString_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "replaceAllString_test.flux",
					Source: "package regexp_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "replaceAllString_test.flux",
						Source: "regexp_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "regexp_test",
			},
		},
	}},
	Package: "regexp_test",
	Path:    "regexp",
}}
