// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"sync"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/google/uuid"
	"github.com/mrusme/journalist/ent/feed"
	"github.com/mrusme/journalist/ent/item"
	"github.com/mrusme/journalist/ent/predicate"
	"github.com/mrusme/journalist/ent/read"
	"github.com/mrusme/journalist/ent/subscription"
	"github.com/mrusme/journalist/ent/token"
	"github.com/mrusme/journalist/ent/user"
)

const (
	// Operation types.
	OpCreate    = ent.OpCreate
	OpDelete    = ent.OpDelete
	OpDeleteOne = ent.OpDeleteOne
	OpUpdate    = ent.OpUpdate
	OpUpdateOne = ent.OpUpdateOne

	// Node types.
	TypeFeed         = "Feed"
	TypeItem         = "Item"
	TypeRead         = "Read"
	TypeSubscription = "Subscription"
	TypeToken        = "Token"
	TypeUser         = "User"
)

// FeedMutation represents an operation that mutates the Feed nodes in the graph.
type FeedMutation struct {
	config
	op                      Op
	typ                     string
	id                      *uuid.UUID
	url                     *string
	username                *string
	password                *string
	feed_title              *string
	feed_description        *string
	feed_link               *string
	feed_feed_link          *string
	feed_updated            *time.Time
	feed_published          *time.Time
	feed_author_name        *string
	feed_author_email       *string
	feed_language           *string
	feed_image_title        *string
	feed_image_url          *string
	feed_copyright          *string
	feed_generator          *string
	feed_categories         *string
	created_at              *time.Time
	updated_at              *time.Time
	deleted_at              *time.Time
	clearedFields           map[string]struct{}
	items                   map[uuid.UUID]struct{}
	removeditems            map[uuid.UUID]struct{}
	cleareditems            bool
	subscribed_users        map[uuid.UUID]struct{}
	removedsubscribed_users map[uuid.UUID]struct{}
	clearedsubscribed_users bool
	subscriptions           map[uuid.UUID]struct{}
	removedsubscriptions    map[uuid.UUID]struct{}
	clearedsubscriptions    bool
	done                    bool
	oldValue                func(context.Context) (*Feed, error)
	predicates              []predicate.Feed
}

var _ ent.Mutation = (*FeedMutation)(nil)

// feedOption allows management of the mutation configuration using functional options.
type feedOption func(*FeedMutation)

// newFeedMutation creates new mutation for the Feed entity.
func newFeedMutation(c config, op Op, opts ...feedOption) *FeedMutation {
	m := &FeedMutation{
		config:        c,
		op:            op,
		typ:           TypeFeed,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withFeedID sets the ID field of the mutation.
func withFeedID(id uuid.UUID) feedOption {
	return func(m *FeedMutation) {
		var (
			err   error
			once  sync.Once
			value *Feed
		)
		m.oldValue = func(ctx context.Context) (*Feed, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Feed.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withFeed sets the old Feed of the mutation.
func withFeed(node *Feed) feedOption {
	return func(m *FeedMutation) {
		m.oldValue = func(context.Context) (*Feed, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m FeedMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m FeedMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Feed entities.
func (m *FeedMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *FeedMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *FeedMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Feed.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetURL sets the "url" field.
func (m *FeedMutation) SetURL(s string) {
	m.url = &s
}

// URL returns the value of the "url" field in the mutation.
func (m *FeedMutation) URL() (r string, exists bool) {
	v := m.url
	if v == nil {
		return
	}
	return *v, true
}

// OldURL returns the old "url" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldURL: %w", err)
	}
	return oldValue.URL, nil
}

// ResetURL resets all changes to the "url" field.
func (m *FeedMutation) ResetURL() {
	m.url = nil
}

// SetUsername sets the "username" field.
func (m *FeedMutation) SetUsername(s string) {
	m.username = &s
}

// Username returns the value of the "username" field in the mutation.
func (m *FeedMutation) Username() (r string, exists bool) {
	v := m.username
	if v == nil {
		return
	}
	return *v, true
}

// OldUsername returns the old "username" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUsername: %w", err)
	}
	return oldValue.Username, nil
}

// ResetUsername resets all changes to the "username" field.
func (m *FeedMutation) ResetUsername() {
	m.username = nil
}

// SetPassword sets the "password" field.
func (m *FeedMutation) SetPassword(s string) {
	m.password = &s
}

// Password returns the value of the "password" field in the mutation.
func (m *FeedMutation) Password() (r string, exists bool) {
	v := m.password
	if v == nil {
		return
	}
	return *v, true
}

// OldPassword returns the old "password" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldPassword(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPassword is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPassword requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPassword: %w", err)
	}
	return oldValue.Password, nil
}

// ResetPassword resets all changes to the "password" field.
func (m *FeedMutation) ResetPassword() {
	m.password = nil
}

// SetFeedTitle sets the "feed_title" field.
func (m *FeedMutation) SetFeedTitle(s string) {
	m.feed_title = &s
}

// FeedTitle returns the value of the "feed_title" field in the mutation.
func (m *FeedMutation) FeedTitle() (r string, exists bool) {
	v := m.feed_title
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedTitle returns the old "feed_title" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedTitle(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedTitle is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedTitle requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedTitle: %w", err)
	}
	return oldValue.FeedTitle, nil
}

// ResetFeedTitle resets all changes to the "feed_title" field.
func (m *FeedMutation) ResetFeedTitle() {
	m.feed_title = nil
}

// SetFeedDescription sets the "feed_description" field.
func (m *FeedMutation) SetFeedDescription(s string) {
	m.feed_description = &s
}

// FeedDescription returns the value of the "feed_description" field in the mutation.
func (m *FeedMutation) FeedDescription() (r string, exists bool) {
	v := m.feed_description
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedDescription returns the old "feed_description" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedDescription: %w", err)
	}
	return oldValue.FeedDescription, nil
}

// ResetFeedDescription resets all changes to the "feed_description" field.
func (m *FeedMutation) ResetFeedDescription() {
	m.feed_description = nil
}

// SetFeedLink sets the "feed_link" field.
func (m *FeedMutation) SetFeedLink(s string) {
	m.feed_link = &s
}

// FeedLink returns the value of the "feed_link" field in the mutation.
func (m *FeedMutation) FeedLink() (r string, exists bool) {
	v := m.feed_link
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedLink returns the old "feed_link" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedLink(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedLink is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedLink requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedLink: %w", err)
	}
	return oldValue.FeedLink, nil
}

// ResetFeedLink resets all changes to the "feed_link" field.
func (m *FeedMutation) ResetFeedLink() {
	m.feed_link = nil
}

// SetFeedFeedLink sets the "feed_feed_link" field.
func (m *FeedMutation) SetFeedFeedLink(s string) {
	m.feed_feed_link = &s
}

// FeedFeedLink returns the value of the "feed_feed_link" field in the mutation.
func (m *FeedMutation) FeedFeedLink() (r string, exists bool) {
	v := m.feed_feed_link
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedFeedLink returns the old "feed_feed_link" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedFeedLink(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedFeedLink is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedFeedLink requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedFeedLink: %w", err)
	}
	return oldValue.FeedFeedLink, nil
}

// ResetFeedFeedLink resets all changes to the "feed_feed_link" field.
func (m *FeedMutation) ResetFeedFeedLink() {
	m.feed_feed_link = nil
}

// SetFeedUpdated sets the "feed_updated" field.
func (m *FeedMutation) SetFeedUpdated(t time.Time) {
	m.feed_updated = &t
}

// FeedUpdated returns the value of the "feed_updated" field in the mutation.
func (m *FeedMutation) FeedUpdated() (r time.Time, exists bool) {
	v := m.feed_updated
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedUpdated returns the old "feed_updated" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedUpdated(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedUpdated is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedUpdated requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedUpdated: %w", err)
	}
	return oldValue.FeedUpdated, nil
}

// ResetFeedUpdated resets all changes to the "feed_updated" field.
func (m *FeedMutation) ResetFeedUpdated() {
	m.feed_updated = nil
}

// SetFeedPublished sets the "feed_published" field.
func (m *FeedMutation) SetFeedPublished(t time.Time) {
	m.feed_published = &t
}

// FeedPublished returns the value of the "feed_published" field in the mutation.
func (m *FeedMutation) FeedPublished() (r time.Time, exists bool) {
	v := m.feed_published
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedPublished returns the old "feed_published" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedPublished(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedPublished is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedPublished requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedPublished: %w", err)
	}
	return oldValue.FeedPublished, nil
}

// ResetFeedPublished resets all changes to the "feed_published" field.
func (m *FeedMutation) ResetFeedPublished() {
	m.feed_published = nil
}

// SetFeedAuthorName sets the "feed_author_name" field.
func (m *FeedMutation) SetFeedAuthorName(s string) {
	m.feed_author_name = &s
}

// FeedAuthorName returns the value of the "feed_author_name" field in the mutation.
func (m *FeedMutation) FeedAuthorName() (r string, exists bool) {
	v := m.feed_author_name
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedAuthorName returns the old "feed_author_name" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedAuthorName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedAuthorName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedAuthorName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedAuthorName: %w", err)
	}
	return oldValue.FeedAuthorName, nil
}

// ClearFeedAuthorName clears the value of the "feed_author_name" field.
func (m *FeedMutation) ClearFeedAuthorName() {
	m.feed_author_name = nil
	m.clearedFields[feed.FieldFeedAuthorName] = struct{}{}
}

// FeedAuthorNameCleared returns if the "feed_author_name" field was cleared in this mutation.
func (m *FeedMutation) FeedAuthorNameCleared() bool {
	_, ok := m.clearedFields[feed.FieldFeedAuthorName]
	return ok
}

// ResetFeedAuthorName resets all changes to the "feed_author_name" field.
func (m *FeedMutation) ResetFeedAuthorName() {
	m.feed_author_name = nil
	delete(m.clearedFields, feed.FieldFeedAuthorName)
}

// SetFeedAuthorEmail sets the "feed_author_email" field.
func (m *FeedMutation) SetFeedAuthorEmail(s string) {
	m.feed_author_email = &s
}

// FeedAuthorEmail returns the value of the "feed_author_email" field in the mutation.
func (m *FeedMutation) FeedAuthorEmail() (r string, exists bool) {
	v := m.feed_author_email
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedAuthorEmail returns the old "feed_author_email" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedAuthorEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedAuthorEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedAuthorEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedAuthorEmail: %w", err)
	}
	return oldValue.FeedAuthorEmail, nil
}

// ClearFeedAuthorEmail clears the value of the "feed_author_email" field.
func (m *FeedMutation) ClearFeedAuthorEmail() {
	m.feed_author_email = nil
	m.clearedFields[feed.FieldFeedAuthorEmail] = struct{}{}
}

// FeedAuthorEmailCleared returns if the "feed_author_email" field was cleared in this mutation.
func (m *FeedMutation) FeedAuthorEmailCleared() bool {
	_, ok := m.clearedFields[feed.FieldFeedAuthorEmail]
	return ok
}

// ResetFeedAuthorEmail resets all changes to the "feed_author_email" field.
func (m *FeedMutation) ResetFeedAuthorEmail() {
	m.feed_author_email = nil
	delete(m.clearedFields, feed.FieldFeedAuthorEmail)
}

// SetFeedLanguage sets the "feed_language" field.
func (m *FeedMutation) SetFeedLanguage(s string) {
	m.feed_language = &s
}

// FeedLanguage returns the value of the "feed_language" field in the mutation.
func (m *FeedMutation) FeedLanguage() (r string, exists bool) {
	v := m.feed_language
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedLanguage returns the old "feed_language" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedLanguage(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedLanguage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedLanguage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedLanguage: %w", err)
	}
	return oldValue.FeedLanguage, nil
}

// ResetFeedLanguage resets all changes to the "feed_language" field.
func (m *FeedMutation) ResetFeedLanguage() {
	m.feed_language = nil
}

// SetFeedImageTitle sets the "feed_image_title" field.
func (m *FeedMutation) SetFeedImageTitle(s string) {
	m.feed_image_title = &s
}

// FeedImageTitle returns the value of the "feed_image_title" field in the mutation.
func (m *FeedMutation) FeedImageTitle() (r string, exists bool) {
	v := m.feed_image_title
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedImageTitle returns the old "feed_image_title" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedImageTitle(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedImageTitle is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedImageTitle requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedImageTitle: %w", err)
	}
	return oldValue.FeedImageTitle, nil
}

// ClearFeedImageTitle clears the value of the "feed_image_title" field.
func (m *FeedMutation) ClearFeedImageTitle() {
	m.feed_image_title = nil
	m.clearedFields[feed.FieldFeedImageTitle] = struct{}{}
}

// FeedImageTitleCleared returns if the "feed_image_title" field was cleared in this mutation.
func (m *FeedMutation) FeedImageTitleCleared() bool {
	_, ok := m.clearedFields[feed.FieldFeedImageTitle]
	return ok
}

// ResetFeedImageTitle resets all changes to the "feed_image_title" field.
func (m *FeedMutation) ResetFeedImageTitle() {
	m.feed_image_title = nil
	delete(m.clearedFields, feed.FieldFeedImageTitle)
}

// SetFeedImageURL sets the "feed_image_url" field.
func (m *FeedMutation) SetFeedImageURL(s string) {
	m.feed_image_url = &s
}

// FeedImageURL returns the value of the "feed_image_url" field in the mutation.
func (m *FeedMutation) FeedImageURL() (r string, exists bool) {
	v := m.feed_image_url
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedImageURL returns the old "feed_image_url" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedImageURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedImageURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedImageURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedImageURL: %w", err)
	}
	return oldValue.FeedImageURL, nil
}

// ClearFeedImageURL clears the value of the "feed_image_url" field.
func (m *FeedMutation) ClearFeedImageURL() {
	m.feed_image_url = nil
	m.clearedFields[feed.FieldFeedImageURL] = struct{}{}
}

// FeedImageURLCleared returns if the "feed_image_url" field was cleared in this mutation.
func (m *FeedMutation) FeedImageURLCleared() bool {
	_, ok := m.clearedFields[feed.FieldFeedImageURL]
	return ok
}

// ResetFeedImageURL resets all changes to the "feed_image_url" field.
func (m *FeedMutation) ResetFeedImageURL() {
	m.feed_image_url = nil
	delete(m.clearedFields, feed.FieldFeedImageURL)
}

// SetFeedCopyright sets the "feed_copyright" field.
func (m *FeedMutation) SetFeedCopyright(s string) {
	m.feed_copyright = &s
}

// FeedCopyright returns the value of the "feed_copyright" field in the mutation.
func (m *FeedMutation) FeedCopyright() (r string, exists bool) {
	v := m.feed_copyright
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedCopyright returns the old "feed_copyright" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedCopyright(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedCopyright is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedCopyright requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedCopyright: %w", err)
	}
	return oldValue.FeedCopyright, nil
}

// ResetFeedCopyright resets all changes to the "feed_copyright" field.
func (m *FeedMutation) ResetFeedCopyright() {
	m.feed_copyright = nil
}

// SetFeedGenerator sets the "feed_generator" field.
func (m *FeedMutation) SetFeedGenerator(s string) {
	m.feed_generator = &s
}

// FeedGenerator returns the value of the "feed_generator" field in the mutation.
func (m *FeedMutation) FeedGenerator() (r string, exists bool) {
	v := m.feed_generator
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedGenerator returns the old "feed_generator" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedGenerator(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedGenerator is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedGenerator requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedGenerator: %w", err)
	}
	return oldValue.FeedGenerator, nil
}

// ResetFeedGenerator resets all changes to the "feed_generator" field.
func (m *FeedMutation) ResetFeedGenerator() {
	m.feed_generator = nil
}

// SetFeedCategories sets the "feed_categories" field.
func (m *FeedMutation) SetFeedCategories(s string) {
	m.feed_categories = &s
}

// FeedCategories returns the value of the "feed_categories" field in the mutation.
func (m *FeedMutation) FeedCategories() (r string, exists bool) {
	v := m.feed_categories
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedCategories returns the old "feed_categories" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldFeedCategories(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedCategories is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedCategories requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedCategories: %w", err)
	}
	return oldValue.FeedCategories, nil
}

// ResetFeedCategories resets all changes to the "feed_categories" field.
func (m *FeedMutation) ResetFeedCategories() {
	m.feed_categories = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *FeedMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *FeedMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *FeedMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *FeedMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *FeedMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *FeedMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetDeletedAt sets the "deleted_at" field.
func (m *FeedMutation) SetDeletedAt(t time.Time) {
	m.deleted_at = &t
}

// DeletedAt returns the value of the "deleted_at" field in the mutation.
func (m *FeedMutation) DeletedAt() (r time.Time, exists bool) {
	v := m.deleted_at
	if v == nil {
		return
	}
	return *v, true
}

// OldDeletedAt returns the old "deleted_at" field's value of the Feed entity.
// If the Feed object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *FeedMutation) OldDeletedAt(ctx context.Context) (v *time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeletedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeletedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeletedAt: %w", err)
	}
	return oldValue.DeletedAt, nil
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (m *FeedMutation) ClearDeletedAt() {
	m.deleted_at = nil
	m.clearedFields[feed.FieldDeletedAt] = struct{}{}
}

// DeletedAtCleared returns if the "deleted_at" field was cleared in this mutation.
func (m *FeedMutation) DeletedAtCleared() bool {
	_, ok := m.clearedFields[feed.FieldDeletedAt]
	return ok
}

// ResetDeletedAt resets all changes to the "deleted_at" field.
func (m *FeedMutation) ResetDeletedAt() {
	m.deleted_at = nil
	delete(m.clearedFields, feed.FieldDeletedAt)
}

// AddItemIDs adds the "items" edge to the Item entity by ids.
func (m *FeedMutation) AddItemIDs(ids ...uuid.UUID) {
	if m.items == nil {
		m.items = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.items[ids[i]] = struct{}{}
	}
}

// ClearItems clears the "items" edge to the Item entity.
func (m *FeedMutation) ClearItems() {
	m.cleareditems = true
}

// ItemsCleared reports if the "items" edge to the Item entity was cleared.
func (m *FeedMutation) ItemsCleared() bool {
	return m.cleareditems
}

// RemoveItemIDs removes the "items" edge to the Item entity by IDs.
func (m *FeedMutation) RemoveItemIDs(ids ...uuid.UUID) {
	if m.removeditems == nil {
		m.removeditems = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.items, ids[i])
		m.removeditems[ids[i]] = struct{}{}
	}
}

// RemovedItems returns the removed IDs of the "items" edge to the Item entity.
func (m *FeedMutation) RemovedItemsIDs() (ids []uuid.UUID) {
	for id := range m.removeditems {
		ids = append(ids, id)
	}
	return
}

// ItemsIDs returns the "items" edge IDs in the mutation.
func (m *FeedMutation) ItemsIDs() (ids []uuid.UUID) {
	for id := range m.items {
		ids = append(ids, id)
	}
	return
}

// ResetItems resets all changes to the "items" edge.
func (m *FeedMutation) ResetItems() {
	m.items = nil
	m.cleareditems = false
	m.removeditems = nil
}

// AddSubscribedUserIDs adds the "subscribed_users" edge to the User entity by ids.
func (m *FeedMutation) AddSubscribedUserIDs(ids ...uuid.UUID) {
	if m.subscribed_users == nil {
		m.subscribed_users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.subscribed_users[ids[i]] = struct{}{}
	}
}

// ClearSubscribedUsers clears the "subscribed_users" edge to the User entity.
func (m *FeedMutation) ClearSubscribedUsers() {
	m.clearedsubscribed_users = true
}

// SubscribedUsersCleared reports if the "subscribed_users" edge to the User entity was cleared.
func (m *FeedMutation) SubscribedUsersCleared() bool {
	return m.clearedsubscribed_users
}

// RemoveSubscribedUserIDs removes the "subscribed_users" edge to the User entity by IDs.
func (m *FeedMutation) RemoveSubscribedUserIDs(ids ...uuid.UUID) {
	if m.removedsubscribed_users == nil {
		m.removedsubscribed_users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.subscribed_users, ids[i])
		m.removedsubscribed_users[ids[i]] = struct{}{}
	}
}

// RemovedSubscribedUsers returns the removed IDs of the "subscribed_users" edge to the User entity.
func (m *FeedMutation) RemovedSubscribedUsersIDs() (ids []uuid.UUID) {
	for id := range m.removedsubscribed_users {
		ids = append(ids, id)
	}
	return
}

// SubscribedUsersIDs returns the "subscribed_users" edge IDs in the mutation.
func (m *FeedMutation) SubscribedUsersIDs() (ids []uuid.UUID) {
	for id := range m.subscribed_users {
		ids = append(ids, id)
	}
	return
}

// ResetSubscribedUsers resets all changes to the "subscribed_users" edge.
func (m *FeedMutation) ResetSubscribedUsers() {
	m.subscribed_users = nil
	m.clearedsubscribed_users = false
	m.removedsubscribed_users = nil
}

// AddSubscriptionIDs adds the "subscriptions" edge to the Subscription entity by ids.
func (m *FeedMutation) AddSubscriptionIDs(ids ...uuid.UUID) {
	if m.subscriptions == nil {
		m.subscriptions = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.subscriptions[ids[i]] = struct{}{}
	}
}

// ClearSubscriptions clears the "subscriptions" edge to the Subscription entity.
func (m *FeedMutation) ClearSubscriptions() {
	m.clearedsubscriptions = true
}

// SubscriptionsCleared reports if the "subscriptions" edge to the Subscription entity was cleared.
func (m *FeedMutation) SubscriptionsCleared() bool {
	return m.clearedsubscriptions
}

// RemoveSubscriptionIDs removes the "subscriptions" edge to the Subscription entity by IDs.
func (m *FeedMutation) RemoveSubscriptionIDs(ids ...uuid.UUID) {
	if m.removedsubscriptions == nil {
		m.removedsubscriptions = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.subscriptions, ids[i])
		m.removedsubscriptions[ids[i]] = struct{}{}
	}
}

// RemovedSubscriptions returns the removed IDs of the "subscriptions" edge to the Subscription entity.
func (m *FeedMutation) RemovedSubscriptionsIDs() (ids []uuid.UUID) {
	for id := range m.removedsubscriptions {
		ids = append(ids, id)
	}
	return
}

// SubscriptionsIDs returns the "subscriptions" edge IDs in the mutation.
func (m *FeedMutation) SubscriptionsIDs() (ids []uuid.UUID) {
	for id := range m.subscriptions {
		ids = append(ids, id)
	}
	return
}

// ResetSubscriptions resets all changes to the "subscriptions" edge.
func (m *FeedMutation) ResetSubscriptions() {
	m.subscriptions = nil
	m.clearedsubscriptions = false
	m.removedsubscriptions = nil
}

// Where appends a list predicates to the FeedMutation builder.
func (m *FeedMutation) Where(ps ...predicate.Feed) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the FeedMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *FeedMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Feed, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *FeedMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *FeedMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Feed).
func (m *FeedMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *FeedMutation) Fields() []string {
	fields := make([]string, 0, 20)
	if m.url != nil {
		fields = append(fields, feed.FieldURL)
	}
	if m.username != nil {
		fields = append(fields, feed.FieldUsername)
	}
	if m.password != nil {
		fields = append(fields, feed.FieldPassword)
	}
	if m.feed_title != nil {
		fields = append(fields, feed.FieldFeedTitle)
	}
	if m.feed_description != nil {
		fields = append(fields, feed.FieldFeedDescription)
	}
	if m.feed_link != nil {
		fields = append(fields, feed.FieldFeedLink)
	}
	if m.feed_feed_link != nil {
		fields = append(fields, feed.FieldFeedFeedLink)
	}
	if m.feed_updated != nil {
		fields = append(fields, feed.FieldFeedUpdated)
	}
	if m.feed_published != nil {
		fields = append(fields, feed.FieldFeedPublished)
	}
	if m.feed_author_name != nil {
		fields = append(fields, feed.FieldFeedAuthorName)
	}
	if m.feed_author_email != nil {
		fields = append(fields, feed.FieldFeedAuthorEmail)
	}
	if m.feed_language != nil {
		fields = append(fields, feed.FieldFeedLanguage)
	}
	if m.feed_image_title != nil {
		fields = append(fields, feed.FieldFeedImageTitle)
	}
	if m.feed_image_url != nil {
		fields = append(fields, feed.FieldFeedImageURL)
	}
	if m.feed_copyright != nil {
		fields = append(fields, feed.FieldFeedCopyright)
	}
	if m.feed_generator != nil {
		fields = append(fields, feed.FieldFeedGenerator)
	}
	if m.feed_categories != nil {
		fields = append(fields, feed.FieldFeedCategories)
	}
	if m.created_at != nil {
		fields = append(fields, feed.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, feed.FieldUpdatedAt)
	}
	if m.deleted_at != nil {
		fields = append(fields, feed.FieldDeletedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *FeedMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case feed.FieldURL:
		return m.URL()
	case feed.FieldUsername:
		return m.Username()
	case feed.FieldPassword:
		return m.Password()
	case feed.FieldFeedTitle:
		return m.FeedTitle()
	case feed.FieldFeedDescription:
		return m.FeedDescription()
	case feed.FieldFeedLink:
		return m.FeedLink()
	case feed.FieldFeedFeedLink:
		return m.FeedFeedLink()
	case feed.FieldFeedUpdated:
		return m.FeedUpdated()
	case feed.FieldFeedPublished:
		return m.FeedPublished()
	case feed.FieldFeedAuthorName:
		return m.FeedAuthorName()
	case feed.FieldFeedAuthorEmail:
		return m.FeedAuthorEmail()
	case feed.FieldFeedLanguage:
		return m.FeedLanguage()
	case feed.FieldFeedImageTitle:
		return m.FeedImageTitle()
	case feed.FieldFeedImageURL:
		return m.FeedImageURL()
	case feed.FieldFeedCopyright:
		return m.FeedCopyright()
	case feed.FieldFeedGenerator:
		return m.FeedGenerator()
	case feed.FieldFeedCategories:
		return m.FeedCategories()
	case feed.FieldCreatedAt:
		return m.CreatedAt()
	case feed.FieldUpdatedAt:
		return m.UpdatedAt()
	case feed.FieldDeletedAt:
		return m.DeletedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *FeedMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case feed.FieldURL:
		return m.OldURL(ctx)
	case feed.FieldUsername:
		return m.OldUsername(ctx)
	case feed.FieldPassword:
		return m.OldPassword(ctx)
	case feed.FieldFeedTitle:
		return m.OldFeedTitle(ctx)
	case feed.FieldFeedDescription:
		return m.OldFeedDescription(ctx)
	case feed.FieldFeedLink:
		return m.OldFeedLink(ctx)
	case feed.FieldFeedFeedLink:
		return m.OldFeedFeedLink(ctx)
	case feed.FieldFeedUpdated:
		return m.OldFeedUpdated(ctx)
	case feed.FieldFeedPublished:
		return m.OldFeedPublished(ctx)
	case feed.FieldFeedAuthorName:
		return m.OldFeedAuthorName(ctx)
	case feed.FieldFeedAuthorEmail:
		return m.OldFeedAuthorEmail(ctx)
	case feed.FieldFeedLanguage:
		return m.OldFeedLanguage(ctx)
	case feed.FieldFeedImageTitle:
		return m.OldFeedImageTitle(ctx)
	case feed.FieldFeedImageURL:
		return m.OldFeedImageURL(ctx)
	case feed.FieldFeedCopyright:
		return m.OldFeedCopyright(ctx)
	case feed.FieldFeedGenerator:
		return m.OldFeedGenerator(ctx)
	case feed.FieldFeedCategories:
		return m.OldFeedCategories(ctx)
	case feed.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case feed.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case feed.FieldDeletedAt:
		return m.OldDeletedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Feed field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *FeedMutation) SetField(name string, value ent.Value) error {
	switch name {
	case feed.FieldURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetURL(v)
		return nil
	case feed.FieldUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUsername(v)
		return nil
	case feed.FieldPassword:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPassword(v)
		return nil
	case feed.FieldFeedTitle:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedTitle(v)
		return nil
	case feed.FieldFeedDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedDescription(v)
		return nil
	case feed.FieldFeedLink:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedLink(v)
		return nil
	case feed.FieldFeedFeedLink:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedFeedLink(v)
		return nil
	case feed.FieldFeedUpdated:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedUpdated(v)
		return nil
	case feed.FieldFeedPublished:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedPublished(v)
		return nil
	case feed.FieldFeedAuthorName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedAuthorName(v)
		return nil
	case feed.FieldFeedAuthorEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedAuthorEmail(v)
		return nil
	case feed.FieldFeedLanguage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedLanguage(v)
		return nil
	case feed.FieldFeedImageTitle:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedImageTitle(v)
		return nil
	case feed.FieldFeedImageURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedImageURL(v)
		return nil
	case feed.FieldFeedCopyright:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedCopyright(v)
		return nil
	case feed.FieldFeedGenerator:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedGenerator(v)
		return nil
	case feed.FieldFeedCategories:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedCategories(v)
		return nil
	case feed.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case feed.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case feed.FieldDeletedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeletedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Feed field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *FeedMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *FeedMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *FeedMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Feed numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *FeedMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(feed.FieldFeedAuthorName) {
		fields = append(fields, feed.FieldFeedAuthorName)
	}
	if m.FieldCleared(feed.FieldFeedAuthorEmail) {
		fields = append(fields, feed.FieldFeedAuthorEmail)
	}
	if m.FieldCleared(feed.FieldFeedImageTitle) {
		fields = append(fields, feed.FieldFeedImageTitle)
	}
	if m.FieldCleared(feed.FieldFeedImageURL) {
		fields = append(fields, feed.FieldFeedImageURL)
	}
	if m.FieldCleared(feed.FieldDeletedAt) {
		fields = append(fields, feed.FieldDeletedAt)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *FeedMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *FeedMutation) ClearField(name string) error {
	switch name {
	case feed.FieldFeedAuthorName:
		m.ClearFeedAuthorName()
		return nil
	case feed.FieldFeedAuthorEmail:
		m.ClearFeedAuthorEmail()
		return nil
	case feed.FieldFeedImageTitle:
		m.ClearFeedImageTitle()
		return nil
	case feed.FieldFeedImageURL:
		m.ClearFeedImageURL()
		return nil
	case feed.FieldDeletedAt:
		m.ClearDeletedAt()
		return nil
	}
	return fmt.Errorf("unknown Feed nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *FeedMutation) ResetField(name string) error {
	switch name {
	case feed.FieldURL:
		m.ResetURL()
		return nil
	case feed.FieldUsername:
		m.ResetUsername()
		return nil
	case feed.FieldPassword:
		m.ResetPassword()
		return nil
	case feed.FieldFeedTitle:
		m.ResetFeedTitle()
		return nil
	case feed.FieldFeedDescription:
		m.ResetFeedDescription()
		return nil
	case feed.FieldFeedLink:
		m.ResetFeedLink()
		return nil
	case feed.FieldFeedFeedLink:
		m.ResetFeedFeedLink()
		return nil
	case feed.FieldFeedUpdated:
		m.ResetFeedUpdated()
		return nil
	case feed.FieldFeedPublished:
		m.ResetFeedPublished()
		return nil
	case feed.FieldFeedAuthorName:
		m.ResetFeedAuthorName()
		return nil
	case feed.FieldFeedAuthorEmail:
		m.ResetFeedAuthorEmail()
		return nil
	case feed.FieldFeedLanguage:
		m.ResetFeedLanguage()
		return nil
	case feed.FieldFeedImageTitle:
		m.ResetFeedImageTitle()
		return nil
	case feed.FieldFeedImageURL:
		m.ResetFeedImageURL()
		return nil
	case feed.FieldFeedCopyright:
		m.ResetFeedCopyright()
		return nil
	case feed.FieldFeedGenerator:
		m.ResetFeedGenerator()
		return nil
	case feed.FieldFeedCategories:
		m.ResetFeedCategories()
		return nil
	case feed.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case feed.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case feed.FieldDeletedAt:
		m.ResetDeletedAt()
		return nil
	}
	return fmt.Errorf("unknown Feed field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *FeedMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.items != nil {
		edges = append(edges, feed.EdgeItems)
	}
	if m.subscribed_users != nil {
		edges = append(edges, feed.EdgeSubscribedUsers)
	}
	if m.subscriptions != nil {
		edges = append(edges, feed.EdgeSubscriptions)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *FeedMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case feed.EdgeItems:
		ids := make([]ent.Value, 0, len(m.items))
		for id := range m.items {
			ids = append(ids, id)
		}
		return ids
	case feed.EdgeSubscribedUsers:
		ids := make([]ent.Value, 0, len(m.subscribed_users))
		for id := range m.subscribed_users {
			ids = append(ids, id)
		}
		return ids
	case feed.EdgeSubscriptions:
		ids := make([]ent.Value, 0, len(m.subscriptions))
		for id := range m.subscriptions {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *FeedMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removeditems != nil {
		edges = append(edges, feed.EdgeItems)
	}
	if m.removedsubscribed_users != nil {
		edges = append(edges, feed.EdgeSubscribedUsers)
	}
	if m.removedsubscriptions != nil {
		edges = append(edges, feed.EdgeSubscriptions)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *FeedMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case feed.EdgeItems:
		ids := make([]ent.Value, 0, len(m.removeditems))
		for id := range m.removeditems {
			ids = append(ids, id)
		}
		return ids
	case feed.EdgeSubscribedUsers:
		ids := make([]ent.Value, 0, len(m.removedsubscribed_users))
		for id := range m.removedsubscribed_users {
			ids = append(ids, id)
		}
		return ids
	case feed.EdgeSubscriptions:
		ids := make([]ent.Value, 0, len(m.removedsubscriptions))
		for id := range m.removedsubscriptions {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *FeedMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.cleareditems {
		edges = append(edges, feed.EdgeItems)
	}
	if m.clearedsubscribed_users {
		edges = append(edges, feed.EdgeSubscribedUsers)
	}
	if m.clearedsubscriptions {
		edges = append(edges, feed.EdgeSubscriptions)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *FeedMutation) EdgeCleared(name string) bool {
	switch name {
	case feed.EdgeItems:
		return m.cleareditems
	case feed.EdgeSubscribedUsers:
		return m.clearedsubscribed_users
	case feed.EdgeSubscriptions:
		return m.clearedsubscriptions
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *FeedMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown Feed unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *FeedMutation) ResetEdge(name string) error {
	switch name {
	case feed.EdgeItems:
		m.ResetItems()
		return nil
	case feed.EdgeSubscribedUsers:
		m.ResetSubscribedUsers()
		return nil
	case feed.EdgeSubscriptions:
		m.ResetSubscriptions()
		return nil
	}
	return fmt.Errorf("unknown Feed edge %s", name)
}

// ItemMutation represents an operation that mutates the Item nodes in the graph.
type ItemMutation struct {
	config
	op                   Op
	typ                  string
	id                   *uuid.UUID
	item_guid            *string
	item_title           *string
	item_description     *string
	item_content         *string
	item_link            *string
	item_updated         *time.Time
	item_published       *time.Time
	item_author_name     *string
	item_author_email    *string
	item_image_title     *string
	item_image_url       *string
	item_categories      *string
	item_enclosures      *string
	crawler_title        *string
	crawler_author       *string
	crawler_excerpt      *string
	crawler_site_name    *string
	crawler_image        *string
	crawler_content_html *string
	crawler_content_text *string
	created_at           *time.Time
	updated_at           *time.Time
	clearedFields        map[string]struct{}
	feed                 *uuid.UUID
	clearedfeed          bool
	read_by_users        map[uuid.UUID]struct{}
	removedread_by_users map[uuid.UUID]struct{}
	clearedread_by_users bool
	reads                map[uuid.UUID]struct{}
	removedreads         map[uuid.UUID]struct{}
	clearedreads         bool
	done                 bool
	oldValue             func(context.Context) (*Item, error)
	predicates           []predicate.Item
}

var _ ent.Mutation = (*ItemMutation)(nil)

// itemOption allows management of the mutation configuration using functional options.
type itemOption func(*ItemMutation)

// newItemMutation creates new mutation for the Item entity.
func newItemMutation(c config, op Op, opts ...itemOption) *ItemMutation {
	m := &ItemMutation{
		config:        c,
		op:            op,
		typ:           TypeItem,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withItemID sets the ID field of the mutation.
func withItemID(id uuid.UUID) itemOption {
	return func(m *ItemMutation) {
		var (
			err   error
			once  sync.Once
			value *Item
		)
		m.oldValue = func(ctx context.Context) (*Item, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Item.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withItem sets the old Item of the mutation.
func withItem(node *Item) itemOption {
	return func(m *ItemMutation) {
		m.oldValue = func(context.Context) (*Item, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ItemMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ItemMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Item entities.
func (m *ItemMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ItemMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ItemMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Item.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetItemGUID sets the "item_guid" field.
func (m *ItemMutation) SetItemGUID(s string) {
	m.item_guid = &s
}

// ItemGUID returns the value of the "item_guid" field in the mutation.
func (m *ItemMutation) ItemGUID() (r string, exists bool) {
	v := m.item_guid
	if v == nil {
		return
	}
	return *v, true
}

// OldItemGUID returns the old "item_guid" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemGUID(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemGUID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemGUID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemGUID: %w", err)
	}
	return oldValue.ItemGUID, nil
}

// ResetItemGUID resets all changes to the "item_guid" field.
func (m *ItemMutation) ResetItemGUID() {
	m.item_guid = nil
}

// SetItemTitle sets the "item_title" field.
func (m *ItemMutation) SetItemTitle(s string) {
	m.item_title = &s
}

// ItemTitle returns the value of the "item_title" field in the mutation.
func (m *ItemMutation) ItemTitle() (r string, exists bool) {
	v := m.item_title
	if v == nil {
		return
	}
	return *v, true
}

// OldItemTitle returns the old "item_title" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemTitle(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemTitle is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemTitle requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemTitle: %w", err)
	}
	return oldValue.ItemTitle, nil
}

// ResetItemTitle resets all changes to the "item_title" field.
func (m *ItemMutation) ResetItemTitle() {
	m.item_title = nil
}

// SetItemDescription sets the "item_description" field.
func (m *ItemMutation) SetItemDescription(s string) {
	m.item_description = &s
}

// ItemDescription returns the value of the "item_description" field in the mutation.
func (m *ItemMutation) ItemDescription() (r string, exists bool) {
	v := m.item_description
	if v == nil {
		return
	}
	return *v, true
}

// OldItemDescription returns the old "item_description" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemDescription(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemDescription is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemDescription requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemDescription: %w", err)
	}
	return oldValue.ItemDescription, nil
}

// ResetItemDescription resets all changes to the "item_description" field.
func (m *ItemMutation) ResetItemDescription() {
	m.item_description = nil
}

// SetItemContent sets the "item_content" field.
func (m *ItemMutation) SetItemContent(s string) {
	m.item_content = &s
}

// ItemContent returns the value of the "item_content" field in the mutation.
func (m *ItemMutation) ItemContent() (r string, exists bool) {
	v := m.item_content
	if v == nil {
		return
	}
	return *v, true
}

// OldItemContent returns the old "item_content" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemContent(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemContent is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemContent requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemContent: %w", err)
	}
	return oldValue.ItemContent, nil
}

// ResetItemContent resets all changes to the "item_content" field.
func (m *ItemMutation) ResetItemContent() {
	m.item_content = nil
}

// SetItemLink sets the "item_link" field.
func (m *ItemMutation) SetItemLink(s string) {
	m.item_link = &s
}

// ItemLink returns the value of the "item_link" field in the mutation.
func (m *ItemMutation) ItemLink() (r string, exists bool) {
	v := m.item_link
	if v == nil {
		return
	}
	return *v, true
}

// OldItemLink returns the old "item_link" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemLink(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemLink is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemLink requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemLink: %w", err)
	}
	return oldValue.ItemLink, nil
}

// ResetItemLink resets all changes to the "item_link" field.
func (m *ItemMutation) ResetItemLink() {
	m.item_link = nil
}

// SetItemUpdated sets the "item_updated" field.
func (m *ItemMutation) SetItemUpdated(t time.Time) {
	m.item_updated = &t
}

// ItemUpdated returns the value of the "item_updated" field in the mutation.
func (m *ItemMutation) ItemUpdated() (r time.Time, exists bool) {
	v := m.item_updated
	if v == nil {
		return
	}
	return *v, true
}

// OldItemUpdated returns the old "item_updated" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemUpdated(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemUpdated is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemUpdated requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemUpdated: %w", err)
	}
	return oldValue.ItemUpdated, nil
}

// ResetItemUpdated resets all changes to the "item_updated" field.
func (m *ItemMutation) ResetItemUpdated() {
	m.item_updated = nil
}

// SetItemPublished sets the "item_published" field.
func (m *ItemMutation) SetItemPublished(t time.Time) {
	m.item_published = &t
}

// ItemPublished returns the value of the "item_published" field in the mutation.
func (m *ItemMutation) ItemPublished() (r time.Time, exists bool) {
	v := m.item_published
	if v == nil {
		return
	}
	return *v, true
}

// OldItemPublished returns the old "item_published" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemPublished(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemPublished is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemPublished requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemPublished: %w", err)
	}
	return oldValue.ItemPublished, nil
}

// ResetItemPublished resets all changes to the "item_published" field.
func (m *ItemMutation) ResetItemPublished() {
	m.item_published = nil
}

// SetItemAuthorName sets the "item_author_name" field.
func (m *ItemMutation) SetItemAuthorName(s string) {
	m.item_author_name = &s
}

// ItemAuthorName returns the value of the "item_author_name" field in the mutation.
func (m *ItemMutation) ItemAuthorName() (r string, exists bool) {
	v := m.item_author_name
	if v == nil {
		return
	}
	return *v, true
}

// OldItemAuthorName returns the old "item_author_name" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemAuthorName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemAuthorName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemAuthorName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemAuthorName: %w", err)
	}
	return oldValue.ItemAuthorName, nil
}

// ClearItemAuthorName clears the value of the "item_author_name" field.
func (m *ItemMutation) ClearItemAuthorName() {
	m.item_author_name = nil
	m.clearedFields[item.FieldItemAuthorName] = struct{}{}
}

// ItemAuthorNameCleared returns if the "item_author_name" field was cleared in this mutation.
func (m *ItemMutation) ItemAuthorNameCleared() bool {
	_, ok := m.clearedFields[item.FieldItemAuthorName]
	return ok
}

// ResetItemAuthorName resets all changes to the "item_author_name" field.
func (m *ItemMutation) ResetItemAuthorName() {
	m.item_author_name = nil
	delete(m.clearedFields, item.FieldItemAuthorName)
}

// SetItemAuthorEmail sets the "item_author_email" field.
func (m *ItemMutation) SetItemAuthorEmail(s string) {
	m.item_author_email = &s
}

// ItemAuthorEmail returns the value of the "item_author_email" field in the mutation.
func (m *ItemMutation) ItemAuthorEmail() (r string, exists bool) {
	v := m.item_author_email
	if v == nil {
		return
	}
	return *v, true
}

// OldItemAuthorEmail returns the old "item_author_email" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemAuthorEmail(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemAuthorEmail is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemAuthorEmail requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemAuthorEmail: %w", err)
	}
	return oldValue.ItemAuthorEmail, nil
}

// ClearItemAuthorEmail clears the value of the "item_author_email" field.
func (m *ItemMutation) ClearItemAuthorEmail() {
	m.item_author_email = nil
	m.clearedFields[item.FieldItemAuthorEmail] = struct{}{}
}

// ItemAuthorEmailCleared returns if the "item_author_email" field was cleared in this mutation.
func (m *ItemMutation) ItemAuthorEmailCleared() bool {
	_, ok := m.clearedFields[item.FieldItemAuthorEmail]
	return ok
}

// ResetItemAuthorEmail resets all changes to the "item_author_email" field.
func (m *ItemMutation) ResetItemAuthorEmail() {
	m.item_author_email = nil
	delete(m.clearedFields, item.FieldItemAuthorEmail)
}

// SetItemImageTitle sets the "item_image_title" field.
func (m *ItemMutation) SetItemImageTitle(s string) {
	m.item_image_title = &s
}

// ItemImageTitle returns the value of the "item_image_title" field in the mutation.
func (m *ItemMutation) ItemImageTitle() (r string, exists bool) {
	v := m.item_image_title
	if v == nil {
		return
	}
	return *v, true
}

// OldItemImageTitle returns the old "item_image_title" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemImageTitle(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemImageTitle is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemImageTitle requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemImageTitle: %w", err)
	}
	return oldValue.ItemImageTitle, nil
}

// ClearItemImageTitle clears the value of the "item_image_title" field.
func (m *ItemMutation) ClearItemImageTitle() {
	m.item_image_title = nil
	m.clearedFields[item.FieldItemImageTitle] = struct{}{}
}

// ItemImageTitleCleared returns if the "item_image_title" field was cleared in this mutation.
func (m *ItemMutation) ItemImageTitleCleared() bool {
	_, ok := m.clearedFields[item.FieldItemImageTitle]
	return ok
}

// ResetItemImageTitle resets all changes to the "item_image_title" field.
func (m *ItemMutation) ResetItemImageTitle() {
	m.item_image_title = nil
	delete(m.clearedFields, item.FieldItemImageTitle)
}

// SetItemImageURL sets the "item_image_url" field.
func (m *ItemMutation) SetItemImageURL(s string) {
	m.item_image_url = &s
}

// ItemImageURL returns the value of the "item_image_url" field in the mutation.
func (m *ItemMutation) ItemImageURL() (r string, exists bool) {
	v := m.item_image_url
	if v == nil {
		return
	}
	return *v, true
}

// OldItemImageURL returns the old "item_image_url" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemImageURL(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemImageURL is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemImageURL requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemImageURL: %w", err)
	}
	return oldValue.ItemImageURL, nil
}

// ClearItemImageURL clears the value of the "item_image_url" field.
func (m *ItemMutation) ClearItemImageURL() {
	m.item_image_url = nil
	m.clearedFields[item.FieldItemImageURL] = struct{}{}
}

// ItemImageURLCleared returns if the "item_image_url" field was cleared in this mutation.
func (m *ItemMutation) ItemImageURLCleared() bool {
	_, ok := m.clearedFields[item.FieldItemImageURL]
	return ok
}

// ResetItemImageURL resets all changes to the "item_image_url" field.
func (m *ItemMutation) ResetItemImageURL() {
	m.item_image_url = nil
	delete(m.clearedFields, item.FieldItemImageURL)
}

// SetItemCategories sets the "item_categories" field.
func (m *ItemMutation) SetItemCategories(s string) {
	m.item_categories = &s
}

// ItemCategories returns the value of the "item_categories" field in the mutation.
func (m *ItemMutation) ItemCategories() (r string, exists bool) {
	v := m.item_categories
	if v == nil {
		return
	}
	return *v, true
}

// OldItemCategories returns the old "item_categories" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemCategories(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemCategories is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemCategories requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemCategories: %w", err)
	}
	return oldValue.ItemCategories, nil
}

// ResetItemCategories resets all changes to the "item_categories" field.
func (m *ItemMutation) ResetItemCategories() {
	m.item_categories = nil
}

// SetItemEnclosures sets the "item_enclosures" field.
func (m *ItemMutation) SetItemEnclosures(s string) {
	m.item_enclosures = &s
}

// ItemEnclosures returns the value of the "item_enclosures" field in the mutation.
func (m *ItemMutation) ItemEnclosures() (r string, exists bool) {
	v := m.item_enclosures
	if v == nil {
		return
	}
	return *v, true
}

// OldItemEnclosures returns the old "item_enclosures" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldItemEnclosures(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemEnclosures is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemEnclosures requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemEnclosures: %w", err)
	}
	return oldValue.ItemEnclosures, nil
}

// ResetItemEnclosures resets all changes to the "item_enclosures" field.
func (m *ItemMutation) ResetItemEnclosures() {
	m.item_enclosures = nil
}

// SetCrawlerTitle sets the "crawler_title" field.
func (m *ItemMutation) SetCrawlerTitle(s string) {
	m.crawler_title = &s
}

// CrawlerTitle returns the value of the "crawler_title" field in the mutation.
func (m *ItemMutation) CrawlerTitle() (r string, exists bool) {
	v := m.crawler_title
	if v == nil {
		return
	}
	return *v, true
}

// OldCrawlerTitle returns the old "crawler_title" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldCrawlerTitle(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCrawlerTitle is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCrawlerTitle requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCrawlerTitle: %w", err)
	}
	return oldValue.CrawlerTitle, nil
}

// ClearCrawlerTitle clears the value of the "crawler_title" field.
func (m *ItemMutation) ClearCrawlerTitle() {
	m.crawler_title = nil
	m.clearedFields[item.FieldCrawlerTitle] = struct{}{}
}

// CrawlerTitleCleared returns if the "crawler_title" field was cleared in this mutation.
func (m *ItemMutation) CrawlerTitleCleared() bool {
	_, ok := m.clearedFields[item.FieldCrawlerTitle]
	return ok
}

// ResetCrawlerTitle resets all changes to the "crawler_title" field.
func (m *ItemMutation) ResetCrawlerTitle() {
	m.crawler_title = nil
	delete(m.clearedFields, item.FieldCrawlerTitle)
}

// SetCrawlerAuthor sets the "crawler_author" field.
func (m *ItemMutation) SetCrawlerAuthor(s string) {
	m.crawler_author = &s
}

// CrawlerAuthor returns the value of the "crawler_author" field in the mutation.
func (m *ItemMutation) CrawlerAuthor() (r string, exists bool) {
	v := m.crawler_author
	if v == nil {
		return
	}
	return *v, true
}

// OldCrawlerAuthor returns the old "crawler_author" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldCrawlerAuthor(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCrawlerAuthor is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCrawlerAuthor requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCrawlerAuthor: %w", err)
	}
	return oldValue.CrawlerAuthor, nil
}

// ClearCrawlerAuthor clears the value of the "crawler_author" field.
func (m *ItemMutation) ClearCrawlerAuthor() {
	m.crawler_author = nil
	m.clearedFields[item.FieldCrawlerAuthor] = struct{}{}
}

// CrawlerAuthorCleared returns if the "crawler_author" field was cleared in this mutation.
func (m *ItemMutation) CrawlerAuthorCleared() bool {
	_, ok := m.clearedFields[item.FieldCrawlerAuthor]
	return ok
}

// ResetCrawlerAuthor resets all changes to the "crawler_author" field.
func (m *ItemMutation) ResetCrawlerAuthor() {
	m.crawler_author = nil
	delete(m.clearedFields, item.FieldCrawlerAuthor)
}

// SetCrawlerExcerpt sets the "crawler_excerpt" field.
func (m *ItemMutation) SetCrawlerExcerpt(s string) {
	m.crawler_excerpt = &s
}

// CrawlerExcerpt returns the value of the "crawler_excerpt" field in the mutation.
func (m *ItemMutation) CrawlerExcerpt() (r string, exists bool) {
	v := m.crawler_excerpt
	if v == nil {
		return
	}
	return *v, true
}

// OldCrawlerExcerpt returns the old "crawler_excerpt" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldCrawlerExcerpt(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCrawlerExcerpt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCrawlerExcerpt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCrawlerExcerpt: %w", err)
	}
	return oldValue.CrawlerExcerpt, nil
}

// ClearCrawlerExcerpt clears the value of the "crawler_excerpt" field.
func (m *ItemMutation) ClearCrawlerExcerpt() {
	m.crawler_excerpt = nil
	m.clearedFields[item.FieldCrawlerExcerpt] = struct{}{}
}

// CrawlerExcerptCleared returns if the "crawler_excerpt" field was cleared in this mutation.
func (m *ItemMutation) CrawlerExcerptCleared() bool {
	_, ok := m.clearedFields[item.FieldCrawlerExcerpt]
	return ok
}

// ResetCrawlerExcerpt resets all changes to the "crawler_excerpt" field.
func (m *ItemMutation) ResetCrawlerExcerpt() {
	m.crawler_excerpt = nil
	delete(m.clearedFields, item.FieldCrawlerExcerpt)
}

// SetCrawlerSiteName sets the "crawler_site_name" field.
func (m *ItemMutation) SetCrawlerSiteName(s string) {
	m.crawler_site_name = &s
}

// CrawlerSiteName returns the value of the "crawler_site_name" field in the mutation.
func (m *ItemMutation) CrawlerSiteName() (r string, exists bool) {
	v := m.crawler_site_name
	if v == nil {
		return
	}
	return *v, true
}

// OldCrawlerSiteName returns the old "crawler_site_name" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldCrawlerSiteName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCrawlerSiteName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCrawlerSiteName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCrawlerSiteName: %w", err)
	}
	return oldValue.CrawlerSiteName, nil
}

// ClearCrawlerSiteName clears the value of the "crawler_site_name" field.
func (m *ItemMutation) ClearCrawlerSiteName() {
	m.crawler_site_name = nil
	m.clearedFields[item.FieldCrawlerSiteName] = struct{}{}
}

// CrawlerSiteNameCleared returns if the "crawler_site_name" field was cleared in this mutation.
func (m *ItemMutation) CrawlerSiteNameCleared() bool {
	_, ok := m.clearedFields[item.FieldCrawlerSiteName]
	return ok
}

// ResetCrawlerSiteName resets all changes to the "crawler_site_name" field.
func (m *ItemMutation) ResetCrawlerSiteName() {
	m.crawler_site_name = nil
	delete(m.clearedFields, item.FieldCrawlerSiteName)
}

// SetCrawlerImage sets the "crawler_image" field.
func (m *ItemMutation) SetCrawlerImage(s string) {
	m.crawler_image = &s
}

// CrawlerImage returns the value of the "crawler_image" field in the mutation.
func (m *ItemMutation) CrawlerImage() (r string, exists bool) {
	v := m.crawler_image
	if v == nil {
		return
	}
	return *v, true
}

// OldCrawlerImage returns the old "crawler_image" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldCrawlerImage(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCrawlerImage is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCrawlerImage requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCrawlerImage: %w", err)
	}
	return oldValue.CrawlerImage, nil
}

// ClearCrawlerImage clears the value of the "crawler_image" field.
func (m *ItemMutation) ClearCrawlerImage() {
	m.crawler_image = nil
	m.clearedFields[item.FieldCrawlerImage] = struct{}{}
}

// CrawlerImageCleared returns if the "crawler_image" field was cleared in this mutation.
func (m *ItemMutation) CrawlerImageCleared() bool {
	_, ok := m.clearedFields[item.FieldCrawlerImage]
	return ok
}

// ResetCrawlerImage resets all changes to the "crawler_image" field.
func (m *ItemMutation) ResetCrawlerImage() {
	m.crawler_image = nil
	delete(m.clearedFields, item.FieldCrawlerImage)
}

// SetCrawlerContentHTML sets the "crawler_content_html" field.
func (m *ItemMutation) SetCrawlerContentHTML(s string) {
	m.crawler_content_html = &s
}

// CrawlerContentHTML returns the value of the "crawler_content_html" field in the mutation.
func (m *ItemMutation) CrawlerContentHTML() (r string, exists bool) {
	v := m.crawler_content_html
	if v == nil {
		return
	}
	return *v, true
}

// OldCrawlerContentHTML returns the old "crawler_content_html" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldCrawlerContentHTML(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCrawlerContentHTML is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCrawlerContentHTML requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCrawlerContentHTML: %w", err)
	}
	return oldValue.CrawlerContentHTML, nil
}

// ClearCrawlerContentHTML clears the value of the "crawler_content_html" field.
func (m *ItemMutation) ClearCrawlerContentHTML() {
	m.crawler_content_html = nil
	m.clearedFields[item.FieldCrawlerContentHTML] = struct{}{}
}

// CrawlerContentHTMLCleared returns if the "crawler_content_html" field was cleared in this mutation.
func (m *ItemMutation) CrawlerContentHTMLCleared() bool {
	_, ok := m.clearedFields[item.FieldCrawlerContentHTML]
	return ok
}

// ResetCrawlerContentHTML resets all changes to the "crawler_content_html" field.
func (m *ItemMutation) ResetCrawlerContentHTML() {
	m.crawler_content_html = nil
	delete(m.clearedFields, item.FieldCrawlerContentHTML)
}

// SetCrawlerContentText sets the "crawler_content_text" field.
func (m *ItemMutation) SetCrawlerContentText(s string) {
	m.crawler_content_text = &s
}

// CrawlerContentText returns the value of the "crawler_content_text" field in the mutation.
func (m *ItemMutation) CrawlerContentText() (r string, exists bool) {
	v := m.crawler_content_text
	if v == nil {
		return
	}
	return *v, true
}

// OldCrawlerContentText returns the old "crawler_content_text" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldCrawlerContentText(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCrawlerContentText is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCrawlerContentText requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCrawlerContentText: %w", err)
	}
	return oldValue.CrawlerContentText, nil
}

// ClearCrawlerContentText clears the value of the "crawler_content_text" field.
func (m *ItemMutation) ClearCrawlerContentText() {
	m.crawler_content_text = nil
	m.clearedFields[item.FieldCrawlerContentText] = struct{}{}
}

// CrawlerContentTextCleared returns if the "crawler_content_text" field was cleared in this mutation.
func (m *ItemMutation) CrawlerContentTextCleared() bool {
	_, ok := m.clearedFields[item.FieldCrawlerContentText]
	return ok
}

// ResetCrawlerContentText resets all changes to the "crawler_content_text" field.
func (m *ItemMutation) ResetCrawlerContentText() {
	m.crawler_content_text = nil
	delete(m.clearedFields, item.FieldCrawlerContentText)
}

// SetCreatedAt sets the "created_at" field.
func (m *ItemMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ItemMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ItemMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *ItemMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *ItemMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Item entity.
// If the Item object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ItemMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *ItemMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetFeedID sets the "feed" edge to the Feed entity by id.
func (m *ItemMutation) SetFeedID(id uuid.UUID) {
	m.feed = &id
}

// ClearFeed clears the "feed" edge to the Feed entity.
func (m *ItemMutation) ClearFeed() {
	m.clearedfeed = true
}

// FeedCleared reports if the "feed" edge to the Feed entity was cleared.
func (m *ItemMutation) FeedCleared() bool {
	return m.clearedfeed
}

// FeedID returns the "feed" edge ID in the mutation.
func (m *ItemMutation) FeedID() (id uuid.UUID, exists bool) {
	if m.feed != nil {
		return *m.feed, true
	}
	return
}

// FeedIDs returns the "feed" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// FeedID instead. It exists only for internal usage by the builders.
func (m *ItemMutation) FeedIDs() (ids []uuid.UUID) {
	if id := m.feed; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetFeed resets all changes to the "feed" edge.
func (m *ItemMutation) ResetFeed() {
	m.feed = nil
	m.clearedfeed = false
}

// AddReadByUserIDs adds the "read_by_users" edge to the User entity by ids.
func (m *ItemMutation) AddReadByUserIDs(ids ...uuid.UUID) {
	if m.read_by_users == nil {
		m.read_by_users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.read_by_users[ids[i]] = struct{}{}
	}
}

// ClearReadByUsers clears the "read_by_users" edge to the User entity.
func (m *ItemMutation) ClearReadByUsers() {
	m.clearedread_by_users = true
}

// ReadByUsersCleared reports if the "read_by_users" edge to the User entity was cleared.
func (m *ItemMutation) ReadByUsersCleared() bool {
	return m.clearedread_by_users
}

// RemoveReadByUserIDs removes the "read_by_users" edge to the User entity by IDs.
func (m *ItemMutation) RemoveReadByUserIDs(ids ...uuid.UUID) {
	if m.removedread_by_users == nil {
		m.removedread_by_users = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.read_by_users, ids[i])
		m.removedread_by_users[ids[i]] = struct{}{}
	}
}

// RemovedReadByUsers returns the removed IDs of the "read_by_users" edge to the User entity.
func (m *ItemMutation) RemovedReadByUsersIDs() (ids []uuid.UUID) {
	for id := range m.removedread_by_users {
		ids = append(ids, id)
	}
	return
}

// ReadByUsersIDs returns the "read_by_users" edge IDs in the mutation.
func (m *ItemMutation) ReadByUsersIDs() (ids []uuid.UUID) {
	for id := range m.read_by_users {
		ids = append(ids, id)
	}
	return
}

// ResetReadByUsers resets all changes to the "read_by_users" edge.
func (m *ItemMutation) ResetReadByUsers() {
	m.read_by_users = nil
	m.clearedread_by_users = false
	m.removedread_by_users = nil
}

// AddReadIDs adds the "reads" edge to the Read entity by ids.
func (m *ItemMutation) AddReadIDs(ids ...uuid.UUID) {
	if m.reads == nil {
		m.reads = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.reads[ids[i]] = struct{}{}
	}
}

// ClearReads clears the "reads" edge to the Read entity.
func (m *ItemMutation) ClearReads() {
	m.clearedreads = true
}

// ReadsCleared reports if the "reads" edge to the Read entity was cleared.
func (m *ItemMutation) ReadsCleared() bool {
	return m.clearedreads
}

// RemoveReadIDs removes the "reads" edge to the Read entity by IDs.
func (m *ItemMutation) RemoveReadIDs(ids ...uuid.UUID) {
	if m.removedreads == nil {
		m.removedreads = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.reads, ids[i])
		m.removedreads[ids[i]] = struct{}{}
	}
}

// RemovedReads returns the removed IDs of the "reads" edge to the Read entity.
func (m *ItemMutation) RemovedReadsIDs() (ids []uuid.UUID) {
	for id := range m.removedreads {
		ids = append(ids, id)
	}
	return
}

// ReadsIDs returns the "reads" edge IDs in the mutation.
func (m *ItemMutation) ReadsIDs() (ids []uuid.UUID) {
	for id := range m.reads {
		ids = append(ids, id)
	}
	return
}

// ResetReads resets all changes to the "reads" edge.
func (m *ItemMutation) ResetReads() {
	m.reads = nil
	m.clearedreads = false
	m.removedreads = nil
}

// Where appends a list predicates to the ItemMutation builder.
func (m *ItemMutation) Where(ps ...predicate.Item) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ItemMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ItemMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Item, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ItemMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ItemMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Item).
func (m *ItemMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ItemMutation) Fields() []string {
	fields := make([]string, 0, 22)
	if m.item_guid != nil {
		fields = append(fields, item.FieldItemGUID)
	}
	if m.item_title != nil {
		fields = append(fields, item.FieldItemTitle)
	}
	if m.item_description != nil {
		fields = append(fields, item.FieldItemDescription)
	}
	if m.item_content != nil {
		fields = append(fields, item.FieldItemContent)
	}
	if m.item_link != nil {
		fields = append(fields, item.FieldItemLink)
	}
	if m.item_updated != nil {
		fields = append(fields, item.FieldItemUpdated)
	}
	if m.item_published != nil {
		fields = append(fields, item.FieldItemPublished)
	}
	if m.item_author_name != nil {
		fields = append(fields, item.FieldItemAuthorName)
	}
	if m.item_author_email != nil {
		fields = append(fields, item.FieldItemAuthorEmail)
	}
	if m.item_image_title != nil {
		fields = append(fields, item.FieldItemImageTitle)
	}
	if m.item_image_url != nil {
		fields = append(fields, item.FieldItemImageURL)
	}
	if m.item_categories != nil {
		fields = append(fields, item.FieldItemCategories)
	}
	if m.item_enclosures != nil {
		fields = append(fields, item.FieldItemEnclosures)
	}
	if m.crawler_title != nil {
		fields = append(fields, item.FieldCrawlerTitle)
	}
	if m.crawler_author != nil {
		fields = append(fields, item.FieldCrawlerAuthor)
	}
	if m.crawler_excerpt != nil {
		fields = append(fields, item.FieldCrawlerExcerpt)
	}
	if m.crawler_site_name != nil {
		fields = append(fields, item.FieldCrawlerSiteName)
	}
	if m.crawler_image != nil {
		fields = append(fields, item.FieldCrawlerImage)
	}
	if m.crawler_content_html != nil {
		fields = append(fields, item.FieldCrawlerContentHTML)
	}
	if m.crawler_content_text != nil {
		fields = append(fields, item.FieldCrawlerContentText)
	}
	if m.created_at != nil {
		fields = append(fields, item.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, item.FieldUpdatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ItemMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case item.FieldItemGUID:
		return m.ItemGUID()
	case item.FieldItemTitle:
		return m.ItemTitle()
	case item.FieldItemDescription:
		return m.ItemDescription()
	case item.FieldItemContent:
		return m.ItemContent()
	case item.FieldItemLink:
		return m.ItemLink()
	case item.FieldItemUpdated:
		return m.ItemUpdated()
	case item.FieldItemPublished:
		return m.ItemPublished()
	case item.FieldItemAuthorName:
		return m.ItemAuthorName()
	case item.FieldItemAuthorEmail:
		return m.ItemAuthorEmail()
	case item.FieldItemImageTitle:
		return m.ItemImageTitle()
	case item.FieldItemImageURL:
		return m.ItemImageURL()
	case item.FieldItemCategories:
		return m.ItemCategories()
	case item.FieldItemEnclosures:
		return m.ItemEnclosures()
	case item.FieldCrawlerTitle:
		return m.CrawlerTitle()
	case item.FieldCrawlerAuthor:
		return m.CrawlerAuthor()
	case item.FieldCrawlerExcerpt:
		return m.CrawlerExcerpt()
	case item.FieldCrawlerSiteName:
		return m.CrawlerSiteName()
	case item.FieldCrawlerImage:
		return m.CrawlerImage()
	case item.FieldCrawlerContentHTML:
		return m.CrawlerContentHTML()
	case item.FieldCrawlerContentText:
		return m.CrawlerContentText()
	case item.FieldCreatedAt:
		return m.CreatedAt()
	case item.FieldUpdatedAt:
		return m.UpdatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ItemMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case item.FieldItemGUID:
		return m.OldItemGUID(ctx)
	case item.FieldItemTitle:
		return m.OldItemTitle(ctx)
	case item.FieldItemDescription:
		return m.OldItemDescription(ctx)
	case item.FieldItemContent:
		return m.OldItemContent(ctx)
	case item.FieldItemLink:
		return m.OldItemLink(ctx)
	case item.FieldItemUpdated:
		return m.OldItemUpdated(ctx)
	case item.FieldItemPublished:
		return m.OldItemPublished(ctx)
	case item.FieldItemAuthorName:
		return m.OldItemAuthorName(ctx)
	case item.FieldItemAuthorEmail:
		return m.OldItemAuthorEmail(ctx)
	case item.FieldItemImageTitle:
		return m.OldItemImageTitle(ctx)
	case item.FieldItemImageURL:
		return m.OldItemImageURL(ctx)
	case item.FieldItemCategories:
		return m.OldItemCategories(ctx)
	case item.FieldItemEnclosures:
		return m.OldItemEnclosures(ctx)
	case item.FieldCrawlerTitle:
		return m.OldCrawlerTitle(ctx)
	case item.FieldCrawlerAuthor:
		return m.OldCrawlerAuthor(ctx)
	case item.FieldCrawlerExcerpt:
		return m.OldCrawlerExcerpt(ctx)
	case item.FieldCrawlerSiteName:
		return m.OldCrawlerSiteName(ctx)
	case item.FieldCrawlerImage:
		return m.OldCrawlerImage(ctx)
	case item.FieldCrawlerContentHTML:
		return m.OldCrawlerContentHTML(ctx)
	case item.FieldCrawlerContentText:
		return m.OldCrawlerContentText(ctx)
	case item.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case item.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Item field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ItemMutation) SetField(name string, value ent.Value) error {
	switch name {
	case item.FieldItemGUID:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemGUID(v)
		return nil
	case item.FieldItemTitle:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemTitle(v)
		return nil
	case item.FieldItemDescription:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemDescription(v)
		return nil
	case item.FieldItemContent:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemContent(v)
		return nil
	case item.FieldItemLink:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemLink(v)
		return nil
	case item.FieldItemUpdated:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemUpdated(v)
		return nil
	case item.FieldItemPublished:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemPublished(v)
		return nil
	case item.FieldItemAuthorName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemAuthorName(v)
		return nil
	case item.FieldItemAuthorEmail:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemAuthorEmail(v)
		return nil
	case item.FieldItemImageTitle:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemImageTitle(v)
		return nil
	case item.FieldItemImageURL:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemImageURL(v)
		return nil
	case item.FieldItemCategories:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemCategories(v)
		return nil
	case item.FieldItemEnclosures:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemEnclosures(v)
		return nil
	case item.FieldCrawlerTitle:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCrawlerTitle(v)
		return nil
	case item.FieldCrawlerAuthor:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCrawlerAuthor(v)
		return nil
	case item.FieldCrawlerExcerpt:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCrawlerExcerpt(v)
		return nil
	case item.FieldCrawlerSiteName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCrawlerSiteName(v)
		return nil
	case item.FieldCrawlerImage:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCrawlerImage(v)
		return nil
	case item.FieldCrawlerContentHTML:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCrawlerContentHTML(v)
		return nil
	case item.FieldCrawlerContentText:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCrawlerContentText(v)
		return nil
	case item.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case item.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Item field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ItemMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ItemMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ItemMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Item numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ItemMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(item.FieldItemAuthorName) {
		fields = append(fields, item.FieldItemAuthorName)
	}
	if m.FieldCleared(item.FieldItemAuthorEmail) {
		fields = append(fields, item.FieldItemAuthorEmail)
	}
	if m.FieldCleared(item.FieldItemImageTitle) {
		fields = append(fields, item.FieldItemImageTitle)
	}
	if m.FieldCleared(item.FieldItemImageURL) {
		fields = append(fields, item.FieldItemImageURL)
	}
	if m.FieldCleared(item.FieldCrawlerTitle) {
		fields = append(fields, item.FieldCrawlerTitle)
	}
	if m.FieldCleared(item.FieldCrawlerAuthor) {
		fields = append(fields, item.FieldCrawlerAuthor)
	}
	if m.FieldCleared(item.FieldCrawlerExcerpt) {
		fields = append(fields, item.FieldCrawlerExcerpt)
	}
	if m.FieldCleared(item.FieldCrawlerSiteName) {
		fields = append(fields, item.FieldCrawlerSiteName)
	}
	if m.FieldCleared(item.FieldCrawlerImage) {
		fields = append(fields, item.FieldCrawlerImage)
	}
	if m.FieldCleared(item.FieldCrawlerContentHTML) {
		fields = append(fields, item.FieldCrawlerContentHTML)
	}
	if m.FieldCleared(item.FieldCrawlerContentText) {
		fields = append(fields, item.FieldCrawlerContentText)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ItemMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ItemMutation) ClearField(name string) error {
	switch name {
	case item.FieldItemAuthorName:
		m.ClearItemAuthorName()
		return nil
	case item.FieldItemAuthorEmail:
		m.ClearItemAuthorEmail()
		return nil
	case item.FieldItemImageTitle:
		m.ClearItemImageTitle()
		return nil
	case item.FieldItemImageURL:
		m.ClearItemImageURL()
		return nil
	case item.FieldCrawlerTitle:
		m.ClearCrawlerTitle()
		return nil
	case item.FieldCrawlerAuthor:
		m.ClearCrawlerAuthor()
		return nil
	case item.FieldCrawlerExcerpt:
		m.ClearCrawlerExcerpt()
		return nil
	case item.FieldCrawlerSiteName:
		m.ClearCrawlerSiteName()
		return nil
	case item.FieldCrawlerImage:
		m.ClearCrawlerImage()
		return nil
	case item.FieldCrawlerContentHTML:
		m.ClearCrawlerContentHTML()
		return nil
	case item.FieldCrawlerContentText:
		m.ClearCrawlerContentText()
		return nil
	}
	return fmt.Errorf("unknown Item nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ItemMutation) ResetField(name string) error {
	switch name {
	case item.FieldItemGUID:
		m.ResetItemGUID()
		return nil
	case item.FieldItemTitle:
		m.ResetItemTitle()
		return nil
	case item.FieldItemDescription:
		m.ResetItemDescription()
		return nil
	case item.FieldItemContent:
		m.ResetItemContent()
		return nil
	case item.FieldItemLink:
		m.ResetItemLink()
		return nil
	case item.FieldItemUpdated:
		m.ResetItemUpdated()
		return nil
	case item.FieldItemPublished:
		m.ResetItemPublished()
		return nil
	case item.FieldItemAuthorName:
		m.ResetItemAuthorName()
		return nil
	case item.FieldItemAuthorEmail:
		m.ResetItemAuthorEmail()
		return nil
	case item.FieldItemImageTitle:
		m.ResetItemImageTitle()
		return nil
	case item.FieldItemImageURL:
		m.ResetItemImageURL()
		return nil
	case item.FieldItemCategories:
		m.ResetItemCategories()
		return nil
	case item.FieldItemEnclosures:
		m.ResetItemEnclosures()
		return nil
	case item.FieldCrawlerTitle:
		m.ResetCrawlerTitle()
		return nil
	case item.FieldCrawlerAuthor:
		m.ResetCrawlerAuthor()
		return nil
	case item.FieldCrawlerExcerpt:
		m.ResetCrawlerExcerpt()
		return nil
	case item.FieldCrawlerSiteName:
		m.ResetCrawlerSiteName()
		return nil
	case item.FieldCrawlerImage:
		m.ResetCrawlerImage()
		return nil
	case item.FieldCrawlerContentHTML:
		m.ResetCrawlerContentHTML()
		return nil
	case item.FieldCrawlerContentText:
		m.ResetCrawlerContentText()
		return nil
	case item.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case item.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	}
	return fmt.Errorf("unknown Item field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ItemMutation) AddedEdges() []string {
	edges := make([]string, 0, 3)
	if m.feed != nil {
		edges = append(edges, item.EdgeFeed)
	}
	if m.read_by_users != nil {
		edges = append(edges, item.EdgeReadByUsers)
	}
	if m.reads != nil {
		edges = append(edges, item.EdgeReads)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ItemMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case item.EdgeFeed:
		if id := m.feed; id != nil {
			return []ent.Value{*id}
		}
	case item.EdgeReadByUsers:
		ids := make([]ent.Value, 0, len(m.read_by_users))
		for id := range m.read_by_users {
			ids = append(ids, id)
		}
		return ids
	case item.EdgeReads:
		ids := make([]ent.Value, 0, len(m.reads))
		for id := range m.reads {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ItemMutation) RemovedEdges() []string {
	edges := make([]string, 0, 3)
	if m.removedread_by_users != nil {
		edges = append(edges, item.EdgeReadByUsers)
	}
	if m.removedreads != nil {
		edges = append(edges, item.EdgeReads)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ItemMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case item.EdgeReadByUsers:
		ids := make([]ent.Value, 0, len(m.removedread_by_users))
		for id := range m.removedread_by_users {
			ids = append(ids, id)
		}
		return ids
	case item.EdgeReads:
		ids := make([]ent.Value, 0, len(m.removedreads))
		for id := range m.removedreads {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ItemMutation) ClearedEdges() []string {
	edges := make([]string, 0, 3)
	if m.clearedfeed {
		edges = append(edges, item.EdgeFeed)
	}
	if m.clearedread_by_users {
		edges = append(edges, item.EdgeReadByUsers)
	}
	if m.clearedreads {
		edges = append(edges, item.EdgeReads)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ItemMutation) EdgeCleared(name string) bool {
	switch name {
	case item.EdgeFeed:
		return m.clearedfeed
	case item.EdgeReadByUsers:
		return m.clearedread_by_users
	case item.EdgeReads:
		return m.clearedreads
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ItemMutation) ClearEdge(name string) error {
	switch name {
	case item.EdgeFeed:
		m.ClearFeed()
		return nil
	}
	return fmt.Errorf("unknown Item unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ItemMutation) ResetEdge(name string) error {
	switch name {
	case item.EdgeFeed:
		m.ResetFeed()
		return nil
	case item.EdgeReadByUsers:
		m.ResetReadByUsers()
		return nil
	case item.EdgeReads:
		m.ResetReads()
		return nil
	}
	return fmt.Errorf("unknown Item edge %s", name)
}

// ReadMutation represents an operation that mutates the Read nodes in the graph.
type ReadMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	created_at    *time.Time
	clearedFields map[string]struct{}
	user          *uuid.UUID
	cleareduser   bool
	item          *uuid.UUID
	cleareditem   bool
	done          bool
	oldValue      func(context.Context) (*Read, error)
	predicates    []predicate.Read
}

var _ ent.Mutation = (*ReadMutation)(nil)

// readOption allows management of the mutation configuration using functional options.
type readOption func(*ReadMutation)

// newReadMutation creates new mutation for the Read entity.
func newReadMutation(c config, op Op, opts ...readOption) *ReadMutation {
	m := &ReadMutation{
		config:        c,
		op:            op,
		typ:           TypeRead,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withReadID sets the ID field of the mutation.
func withReadID(id uuid.UUID) readOption {
	return func(m *ReadMutation) {
		var (
			err   error
			once  sync.Once
			value *Read
		)
		m.oldValue = func(ctx context.Context) (*Read, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Read.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withRead sets the old Read of the mutation.
func withRead(node *Read) readOption {
	return func(m *ReadMutation) {
		m.oldValue = func(context.Context) (*Read, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m ReadMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m ReadMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Read entities.
func (m *ReadMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *ReadMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *ReadMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Read.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserID sets the "user_id" field.
func (m *ReadMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *ReadMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the Read entity.
// If the Read object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ReadMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *ReadMutation) ResetUserID() {
	m.user = nil
}

// SetItemID sets the "item_id" field.
func (m *ReadMutation) SetItemID(u uuid.UUID) {
	m.item = &u
}

// ItemID returns the value of the "item_id" field in the mutation.
func (m *ReadMutation) ItemID() (r uuid.UUID, exists bool) {
	v := m.item
	if v == nil {
		return
	}
	return *v, true
}

// OldItemID returns the old "item_id" field's value of the Read entity.
// If the Read object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ReadMutation) OldItemID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldItemID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldItemID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldItemID: %w", err)
	}
	return oldValue.ItemID, nil
}

// ResetItemID resets all changes to the "item_id" field.
func (m *ReadMutation) ResetItemID() {
	m.item = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *ReadMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *ReadMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Read entity.
// If the Read object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *ReadMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *ReadMutation) ResetCreatedAt() {
	m.created_at = nil
}

// ClearUser clears the "user" edge to the User entity.
func (m *ReadMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[read.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *ReadMutation) UserCleared() bool {
	return m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *ReadMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *ReadMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// ClearItem clears the "item" edge to the Item entity.
func (m *ReadMutation) ClearItem() {
	m.cleareditem = true
	m.clearedFields[read.FieldItemID] = struct{}{}
}

// ItemCleared reports if the "item" edge to the Item entity was cleared.
func (m *ReadMutation) ItemCleared() bool {
	return m.cleareditem
}

// ItemIDs returns the "item" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// ItemID instead. It exists only for internal usage by the builders.
func (m *ReadMutation) ItemIDs() (ids []uuid.UUID) {
	if id := m.item; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetItem resets all changes to the "item" edge.
func (m *ReadMutation) ResetItem() {
	m.item = nil
	m.cleareditem = false
}

// Where appends a list predicates to the ReadMutation builder.
func (m *ReadMutation) Where(ps ...predicate.Read) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the ReadMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *ReadMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Read, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *ReadMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *ReadMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Read).
func (m *ReadMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *ReadMutation) Fields() []string {
	fields := make([]string, 0, 3)
	if m.user != nil {
		fields = append(fields, read.FieldUserID)
	}
	if m.item != nil {
		fields = append(fields, read.FieldItemID)
	}
	if m.created_at != nil {
		fields = append(fields, read.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *ReadMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case read.FieldUserID:
		return m.UserID()
	case read.FieldItemID:
		return m.ItemID()
	case read.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *ReadMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case read.FieldUserID:
		return m.OldUserID(ctx)
	case read.FieldItemID:
		return m.OldItemID(ctx)
	case read.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Read field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ReadMutation) SetField(name string, value ent.Value) error {
	switch name {
	case read.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case read.FieldItemID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetItemID(v)
		return nil
	case read.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Read field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *ReadMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *ReadMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *ReadMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Read numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *ReadMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *ReadMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *ReadMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Read nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *ReadMutation) ResetField(name string) error {
	switch name {
	case read.FieldUserID:
		m.ResetUserID()
		return nil
	case read.FieldItemID:
		m.ResetItemID()
		return nil
	case read.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown Read field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *ReadMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.user != nil {
		edges = append(edges, read.EdgeUser)
	}
	if m.item != nil {
		edges = append(edges, read.EdgeItem)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *ReadMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case read.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	case read.EdgeItem:
		if id := m.item; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *ReadMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *ReadMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *ReadMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.cleareduser {
		edges = append(edges, read.EdgeUser)
	}
	if m.cleareditem {
		edges = append(edges, read.EdgeItem)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *ReadMutation) EdgeCleared(name string) bool {
	switch name {
	case read.EdgeUser:
		return m.cleareduser
	case read.EdgeItem:
		return m.cleareditem
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *ReadMutation) ClearEdge(name string) error {
	switch name {
	case read.EdgeUser:
		m.ClearUser()
		return nil
	case read.EdgeItem:
		m.ClearItem()
		return nil
	}
	return fmt.Errorf("unknown Read unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *ReadMutation) ResetEdge(name string) error {
	switch name {
	case read.EdgeUser:
		m.ResetUser()
		return nil
	case read.EdgeItem:
		m.ResetItem()
		return nil
	}
	return fmt.Errorf("unknown Read edge %s", name)
}

// SubscriptionMutation represents an operation that mutates the Subscription nodes in the graph.
type SubscriptionMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	name          *string
	group         *string
	created_at    *time.Time
	clearedFields map[string]struct{}
	user          *uuid.UUID
	cleareduser   bool
	feed          *uuid.UUID
	clearedfeed   bool
	done          bool
	oldValue      func(context.Context) (*Subscription, error)
	predicates    []predicate.Subscription
}

var _ ent.Mutation = (*SubscriptionMutation)(nil)

// subscriptionOption allows management of the mutation configuration using functional options.
type subscriptionOption func(*SubscriptionMutation)

// newSubscriptionMutation creates new mutation for the Subscription entity.
func newSubscriptionMutation(c config, op Op, opts ...subscriptionOption) *SubscriptionMutation {
	m := &SubscriptionMutation{
		config:        c,
		op:            op,
		typ:           TypeSubscription,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withSubscriptionID sets the ID field of the mutation.
func withSubscriptionID(id uuid.UUID) subscriptionOption {
	return func(m *SubscriptionMutation) {
		var (
			err   error
			once  sync.Once
			value *Subscription
		)
		m.oldValue = func(ctx context.Context) (*Subscription, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Subscription.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withSubscription sets the old Subscription of the mutation.
func withSubscription(node *Subscription) subscriptionOption {
	return func(m *SubscriptionMutation) {
		m.oldValue = func(context.Context) (*Subscription, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m SubscriptionMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m SubscriptionMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Subscription entities.
func (m *SubscriptionMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *SubscriptionMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *SubscriptionMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Subscription.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUserID sets the "user_id" field.
func (m *SubscriptionMutation) SetUserID(u uuid.UUID) {
	m.user = &u
}

// UserID returns the value of the "user_id" field in the mutation.
func (m *SubscriptionMutation) UserID() (r uuid.UUID, exists bool) {
	v := m.user
	if v == nil {
		return
	}
	return *v, true
}

// OldUserID returns the old "user_id" field's value of the Subscription entity.
// If the Subscription object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SubscriptionMutation) OldUserID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUserID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUserID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUserID: %w", err)
	}
	return oldValue.UserID, nil
}

// ResetUserID resets all changes to the "user_id" field.
func (m *SubscriptionMutation) ResetUserID() {
	m.user = nil
}

// SetFeedID sets the "feed_id" field.
func (m *SubscriptionMutation) SetFeedID(u uuid.UUID) {
	m.feed = &u
}

// FeedID returns the value of the "feed_id" field in the mutation.
func (m *SubscriptionMutation) FeedID() (r uuid.UUID, exists bool) {
	v := m.feed
	if v == nil {
		return
	}
	return *v, true
}

// OldFeedID returns the old "feed_id" field's value of the Subscription entity.
// If the Subscription object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SubscriptionMutation) OldFeedID(ctx context.Context) (v uuid.UUID, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldFeedID is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldFeedID requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldFeedID: %w", err)
	}
	return oldValue.FeedID, nil
}

// ResetFeedID resets all changes to the "feed_id" field.
func (m *SubscriptionMutation) ResetFeedID() {
	m.feed = nil
}

// SetName sets the "name" field.
func (m *SubscriptionMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *SubscriptionMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Subscription entity.
// If the Subscription object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SubscriptionMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *SubscriptionMutation) ResetName() {
	m.name = nil
}

// SetGroup sets the "group" field.
func (m *SubscriptionMutation) SetGroup(s string) {
	m.group = &s
}

// Group returns the value of the "group" field in the mutation.
func (m *SubscriptionMutation) Group() (r string, exists bool) {
	v := m.group
	if v == nil {
		return
	}
	return *v, true
}

// OldGroup returns the old "group" field's value of the Subscription entity.
// If the Subscription object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SubscriptionMutation) OldGroup(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldGroup is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldGroup requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldGroup: %w", err)
	}
	return oldValue.Group, nil
}

// ResetGroup resets all changes to the "group" field.
func (m *SubscriptionMutation) ResetGroup() {
	m.group = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *SubscriptionMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *SubscriptionMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Subscription entity.
// If the Subscription object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *SubscriptionMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *SubscriptionMutation) ResetCreatedAt() {
	m.created_at = nil
}

// ClearUser clears the "user" edge to the User entity.
func (m *SubscriptionMutation) ClearUser() {
	m.cleareduser = true
	m.clearedFields[subscription.FieldUserID] = struct{}{}
}

// UserCleared reports if the "user" edge to the User entity was cleared.
func (m *SubscriptionMutation) UserCleared() bool {
	return m.cleareduser
}

// UserIDs returns the "user" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// UserID instead. It exists only for internal usage by the builders.
func (m *SubscriptionMutation) UserIDs() (ids []uuid.UUID) {
	if id := m.user; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetUser resets all changes to the "user" edge.
func (m *SubscriptionMutation) ResetUser() {
	m.user = nil
	m.cleareduser = false
}

// ClearFeed clears the "feed" edge to the Feed entity.
func (m *SubscriptionMutation) ClearFeed() {
	m.clearedfeed = true
	m.clearedFields[subscription.FieldFeedID] = struct{}{}
}

// FeedCleared reports if the "feed" edge to the Feed entity was cleared.
func (m *SubscriptionMutation) FeedCleared() bool {
	return m.clearedfeed
}

// FeedIDs returns the "feed" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// FeedID instead. It exists only for internal usage by the builders.
func (m *SubscriptionMutation) FeedIDs() (ids []uuid.UUID) {
	if id := m.feed; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetFeed resets all changes to the "feed" edge.
func (m *SubscriptionMutation) ResetFeed() {
	m.feed = nil
	m.clearedfeed = false
}

// Where appends a list predicates to the SubscriptionMutation builder.
func (m *SubscriptionMutation) Where(ps ...predicate.Subscription) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the SubscriptionMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *SubscriptionMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Subscription, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *SubscriptionMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *SubscriptionMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Subscription).
func (m *SubscriptionMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *SubscriptionMutation) Fields() []string {
	fields := make([]string, 0, 5)
	if m.user != nil {
		fields = append(fields, subscription.FieldUserID)
	}
	if m.feed != nil {
		fields = append(fields, subscription.FieldFeedID)
	}
	if m.name != nil {
		fields = append(fields, subscription.FieldName)
	}
	if m.group != nil {
		fields = append(fields, subscription.FieldGroup)
	}
	if m.created_at != nil {
		fields = append(fields, subscription.FieldCreatedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *SubscriptionMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case subscription.FieldUserID:
		return m.UserID()
	case subscription.FieldFeedID:
		return m.FeedID()
	case subscription.FieldName:
		return m.Name()
	case subscription.FieldGroup:
		return m.Group()
	case subscription.FieldCreatedAt:
		return m.CreatedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *SubscriptionMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case subscription.FieldUserID:
		return m.OldUserID(ctx)
	case subscription.FieldFeedID:
		return m.OldFeedID(ctx)
	case subscription.FieldName:
		return m.OldName(ctx)
	case subscription.FieldGroup:
		return m.OldGroup(ctx)
	case subscription.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Subscription field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SubscriptionMutation) SetField(name string, value ent.Value) error {
	switch name {
	case subscription.FieldUserID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUserID(v)
		return nil
	case subscription.FieldFeedID:
		v, ok := value.(uuid.UUID)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetFeedID(v)
		return nil
	case subscription.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case subscription.FieldGroup:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetGroup(v)
		return nil
	case subscription.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Subscription field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *SubscriptionMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *SubscriptionMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *SubscriptionMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Subscription numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *SubscriptionMutation) ClearedFields() []string {
	return nil
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *SubscriptionMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *SubscriptionMutation) ClearField(name string) error {
	return fmt.Errorf("unknown Subscription nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *SubscriptionMutation) ResetField(name string) error {
	switch name {
	case subscription.FieldUserID:
		m.ResetUserID()
		return nil
	case subscription.FieldFeedID:
		m.ResetFeedID()
		return nil
	case subscription.FieldName:
		m.ResetName()
		return nil
	case subscription.FieldGroup:
		m.ResetGroup()
		return nil
	case subscription.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	}
	return fmt.Errorf("unknown Subscription field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *SubscriptionMutation) AddedEdges() []string {
	edges := make([]string, 0, 2)
	if m.user != nil {
		edges = append(edges, subscription.EdgeUser)
	}
	if m.feed != nil {
		edges = append(edges, subscription.EdgeFeed)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *SubscriptionMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case subscription.EdgeUser:
		if id := m.user; id != nil {
			return []ent.Value{*id}
		}
	case subscription.EdgeFeed:
		if id := m.feed; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *SubscriptionMutation) RemovedEdges() []string {
	edges := make([]string, 0, 2)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *SubscriptionMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *SubscriptionMutation) ClearedEdges() []string {
	edges := make([]string, 0, 2)
	if m.cleareduser {
		edges = append(edges, subscription.EdgeUser)
	}
	if m.clearedfeed {
		edges = append(edges, subscription.EdgeFeed)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *SubscriptionMutation) EdgeCleared(name string) bool {
	switch name {
	case subscription.EdgeUser:
		return m.cleareduser
	case subscription.EdgeFeed:
		return m.clearedfeed
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *SubscriptionMutation) ClearEdge(name string) error {
	switch name {
	case subscription.EdgeUser:
		m.ClearUser()
		return nil
	case subscription.EdgeFeed:
		m.ClearFeed()
		return nil
	}
	return fmt.Errorf("unknown Subscription unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *SubscriptionMutation) ResetEdge(name string) error {
	switch name {
	case subscription.EdgeUser:
		m.ResetUser()
		return nil
	case subscription.EdgeFeed:
		m.ResetFeed()
		return nil
	}
	return fmt.Errorf("unknown Subscription edge %s", name)
}

// TokenMutation represents an operation that mutates the Token nodes in the graph.
type TokenMutation struct {
	config
	op            Op
	typ           string
	id            *uuid.UUID
	_type         *string
	name          *string
	token         *string
	created_at    *time.Time
	updated_at    *time.Time
	deleted_at    *time.Time
	clearedFields map[string]struct{}
	owner         *uuid.UUID
	clearedowner  bool
	done          bool
	oldValue      func(context.Context) (*Token, error)
	predicates    []predicate.Token
}

var _ ent.Mutation = (*TokenMutation)(nil)

// tokenOption allows management of the mutation configuration using functional options.
type tokenOption func(*TokenMutation)

// newTokenMutation creates new mutation for the Token entity.
func newTokenMutation(c config, op Op, opts ...tokenOption) *TokenMutation {
	m := &TokenMutation{
		config:        c,
		op:            op,
		typ:           TypeToken,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withTokenID sets the ID field of the mutation.
func withTokenID(id uuid.UUID) tokenOption {
	return func(m *TokenMutation) {
		var (
			err   error
			once  sync.Once
			value *Token
		)
		m.oldValue = func(ctx context.Context) (*Token, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().Token.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withToken sets the old Token of the mutation.
func withToken(node *Token) tokenOption {
	return func(m *TokenMutation) {
		m.oldValue = func(context.Context) (*Token, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m TokenMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m TokenMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of Token entities.
func (m *TokenMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *TokenMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *TokenMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().Token.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetType sets the "type" field.
func (m *TokenMutation) SetType(s string) {
	m._type = &s
}

// GetType returns the value of the "type" field in the mutation.
func (m *TokenMutation) GetType() (r string, exists bool) {
	v := m._type
	if v == nil {
		return
	}
	return *v, true
}

// OldType returns the old "type" field's value of the Token entity.
// If the Token object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TokenMutation) OldType(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldType is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldType requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldType: %w", err)
	}
	return oldValue.Type, nil
}

// ResetType resets all changes to the "type" field.
func (m *TokenMutation) ResetType() {
	m._type = nil
}

// SetName sets the "name" field.
func (m *TokenMutation) SetName(s string) {
	m.name = &s
}

// Name returns the value of the "name" field in the mutation.
func (m *TokenMutation) Name() (r string, exists bool) {
	v := m.name
	if v == nil {
		return
	}
	return *v, true
}

// OldName returns the old "name" field's value of the Token entity.
// If the Token object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TokenMutation) OldName(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldName is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldName requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldName: %w", err)
	}
	return oldValue.Name, nil
}

// ResetName resets all changes to the "name" field.
func (m *TokenMutation) ResetName() {
	m.name = nil
}

// SetToken sets the "token" field.
func (m *TokenMutation) SetToken(s string) {
	m.token = &s
}

// Token returns the value of the "token" field in the mutation.
func (m *TokenMutation) Token() (r string, exists bool) {
	v := m.token
	if v == nil {
		return
	}
	return *v, true
}

// OldToken returns the old "token" field's value of the Token entity.
// If the Token object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TokenMutation) OldToken(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldToken is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldToken requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldToken: %w", err)
	}
	return oldValue.Token, nil
}

// ResetToken resets all changes to the "token" field.
func (m *TokenMutation) ResetToken() {
	m.token = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *TokenMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *TokenMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the Token entity.
// If the Token object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TokenMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *TokenMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *TokenMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *TokenMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the Token entity.
// If the Token object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TokenMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *TokenMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetDeletedAt sets the "deleted_at" field.
func (m *TokenMutation) SetDeletedAt(t time.Time) {
	m.deleted_at = &t
}

// DeletedAt returns the value of the "deleted_at" field in the mutation.
func (m *TokenMutation) DeletedAt() (r time.Time, exists bool) {
	v := m.deleted_at
	if v == nil {
		return
	}
	return *v, true
}

// OldDeletedAt returns the old "deleted_at" field's value of the Token entity.
// If the Token object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *TokenMutation) OldDeletedAt(ctx context.Context) (v *time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeletedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeletedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeletedAt: %w", err)
	}
	return oldValue.DeletedAt, nil
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (m *TokenMutation) ClearDeletedAt() {
	m.deleted_at = nil
	m.clearedFields[token.FieldDeletedAt] = struct{}{}
}

// DeletedAtCleared returns if the "deleted_at" field was cleared in this mutation.
func (m *TokenMutation) DeletedAtCleared() bool {
	_, ok := m.clearedFields[token.FieldDeletedAt]
	return ok
}

// ResetDeletedAt resets all changes to the "deleted_at" field.
func (m *TokenMutation) ResetDeletedAt() {
	m.deleted_at = nil
	delete(m.clearedFields, token.FieldDeletedAt)
}

// SetOwnerID sets the "owner" edge to the User entity by id.
func (m *TokenMutation) SetOwnerID(id uuid.UUID) {
	m.owner = &id
}

// ClearOwner clears the "owner" edge to the User entity.
func (m *TokenMutation) ClearOwner() {
	m.clearedowner = true
}

// OwnerCleared reports if the "owner" edge to the User entity was cleared.
func (m *TokenMutation) OwnerCleared() bool {
	return m.clearedowner
}

// OwnerID returns the "owner" edge ID in the mutation.
func (m *TokenMutation) OwnerID() (id uuid.UUID, exists bool) {
	if m.owner != nil {
		return *m.owner, true
	}
	return
}

// OwnerIDs returns the "owner" edge IDs in the mutation.
// Note that IDs always returns len(IDs) <= 1 for unique edges, and you should use
// OwnerID instead. It exists only for internal usage by the builders.
func (m *TokenMutation) OwnerIDs() (ids []uuid.UUID) {
	if id := m.owner; id != nil {
		ids = append(ids, *id)
	}
	return
}

// ResetOwner resets all changes to the "owner" edge.
func (m *TokenMutation) ResetOwner() {
	m.owner = nil
	m.clearedowner = false
}

// Where appends a list predicates to the TokenMutation builder.
func (m *TokenMutation) Where(ps ...predicate.Token) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the TokenMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *TokenMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.Token, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *TokenMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *TokenMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (Token).
func (m *TokenMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *TokenMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m._type != nil {
		fields = append(fields, token.FieldType)
	}
	if m.name != nil {
		fields = append(fields, token.FieldName)
	}
	if m.token != nil {
		fields = append(fields, token.FieldToken)
	}
	if m.created_at != nil {
		fields = append(fields, token.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, token.FieldUpdatedAt)
	}
	if m.deleted_at != nil {
		fields = append(fields, token.FieldDeletedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *TokenMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case token.FieldType:
		return m.GetType()
	case token.FieldName:
		return m.Name()
	case token.FieldToken:
		return m.Token()
	case token.FieldCreatedAt:
		return m.CreatedAt()
	case token.FieldUpdatedAt:
		return m.UpdatedAt()
	case token.FieldDeletedAt:
		return m.DeletedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *TokenMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case token.FieldType:
		return m.OldType(ctx)
	case token.FieldName:
		return m.OldName(ctx)
	case token.FieldToken:
		return m.OldToken(ctx)
	case token.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case token.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case token.FieldDeletedAt:
		return m.OldDeletedAt(ctx)
	}
	return nil, fmt.Errorf("unknown Token field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TokenMutation) SetField(name string, value ent.Value) error {
	switch name {
	case token.FieldType:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetType(v)
		return nil
	case token.FieldName:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetName(v)
		return nil
	case token.FieldToken:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetToken(v)
		return nil
	case token.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case token.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case token.FieldDeletedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeletedAt(v)
		return nil
	}
	return fmt.Errorf("unknown Token field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *TokenMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *TokenMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *TokenMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown Token numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *TokenMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(token.FieldDeletedAt) {
		fields = append(fields, token.FieldDeletedAt)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *TokenMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *TokenMutation) ClearField(name string) error {
	switch name {
	case token.FieldDeletedAt:
		m.ClearDeletedAt()
		return nil
	}
	return fmt.Errorf("unknown Token nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *TokenMutation) ResetField(name string) error {
	switch name {
	case token.FieldType:
		m.ResetType()
		return nil
	case token.FieldName:
		m.ResetName()
		return nil
	case token.FieldToken:
		m.ResetToken()
		return nil
	case token.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case token.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case token.FieldDeletedAt:
		m.ResetDeletedAt()
		return nil
	}
	return fmt.Errorf("unknown Token field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *TokenMutation) AddedEdges() []string {
	edges := make([]string, 0, 1)
	if m.owner != nil {
		edges = append(edges, token.EdgeOwner)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *TokenMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case token.EdgeOwner:
		if id := m.owner; id != nil {
			return []ent.Value{*id}
		}
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *TokenMutation) RemovedEdges() []string {
	edges := make([]string, 0, 1)
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *TokenMutation) RemovedIDs(name string) []ent.Value {
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *TokenMutation) ClearedEdges() []string {
	edges := make([]string, 0, 1)
	if m.clearedowner {
		edges = append(edges, token.EdgeOwner)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *TokenMutation) EdgeCleared(name string) bool {
	switch name {
	case token.EdgeOwner:
		return m.clearedowner
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *TokenMutation) ClearEdge(name string) error {
	switch name {
	case token.EdgeOwner:
		m.ClearOwner()
		return nil
	}
	return fmt.Errorf("unknown Token unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *TokenMutation) ResetEdge(name string) error {
	switch name {
	case token.EdgeOwner:
		m.ResetOwner()
		return nil
	}
	return fmt.Errorf("unknown Token edge %s", name)
}

// UserMutation represents an operation that mutates the User nodes in the graph.
type UserMutation struct {
	config
	op                      Op
	typ                     string
	id                      *uuid.UUID
	username                *string
	password                *string
	role                    *string
	created_at              *time.Time
	updated_at              *time.Time
	deleted_at              *time.Time
	clearedFields           map[string]struct{}
	tokens                  map[uuid.UUID]struct{}
	removedtokens           map[uuid.UUID]struct{}
	clearedtokens           bool
	subscribed_feeds        map[uuid.UUID]struct{}
	removedsubscribed_feeds map[uuid.UUID]struct{}
	clearedsubscribed_feeds bool
	read_items              map[uuid.UUID]struct{}
	removedread_items       map[uuid.UUID]struct{}
	clearedread_items       bool
	subscriptions           map[uuid.UUID]struct{}
	removedsubscriptions    map[uuid.UUID]struct{}
	clearedsubscriptions    bool
	reads                   map[uuid.UUID]struct{}
	removedreads            map[uuid.UUID]struct{}
	clearedreads            bool
	done                    bool
	oldValue                func(context.Context) (*User, error)
	predicates              []predicate.User
}

var _ ent.Mutation = (*UserMutation)(nil)

// userOption allows management of the mutation configuration using functional options.
type userOption func(*UserMutation)

// newUserMutation creates new mutation for the User entity.
func newUserMutation(c config, op Op, opts ...userOption) *UserMutation {
	m := &UserMutation{
		config:        c,
		op:            op,
		typ:           TypeUser,
		clearedFields: make(map[string]struct{}),
	}
	for _, opt := range opts {
		opt(m)
	}
	return m
}

// withUserID sets the ID field of the mutation.
func withUserID(id uuid.UUID) userOption {
	return func(m *UserMutation) {
		var (
			err   error
			once  sync.Once
			value *User
		)
		m.oldValue = func(ctx context.Context) (*User, error) {
			once.Do(func() {
				if m.done {
					err = errors.New("querying old values post mutation is not allowed")
				} else {
					value, err = m.Client().User.Get(ctx, id)
				}
			})
			return value, err
		}
		m.id = &id
	}
}

// withUser sets the old User of the mutation.
func withUser(node *User) userOption {
	return func(m *UserMutation) {
		m.oldValue = func(context.Context) (*User, error) {
			return node, nil
		}
		m.id = &node.ID
	}
}

// Client returns a new `ent.Client` from the mutation. If the mutation was
// executed in a transaction (ent.Tx), a transactional client is returned.
func (m UserMutation) Client() *Client {
	client := &Client{config: m.config}
	client.init()
	return client
}

// Tx returns an `ent.Tx` for mutations that were executed in transactions;
// it returns an error otherwise.
func (m UserMutation) Tx() (*Tx, error) {
	if _, ok := m.driver.(*txDriver); !ok {
		return nil, errors.New("ent: mutation is not running in a transaction")
	}
	tx := &Tx{config: m.config}
	tx.init()
	return tx, nil
}

// SetID sets the value of the id field. Note that this
// operation is only accepted on creation of User entities.
func (m *UserMutation) SetID(id uuid.UUID) {
	m.id = &id
}

// ID returns the ID value in the mutation. Note that the ID is only available
// if it was provided to the builder or after it was returned from the database.
func (m *UserMutation) ID() (id uuid.UUID, exists bool) {
	if m.id == nil {
		return
	}
	return *m.id, true
}

// IDs queries the database and returns the entity ids that match the mutation's predicate.
// That means, if the mutation is applied within a transaction with an isolation level such
// as sql.LevelSerializable, the returned ids match the ids of the rows that will be updated
// or updated by the mutation.
func (m *UserMutation) IDs(ctx context.Context) ([]uuid.UUID, error) {
	switch {
	case m.op.Is(OpUpdateOne | OpDeleteOne):
		id, exists := m.ID()
		if exists {
			return []uuid.UUID{id}, nil
		}
		fallthrough
	case m.op.Is(OpUpdate | OpDelete):
		return m.Client().User.Query().Where(m.predicates...).IDs(ctx)
	default:
		return nil, fmt.Errorf("IDs is not allowed on %s operations", m.op)
	}
}

// SetUsername sets the "username" field.
func (m *UserMutation) SetUsername(s string) {
	m.username = &s
}

// Username returns the value of the "username" field in the mutation.
func (m *UserMutation) Username() (r string, exists bool) {
	v := m.username
	if v == nil {
		return
	}
	return *v, true
}

// OldUsername returns the old "username" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldUsername(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUsername is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUsername requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUsername: %w", err)
	}
	return oldValue.Username, nil
}

// ResetUsername resets all changes to the "username" field.
func (m *UserMutation) ResetUsername() {
	m.username = nil
}

// SetPassword sets the "password" field.
func (m *UserMutation) SetPassword(s string) {
	m.password = &s
}

// Password returns the value of the "password" field in the mutation.
func (m *UserMutation) Password() (r string, exists bool) {
	v := m.password
	if v == nil {
		return
	}
	return *v, true
}

// OldPassword returns the old "password" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldPassword(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldPassword is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldPassword requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldPassword: %w", err)
	}
	return oldValue.Password, nil
}

// ResetPassword resets all changes to the "password" field.
func (m *UserMutation) ResetPassword() {
	m.password = nil
}

// SetRole sets the "role" field.
func (m *UserMutation) SetRole(s string) {
	m.role = &s
}

// Role returns the value of the "role" field in the mutation.
func (m *UserMutation) Role() (r string, exists bool) {
	v := m.role
	if v == nil {
		return
	}
	return *v, true
}

// OldRole returns the old "role" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldRole(ctx context.Context) (v string, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldRole is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldRole requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldRole: %w", err)
	}
	return oldValue.Role, nil
}

// ResetRole resets all changes to the "role" field.
func (m *UserMutation) ResetRole() {
	m.role = nil
}

// SetCreatedAt sets the "created_at" field.
func (m *UserMutation) SetCreatedAt(t time.Time) {
	m.created_at = &t
}

// CreatedAt returns the value of the "created_at" field in the mutation.
func (m *UserMutation) CreatedAt() (r time.Time, exists bool) {
	v := m.created_at
	if v == nil {
		return
	}
	return *v, true
}

// OldCreatedAt returns the old "created_at" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldCreatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldCreatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldCreatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldCreatedAt: %w", err)
	}
	return oldValue.CreatedAt, nil
}

// ResetCreatedAt resets all changes to the "created_at" field.
func (m *UserMutation) ResetCreatedAt() {
	m.created_at = nil
}

// SetUpdatedAt sets the "updated_at" field.
func (m *UserMutation) SetUpdatedAt(t time.Time) {
	m.updated_at = &t
}

// UpdatedAt returns the value of the "updated_at" field in the mutation.
func (m *UserMutation) UpdatedAt() (r time.Time, exists bool) {
	v := m.updated_at
	if v == nil {
		return
	}
	return *v, true
}

// OldUpdatedAt returns the old "updated_at" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldUpdatedAt(ctx context.Context) (v time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldUpdatedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldUpdatedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldUpdatedAt: %w", err)
	}
	return oldValue.UpdatedAt, nil
}

// ResetUpdatedAt resets all changes to the "updated_at" field.
func (m *UserMutation) ResetUpdatedAt() {
	m.updated_at = nil
}

// SetDeletedAt sets the "deleted_at" field.
func (m *UserMutation) SetDeletedAt(t time.Time) {
	m.deleted_at = &t
}

// DeletedAt returns the value of the "deleted_at" field in the mutation.
func (m *UserMutation) DeletedAt() (r time.Time, exists bool) {
	v := m.deleted_at
	if v == nil {
		return
	}
	return *v, true
}

// OldDeletedAt returns the old "deleted_at" field's value of the User entity.
// If the User object wasn't provided to the builder, the object is fetched from the database.
// An error is returned if the mutation operation is not UpdateOne, or the database query fails.
func (m *UserMutation) OldDeletedAt(ctx context.Context) (v *time.Time, err error) {
	if !m.op.Is(OpUpdateOne) {
		return v, errors.New("OldDeletedAt is only allowed on UpdateOne operations")
	}
	if m.id == nil || m.oldValue == nil {
		return v, errors.New("OldDeletedAt requires an ID field in the mutation")
	}
	oldValue, err := m.oldValue(ctx)
	if err != nil {
		return v, fmt.Errorf("querying old value for OldDeletedAt: %w", err)
	}
	return oldValue.DeletedAt, nil
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (m *UserMutation) ClearDeletedAt() {
	m.deleted_at = nil
	m.clearedFields[user.FieldDeletedAt] = struct{}{}
}

// DeletedAtCleared returns if the "deleted_at" field was cleared in this mutation.
func (m *UserMutation) DeletedAtCleared() bool {
	_, ok := m.clearedFields[user.FieldDeletedAt]
	return ok
}

// ResetDeletedAt resets all changes to the "deleted_at" field.
func (m *UserMutation) ResetDeletedAt() {
	m.deleted_at = nil
	delete(m.clearedFields, user.FieldDeletedAt)
}

// AddTokenIDs adds the "tokens" edge to the Token entity by ids.
func (m *UserMutation) AddTokenIDs(ids ...uuid.UUID) {
	if m.tokens == nil {
		m.tokens = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.tokens[ids[i]] = struct{}{}
	}
}

// ClearTokens clears the "tokens" edge to the Token entity.
func (m *UserMutation) ClearTokens() {
	m.clearedtokens = true
}

// TokensCleared reports if the "tokens" edge to the Token entity was cleared.
func (m *UserMutation) TokensCleared() bool {
	return m.clearedtokens
}

// RemoveTokenIDs removes the "tokens" edge to the Token entity by IDs.
func (m *UserMutation) RemoveTokenIDs(ids ...uuid.UUID) {
	if m.removedtokens == nil {
		m.removedtokens = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.tokens, ids[i])
		m.removedtokens[ids[i]] = struct{}{}
	}
}

// RemovedTokens returns the removed IDs of the "tokens" edge to the Token entity.
func (m *UserMutation) RemovedTokensIDs() (ids []uuid.UUID) {
	for id := range m.removedtokens {
		ids = append(ids, id)
	}
	return
}

// TokensIDs returns the "tokens" edge IDs in the mutation.
func (m *UserMutation) TokensIDs() (ids []uuid.UUID) {
	for id := range m.tokens {
		ids = append(ids, id)
	}
	return
}

// ResetTokens resets all changes to the "tokens" edge.
func (m *UserMutation) ResetTokens() {
	m.tokens = nil
	m.clearedtokens = false
	m.removedtokens = nil
}

// AddSubscribedFeedIDs adds the "subscribed_feeds" edge to the Feed entity by ids.
func (m *UserMutation) AddSubscribedFeedIDs(ids ...uuid.UUID) {
	if m.subscribed_feeds == nil {
		m.subscribed_feeds = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.subscribed_feeds[ids[i]] = struct{}{}
	}
}

// ClearSubscribedFeeds clears the "subscribed_feeds" edge to the Feed entity.
func (m *UserMutation) ClearSubscribedFeeds() {
	m.clearedsubscribed_feeds = true
}

// SubscribedFeedsCleared reports if the "subscribed_feeds" edge to the Feed entity was cleared.
func (m *UserMutation) SubscribedFeedsCleared() bool {
	return m.clearedsubscribed_feeds
}

// RemoveSubscribedFeedIDs removes the "subscribed_feeds" edge to the Feed entity by IDs.
func (m *UserMutation) RemoveSubscribedFeedIDs(ids ...uuid.UUID) {
	if m.removedsubscribed_feeds == nil {
		m.removedsubscribed_feeds = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.subscribed_feeds, ids[i])
		m.removedsubscribed_feeds[ids[i]] = struct{}{}
	}
}

// RemovedSubscribedFeeds returns the removed IDs of the "subscribed_feeds" edge to the Feed entity.
func (m *UserMutation) RemovedSubscribedFeedsIDs() (ids []uuid.UUID) {
	for id := range m.removedsubscribed_feeds {
		ids = append(ids, id)
	}
	return
}

// SubscribedFeedsIDs returns the "subscribed_feeds" edge IDs in the mutation.
func (m *UserMutation) SubscribedFeedsIDs() (ids []uuid.UUID) {
	for id := range m.subscribed_feeds {
		ids = append(ids, id)
	}
	return
}

// ResetSubscribedFeeds resets all changes to the "subscribed_feeds" edge.
func (m *UserMutation) ResetSubscribedFeeds() {
	m.subscribed_feeds = nil
	m.clearedsubscribed_feeds = false
	m.removedsubscribed_feeds = nil
}

// AddReadItemIDs adds the "read_items" edge to the Item entity by ids.
func (m *UserMutation) AddReadItemIDs(ids ...uuid.UUID) {
	if m.read_items == nil {
		m.read_items = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.read_items[ids[i]] = struct{}{}
	}
}

// ClearReadItems clears the "read_items" edge to the Item entity.
func (m *UserMutation) ClearReadItems() {
	m.clearedread_items = true
}

// ReadItemsCleared reports if the "read_items" edge to the Item entity was cleared.
func (m *UserMutation) ReadItemsCleared() bool {
	return m.clearedread_items
}

// RemoveReadItemIDs removes the "read_items" edge to the Item entity by IDs.
func (m *UserMutation) RemoveReadItemIDs(ids ...uuid.UUID) {
	if m.removedread_items == nil {
		m.removedread_items = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.read_items, ids[i])
		m.removedread_items[ids[i]] = struct{}{}
	}
}

// RemovedReadItems returns the removed IDs of the "read_items" edge to the Item entity.
func (m *UserMutation) RemovedReadItemsIDs() (ids []uuid.UUID) {
	for id := range m.removedread_items {
		ids = append(ids, id)
	}
	return
}

// ReadItemsIDs returns the "read_items" edge IDs in the mutation.
func (m *UserMutation) ReadItemsIDs() (ids []uuid.UUID) {
	for id := range m.read_items {
		ids = append(ids, id)
	}
	return
}

// ResetReadItems resets all changes to the "read_items" edge.
func (m *UserMutation) ResetReadItems() {
	m.read_items = nil
	m.clearedread_items = false
	m.removedread_items = nil
}

// AddSubscriptionIDs adds the "subscriptions" edge to the Subscription entity by ids.
func (m *UserMutation) AddSubscriptionIDs(ids ...uuid.UUID) {
	if m.subscriptions == nil {
		m.subscriptions = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.subscriptions[ids[i]] = struct{}{}
	}
}

// ClearSubscriptions clears the "subscriptions" edge to the Subscription entity.
func (m *UserMutation) ClearSubscriptions() {
	m.clearedsubscriptions = true
}

// SubscriptionsCleared reports if the "subscriptions" edge to the Subscription entity was cleared.
func (m *UserMutation) SubscriptionsCleared() bool {
	return m.clearedsubscriptions
}

// RemoveSubscriptionIDs removes the "subscriptions" edge to the Subscription entity by IDs.
func (m *UserMutation) RemoveSubscriptionIDs(ids ...uuid.UUID) {
	if m.removedsubscriptions == nil {
		m.removedsubscriptions = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.subscriptions, ids[i])
		m.removedsubscriptions[ids[i]] = struct{}{}
	}
}

// RemovedSubscriptions returns the removed IDs of the "subscriptions" edge to the Subscription entity.
func (m *UserMutation) RemovedSubscriptionsIDs() (ids []uuid.UUID) {
	for id := range m.removedsubscriptions {
		ids = append(ids, id)
	}
	return
}

// SubscriptionsIDs returns the "subscriptions" edge IDs in the mutation.
func (m *UserMutation) SubscriptionsIDs() (ids []uuid.UUID) {
	for id := range m.subscriptions {
		ids = append(ids, id)
	}
	return
}

// ResetSubscriptions resets all changes to the "subscriptions" edge.
func (m *UserMutation) ResetSubscriptions() {
	m.subscriptions = nil
	m.clearedsubscriptions = false
	m.removedsubscriptions = nil
}

// AddReadIDs adds the "reads" edge to the Read entity by ids.
func (m *UserMutation) AddReadIDs(ids ...uuid.UUID) {
	if m.reads == nil {
		m.reads = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		m.reads[ids[i]] = struct{}{}
	}
}

// ClearReads clears the "reads" edge to the Read entity.
func (m *UserMutation) ClearReads() {
	m.clearedreads = true
}

// ReadsCleared reports if the "reads" edge to the Read entity was cleared.
func (m *UserMutation) ReadsCleared() bool {
	return m.clearedreads
}

// RemoveReadIDs removes the "reads" edge to the Read entity by IDs.
func (m *UserMutation) RemoveReadIDs(ids ...uuid.UUID) {
	if m.removedreads == nil {
		m.removedreads = make(map[uuid.UUID]struct{})
	}
	for i := range ids {
		delete(m.reads, ids[i])
		m.removedreads[ids[i]] = struct{}{}
	}
}

// RemovedReads returns the removed IDs of the "reads" edge to the Read entity.
func (m *UserMutation) RemovedReadsIDs() (ids []uuid.UUID) {
	for id := range m.removedreads {
		ids = append(ids, id)
	}
	return
}

// ReadsIDs returns the "reads" edge IDs in the mutation.
func (m *UserMutation) ReadsIDs() (ids []uuid.UUID) {
	for id := range m.reads {
		ids = append(ids, id)
	}
	return
}

// ResetReads resets all changes to the "reads" edge.
func (m *UserMutation) ResetReads() {
	m.reads = nil
	m.clearedreads = false
	m.removedreads = nil
}

// Where appends a list predicates to the UserMutation builder.
func (m *UserMutation) Where(ps ...predicate.User) {
	m.predicates = append(m.predicates, ps...)
}

// WhereP appends storage-level predicates to the UserMutation builder. Using this method,
// users can use type-assertion to append predicates that do not depend on any generated package.
func (m *UserMutation) WhereP(ps ...func(*sql.Selector)) {
	p := make([]predicate.User, len(ps))
	for i := range ps {
		p[i] = ps[i]
	}
	m.Where(p...)
}

// Op returns the operation name.
func (m *UserMutation) Op() Op {
	return m.op
}

// SetOp allows setting the mutation operation.
func (m *UserMutation) SetOp(op Op) {
	m.op = op
}

// Type returns the node type of this mutation (User).
func (m *UserMutation) Type() string {
	return m.typ
}

// Fields returns all fields that were changed during this mutation. Note that in
// order to get all numeric fields that were incremented/decremented, call
// AddedFields().
func (m *UserMutation) Fields() []string {
	fields := make([]string, 0, 6)
	if m.username != nil {
		fields = append(fields, user.FieldUsername)
	}
	if m.password != nil {
		fields = append(fields, user.FieldPassword)
	}
	if m.role != nil {
		fields = append(fields, user.FieldRole)
	}
	if m.created_at != nil {
		fields = append(fields, user.FieldCreatedAt)
	}
	if m.updated_at != nil {
		fields = append(fields, user.FieldUpdatedAt)
	}
	if m.deleted_at != nil {
		fields = append(fields, user.FieldDeletedAt)
	}
	return fields
}

// Field returns the value of a field with the given name. The second boolean
// return value indicates that this field was not set, or was not defined in the
// schema.
func (m *UserMutation) Field(name string) (ent.Value, bool) {
	switch name {
	case user.FieldUsername:
		return m.Username()
	case user.FieldPassword:
		return m.Password()
	case user.FieldRole:
		return m.Role()
	case user.FieldCreatedAt:
		return m.CreatedAt()
	case user.FieldUpdatedAt:
		return m.UpdatedAt()
	case user.FieldDeletedAt:
		return m.DeletedAt()
	}
	return nil, false
}

// OldField returns the old value of the field from the database. An error is
// returned if the mutation operation is not UpdateOne, or the query to the
// database failed.
func (m *UserMutation) OldField(ctx context.Context, name string) (ent.Value, error) {
	switch name {
	case user.FieldUsername:
		return m.OldUsername(ctx)
	case user.FieldPassword:
		return m.OldPassword(ctx)
	case user.FieldRole:
		return m.OldRole(ctx)
	case user.FieldCreatedAt:
		return m.OldCreatedAt(ctx)
	case user.FieldUpdatedAt:
		return m.OldUpdatedAt(ctx)
	case user.FieldDeletedAt:
		return m.OldDeletedAt(ctx)
	}
	return nil, fmt.Errorf("unknown User field %s", name)
}

// SetField sets the value of a field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) SetField(name string, value ent.Value) error {
	switch name {
	case user.FieldUsername:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUsername(v)
		return nil
	case user.FieldPassword:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetPassword(v)
		return nil
	case user.FieldRole:
		v, ok := value.(string)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetRole(v)
		return nil
	case user.FieldCreatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetCreatedAt(v)
		return nil
	case user.FieldUpdatedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetUpdatedAt(v)
		return nil
	case user.FieldDeletedAt:
		v, ok := value.(time.Time)
		if !ok {
			return fmt.Errorf("unexpected type %T for field %s", value, name)
		}
		m.SetDeletedAt(v)
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedFields returns all numeric fields that were incremented/decremented during
// this mutation.
func (m *UserMutation) AddedFields() []string {
	return nil
}

// AddedField returns the numeric value that was incremented/decremented on a field
// with the given name. The second boolean return value indicates that this field
// was not set, or was not defined in the schema.
func (m *UserMutation) AddedField(name string) (ent.Value, bool) {
	return nil, false
}

// AddField adds the value to the field with the given name. It returns an error if
// the field is not defined in the schema, or if the type mismatched the field
// type.
func (m *UserMutation) AddField(name string, value ent.Value) error {
	switch name {
	}
	return fmt.Errorf("unknown User numeric field %s", name)
}

// ClearedFields returns all nullable fields that were cleared during this
// mutation.
func (m *UserMutation) ClearedFields() []string {
	var fields []string
	if m.FieldCleared(user.FieldDeletedAt) {
		fields = append(fields, user.FieldDeletedAt)
	}
	return fields
}

// FieldCleared returns a boolean indicating if a field with the given name was
// cleared in this mutation.
func (m *UserMutation) FieldCleared(name string) bool {
	_, ok := m.clearedFields[name]
	return ok
}

// ClearField clears the value of the field with the given name. It returns an
// error if the field is not defined in the schema.
func (m *UserMutation) ClearField(name string) error {
	switch name {
	case user.FieldDeletedAt:
		m.ClearDeletedAt()
		return nil
	}
	return fmt.Errorf("unknown User nullable field %s", name)
}

// ResetField resets all changes in the mutation for the field with the given name.
// It returns an error if the field is not defined in the schema.
func (m *UserMutation) ResetField(name string) error {
	switch name {
	case user.FieldUsername:
		m.ResetUsername()
		return nil
	case user.FieldPassword:
		m.ResetPassword()
		return nil
	case user.FieldRole:
		m.ResetRole()
		return nil
	case user.FieldCreatedAt:
		m.ResetCreatedAt()
		return nil
	case user.FieldUpdatedAt:
		m.ResetUpdatedAt()
		return nil
	case user.FieldDeletedAt:
		m.ResetDeletedAt()
		return nil
	}
	return fmt.Errorf("unknown User field %s", name)
}

// AddedEdges returns all edge names that were set/added in this mutation.
func (m *UserMutation) AddedEdges() []string {
	edges := make([]string, 0, 5)
	if m.tokens != nil {
		edges = append(edges, user.EdgeTokens)
	}
	if m.subscribed_feeds != nil {
		edges = append(edges, user.EdgeSubscribedFeeds)
	}
	if m.read_items != nil {
		edges = append(edges, user.EdgeReadItems)
	}
	if m.subscriptions != nil {
		edges = append(edges, user.EdgeSubscriptions)
	}
	if m.reads != nil {
		edges = append(edges, user.EdgeReads)
	}
	return edges
}

// AddedIDs returns all IDs (to other nodes) that were added for the given edge
// name in this mutation.
func (m *UserMutation) AddedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeTokens:
		ids := make([]ent.Value, 0, len(m.tokens))
		for id := range m.tokens {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeSubscribedFeeds:
		ids := make([]ent.Value, 0, len(m.subscribed_feeds))
		for id := range m.subscribed_feeds {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeReadItems:
		ids := make([]ent.Value, 0, len(m.read_items))
		for id := range m.read_items {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeSubscriptions:
		ids := make([]ent.Value, 0, len(m.subscriptions))
		for id := range m.subscriptions {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeReads:
		ids := make([]ent.Value, 0, len(m.reads))
		for id := range m.reads {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// RemovedEdges returns all edge names that were removed in this mutation.
func (m *UserMutation) RemovedEdges() []string {
	edges := make([]string, 0, 5)
	if m.removedtokens != nil {
		edges = append(edges, user.EdgeTokens)
	}
	if m.removedsubscribed_feeds != nil {
		edges = append(edges, user.EdgeSubscribedFeeds)
	}
	if m.removedread_items != nil {
		edges = append(edges, user.EdgeReadItems)
	}
	if m.removedsubscriptions != nil {
		edges = append(edges, user.EdgeSubscriptions)
	}
	if m.removedreads != nil {
		edges = append(edges, user.EdgeReads)
	}
	return edges
}

// RemovedIDs returns all IDs (to other nodes) that were removed for the edge with
// the given name in this mutation.
func (m *UserMutation) RemovedIDs(name string) []ent.Value {
	switch name {
	case user.EdgeTokens:
		ids := make([]ent.Value, 0, len(m.removedtokens))
		for id := range m.removedtokens {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeSubscribedFeeds:
		ids := make([]ent.Value, 0, len(m.removedsubscribed_feeds))
		for id := range m.removedsubscribed_feeds {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeReadItems:
		ids := make([]ent.Value, 0, len(m.removedread_items))
		for id := range m.removedread_items {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeSubscriptions:
		ids := make([]ent.Value, 0, len(m.removedsubscriptions))
		for id := range m.removedsubscriptions {
			ids = append(ids, id)
		}
		return ids
	case user.EdgeReads:
		ids := make([]ent.Value, 0, len(m.removedreads))
		for id := range m.removedreads {
			ids = append(ids, id)
		}
		return ids
	}
	return nil
}

// ClearedEdges returns all edge names that were cleared in this mutation.
func (m *UserMutation) ClearedEdges() []string {
	edges := make([]string, 0, 5)
	if m.clearedtokens {
		edges = append(edges, user.EdgeTokens)
	}
	if m.clearedsubscribed_feeds {
		edges = append(edges, user.EdgeSubscribedFeeds)
	}
	if m.clearedread_items {
		edges = append(edges, user.EdgeReadItems)
	}
	if m.clearedsubscriptions {
		edges = append(edges, user.EdgeSubscriptions)
	}
	if m.clearedreads {
		edges = append(edges, user.EdgeReads)
	}
	return edges
}

// EdgeCleared returns a boolean which indicates if the edge with the given name
// was cleared in this mutation.
func (m *UserMutation) EdgeCleared(name string) bool {
	switch name {
	case user.EdgeTokens:
		return m.clearedtokens
	case user.EdgeSubscribedFeeds:
		return m.clearedsubscribed_feeds
	case user.EdgeReadItems:
		return m.clearedread_items
	case user.EdgeSubscriptions:
		return m.clearedsubscriptions
	case user.EdgeReads:
		return m.clearedreads
	}
	return false
}

// ClearEdge clears the value of the edge with the given name. It returns an error
// if that edge is not defined in the schema.
func (m *UserMutation) ClearEdge(name string) error {
	switch name {
	}
	return fmt.Errorf("unknown User unique edge %s", name)
}

// ResetEdge resets all changes to the edge with the given name in this mutation.
// It returns an error if the edge is not defined in the schema.
func (m *UserMutation) ResetEdge(name string) error {
	switch name {
	case user.EdgeTokens:
		m.ResetTokens()
		return nil
	case user.EdgeSubscribedFeeds:
		m.ResetSubscribedFeeds()
		return nil
	case user.EdgeReadItems:
		m.ResetReadItems()
		return nil
	case user.EdgeSubscriptions:
		m.ResetSubscriptions()
		return nil
	case user.EdgeReads:
		m.ResetReads()
		return nil
	}
	return fmt.Errorf("unknown User edge %s", name)
}
