// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// OS Management Hub API
//
// Use the OS Management Hub API to manage and monitor updates and patches for instances in OCI, your private data center, or 3rd-party clouds.
// For more information, see Overview of OS Management Hub (https://docs.oracle.com/iaas/osmh/doc/overview.htm).
//

package osmanagementhub

import (
	"strings"
)

// EventStatusEnum Enum with underlying type: string
type EventStatusEnum string

// Set of constants representing the allowable values for EventStatusEnum
const (
	EventStatusSucceeded EventStatusEnum = "SUCCEEDED"
	EventStatusFailed    EventStatusEnum = "FAILED"
)

var mappingEventStatusEnum = map[string]EventStatusEnum{
	"SUCCEEDED": EventStatusSucceeded,
	"FAILED":    EventStatusFailed,
}

var mappingEventStatusEnumLowerCase = map[string]EventStatusEnum{
	"succeeded": EventStatusSucceeded,
	"failed":    EventStatusFailed,
}

// GetEventStatusEnumValues Enumerates the set of values for EventStatusEnum
func GetEventStatusEnumValues() []EventStatusEnum {
	values := make([]EventStatusEnum, 0)
	for _, v := range mappingEventStatusEnum {
		values = append(values, v)
	}
	return values
}

// GetEventStatusEnumStringValues Enumerates the set of values in String for EventStatusEnum
func GetEventStatusEnumStringValues() []string {
	return []string{
		"SUCCEEDED",
		"FAILED",
	}
}

// GetMappingEventStatusEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingEventStatusEnum(val string) (EventStatusEnum, bool) {
	enum, ok := mappingEventStatusEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
