// Code generated by pigeon; DO NOT EDIT.

package internal

import (
	"bytes"
	"crypto/sha256"
	"encoding/hex"
	"errors"
	"fmt"
	"io"
	"io/ioutil"
	"math"
	"net"
	"net/url"
	"os"
	"path"
	"sort"
	"strconv"
	"strings"
	"unicode"
	"unicode/utf8"

	. "github.com/philandstuff/dhall-golang/v6/term"
)

// Helper function for parsing all the operator parsing blocks
// see OrExpression for an example of how this is used
func parseOperator(opcode OpCode, first, rest interface{}) Term {
	out := first.(Term)
	if rest == nil {
		return out
	}
	for _, b := range rest.([]interface{}) {
		nextTerm := b.([]interface{})[3].(Term)
		out = Op{OpCode: opcode, L: out, R: nextTerm}
	}
	return out
}

func isNonCharacter(r rune) bool {
	return r&0xfffe == 0xfffe
}

func validCodepoint(r rune) bool {
	return utf8.ValidRune(r) && !isNonCharacter(r)
}

// Helper for parsing unicode code points
func parseCodepoint(codepointText string) ([]byte, error) {
	i, err := strconv.ParseInt(codepointText, 16, 32)
	if err != nil {
		return nil, err
	}
	r := rune(i)
	if !validCodepoint(r) {
		return nil, fmt.Errorf("%s is not a valid unicode code point", codepointText)
	}
	return []byte(string([]rune{r})), nil
}

var g = &grammar{
	rules: []*rule{
		{
			name: "DhallFile",
			pos:  position{line: 67, col: 1, offset: 1552},
			expr: &actionExpr{
				pos: position{line: 67, col: 13, offset: 1566},
				run: (*parser).callonDhallFile1,
				expr: &seqExpr{
					pos: position{line: 67, col: 13, offset: 1566},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 67, col: 13, offset: 1566},
							label: "e",
							expr: &ruleRefExpr{
								pos:  position{line: 67, col: 15, offset: 1568},
								name: "CompleteExpression",
							},
						},
						&notExpr{
							pos: position{line: 69, col: 7, offset: 1618},
							expr: &anyMatcher{
								line: 69, col: 8, offset: 1619,
							},
						},
					},
				},
			},
		},
		{
			name: "BlockComment",
			pos:  position{line: 93, col: 1, offset: 2183},
			expr: &seqExpr{
				pos: position{line: 93, col: 16, offset: 2200},
				exprs: []interface{}{
					&litMatcher{
						pos:        position{line: 93, col: 16, offset: 2200},
						val:        "{-",
						ignoreCase: false,
						want:       "\"{-\"",
					},
					&ruleRefExpr{
						pos:  position{line: 93, col: 21, offset: 2205},
						name: "BlockCommentContinue",
					},
				},
			},
		},
		{
			name: "BlockCommentContinue",
			pos:  position{line: 101, col: 1, offset: 2300},
			expr: &choiceExpr{
				pos: position{line: 102, col: 7, offset: 2331},
				alternatives: []interface{}{
					&litMatcher{
						pos:        position{line: 102, col: 7, offset: 2331},
						val:        "-}",
						ignoreCase: false,
						want:       "\"-}\"",
					},
					&seqExpr{
						pos: position{line: 103, col: 7, offset: 2342},
						exprs: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 103, col: 7, offset: 2342},
								name: "BlockComment",
							},
							&ruleRefExpr{
								pos:  position{line: 103, col: 20, offset: 2355},
								name: "BlockCommentContinue",
							},
						},
					},
					&seqExpr{
						pos: position{line: 104, col: 7, offset: 2382},
						exprs: []interface{}{
							&choiceExpr{
								pos: position{line: 96, col: 5, offset: 2252},
								alternatives: []interface{}{
									&charClassMatcher{
										pos:        position{line: 96, col: 5, offset: 2252},
										val:        "[𐀀D\\t\\n -\\u007f\\u0080-\\ud7ff\\ue000-�𐀀-\\U0001fffd𠀀-\\U0002fffd\\U00030000-\\U0003fffd\\U00040000-\\U0004fffd\\U00050000-\\U0005fffd\\U00060000-\\U0006fffd\\U00070000-\\U0007fffd\\U00080000-\\U0008fffd\\U00090000-\\U0009fffd\\U000a0000-\\U000afffd\\U000b0000-\\U000bfffd\\U000c0000-\\U000cfffd\\U000d0000-\\U000dfffd\\U000e0000-\\U000efffd\\U000f0000-\\U000ffffd0-\\U00010fff]",
										chars:      []rune{'𐀀', 'D', '\t', '\n'},
										ranges:     []rune{' ', '\u007f', '\u0080', '\ud7ff', '\ue000', '�', '𐀀', '\U0001fffd', '𠀀', '\U0002fffd', '\U00030000', '\U0003fffd', '\U00040000', '\U0004fffd', '\U00050000', '\U0005fffd', '\U00060000', '\U0006fffd', '\U00070000', '\U0007fffd', '\U00080000', '\U0008fffd', '\U00090000', '\U0009fffd', '\U000a0000', '\U000afffd', '\U000b0000', '\U000bfffd', '\U000c0000', '\U000cfffd', '\U000d0000', '\U000dfffd', '\U000e0000', '\U000efffd', '\U000f0000', '\U000ffffd', '0', '\U00010fff'},
										ignoreCase: false,
										inverted:   false,
									},
									&actionExpr{
										pos: position{line: 71, col: 14, offset: 1637},
										run: (*parser).callonBlockCommentContinue9,
										expr: &litMatcher{
											pos:        position{line: 71, col: 14, offset: 1637},
											val:        "\r\n",
											ignoreCase: false,
											want:       "\"\\r\\n\"",
										},
									},
								},
							},
							&ruleRefExpr{
								pos:  position{line: 104, col: 24, offset: 2399},
								name: "BlockCommentContinue",
							},
						},
					},
				},
			},
		},
		{
			name: "WhitespaceChunk",
			pos:  position{line: 110, col: 1, offset: 2566},
			expr: &choiceExpr{
				pos: position{line: 110, col: 19, offset: 2586},
				alternatives: []interface{}{
					&charClassMatcher{
						pos:        position{line: 110, col: 19, offset: 2586},
						val:        "[ \\t\\n]",
						chars:      []rune{' ', '\t', '\n'},
						ignoreCase: false,
						inverted:   false,
					},
					&actionExpr{
						pos: position{line: 71, col: 14, offset: 1637},
						run: (*parser).callonWhitespaceChunk3,
						expr: &litMatcher{
							pos:        position{line: 71, col: 14, offset: 1637},
							val:        "\r\n",
							ignoreCase: false,
							want:       "\"\\r\\n\"",
						},
					},
					&actionExpr{
						pos: position{line: 108, col: 15, offset: 2484},
						run: (*parser).callonWhitespaceChunk5,
						expr: &seqExpr{
							pos: position{line: 108, col: 15, offset: 2484},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 108, col: 15, offset: 2484},
									val:        "--",
									ignoreCase: false,
									want:       "\"--\"",
								},
								&labeledExpr{
									pos:   position{line: 108, col: 20, offset: 2489},
									label: "content",
									expr: &actionExpr{
										pos: position{line: 108, col: 29, offset: 2498},
										run: (*parser).callonWhitespaceChunk9,
										expr: &zeroOrMoreExpr{
											pos: position{line: 108, col: 29, offset: 2498},
											expr: &charClassMatcher{
												pos:        position{line: 106, col: 10, offset: 2432},
												val:        "[𐀀D\\t -\\u007f\\u0080-\\ud7ff\\ue000-�𐀀-\\U0001fffd𠀀-\\U0002fffd\\U00030000-\\U0003fffd\\U00040000-\\U0004fffd\\U00050000-\\U0005fffd\\U00060000-\\U0006fffd\\U00070000-\\U0007fffd\\U00080000-\\U0008fffd\\U00090000-\\U0009fffd\\U000a0000-\\U000afffd\\U000b0000-\\U000bfffd\\U000c0000-\\U000cfffd\\U000d0000-\\U000dfffd\\U000e0000-\\U000efffd\\U000f0000-\\U000ffffd0-\\U00010fff]",
												chars:      []rune{'𐀀', 'D', '\t'},
												ranges:     []rune{' ', '\u007f', '\u0080', '\ud7ff', '\ue000', '�', '𐀀', '\U0001fffd', '𠀀', '\U0002fffd', '\U00030000', '\U0003fffd', '\U00040000', '\U0004fffd', '\U00050000', '\U0005fffd', '\U00060000', '\U0006fffd', '\U00070000', '\U0007fffd', '\U00080000', '\U0008fffd', '\U00090000', '\U0009fffd', '\U000a0000', '\U000afffd', '\U000b0000', '\U000bfffd', '\U000c0000', '\U000cfffd', '\U000d0000', '\U000dfffd', '\U000e0000', '\U000efffd', '\U000f0000', '\U000ffffd', '0', '\U00010fff'},
												ignoreCase: false,
												inverted:   false,
											},
										},
									},
								},
								&choiceExpr{
									pos: position{line: 71, col: 7, offset: 1630},
									alternatives: []interface{}{
										&litMatcher{
											pos:        position{line: 71, col: 7, offset: 1630},
											val:        "\n",
											ignoreCase: false,
											want:       "\"\\n\"",
										},
										&actionExpr{
											pos: position{line: 71, col: 14, offset: 1637},
											run: (*parser).callonWhitespaceChunk14,
											expr: &litMatcher{
												pos:        position{line: 71, col: 14, offset: 1637},
												val:        "\r\n",
												ignoreCase: false,
												want:       "\"\\r\\n\"",
											},
										},
									},
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 110, col: 52, offset: 2619},
						name: "BlockComment",
					},
				},
			},
		},
		{
			name: "_",
			pos:  position{line: 112, col: 1, offset: 2633},
			expr: &zeroOrMoreExpr{
				pos: position{line: 112, col: 5, offset: 2639},
				expr: &ruleRefExpr{
					pos:  position{line: 112, col: 5, offset: 2639},
					name: "WhitespaceChunk",
				},
			},
		},
		{
			name: "_1",
			pos:  position{line: 114, col: 1, offset: 2657},
			expr: &oneOrMoreExpr{
				pos: position{line: 114, col: 6, offset: 2664},
				expr: &ruleRefExpr{
					pos:  position{line: 114, col: 6, offset: 2664},
					name: "WhitespaceChunk",
				},
			},
		},
		{
			name: "DoubleQuoteChunk",
			pos:  position{line: 142, col: 1, offset: 3452},
			expr: &choiceExpr{
				pos: position{line: 143, col: 6, offset: 3478},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 143, col: 6, offset: 3478},
						name: "Interpolation",
					},
					&actionExpr{
						pos: position{line: 144, col: 6, offset: 3497},
						run: (*parser).callonDoubleQuoteChunk3,
						expr: &seqExpr{
							pos: position{line: 144, col: 6, offset: 3497},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 144, col: 6, offset: 3497},
									val:        "\\",
									ignoreCase: false,
									want:       "\"\\\\\"",
								},
								&labeledExpr{
									pos:   position{line: 144, col: 11, offset: 3502},
									label: "e",
									expr: &choiceExpr{
										pos: position{line: 148, col: 8, offset: 3593},
										alternatives: []interface{}{
											&charClassMatcher{
												pos:        position{line: 148, col: 8, offset: 3593},
												val:        "[\"$\\\\/]",
												chars:      []rune{'"', '$', '\\', '/'},
												ignoreCase: false,
												inverted:   false,
											},
											&actionExpr{
												pos: position{line: 152, col: 8, offset: 3638},
												run: (*parser).callonDoubleQuoteChunk9,
												expr: &litMatcher{
													pos:        position{line: 152, col: 8, offset: 3638},
													val:        "b",
													ignoreCase: false,
													want:       "\"b\"",
												},
											},
											&actionExpr{
												pos: position{line: 153, col: 8, offset: 3678},
												run: (*parser).callonDoubleQuoteChunk11,
												expr: &litMatcher{
													pos:        position{line: 153, col: 8, offset: 3678},
													val:        "f",
													ignoreCase: false,
													want:       "\"f\"",
												},
											},
											&actionExpr{
												pos: position{line: 154, col: 8, offset: 3718},
												run: (*parser).callonDoubleQuoteChunk13,
												expr: &litMatcher{
													pos:        position{line: 154, col: 8, offset: 3718},
													val:        "n",
													ignoreCase: false,
													want:       "\"n\"",
												},
											},
											&actionExpr{
												pos: position{line: 155, col: 8, offset: 3758},
												run: (*parser).callonDoubleQuoteChunk15,
												expr: &litMatcher{
													pos:        position{line: 155, col: 8, offset: 3758},
													val:        "r",
													ignoreCase: false,
													want:       "\"r\"",
												},
											},
											&actionExpr{
												pos: position{line: 156, col: 8, offset: 3798},
												run: (*parser).callonDoubleQuoteChunk17,
												expr: &litMatcher{
													pos:        position{line: 156, col: 8, offset: 3798},
													val:        "t",
													ignoreCase: false,
													want:       "\"t\"",
												},
											},
											&actionExpr{
												pos: position{line: 157, col: 8, offset: 3838},
												run: (*parser).callonDoubleQuoteChunk19,
												expr: &seqExpr{
													pos: position{line: 157, col: 8, offset: 3838},
													exprs: []interface{}{
														&litMatcher{
															pos:        position{line: 157, col: 8, offset: 3838},
															val:        "u",
															ignoreCase: false,
															want:       "\"u\"",
														},
														&labeledExpr{
															pos:   position{line: 157, col: 12, offset: 3842},
															label: "u",
															expr: &choiceExpr{
																pos: position{line: 160, col: 9, offset: 3903},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 160, col: 9, offset: 3903},
																		run: (*parser).callonDoubleQuoteChunk24,
																		expr: &seqExpr{
																			pos: position{line: 160, col: 9, offset: 3903},
																			exprs: []interface{}{
																				&choiceExpr{
																					pos: position{line: 118, col: 10, offset: 2710},
																					alternatives: []interface{}{
																						&charClassMatcher{
																							pos:        position{line: 116, col: 9, offset: 2692},
																							val:        "[0-9]",
																							ranges:     []rune{'0', '9'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&charClassMatcher{
																							pos:        position{line: 118, col: 18, offset: 2718},
																							val:        "[a-f]i",
																							ranges:     []rune{'a', 'f'},
																							ignoreCase: true,
																							inverted:   false,
																						},
																					},
																				},
																				&choiceExpr{
																					pos: position{line: 118, col: 10, offset: 2710},
																					alternatives: []interface{}{
																						&charClassMatcher{
																							pos:        position{line: 116, col: 9, offset: 2692},
																							val:        "[0-9]",
																							ranges:     []rune{'0', '9'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&charClassMatcher{
																							pos:        position{line: 118, col: 18, offset: 2718},
																							val:        "[a-f]i",
																							ranges:     []rune{'a', 'f'},
																							ignoreCase: true,
																							inverted:   false,
																						},
																					},
																				},
																				&choiceExpr{
																					pos: position{line: 118, col: 10, offset: 2710},
																					alternatives: []interface{}{
																						&charClassMatcher{
																							pos:        position{line: 116, col: 9, offset: 2692},
																							val:        "[0-9]",
																							ranges:     []rune{'0', '9'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&charClassMatcher{
																							pos:        position{line: 118, col: 18, offset: 2718},
																							val:        "[a-f]i",
																							ranges:     []rune{'a', 'f'},
																							ignoreCase: true,
																							inverted:   false,
																						},
																					},
																				},
																				&choiceExpr{
																					pos: position{line: 118, col: 10, offset: 2710},
																					alternatives: []interface{}{
																						&charClassMatcher{
																							pos:        position{line: 116, col: 9, offset: 2692},
																							val:        "[0-9]",
																							ranges:     []rune{'0', '9'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&charClassMatcher{
																							pos:        position{line: 118, col: 18, offset: 2718},
																							val:        "[a-f]i",
																							ranges:     []rune{'a', 'f'},
																							ignoreCase: true,
																							inverted:   false,
																						},
																					},
																				},
																			},
																		},
																	},
																	&actionExpr{
																		pos: position{line: 163, col: 9, offset: 4001},
																		run: (*parser).callonDoubleQuoteChunk38,
																		expr: &seqExpr{
																			pos: position{line: 163, col: 9, offset: 4001},
																			exprs: []interface{}{
																				&litMatcher{
																					pos:        position{line: 163, col: 9, offset: 4001},
																					val:        "{",
																					ignoreCase: false,
																					want:       "\"{\"",
																				},
																				&oneOrMoreExpr{
																					pos: position{line: 163, col: 13, offset: 4005},
																					expr: &choiceExpr{
																						pos: position{line: 118, col: 10, offset: 2710},
																						alternatives: []interface{}{
																							&charClassMatcher{
																								pos:        position{line: 116, col: 9, offset: 2692},
																								val:        "[0-9]",
																								ranges:     []rune{'0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																							&charClassMatcher{
																								pos:        position{line: 118, col: 18, offset: 2718},
																								val:        "[a-f]i",
																								ranges:     []rune{'a', 'f'},
																								ignoreCase: true,
																								inverted:   false,
																							},
																						},
																					},
																				},
																				&litMatcher{
																					pos:        position{line: 163, col: 21, offset: 4013},
																					val:        "}",
																					ignoreCase: false,
																					want:       "\"}\"",
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
					},
					&charClassMatcher{
						pos:        position{line: 168, col: 6, offset: 4122},
						val:        "[𐀀D -!#-[]-\\u007f\\u0080-\\ud7ff\\ue000-�𐀀-\\U0001fffd𠀀-\\U0002fffd\\U00030000-\\U0003fffd\\U00040000-\\U0004fffd\\U00050000-\\U0005fffd\\U00060000-\\U0006fffd\\U00070000-\\U0007fffd\\U00080000-\\U0008fffd\\U00090000-\\U0009fffd\\U000a0000-\\U000afffd\\U000b0000-\\U000bfffd\\U000c0000-\\U000cfffd\\U000d0000-\\U000dfffd\\U000e0000-\\U000efffd\\U000f0000-\\U000ffffd0-\\U00010fff]",
						chars:      []rune{'𐀀', 'D'},
						ranges:     []rune{' ', '!', '#', '[', ']', '\u007f', '\u0080', '\ud7ff', '\ue000', '�', '𐀀', '\U0001fffd', '𠀀', '\U0002fffd', '\U00030000', '\U0003fffd', '\U00040000', '\U0004fffd', '\U00050000', '\U0005fffd', '\U00060000', '\U0006fffd', '\U00070000', '\U0007fffd', '\U00080000', '\U0008fffd', '\U00090000', '\U0009fffd', '\U000a0000', '\U000afffd', '\U000b0000', '\U000bfffd', '\U000c0000', '\U000cfffd', '\U000d0000', '\U000dfffd', '\U000e0000', '\U000efffd', '\U000f0000', '\U000ffffd', '0', '\U00010fff'},
						ignoreCase: false,
						inverted:   false,
					},
				},
			},
		},
		{
			name: "DoubleQuoteLiteral",
			pos:  position{line: 173, col: 1, offset: 4188},
			expr: &actionExpr{
				pos: position{line: 173, col: 22, offset: 4211},
				run: (*parser).callonDoubleQuoteLiteral1,
				expr: &seqExpr{
					pos: position{line: 173, col: 22, offset: 4211},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 173, col: 22, offset: 4211},
							val:        "\"",
							ignoreCase: false,
							want:       "\"\\\"\"",
						},
						&labeledExpr{
							pos:   position{line: 173, col: 26, offset: 4215},
							label: "chunks",
							expr: &zeroOrMoreExpr{
								pos: position{line: 173, col: 33, offset: 4222},
								expr: &ruleRefExpr{
									pos:  position{line: 173, col: 33, offset: 4222},
									name: "DoubleQuoteChunk",
								},
							},
						},
						&litMatcher{
							pos:        position{line: 173, col: 51, offset: 4240},
							val:        "\"",
							ignoreCase: false,
							want:       "\"\\\"\"",
						},
					},
				},
			},
		},
		{
			name: "SingleQuoteContinue",
			pos:  position{line: 190, col: 1, offset: 4708},
			expr: &choiceExpr{
				pos: position{line: 191, col: 7, offset: 4738},
				alternatives: []interface{}{
					&seqExpr{
						pos: position{line: 191, col: 7, offset: 4738},
						exprs: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 191, col: 7, offset: 4738},
								name: "Interpolation",
							},
							&ruleRefExpr{
								pos:  position{line: 191, col: 21, offset: 4752},
								name: "SingleQuoteContinue",
							},
						},
					},
					&seqExpr{
						pos: position{line: 192, col: 7, offset: 4778},
						exprs: []interface{}{
							&actionExpr{
								pos: position{line: 197, col: 20, offset: 4937},
								run: (*parser).callonSingleQuoteContinue6,
								expr: &litMatcher{
									pos:        position{line: 197, col: 20, offset: 4937},
									val:        "'''",
									ignoreCase: false,
									want:       "\"'''\"",
								},
							},
							&ruleRefExpr{
								pos:  position{line: 192, col: 24, offset: 4795},
								name: "SingleQuoteContinue",
							},
						},
					},
					&seqExpr{
						pos: position{line: 193, col: 7, offset: 4821},
						exprs: []interface{}{
							&actionExpr{
								pos: position{line: 201, col: 24, offset: 5097},
								run: (*parser).callonSingleQuoteContinue10,
								expr: &litMatcher{
									pos:        position{line: 201, col: 24, offset: 5097},
									val:        "''${",
									ignoreCase: false,
									want:       "\"''${\"",
								},
							},
							&ruleRefExpr{
								pos:  position{line: 193, col: 28, offset: 4842},
								name: "SingleQuoteContinue",
							},
						},
					},
					&litMatcher{
						pos:        position{line: 194, col: 7, offset: 4868},
						val:        "''",
						ignoreCase: false,
						want:       "\"''\"",
					},
					&seqExpr{
						pos: position{line: 195, col: 7, offset: 4879},
						exprs: []interface{}{
							&choiceExpr{
								pos: position{line: 204, col: 6, offset: 5164},
								alternatives: []interface{}{
									&charClassMatcher{
										pos:        position{line: 204, col: 6, offset: 5164},
										val:        "[𐀀D\\t\\n -\\u007f\\u0080-\\ud7ff\\ue000-�𐀀-\\U0001fffd𠀀-\\U0002fffd\\U00030000-\\U0003fffd\\U00040000-\\U0004fffd\\U00050000-\\U0005fffd\\U00060000-\\U0006fffd\\U00070000-\\U0007fffd\\U00080000-\\U0008fffd\\U00090000-\\U0009fffd\\U000a0000-\\U000afffd\\U000b0000-\\U000bfffd\\U000c0000-\\U000cfffd\\U000d0000-\\U000dfffd\\U000e0000-\\U000efffd\\U000f0000-\\U000ffffd0-\\U00010fff]",
										chars:      []rune{'𐀀', 'D', '\t', '\n'},
										ranges:     []rune{' ', '\u007f', '\u0080', '\ud7ff', '\ue000', '�', '𐀀', '\U0001fffd', '𠀀', '\U0002fffd', '\U00030000', '\U0003fffd', '\U00040000', '\U0004fffd', '\U00050000', '\U0005fffd', '\U00060000', '\U0006fffd', '\U00070000', '\U0007fffd', '\U00080000', '\U0008fffd', '\U00090000', '\U0009fffd', '\U000a0000', '\U000afffd', '\U000b0000', '\U000bfffd', '\U000c0000', '\U000cfffd', '\U000d0000', '\U000dfffd', '\U000e0000', '\U000efffd', '\U000f0000', '\U000ffffd', '0', '\U00010fff'},
										ignoreCase: false,
										inverted:   false,
									},
									&actionExpr{
										pos: position{line: 71, col: 14, offset: 1637},
										run: (*parser).callonSingleQuoteContinue17,
										expr: &litMatcher{
											pos:        position{line: 71, col: 14, offset: 1637},
											val:        "\r\n",
											ignoreCase: false,
											want:       "\"\\r\\n\"",
										},
									},
								},
							},
							&ruleRefExpr{
								pos:  position{line: 195, col: 23, offset: 4895},
								name: "SingleQuoteContinue",
							},
						},
					},
				},
			},
		},
		{
			name: "SingleQuoteLiteral",
			pos:  position{line: 209, col: 1, offset: 5215},
			expr: &actionExpr{
				pos: position{line: 209, col: 22, offset: 5238},
				run: (*parser).callonSingleQuoteLiteral1,
				expr: &seqExpr{
					pos: position{line: 209, col: 22, offset: 5238},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 209, col: 22, offset: 5238},
							val:        "''",
							ignoreCase: false,
							want:       "\"''\"",
						},
						&choiceExpr{
							pos: position{line: 71, col: 7, offset: 1630},
							alternatives: []interface{}{
								&litMatcher{
									pos:        position{line: 71, col: 7, offset: 1630},
									val:        "\n",
									ignoreCase: false,
									want:       "\"\\n\"",
								},
								&actionExpr{
									pos: position{line: 71, col: 14, offset: 1637},
									run: (*parser).callonSingleQuoteLiteral6,
									expr: &litMatcher{
										pos:        position{line: 71, col: 14, offset: 1637},
										val:        "\r\n",
										ignoreCase: false,
										want:       "\"\\r\\n\"",
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 209, col: 31, offset: 5247},
							label: "content",
							expr: &ruleRefExpr{
								pos:  position{line: 209, col: 39, offset: 5255},
								name: "SingleQuoteContinue",
							},
						},
					},
				},
			},
		},
		{
			name: "Interpolation",
			pos:  position{line: 227, col: 1, offset: 5805},
			expr: &actionExpr{
				pos: position{line: 227, col: 17, offset: 5823},
				run: (*parser).callonInterpolation1,
				expr: &seqExpr{
					pos: position{line: 227, col: 17, offset: 5823},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 227, col: 17, offset: 5823},
							val:        "${",
							ignoreCase: false,
							want:       "\"${\"",
						},
						&labeledExpr{
							pos:   position{line: 227, col: 22, offset: 5828},
							label: "e",
							expr: &ruleRefExpr{
								pos:  position{line: 227, col: 24, offset: 5830},
								name: "CompleteExpression",
							},
						},
						&litMatcher{
							pos:        position{line: 227, col: 43, offset: 5849},
							val:        "}",
							ignoreCase: false,
							want:       "\"}\"",
						},
					},
				},
			},
		},
		{
			name: "TextLiteral",
			pos:  position{line: 229, col: 1, offset: 5872},
			expr: &choiceExpr{
				pos: position{line: 229, col: 15, offset: 5888},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 229, col: 15, offset: 5888},
						name: "DoubleQuoteLiteral",
					},
					&ruleRefExpr{
						pos:  position{line: 229, col: 36, offset: 5909},
						name: "SingleQuoteLiteral",
					},
				},
			},
		},
		{
			name: "Identifier",
			pos:  position{line: 335, col: 1, offset: 9059},
			expr: &choiceExpr{
				pos: position{line: 335, col: 14, offset: 9074},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 335, col: 14, offset: 9074},
						name: "Variable",
					},
					&actionExpr{
						pos: position{line: 259, col: 5, offset: 6416},
						run: (*parser).callonIdentifier3,
						expr: &litMatcher{
							pos:        position{line: 259, col: 5, offset: 6416},
							val:        "Natural/fold",
							ignoreCase: false,
							want:       "\"Natural/fold\"",
						},
					},
					&actionExpr{
						pos: position{line: 260, col: 5, offset: 6463},
						run: (*parser).callonIdentifier5,
						expr: &litMatcher{
							pos:        position{line: 260, col: 5, offset: 6463},
							val:        "Natural/build",
							ignoreCase: false,
							want:       "\"Natural/build\"",
						},
					},
					&actionExpr{
						pos: position{line: 261, col: 5, offset: 6512},
						run: (*parser).callonIdentifier7,
						expr: &litMatcher{
							pos:        position{line: 261, col: 5, offset: 6512},
							val:        "Natural/isZero",
							ignoreCase: false,
							want:       "\"Natural/isZero\"",
						},
					},
					&actionExpr{
						pos: position{line: 262, col: 5, offset: 6563},
						run: (*parser).callonIdentifier9,
						expr: &litMatcher{
							pos:        position{line: 262, col: 5, offset: 6563},
							val:        "Natural/even",
							ignoreCase: false,
							want:       "\"Natural/even\"",
						},
					},
					&actionExpr{
						pos: position{line: 263, col: 5, offset: 6610},
						run: (*parser).callonIdentifier11,
						expr: &litMatcher{
							pos:        position{line: 263, col: 5, offset: 6610},
							val:        "Natural/odd",
							ignoreCase: false,
							want:       "\"Natural/odd\"",
						},
					},
					&actionExpr{
						pos: position{line: 264, col: 5, offset: 6655},
						run: (*parser).callonIdentifier13,
						expr: &litMatcher{
							pos:        position{line: 264, col: 5, offset: 6655},
							val:        "Natural/toInteger",
							ignoreCase: false,
							want:       "\"Natural/toInteger\"",
						},
					},
					&actionExpr{
						pos: position{line: 265, col: 5, offset: 6712},
						run: (*parser).callonIdentifier15,
						expr: &litMatcher{
							pos:        position{line: 265, col: 5, offset: 6712},
							val:        "Natural/show",
							ignoreCase: false,
							want:       "\"Natural/show\"",
						},
					},
					&actionExpr{
						pos: position{line: 266, col: 5, offset: 6759},
						run: (*parser).callonIdentifier17,
						expr: &litMatcher{
							pos:        position{line: 266, col: 5, offset: 6759},
							val:        "Integer/toDouble",
							ignoreCase: false,
							want:       "\"Integer/toDouble\"",
						},
					},
					&actionExpr{
						pos: position{line: 267, col: 5, offset: 6814},
						run: (*parser).callonIdentifier19,
						expr: &litMatcher{
							pos:        position{line: 267, col: 5, offset: 6814},
							val:        "Integer/show",
							ignoreCase: false,
							want:       "\"Integer/show\"",
						},
					},
					&actionExpr{
						pos: position{line: 268, col: 5, offset: 6861},
						run: (*parser).callonIdentifier21,
						expr: &litMatcher{
							pos:        position{line: 268, col: 5, offset: 6861},
							val:        "Integer/negate",
							ignoreCase: false,
							want:       "\"Integer/negate\"",
						},
					},
					&actionExpr{
						pos: position{line: 269, col: 5, offset: 6912},
						run: (*parser).callonIdentifier23,
						expr: &litMatcher{
							pos:        position{line: 269, col: 5, offset: 6912},
							val:        "Integer/clamp",
							ignoreCase: false,
							want:       "\"Integer/clamp\"",
						},
					},
					&actionExpr{
						pos: position{line: 270, col: 5, offset: 6961},
						run: (*parser).callonIdentifier25,
						expr: &litMatcher{
							pos:        position{line: 270, col: 5, offset: 6961},
							val:        "Natural/subtract",
							ignoreCase: false,
							want:       "\"Natural/subtract\"",
						},
					},
					&actionExpr{
						pos: position{line: 271, col: 5, offset: 7016},
						run: (*parser).callonIdentifier27,
						expr: &litMatcher{
							pos:        position{line: 271, col: 5, offset: 7016},
							val:        "Double/show",
							ignoreCase: false,
							want:       "\"Double/show\"",
						},
					},
					&actionExpr{
						pos: position{line: 272, col: 5, offset: 7061},
						run: (*parser).callonIdentifier29,
						expr: &litMatcher{
							pos:        position{line: 272, col: 5, offset: 7061},
							val:        "List/build",
							ignoreCase: false,
							want:       "\"List/build\"",
						},
					},
					&actionExpr{
						pos: position{line: 273, col: 5, offset: 7104},
						run: (*parser).callonIdentifier31,
						expr: &litMatcher{
							pos:        position{line: 273, col: 5, offset: 7104},
							val:        "List/fold",
							ignoreCase: false,
							want:       "\"List/fold\"",
						},
					},
					&actionExpr{
						pos: position{line: 274, col: 5, offset: 7145},
						run: (*parser).callonIdentifier33,
						expr: &litMatcher{
							pos:        position{line: 274, col: 5, offset: 7145},
							val:        "List/length",
							ignoreCase: false,
							want:       "\"List/length\"",
						},
					},
					&actionExpr{
						pos: position{line: 275, col: 5, offset: 7190},
						run: (*parser).callonIdentifier35,
						expr: &litMatcher{
							pos:        position{line: 275, col: 5, offset: 7190},
							val:        "List/head",
							ignoreCase: false,
							want:       "\"List/head\"",
						},
					},
					&actionExpr{
						pos: position{line: 276, col: 5, offset: 7231},
						run: (*parser).callonIdentifier37,
						expr: &litMatcher{
							pos:        position{line: 276, col: 5, offset: 7231},
							val:        "List/last",
							ignoreCase: false,
							want:       "\"List/last\"",
						},
					},
					&actionExpr{
						pos: position{line: 277, col: 5, offset: 7272},
						run: (*parser).callonIdentifier39,
						expr: &litMatcher{
							pos:        position{line: 277, col: 5, offset: 7272},
							val:        "List/indexed",
							ignoreCase: false,
							want:       "\"List/indexed\"",
						},
					},
					&actionExpr{
						pos: position{line: 278, col: 5, offset: 7319},
						run: (*parser).callonIdentifier41,
						expr: &litMatcher{
							pos:        position{line: 278, col: 5, offset: 7319},
							val:        "List/reverse",
							ignoreCase: false,
							want:       "\"List/reverse\"",
						},
					},
					&actionExpr{
						pos: position{line: 279, col: 5, offset: 7366},
						run: (*parser).callonIdentifier43,
						expr: &litMatcher{
							pos:        position{line: 279, col: 5, offset: 7366},
							val:        "Text/show",
							ignoreCase: false,
							want:       "\"Text/show\"",
						},
					},
					&actionExpr{
						pos: position{line: 280, col: 5, offset: 7407},
						run: (*parser).callonIdentifier45,
						expr: &litMatcher{
							pos:        position{line: 280, col: 5, offset: 7407},
							val:        "Text/replace",
							ignoreCase: false,
							want:       "\"Text/replace\"",
						},
					},
					&actionExpr{
						pos: position{line: 281, col: 5, offset: 7454},
						run: (*parser).callonIdentifier47,
						expr: &litMatcher{
							pos:        position{line: 281, col: 5, offset: 7454},
							val:        "Bool",
							ignoreCase: false,
							want:       "\"Bool\"",
						},
					},
					&actionExpr{
						pos: position{line: 282, col: 5, offset: 7486},
						run: (*parser).callonIdentifier49,
						expr: &litMatcher{
							pos:        position{line: 282, col: 5, offset: 7486},
							val:        "True",
							ignoreCase: false,
							want:       "\"True\"",
						},
					},
					&actionExpr{
						pos: position{line: 283, col: 5, offset: 7518},
						run: (*parser).callonIdentifier51,
						expr: &litMatcher{
							pos:        position{line: 283, col: 5, offset: 7518},
							val:        "False",
							ignoreCase: false,
							want:       "\"False\"",
						},
					},
					&actionExpr{
						pos: position{line: 284, col: 5, offset: 7552},
						run: (*parser).callonIdentifier53,
						expr: &litMatcher{
							pos:        position{line: 284, col: 5, offset: 7552},
							val:        "Optional",
							ignoreCase: false,
							want:       "\"Optional\"",
						},
					},
					&actionExpr{
						pos: position{line: 285, col: 5, offset: 7592},
						run: (*parser).callonIdentifier55,
						expr: &litMatcher{
							pos:        position{line: 285, col: 5, offset: 7592},
							val:        "None",
							ignoreCase: false,
							want:       "\"None\"",
						},
					},
					&actionExpr{
						pos: position{line: 286, col: 5, offset: 7624},
						run: (*parser).callonIdentifier57,
						expr: &litMatcher{
							pos:        position{line: 286, col: 5, offset: 7624},
							val:        "Natural",
							ignoreCase: false,
							want:       "\"Natural\"",
						},
					},
					&actionExpr{
						pos: position{line: 287, col: 5, offset: 7662},
						run: (*parser).callonIdentifier59,
						expr: &litMatcher{
							pos:        position{line: 287, col: 5, offset: 7662},
							val:        "Integer",
							ignoreCase: false,
							want:       "\"Integer\"",
						},
					},
					&actionExpr{
						pos: position{line: 288, col: 5, offset: 7700},
						run: (*parser).callonIdentifier61,
						expr: &litMatcher{
							pos:        position{line: 288, col: 5, offset: 7700},
							val:        "Double",
							ignoreCase: false,
							want:       "\"Double\"",
						},
					},
					&actionExpr{
						pos: position{line: 289, col: 5, offset: 7736},
						run: (*parser).callonIdentifier63,
						expr: &litMatcher{
							pos:        position{line: 289, col: 5, offset: 7736},
							val:        "Text",
							ignoreCase: false,
							want:       "\"Text\"",
						},
					},
					&actionExpr{
						pos: position{line: 290, col: 5, offset: 7768},
						run: (*parser).callonIdentifier65,
						expr: &litMatcher{
							pos:        position{line: 290, col: 5, offset: 7768},
							val:        "List",
							ignoreCase: false,
							want:       "\"List\"",
						},
					},
					&actionExpr{
						pos: position{line: 291, col: 5, offset: 7800},
						run: (*parser).callonIdentifier67,
						expr: &litMatcher{
							pos:        position{line: 291, col: 5, offset: 7800},
							val:        "Type",
							ignoreCase: false,
							want:       "\"Type\"",
						},
					},
					&actionExpr{
						pos: position{line: 292, col: 5, offset: 7832},
						run: (*parser).callonIdentifier69,
						expr: &litMatcher{
							pos:        position{line: 292, col: 5, offset: 7832},
							val:        "Kind",
							ignoreCase: false,
							want:       "\"Kind\"",
						},
					},
					&actionExpr{
						pos: position{line: 293, col: 5, offset: 7864},
						run: (*parser).callonIdentifier71,
						expr: &litMatcher{
							pos:        position{line: 293, col: 5, offset: 7864},
							val:        "Sort",
							ignoreCase: false,
							want:       "\"Sort\"",
						},
					},
				},
			},
		},
		{
			name: "DeBruijn",
			pos:  position{line: 337, col: 1, offset: 9094},
			expr: &actionExpr{
				pos: position{line: 337, col: 12, offset: 9107},
				run: (*parser).callonDeBruijn1,
				expr: &seqExpr{
					pos: position{line: 337, col: 12, offset: 9107},
					exprs: []interface{}{
						&ruleRefExpr{
							pos:  position{line: 337, col: 12, offset: 9107},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 337, col: 14, offset: 9109},
							val:        "@",
							ignoreCase: false,
							want:       "\"@\"",
						},
						&ruleRefExpr{
							pos:  position{line: 337, col: 18, offset: 9113},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 337, col: 20, offset: 9115},
							label: "index",
							expr: &choiceExpr{
								pos: position{line: 323, col: 3, offset: 8618},
								alternatives: []interface{}{
									&actionExpr{
										pos: position{line: 323, col: 3, offset: 8618},
										run: (*parser).callonDeBruijn8,
										expr: &choiceExpr{
											pos: position{line: 323, col: 4, offset: 8619},
											alternatives: []interface{}{
												&seqExpr{
													pos: position{line: 323, col: 4, offset: 8619},
													exprs: []interface{}{
														&litMatcher{
															pos:        position{line: 323, col: 4, offset: 8619},
															val:        "0x",
															ignoreCase: false,
															want:       "\"0x\"",
														},
														&oneOrMoreExpr{
															pos: position{line: 323, col: 9, offset: 8624},
															expr: &choiceExpr{
																pos: position{line: 118, col: 10, offset: 2710},
																alternatives: []interface{}{
																	&charClassMatcher{
																		pos:        position{line: 116, col: 9, offset: 2692},
																		val:        "[0-9]",
																		ranges:     []rune{'0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																	&charClassMatcher{
																		pos:        position{line: 118, col: 18, offset: 2718},
																		val:        "[a-f]i",
																		ranges:     []rune{'a', 'f'},
																		ignoreCase: true,
																		inverted:   false,
																	},
																},
															},
														},
													},
												},
												&seqExpr{
													pos: position{line: 323, col: 19, offset: 8634},
													exprs: []interface{}{
														&charClassMatcher{
															pos:        position{line: 323, col: 19, offset: 8634},
															val:        "[1-9]",
															ranges:     []rune{'1', '9'},
															ignoreCase: false,
															inverted:   false,
														},
														&zeroOrMoreExpr{
															pos: position{line: 323, col: 25, offset: 8640},
															expr: &charClassMatcher{
																pos:        position{line: 116, col: 9, offset: 2692},
																val:        "[0-9]",
																ranges:     []rune{'0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 328, col: 5, offset: 8776},
										run: (*parser).callonDeBruijn20,
										expr: &seqExpr{
											pos: position{line: 328, col: 5, offset: 8776},
											exprs: []interface{}{
												&litMatcher{
													pos:        position{line: 328, col: 5, offset: 8776},
													val:        "0",
													ignoreCase: false,
													want:       "\"0\"",
												},
												&oneOrMoreExpr{
													pos: position{line: 328, col: 9, offset: 8780},
													expr: &charClassMatcher{
														pos:        position{line: 116, col: 9, offset: 2692},
														val:        "[0-9]",
														ranges:     []rune{'0', '9'},
														ignoreCase: false,
														inverted:   false,
													},
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 329, col: 5, offset: 8865},
										run: (*parser).callonDeBruijn25,
										expr: &litMatcher{
											pos:        position{line: 329, col: 5, offset: 8865},
											val:        "0",
											ignoreCase: false,
											want:       "\"0\"",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Variable",
			pos:  position{line: 339, col: 1, offset: 9177},
			expr: &actionExpr{
				pos: position{line: 339, col: 12, offset: 9190},
				run: (*parser).callonVariable1,
				expr: &seqExpr{
					pos: position{line: 339, col: 12, offset: 9190},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 339, col: 12, offset: 9190},
							label: "name",
							expr: &choiceExpr{
								pos: position{line: 134, col: 20, offset: 3237},
								alternatives: []interface{}{
									&actionExpr{
										pos: position{line: 134, col: 20, offset: 3237},
										run: (*parser).callonVariable5,
										expr: &seqExpr{
											pos: position{line: 134, col: 20, offset: 3237},
											exprs: []interface{}{
												&andExpr{
													pos: position{line: 134, col: 20, offset: 3237},
													expr: &seqExpr{
														pos: position{line: 134, col: 22, offset: 3239},
														exprs: []interface{}{
															&choiceExpr{
																pos: position{line: 259, col: 5, offset: 6416},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 259, col: 5, offset: 6416},
																		run: (*parser).callonVariable10,
																		expr: &litMatcher{
																			pos:        position{line: 259, col: 5, offset: 6416},
																			val:        "Natural/fold",
																			ignoreCase: false,
																			want:       "\"Natural/fold\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 260, col: 5, offset: 6463},
																		run: (*parser).callonVariable12,
																		expr: &litMatcher{
																			pos:        position{line: 260, col: 5, offset: 6463},
																			val:        "Natural/build",
																			ignoreCase: false,
																			want:       "\"Natural/build\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 261, col: 5, offset: 6512},
																		run: (*parser).callonVariable14,
																		expr: &litMatcher{
																			pos:        position{line: 261, col: 5, offset: 6512},
																			val:        "Natural/isZero",
																			ignoreCase: false,
																			want:       "\"Natural/isZero\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 262, col: 5, offset: 6563},
																		run: (*parser).callonVariable16,
																		expr: &litMatcher{
																			pos:        position{line: 262, col: 5, offset: 6563},
																			val:        "Natural/even",
																			ignoreCase: false,
																			want:       "\"Natural/even\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 263, col: 5, offset: 6610},
																		run: (*parser).callonVariable18,
																		expr: &litMatcher{
																			pos:        position{line: 263, col: 5, offset: 6610},
																			val:        "Natural/odd",
																			ignoreCase: false,
																			want:       "\"Natural/odd\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 264, col: 5, offset: 6655},
																		run: (*parser).callonVariable20,
																		expr: &litMatcher{
																			pos:        position{line: 264, col: 5, offset: 6655},
																			val:        "Natural/toInteger",
																			ignoreCase: false,
																			want:       "\"Natural/toInteger\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 265, col: 5, offset: 6712},
																		run: (*parser).callonVariable22,
																		expr: &litMatcher{
																			pos:        position{line: 265, col: 5, offset: 6712},
																			val:        "Natural/show",
																			ignoreCase: false,
																			want:       "\"Natural/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 266, col: 5, offset: 6759},
																		run: (*parser).callonVariable24,
																		expr: &litMatcher{
																			pos:        position{line: 266, col: 5, offset: 6759},
																			val:        "Integer/toDouble",
																			ignoreCase: false,
																			want:       "\"Integer/toDouble\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 267, col: 5, offset: 6814},
																		run: (*parser).callonVariable26,
																		expr: &litMatcher{
																			pos:        position{line: 267, col: 5, offset: 6814},
																			val:        "Integer/show",
																			ignoreCase: false,
																			want:       "\"Integer/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 268, col: 5, offset: 6861},
																		run: (*parser).callonVariable28,
																		expr: &litMatcher{
																			pos:        position{line: 268, col: 5, offset: 6861},
																			val:        "Integer/negate",
																			ignoreCase: false,
																			want:       "\"Integer/negate\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 269, col: 5, offset: 6912},
																		run: (*parser).callonVariable30,
																		expr: &litMatcher{
																			pos:        position{line: 269, col: 5, offset: 6912},
																			val:        "Integer/clamp",
																			ignoreCase: false,
																			want:       "\"Integer/clamp\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 270, col: 5, offset: 6961},
																		run: (*parser).callonVariable32,
																		expr: &litMatcher{
																			pos:        position{line: 270, col: 5, offset: 6961},
																			val:        "Natural/subtract",
																			ignoreCase: false,
																			want:       "\"Natural/subtract\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 271, col: 5, offset: 7016},
																		run: (*parser).callonVariable34,
																		expr: &litMatcher{
																			pos:        position{line: 271, col: 5, offset: 7016},
																			val:        "Double/show",
																			ignoreCase: false,
																			want:       "\"Double/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 272, col: 5, offset: 7061},
																		run: (*parser).callonVariable36,
																		expr: &litMatcher{
																			pos:        position{line: 272, col: 5, offset: 7061},
																			val:        "List/build",
																			ignoreCase: false,
																			want:       "\"List/build\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 273, col: 5, offset: 7104},
																		run: (*parser).callonVariable38,
																		expr: &litMatcher{
																			pos:        position{line: 273, col: 5, offset: 7104},
																			val:        "List/fold",
																			ignoreCase: false,
																			want:       "\"List/fold\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 274, col: 5, offset: 7145},
																		run: (*parser).callonVariable40,
																		expr: &litMatcher{
																			pos:        position{line: 274, col: 5, offset: 7145},
																			val:        "List/length",
																			ignoreCase: false,
																			want:       "\"List/length\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 275, col: 5, offset: 7190},
																		run: (*parser).callonVariable42,
																		expr: &litMatcher{
																			pos:        position{line: 275, col: 5, offset: 7190},
																			val:        "List/head",
																			ignoreCase: false,
																			want:       "\"List/head\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 276, col: 5, offset: 7231},
																		run: (*parser).callonVariable44,
																		expr: &litMatcher{
																			pos:        position{line: 276, col: 5, offset: 7231},
																			val:        "List/last",
																			ignoreCase: false,
																			want:       "\"List/last\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 277, col: 5, offset: 7272},
																		run: (*parser).callonVariable46,
																		expr: &litMatcher{
																			pos:        position{line: 277, col: 5, offset: 7272},
																			val:        "List/indexed",
																			ignoreCase: false,
																			want:       "\"List/indexed\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 278, col: 5, offset: 7319},
																		run: (*parser).callonVariable48,
																		expr: &litMatcher{
																			pos:        position{line: 278, col: 5, offset: 7319},
																			val:        "List/reverse",
																			ignoreCase: false,
																			want:       "\"List/reverse\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 279, col: 5, offset: 7366},
																		run: (*parser).callonVariable50,
																		expr: &litMatcher{
																			pos:        position{line: 279, col: 5, offset: 7366},
																			val:        "Text/show",
																			ignoreCase: false,
																			want:       "\"Text/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 280, col: 5, offset: 7407},
																		run: (*parser).callonVariable52,
																		expr: &litMatcher{
																			pos:        position{line: 280, col: 5, offset: 7407},
																			val:        "Text/replace",
																			ignoreCase: false,
																			want:       "\"Text/replace\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 281, col: 5, offset: 7454},
																		run: (*parser).callonVariable54,
																		expr: &litMatcher{
																			pos:        position{line: 281, col: 5, offset: 7454},
																			val:        "Bool",
																			ignoreCase: false,
																			want:       "\"Bool\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 282, col: 5, offset: 7486},
																		run: (*parser).callonVariable56,
																		expr: &litMatcher{
																			pos:        position{line: 282, col: 5, offset: 7486},
																			val:        "True",
																			ignoreCase: false,
																			want:       "\"True\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 283, col: 5, offset: 7518},
																		run: (*parser).callonVariable58,
																		expr: &litMatcher{
																			pos:        position{line: 283, col: 5, offset: 7518},
																			val:        "False",
																			ignoreCase: false,
																			want:       "\"False\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 284, col: 5, offset: 7552},
																		run: (*parser).callonVariable60,
																		expr: &litMatcher{
																			pos:        position{line: 284, col: 5, offset: 7552},
																			val:        "Optional",
																			ignoreCase: false,
																			want:       "\"Optional\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 285, col: 5, offset: 7592},
																		run: (*parser).callonVariable62,
																		expr: &litMatcher{
																			pos:        position{line: 285, col: 5, offset: 7592},
																			val:        "None",
																			ignoreCase: false,
																			want:       "\"None\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 286, col: 5, offset: 7624},
																		run: (*parser).callonVariable64,
																		expr: &litMatcher{
																			pos:        position{line: 286, col: 5, offset: 7624},
																			val:        "Natural",
																			ignoreCase: false,
																			want:       "\"Natural\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 287, col: 5, offset: 7662},
																		run: (*parser).callonVariable66,
																		expr: &litMatcher{
																			pos:        position{line: 287, col: 5, offset: 7662},
																			val:        "Integer",
																			ignoreCase: false,
																			want:       "\"Integer\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 288, col: 5, offset: 7700},
																		run: (*parser).callonVariable68,
																		expr: &litMatcher{
																			pos:        position{line: 288, col: 5, offset: 7700},
																			val:        "Double",
																			ignoreCase: false,
																			want:       "\"Double\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 289, col: 5, offset: 7736},
																		run: (*parser).callonVariable70,
																		expr: &litMatcher{
																			pos:        position{line: 289, col: 5, offset: 7736},
																			val:        "Text",
																			ignoreCase: false,
																			want:       "\"Text\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 290, col: 5, offset: 7768},
																		run: (*parser).callonVariable72,
																		expr: &litMatcher{
																			pos:        position{line: 290, col: 5, offset: 7768},
																			val:        "List",
																			ignoreCase: false,
																			want:       "\"List\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 291, col: 5, offset: 7800},
																		run: (*parser).callonVariable74,
																		expr: &litMatcher{
																			pos:        position{line: 291, col: 5, offset: 7800},
																			val:        "Type",
																			ignoreCase: false,
																			want:       "\"Type\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 292, col: 5, offset: 7832},
																		run: (*parser).callonVariable76,
																		expr: &litMatcher{
																			pos:        position{line: 292, col: 5, offset: 7832},
																			val:        "Kind",
																			ignoreCase: false,
																			want:       "\"Kind\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 293, col: 5, offset: 7864},
																		run: (*parser).callonVariable78,
																		expr: &litMatcher{
																			pos:        position{line: 293, col: 5, offset: 7864},
																			val:        "Sort",
																			ignoreCase: false,
																			want:       "\"Sort\"",
																		},
																	},
																},
															},
															&charClassMatcher{
																pos:        position{line: 121, col: 23, offset: 2785},
																val:        "[_/-A-Za-z0-9]",
																chars:      []rune{'_', '/', '-'},
																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
												&labeledExpr{
													pos:   position{line: 134, col: 51, offset: 3268},
													label: "label",
													expr: &choiceExpr{
														pos: position{line: 131, col: 9, offset: 3119},
														alternatives: []interface{}{
															&actionExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																run: (*parser).callonVariable83,
																expr: &seqExpr{
																	pos: position{line: 131, col: 9, offset: 3119},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 131, col: 9, offset: 3119},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																		&labeledExpr{
																			pos:   position{line: 131, col: 13, offset: 3123},
																			label: "label",
																			expr: &actionExpr{
																				pos: position{line: 129, col: 15, offset: 3060},
																				run: (*parser).callonVariable87,
																				expr: &zeroOrMoreExpr{
																					pos: position{line: 129, col: 15, offset: 3060},
																					expr: &charClassMatcher{
																						pos:        position{line: 128, col: 19, offset: 3023},
																						val:        "[ -_a-~]",
																						ranges:     []rune{' ', '_', 'a', '~'},
																						ignoreCase: false,
																						inverted:   false,
																					},
																				},
																			},
																		},
																		&litMatcher{
																			pos:        position{line: 131, col: 31, offset: 3141},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																	},
																},
															},
															&actionExpr{
																pos: position{line: 132, col: 9, offset: 3175},
																run: (*parser).callonVariable91,
																expr: &labeledExpr{
																	pos:   position{line: 132, col: 9, offset: 3175},
																	label: "label",
																	expr: &choiceExpr{
																		pos: position{line: 122, col: 15, offset: 2816},
																		alternatives: []interface{}{
																			&actionExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				run: (*parser).callonVariable94,
																				expr: &seqExpr{
																					pos: position{line: 122, col: 15, offset: 2816},
																					exprs: []interface{}{
																						&choiceExpr{
																							pos: position{line: 249, col: 5, offset: 6269},
																							alternatives: []interface{}{
																								&litMatcher{
																									pos:        position{line: 231, col: 6, offset: 5936},
																									val:        "if",
																									ignoreCase: false,
																									want:       "\"if\"",
																								},
																								&litMatcher{
																									pos:        position{line: 232, col: 8, offset: 5950},
																									val:        "then",
																									ignoreCase: false,
																									want:       "\"then\"",
																								},
																								&litMatcher{
																									pos:        position{line: 233, col: 8, offset: 5966},
																									val:        "else",
																									ignoreCase: false,
																									want:       "\"else\"",
																								},
																								&litMatcher{
																									pos:        position{line: 234, col: 7, offset: 5981},
																									val:        "let",
																									ignoreCase: false,
																									want:       "\"let\"",
																								},
																								&litMatcher{
																									pos:        position{line: 235, col: 6, offset: 5994},
																									val:        "in",
																									ignoreCase: false,
																									want:       "\"in\"",
																								},
																								&litMatcher{
																									pos:        position{line: 237, col: 9, offset: 6021},
																									val:        "using",
																									ignoreCase: false,
																									want:       "\"using\"",
																								},
																								&actionExpr{
																									pos: position{line: 239, col: 11, offset: 6059},
																									run: (*parser).callonVariable103,
																									expr: &seqExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										exprs: []interface{}{
																											&litMatcher{
																												pos:        position{line: 239, col: 11, offset: 6059},
																												val:        "missing",
																												ignoreCase: false,
																												want:       "\"missing\"",
																											},
																											&notExpr{
																												pos: position{line: 239, col: 21, offset: 6069},
																												expr: &charClassMatcher{
																													pos:        position{line: 121, col: 23, offset: 2785},
																													val:        "[_/-A-Za-z0-9]",
																													chars:      []rune{'_', '/', '-'},
																													ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																													ignoreCase: false,
																													inverted:   false,
																												},
																											},
																										},
																									},
																								},
																								&litMatcher{
																									pos:        position{line: 244, col: 10, offset: 6199},
																									val:        "assert",
																									ignoreCase: false,
																									want:       "\"assert\"",
																								},
																								&litMatcher{
																									pos:        position{line: 236, col: 6, offset: 6006},
																									val:        "as",
																									ignoreCase: false,
																									want:       "\"as\"",
																								},
																								&litMatcher{
																									pos:        position{line: 240, col: 12, offset: 6129},
																									val:        "Infinity",
																									ignoreCase: false,
																									want:       "\"Infinity\"",
																								},
																								&litMatcher{
																									pos:        position{line: 241, col: 7, offset: 6148},
																									val:        "NaN",
																									ignoreCase: false,
																									want:       "\"NaN\"",
																								},
																								&litMatcher{
																									pos:        position{line: 238, col: 9, offset: 6039},
																									val:        "merge",
																									ignoreCase: false,
																									want:       "\"merge\"",
																								},
																								&litMatcher{
																									pos:        position{line: 242, col: 8, offset: 6163},
																									val:        "Some",
																									ignoreCase: false,
																									want:       "\"Some\"",
																								},
																								&litMatcher{
																									pos:        position{line: 243, col: 9, offset: 6180},
																									val:        "toMap",
																									ignoreCase: false,
																									want:       "\"toMap\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 10, offset: 6219},
																									val:        "forall",
																									ignoreCase: false,
																									want:       "\"forall\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 21, offset: 6230},
																									val:        "∀",
																									ignoreCase: false,
																									want:       "\"∀\"",
																								},
																								&litMatcher{
																									pos:        position{line: 246, col: 8, offset: 6245},
																									val:        "with",
																									ignoreCase: false,
																									want:       "\"with\"",
																								},
																							},
																						},
																						&oneOrMoreExpr{
																							pos: position{line: 122, col: 23, offset: 2824},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																			&actionExpr{
																				pos: position{line: 123, col: 13, offset: 2888},
																				run: (*parser).callonVariable120,
																				expr: &seqExpr{
																					pos: position{line: 123, col: 13, offset: 2888},
																					exprs: []interface{}{
																						&notExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							expr: &choiceExpr{
																								pos: position{line: 249, col: 5, offset: 6269},
																								alternatives: []interface{}{
																									&litMatcher{
																										pos:        position{line: 231, col: 6, offset: 5936},
																										val:        "if",
																										ignoreCase: false,
																										want:       "\"if\"",
																									},
																									&litMatcher{
																										pos:        position{line: 232, col: 8, offset: 5950},
																										val:        "then",
																										ignoreCase: false,
																										want:       "\"then\"",
																									},
																									&litMatcher{
																										pos:        position{line: 233, col: 8, offset: 5966},
																										val:        "else",
																										ignoreCase: false,
																										want:       "\"else\"",
																									},
																									&litMatcher{
																										pos:        position{line: 234, col: 7, offset: 5981},
																										val:        "let",
																										ignoreCase: false,
																										want:       "\"let\"",
																									},
																									&litMatcher{
																										pos:        position{line: 235, col: 6, offset: 5994},
																										val:        "in",
																										ignoreCase: false,
																										want:       "\"in\"",
																									},
																									&litMatcher{
																										pos:        position{line: 237, col: 9, offset: 6021},
																										val:        "using",
																										ignoreCase: false,
																										want:       "\"using\"",
																									},
																									&actionExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										run: (*parser).callonVariable130,
																										expr: &seqExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											exprs: []interface{}{
																												&litMatcher{
																													pos:        position{line: 239, col: 11, offset: 6059},
																													val:        "missing",
																													ignoreCase: false,
																													want:       "\"missing\"",
																												},
																												&notExpr{
																													pos: position{line: 239, col: 21, offset: 6069},
																													expr: &charClassMatcher{
																														pos:        position{line: 121, col: 23, offset: 2785},
																														val:        "[_/-A-Za-z0-9]",
																														chars:      []rune{'_', '/', '-'},
																														ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																														ignoreCase: false,
																														inverted:   false,
																													},
																												},
																											},
																										},
																									},
																									&litMatcher{
																										pos:        position{line: 244, col: 10, offset: 6199},
																										val:        "assert",
																										ignoreCase: false,
																										want:       "\"assert\"",
																									},
																									&litMatcher{
																										pos:        position{line: 236, col: 6, offset: 6006},
																										val:        "as",
																										ignoreCase: false,
																										want:       "\"as\"",
																									},
																									&litMatcher{
																										pos:        position{line: 240, col: 12, offset: 6129},
																										val:        "Infinity",
																										ignoreCase: false,
																										want:       "\"Infinity\"",
																									},
																									&litMatcher{
																										pos:        position{line: 241, col: 7, offset: 6148},
																										val:        "NaN",
																										ignoreCase: false,
																										want:       "\"NaN\"",
																									},
																									&litMatcher{
																										pos:        position{line: 238, col: 9, offset: 6039},
																										val:        "merge",
																										ignoreCase: false,
																										want:       "\"merge\"",
																									},
																									&litMatcher{
																										pos:        position{line: 242, col: 8, offset: 6163},
																										val:        "Some",
																										ignoreCase: false,
																										want:       "\"Some\"",
																									},
																									&litMatcher{
																										pos:        position{line: 243, col: 9, offset: 6180},
																										val:        "toMap",
																										ignoreCase: false,
																										want:       "\"toMap\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 10, offset: 6219},
																										val:        "forall",
																										ignoreCase: false,
																										want:       "\"forall\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 21, offset: 6230},
																										val:        "∀",
																										ignoreCase: false,
																										want:       "\"∀\"",
																									},
																									&litMatcher{
																										pos:        position{line: 246, col: 8, offset: 6245},
																										val:        "with",
																										ignoreCase: false,
																										want:       "\"with\"",
																									},
																								},
																							},
																						},
																						&charClassMatcher{
																							pos:        position{line: 120, col: 24, offset: 2751},
																							val:        "[_A-Za-z]",
																							chars:      []rune{'_'},
																							ranges:     []rune{'A', 'Z', 'a', 'z'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&zeroOrMoreExpr{
																							pos: position{line: 123, col: 43, offset: 2918},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 135, col: 19, offset: 3320},
										run: (*parser).callonVariable148,
										expr: &seqExpr{
											pos: position{line: 135, col: 19, offset: 3320},
											exprs: []interface{}{
												&notExpr{
													pos: position{line: 135, col: 19, offset: 3320},
													expr: &choiceExpr{
														pos: position{line: 259, col: 5, offset: 6416},
														alternatives: []interface{}{
															&actionExpr{
																pos: position{line: 259, col: 5, offset: 6416},
																run: (*parser).callonVariable152,
																expr: &litMatcher{
																	pos:        position{line: 259, col: 5, offset: 6416},
																	val:        "Natural/fold",
																	ignoreCase: false,
																	want:       "\"Natural/fold\"",
																},
															},
															&actionExpr{
																pos: position{line: 260, col: 5, offset: 6463},
																run: (*parser).callonVariable154,
																expr: &litMatcher{
																	pos:        position{line: 260, col: 5, offset: 6463},
																	val:        "Natural/build",
																	ignoreCase: false,
																	want:       "\"Natural/build\"",
																},
															},
															&actionExpr{
																pos: position{line: 261, col: 5, offset: 6512},
																run: (*parser).callonVariable156,
																expr: &litMatcher{
																	pos:        position{line: 261, col: 5, offset: 6512},
																	val:        "Natural/isZero",
																	ignoreCase: false,
																	want:       "\"Natural/isZero\"",
																},
															},
															&actionExpr{
																pos: position{line: 262, col: 5, offset: 6563},
																run: (*parser).callonVariable158,
																expr: &litMatcher{
																	pos:        position{line: 262, col: 5, offset: 6563},
																	val:        "Natural/even",
																	ignoreCase: false,
																	want:       "\"Natural/even\"",
																},
															},
															&actionExpr{
																pos: position{line: 263, col: 5, offset: 6610},
																run: (*parser).callonVariable160,
																expr: &litMatcher{
																	pos:        position{line: 263, col: 5, offset: 6610},
																	val:        "Natural/odd",
																	ignoreCase: false,
																	want:       "\"Natural/odd\"",
																},
															},
															&actionExpr{
																pos: position{line: 264, col: 5, offset: 6655},
																run: (*parser).callonVariable162,
																expr: &litMatcher{
																	pos:        position{line: 264, col: 5, offset: 6655},
																	val:        "Natural/toInteger",
																	ignoreCase: false,
																	want:       "\"Natural/toInteger\"",
																},
															},
															&actionExpr{
																pos: position{line: 265, col: 5, offset: 6712},
																run: (*parser).callonVariable164,
																expr: &litMatcher{
																	pos:        position{line: 265, col: 5, offset: 6712},
																	val:        "Natural/show",
																	ignoreCase: false,
																	want:       "\"Natural/show\"",
																},
															},
															&actionExpr{
																pos: position{line: 266, col: 5, offset: 6759},
																run: (*parser).callonVariable166,
																expr: &litMatcher{
																	pos:        position{line: 266, col: 5, offset: 6759},
																	val:        "Integer/toDouble",
																	ignoreCase: false,
																	want:       "\"Integer/toDouble\"",
																},
															},
															&actionExpr{
																pos: position{line: 267, col: 5, offset: 6814},
																run: (*parser).callonVariable168,
																expr: &litMatcher{
																	pos:        position{line: 267, col: 5, offset: 6814},
																	val:        "Integer/show",
																	ignoreCase: false,
																	want:       "\"Integer/show\"",
																},
															},
															&actionExpr{
																pos: position{line: 268, col: 5, offset: 6861},
																run: (*parser).callonVariable170,
																expr: &litMatcher{
																	pos:        position{line: 268, col: 5, offset: 6861},
																	val:        "Integer/negate",
																	ignoreCase: false,
																	want:       "\"Integer/negate\"",
																},
															},
															&actionExpr{
																pos: position{line: 269, col: 5, offset: 6912},
																run: (*parser).callonVariable172,
																expr: &litMatcher{
																	pos:        position{line: 269, col: 5, offset: 6912},
																	val:        "Integer/clamp",
																	ignoreCase: false,
																	want:       "\"Integer/clamp\"",
																},
															},
															&actionExpr{
																pos: position{line: 270, col: 5, offset: 6961},
																run: (*parser).callonVariable174,
																expr: &litMatcher{
																	pos:        position{line: 270, col: 5, offset: 6961},
																	val:        "Natural/subtract",
																	ignoreCase: false,
																	want:       "\"Natural/subtract\"",
																},
															},
															&actionExpr{
																pos: position{line: 271, col: 5, offset: 7016},
																run: (*parser).callonVariable176,
																expr: &litMatcher{
																	pos:        position{line: 271, col: 5, offset: 7016},
																	val:        "Double/show",
																	ignoreCase: false,
																	want:       "\"Double/show\"",
																},
															},
															&actionExpr{
																pos: position{line: 272, col: 5, offset: 7061},
																run: (*parser).callonVariable178,
																expr: &litMatcher{
																	pos:        position{line: 272, col: 5, offset: 7061},
																	val:        "List/build",
																	ignoreCase: false,
																	want:       "\"List/build\"",
																},
															},
															&actionExpr{
																pos: position{line: 273, col: 5, offset: 7104},
																run: (*parser).callonVariable180,
																expr: &litMatcher{
																	pos:        position{line: 273, col: 5, offset: 7104},
																	val:        "List/fold",
																	ignoreCase: false,
																	want:       "\"List/fold\"",
																},
															},
															&actionExpr{
																pos: position{line: 274, col: 5, offset: 7145},
																run: (*parser).callonVariable182,
																expr: &litMatcher{
																	pos:        position{line: 274, col: 5, offset: 7145},
																	val:        "List/length",
																	ignoreCase: false,
																	want:       "\"List/length\"",
																},
															},
															&actionExpr{
																pos: position{line: 275, col: 5, offset: 7190},
																run: (*parser).callonVariable184,
																expr: &litMatcher{
																	pos:        position{line: 275, col: 5, offset: 7190},
																	val:        "List/head",
																	ignoreCase: false,
																	want:       "\"List/head\"",
																},
															},
															&actionExpr{
																pos: position{line: 276, col: 5, offset: 7231},
																run: (*parser).callonVariable186,
																expr: &litMatcher{
																	pos:        position{line: 276, col: 5, offset: 7231},
																	val:        "List/last",
																	ignoreCase: false,
																	want:       "\"List/last\"",
																},
															},
															&actionExpr{
																pos: position{line: 277, col: 5, offset: 7272},
																run: (*parser).callonVariable188,
																expr: &litMatcher{
																	pos:        position{line: 277, col: 5, offset: 7272},
																	val:        "List/indexed",
																	ignoreCase: false,
																	want:       "\"List/indexed\"",
																},
															},
															&actionExpr{
																pos: position{line: 278, col: 5, offset: 7319},
																run: (*parser).callonVariable190,
																expr: &litMatcher{
																	pos:        position{line: 278, col: 5, offset: 7319},
																	val:        "List/reverse",
																	ignoreCase: false,
																	want:       "\"List/reverse\"",
																},
															},
															&actionExpr{
																pos: position{line: 279, col: 5, offset: 7366},
																run: (*parser).callonVariable192,
																expr: &litMatcher{
																	pos:        position{line: 279, col: 5, offset: 7366},
																	val:        "Text/show",
																	ignoreCase: false,
																	want:       "\"Text/show\"",
																},
															},
															&actionExpr{
																pos: position{line: 280, col: 5, offset: 7407},
																run: (*parser).callonVariable194,
																expr: &litMatcher{
																	pos:        position{line: 280, col: 5, offset: 7407},
																	val:        "Text/replace",
																	ignoreCase: false,
																	want:       "\"Text/replace\"",
																},
															},
															&actionExpr{
																pos: position{line: 281, col: 5, offset: 7454},
																run: (*parser).callonVariable196,
																expr: &litMatcher{
																	pos:        position{line: 281, col: 5, offset: 7454},
																	val:        "Bool",
																	ignoreCase: false,
																	want:       "\"Bool\"",
																},
															},
															&actionExpr{
																pos: position{line: 282, col: 5, offset: 7486},
																run: (*parser).callonVariable198,
																expr: &litMatcher{
																	pos:        position{line: 282, col: 5, offset: 7486},
																	val:        "True",
																	ignoreCase: false,
																	want:       "\"True\"",
																},
															},
															&actionExpr{
																pos: position{line: 283, col: 5, offset: 7518},
																run: (*parser).callonVariable200,
																expr: &litMatcher{
																	pos:        position{line: 283, col: 5, offset: 7518},
																	val:        "False",
																	ignoreCase: false,
																	want:       "\"False\"",
																},
															},
															&actionExpr{
																pos: position{line: 284, col: 5, offset: 7552},
																run: (*parser).callonVariable202,
																expr: &litMatcher{
																	pos:        position{line: 284, col: 5, offset: 7552},
																	val:        "Optional",
																	ignoreCase: false,
																	want:       "\"Optional\"",
																},
															},
															&actionExpr{
																pos: position{line: 285, col: 5, offset: 7592},
																run: (*parser).callonVariable204,
																expr: &litMatcher{
																	pos:        position{line: 285, col: 5, offset: 7592},
																	val:        "None",
																	ignoreCase: false,
																	want:       "\"None\"",
																},
															},
															&actionExpr{
																pos: position{line: 286, col: 5, offset: 7624},
																run: (*parser).callonVariable206,
																expr: &litMatcher{
																	pos:        position{line: 286, col: 5, offset: 7624},
																	val:        "Natural",
																	ignoreCase: false,
																	want:       "\"Natural\"",
																},
															},
															&actionExpr{
																pos: position{line: 287, col: 5, offset: 7662},
																run: (*parser).callonVariable208,
																expr: &litMatcher{
																	pos:        position{line: 287, col: 5, offset: 7662},
																	val:        "Integer",
																	ignoreCase: false,
																	want:       "\"Integer\"",
																},
															},
															&actionExpr{
																pos: position{line: 288, col: 5, offset: 7700},
																run: (*parser).callonVariable210,
																expr: &litMatcher{
																	pos:        position{line: 288, col: 5, offset: 7700},
																	val:        "Double",
																	ignoreCase: false,
																	want:       "\"Double\"",
																},
															},
															&actionExpr{
																pos: position{line: 289, col: 5, offset: 7736},
																run: (*parser).callonVariable212,
																expr: &litMatcher{
																	pos:        position{line: 289, col: 5, offset: 7736},
																	val:        "Text",
																	ignoreCase: false,
																	want:       "\"Text\"",
																},
															},
															&actionExpr{
																pos: position{line: 290, col: 5, offset: 7768},
																run: (*parser).callonVariable214,
																expr: &litMatcher{
																	pos:        position{line: 290, col: 5, offset: 7768},
																	val:        "List",
																	ignoreCase: false,
																	want:       "\"List\"",
																},
															},
															&actionExpr{
																pos: position{line: 291, col: 5, offset: 7800},
																run: (*parser).callonVariable216,
																expr: &litMatcher{
																	pos:        position{line: 291, col: 5, offset: 7800},
																	val:        "Type",
																	ignoreCase: false,
																	want:       "\"Type\"",
																},
															},
															&actionExpr{
																pos: position{line: 292, col: 5, offset: 7832},
																run: (*parser).callonVariable218,
																expr: &litMatcher{
																	pos:        position{line: 292, col: 5, offset: 7832},
																	val:        "Kind",
																	ignoreCase: false,
																	want:       "\"Kind\"",
																},
															},
															&actionExpr{
																pos: position{line: 293, col: 5, offset: 7864},
																run: (*parser).callonVariable220,
																expr: &litMatcher{
																	pos:        position{line: 293, col: 5, offset: 7864},
																	val:        "Sort",
																	ignoreCase: false,
																	want:       "\"Sort\"",
																},
															},
														},
													},
												},
												&labeledExpr{
													pos:   position{line: 135, col: 28, offset: 3329},
													label: "label",
													expr: &choiceExpr{
														pos: position{line: 131, col: 9, offset: 3119},
														alternatives: []interface{}{
															&actionExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																run: (*parser).callonVariable224,
																expr: &seqExpr{
																	pos: position{line: 131, col: 9, offset: 3119},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 131, col: 9, offset: 3119},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																		&labeledExpr{
																			pos:   position{line: 131, col: 13, offset: 3123},
																			label: "label",
																			expr: &actionExpr{
																				pos: position{line: 129, col: 15, offset: 3060},
																				run: (*parser).callonVariable228,
																				expr: &zeroOrMoreExpr{
																					pos: position{line: 129, col: 15, offset: 3060},
																					expr: &charClassMatcher{
																						pos:        position{line: 128, col: 19, offset: 3023},
																						val:        "[ -_a-~]",
																						ranges:     []rune{' ', '_', 'a', '~'},
																						ignoreCase: false,
																						inverted:   false,
																					},
																				},
																			},
																		},
																		&litMatcher{
																			pos:        position{line: 131, col: 31, offset: 3141},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																	},
																},
															},
															&actionExpr{
																pos: position{line: 132, col: 9, offset: 3175},
																run: (*parser).callonVariable232,
																expr: &labeledExpr{
																	pos:   position{line: 132, col: 9, offset: 3175},
																	label: "label",
																	expr: &choiceExpr{
																		pos: position{line: 122, col: 15, offset: 2816},
																		alternatives: []interface{}{
																			&actionExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				run: (*parser).callonVariable235,
																				expr: &seqExpr{
																					pos: position{line: 122, col: 15, offset: 2816},
																					exprs: []interface{}{
																						&choiceExpr{
																							pos: position{line: 249, col: 5, offset: 6269},
																							alternatives: []interface{}{
																								&litMatcher{
																									pos:        position{line: 231, col: 6, offset: 5936},
																									val:        "if",
																									ignoreCase: false,
																									want:       "\"if\"",
																								},
																								&litMatcher{
																									pos:        position{line: 232, col: 8, offset: 5950},
																									val:        "then",
																									ignoreCase: false,
																									want:       "\"then\"",
																								},
																								&litMatcher{
																									pos:        position{line: 233, col: 8, offset: 5966},
																									val:        "else",
																									ignoreCase: false,
																									want:       "\"else\"",
																								},
																								&litMatcher{
																									pos:        position{line: 234, col: 7, offset: 5981},
																									val:        "let",
																									ignoreCase: false,
																									want:       "\"let\"",
																								},
																								&litMatcher{
																									pos:        position{line: 235, col: 6, offset: 5994},
																									val:        "in",
																									ignoreCase: false,
																									want:       "\"in\"",
																								},
																								&litMatcher{
																									pos:        position{line: 237, col: 9, offset: 6021},
																									val:        "using",
																									ignoreCase: false,
																									want:       "\"using\"",
																								},
																								&actionExpr{
																									pos: position{line: 239, col: 11, offset: 6059},
																									run: (*parser).callonVariable244,
																									expr: &seqExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										exprs: []interface{}{
																											&litMatcher{
																												pos:        position{line: 239, col: 11, offset: 6059},
																												val:        "missing",
																												ignoreCase: false,
																												want:       "\"missing\"",
																											},
																											&notExpr{
																												pos: position{line: 239, col: 21, offset: 6069},
																												expr: &charClassMatcher{
																													pos:        position{line: 121, col: 23, offset: 2785},
																													val:        "[_/-A-Za-z0-9]",
																													chars:      []rune{'_', '/', '-'},
																													ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																													ignoreCase: false,
																													inverted:   false,
																												},
																											},
																										},
																									},
																								},
																								&litMatcher{
																									pos:        position{line: 244, col: 10, offset: 6199},
																									val:        "assert",
																									ignoreCase: false,
																									want:       "\"assert\"",
																								},
																								&litMatcher{
																									pos:        position{line: 236, col: 6, offset: 6006},
																									val:        "as",
																									ignoreCase: false,
																									want:       "\"as\"",
																								},
																								&litMatcher{
																									pos:        position{line: 240, col: 12, offset: 6129},
																									val:        "Infinity",
																									ignoreCase: false,
																									want:       "\"Infinity\"",
																								},
																								&litMatcher{
																									pos:        position{line: 241, col: 7, offset: 6148},
																									val:        "NaN",
																									ignoreCase: false,
																									want:       "\"NaN\"",
																								},
																								&litMatcher{
																									pos:        position{line: 238, col: 9, offset: 6039},
																									val:        "merge",
																									ignoreCase: false,
																									want:       "\"merge\"",
																								},
																								&litMatcher{
																									pos:        position{line: 242, col: 8, offset: 6163},
																									val:        "Some",
																									ignoreCase: false,
																									want:       "\"Some\"",
																								},
																								&litMatcher{
																									pos:        position{line: 243, col: 9, offset: 6180},
																									val:        "toMap",
																									ignoreCase: false,
																									want:       "\"toMap\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 10, offset: 6219},
																									val:        "forall",
																									ignoreCase: false,
																									want:       "\"forall\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 21, offset: 6230},
																									val:        "∀",
																									ignoreCase: false,
																									want:       "\"∀\"",
																								},
																								&litMatcher{
																									pos:        position{line: 246, col: 8, offset: 6245},
																									val:        "with",
																									ignoreCase: false,
																									want:       "\"with\"",
																								},
																							},
																						},
																						&oneOrMoreExpr{
																							pos: position{line: 122, col: 23, offset: 2824},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																			&actionExpr{
																				pos: position{line: 123, col: 13, offset: 2888},
																				run: (*parser).callonVariable261,
																				expr: &seqExpr{
																					pos: position{line: 123, col: 13, offset: 2888},
																					exprs: []interface{}{
																						&notExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							expr: &choiceExpr{
																								pos: position{line: 249, col: 5, offset: 6269},
																								alternatives: []interface{}{
																									&litMatcher{
																										pos:        position{line: 231, col: 6, offset: 5936},
																										val:        "if",
																										ignoreCase: false,
																										want:       "\"if\"",
																									},
																									&litMatcher{
																										pos:        position{line: 232, col: 8, offset: 5950},
																										val:        "then",
																										ignoreCase: false,
																										want:       "\"then\"",
																									},
																									&litMatcher{
																										pos:        position{line: 233, col: 8, offset: 5966},
																										val:        "else",
																										ignoreCase: false,
																										want:       "\"else\"",
																									},
																									&litMatcher{
																										pos:        position{line: 234, col: 7, offset: 5981},
																										val:        "let",
																										ignoreCase: false,
																										want:       "\"let\"",
																									},
																									&litMatcher{
																										pos:        position{line: 235, col: 6, offset: 5994},
																										val:        "in",
																										ignoreCase: false,
																										want:       "\"in\"",
																									},
																									&litMatcher{
																										pos:        position{line: 237, col: 9, offset: 6021},
																										val:        "using",
																										ignoreCase: false,
																										want:       "\"using\"",
																									},
																									&actionExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										run: (*parser).callonVariable271,
																										expr: &seqExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											exprs: []interface{}{
																												&litMatcher{
																													pos:        position{line: 239, col: 11, offset: 6059},
																													val:        "missing",
																													ignoreCase: false,
																													want:       "\"missing\"",
																												},
																												&notExpr{
																													pos: position{line: 239, col: 21, offset: 6069},
																													expr: &charClassMatcher{
																														pos:        position{line: 121, col: 23, offset: 2785},
																														val:        "[_/-A-Za-z0-9]",
																														chars:      []rune{'_', '/', '-'},
																														ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																														ignoreCase: false,
																														inverted:   false,
																													},
																												},
																											},
																										},
																									},
																									&litMatcher{
																										pos:        position{line: 244, col: 10, offset: 6199},
																										val:        "assert",
																										ignoreCase: false,
																										want:       "\"assert\"",
																									},
																									&litMatcher{
																										pos:        position{line: 236, col: 6, offset: 6006},
																										val:        "as",
																										ignoreCase: false,
																										want:       "\"as\"",
																									},
																									&litMatcher{
																										pos:        position{line: 240, col: 12, offset: 6129},
																										val:        "Infinity",
																										ignoreCase: false,
																										want:       "\"Infinity\"",
																									},
																									&litMatcher{
																										pos:        position{line: 241, col: 7, offset: 6148},
																										val:        "NaN",
																										ignoreCase: false,
																										want:       "\"NaN\"",
																									},
																									&litMatcher{
																										pos:        position{line: 238, col: 9, offset: 6039},
																										val:        "merge",
																										ignoreCase: false,
																										want:       "\"merge\"",
																									},
																									&litMatcher{
																										pos:        position{line: 242, col: 8, offset: 6163},
																										val:        "Some",
																										ignoreCase: false,
																										want:       "\"Some\"",
																									},
																									&litMatcher{
																										pos:        position{line: 243, col: 9, offset: 6180},
																										val:        "toMap",
																										ignoreCase: false,
																										want:       "\"toMap\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 10, offset: 6219},
																										val:        "forall",
																										ignoreCase: false,
																										want:       "\"forall\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 21, offset: 6230},
																										val:        "∀",
																										ignoreCase: false,
																										want:       "\"∀\"",
																									},
																									&litMatcher{
																										pos:        position{line: 246, col: 8, offset: 6245},
																										val:        "with",
																										ignoreCase: false,
																										want:       "\"with\"",
																									},
																								},
																							},
																						},
																						&charClassMatcher{
																							pos:        position{line: 120, col: 24, offset: 2751},
																							val:        "[_A-Za-z]",
																							chars:      []rune{'_'},
																							ranges:     []rune{'A', 'Z', 'a', 'z'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&zeroOrMoreExpr{
																							pos: position{line: 123, col: 43, offset: 2918},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 339, col: 34, offset: 9212},
							label: "index",
							expr: &zeroOrOneExpr{
								pos: position{line: 339, col: 40, offset: 9218},
								expr: &ruleRefExpr{
									pos:  position{line: 339, col: 40, offset: 9218},
									name: "DeBruijn",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Http",
			pos:  position{line: 423, col: 1, offset: 11410},
			expr: &actionExpr{
				pos: position{line: 423, col: 8, offset: 11419},
				run: (*parser).callonHttp1,
				expr: &seqExpr{
					pos: position{line: 423, col: 8, offset: 11419},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 423, col: 8, offset: 11419},
							label: "u",
							expr: &actionExpr{
								pos: position{line: 389, col: 11, offset: 10609},
								run: (*parser).callonHttp4,
								expr: &seqExpr{
									pos: position{line: 389, col: 11, offset: 10609},
									exprs: []interface{}{
										&litMatcher{
											pos:        position{line: 387, col: 10, offset: 10584},
											val:        "http",
											ignoreCase: false,
											want:       "\"http\"",
										},
										&zeroOrOneExpr{
											pos: position{line: 387, col: 17, offset: 10591},
											expr: &litMatcher{
												pos:        position{line: 387, col: 17, offset: 10591},
												val:        "s",
												ignoreCase: false,
												want:       "\"s\"",
											},
										},
										&litMatcher{
											pos:        position{line: 389, col: 18, offset: 10616},
											val:        "://",
											ignoreCase: false,
											want:       "\"://\"",
										},
										&zeroOrOneExpr{
											pos: position{line: 393, col: 13, offset: 10753},
											expr: &seqExpr{
												pos: position{line: 393, col: 14, offset: 10754},
												exprs: []interface{}{
													&zeroOrMoreExpr{
														pos: position{line: 395, col: 12, offset: 10800},
														expr: &choiceExpr{
															pos: position{line: 395, col: 14, offset: 10802},
															alternatives: []interface{}{
																&charClassMatcher{
																	pos:        position{line: 419, col: 14, offset: 11332},
																	val:        "[._~-A-Za-z0-9]",
																	chars:      []rune{'.', '_', '~', '-'},
																	ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																	ignoreCase: false,
																	inverted:   false,
																},
																&seqExpr{
																	pos: position{line: 417, col: 14, offset: 11298},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 417, col: 14, offset: 11298},
																			val:        "%",
																			ignoreCase: false,
																			want:       "\"%\"",
																		},
																		&choiceExpr{
																			pos: position{line: 118, col: 10, offset: 2710},
																			alternatives: []interface{}{
																				&charClassMatcher{
																					pos:        position{line: 116, col: 9, offset: 2692},
																					val:        "[0-9]",
																					ranges:     []rune{'0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 118, col: 18, offset: 2718},
																					val:        "[a-f]i",
																					ranges:     []rune{'a', 'f'},
																					ignoreCase: true,
																					inverted:   false,
																				},
																			},
																		},
																		&choiceExpr{
																			pos: position{line: 118, col: 10, offset: 2710},
																			alternatives: []interface{}{
																				&charClassMatcher{
																					pos:        position{line: 116, col: 9, offset: 2692},
																					val:        "[0-9]",
																					ranges:     []rune{'0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 118, col: 18, offset: 2718},
																					val:        "[a-f]i",
																					ranges:     []rune{'a', 'f'},
																					ignoreCase: true,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
																&charClassMatcher{
																	pos:        position{line: 421, col: 13, offset: 11363},
																	val:        "[!$&\\*+;=:]",
																	chars:      []rune{'!', '$', '&', '\'', '*', '+', ';', '=', ':'},
																	ignoreCase: false,
																	inverted:   false,
																},
															},
														},
													},
													&litMatcher{
														pos:        position{line: 393, col: 23, offset: 10763},
														val:        "@",
														ignoreCase: false,
														want:       "\"@\"",
													},
												},
											},
										},
										&choiceExpr{
											pos: position{line: 397, col: 8, offset: 10857},
											alternatives: []interface{}{
												&seqExpr{
													pos: position{line: 401, col: 13, offset: 10909},
													exprs: []interface{}{
														&litMatcher{
															pos:        position{line: 401, col: 13, offset: 10909},
															val:        "[",
															ignoreCase: false,
															want:       "\"[\"",
														},
														&actionExpr{
															pos: position{line: 403, col: 15, offset: 10946},
															run: (*parser).callonHttp28,
															expr: &seqExpr{
																pos: position{line: 403, col: 15, offset: 10946},
																exprs: []interface{}{
																	&zeroOrMoreExpr{
																		pos: position{line: 403, col: 15, offset: 10946},
																		expr: &choiceExpr{
																			pos: position{line: 118, col: 10, offset: 2710},
																			alternatives: []interface{}{
																				&charClassMatcher{
																					pos:        position{line: 116, col: 9, offset: 2692},
																					val:        "[0-9]",
																					ranges:     []rune{'0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 118, col: 18, offset: 2718},
																					val:        "[a-f]i",
																					ranges:     []rune{'a', 'f'},
																					ignoreCase: true,
																					inverted:   false,
																				},
																			},
																		},
																	},
																	&litMatcher{
																		pos:        position{line: 403, col: 25, offset: 10956},
																		val:        ":",
																		ignoreCase: false,
																		want:       "\":\"",
																	},
																	&zeroOrMoreExpr{
																		pos: position{line: 403, col: 29, offset: 10960},
																		expr: &choiceExpr{
																			pos: position{line: 403, col: 30, offset: 10961},
																			alternatives: []interface{}{
																				&charClassMatcher{
																					pos:        position{line: 116, col: 9, offset: 2692},
																					val:        "[0-9]",
																					ranges:     []rune{'0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 118, col: 18, offset: 2718},
																					val:        "[a-f]i",
																					ranges:     []rune{'a', 'f'},
																					ignoreCase: true,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 403, col: 39, offset: 10970},
																					val:        "[:.]",
																					chars:      []rune{':', '.'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
															},
														},
														&litMatcher{
															pos:        position{line: 401, col: 29, offset: 10925},
															val:        "]",
															ignoreCase: false,
															want:       "\"]\"",
														},
													},
												},
												&zeroOrMoreExpr{
													pos: position{line: 409, col: 11, offset: 11142},
													expr: &choiceExpr{
														pos: position{line: 409, col: 12, offset: 11143},
														alternatives: []interface{}{
															&charClassMatcher{
																pos:        position{line: 419, col: 14, offset: 11332},
																val:        "[._~-A-Za-z0-9]",
																chars:      []rune{'.', '_', '~', '-'},
																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
															&seqExpr{
																pos: position{line: 417, col: 14, offset: 11298},
																exprs: []interface{}{
																	&litMatcher{
																		pos:        position{line: 417, col: 14, offset: 11298},
																		val:        "%",
																		ignoreCase: false,
																		want:       "\"%\"",
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																},
															},
															&charClassMatcher{
																pos:        position{line: 421, col: 13, offset: 11363},
																val:        "[!$&\\*+;=]",
																chars:      []rune{'!', '$', '&', '\'', '*', '+', ';', '='},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
											},
										},
										&zeroOrOneExpr{
											pos: position{line: 393, col: 34, offset: 10774},
											expr: &seqExpr{
												pos: position{line: 393, col: 35, offset: 10775},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 393, col: 35, offset: 10775},
														val:        ":",
														ignoreCase: false,
														want:       "\":\"",
													},
													&zeroOrMoreExpr{
														pos: position{line: 399, col: 8, offset: 10887},
														expr: &charClassMatcher{
															pos:        position{line: 116, col: 9, offset: 2692},
															val:        "[0-9]",
															ranges:     []rune{'0', '9'},
															ignoreCase: false,
															inverted:   false,
														},
													},
												},
											},
										},
										&zeroOrMoreExpr{
											pos: position{line: 391, col: 15, offset: 10723},
											expr: &seqExpr{
												pos: position{line: 391, col: 16, offset: 10724},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 391, col: 16, offset: 10724},
														val:        "/",
														ignoreCase: false,
														want:       "\"/\"",
													},
													&zeroOrMoreExpr{
														pos: position{line: 411, col: 11, offset: 11194},
														expr: &choiceExpr{
															pos: position{line: 413, col: 9, offset: 11212},
															alternatives: []interface{}{
																&charClassMatcher{
																	pos:        position{line: 419, col: 14, offset: 11332},
																	val:        "[._~-A-Za-z0-9]",
																	chars:      []rune{'.', '_', '~', '-'},
																	ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																	ignoreCase: false,
																	inverted:   false,
																},
																&seqExpr{
																	pos: position{line: 417, col: 14, offset: 11298},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 417, col: 14, offset: 11298},
																			val:        "%",
																			ignoreCase: false,
																			want:       "\"%\"",
																		},
																		&choiceExpr{
																			pos: position{line: 118, col: 10, offset: 2710},
																			alternatives: []interface{}{
																				&charClassMatcher{
																					pos:        position{line: 116, col: 9, offset: 2692},
																					val:        "[0-9]",
																					ranges:     []rune{'0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 118, col: 18, offset: 2718},
																					val:        "[a-f]i",
																					ranges:     []rune{'a', 'f'},
																					ignoreCase: true,
																					inverted:   false,
																				},
																			},
																		},
																		&choiceExpr{
																			pos: position{line: 118, col: 10, offset: 2710},
																			alternatives: []interface{}{
																				&charClassMatcher{
																					pos:        position{line: 116, col: 9, offset: 2692},
																					val:        "[0-9]",
																					ranges:     []rune{'0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 118, col: 18, offset: 2718},
																					val:        "[a-f]i",
																					ranges:     []rune{'a', 'f'},
																					ignoreCase: true,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
																&charClassMatcher{
																	pos:        position{line: 421, col: 13, offset: 11363},
																	val:        "[!$&\\*+;=:@]",
																	chars:      []rune{'!', '$', '&', '\'', '*', '+', ';', '=', ':', '@'},
																	ignoreCase: false,
																	inverted:   false,
																},
															},
														},
													},
												},
											},
										},
										&zeroOrOneExpr{
											pos: position{line: 389, col: 46, offset: 10644},
											expr: &seqExpr{
												pos: position{line: 389, col: 48, offset: 10646},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 389, col: 48, offset: 10646},
														val:        "?",
														ignoreCase: false,
														want:       "\"?\"",
													},
													&zeroOrMoreExpr{
														pos: position{line: 415, col: 9, offset: 11266},
														expr: &choiceExpr{
															pos: position{line: 415, col: 10, offset: 11267},
															alternatives: []interface{}{
																&charClassMatcher{
																	pos:        position{line: 419, col: 14, offset: 11332},
																	val:        "[._~-A-Za-z0-9]",
																	chars:      []rune{'.', '_', '~', '-'},
																	ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																	ignoreCase: false,
																	inverted:   false,
																},
																&seqExpr{
																	pos: position{line: 417, col: 14, offset: 11298},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 417, col: 14, offset: 11298},
																			val:        "%",
																			ignoreCase: false,
																			want:       "\"%\"",
																		},
																		&choiceExpr{
																			pos: position{line: 118, col: 10, offset: 2710},
																			alternatives: []interface{}{
																				&charClassMatcher{
																					pos:        position{line: 116, col: 9, offset: 2692},
																					val:        "[0-9]",
																					ranges:     []rune{'0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 118, col: 18, offset: 2718},
																					val:        "[a-f]i",
																					ranges:     []rune{'a', 'f'},
																					ignoreCase: true,
																					inverted:   false,
																				},
																			},
																		},
																		&choiceExpr{
																			pos: position{line: 118, col: 10, offset: 2710},
																			alternatives: []interface{}{
																				&charClassMatcher{
																					pos:        position{line: 116, col: 9, offset: 2692},
																					val:        "[0-9]",
																					ranges:     []rune{'0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																				&charClassMatcher{
																					pos:        position{line: 118, col: 18, offset: 2718},
																					val:        "[a-f]i",
																					ranges:     []rune{'a', 'f'},
																					ignoreCase: true,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
																&charClassMatcher{
																	pos:        position{line: 421, col: 13, offset: 11363},
																	val:        "[!$&\\*+;=:@/?]",
																	chars:      []rune{'!', '$', '&', '\'', '*', '+', ';', '=', ':', '@', '/', '?'},
																	ignoreCase: false,
																	inverted:   false,
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 423, col: 18, offset: 11429},
							label: "usingClause",
							expr: &zeroOrOneExpr{
								pos: position{line: 423, col: 30, offset: 11441},
								expr: &seqExpr{
									pos: position{line: 423, col: 32, offset: 11443},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 423, col: 32, offset: 11443},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 237, col: 9, offset: 6021},
											val:        "using",
											ignoreCase: false,
											want:       "\"using\"",
										},
										&ruleRefExpr{
											pos:  position{line: 423, col: 40, offset: 11451},
											name: "_1",
										},
										&ruleRefExpr{
											pos:  position{line: 423, col: 43, offset: 11454},
											name: "ImportExpression",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "ImportType",
			pos:  position{line: 464, col: 1, offset: 12650},
			expr: &choiceExpr{
				pos: position{line: 464, col: 14, offset: 12665},
				alternatives: []interface{}{
					&actionExpr{
						pos: position{line: 239, col: 11, offset: 6059},
						run: (*parser).callonImportType2,
						expr: &seqExpr{
							pos: position{line: 239, col: 11, offset: 6059},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 239, col: 11, offset: 6059},
									val:        "missing",
									ignoreCase: false,
									want:       "\"missing\"",
								},
								&notExpr{
									pos: position{line: 239, col: 21, offset: 6069},
									expr: &charClassMatcher{
										pos:        position{line: 121, col: 23, offset: 2785},
										val:        "[_/-A-Za-z0-9]",
										chars:      []rune{'_', '/', '-'},
										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
										ignoreCase: false,
										inverted:   false,
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 382, col: 14, offset: 10287},
						run: (*parser).callonImportType7,
						expr: &seqExpr{
							pos: position{line: 382, col: 14, offset: 10287},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 382, col: 14, offset: 10287},
									val:        "..",
									ignoreCase: false,
									want:       "\"..\"",
								},
								&labeledExpr{
									pos:   position{line: 382, col: 19, offset: 10292},
									label: "p",
									expr: &actionExpr{
										pos: position{line: 371, col: 8, offset: 9936},
										run: (*parser).callonImportType11,
										expr: &labeledExpr{
											pos:   position{line: 371, col: 8, offset: 9936},
											label: "cs",
											expr: &oneOrMoreExpr{
												pos: position{line: 371, col: 11, offset: 9939},
												expr: &choiceExpr{
													pos: position{line: 368, col: 17, offset: 9812},
													alternatives: []interface{}{
														&actionExpr{
															pos: position{line: 368, col: 17, offset: 9812},
															run: (*parser).callonImportType15,
															expr: &seqExpr{
																pos: position{line: 368, col: 17, offset: 9812},
																exprs: []interface{}{
																	&litMatcher{
																		pos:        position{line: 368, col: 17, offset: 9812},
																		val:        "/",
																		ignoreCase: false,
																		want:       "\"/\"",
																	},
																	&labeledExpr{
																		pos:   position{line: 368, col: 21, offset: 9816},
																		label: "u",
																		expr: &actionExpr{
																			pos: position{line: 365, col: 25, offset: 9671},
																			run: (*parser).callonImportType19,
																			expr: &oneOrMoreExpr{
																				pos: position{line: 365, col: 25, offset: 9671},
																				expr: &charClassMatcher{
																					pos:        position{line: 349, col: 6, offset: 9416},
																					val:        "[!=|~$-\\*-+--.0-;@-Z^-z]",
																					chars:      []rune{'!', '=', '|', '~'},
																					ranges:     []rune{'$', '\'', '*', '+', '-', '.', '0', ';', '@', 'Z', '^', 'z'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
															},
														},
														&actionExpr{
															pos: position{line: 369, col: 17, offset: 9874},
															run: (*parser).callonImportType22,
															expr: &seqExpr{
																pos: position{line: 369, col: 17, offset: 9874},
																exprs: []interface{}{
																	&litMatcher{
																		pos:        position{line: 369, col: 17, offset: 9874},
																		val:        "/\"",
																		ignoreCase: false,
																		want:       "\"/\\\"\"",
																	},
																	&labeledExpr{
																		pos:   position{line: 369, col: 25, offset: 9882},
																		label: "q",
																		expr: &actionExpr{
																			pos: position{line: 366, col: 23, offset: 9741},
																			run: (*parser).callonImportType26,
																			expr: &oneOrMoreExpr{
																				pos: position{line: 366, col: 23, offset: 9741},
																				expr: &charClassMatcher{
																					pos:        position{line: 360, col: 6, offset: 9579},
																					val:        "[𐀀D -!#-.0-\\u007f\\u0080-\\ud7ff\\ue000-�𐀀-\\U0001fffd𠀀-\\U0002fffd\\U00030000-\\U0003fffd\\U00040000-\\U0004fffd\\U00050000-\\U0005fffd\\U00060000-\\U0006fffd\\U00070000-\\U0007fffd\\U00080000-\\U0008fffd\\U00090000-\\U0009fffd\\U000a0000-\\U000afffd\\U000b0000-\\U000bfffd\\U000c0000-\\U000cfffd\\U000d0000-\\U000dfffd\\U000e0000-\\U000efffd\\U000f0000-\\U000ffffd0-\\U00010fff]",
																					chars:      []rune{'𐀀', 'D'},
																					ranges:     []rune{' ', '!', '#', '.', '0', '\u007f', '\u0080', '\ud7ff', '\ue000', '�', '𐀀', '\U0001fffd', '𠀀', '\U0002fffd', '\U00030000', '\U0003fffd', '\U00040000', '\U0004fffd', '\U00050000', '\U0005fffd', '\U00060000', '\U0006fffd', '\U00070000', '\U0007fffd', '\U00080000', '\U0008fffd', '\U00090000', '\U0009fffd', '\U000a0000', '\U000afffd', '\U000b0000', '\U000bfffd', '\U000c0000', '\U000cfffd', '\U000d0000', '\U000dfffd', '\U000e0000', '\U000efffd', '\U000f0000', '\U000ffffd', '0', '\U00010fff'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																	&litMatcher{
																		pos:        position{line: 369, col: 47, offset: 9904},
																		val:        "\"",
																		ignoreCase: false,
																		want:       "\"\\\"\"",
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 383, col: 12, offset: 10367},
						run: (*parser).callonImportType30,
						expr: &seqExpr{
							pos: position{line: 383, col: 12, offset: 10367},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 383, col: 12, offset: 10367},
									val:        ".",
									ignoreCase: false,
									want:       "\".\"",
								},
								&labeledExpr{
									pos:   position{line: 383, col: 16, offset: 10371},
									label: "p",
									expr: &actionExpr{
										pos: position{line: 371, col: 8, offset: 9936},
										run: (*parser).callonImportType34,
										expr: &labeledExpr{
											pos:   position{line: 371, col: 8, offset: 9936},
											label: "cs",
											expr: &oneOrMoreExpr{
												pos: position{line: 371, col: 11, offset: 9939},
												expr: &choiceExpr{
													pos: position{line: 368, col: 17, offset: 9812},
													alternatives: []interface{}{
														&actionExpr{
															pos: position{line: 368, col: 17, offset: 9812},
															run: (*parser).callonImportType38,
															expr: &seqExpr{
																pos: position{line: 368, col: 17, offset: 9812},
																exprs: []interface{}{
																	&litMatcher{
																		pos:        position{line: 368, col: 17, offset: 9812},
																		val:        "/",
																		ignoreCase: false,
																		want:       "\"/\"",
																	},
																	&labeledExpr{
																		pos:   position{line: 368, col: 21, offset: 9816},
																		label: "u",
																		expr: &actionExpr{
																			pos: position{line: 365, col: 25, offset: 9671},
																			run: (*parser).callonImportType42,
																			expr: &oneOrMoreExpr{
																				pos: position{line: 365, col: 25, offset: 9671},
																				expr: &charClassMatcher{
																					pos:        position{line: 349, col: 6, offset: 9416},
																					val:        "[!=|~$-\\*-+--.0-;@-Z^-z]",
																					chars:      []rune{'!', '=', '|', '~'},
																					ranges:     []rune{'$', '\'', '*', '+', '-', '.', '0', ';', '@', 'Z', '^', 'z'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
															},
														},
														&actionExpr{
															pos: position{line: 369, col: 17, offset: 9874},
															run: (*parser).callonImportType45,
															expr: &seqExpr{
																pos: position{line: 369, col: 17, offset: 9874},
																exprs: []interface{}{
																	&litMatcher{
																		pos:        position{line: 369, col: 17, offset: 9874},
																		val:        "/\"",
																		ignoreCase: false,
																		want:       "\"/\\\"\"",
																	},
																	&labeledExpr{
																		pos:   position{line: 369, col: 25, offset: 9882},
																		label: "q",
																		expr: &actionExpr{
																			pos: position{line: 366, col: 23, offset: 9741},
																			run: (*parser).callonImportType49,
																			expr: &oneOrMoreExpr{
																				pos: position{line: 366, col: 23, offset: 9741},
																				expr: &charClassMatcher{
																					pos:        position{line: 360, col: 6, offset: 9579},
																					val:        "[𐀀D -!#-.0-\\u007f\\u0080-\\ud7ff\\ue000-�𐀀-\\U0001fffd𠀀-\\U0002fffd\\U00030000-\\U0003fffd\\U00040000-\\U0004fffd\\U00050000-\\U0005fffd\\U00060000-\\U0006fffd\\U00070000-\\U0007fffd\\U00080000-\\U0008fffd\\U00090000-\\U0009fffd\\U000a0000-\\U000afffd\\U000b0000-\\U000bfffd\\U000c0000-\\U000cfffd\\U000d0000-\\U000dfffd\\U000e0000-\\U000efffd\\U000f0000-\\U000ffffd0-\\U00010fff]",
																					chars:      []rune{'𐀀', 'D'},
																					ranges:     []rune{' ', '!', '#', '.', '0', '\u007f', '\u0080', '\ud7ff', '\ue000', '�', '𐀀', '\U0001fffd', '𠀀', '\U0002fffd', '\U00030000', '\U0003fffd', '\U00040000', '\U0004fffd', '\U00050000', '\U0005fffd', '\U00060000', '\U0006fffd', '\U00070000', '\U0007fffd', '\U00080000', '\U0008fffd', '\U00090000', '\U0009fffd', '\U000a0000', '\U000afffd', '\U000b0000', '\U000bfffd', '\U000c0000', '\U000cfffd', '\U000d0000', '\U000dfffd', '\U000e0000', '\U000efffd', '\U000f0000', '\U000ffffd', '0', '\U00010fff'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																	&litMatcher{
																		pos:        position{line: 369, col: 47, offset: 9904},
																		val:        "\"",
																		ignoreCase: false,
																		want:       "\"\\\"\"",
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 384, col: 12, offset: 10429},
						run: (*parser).callonImportType53,
						expr: &seqExpr{
							pos: position{line: 384, col: 12, offset: 10429},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 384, col: 12, offset: 10429},
									val:        "~",
									ignoreCase: false,
									want:       "\"~\"",
								},
								&labeledExpr{
									pos:   position{line: 384, col: 16, offset: 10433},
									label: "p",
									expr: &actionExpr{
										pos: position{line: 371, col: 8, offset: 9936},
										run: (*parser).callonImportType57,
										expr: &labeledExpr{
											pos:   position{line: 371, col: 8, offset: 9936},
											label: "cs",
											expr: &oneOrMoreExpr{
												pos: position{line: 371, col: 11, offset: 9939},
												expr: &choiceExpr{
													pos: position{line: 368, col: 17, offset: 9812},
													alternatives: []interface{}{
														&actionExpr{
															pos: position{line: 368, col: 17, offset: 9812},
															run: (*parser).callonImportType61,
															expr: &seqExpr{
																pos: position{line: 368, col: 17, offset: 9812},
																exprs: []interface{}{
																	&litMatcher{
																		pos:        position{line: 368, col: 17, offset: 9812},
																		val:        "/",
																		ignoreCase: false,
																		want:       "\"/\"",
																	},
																	&labeledExpr{
																		pos:   position{line: 368, col: 21, offset: 9816},
																		label: "u",
																		expr: &actionExpr{
																			pos: position{line: 365, col: 25, offset: 9671},
																			run: (*parser).callonImportType65,
																			expr: &oneOrMoreExpr{
																				pos: position{line: 365, col: 25, offset: 9671},
																				expr: &charClassMatcher{
																					pos:        position{line: 349, col: 6, offset: 9416},
																					val:        "[!=|~$-\\*-+--.0-;@-Z^-z]",
																					chars:      []rune{'!', '=', '|', '~'},
																					ranges:     []rune{'$', '\'', '*', '+', '-', '.', '0', ';', '@', 'Z', '^', 'z'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
															},
														},
														&actionExpr{
															pos: position{line: 369, col: 17, offset: 9874},
															run: (*parser).callonImportType68,
															expr: &seqExpr{
																pos: position{line: 369, col: 17, offset: 9874},
																exprs: []interface{}{
																	&litMatcher{
																		pos:        position{line: 369, col: 17, offset: 9874},
																		val:        "/\"",
																		ignoreCase: false,
																		want:       "\"/\\\"\"",
																	},
																	&labeledExpr{
																		pos:   position{line: 369, col: 25, offset: 9882},
																		label: "q",
																		expr: &actionExpr{
																			pos: position{line: 366, col: 23, offset: 9741},
																			run: (*parser).callonImportType72,
																			expr: &oneOrMoreExpr{
																				pos: position{line: 366, col: 23, offset: 9741},
																				expr: &charClassMatcher{
																					pos:        position{line: 360, col: 6, offset: 9579},
																					val:        "[𐀀D -!#-.0-\\u007f\\u0080-\\ud7ff\\ue000-�𐀀-\\U0001fffd𠀀-\\U0002fffd\\U00030000-\\U0003fffd\\U00040000-\\U0004fffd\\U00050000-\\U0005fffd\\U00060000-\\U0006fffd\\U00070000-\\U0007fffd\\U00080000-\\U0008fffd\\U00090000-\\U0009fffd\\U000a0000-\\U000afffd\\U000b0000-\\U000bfffd\\U000c0000-\\U000cfffd\\U000d0000-\\U000dfffd\\U000e0000-\\U000efffd\\U000f0000-\\U000ffffd0-\\U00010fff]",
																					chars:      []rune{'𐀀', 'D'},
																					ranges:     []rune{' ', '!', '#', '.', '0', '\u007f', '\u0080', '\ud7ff', '\ue000', '�', '𐀀', '\U0001fffd', '𠀀', '\U0002fffd', '\U00030000', '\U0003fffd', '\U00040000', '\U0004fffd', '\U00050000', '\U0005fffd', '\U00060000', '\U0006fffd', '\U00070000', '\U0007fffd', '\U00080000', '\U0008fffd', '\U00090000', '\U0009fffd', '\U000a0000', '\U000afffd', '\U000b0000', '\U000bfffd', '\U000c0000', '\U000cfffd', '\U000d0000', '\U000dfffd', '\U000e0000', '\U000efffd', '\U000f0000', '\U000ffffd', '0', '\U00010fff'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																	&litMatcher{
																		pos:        position{line: 369, col: 47, offset: 9904},
																		val:        "\"",
																		ignoreCase: false,
																		want:       "\"\\\"\"",
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 385, col: 16, offset: 10511},
						run: (*parser).callonImportType76,
						expr: &labeledExpr{
							pos:   position{line: 385, col: 16, offset: 10511},
							label: "p",
							expr: &actionExpr{
								pos: position{line: 371, col: 8, offset: 9936},
								run: (*parser).callonImportType78,
								expr: &labeledExpr{
									pos:   position{line: 371, col: 8, offset: 9936},
									label: "cs",
									expr: &oneOrMoreExpr{
										pos: position{line: 371, col: 11, offset: 9939},
										expr: &choiceExpr{
											pos: position{line: 368, col: 17, offset: 9812},
											alternatives: []interface{}{
												&actionExpr{
													pos: position{line: 368, col: 17, offset: 9812},
													run: (*parser).callonImportType82,
													expr: &seqExpr{
														pos: position{line: 368, col: 17, offset: 9812},
														exprs: []interface{}{
															&litMatcher{
																pos:        position{line: 368, col: 17, offset: 9812},
																val:        "/",
																ignoreCase: false,
																want:       "\"/\"",
															},
															&labeledExpr{
																pos:   position{line: 368, col: 21, offset: 9816},
																label: "u",
																expr: &actionExpr{
																	pos: position{line: 365, col: 25, offset: 9671},
																	run: (*parser).callonImportType86,
																	expr: &oneOrMoreExpr{
																		pos: position{line: 365, col: 25, offset: 9671},
																		expr: &charClassMatcher{
																			pos:        position{line: 349, col: 6, offset: 9416},
																			val:        "[!=|~$-\\*-+--.0-;@-Z^-z]",
																			chars:      []rune{'!', '=', '|', '~'},
																			ranges:     []rune{'$', '\'', '*', '+', '-', '.', '0', ';', '@', 'Z', '^', 'z'},
																			ignoreCase: false,
																			inverted:   false,
																		},
																	},
																},
															},
														},
													},
												},
												&actionExpr{
													pos: position{line: 369, col: 17, offset: 9874},
													run: (*parser).callonImportType89,
													expr: &seqExpr{
														pos: position{line: 369, col: 17, offset: 9874},
														exprs: []interface{}{
															&litMatcher{
																pos:        position{line: 369, col: 17, offset: 9874},
																val:        "/\"",
																ignoreCase: false,
																want:       "\"/\\\"\"",
															},
															&labeledExpr{
																pos:   position{line: 369, col: 25, offset: 9882},
																label: "q",
																expr: &actionExpr{
																	pos: position{line: 366, col: 23, offset: 9741},
																	run: (*parser).callonImportType93,
																	expr: &oneOrMoreExpr{
																		pos: position{line: 366, col: 23, offset: 9741},
																		expr: &charClassMatcher{
																			pos:        position{line: 360, col: 6, offset: 9579},
																			val:        "[𐀀D -!#-.0-\\u007f\\u0080-\\ud7ff\\ue000-�𐀀-\\U0001fffd𠀀-\\U0002fffd\\U00030000-\\U0003fffd\\U00040000-\\U0004fffd\\U00050000-\\U0005fffd\\U00060000-\\U0006fffd\\U00070000-\\U0007fffd\\U00080000-\\U0008fffd\\U00090000-\\U0009fffd\\U000a0000-\\U000afffd\\U000b0000-\\U000bfffd\\U000c0000-\\U000cfffd\\U000d0000-\\U000dfffd\\U000e0000-\\U000efffd\\U000f0000-\\U000ffffd0-\\U00010fff]",
																			chars:      []rune{'𐀀', 'D'},
																			ranges:     []rune{' ', '!', '#', '.', '0', '\u007f', '\u0080', '\ud7ff', '\ue000', '�', '𐀀', '\U0001fffd', '𠀀', '\U0002fffd', '\U00030000', '\U0003fffd', '\U00040000', '\U0004fffd', '\U00050000', '\U0005fffd', '\U00060000', '\U0006fffd', '\U00070000', '\U0007fffd', '\U00080000', '\U0008fffd', '\U00090000', '\U0009fffd', '\U000a0000', '\U000afffd', '\U000b0000', '\U000bfffd', '\U000c0000', '\U000cfffd', '\U000d0000', '\U000dfffd', '\U000e0000', '\U000efffd', '\U000f0000', '\U000ffffd', '0', '\U00010fff'},
																			ignoreCase: false,
																			inverted:   false,
																		},
																	},
																},
															},
															&litMatcher{
																pos:        position{line: 369, col: 47, offset: 9904},
																val:        "\"",
																ignoreCase: false,
																want:       "\"\\\"\"",
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 464, col: 32, offset: 12683},
						name: "Http",
					},
					&actionExpr{
						pos: position{line: 430, col: 7, offset: 11662},
						run: (*parser).callonImportType98,
						expr: &seqExpr{
							pos: position{line: 430, col: 7, offset: 11662},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 430, col: 7, offset: 11662},
									val:        "env:",
									ignoreCase: false,
									want:       "\"env:\"",
								},
								&labeledExpr{
									pos:   position{line: 430, col: 14, offset: 11669},
									label: "v",
									expr: &choiceExpr{
										pos: position{line: 430, col: 17, offset: 11672},
										alternatives: []interface{}{
											&actionExpr{
												pos: position{line: 432, col: 27, offset: 11771},
												run: (*parser).callonImportType103,
												expr: &seqExpr{
													pos: position{line: 432, col: 27, offset: 11771},
													exprs: []interface{}{
														&charClassMatcher{
															pos:        position{line: 432, col: 27, offset: 11771},
															val:        "[_A-Za-z]",
															chars:      []rune{'_'},
															ranges:     []rune{'A', 'Z', 'a', 'z'},
															ignoreCase: false,
															inverted:   false,
														},
														&zeroOrMoreExpr{
															pos: position{line: 432, col: 36, offset: 11780},
															expr: &charClassMatcher{
																pos:        position{line: 432, col: 36, offset: 11780},
																val:        "[_A-Za-z0-9]",
																chars:      []rune{'_'},
																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
											},
											&actionExpr{
												pos: position{line: 436, col: 28, offset: 11865},
												run: (*parser).callonImportType108,
												expr: &seqExpr{
													pos: position{line: 436, col: 28, offset: 11865},
													exprs: []interface{}{
														&litMatcher{
															pos:        position{line: 436, col: 28, offset: 11865},
															val:        "\"",
															ignoreCase: false,
															want:       "\"\\\"\"",
														},
														&labeledExpr{
															pos:   position{line: 436, col: 32, offset: 11869},
															label: "v",
															expr: &actionExpr{
																pos: position{line: 440, col: 35, offset: 11964},
																run: (*parser).callonImportType112,
																expr: &labeledExpr{
																	pos:   position{line: 440, col: 35, offset: 11964},
																	label: "v",
																	expr: &oneOrMoreExpr{
																		pos: position{line: 440, col: 37, offset: 11966},
																		expr: &choiceExpr{
																			pos: position{line: 450, col: 7, offset: 12223},
																			alternatives: []interface{}{
																				&actionExpr{
																					pos: position{line: 450, col: 7, offset: 12223},
																					run: (*parser).callonImportType116,
																					expr: &litMatcher{
																						pos:        position{line: 450, col: 7, offset: 12223},
																						val:        "\\\"",
																						ignoreCase: false,
																						want:       "\"\\\\\\\"\"",
																					},
																				},
																				&actionExpr{
																					pos: position{line: 451, col: 7, offset: 12263},
																					run: (*parser).callonImportType118,
																					expr: &litMatcher{
																						pos:        position{line: 451, col: 7, offset: 12263},
																						val:        "\\\\",
																						ignoreCase: false,
																						want:       "\"\\\\\\\\\"",
																					},
																				},
																				&actionExpr{
																					pos: position{line: 452, col: 7, offset: 12303},
																					run: (*parser).callonImportType120,
																					expr: &litMatcher{
																						pos:        position{line: 452, col: 7, offset: 12303},
																						val:        "\\a",
																						ignoreCase: false,
																						want:       "\"\\\\a\"",
																					},
																				},
																				&actionExpr{
																					pos: position{line: 453, col: 7, offset: 12343},
																					run: (*parser).callonImportType122,
																					expr: &litMatcher{
																						pos:        position{line: 453, col: 7, offset: 12343},
																						val:        "\\b",
																						ignoreCase: false,
																						want:       "\"\\\\b\"",
																					},
																				},
																				&actionExpr{
																					pos: position{line: 454, col: 7, offset: 12383},
																					run: (*parser).callonImportType124,
																					expr: &litMatcher{
																						pos:        position{line: 454, col: 7, offset: 12383},
																						val:        "\\f",
																						ignoreCase: false,
																						want:       "\"\\\\f\"",
																					},
																				},
																				&actionExpr{
																					pos: position{line: 455, col: 7, offset: 12423},
																					run: (*parser).callonImportType126,
																					expr: &litMatcher{
																						pos:        position{line: 455, col: 7, offset: 12423},
																						val:        "\\n",
																						ignoreCase: false,
																						want:       "\"\\\\n\"",
																					},
																				},
																				&actionExpr{
																					pos: position{line: 456, col: 7, offset: 12463},
																					run: (*parser).callonImportType128,
																					expr: &litMatcher{
																						pos:        position{line: 456, col: 7, offset: 12463},
																						val:        "\\r",
																						ignoreCase: false,
																						want:       "\"\\\\r\"",
																					},
																				},
																				&actionExpr{
																					pos: position{line: 457, col: 7, offset: 12503},
																					run: (*parser).callonImportType130,
																					expr: &litMatcher{
																						pos:        position{line: 457, col: 7, offset: 12503},
																						val:        "\\t",
																						ignoreCase: false,
																						want:       "\"\\\\t\"",
																					},
																				},
																				&actionExpr{
																					pos: position{line: 458, col: 7, offset: 12543},
																					run: (*parser).callonImportType132,
																					expr: &litMatcher{
																						pos:        position{line: 458, col: 7, offset: 12543},
																						val:        "\\v",
																						ignoreCase: false,
																						want:       "\"\\\\v\"",
																					},
																				},
																				&charClassMatcher{
																					pos:        position{line: 459, col: 7, offset: 12583},
																					val:        "[ -!#-<>-[]-~]",
																					ranges:     []rune{' ', '!', '#', '<', '>', '[', ']', '~'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
															},
														},
														&litMatcher{
															pos:        position{line: 436, col: 66, offset: 11903},
															val:        "\"",
															ignoreCase: false,
															want:       "\"\\\"\"",
														},
													},
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "ImportHashed",
			pos:  position{line: 482, col: 1, offset: 13535},
			expr: &actionExpr{
				pos: position{line: 482, col: 16, offset: 13552},
				run: (*parser).callonImportHashed1,
				expr: &seqExpr{
					pos: position{line: 482, col: 16, offset: 13552},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 482, col: 16, offset: 13552},
							label: "i",
							expr: &ruleRefExpr{
								pos:  position{line: 482, col: 18, offset: 13554},
								name: "ImportType",
							},
						},
						&labeledExpr{
							pos:   position{line: 482, col: 29, offset: 13565},
							label: "h",
							expr: &zeroOrOneExpr{
								pos: position{line: 482, col: 31, offset: 13567},
								expr: &seqExpr{
									pos: position{line: 482, col: 32, offset: 13568},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 482, col: 32, offset: 13568},
											name: "_1",
										},
										&actionExpr{
											pos: position{line: 480, col: 8, offset: 13451},
											run: (*parser).callonImportHashed9,
											expr: &seqExpr{
												pos: position{line: 480, col: 8, offset: 13451},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 480, col: 8, offset: 13451},
														val:        "sha256:",
														ignoreCase: false,
														want:       "\"sha256:\"",
													},
													&labeledExpr{
														pos:   position{line: 480, col: 18, offset: 13461},
														label: "val",
														expr: &actionExpr{
															pos: position{line: 467, col: 13, offset: 12775},
															run: (*parser).callonImportHashed13,
															expr: &seqExpr{
																pos: position{line: 467, col: 13, offset: 12775},
																exprs: []interface{}{
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																	&choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Import",
			pos:  position{line: 490, col: 1, offset: 13726},
			expr: &choiceExpr{
				pos: position{line: 490, col: 10, offset: 13737},
				alternatives: []interface{}{
					&actionExpr{
						pos: position{line: 490, col: 10, offset: 13737},
						run: (*parser).callonImport2,
						expr: &seqExpr{
							pos: position{line: 490, col: 10, offset: 13737},
							exprs: []interface{}{
								&labeledExpr{
									pos:   position{line: 490, col: 10, offset: 13737},
									label: "i",
									expr: &ruleRefExpr{
										pos:  position{line: 490, col: 12, offset: 13739},
										name: "ImportHashed",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 490, col: 25, offset: 13752},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 236, col: 6, offset: 6006},
									val:        "as",
									ignoreCase: false,
									want:       "\"as\"",
								},
								&ruleRefExpr{
									pos:  position{line: 490, col: 30, offset: 13757},
									name: "_1",
								},
								&litMatcher{
									pos:        position{line: 295, col: 8, offset: 7902},
									val:        "Text",
									ignoreCase: false,
									want:       "\"Text\"",
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 491, col: 10, offset: 13850},
						run: (*parser).callonImport10,
						expr: &seqExpr{
							pos: position{line: 491, col: 10, offset: 13850},
							exprs: []interface{}{
								&labeledExpr{
									pos:   position{line: 491, col: 10, offset: 13850},
									label: "i",
									expr: &ruleRefExpr{
										pos:  position{line: 491, col: 12, offset: 13852},
										name: "ImportHashed",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 491, col: 25, offset: 13865},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 236, col: 6, offset: 6006},
									val:        "as",
									ignoreCase: false,
									want:       "\"as\"",
								},
								&ruleRefExpr{
									pos:  position{line: 491, col: 30, offset: 13870},
									name: "_1",
								},
								&litMatcher{
									pos:        position{line: 296, col: 12, offset: 7922},
									val:        "Location",
									ignoreCase: false,
									want:       "\"Location\"",
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 492, col: 10, offset: 13968},
						run: (*parser).callonImport18,
						expr: &labeledExpr{
							pos:   position{line: 492, col: 10, offset: 13968},
							label: "i",
							expr: &ruleRefExpr{
								pos:  position{line: 492, col: 12, offset: 13970},
								name: "ImportHashed",
							},
						},
					},
				},
			},
		},
		{
			name: "LetBinding",
			pos:  position{line: 495, col: 1, offset: 14058},
			expr: &actionExpr{
				pos: position{line: 495, col: 14, offset: 14073},
				run: (*parser).callonLetBinding1,
				expr: &seqExpr{
					pos: position{line: 495, col: 14, offset: 14073},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 234, col: 7, offset: 5981},
							val:        "let",
							ignoreCase: false,
							want:       "\"let\"",
						},
						&ruleRefExpr{
							pos:  position{line: 495, col: 18, offset: 14077},
							name: "_1",
						},
						&labeledExpr{
							pos:   position{line: 495, col: 21, offset: 14080},
							label: "label",
							expr: &choiceExpr{
								pos: position{line: 134, col: 20, offset: 3237},
								alternatives: []interface{}{
									&actionExpr{
										pos: position{line: 134, col: 20, offset: 3237},
										run: (*parser).callonLetBinding7,
										expr: &seqExpr{
											pos: position{line: 134, col: 20, offset: 3237},
											exprs: []interface{}{
												&andExpr{
													pos: position{line: 134, col: 20, offset: 3237},
													expr: &seqExpr{
														pos: position{line: 134, col: 22, offset: 3239},
														exprs: []interface{}{
															&choiceExpr{
																pos: position{line: 259, col: 5, offset: 6416},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 259, col: 5, offset: 6416},
																		run: (*parser).callonLetBinding12,
																		expr: &litMatcher{
																			pos:        position{line: 259, col: 5, offset: 6416},
																			val:        "Natural/fold",
																			ignoreCase: false,
																			want:       "\"Natural/fold\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 260, col: 5, offset: 6463},
																		run: (*parser).callonLetBinding14,
																		expr: &litMatcher{
																			pos:        position{line: 260, col: 5, offset: 6463},
																			val:        "Natural/build",
																			ignoreCase: false,
																			want:       "\"Natural/build\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 261, col: 5, offset: 6512},
																		run: (*parser).callonLetBinding16,
																		expr: &litMatcher{
																			pos:        position{line: 261, col: 5, offset: 6512},
																			val:        "Natural/isZero",
																			ignoreCase: false,
																			want:       "\"Natural/isZero\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 262, col: 5, offset: 6563},
																		run: (*parser).callonLetBinding18,
																		expr: &litMatcher{
																			pos:        position{line: 262, col: 5, offset: 6563},
																			val:        "Natural/even",
																			ignoreCase: false,
																			want:       "\"Natural/even\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 263, col: 5, offset: 6610},
																		run: (*parser).callonLetBinding20,
																		expr: &litMatcher{
																			pos:        position{line: 263, col: 5, offset: 6610},
																			val:        "Natural/odd",
																			ignoreCase: false,
																			want:       "\"Natural/odd\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 264, col: 5, offset: 6655},
																		run: (*parser).callonLetBinding22,
																		expr: &litMatcher{
																			pos:        position{line: 264, col: 5, offset: 6655},
																			val:        "Natural/toInteger",
																			ignoreCase: false,
																			want:       "\"Natural/toInteger\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 265, col: 5, offset: 6712},
																		run: (*parser).callonLetBinding24,
																		expr: &litMatcher{
																			pos:        position{line: 265, col: 5, offset: 6712},
																			val:        "Natural/show",
																			ignoreCase: false,
																			want:       "\"Natural/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 266, col: 5, offset: 6759},
																		run: (*parser).callonLetBinding26,
																		expr: &litMatcher{
																			pos:        position{line: 266, col: 5, offset: 6759},
																			val:        "Integer/toDouble",
																			ignoreCase: false,
																			want:       "\"Integer/toDouble\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 267, col: 5, offset: 6814},
																		run: (*parser).callonLetBinding28,
																		expr: &litMatcher{
																			pos:        position{line: 267, col: 5, offset: 6814},
																			val:        "Integer/show",
																			ignoreCase: false,
																			want:       "\"Integer/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 268, col: 5, offset: 6861},
																		run: (*parser).callonLetBinding30,
																		expr: &litMatcher{
																			pos:        position{line: 268, col: 5, offset: 6861},
																			val:        "Integer/negate",
																			ignoreCase: false,
																			want:       "\"Integer/negate\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 269, col: 5, offset: 6912},
																		run: (*parser).callonLetBinding32,
																		expr: &litMatcher{
																			pos:        position{line: 269, col: 5, offset: 6912},
																			val:        "Integer/clamp",
																			ignoreCase: false,
																			want:       "\"Integer/clamp\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 270, col: 5, offset: 6961},
																		run: (*parser).callonLetBinding34,
																		expr: &litMatcher{
																			pos:        position{line: 270, col: 5, offset: 6961},
																			val:        "Natural/subtract",
																			ignoreCase: false,
																			want:       "\"Natural/subtract\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 271, col: 5, offset: 7016},
																		run: (*parser).callonLetBinding36,
																		expr: &litMatcher{
																			pos:        position{line: 271, col: 5, offset: 7016},
																			val:        "Double/show",
																			ignoreCase: false,
																			want:       "\"Double/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 272, col: 5, offset: 7061},
																		run: (*parser).callonLetBinding38,
																		expr: &litMatcher{
																			pos:        position{line: 272, col: 5, offset: 7061},
																			val:        "List/build",
																			ignoreCase: false,
																			want:       "\"List/build\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 273, col: 5, offset: 7104},
																		run: (*parser).callonLetBinding40,
																		expr: &litMatcher{
																			pos:        position{line: 273, col: 5, offset: 7104},
																			val:        "List/fold",
																			ignoreCase: false,
																			want:       "\"List/fold\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 274, col: 5, offset: 7145},
																		run: (*parser).callonLetBinding42,
																		expr: &litMatcher{
																			pos:        position{line: 274, col: 5, offset: 7145},
																			val:        "List/length",
																			ignoreCase: false,
																			want:       "\"List/length\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 275, col: 5, offset: 7190},
																		run: (*parser).callonLetBinding44,
																		expr: &litMatcher{
																			pos:        position{line: 275, col: 5, offset: 7190},
																			val:        "List/head",
																			ignoreCase: false,
																			want:       "\"List/head\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 276, col: 5, offset: 7231},
																		run: (*parser).callonLetBinding46,
																		expr: &litMatcher{
																			pos:        position{line: 276, col: 5, offset: 7231},
																			val:        "List/last",
																			ignoreCase: false,
																			want:       "\"List/last\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 277, col: 5, offset: 7272},
																		run: (*parser).callonLetBinding48,
																		expr: &litMatcher{
																			pos:        position{line: 277, col: 5, offset: 7272},
																			val:        "List/indexed",
																			ignoreCase: false,
																			want:       "\"List/indexed\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 278, col: 5, offset: 7319},
																		run: (*parser).callonLetBinding50,
																		expr: &litMatcher{
																			pos:        position{line: 278, col: 5, offset: 7319},
																			val:        "List/reverse",
																			ignoreCase: false,
																			want:       "\"List/reverse\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 279, col: 5, offset: 7366},
																		run: (*parser).callonLetBinding52,
																		expr: &litMatcher{
																			pos:        position{line: 279, col: 5, offset: 7366},
																			val:        "Text/show",
																			ignoreCase: false,
																			want:       "\"Text/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 280, col: 5, offset: 7407},
																		run: (*parser).callonLetBinding54,
																		expr: &litMatcher{
																			pos:        position{line: 280, col: 5, offset: 7407},
																			val:        "Text/replace",
																			ignoreCase: false,
																			want:       "\"Text/replace\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 281, col: 5, offset: 7454},
																		run: (*parser).callonLetBinding56,
																		expr: &litMatcher{
																			pos:        position{line: 281, col: 5, offset: 7454},
																			val:        "Bool",
																			ignoreCase: false,
																			want:       "\"Bool\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 282, col: 5, offset: 7486},
																		run: (*parser).callonLetBinding58,
																		expr: &litMatcher{
																			pos:        position{line: 282, col: 5, offset: 7486},
																			val:        "True",
																			ignoreCase: false,
																			want:       "\"True\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 283, col: 5, offset: 7518},
																		run: (*parser).callonLetBinding60,
																		expr: &litMatcher{
																			pos:        position{line: 283, col: 5, offset: 7518},
																			val:        "False",
																			ignoreCase: false,
																			want:       "\"False\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 284, col: 5, offset: 7552},
																		run: (*parser).callonLetBinding62,
																		expr: &litMatcher{
																			pos:        position{line: 284, col: 5, offset: 7552},
																			val:        "Optional",
																			ignoreCase: false,
																			want:       "\"Optional\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 285, col: 5, offset: 7592},
																		run: (*parser).callonLetBinding64,
																		expr: &litMatcher{
																			pos:        position{line: 285, col: 5, offset: 7592},
																			val:        "None",
																			ignoreCase: false,
																			want:       "\"None\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 286, col: 5, offset: 7624},
																		run: (*parser).callonLetBinding66,
																		expr: &litMatcher{
																			pos:        position{line: 286, col: 5, offset: 7624},
																			val:        "Natural",
																			ignoreCase: false,
																			want:       "\"Natural\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 287, col: 5, offset: 7662},
																		run: (*parser).callonLetBinding68,
																		expr: &litMatcher{
																			pos:        position{line: 287, col: 5, offset: 7662},
																			val:        "Integer",
																			ignoreCase: false,
																			want:       "\"Integer\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 288, col: 5, offset: 7700},
																		run: (*parser).callonLetBinding70,
																		expr: &litMatcher{
																			pos:        position{line: 288, col: 5, offset: 7700},
																			val:        "Double",
																			ignoreCase: false,
																			want:       "\"Double\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 289, col: 5, offset: 7736},
																		run: (*parser).callonLetBinding72,
																		expr: &litMatcher{
																			pos:        position{line: 289, col: 5, offset: 7736},
																			val:        "Text",
																			ignoreCase: false,
																			want:       "\"Text\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 290, col: 5, offset: 7768},
																		run: (*parser).callonLetBinding74,
																		expr: &litMatcher{
																			pos:        position{line: 290, col: 5, offset: 7768},
																			val:        "List",
																			ignoreCase: false,
																			want:       "\"List\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 291, col: 5, offset: 7800},
																		run: (*parser).callonLetBinding76,
																		expr: &litMatcher{
																			pos:        position{line: 291, col: 5, offset: 7800},
																			val:        "Type",
																			ignoreCase: false,
																			want:       "\"Type\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 292, col: 5, offset: 7832},
																		run: (*parser).callonLetBinding78,
																		expr: &litMatcher{
																			pos:        position{line: 292, col: 5, offset: 7832},
																			val:        "Kind",
																			ignoreCase: false,
																			want:       "\"Kind\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 293, col: 5, offset: 7864},
																		run: (*parser).callonLetBinding80,
																		expr: &litMatcher{
																			pos:        position{line: 293, col: 5, offset: 7864},
																			val:        "Sort",
																			ignoreCase: false,
																			want:       "\"Sort\"",
																		},
																	},
																},
															},
															&charClassMatcher{
																pos:        position{line: 121, col: 23, offset: 2785},
																val:        "[_/-A-Za-z0-9]",
																chars:      []rune{'_', '/', '-'},
																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
												&labeledExpr{
													pos:   position{line: 134, col: 51, offset: 3268},
													label: "label",
													expr: &choiceExpr{
														pos: position{line: 131, col: 9, offset: 3119},
														alternatives: []interface{}{
															&actionExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																run: (*parser).callonLetBinding85,
																expr: &seqExpr{
																	pos: position{line: 131, col: 9, offset: 3119},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 131, col: 9, offset: 3119},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																		&labeledExpr{
																			pos:   position{line: 131, col: 13, offset: 3123},
																			label: "label",
																			expr: &actionExpr{
																				pos: position{line: 129, col: 15, offset: 3060},
																				run: (*parser).callonLetBinding89,
																				expr: &zeroOrMoreExpr{
																					pos: position{line: 129, col: 15, offset: 3060},
																					expr: &charClassMatcher{
																						pos:        position{line: 128, col: 19, offset: 3023},
																						val:        "[ -_a-~]",
																						ranges:     []rune{' ', '_', 'a', '~'},
																						ignoreCase: false,
																						inverted:   false,
																					},
																				},
																			},
																		},
																		&litMatcher{
																			pos:        position{line: 131, col: 31, offset: 3141},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																	},
																},
															},
															&actionExpr{
																pos: position{line: 132, col: 9, offset: 3175},
																run: (*parser).callonLetBinding93,
																expr: &labeledExpr{
																	pos:   position{line: 132, col: 9, offset: 3175},
																	label: "label",
																	expr: &choiceExpr{
																		pos: position{line: 122, col: 15, offset: 2816},
																		alternatives: []interface{}{
																			&actionExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				run: (*parser).callonLetBinding96,
																				expr: &seqExpr{
																					pos: position{line: 122, col: 15, offset: 2816},
																					exprs: []interface{}{
																						&choiceExpr{
																							pos: position{line: 249, col: 5, offset: 6269},
																							alternatives: []interface{}{
																								&litMatcher{
																									pos:        position{line: 231, col: 6, offset: 5936},
																									val:        "if",
																									ignoreCase: false,
																									want:       "\"if\"",
																								},
																								&litMatcher{
																									pos:        position{line: 232, col: 8, offset: 5950},
																									val:        "then",
																									ignoreCase: false,
																									want:       "\"then\"",
																								},
																								&litMatcher{
																									pos:        position{line: 233, col: 8, offset: 5966},
																									val:        "else",
																									ignoreCase: false,
																									want:       "\"else\"",
																								},
																								&litMatcher{
																									pos:        position{line: 234, col: 7, offset: 5981},
																									val:        "let",
																									ignoreCase: false,
																									want:       "\"let\"",
																								},
																								&litMatcher{
																									pos:        position{line: 235, col: 6, offset: 5994},
																									val:        "in",
																									ignoreCase: false,
																									want:       "\"in\"",
																								},
																								&litMatcher{
																									pos:        position{line: 237, col: 9, offset: 6021},
																									val:        "using",
																									ignoreCase: false,
																									want:       "\"using\"",
																								},
																								&actionExpr{
																									pos: position{line: 239, col: 11, offset: 6059},
																									run: (*parser).callonLetBinding105,
																									expr: &seqExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										exprs: []interface{}{
																											&litMatcher{
																												pos:        position{line: 239, col: 11, offset: 6059},
																												val:        "missing",
																												ignoreCase: false,
																												want:       "\"missing\"",
																											},
																											&notExpr{
																												pos: position{line: 239, col: 21, offset: 6069},
																												expr: &charClassMatcher{
																													pos:        position{line: 121, col: 23, offset: 2785},
																													val:        "[_/-A-Za-z0-9]",
																													chars:      []rune{'_', '/', '-'},
																													ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																													ignoreCase: false,
																													inverted:   false,
																												},
																											},
																										},
																									},
																								},
																								&litMatcher{
																									pos:        position{line: 244, col: 10, offset: 6199},
																									val:        "assert",
																									ignoreCase: false,
																									want:       "\"assert\"",
																								},
																								&litMatcher{
																									pos:        position{line: 236, col: 6, offset: 6006},
																									val:        "as",
																									ignoreCase: false,
																									want:       "\"as\"",
																								},
																								&litMatcher{
																									pos:        position{line: 240, col: 12, offset: 6129},
																									val:        "Infinity",
																									ignoreCase: false,
																									want:       "\"Infinity\"",
																								},
																								&litMatcher{
																									pos:        position{line: 241, col: 7, offset: 6148},
																									val:        "NaN",
																									ignoreCase: false,
																									want:       "\"NaN\"",
																								},
																								&litMatcher{
																									pos:        position{line: 238, col: 9, offset: 6039},
																									val:        "merge",
																									ignoreCase: false,
																									want:       "\"merge\"",
																								},
																								&litMatcher{
																									pos:        position{line: 242, col: 8, offset: 6163},
																									val:        "Some",
																									ignoreCase: false,
																									want:       "\"Some\"",
																								},
																								&litMatcher{
																									pos:        position{line: 243, col: 9, offset: 6180},
																									val:        "toMap",
																									ignoreCase: false,
																									want:       "\"toMap\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 10, offset: 6219},
																									val:        "forall",
																									ignoreCase: false,
																									want:       "\"forall\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 21, offset: 6230},
																									val:        "∀",
																									ignoreCase: false,
																									want:       "\"∀\"",
																								},
																								&litMatcher{
																									pos:        position{line: 246, col: 8, offset: 6245},
																									val:        "with",
																									ignoreCase: false,
																									want:       "\"with\"",
																								},
																							},
																						},
																						&oneOrMoreExpr{
																							pos: position{line: 122, col: 23, offset: 2824},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																			&actionExpr{
																				pos: position{line: 123, col: 13, offset: 2888},
																				run: (*parser).callonLetBinding122,
																				expr: &seqExpr{
																					pos: position{line: 123, col: 13, offset: 2888},
																					exprs: []interface{}{
																						&notExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							expr: &choiceExpr{
																								pos: position{line: 249, col: 5, offset: 6269},
																								alternatives: []interface{}{
																									&litMatcher{
																										pos:        position{line: 231, col: 6, offset: 5936},
																										val:        "if",
																										ignoreCase: false,
																										want:       "\"if\"",
																									},
																									&litMatcher{
																										pos:        position{line: 232, col: 8, offset: 5950},
																										val:        "then",
																										ignoreCase: false,
																										want:       "\"then\"",
																									},
																									&litMatcher{
																										pos:        position{line: 233, col: 8, offset: 5966},
																										val:        "else",
																										ignoreCase: false,
																										want:       "\"else\"",
																									},
																									&litMatcher{
																										pos:        position{line: 234, col: 7, offset: 5981},
																										val:        "let",
																										ignoreCase: false,
																										want:       "\"let\"",
																									},
																									&litMatcher{
																										pos:        position{line: 235, col: 6, offset: 5994},
																										val:        "in",
																										ignoreCase: false,
																										want:       "\"in\"",
																									},
																									&litMatcher{
																										pos:        position{line: 237, col: 9, offset: 6021},
																										val:        "using",
																										ignoreCase: false,
																										want:       "\"using\"",
																									},
																									&actionExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										run: (*parser).callonLetBinding132,
																										expr: &seqExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											exprs: []interface{}{
																												&litMatcher{
																													pos:        position{line: 239, col: 11, offset: 6059},
																													val:        "missing",
																													ignoreCase: false,
																													want:       "\"missing\"",
																												},
																												&notExpr{
																													pos: position{line: 239, col: 21, offset: 6069},
																													expr: &charClassMatcher{
																														pos:        position{line: 121, col: 23, offset: 2785},
																														val:        "[_/-A-Za-z0-9]",
																														chars:      []rune{'_', '/', '-'},
																														ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																														ignoreCase: false,
																														inverted:   false,
																													},
																												},
																											},
																										},
																									},
																									&litMatcher{
																										pos:        position{line: 244, col: 10, offset: 6199},
																										val:        "assert",
																										ignoreCase: false,
																										want:       "\"assert\"",
																									},
																									&litMatcher{
																										pos:        position{line: 236, col: 6, offset: 6006},
																										val:        "as",
																										ignoreCase: false,
																										want:       "\"as\"",
																									},
																									&litMatcher{
																										pos:        position{line: 240, col: 12, offset: 6129},
																										val:        "Infinity",
																										ignoreCase: false,
																										want:       "\"Infinity\"",
																									},
																									&litMatcher{
																										pos:        position{line: 241, col: 7, offset: 6148},
																										val:        "NaN",
																										ignoreCase: false,
																										want:       "\"NaN\"",
																									},
																									&litMatcher{
																										pos:        position{line: 238, col: 9, offset: 6039},
																										val:        "merge",
																										ignoreCase: false,
																										want:       "\"merge\"",
																									},
																									&litMatcher{
																										pos:        position{line: 242, col: 8, offset: 6163},
																										val:        "Some",
																										ignoreCase: false,
																										want:       "\"Some\"",
																									},
																									&litMatcher{
																										pos:        position{line: 243, col: 9, offset: 6180},
																										val:        "toMap",
																										ignoreCase: false,
																										want:       "\"toMap\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 10, offset: 6219},
																										val:        "forall",
																										ignoreCase: false,
																										want:       "\"forall\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 21, offset: 6230},
																										val:        "∀",
																										ignoreCase: false,
																										want:       "\"∀\"",
																									},
																									&litMatcher{
																										pos:        position{line: 246, col: 8, offset: 6245},
																										val:        "with",
																										ignoreCase: false,
																										want:       "\"with\"",
																									},
																								},
																							},
																						},
																						&charClassMatcher{
																							pos:        position{line: 120, col: 24, offset: 2751},
																							val:        "[_A-Za-z]",
																							chars:      []rune{'_'},
																							ranges:     []rune{'A', 'Z', 'a', 'z'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&zeroOrMoreExpr{
																							pos: position{line: 123, col: 43, offset: 2918},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 135, col: 19, offset: 3320},
										run: (*parser).callonLetBinding150,
										expr: &seqExpr{
											pos: position{line: 135, col: 19, offset: 3320},
											exprs: []interface{}{
												&notExpr{
													pos: position{line: 135, col: 19, offset: 3320},
													expr: &choiceExpr{
														pos: position{line: 259, col: 5, offset: 6416},
														alternatives: []interface{}{
															&actionExpr{
																pos: position{line: 259, col: 5, offset: 6416},
																run: (*parser).callonLetBinding154,
																expr: &litMatcher{
																	pos:        position{line: 259, col: 5, offset: 6416},
																	val:        "Natural/fold",
																	ignoreCase: false,
																	want:       "\"Natural/fold\"",
																},
															},
															&actionExpr{
																pos: position{line: 260, col: 5, offset: 6463},
																run: (*parser).callonLetBinding156,
																expr: &litMatcher{
																	pos:        position{line: 260, col: 5, offset: 6463},
																	val:        "Natural/build",
																	ignoreCase: false,
																	want:       "\"Natural/build\"",
																},
															},
															&actionExpr{
																pos: position{line: 261, col: 5, offset: 6512},
																run: (*parser).callonLetBinding158,
																expr: &litMatcher{
																	pos:        position{line: 261, col: 5, offset: 6512},
																	val:        "Natural/isZero",
																	ignoreCase: false,
																	want:       "\"Natural/isZero\"",
																},
															},
															&actionExpr{
																pos: position{line: 262, col: 5, offset: 6563},
																run: (*parser).callonLetBinding160,
																expr: &litMatcher{
																	pos:        position{line: 262, col: 5, offset: 6563},
																	val:        "Natural/even",
																	ignoreCase: false,
																	want:       "\"Natural/even\"",
																},
															},
															&actionExpr{
																pos: position{line: 263, col: 5, offset: 6610},
																run: (*parser).callonLetBinding162,
																expr: &litMatcher{
																	pos:        position{line: 263, col: 5, offset: 6610},
																	val:        "Natural/odd",
																	ignoreCase: false,
																	want:       "\"Natural/odd\"",
																},
															},
															&actionExpr{
																pos: position{line: 264, col: 5, offset: 6655},
																run: (*parser).callonLetBinding164,
																expr: &litMatcher{
																	pos:        position{line: 264, col: 5, offset: 6655},
																	val:        "Natural/toInteger",
																	ignoreCase: false,
																	want:       "\"Natural/toInteger\"",
																},
															},
															&actionExpr{
																pos: position{line: 265, col: 5, offset: 6712},
																run: (*parser).callonLetBinding166,
																expr: &litMatcher{
																	pos:        position{line: 265, col: 5, offset: 6712},
																	val:        "Natural/show",
																	ignoreCase: false,
																	want:       "\"Natural/show\"",
																},
															},
															&actionExpr{
																pos: position{line: 266, col: 5, offset: 6759},
																run: (*parser).callonLetBinding168,
																expr: &litMatcher{
																	pos:        position{line: 266, col: 5, offset: 6759},
																	val:        "Integer/toDouble",
																	ignoreCase: false,
																	want:       "\"Integer/toDouble\"",
																},
															},
															&actionExpr{
																pos: position{line: 267, col: 5, offset: 6814},
																run: (*parser).callonLetBinding170,
																expr: &litMatcher{
																	pos:        position{line: 267, col: 5, offset: 6814},
																	val:        "Integer/show",
																	ignoreCase: false,
																	want:       "\"Integer/show\"",
																},
															},
															&actionExpr{
																pos: position{line: 268, col: 5, offset: 6861},
																run: (*parser).callonLetBinding172,
																expr: &litMatcher{
																	pos:        position{line: 268, col: 5, offset: 6861},
																	val:        "Integer/negate",
																	ignoreCase: false,
																	want:       "\"Integer/negate\"",
																},
															},
															&actionExpr{
																pos: position{line: 269, col: 5, offset: 6912},
																run: (*parser).callonLetBinding174,
																expr: &litMatcher{
																	pos:        position{line: 269, col: 5, offset: 6912},
																	val:        "Integer/clamp",
																	ignoreCase: false,
																	want:       "\"Integer/clamp\"",
																},
															},
															&actionExpr{
																pos: position{line: 270, col: 5, offset: 6961},
																run: (*parser).callonLetBinding176,
																expr: &litMatcher{
																	pos:        position{line: 270, col: 5, offset: 6961},
																	val:        "Natural/subtract",
																	ignoreCase: false,
																	want:       "\"Natural/subtract\"",
																},
															},
															&actionExpr{
																pos: position{line: 271, col: 5, offset: 7016},
																run: (*parser).callonLetBinding178,
																expr: &litMatcher{
																	pos:        position{line: 271, col: 5, offset: 7016},
																	val:        "Double/show",
																	ignoreCase: false,
																	want:       "\"Double/show\"",
																},
															},
															&actionExpr{
																pos: position{line: 272, col: 5, offset: 7061},
																run: (*parser).callonLetBinding180,
																expr: &litMatcher{
																	pos:        position{line: 272, col: 5, offset: 7061},
																	val:        "List/build",
																	ignoreCase: false,
																	want:       "\"List/build\"",
																},
															},
															&actionExpr{
																pos: position{line: 273, col: 5, offset: 7104},
																run: (*parser).callonLetBinding182,
																expr: &litMatcher{
																	pos:        position{line: 273, col: 5, offset: 7104},
																	val:        "List/fold",
																	ignoreCase: false,
																	want:       "\"List/fold\"",
																},
															},
															&actionExpr{
																pos: position{line: 274, col: 5, offset: 7145},
																run: (*parser).callonLetBinding184,
																expr: &litMatcher{
																	pos:        position{line: 274, col: 5, offset: 7145},
																	val:        "List/length",
																	ignoreCase: false,
																	want:       "\"List/length\"",
																},
															},
															&actionExpr{
																pos: position{line: 275, col: 5, offset: 7190},
																run: (*parser).callonLetBinding186,
																expr: &litMatcher{
																	pos:        position{line: 275, col: 5, offset: 7190},
																	val:        "List/head",
																	ignoreCase: false,
																	want:       "\"List/head\"",
																},
															},
															&actionExpr{
																pos: position{line: 276, col: 5, offset: 7231},
																run: (*parser).callonLetBinding188,
																expr: &litMatcher{
																	pos:        position{line: 276, col: 5, offset: 7231},
																	val:        "List/last",
																	ignoreCase: false,
																	want:       "\"List/last\"",
																},
															},
															&actionExpr{
																pos: position{line: 277, col: 5, offset: 7272},
																run: (*parser).callonLetBinding190,
																expr: &litMatcher{
																	pos:        position{line: 277, col: 5, offset: 7272},
																	val:        "List/indexed",
																	ignoreCase: false,
																	want:       "\"List/indexed\"",
																},
															},
															&actionExpr{
																pos: position{line: 278, col: 5, offset: 7319},
																run: (*parser).callonLetBinding192,
																expr: &litMatcher{
																	pos:        position{line: 278, col: 5, offset: 7319},
																	val:        "List/reverse",
																	ignoreCase: false,
																	want:       "\"List/reverse\"",
																},
															},
															&actionExpr{
																pos: position{line: 279, col: 5, offset: 7366},
																run: (*parser).callonLetBinding194,
																expr: &litMatcher{
																	pos:        position{line: 279, col: 5, offset: 7366},
																	val:        "Text/show",
																	ignoreCase: false,
																	want:       "\"Text/show\"",
																},
															},
															&actionExpr{
																pos: position{line: 280, col: 5, offset: 7407},
																run: (*parser).callonLetBinding196,
																expr: &litMatcher{
																	pos:        position{line: 280, col: 5, offset: 7407},
																	val:        "Text/replace",
																	ignoreCase: false,
																	want:       "\"Text/replace\"",
																},
															},
															&actionExpr{
																pos: position{line: 281, col: 5, offset: 7454},
																run: (*parser).callonLetBinding198,
																expr: &litMatcher{
																	pos:        position{line: 281, col: 5, offset: 7454},
																	val:        "Bool",
																	ignoreCase: false,
																	want:       "\"Bool\"",
																},
															},
															&actionExpr{
																pos: position{line: 282, col: 5, offset: 7486},
																run: (*parser).callonLetBinding200,
																expr: &litMatcher{
																	pos:        position{line: 282, col: 5, offset: 7486},
																	val:        "True",
																	ignoreCase: false,
																	want:       "\"True\"",
																},
															},
															&actionExpr{
																pos: position{line: 283, col: 5, offset: 7518},
																run: (*parser).callonLetBinding202,
																expr: &litMatcher{
																	pos:        position{line: 283, col: 5, offset: 7518},
																	val:        "False",
																	ignoreCase: false,
																	want:       "\"False\"",
																},
															},
															&actionExpr{
																pos: position{line: 284, col: 5, offset: 7552},
																run: (*parser).callonLetBinding204,
																expr: &litMatcher{
																	pos:        position{line: 284, col: 5, offset: 7552},
																	val:        "Optional",
																	ignoreCase: false,
																	want:       "\"Optional\"",
																},
															},
															&actionExpr{
																pos: position{line: 285, col: 5, offset: 7592},
																run: (*parser).callonLetBinding206,
																expr: &litMatcher{
																	pos:        position{line: 285, col: 5, offset: 7592},
																	val:        "None",
																	ignoreCase: false,
																	want:       "\"None\"",
																},
															},
															&actionExpr{
																pos: position{line: 286, col: 5, offset: 7624},
																run: (*parser).callonLetBinding208,
																expr: &litMatcher{
																	pos:        position{line: 286, col: 5, offset: 7624},
																	val:        "Natural",
																	ignoreCase: false,
																	want:       "\"Natural\"",
																},
															},
															&actionExpr{
																pos: position{line: 287, col: 5, offset: 7662},
																run: (*parser).callonLetBinding210,
																expr: &litMatcher{
																	pos:        position{line: 287, col: 5, offset: 7662},
																	val:        "Integer",
																	ignoreCase: false,
																	want:       "\"Integer\"",
																},
															},
															&actionExpr{
																pos: position{line: 288, col: 5, offset: 7700},
																run: (*parser).callonLetBinding212,
																expr: &litMatcher{
																	pos:        position{line: 288, col: 5, offset: 7700},
																	val:        "Double",
																	ignoreCase: false,
																	want:       "\"Double\"",
																},
															},
															&actionExpr{
																pos: position{line: 289, col: 5, offset: 7736},
																run: (*parser).callonLetBinding214,
																expr: &litMatcher{
																	pos:        position{line: 289, col: 5, offset: 7736},
																	val:        "Text",
																	ignoreCase: false,
																	want:       "\"Text\"",
																},
															},
															&actionExpr{
																pos: position{line: 290, col: 5, offset: 7768},
																run: (*parser).callonLetBinding216,
																expr: &litMatcher{
																	pos:        position{line: 290, col: 5, offset: 7768},
																	val:        "List",
																	ignoreCase: false,
																	want:       "\"List\"",
																},
															},
															&actionExpr{
																pos: position{line: 291, col: 5, offset: 7800},
																run: (*parser).callonLetBinding218,
																expr: &litMatcher{
																	pos:        position{line: 291, col: 5, offset: 7800},
																	val:        "Type",
																	ignoreCase: false,
																	want:       "\"Type\"",
																},
															},
															&actionExpr{
																pos: position{line: 292, col: 5, offset: 7832},
																run: (*parser).callonLetBinding220,
																expr: &litMatcher{
																	pos:        position{line: 292, col: 5, offset: 7832},
																	val:        "Kind",
																	ignoreCase: false,
																	want:       "\"Kind\"",
																},
															},
															&actionExpr{
																pos: position{line: 293, col: 5, offset: 7864},
																run: (*parser).callonLetBinding222,
																expr: &litMatcher{
																	pos:        position{line: 293, col: 5, offset: 7864},
																	val:        "Sort",
																	ignoreCase: false,
																	want:       "\"Sort\"",
																},
															},
														},
													},
												},
												&labeledExpr{
													pos:   position{line: 135, col: 28, offset: 3329},
													label: "label",
													expr: &choiceExpr{
														pos: position{line: 131, col: 9, offset: 3119},
														alternatives: []interface{}{
															&actionExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																run: (*parser).callonLetBinding226,
																expr: &seqExpr{
																	pos: position{line: 131, col: 9, offset: 3119},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 131, col: 9, offset: 3119},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																		&labeledExpr{
																			pos:   position{line: 131, col: 13, offset: 3123},
																			label: "label",
																			expr: &actionExpr{
																				pos: position{line: 129, col: 15, offset: 3060},
																				run: (*parser).callonLetBinding230,
																				expr: &zeroOrMoreExpr{
																					pos: position{line: 129, col: 15, offset: 3060},
																					expr: &charClassMatcher{
																						pos:        position{line: 128, col: 19, offset: 3023},
																						val:        "[ -_a-~]",
																						ranges:     []rune{' ', '_', 'a', '~'},
																						ignoreCase: false,
																						inverted:   false,
																					},
																				},
																			},
																		},
																		&litMatcher{
																			pos:        position{line: 131, col: 31, offset: 3141},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																	},
																},
															},
															&actionExpr{
																pos: position{line: 132, col: 9, offset: 3175},
																run: (*parser).callonLetBinding234,
																expr: &labeledExpr{
																	pos:   position{line: 132, col: 9, offset: 3175},
																	label: "label",
																	expr: &choiceExpr{
																		pos: position{line: 122, col: 15, offset: 2816},
																		alternatives: []interface{}{
																			&actionExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				run: (*parser).callonLetBinding237,
																				expr: &seqExpr{
																					pos: position{line: 122, col: 15, offset: 2816},
																					exprs: []interface{}{
																						&choiceExpr{
																							pos: position{line: 249, col: 5, offset: 6269},
																							alternatives: []interface{}{
																								&litMatcher{
																									pos:        position{line: 231, col: 6, offset: 5936},
																									val:        "if",
																									ignoreCase: false,
																									want:       "\"if\"",
																								},
																								&litMatcher{
																									pos:        position{line: 232, col: 8, offset: 5950},
																									val:        "then",
																									ignoreCase: false,
																									want:       "\"then\"",
																								},
																								&litMatcher{
																									pos:        position{line: 233, col: 8, offset: 5966},
																									val:        "else",
																									ignoreCase: false,
																									want:       "\"else\"",
																								},
																								&litMatcher{
																									pos:        position{line: 234, col: 7, offset: 5981},
																									val:        "let",
																									ignoreCase: false,
																									want:       "\"let\"",
																								},
																								&litMatcher{
																									pos:        position{line: 235, col: 6, offset: 5994},
																									val:        "in",
																									ignoreCase: false,
																									want:       "\"in\"",
																								},
																								&litMatcher{
																									pos:        position{line: 237, col: 9, offset: 6021},
																									val:        "using",
																									ignoreCase: false,
																									want:       "\"using\"",
																								},
																								&actionExpr{
																									pos: position{line: 239, col: 11, offset: 6059},
																									run: (*parser).callonLetBinding246,
																									expr: &seqExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										exprs: []interface{}{
																											&litMatcher{
																												pos:        position{line: 239, col: 11, offset: 6059},
																												val:        "missing",
																												ignoreCase: false,
																												want:       "\"missing\"",
																											},
																											&notExpr{
																												pos: position{line: 239, col: 21, offset: 6069},
																												expr: &charClassMatcher{
																													pos:        position{line: 121, col: 23, offset: 2785},
																													val:        "[_/-A-Za-z0-9]",
																													chars:      []rune{'_', '/', '-'},
																													ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																													ignoreCase: false,
																													inverted:   false,
																												},
																											},
																										},
																									},
																								},
																								&litMatcher{
																									pos:        position{line: 244, col: 10, offset: 6199},
																									val:        "assert",
																									ignoreCase: false,
																									want:       "\"assert\"",
																								},
																								&litMatcher{
																									pos:        position{line: 236, col: 6, offset: 6006},
																									val:        "as",
																									ignoreCase: false,
																									want:       "\"as\"",
																								},
																								&litMatcher{
																									pos:        position{line: 240, col: 12, offset: 6129},
																									val:        "Infinity",
																									ignoreCase: false,
																									want:       "\"Infinity\"",
																								},
																								&litMatcher{
																									pos:        position{line: 241, col: 7, offset: 6148},
																									val:        "NaN",
																									ignoreCase: false,
																									want:       "\"NaN\"",
																								},
																								&litMatcher{
																									pos:        position{line: 238, col: 9, offset: 6039},
																									val:        "merge",
																									ignoreCase: false,
																									want:       "\"merge\"",
																								},
																								&litMatcher{
																									pos:        position{line: 242, col: 8, offset: 6163},
																									val:        "Some",
																									ignoreCase: false,
																									want:       "\"Some\"",
																								},
																								&litMatcher{
																									pos:        position{line: 243, col: 9, offset: 6180},
																									val:        "toMap",
																									ignoreCase: false,
																									want:       "\"toMap\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 10, offset: 6219},
																									val:        "forall",
																									ignoreCase: false,
																									want:       "\"forall\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 21, offset: 6230},
																									val:        "∀",
																									ignoreCase: false,
																									want:       "\"∀\"",
																								},
																								&litMatcher{
																									pos:        position{line: 246, col: 8, offset: 6245},
																									val:        "with",
																									ignoreCase: false,
																									want:       "\"with\"",
																								},
																							},
																						},
																						&oneOrMoreExpr{
																							pos: position{line: 122, col: 23, offset: 2824},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																			&actionExpr{
																				pos: position{line: 123, col: 13, offset: 2888},
																				run: (*parser).callonLetBinding263,
																				expr: &seqExpr{
																					pos: position{line: 123, col: 13, offset: 2888},
																					exprs: []interface{}{
																						&notExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							expr: &choiceExpr{
																								pos: position{line: 249, col: 5, offset: 6269},
																								alternatives: []interface{}{
																									&litMatcher{
																										pos:        position{line: 231, col: 6, offset: 5936},
																										val:        "if",
																										ignoreCase: false,
																										want:       "\"if\"",
																									},
																									&litMatcher{
																										pos:        position{line: 232, col: 8, offset: 5950},
																										val:        "then",
																										ignoreCase: false,
																										want:       "\"then\"",
																									},
																									&litMatcher{
																										pos:        position{line: 233, col: 8, offset: 5966},
																										val:        "else",
																										ignoreCase: false,
																										want:       "\"else\"",
																									},
																									&litMatcher{
																										pos:        position{line: 234, col: 7, offset: 5981},
																										val:        "let",
																										ignoreCase: false,
																										want:       "\"let\"",
																									},
																									&litMatcher{
																										pos:        position{line: 235, col: 6, offset: 5994},
																										val:        "in",
																										ignoreCase: false,
																										want:       "\"in\"",
																									},
																									&litMatcher{
																										pos:        position{line: 237, col: 9, offset: 6021},
																										val:        "using",
																										ignoreCase: false,
																										want:       "\"using\"",
																									},
																									&actionExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										run: (*parser).callonLetBinding273,
																										expr: &seqExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											exprs: []interface{}{
																												&litMatcher{
																													pos:        position{line: 239, col: 11, offset: 6059},
																													val:        "missing",
																													ignoreCase: false,
																													want:       "\"missing\"",
																												},
																												&notExpr{
																													pos: position{line: 239, col: 21, offset: 6069},
																													expr: &charClassMatcher{
																														pos:        position{line: 121, col: 23, offset: 2785},
																														val:        "[_/-A-Za-z0-9]",
																														chars:      []rune{'_', '/', '-'},
																														ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																														ignoreCase: false,
																														inverted:   false,
																													},
																												},
																											},
																										},
																									},
																									&litMatcher{
																										pos:        position{line: 244, col: 10, offset: 6199},
																										val:        "assert",
																										ignoreCase: false,
																										want:       "\"assert\"",
																									},
																									&litMatcher{
																										pos:        position{line: 236, col: 6, offset: 6006},
																										val:        "as",
																										ignoreCase: false,
																										want:       "\"as\"",
																									},
																									&litMatcher{
																										pos:        position{line: 240, col: 12, offset: 6129},
																										val:        "Infinity",
																										ignoreCase: false,
																										want:       "\"Infinity\"",
																									},
																									&litMatcher{
																										pos:        position{line: 241, col: 7, offset: 6148},
																										val:        "NaN",
																										ignoreCase: false,
																										want:       "\"NaN\"",
																									},
																									&litMatcher{
																										pos:        position{line: 238, col: 9, offset: 6039},
																										val:        "merge",
																										ignoreCase: false,
																										want:       "\"merge\"",
																									},
																									&litMatcher{
																										pos:        position{line: 242, col: 8, offset: 6163},
																										val:        "Some",
																										ignoreCase: false,
																										want:       "\"Some\"",
																									},
																									&litMatcher{
																										pos:        position{line: 243, col: 9, offset: 6180},
																										val:        "toMap",
																										ignoreCase: false,
																										want:       "\"toMap\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 10, offset: 6219},
																										val:        "forall",
																										ignoreCase: false,
																										want:       "\"forall\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 21, offset: 6230},
																										val:        "∀",
																										ignoreCase: false,
																										want:       "\"∀\"",
																									},
																									&litMatcher{
																										pos:        position{line: 246, col: 8, offset: 6245},
																										val:        "with",
																										ignoreCase: false,
																										want:       "\"with\"",
																									},
																								},
																							},
																						},
																						&charClassMatcher{
																							pos:        position{line: 120, col: 24, offset: 2751},
																							val:        "[_A-Za-z]",
																							chars:      []rune{'_'},
																							ranges:     []rune{'A', 'Z', 'a', 'z'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&zeroOrMoreExpr{
																							pos: position{line: 123, col: 43, offset: 2918},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 495, col: 44, offset: 14103},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 495, col: 46, offset: 14105},
							label: "a",
							expr: &zeroOrOneExpr{
								pos: position{line: 495, col: 48, offset: 14107},
								expr: &seqExpr{
									pos: position{line: 495, col: 49, offset: 14108},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 495, col: 49, offset: 14108},
											name: "Annotation",
										},
										&ruleRefExpr{
											pos:  position{line: 495, col: 60, offset: 14119},
											name: "_",
										},
									},
								},
							},
						},
						&litMatcher{
							pos:        position{line: 496, col: 13, offset: 14135},
							val:        "=",
							ignoreCase: false,
							want:       "\"=\"",
						},
						&ruleRefExpr{
							pos:  position{line: 496, col: 17, offset: 14139},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 496, col: 19, offset: 14141},
							label: "v",
							expr: &ruleRefExpr{
								pos:  position{line: 496, col: 21, offset: 14143},
								name: "Expression",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 496, col: 32, offset: 14154},
							name: "_",
						},
					},
				},
			},
		},
		{
			name: "Expression",
			pos:  position{line: 511, col: 1, offset: 14463},
			expr: &choiceExpr{
				pos: position{line: 512, col: 7, offset: 14484},
				alternatives: []interface{}{
					&actionExpr{
						pos: position{line: 512, col: 7, offset: 14484},
						run: (*parser).callonExpression2,
						expr: &seqExpr{
							pos: position{line: 512, col: 7, offset: 14484},
							exprs: []interface{}{
								&charClassMatcher{
									pos:        position{line: 302, col: 10, offset: 8058},
									val:        "[\\\\λ]",
									chars:      []rune{'\\', 'λ'},
									ignoreCase: false,
									inverted:   false,
								},
								&ruleRefExpr{
									pos:  position{line: 512, col: 14, offset: 14491},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 512, col: 16, offset: 14493},
									val:        "(",
									ignoreCase: false,
									want:       "\"(\"",
								},
								&ruleRefExpr{
									pos:  position{line: 512, col: 20, offset: 14497},
									name: "_",
								},
								&labeledExpr{
									pos:   position{line: 512, col: 22, offset: 14499},
									label: "label",
									expr: &choiceExpr{
										pos: position{line: 134, col: 20, offset: 3237},
										alternatives: []interface{}{
											&actionExpr{
												pos: position{line: 134, col: 20, offset: 3237},
												run: (*parser).callonExpression10,
												expr: &seqExpr{
													pos: position{line: 134, col: 20, offset: 3237},
													exprs: []interface{}{
														&andExpr{
															pos: position{line: 134, col: 20, offset: 3237},
															expr: &seqExpr{
																pos: position{line: 134, col: 22, offset: 3239},
																exprs: []interface{}{
																	&choiceExpr{
																		pos: position{line: 259, col: 5, offset: 6416},
																		alternatives: []interface{}{
																			&actionExpr{
																				pos: position{line: 259, col: 5, offset: 6416},
																				run: (*parser).callonExpression15,
																				expr: &litMatcher{
																					pos:        position{line: 259, col: 5, offset: 6416},
																					val:        "Natural/fold",
																					ignoreCase: false,
																					want:       "\"Natural/fold\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 260, col: 5, offset: 6463},
																				run: (*parser).callonExpression17,
																				expr: &litMatcher{
																					pos:        position{line: 260, col: 5, offset: 6463},
																					val:        "Natural/build",
																					ignoreCase: false,
																					want:       "\"Natural/build\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 261, col: 5, offset: 6512},
																				run: (*parser).callonExpression19,
																				expr: &litMatcher{
																					pos:        position{line: 261, col: 5, offset: 6512},
																					val:        "Natural/isZero",
																					ignoreCase: false,
																					want:       "\"Natural/isZero\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 262, col: 5, offset: 6563},
																				run: (*parser).callonExpression21,
																				expr: &litMatcher{
																					pos:        position{line: 262, col: 5, offset: 6563},
																					val:        "Natural/even",
																					ignoreCase: false,
																					want:       "\"Natural/even\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 263, col: 5, offset: 6610},
																				run: (*parser).callonExpression23,
																				expr: &litMatcher{
																					pos:        position{line: 263, col: 5, offset: 6610},
																					val:        "Natural/odd",
																					ignoreCase: false,
																					want:       "\"Natural/odd\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 264, col: 5, offset: 6655},
																				run: (*parser).callonExpression25,
																				expr: &litMatcher{
																					pos:        position{line: 264, col: 5, offset: 6655},
																					val:        "Natural/toInteger",
																					ignoreCase: false,
																					want:       "\"Natural/toInteger\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 265, col: 5, offset: 6712},
																				run: (*parser).callonExpression27,
																				expr: &litMatcher{
																					pos:        position{line: 265, col: 5, offset: 6712},
																					val:        "Natural/show",
																					ignoreCase: false,
																					want:       "\"Natural/show\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 266, col: 5, offset: 6759},
																				run: (*parser).callonExpression29,
																				expr: &litMatcher{
																					pos:        position{line: 266, col: 5, offset: 6759},
																					val:        "Integer/toDouble",
																					ignoreCase: false,
																					want:       "\"Integer/toDouble\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 267, col: 5, offset: 6814},
																				run: (*parser).callonExpression31,
																				expr: &litMatcher{
																					pos:        position{line: 267, col: 5, offset: 6814},
																					val:        "Integer/show",
																					ignoreCase: false,
																					want:       "\"Integer/show\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 268, col: 5, offset: 6861},
																				run: (*parser).callonExpression33,
																				expr: &litMatcher{
																					pos:        position{line: 268, col: 5, offset: 6861},
																					val:        "Integer/negate",
																					ignoreCase: false,
																					want:       "\"Integer/negate\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 269, col: 5, offset: 6912},
																				run: (*parser).callonExpression35,
																				expr: &litMatcher{
																					pos:        position{line: 269, col: 5, offset: 6912},
																					val:        "Integer/clamp",
																					ignoreCase: false,
																					want:       "\"Integer/clamp\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 270, col: 5, offset: 6961},
																				run: (*parser).callonExpression37,
																				expr: &litMatcher{
																					pos:        position{line: 270, col: 5, offset: 6961},
																					val:        "Natural/subtract",
																					ignoreCase: false,
																					want:       "\"Natural/subtract\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 271, col: 5, offset: 7016},
																				run: (*parser).callonExpression39,
																				expr: &litMatcher{
																					pos:        position{line: 271, col: 5, offset: 7016},
																					val:        "Double/show",
																					ignoreCase: false,
																					want:       "\"Double/show\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 272, col: 5, offset: 7061},
																				run: (*parser).callonExpression41,
																				expr: &litMatcher{
																					pos:        position{line: 272, col: 5, offset: 7061},
																					val:        "List/build",
																					ignoreCase: false,
																					want:       "\"List/build\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 273, col: 5, offset: 7104},
																				run: (*parser).callonExpression43,
																				expr: &litMatcher{
																					pos:        position{line: 273, col: 5, offset: 7104},
																					val:        "List/fold",
																					ignoreCase: false,
																					want:       "\"List/fold\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 274, col: 5, offset: 7145},
																				run: (*parser).callonExpression45,
																				expr: &litMatcher{
																					pos:        position{line: 274, col: 5, offset: 7145},
																					val:        "List/length",
																					ignoreCase: false,
																					want:       "\"List/length\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 275, col: 5, offset: 7190},
																				run: (*parser).callonExpression47,
																				expr: &litMatcher{
																					pos:        position{line: 275, col: 5, offset: 7190},
																					val:        "List/head",
																					ignoreCase: false,
																					want:       "\"List/head\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 276, col: 5, offset: 7231},
																				run: (*parser).callonExpression49,
																				expr: &litMatcher{
																					pos:        position{line: 276, col: 5, offset: 7231},
																					val:        "List/last",
																					ignoreCase: false,
																					want:       "\"List/last\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 277, col: 5, offset: 7272},
																				run: (*parser).callonExpression51,
																				expr: &litMatcher{
																					pos:        position{line: 277, col: 5, offset: 7272},
																					val:        "List/indexed",
																					ignoreCase: false,
																					want:       "\"List/indexed\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 278, col: 5, offset: 7319},
																				run: (*parser).callonExpression53,
																				expr: &litMatcher{
																					pos:        position{line: 278, col: 5, offset: 7319},
																					val:        "List/reverse",
																					ignoreCase: false,
																					want:       "\"List/reverse\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 279, col: 5, offset: 7366},
																				run: (*parser).callonExpression55,
																				expr: &litMatcher{
																					pos:        position{line: 279, col: 5, offset: 7366},
																					val:        "Text/show",
																					ignoreCase: false,
																					want:       "\"Text/show\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 280, col: 5, offset: 7407},
																				run: (*parser).callonExpression57,
																				expr: &litMatcher{
																					pos:        position{line: 280, col: 5, offset: 7407},
																					val:        "Text/replace",
																					ignoreCase: false,
																					want:       "\"Text/replace\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 281, col: 5, offset: 7454},
																				run: (*parser).callonExpression59,
																				expr: &litMatcher{
																					pos:        position{line: 281, col: 5, offset: 7454},
																					val:        "Bool",
																					ignoreCase: false,
																					want:       "\"Bool\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 282, col: 5, offset: 7486},
																				run: (*parser).callonExpression61,
																				expr: &litMatcher{
																					pos:        position{line: 282, col: 5, offset: 7486},
																					val:        "True",
																					ignoreCase: false,
																					want:       "\"True\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 283, col: 5, offset: 7518},
																				run: (*parser).callonExpression63,
																				expr: &litMatcher{
																					pos:        position{line: 283, col: 5, offset: 7518},
																					val:        "False",
																					ignoreCase: false,
																					want:       "\"False\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 284, col: 5, offset: 7552},
																				run: (*parser).callonExpression65,
																				expr: &litMatcher{
																					pos:        position{line: 284, col: 5, offset: 7552},
																					val:        "Optional",
																					ignoreCase: false,
																					want:       "\"Optional\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 285, col: 5, offset: 7592},
																				run: (*parser).callonExpression67,
																				expr: &litMatcher{
																					pos:        position{line: 285, col: 5, offset: 7592},
																					val:        "None",
																					ignoreCase: false,
																					want:       "\"None\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 286, col: 5, offset: 7624},
																				run: (*parser).callonExpression69,
																				expr: &litMatcher{
																					pos:        position{line: 286, col: 5, offset: 7624},
																					val:        "Natural",
																					ignoreCase: false,
																					want:       "\"Natural\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 287, col: 5, offset: 7662},
																				run: (*parser).callonExpression71,
																				expr: &litMatcher{
																					pos:        position{line: 287, col: 5, offset: 7662},
																					val:        "Integer",
																					ignoreCase: false,
																					want:       "\"Integer\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 288, col: 5, offset: 7700},
																				run: (*parser).callonExpression73,
																				expr: &litMatcher{
																					pos:        position{line: 288, col: 5, offset: 7700},
																					val:        "Double",
																					ignoreCase: false,
																					want:       "\"Double\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 289, col: 5, offset: 7736},
																				run: (*parser).callonExpression75,
																				expr: &litMatcher{
																					pos:        position{line: 289, col: 5, offset: 7736},
																					val:        "Text",
																					ignoreCase: false,
																					want:       "\"Text\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 290, col: 5, offset: 7768},
																				run: (*parser).callonExpression77,
																				expr: &litMatcher{
																					pos:        position{line: 290, col: 5, offset: 7768},
																					val:        "List",
																					ignoreCase: false,
																					want:       "\"List\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 291, col: 5, offset: 7800},
																				run: (*parser).callonExpression79,
																				expr: &litMatcher{
																					pos:        position{line: 291, col: 5, offset: 7800},
																					val:        "Type",
																					ignoreCase: false,
																					want:       "\"Type\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 292, col: 5, offset: 7832},
																				run: (*parser).callonExpression81,
																				expr: &litMatcher{
																					pos:        position{line: 292, col: 5, offset: 7832},
																					val:        "Kind",
																					ignoreCase: false,
																					want:       "\"Kind\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 293, col: 5, offset: 7864},
																				run: (*parser).callonExpression83,
																				expr: &litMatcher{
																					pos:        position{line: 293, col: 5, offset: 7864},
																					val:        "Sort",
																					ignoreCase: false,
																					want:       "\"Sort\"",
																				},
																			},
																		},
																	},
																	&charClassMatcher{
																		pos:        position{line: 121, col: 23, offset: 2785},
																		val:        "[_/-A-Za-z0-9]",
																		chars:      []rune{'_', '/', '-'},
																		ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
														&labeledExpr{
															pos:   position{line: 134, col: 51, offset: 3268},
															label: "label",
															expr: &choiceExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 131, col: 9, offset: 3119},
																		run: (*parser).callonExpression88,
																		expr: &seqExpr{
																			pos: position{line: 131, col: 9, offset: 3119},
																			exprs: []interface{}{
																				&litMatcher{
																					pos:        position{line: 131, col: 9, offset: 3119},
																					val:        "`",
																					ignoreCase: false,
																					want:       "\"`\"",
																				},
																				&labeledExpr{
																					pos:   position{line: 131, col: 13, offset: 3123},
																					label: "label",
																					expr: &actionExpr{
																						pos: position{line: 129, col: 15, offset: 3060},
																						run: (*parser).callonExpression92,
																						expr: &zeroOrMoreExpr{
																							pos: position{line: 129, col: 15, offset: 3060},
																							expr: &charClassMatcher{
																								pos:        position{line: 128, col: 19, offset: 3023},
																								val:        "[ -_a-~]",
																								ranges:     []rune{' ', '_', 'a', '~'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																				&litMatcher{
																					pos:        position{line: 131, col: 31, offset: 3141},
																					val:        "`",
																					ignoreCase: false,
																					want:       "\"`\"",
																				},
																			},
																		},
																	},
																	&actionExpr{
																		pos: position{line: 132, col: 9, offset: 3175},
																		run: (*parser).callonExpression96,
																		expr: &labeledExpr{
																			pos:   position{line: 132, col: 9, offset: 3175},
																			label: "label",
																			expr: &choiceExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				alternatives: []interface{}{
																					&actionExpr{
																						pos: position{line: 122, col: 15, offset: 2816},
																						run: (*parser).callonExpression99,
																						expr: &seqExpr{
																							pos: position{line: 122, col: 15, offset: 2816},
																							exprs: []interface{}{
																								&choiceExpr{
																									pos: position{line: 249, col: 5, offset: 6269},
																									alternatives: []interface{}{
																										&litMatcher{
																											pos:        position{line: 231, col: 6, offset: 5936},
																											val:        "if",
																											ignoreCase: false,
																											want:       "\"if\"",
																										},
																										&litMatcher{
																											pos:        position{line: 232, col: 8, offset: 5950},
																											val:        "then",
																											ignoreCase: false,
																											want:       "\"then\"",
																										},
																										&litMatcher{
																											pos:        position{line: 233, col: 8, offset: 5966},
																											val:        "else",
																											ignoreCase: false,
																											want:       "\"else\"",
																										},
																										&litMatcher{
																											pos:        position{line: 234, col: 7, offset: 5981},
																											val:        "let",
																											ignoreCase: false,
																											want:       "\"let\"",
																										},
																										&litMatcher{
																											pos:        position{line: 235, col: 6, offset: 5994},
																											val:        "in",
																											ignoreCase: false,
																											want:       "\"in\"",
																										},
																										&litMatcher{
																											pos:        position{line: 237, col: 9, offset: 6021},
																											val:        "using",
																											ignoreCase: false,
																											want:       "\"using\"",
																										},
																										&actionExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											run: (*parser).callonExpression108,
																											expr: &seqExpr{
																												pos: position{line: 239, col: 11, offset: 6059},
																												exprs: []interface{}{
																													&litMatcher{
																														pos:        position{line: 239, col: 11, offset: 6059},
																														val:        "missing",
																														ignoreCase: false,
																														want:       "\"missing\"",
																													},
																													&notExpr{
																														pos: position{line: 239, col: 21, offset: 6069},
																														expr: &charClassMatcher{
																															pos:        position{line: 121, col: 23, offset: 2785},
																															val:        "[_/-A-Za-z0-9]",
																															chars:      []rune{'_', '/', '-'},
																															ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																															ignoreCase: false,
																															inverted:   false,
																														},
																													},
																												},
																											},
																										},
																										&litMatcher{
																											pos:        position{line: 244, col: 10, offset: 6199},
																											val:        "assert",
																											ignoreCase: false,
																											want:       "\"assert\"",
																										},
																										&litMatcher{
																											pos:        position{line: 236, col: 6, offset: 6006},
																											val:        "as",
																											ignoreCase: false,
																											want:       "\"as\"",
																										},
																										&litMatcher{
																											pos:        position{line: 240, col: 12, offset: 6129},
																											val:        "Infinity",
																											ignoreCase: false,
																											want:       "\"Infinity\"",
																										},
																										&litMatcher{
																											pos:        position{line: 241, col: 7, offset: 6148},
																											val:        "NaN",
																											ignoreCase: false,
																											want:       "\"NaN\"",
																										},
																										&litMatcher{
																											pos:        position{line: 238, col: 9, offset: 6039},
																											val:        "merge",
																											ignoreCase: false,
																											want:       "\"merge\"",
																										},
																										&litMatcher{
																											pos:        position{line: 242, col: 8, offset: 6163},
																											val:        "Some",
																											ignoreCase: false,
																											want:       "\"Some\"",
																										},
																										&litMatcher{
																											pos:        position{line: 243, col: 9, offset: 6180},
																											val:        "toMap",
																											ignoreCase: false,
																											want:       "\"toMap\"",
																										},
																										&litMatcher{
																											pos:        position{line: 245, col: 10, offset: 6219},
																											val:        "forall",
																											ignoreCase: false,
																											want:       "\"forall\"",
																										},
																										&litMatcher{
																											pos:        position{line: 245, col: 21, offset: 6230},
																											val:        "∀",
																											ignoreCase: false,
																											want:       "\"∀\"",
																										},
																										&litMatcher{
																											pos:        position{line: 246, col: 8, offset: 6245},
																											val:        "with",
																											ignoreCase: false,
																											want:       "\"with\"",
																										},
																									},
																								},
																								&oneOrMoreExpr{
																									pos: position{line: 122, col: 23, offset: 2824},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																					&actionExpr{
																						pos: position{line: 123, col: 13, offset: 2888},
																						run: (*parser).callonExpression125,
																						expr: &seqExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							exprs: []interface{}{
																								&notExpr{
																									pos: position{line: 123, col: 13, offset: 2888},
																									expr: &choiceExpr{
																										pos: position{line: 249, col: 5, offset: 6269},
																										alternatives: []interface{}{
																											&litMatcher{
																												pos:        position{line: 231, col: 6, offset: 5936},
																												val:        "if",
																												ignoreCase: false,
																												want:       "\"if\"",
																											},
																											&litMatcher{
																												pos:        position{line: 232, col: 8, offset: 5950},
																												val:        "then",
																												ignoreCase: false,
																												want:       "\"then\"",
																											},
																											&litMatcher{
																												pos:        position{line: 233, col: 8, offset: 5966},
																												val:        "else",
																												ignoreCase: false,
																												want:       "\"else\"",
																											},
																											&litMatcher{
																												pos:        position{line: 234, col: 7, offset: 5981},
																												val:        "let",
																												ignoreCase: false,
																												want:       "\"let\"",
																											},
																											&litMatcher{
																												pos:        position{line: 235, col: 6, offset: 5994},
																												val:        "in",
																												ignoreCase: false,
																												want:       "\"in\"",
																											},
																											&litMatcher{
																												pos:        position{line: 237, col: 9, offset: 6021},
																												val:        "using",
																												ignoreCase: false,
																												want:       "\"using\"",
																											},
																											&actionExpr{
																												pos: position{line: 239, col: 11, offset: 6059},
																												run: (*parser).callonExpression135,
																												expr: &seqExpr{
																													pos: position{line: 239, col: 11, offset: 6059},
																													exprs: []interface{}{
																														&litMatcher{
																															pos:        position{line: 239, col: 11, offset: 6059},
																															val:        "missing",
																															ignoreCase: false,
																															want:       "\"missing\"",
																														},
																														&notExpr{
																															pos: position{line: 239, col: 21, offset: 6069},
																															expr: &charClassMatcher{
																																pos:        position{line: 121, col: 23, offset: 2785},
																																val:        "[_/-A-Za-z0-9]",
																																chars:      []rune{'_', '/', '-'},
																																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																																ignoreCase: false,
																																inverted:   false,
																															},
																														},
																													},
																												},
																											},
																											&litMatcher{
																												pos:        position{line: 244, col: 10, offset: 6199},
																												val:        "assert",
																												ignoreCase: false,
																												want:       "\"assert\"",
																											},
																											&litMatcher{
																												pos:        position{line: 236, col: 6, offset: 6006},
																												val:        "as",
																												ignoreCase: false,
																												want:       "\"as\"",
																											},
																											&litMatcher{
																												pos:        position{line: 240, col: 12, offset: 6129},
																												val:        "Infinity",
																												ignoreCase: false,
																												want:       "\"Infinity\"",
																											},
																											&litMatcher{
																												pos:        position{line: 241, col: 7, offset: 6148},
																												val:        "NaN",
																												ignoreCase: false,
																												want:       "\"NaN\"",
																											},
																											&litMatcher{
																												pos:        position{line: 238, col: 9, offset: 6039},
																												val:        "merge",
																												ignoreCase: false,
																												want:       "\"merge\"",
																											},
																											&litMatcher{
																												pos:        position{line: 242, col: 8, offset: 6163},
																												val:        "Some",
																												ignoreCase: false,
																												want:       "\"Some\"",
																											},
																											&litMatcher{
																												pos:        position{line: 243, col: 9, offset: 6180},
																												val:        "toMap",
																												ignoreCase: false,
																												want:       "\"toMap\"",
																											},
																											&litMatcher{
																												pos:        position{line: 245, col: 10, offset: 6219},
																												val:        "forall",
																												ignoreCase: false,
																												want:       "\"forall\"",
																											},
																											&litMatcher{
																												pos:        position{line: 245, col: 21, offset: 6230},
																												val:        "∀",
																												ignoreCase: false,
																												want:       "\"∀\"",
																											},
																											&litMatcher{
																												pos:        position{line: 246, col: 8, offset: 6245},
																												val:        "with",
																												ignoreCase: false,
																												want:       "\"with\"",
																											},
																										},
																									},
																								},
																								&charClassMatcher{
																									pos:        position{line: 120, col: 24, offset: 2751},
																									val:        "[_A-Za-z]",
																									chars:      []rune{'_'},
																									ranges:     []rune{'A', 'Z', 'a', 'z'},
																									ignoreCase: false,
																									inverted:   false,
																								},
																								&zeroOrMoreExpr{
																									pos: position{line: 123, col: 43, offset: 2918},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
											&actionExpr{
												pos: position{line: 135, col: 19, offset: 3320},
												run: (*parser).callonExpression153,
												expr: &seqExpr{
													pos: position{line: 135, col: 19, offset: 3320},
													exprs: []interface{}{
														&notExpr{
															pos: position{line: 135, col: 19, offset: 3320},
															expr: &choiceExpr{
																pos: position{line: 259, col: 5, offset: 6416},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 259, col: 5, offset: 6416},
																		run: (*parser).callonExpression157,
																		expr: &litMatcher{
																			pos:        position{line: 259, col: 5, offset: 6416},
																			val:        "Natural/fold",
																			ignoreCase: false,
																			want:       "\"Natural/fold\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 260, col: 5, offset: 6463},
																		run: (*parser).callonExpression159,
																		expr: &litMatcher{
																			pos:        position{line: 260, col: 5, offset: 6463},
																			val:        "Natural/build",
																			ignoreCase: false,
																			want:       "\"Natural/build\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 261, col: 5, offset: 6512},
																		run: (*parser).callonExpression161,
																		expr: &litMatcher{
																			pos:        position{line: 261, col: 5, offset: 6512},
																			val:        "Natural/isZero",
																			ignoreCase: false,
																			want:       "\"Natural/isZero\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 262, col: 5, offset: 6563},
																		run: (*parser).callonExpression163,
																		expr: &litMatcher{
																			pos:        position{line: 262, col: 5, offset: 6563},
																			val:        "Natural/even",
																			ignoreCase: false,
																			want:       "\"Natural/even\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 263, col: 5, offset: 6610},
																		run: (*parser).callonExpression165,
																		expr: &litMatcher{
																			pos:        position{line: 263, col: 5, offset: 6610},
																			val:        "Natural/odd",
																			ignoreCase: false,
																			want:       "\"Natural/odd\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 264, col: 5, offset: 6655},
																		run: (*parser).callonExpression167,
																		expr: &litMatcher{
																			pos:        position{line: 264, col: 5, offset: 6655},
																			val:        "Natural/toInteger",
																			ignoreCase: false,
																			want:       "\"Natural/toInteger\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 265, col: 5, offset: 6712},
																		run: (*parser).callonExpression169,
																		expr: &litMatcher{
																			pos:        position{line: 265, col: 5, offset: 6712},
																			val:        "Natural/show",
																			ignoreCase: false,
																			want:       "\"Natural/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 266, col: 5, offset: 6759},
																		run: (*parser).callonExpression171,
																		expr: &litMatcher{
																			pos:        position{line: 266, col: 5, offset: 6759},
																			val:        "Integer/toDouble",
																			ignoreCase: false,
																			want:       "\"Integer/toDouble\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 267, col: 5, offset: 6814},
																		run: (*parser).callonExpression173,
																		expr: &litMatcher{
																			pos:        position{line: 267, col: 5, offset: 6814},
																			val:        "Integer/show",
																			ignoreCase: false,
																			want:       "\"Integer/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 268, col: 5, offset: 6861},
																		run: (*parser).callonExpression175,
																		expr: &litMatcher{
																			pos:        position{line: 268, col: 5, offset: 6861},
																			val:        "Integer/negate",
																			ignoreCase: false,
																			want:       "\"Integer/negate\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 269, col: 5, offset: 6912},
																		run: (*parser).callonExpression177,
																		expr: &litMatcher{
																			pos:        position{line: 269, col: 5, offset: 6912},
																			val:        "Integer/clamp",
																			ignoreCase: false,
																			want:       "\"Integer/clamp\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 270, col: 5, offset: 6961},
																		run: (*parser).callonExpression179,
																		expr: &litMatcher{
																			pos:        position{line: 270, col: 5, offset: 6961},
																			val:        "Natural/subtract",
																			ignoreCase: false,
																			want:       "\"Natural/subtract\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 271, col: 5, offset: 7016},
																		run: (*parser).callonExpression181,
																		expr: &litMatcher{
																			pos:        position{line: 271, col: 5, offset: 7016},
																			val:        "Double/show",
																			ignoreCase: false,
																			want:       "\"Double/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 272, col: 5, offset: 7061},
																		run: (*parser).callonExpression183,
																		expr: &litMatcher{
																			pos:        position{line: 272, col: 5, offset: 7061},
																			val:        "List/build",
																			ignoreCase: false,
																			want:       "\"List/build\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 273, col: 5, offset: 7104},
																		run: (*parser).callonExpression185,
																		expr: &litMatcher{
																			pos:        position{line: 273, col: 5, offset: 7104},
																			val:        "List/fold",
																			ignoreCase: false,
																			want:       "\"List/fold\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 274, col: 5, offset: 7145},
																		run: (*parser).callonExpression187,
																		expr: &litMatcher{
																			pos:        position{line: 274, col: 5, offset: 7145},
																			val:        "List/length",
																			ignoreCase: false,
																			want:       "\"List/length\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 275, col: 5, offset: 7190},
																		run: (*parser).callonExpression189,
																		expr: &litMatcher{
																			pos:        position{line: 275, col: 5, offset: 7190},
																			val:        "List/head",
																			ignoreCase: false,
																			want:       "\"List/head\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 276, col: 5, offset: 7231},
																		run: (*parser).callonExpression191,
																		expr: &litMatcher{
																			pos:        position{line: 276, col: 5, offset: 7231},
																			val:        "List/last",
																			ignoreCase: false,
																			want:       "\"List/last\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 277, col: 5, offset: 7272},
																		run: (*parser).callonExpression193,
																		expr: &litMatcher{
																			pos:        position{line: 277, col: 5, offset: 7272},
																			val:        "List/indexed",
																			ignoreCase: false,
																			want:       "\"List/indexed\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 278, col: 5, offset: 7319},
																		run: (*parser).callonExpression195,
																		expr: &litMatcher{
																			pos:        position{line: 278, col: 5, offset: 7319},
																			val:        "List/reverse",
																			ignoreCase: false,
																			want:       "\"List/reverse\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 279, col: 5, offset: 7366},
																		run: (*parser).callonExpression197,
																		expr: &litMatcher{
																			pos:        position{line: 279, col: 5, offset: 7366},
																			val:        "Text/show",
																			ignoreCase: false,
																			want:       "\"Text/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 280, col: 5, offset: 7407},
																		run: (*parser).callonExpression199,
																		expr: &litMatcher{
																			pos:        position{line: 280, col: 5, offset: 7407},
																			val:        "Text/replace",
																			ignoreCase: false,
																			want:       "\"Text/replace\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 281, col: 5, offset: 7454},
																		run: (*parser).callonExpression201,
																		expr: &litMatcher{
																			pos:        position{line: 281, col: 5, offset: 7454},
																			val:        "Bool",
																			ignoreCase: false,
																			want:       "\"Bool\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 282, col: 5, offset: 7486},
																		run: (*parser).callonExpression203,
																		expr: &litMatcher{
																			pos:        position{line: 282, col: 5, offset: 7486},
																			val:        "True",
																			ignoreCase: false,
																			want:       "\"True\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 283, col: 5, offset: 7518},
																		run: (*parser).callonExpression205,
																		expr: &litMatcher{
																			pos:        position{line: 283, col: 5, offset: 7518},
																			val:        "False",
																			ignoreCase: false,
																			want:       "\"False\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 284, col: 5, offset: 7552},
																		run: (*parser).callonExpression207,
																		expr: &litMatcher{
																			pos:        position{line: 284, col: 5, offset: 7552},
																			val:        "Optional",
																			ignoreCase: false,
																			want:       "\"Optional\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 285, col: 5, offset: 7592},
																		run: (*parser).callonExpression209,
																		expr: &litMatcher{
																			pos:        position{line: 285, col: 5, offset: 7592},
																			val:        "None",
																			ignoreCase: false,
																			want:       "\"None\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 286, col: 5, offset: 7624},
																		run: (*parser).callonExpression211,
																		expr: &litMatcher{
																			pos:        position{line: 286, col: 5, offset: 7624},
																			val:        "Natural",
																			ignoreCase: false,
																			want:       "\"Natural\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 287, col: 5, offset: 7662},
																		run: (*parser).callonExpression213,
																		expr: &litMatcher{
																			pos:        position{line: 287, col: 5, offset: 7662},
																			val:        "Integer",
																			ignoreCase: false,
																			want:       "\"Integer\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 288, col: 5, offset: 7700},
																		run: (*parser).callonExpression215,
																		expr: &litMatcher{
																			pos:        position{line: 288, col: 5, offset: 7700},
																			val:        "Double",
																			ignoreCase: false,
																			want:       "\"Double\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 289, col: 5, offset: 7736},
																		run: (*parser).callonExpression217,
																		expr: &litMatcher{
																			pos:        position{line: 289, col: 5, offset: 7736},
																			val:        "Text",
																			ignoreCase: false,
																			want:       "\"Text\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 290, col: 5, offset: 7768},
																		run: (*parser).callonExpression219,
																		expr: &litMatcher{
																			pos:        position{line: 290, col: 5, offset: 7768},
																			val:        "List",
																			ignoreCase: false,
																			want:       "\"List\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 291, col: 5, offset: 7800},
																		run: (*parser).callonExpression221,
																		expr: &litMatcher{
																			pos:        position{line: 291, col: 5, offset: 7800},
																			val:        "Type",
																			ignoreCase: false,
																			want:       "\"Type\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 292, col: 5, offset: 7832},
																		run: (*parser).callonExpression223,
																		expr: &litMatcher{
																			pos:        position{line: 292, col: 5, offset: 7832},
																			val:        "Kind",
																			ignoreCase: false,
																			want:       "\"Kind\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 293, col: 5, offset: 7864},
																		run: (*parser).callonExpression225,
																		expr: &litMatcher{
																			pos:        position{line: 293, col: 5, offset: 7864},
																			val:        "Sort",
																			ignoreCase: false,
																			want:       "\"Sort\"",
																		},
																	},
																},
															},
														},
														&labeledExpr{
															pos:   position{line: 135, col: 28, offset: 3329},
															label: "label",
															expr: &choiceExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 131, col: 9, offset: 3119},
																		run: (*parser).callonExpression229,
																		expr: &seqExpr{
																			pos: position{line: 131, col: 9, offset: 3119},
																			exprs: []interface{}{
																				&litMatcher{
																					pos:        position{line: 131, col: 9, offset: 3119},
																					val:        "`",
																					ignoreCase: false,
																					want:       "\"`\"",
																				},
																				&labeledExpr{
																					pos:   position{line: 131, col: 13, offset: 3123},
																					label: "label",
																					expr: &actionExpr{
																						pos: position{line: 129, col: 15, offset: 3060},
																						run: (*parser).callonExpression233,
																						expr: &zeroOrMoreExpr{
																							pos: position{line: 129, col: 15, offset: 3060},
																							expr: &charClassMatcher{
																								pos:        position{line: 128, col: 19, offset: 3023},
																								val:        "[ -_a-~]",
																								ranges:     []rune{' ', '_', 'a', '~'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																				&litMatcher{
																					pos:        position{line: 131, col: 31, offset: 3141},
																					val:        "`",
																					ignoreCase: false,
																					want:       "\"`\"",
																				},
																			},
																		},
																	},
																	&actionExpr{
																		pos: position{line: 132, col: 9, offset: 3175},
																		run: (*parser).callonExpression237,
																		expr: &labeledExpr{
																			pos:   position{line: 132, col: 9, offset: 3175},
																			label: "label",
																			expr: &choiceExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				alternatives: []interface{}{
																					&actionExpr{
																						pos: position{line: 122, col: 15, offset: 2816},
																						run: (*parser).callonExpression240,
																						expr: &seqExpr{
																							pos: position{line: 122, col: 15, offset: 2816},
																							exprs: []interface{}{
																								&choiceExpr{
																									pos: position{line: 249, col: 5, offset: 6269},
																									alternatives: []interface{}{
																										&litMatcher{
																											pos:        position{line: 231, col: 6, offset: 5936},
																											val:        "if",
																											ignoreCase: false,
																											want:       "\"if\"",
																										},
																										&litMatcher{
																											pos:        position{line: 232, col: 8, offset: 5950},
																											val:        "then",
																											ignoreCase: false,
																											want:       "\"then\"",
																										},
																										&litMatcher{
																											pos:        position{line: 233, col: 8, offset: 5966},
																											val:        "else",
																											ignoreCase: false,
																											want:       "\"else\"",
																										},
																										&litMatcher{
																											pos:        position{line: 234, col: 7, offset: 5981},
																											val:        "let",
																											ignoreCase: false,
																											want:       "\"let\"",
																										},
																										&litMatcher{
																											pos:        position{line: 235, col: 6, offset: 5994},
																											val:        "in",
																											ignoreCase: false,
																											want:       "\"in\"",
																										},
																										&litMatcher{
																											pos:        position{line: 237, col: 9, offset: 6021},
																											val:        "using",
																											ignoreCase: false,
																											want:       "\"using\"",
																										},
																										&actionExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											run: (*parser).callonExpression249,
																											expr: &seqExpr{
																												pos: position{line: 239, col: 11, offset: 6059},
																												exprs: []interface{}{
																													&litMatcher{
																														pos:        position{line: 239, col: 11, offset: 6059},
																														val:        "missing",
																														ignoreCase: false,
																														want:       "\"missing\"",
																													},
																													&notExpr{
																														pos: position{line: 239, col: 21, offset: 6069},
																														expr: &charClassMatcher{
																															pos:        position{line: 121, col: 23, offset: 2785},
																															val:        "[_/-A-Za-z0-9]",
																															chars:      []rune{'_', '/', '-'},
																															ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																															ignoreCase: false,
																															inverted:   false,
																														},
																													},
																												},
																											},
																										},
																										&litMatcher{
																											pos:        position{line: 244, col: 10, offset: 6199},
																											val:        "assert",
																											ignoreCase: false,
																											want:       "\"assert\"",
																										},
																										&litMatcher{
																											pos:        position{line: 236, col: 6, offset: 6006},
																											val:        "as",
																											ignoreCase: false,
																											want:       "\"as\"",
																										},
																										&litMatcher{
																											pos:        position{line: 240, col: 12, offset: 6129},
																											val:        "Infinity",
																											ignoreCase: false,
																											want:       "\"Infinity\"",
																										},
																										&litMatcher{
																											pos:        position{line: 241, col: 7, offset: 6148},
																											val:        "NaN",
																											ignoreCase: false,
																											want:       "\"NaN\"",
																										},
																										&litMatcher{
																											pos:        position{line: 238, col: 9, offset: 6039},
																											val:        "merge",
																											ignoreCase: false,
																											want:       "\"merge\"",
																										},
																										&litMatcher{
																											pos:        position{line: 242, col: 8, offset: 6163},
																											val:        "Some",
																											ignoreCase: false,
																											want:       "\"Some\"",
																										},
																										&litMatcher{
																											pos:        position{line: 243, col: 9, offset: 6180},
																											val:        "toMap",
																											ignoreCase: false,
																											want:       "\"toMap\"",
																										},
																										&litMatcher{
																											pos:        position{line: 245, col: 10, offset: 6219},
																											val:        "forall",
																											ignoreCase: false,
																											want:       "\"forall\"",
																										},
																										&litMatcher{
																											pos:        position{line: 245, col: 21, offset: 6230},
																											val:        "∀",
																											ignoreCase: false,
																											want:       "\"∀\"",
																										},
																										&litMatcher{
																											pos:        position{line: 246, col: 8, offset: 6245},
																											val:        "with",
																											ignoreCase: false,
																											want:       "\"with\"",
																										},
																									},
																								},
																								&oneOrMoreExpr{
																									pos: position{line: 122, col: 23, offset: 2824},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																					&actionExpr{
																						pos: position{line: 123, col: 13, offset: 2888},
																						run: (*parser).callonExpression266,
																						expr: &seqExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							exprs: []interface{}{
																								&notExpr{
																									pos: position{line: 123, col: 13, offset: 2888},
																									expr: &choiceExpr{
																										pos: position{line: 249, col: 5, offset: 6269},
																										alternatives: []interface{}{
																											&litMatcher{
																												pos:        position{line: 231, col: 6, offset: 5936},
																												val:        "if",
																												ignoreCase: false,
																												want:       "\"if\"",
																											},
																											&litMatcher{
																												pos:        position{line: 232, col: 8, offset: 5950},
																												val:        "then",
																												ignoreCase: false,
																												want:       "\"then\"",
																											},
																											&litMatcher{
																												pos:        position{line: 233, col: 8, offset: 5966},
																												val:        "else",
																												ignoreCase: false,
																												want:       "\"else\"",
																											},
																											&litMatcher{
																												pos:        position{line: 234, col: 7, offset: 5981},
																												val:        "let",
																												ignoreCase: false,
																												want:       "\"let\"",
																											},
																											&litMatcher{
																												pos:        position{line: 235, col: 6, offset: 5994},
																												val:        "in",
																												ignoreCase: false,
																												want:       "\"in\"",
																											},
																											&litMatcher{
																												pos:        position{line: 237, col: 9, offset: 6021},
																												val:        "using",
																												ignoreCase: false,
																												want:       "\"using\"",
																											},
																											&actionExpr{
																												pos: position{line: 239, col: 11, offset: 6059},
																												run: (*parser).callonExpression276,
																												expr: &seqExpr{
																													pos: position{line: 239, col: 11, offset: 6059},
																													exprs: []interface{}{
																														&litMatcher{
																															pos:        position{line: 239, col: 11, offset: 6059},
																															val:        "missing",
																															ignoreCase: false,
																															want:       "\"missing\"",
																														},
																														&notExpr{
																															pos: position{line: 239, col: 21, offset: 6069},
																															expr: &charClassMatcher{
																																pos:        position{line: 121, col: 23, offset: 2785},
																																val:        "[_/-A-Za-z0-9]",
																																chars:      []rune{'_', '/', '-'},
																																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																																ignoreCase: false,
																																inverted:   false,
																															},
																														},
																													},
																												},
																											},
																											&litMatcher{
																												pos:        position{line: 244, col: 10, offset: 6199},
																												val:        "assert",
																												ignoreCase: false,
																												want:       "\"assert\"",
																											},
																											&litMatcher{
																												pos:        position{line: 236, col: 6, offset: 6006},
																												val:        "as",
																												ignoreCase: false,
																												want:       "\"as\"",
																											},
																											&litMatcher{
																												pos:        position{line: 240, col: 12, offset: 6129},
																												val:        "Infinity",
																												ignoreCase: false,
																												want:       "\"Infinity\"",
																											},
																											&litMatcher{
																												pos:        position{line: 241, col: 7, offset: 6148},
																												val:        "NaN",
																												ignoreCase: false,
																												want:       "\"NaN\"",
																											},
																											&litMatcher{
																												pos:        position{line: 238, col: 9, offset: 6039},
																												val:        "merge",
																												ignoreCase: false,
																												want:       "\"merge\"",
																											},
																											&litMatcher{
																												pos:        position{line: 242, col: 8, offset: 6163},
																												val:        "Some",
																												ignoreCase: false,
																												want:       "\"Some\"",
																											},
																											&litMatcher{
																												pos:        position{line: 243, col: 9, offset: 6180},
																												val:        "toMap",
																												ignoreCase: false,
																												want:       "\"toMap\"",
																											},
																											&litMatcher{
																												pos:        position{line: 245, col: 10, offset: 6219},
																												val:        "forall",
																												ignoreCase: false,
																												want:       "\"forall\"",
																											},
																											&litMatcher{
																												pos:        position{line: 245, col: 21, offset: 6230},
																												val:        "∀",
																												ignoreCase: false,
																												want:       "\"∀\"",
																											},
																											&litMatcher{
																												pos:        position{line: 246, col: 8, offset: 6245},
																												val:        "with",
																												ignoreCase: false,
																												want:       "\"with\"",
																											},
																										},
																									},
																								},
																								&charClassMatcher{
																									pos:        position{line: 120, col: 24, offset: 2751},
																									val:        "[_A-Za-z]",
																									chars:      []rune{'_'},
																									ranges:     []rune{'A', 'Z', 'a', 'z'},
																									ignoreCase: false,
																									inverted:   false,
																								},
																								&zeroOrMoreExpr{
																									pos: position{line: 123, col: 43, offset: 2918},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
								&ruleRefExpr{
									pos:  position{line: 512, col: 45, offset: 14522},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 512, col: 47, offset: 14524},
									val:        ":",
									ignoreCase: false,
									want:       "\":\"",
								},
								&ruleRefExpr{
									pos:  position{line: 512, col: 51, offset: 14528},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 512, col: 54, offset: 14531},
									label: "t",
									expr: &ruleRefExpr{
										pos:  position{line: 512, col: 56, offset: 14533},
										name: "Expression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 512, col: 67, offset: 14544},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 512, col: 69, offset: 14546},
									val:        ")",
									ignoreCase: false,
									want:       "\")\"",
								},
								&ruleRefExpr{
									pos:  position{line: 512, col: 73, offset: 14550},
									name: "_",
								},
								&choiceExpr{
									pos: position{line: 303, col: 9, offset: 8080},
									alternatives: []interface{}{
										&litMatcher{
											pos:        position{line: 303, col: 9, offset: 8080},
											val:        "->",
											ignoreCase: false,
											want:       "\"->\"",
										},
										&litMatcher{
											pos:        position{line: 303, col: 16, offset: 8087},
											val:        "→",
											ignoreCase: false,
											want:       "\"→\"",
										},
									},
								},
								&ruleRefExpr{
									pos:  position{line: 512, col: 81, offset: 14558},
									name: "_",
								},
								&labeledExpr{
									pos:   position{line: 512, col: 83, offset: 14560},
									label: "body",
									expr: &ruleRefExpr{
										pos:  position{line: 512, col: 88, offset: 14565},
										name: "Expression",
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 515, col: 7, offset: 14677},
						run: (*parser).callonExpression308,
						expr: &seqExpr{
							pos: position{line: 515, col: 7, offset: 14677},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 231, col: 6, offset: 5936},
									val:        "if",
									ignoreCase: false,
									want:       "\"if\"",
								},
								&ruleRefExpr{
									pos:  position{line: 515, col: 10, offset: 14680},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 515, col: 13, offset: 14683},
									label: "cond",
									expr: &ruleRefExpr{
										pos:  position{line: 515, col: 18, offset: 14688},
										name: "Expression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 515, col: 29, offset: 14699},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 232, col: 8, offset: 5950},
									val:        "then",
									ignoreCase: false,
									want:       "\"then\"",
								},
								&ruleRefExpr{
									pos:  position{line: 515, col: 36, offset: 14706},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 515, col: 39, offset: 14709},
									label: "t",
									expr: &ruleRefExpr{
										pos:  position{line: 515, col: 41, offset: 14711},
										name: "Expression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 515, col: 52, offset: 14722},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 233, col: 8, offset: 5966},
									val:        "else",
									ignoreCase: false,
									want:       "\"else\"",
								},
								&ruleRefExpr{
									pos:  position{line: 515, col: 59, offset: 14729},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 515, col: 62, offset: 14732},
									label: "f",
									expr: &ruleRefExpr{
										pos:  position{line: 515, col: 64, offset: 14734},
										name: "Expression",
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 518, col: 7, offset: 14816},
						run: (*parser).callonExpression324,
						expr: &seqExpr{
							pos: position{line: 518, col: 7, offset: 14816},
							exprs: []interface{}{
								&labeledExpr{
									pos:   position{line: 518, col: 7, offset: 14816},
									label: "bindings",
									expr: &oneOrMoreExpr{
										pos: position{line: 518, col: 16, offset: 14825},
										expr: &ruleRefExpr{
											pos:  position{line: 518, col: 16, offset: 14825},
											name: "LetBinding",
										},
									},
								},
								&litMatcher{
									pos:        position{line: 235, col: 6, offset: 5994},
									val:        "in",
									ignoreCase: false,
									want:       "\"in\"",
								},
								&ruleRefExpr{
									pos:  position{line: 518, col: 31, offset: 14840},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 518, col: 34, offset: 14843},
									label: "b",
									expr: &ruleRefExpr{
										pos:  position{line: 518, col: 36, offset: 14845},
										name: "Expression",
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 525, col: 7, offset: 15084},
						run: (*parser).callonExpression333,
						expr: &seqExpr{
							pos: position{line: 525, col: 7, offset: 15084},
							exprs: []interface{}{
								&choiceExpr{
									pos: position{line: 245, col: 10, offset: 6219},
									alternatives: []interface{}{
										&litMatcher{
											pos:        position{line: 245, col: 10, offset: 6219},
											val:        "forall",
											ignoreCase: false,
											want:       "\"forall\"",
										},
										&litMatcher{
											pos:        position{line: 245, col: 21, offset: 6230},
											val:        "∀",
											ignoreCase: false,
											want:       "\"∀\"",
										},
									},
								},
								&ruleRefExpr{
									pos:  position{line: 525, col: 14, offset: 15091},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 525, col: 16, offset: 15093},
									val:        "(",
									ignoreCase: false,
									want:       "\"(\"",
								},
								&ruleRefExpr{
									pos:  position{line: 525, col: 20, offset: 15097},
									name: "_",
								},
								&labeledExpr{
									pos:   position{line: 525, col: 22, offset: 15099},
									label: "label",
									expr: &choiceExpr{
										pos: position{line: 134, col: 20, offset: 3237},
										alternatives: []interface{}{
											&actionExpr{
												pos: position{line: 134, col: 20, offset: 3237},
												run: (*parser).callonExpression343,
												expr: &seqExpr{
													pos: position{line: 134, col: 20, offset: 3237},
													exprs: []interface{}{
														&andExpr{
															pos: position{line: 134, col: 20, offset: 3237},
															expr: &seqExpr{
																pos: position{line: 134, col: 22, offset: 3239},
																exprs: []interface{}{
																	&choiceExpr{
																		pos: position{line: 259, col: 5, offset: 6416},
																		alternatives: []interface{}{
																			&actionExpr{
																				pos: position{line: 259, col: 5, offset: 6416},
																				run: (*parser).callonExpression348,
																				expr: &litMatcher{
																					pos:        position{line: 259, col: 5, offset: 6416},
																					val:        "Natural/fold",
																					ignoreCase: false,
																					want:       "\"Natural/fold\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 260, col: 5, offset: 6463},
																				run: (*parser).callonExpression350,
																				expr: &litMatcher{
																					pos:        position{line: 260, col: 5, offset: 6463},
																					val:        "Natural/build",
																					ignoreCase: false,
																					want:       "\"Natural/build\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 261, col: 5, offset: 6512},
																				run: (*parser).callonExpression352,
																				expr: &litMatcher{
																					pos:        position{line: 261, col: 5, offset: 6512},
																					val:        "Natural/isZero",
																					ignoreCase: false,
																					want:       "\"Natural/isZero\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 262, col: 5, offset: 6563},
																				run: (*parser).callonExpression354,
																				expr: &litMatcher{
																					pos:        position{line: 262, col: 5, offset: 6563},
																					val:        "Natural/even",
																					ignoreCase: false,
																					want:       "\"Natural/even\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 263, col: 5, offset: 6610},
																				run: (*parser).callonExpression356,
																				expr: &litMatcher{
																					pos:        position{line: 263, col: 5, offset: 6610},
																					val:        "Natural/odd",
																					ignoreCase: false,
																					want:       "\"Natural/odd\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 264, col: 5, offset: 6655},
																				run: (*parser).callonExpression358,
																				expr: &litMatcher{
																					pos:        position{line: 264, col: 5, offset: 6655},
																					val:        "Natural/toInteger",
																					ignoreCase: false,
																					want:       "\"Natural/toInteger\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 265, col: 5, offset: 6712},
																				run: (*parser).callonExpression360,
																				expr: &litMatcher{
																					pos:        position{line: 265, col: 5, offset: 6712},
																					val:        "Natural/show",
																					ignoreCase: false,
																					want:       "\"Natural/show\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 266, col: 5, offset: 6759},
																				run: (*parser).callonExpression362,
																				expr: &litMatcher{
																					pos:        position{line: 266, col: 5, offset: 6759},
																					val:        "Integer/toDouble",
																					ignoreCase: false,
																					want:       "\"Integer/toDouble\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 267, col: 5, offset: 6814},
																				run: (*parser).callonExpression364,
																				expr: &litMatcher{
																					pos:        position{line: 267, col: 5, offset: 6814},
																					val:        "Integer/show",
																					ignoreCase: false,
																					want:       "\"Integer/show\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 268, col: 5, offset: 6861},
																				run: (*parser).callonExpression366,
																				expr: &litMatcher{
																					pos:        position{line: 268, col: 5, offset: 6861},
																					val:        "Integer/negate",
																					ignoreCase: false,
																					want:       "\"Integer/negate\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 269, col: 5, offset: 6912},
																				run: (*parser).callonExpression368,
																				expr: &litMatcher{
																					pos:        position{line: 269, col: 5, offset: 6912},
																					val:        "Integer/clamp",
																					ignoreCase: false,
																					want:       "\"Integer/clamp\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 270, col: 5, offset: 6961},
																				run: (*parser).callonExpression370,
																				expr: &litMatcher{
																					pos:        position{line: 270, col: 5, offset: 6961},
																					val:        "Natural/subtract",
																					ignoreCase: false,
																					want:       "\"Natural/subtract\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 271, col: 5, offset: 7016},
																				run: (*parser).callonExpression372,
																				expr: &litMatcher{
																					pos:        position{line: 271, col: 5, offset: 7016},
																					val:        "Double/show",
																					ignoreCase: false,
																					want:       "\"Double/show\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 272, col: 5, offset: 7061},
																				run: (*parser).callonExpression374,
																				expr: &litMatcher{
																					pos:        position{line: 272, col: 5, offset: 7061},
																					val:        "List/build",
																					ignoreCase: false,
																					want:       "\"List/build\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 273, col: 5, offset: 7104},
																				run: (*parser).callonExpression376,
																				expr: &litMatcher{
																					pos:        position{line: 273, col: 5, offset: 7104},
																					val:        "List/fold",
																					ignoreCase: false,
																					want:       "\"List/fold\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 274, col: 5, offset: 7145},
																				run: (*parser).callonExpression378,
																				expr: &litMatcher{
																					pos:        position{line: 274, col: 5, offset: 7145},
																					val:        "List/length",
																					ignoreCase: false,
																					want:       "\"List/length\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 275, col: 5, offset: 7190},
																				run: (*parser).callonExpression380,
																				expr: &litMatcher{
																					pos:        position{line: 275, col: 5, offset: 7190},
																					val:        "List/head",
																					ignoreCase: false,
																					want:       "\"List/head\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 276, col: 5, offset: 7231},
																				run: (*parser).callonExpression382,
																				expr: &litMatcher{
																					pos:        position{line: 276, col: 5, offset: 7231},
																					val:        "List/last",
																					ignoreCase: false,
																					want:       "\"List/last\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 277, col: 5, offset: 7272},
																				run: (*parser).callonExpression384,
																				expr: &litMatcher{
																					pos:        position{line: 277, col: 5, offset: 7272},
																					val:        "List/indexed",
																					ignoreCase: false,
																					want:       "\"List/indexed\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 278, col: 5, offset: 7319},
																				run: (*parser).callonExpression386,
																				expr: &litMatcher{
																					pos:        position{line: 278, col: 5, offset: 7319},
																					val:        "List/reverse",
																					ignoreCase: false,
																					want:       "\"List/reverse\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 279, col: 5, offset: 7366},
																				run: (*parser).callonExpression388,
																				expr: &litMatcher{
																					pos:        position{line: 279, col: 5, offset: 7366},
																					val:        "Text/show",
																					ignoreCase: false,
																					want:       "\"Text/show\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 280, col: 5, offset: 7407},
																				run: (*parser).callonExpression390,
																				expr: &litMatcher{
																					pos:        position{line: 280, col: 5, offset: 7407},
																					val:        "Text/replace",
																					ignoreCase: false,
																					want:       "\"Text/replace\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 281, col: 5, offset: 7454},
																				run: (*parser).callonExpression392,
																				expr: &litMatcher{
																					pos:        position{line: 281, col: 5, offset: 7454},
																					val:        "Bool",
																					ignoreCase: false,
																					want:       "\"Bool\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 282, col: 5, offset: 7486},
																				run: (*parser).callonExpression394,
																				expr: &litMatcher{
																					pos:        position{line: 282, col: 5, offset: 7486},
																					val:        "True",
																					ignoreCase: false,
																					want:       "\"True\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 283, col: 5, offset: 7518},
																				run: (*parser).callonExpression396,
																				expr: &litMatcher{
																					pos:        position{line: 283, col: 5, offset: 7518},
																					val:        "False",
																					ignoreCase: false,
																					want:       "\"False\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 284, col: 5, offset: 7552},
																				run: (*parser).callonExpression398,
																				expr: &litMatcher{
																					pos:        position{line: 284, col: 5, offset: 7552},
																					val:        "Optional",
																					ignoreCase: false,
																					want:       "\"Optional\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 285, col: 5, offset: 7592},
																				run: (*parser).callonExpression400,
																				expr: &litMatcher{
																					pos:        position{line: 285, col: 5, offset: 7592},
																					val:        "None",
																					ignoreCase: false,
																					want:       "\"None\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 286, col: 5, offset: 7624},
																				run: (*parser).callonExpression402,
																				expr: &litMatcher{
																					pos:        position{line: 286, col: 5, offset: 7624},
																					val:        "Natural",
																					ignoreCase: false,
																					want:       "\"Natural\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 287, col: 5, offset: 7662},
																				run: (*parser).callonExpression404,
																				expr: &litMatcher{
																					pos:        position{line: 287, col: 5, offset: 7662},
																					val:        "Integer",
																					ignoreCase: false,
																					want:       "\"Integer\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 288, col: 5, offset: 7700},
																				run: (*parser).callonExpression406,
																				expr: &litMatcher{
																					pos:        position{line: 288, col: 5, offset: 7700},
																					val:        "Double",
																					ignoreCase: false,
																					want:       "\"Double\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 289, col: 5, offset: 7736},
																				run: (*parser).callonExpression408,
																				expr: &litMatcher{
																					pos:        position{line: 289, col: 5, offset: 7736},
																					val:        "Text",
																					ignoreCase: false,
																					want:       "\"Text\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 290, col: 5, offset: 7768},
																				run: (*parser).callonExpression410,
																				expr: &litMatcher{
																					pos:        position{line: 290, col: 5, offset: 7768},
																					val:        "List",
																					ignoreCase: false,
																					want:       "\"List\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 291, col: 5, offset: 7800},
																				run: (*parser).callonExpression412,
																				expr: &litMatcher{
																					pos:        position{line: 291, col: 5, offset: 7800},
																					val:        "Type",
																					ignoreCase: false,
																					want:       "\"Type\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 292, col: 5, offset: 7832},
																				run: (*parser).callonExpression414,
																				expr: &litMatcher{
																					pos:        position{line: 292, col: 5, offset: 7832},
																					val:        "Kind",
																					ignoreCase: false,
																					want:       "\"Kind\"",
																				},
																			},
																			&actionExpr{
																				pos: position{line: 293, col: 5, offset: 7864},
																				run: (*parser).callonExpression416,
																				expr: &litMatcher{
																					pos:        position{line: 293, col: 5, offset: 7864},
																					val:        "Sort",
																					ignoreCase: false,
																					want:       "\"Sort\"",
																				},
																			},
																		},
																	},
																	&charClassMatcher{
																		pos:        position{line: 121, col: 23, offset: 2785},
																		val:        "[_/-A-Za-z0-9]",
																		chars:      []rune{'_', '/', '-'},
																		ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
														&labeledExpr{
															pos:   position{line: 134, col: 51, offset: 3268},
															label: "label",
															expr: &choiceExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 131, col: 9, offset: 3119},
																		run: (*parser).callonExpression421,
																		expr: &seqExpr{
																			pos: position{line: 131, col: 9, offset: 3119},
																			exprs: []interface{}{
																				&litMatcher{
																					pos:        position{line: 131, col: 9, offset: 3119},
																					val:        "`",
																					ignoreCase: false,
																					want:       "\"`\"",
																				},
																				&labeledExpr{
																					pos:   position{line: 131, col: 13, offset: 3123},
																					label: "label",
																					expr: &actionExpr{
																						pos: position{line: 129, col: 15, offset: 3060},
																						run: (*parser).callonExpression425,
																						expr: &zeroOrMoreExpr{
																							pos: position{line: 129, col: 15, offset: 3060},
																							expr: &charClassMatcher{
																								pos:        position{line: 128, col: 19, offset: 3023},
																								val:        "[ -_a-~]",
																								ranges:     []rune{' ', '_', 'a', '~'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																				&litMatcher{
																					pos:        position{line: 131, col: 31, offset: 3141},
																					val:        "`",
																					ignoreCase: false,
																					want:       "\"`\"",
																				},
																			},
																		},
																	},
																	&actionExpr{
																		pos: position{line: 132, col: 9, offset: 3175},
																		run: (*parser).callonExpression429,
																		expr: &labeledExpr{
																			pos:   position{line: 132, col: 9, offset: 3175},
																			label: "label",
																			expr: &choiceExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				alternatives: []interface{}{
																					&actionExpr{
																						pos: position{line: 122, col: 15, offset: 2816},
																						run: (*parser).callonExpression432,
																						expr: &seqExpr{
																							pos: position{line: 122, col: 15, offset: 2816},
																							exprs: []interface{}{
																								&choiceExpr{
																									pos: position{line: 249, col: 5, offset: 6269},
																									alternatives: []interface{}{
																										&litMatcher{
																											pos:        position{line: 231, col: 6, offset: 5936},
																											val:        "if",
																											ignoreCase: false,
																											want:       "\"if\"",
																										},
																										&litMatcher{
																											pos:        position{line: 232, col: 8, offset: 5950},
																											val:        "then",
																											ignoreCase: false,
																											want:       "\"then\"",
																										},
																										&litMatcher{
																											pos:        position{line: 233, col: 8, offset: 5966},
																											val:        "else",
																											ignoreCase: false,
																											want:       "\"else\"",
																										},
																										&litMatcher{
																											pos:        position{line: 234, col: 7, offset: 5981},
																											val:        "let",
																											ignoreCase: false,
																											want:       "\"let\"",
																										},
																										&litMatcher{
																											pos:        position{line: 235, col: 6, offset: 5994},
																											val:        "in",
																											ignoreCase: false,
																											want:       "\"in\"",
																										},
																										&litMatcher{
																											pos:        position{line: 237, col: 9, offset: 6021},
																											val:        "using",
																											ignoreCase: false,
																											want:       "\"using\"",
																										},
																										&actionExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											run: (*parser).callonExpression441,
																											expr: &seqExpr{
																												pos: position{line: 239, col: 11, offset: 6059},
																												exprs: []interface{}{
																													&litMatcher{
																														pos:        position{line: 239, col: 11, offset: 6059},
																														val:        "missing",
																														ignoreCase: false,
																														want:       "\"missing\"",
																													},
																													&notExpr{
																														pos: position{line: 239, col: 21, offset: 6069},
																														expr: &charClassMatcher{
																															pos:        position{line: 121, col: 23, offset: 2785},
																															val:        "[_/-A-Za-z0-9]",
																															chars:      []rune{'_', '/', '-'},
																															ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																															ignoreCase: false,
																															inverted:   false,
																														},
																													},
																												},
																											},
																										},
																										&litMatcher{
																											pos:        position{line: 244, col: 10, offset: 6199},
																											val:        "assert",
																											ignoreCase: false,
																											want:       "\"assert\"",
																										},
																										&litMatcher{
																											pos:        position{line: 236, col: 6, offset: 6006},
																											val:        "as",
																											ignoreCase: false,
																											want:       "\"as\"",
																										},
																										&litMatcher{
																											pos:        position{line: 240, col: 12, offset: 6129},
																											val:        "Infinity",
																											ignoreCase: false,
																											want:       "\"Infinity\"",
																										},
																										&litMatcher{
																											pos:        position{line: 241, col: 7, offset: 6148},
																											val:        "NaN",
																											ignoreCase: false,
																											want:       "\"NaN\"",
																										},
																										&litMatcher{
																											pos:        position{line: 238, col: 9, offset: 6039},
																											val:        "merge",
																											ignoreCase: false,
																											want:       "\"merge\"",
																										},
																										&litMatcher{
																											pos:        position{line: 242, col: 8, offset: 6163},
																											val:        "Some",
																											ignoreCase: false,
																											want:       "\"Some\"",
																										},
																										&litMatcher{
																											pos:        position{line: 243, col: 9, offset: 6180},
																											val:        "toMap",
																											ignoreCase: false,
																											want:       "\"toMap\"",
																										},
																										&litMatcher{
																											pos:        position{line: 245, col: 10, offset: 6219},
																											val:        "forall",
																											ignoreCase: false,
																											want:       "\"forall\"",
																										},
																										&litMatcher{
																											pos:        position{line: 245, col: 21, offset: 6230},
																											val:        "∀",
																											ignoreCase: false,
																											want:       "\"∀\"",
																										},
																										&litMatcher{
																											pos:        position{line: 246, col: 8, offset: 6245},
																											val:        "with",
																											ignoreCase: false,
																											want:       "\"with\"",
																										},
																									},
																								},
																								&oneOrMoreExpr{
																									pos: position{line: 122, col: 23, offset: 2824},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																					&actionExpr{
																						pos: position{line: 123, col: 13, offset: 2888},
																						run: (*parser).callonExpression458,
																						expr: &seqExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							exprs: []interface{}{
																								&notExpr{
																									pos: position{line: 123, col: 13, offset: 2888},
																									expr: &choiceExpr{
																										pos: position{line: 249, col: 5, offset: 6269},
																										alternatives: []interface{}{
																											&litMatcher{
																												pos:        position{line: 231, col: 6, offset: 5936},
																												val:        "if",
																												ignoreCase: false,
																												want:       "\"if\"",
																											},
																											&litMatcher{
																												pos:        position{line: 232, col: 8, offset: 5950},
																												val:        "then",
																												ignoreCase: false,
																												want:       "\"then\"",
																											},
																											&litMatcher{
																												pos:        position{line: 233, col: 8, offset: 5966},
																												val:        "else",
																												ignoreCase: false,
																												want:       "\"else\"",
																											},
																											&litMatcher{
																												pos:        position{line: 234, col: 7, offset: 5981},
																												val:        "let",
																												ignoreCase: false,
																												want:       "\"let\"",
																											},
																											&litMatcher{
																												pos:        position{line: 235, col: 6, offset: 5994},
																												val:        "in",
																												ignoreCase: false,
																												want:       "\"in\"",
																											},
																											&litMatcher{
																												pos:        position{line: 237, col: 9, offset: 6021},
																												val:        "using",
																												ignoreCase: false,
																												want:       "\"using\"",
																											},
																											&actionExpr{
																												pos: position{line: 239, col: 11, offset: 6059},
																												run: (*parser).callonExpression468,
																												expr: &seqExpr{
																													pos: position{line: 239, col: 11, offset: 6059},
																													exprs: []interface{}{
																														&litMatcher{
																															pos:        position{line: 239, col: 11, offset: 6059},
																															val:        "missing",
																															ignoreCase: false,
																															want:       "\"missing\"",
																														},
																														&notExpr{
																															pos: position{line: 239, col: 21, offset: 6069},
																															expr: &charClassMatcher{
																																pos:        position{line: 121, col: 23, offset: 2785},
																																val:        "[_/-A-Za-z0-9]",
																																chars:      []rune{'_', '/', '-'},
																																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																																ignoreCase: false,
																																inverted:   false,
																															},
																														},
																													},
																												},
																											},
																											&litMatcher{
																												pos:        position{line: 244, col: 10, offset: 6199},
																												val:        "assert",
																												ignoreCase: false,
																												want:       "\"assert\"",
																											},
																											&litMatcher{
																												pos:        position{line: 236, col: 6, offset: 6006},
																												val:        "as",
																												ignoreCase: false,
																												want:       "\"as\"",
																											},
																											&litMatcher{
																												pos:        position{line: 240, col: 12, offset: 6129},
																												val:        "Infinity",
																												ignoreCase: false,
																												want:       "\"Infinity\"",
																											},
																											&litMatcher{
																												pos:        position{line: 241, col: 7, offset: 6148},
																												val:        "NaN",
																												ignoreCase: false,
																												want:       "\"NaN\"",
																											},
																											&litMatcher{
																												pos:        position{line: 238, col: 9, offset: 6039},
																												val:        "merge",
																												ignoreCase: false,
																												want:       "\"merge\"",
																											},
																											&litMatcher{
																												pos:        position{line: 242, col: 8, offset: 6163},
																												val:        "Some",
																												ignoreCase: false,
																												want:       "\"Some\"",
																											},
																											&litMatcher{
																												pos:        position{line: 243, col: 9, offset: 6180},
																												val:        "toMap",
																												ignoreCase: false,
																												want:       "\"toMap\"",
																											},
																											&litMatcher{
																												pos:        position{line: 245, col: 10, offset: 6219},
																												val:        "forall",
																												ignoreCase: false,
																												want:       "\"forall\"",
																											},
																											&litMatcher{
																												pos:        position{line: 245, col: 21, offset: 6230},
																												val:        "∀",
																												ignoreCase: false,
																												want:       "\"∀\"",
																											},
																											&litMatcher{
																												pos:        position{line: 246, col: 8, offset: 6245},
																												val:        "with",
																												ignoreCase: false,
																												want:       "\"with\"",
																											},
																										},
																									},
																								},
																								&charClassMatcher{
																									pos:        position{line: 120, col: 24, offset: 2751},
																									val:        "[_A-Za-z]",
																									chars:      []rune{'_'},
																									ranges:     []rune{'A', 'Z', 'a', 'z'},
																									ignoreCase: false,
																									inverted:   false,
																								},
																								&zeroOrMoreExpr{
																									pos: position{line: 123, col: 43, offset: 2918},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
											&actionExpr{
												pos: position{line: 135, col: 19, offset: 3320},
												run: (*parser).callonExpression486,
												expr: &seqExpr{
													pos: position{line: 135, col: 19, offset: 3320},
													exprs: []interface{}{
														&notExpr{
															pos: position{line: 135, col: 19, offset: 3320},
															expr: &choiceExpr{
																pos: position{line: 259, col: 5, offset: 6416},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 259, col: 5, offset: 6416},
																		run: (*parser).callonExpression490,
																		expr: &litMatcher{
																			pos:        position{line: 259, col: 5, offset: 6416},
																			val:        "Natural/fold",
																			ignoreCase: false,
																			want:       "\"Natural/fold\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 260, col: 5, offset: 6463},
																		run: (*parser).callonExpression492,
																		expr: &litMatcher{
																			pos:        position{line: 260, col: 5, offset: 6463},
																			val:        "Natural/build",
																			ignoreCase: false,
																			want:       "\"Natural/build\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 261, col: 5, offset: 6512},
																		run: (*parser).callonExpression494,
																		expr: &litMatcher{
																			pos:        position{line: 261, col: 5, offset: 6512},
																			val:        "Natural/isZero",
																			ignoreCase: false,
																			want:       "\"Natural/isZero\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 262, col: 5, offset: 6563},
																		run: (*parser).callonExpression496,
																		expr: &litMatcher{
																			pos:        position{line: 262, col: 5, offset: 6563},
																			val:        "Natural/even",
																			ignoreCase: false,
																			want:       "\"Natural/even\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 263, col: 5, offset: 6610},
																		run: (*parser).callonExpression498,
																		expr: &litMatcher{
																			pos:        position{line: 263, col: 5, offset: 6610},
																			val:        "Natural/odd",
																			ignoreCase: false,
																			want:       "\"Natural/odd\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 264, col: 5, offset: 6655},
																		run: (*parser).callonExpression500,
																		expr: &litMatcher{
																			pos:        position{line: 264, col: 5, offset: 6655},
																			val:        "Natural/toInteger",
																			ignoreCase: false,
																			want:       "\"Natural/toInteger\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 265, col: 5, offset: 6712},
																		run: (*parser).callonExpression502,
																		expr: &litMatcher{
																			pos:        position{line: 265, col: 5, offset: 6712},
																			val:        "Natural/show",
																			ignoreCase: false,
																			want:       "\"Natural/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 266, col: 5, offset: 6759},
																		run: (*parser).callonExpression504,
																		expr: &litMatcher{
																			pos:        position{line: 266, col: 5, offset: 6759},
																			val:        "Integer/toDouble",
																			ignoreCase: false,
																			want:       "\"Integer/toDouble\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 267, col: 5, offset: 6814},
																		run: (*parser).callonExpression506,
																		expr: &litMatcher{
																			pos:        position{line: 267, col: 5, offset: 6814},
																			val:        "Integer/show",
																			ignoreCase: false,
																			want:       "\"Integer/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 268, col: 5, offset: 6861},
																		run: (*parser).callonExpression508,
																		expr: &litMatcher{
																			pos:        position{line: 268, col: 5, offset: 6861},
																			val:        "Integer/negate",
																			ignoreCase: false,
																			want:       "\"Integer/negate\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 269, col: 5, offset: 6912},
																		run: (*parser).callonExpression510,
																		expr: &litMatcher{
																			pos:        position{line: 269, col: 5, offset: 6912},
																			val:        "Integer/clamp",
																			ignoreCase: false,
																			want:       "\"Integer/clamp\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 270, col: 5, offset: 6961},
																		run: (*parser).callonExpression512,
																		expr: &litMatcher{
																			pos:        position{line: 270, col: 5, offset: 6961},
																			val:        "Natural/subtract",
																			ignoreCase: false,
																			want:       "\"Natural/subtract\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 271, col: 5, offset: 7016},
																		run: (*parser).callonExpression514,
																		expr: &litMatcher{
																			pos:        position{line: 271, col: 5, offset: 7016},
																			val:        "Double/show",
																			ignoreCase: false,
																			want:       "\"Double/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 272, col: 5, offset: 7061},
																		run: (*parser).callonExpression516,
																		expr: &litMatcher{
																			pos:        position{line: 272, col: 5, offset: 7061},
																			val:        "List/build",
																			ignoreCase: false,
																			want:       "\"List/build\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 273, col: 5, offset: 7104},
																		run: (*parser).callonExpression518,
																		expr: &litMatcher{
																			pos:        position{line: 273, col: 5, offset: 7104},
																			val:        "List/fold",
																			ignoreCase: false,
																			want:       "\"List/fold\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 274, col: 5, offset: 7145},
																		run: (*parser).callonExpression520,
																		expr: &litMatcher{
																			pos:        position{line: 274, col: 5, offset: 7145},
																			val:        "List/length",
																			ignoreCase: false,
																			want:       "\"List/length\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 275, col: 5, offset: 7190},
																		run: (*parser).callonExpression522,
																		expr: &litMatcher{
																			pos:        position{line: 275, col: 5, offset: 7190},
																			val:        "List/head",
																			ignoreCase: false,
																			want:       "\"List/head\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 276, col: 5, offset: 7231},
																		run: (*parser).callonExpression524,
																		expr: &litMatcher{
																			pos:        position{line: 276, col: 5, offset: 7231},
																			val:        "List/last",
																			ignoreCase: false,
																			want:       "\"List/last\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 277, col: 5, offset: 7272},
																		run: (*parser).callonExpression526,
																		expr: &litMatcher{
																			pos:        position{line: 277, col: 5, offset: 7272},
																			val:        "List/indexed",
																			ignoreCase: false,
																			want:       "\"List/indexed\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 278, col: 5, offset: 7319},
																		run: (*parser).callonExpression528,
																		expr: &litMatcher{
																			pos:        position{line: 278, col: 5, offset: 7319},
																			val:        "List/reverse",
																			ignoreCase: false,
																			want:       "\"List/reverse\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 279, col: 5, offset: 7366},
																		run: (*parser).callonExpression530,
																		expr: &litMatcher{
																			pos:        position{line: 279, col: 5, offset: 7366},
																			val:        "Text/show",
																			ignoreCase: false,
																			want:       "\"Text/show\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 280, col: 5, offset: 7407},
																		run: (*parser).callonExpression532,
																		expr: &litMatcher{
																			pos:        position{line: 280, col: 5, offset: 7407},
																			val:        "Text/replace",
																			ignoreCase: false,
																			want:       "\"Text/replace\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 281, col: 5, offset: 7454},
																		run: (*parser).callonExpression534,
																		expr: &litMatcher{
																			pos:        position{line: 281, col: 5, offset: 7454},
																			val:        "Bool",
																			ignoreCase: false,
																			want:       "\"Bool\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 282, col: 5, offset: 7486},
																		run: (*parser).callonExpression536,
																		expr: &litMatcher{
																			pos:        position{line: 282, col: 5, offset: 7486},
																			val:        "True",
																			ignoreCase: false,
																			want:       "\"True\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 283, col: 5, offset: 7518},
																		run: (*parser).callonExpression538,
																		expr: &litMatcher{
																			pos:        position{line: 283, col: 5, offset: 7518},
																			val:        "False",
																			ignoreCase: false,
																			want:       "\"False\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 284, col: 5, offset: 7552},
																		run: (*parser).callonExpression540,
																		expr: &litMatcher{
																			pos:        position{line: 284, col: 5, offset: 7552},
																			val:        "Optional",
																			ignoreCase: false,
																			want:       "\"Optional\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 285, col: 5, offset: 7592},
																		run: (*parser).callonExpression542,
																		expr: &litMatcher{
																			pos:        position{line: 285, col: 5, offset: 7592},
																			val:        "None",
																			ignoreCase: false,
																			want:       "\"None\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 286, col: 5, offset: 7624},
																		run: (*parser).callonExpression544,
																		expr: &litMatcher{
																			pos:        position{line: 286, col: 5, offset: 7624},
																			val:        "Natural",
																			ignoreCase: false,
																			want:       "\"Natural\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 287, col: 5, offset: 7662},
																		run: (*parser).callonExpression546,
																		expr: &litMatcher{
																			pos:        position{line: 287, col: 5, offset: 7662},
																			val:        "Integer",
																			ignoreCase: false,
																			want:       "\"Integer\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 288, col: 5, offset: 7700},
																		run: (*parser).callonExpression548,
																		expr: &litMatcher{
																			pos:        position{line: 288, col: 5, offset: 7700},
																			val:        "Double",
																			ignoreCase: false,
																			want:       "\"Double\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 289, col: 5, offset: 7736},
																		run: (*parser).callonExpression550,
																		expr: &litMatcher{
																			pos:        position{line: 289, col: 5, offset: 7736},
																			val:        "Text",
																			ignoreCase: false,
																			want:       "\"Text\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 290, col: 5, offset: 7768},
																		run: (*parser).callonExpression552,
																		expr: &litMatcher{
																			pos:        position{line: 290, col: 5, offset: 7768},
																			val:        "List",
																			ignoreCase: false,
																			want:       "\"List\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 291, col: 5, offset: 7800},
																		run: (*parser).callonExpression554,
																		expr: &litMatcher{
																			pos:        position{line: 291, col: 5, offset: 7800},
																			val:        "Type",
																			ignoreCase: false,
																			want:       "\"Type\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 292, col: 5, offset: 7832},
																		run: (*parser).callonExpression556,
																		expr: &litMatcher{
																			pos:        position{line: 292, col: 5, offset: 7832},
																			val:        "Kind",
																			ignoreCase: false,
																			want:       "\"Kind\"",
																		},
																	},
																	&actionExpr{
																		pos: position{line: 293, col: 5, offset: 7864},
																		run: (*parser).callonExpression558,
																		expr: &litMatcher{
																			pos:        position{line: 293, col: 5, offset: 7864},
																			val:        "Sort",
																			ignoreCase: false,
																			want:       "\"Sort\"",
																		},
																	},
																},
															},
														},
														&labeledExpr{
															pos:   position{line: 135, col: 28, offset: 3329},
															label: "label",
															expr: &choiceExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																alternatives: []interface{}{
																	&actionExpr{
																		pos: position{line: 131, col: 9, offset: 3119},
																		run: (*parser).callonExpression562,
																		expr: &seqExpr{
																			pos: position{line: 131, col: 9, offset: 3119},
																			exprs: []interface{}{
																				&litMatcher{
																					pos:        position{line: 131, col: 9, offset: 3119},
																					val:        "`",
																					ignoreCase: false,
																					want:       "\"`\"",
																				},
																				&labeledExpr{
																					pos:   position{line: 131, col: 13, offset: 3123},
																					label: "label",
																					expr: &actionExpr{
																						pos: position{line: 129, col: 15, offset: 3060},
																						run: (*parser).callonExpression566,
																						expr: &zeroOrMoreExpr{
																							pos: position{line: 129, col: 15, offset: 3060},
																							expr: &charClassMatcher{
																								pos:        position{line: 128, col: 19, offset: 3023},
																								val:        "[ -_a-~]",
																								ranges:     []rune{' ', '_', 'a', '~'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																				&litMatcher{
																					pos:        position{line: 131, col: 31, offset: 3141},
																					val:        "`",
																					ignoreCase: false,
																					want:       "\"`\"",
																				},
																			},
																		},
																	},
																	&actionExpr{
																		pos: position{line: 132, col: 9, offset: 3175},
																		run: (*parser).callonExpression570,
																		expr: &labeledExpr{
																			pos:   position{line: 132, col: 9, offset: 3175},
																			label: "label",
																			expr: &choiceExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				alternatives: []interface{}{
																					&actionExpr{
																						pos: position{line: 122, col: 15, offset: 2816},
																						run: (*parser).callonExpression573,
																						expr: &seqExpr{
																							pos: position{line: 122, col: 15, offset: 2816},
																							exprs: []interface{}{
																								&choiceExpr{
																									pos: position{line: 249, col: 5, offset: 6269},
																									alternatives: []interface{}{
																										&litMatcher{
																											pos:        position{line: 231, col: 6, offset: 5936},
																											val:        "if",
																											ignoreCase: false,
																											want:       "\"if\"",
																										},
																										&litMatcher{
																											pos:        position{line: 232, col: 8, offset: 5950},
																											val:        "then",
																											ignoreCase: false,
																											want:       "\"then\"",
																										},
																										&litMatcher{
																											pos:        position{line: 233, col: 8, offset: 5966},
																											val:        "else",
																											ignoreCase: false,
																											want:       "\"else\"",
																										},
																										&litMatcher{
																											pos:        position{line: 234, col: 7, offset: 5981},
																											val:        "let",
																											ignoreCase: false,
																											want:       "\"let\"",
																										},
																										&litMatcher{
																											pos:        position{line: 235, col: 6, offset: 5994},
																											val:        "in",
																											ignoreCase: false,
																											want:       "\"in\"",
																										},
																										&litMatcher{
																											pos:        position{line: 237, col: 9, offset: 6021},
																											val:        "using",
																											ignoreCase: false,
																											want:       "\"using\"",
																										},
																										&actionExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											run: (*parser).callonExpression582,
																											expr: &seqExpr{
																												pos: position{line: 239, col: 11, offset: 6059},
																												exprs: []interface{}{
																													&litMatcher{
																														pos:        position{line: 239, col: 11, offset: 6059},
																														val:        "missing",
																														ignoreCase: false,
																														want:       "\"missing\"",
																													},
																													&notExpr{
																														pos: position{line: 239, col: 21, offset: 6069},
																														expr: &charClassMatcher{
																															pos:        position{line: 121, col: 23, offset: 2785},
																															val:        "[_/-A-Za-z0-9]",
																															chars:      []rune{'_', '/', '-'},
																															ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																															ignoreCase: false,
																															inverted:   false,
																														},
																													},
																												},
																											},
																										},
																										&litMatcher{
																											pos:        position{line: 244, col: 10, offset: 6199},
																											val:        "assert",
																											ignoreCase: false,
																											want:       "\"assert\"",
																										},
																										&litMatcher{
																											pos:        position{line: 236, col: 6, offset: 6006},
																											val:        "as",
																											ignoreCase: false,
																											want:       "\"as\"",
																										},
																										&litMatcher{
																											pos:        position{line: 240, col: 12, offset: 6129},
																											val:        "Infinity",
																											ignoreCase: false,
																											want:       "\"Infinity\"",
																										},
																										&litMatcher{
																											pos:        position{line: 241, col: 7, offset: 6148},
																											val:        "NaN",
																											ignoreCase: false,
																											want:       "\"NaN\"",
																										},
																										&litMatcher{
																											pos:        position{line: 238, col: 9, offset: 6039},
																											val:        "merge",
																											ignoreCase: false,
																											want:       "\"merge\"",
																										},
																										&litMatcher{
																											pos:        position{line: 242, col: 8, offset: 6163},
																											val:        "Some",
																											ignoreCase: false,
																											want:       "\"Some\"",
																										},
																										&litMatcher{
																											pos:        position{line: 243, col: 9, offset: 6180},
																											val:        "toMap",
																											ignoreCase: false,
																											want:       "\"toMap\"",
																										},
																										&litMatcher{
																											pos:        position{line: 245, col: 10, offset: 6219},
																											val:        "forall",
																											ignoreCase: false,
																											want:       "\"forall\"",
																										},
																										&litMatcher{
																											pos:        position{line: 245, col: 21, offset: 6230},
																											val:        "∀",
																											ignoreCase: false,
																											want:       "\"∀\"",
																										},
																										&litMatcher{
																											pos:        position{line: 246, col: 8, offset: 6245},
																											val:        "with",
																											ignoreCase: false,
																											want:       "\"with\"",
																										},
																									},
																								},
																								&oneOrMoreExpr{
																									pos: position{line: 122, col: 23, offset: 2824},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																					&actionExpr{
																						pos: position{line: 123, col: 13, offset: 2888},
																						run: (*parser).callonExpression599,
																						expr: &seqExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							exprs: []interface{}{
																								&notExpr{
																									pos: position{line: 123, col: 13, offset: 2888},
																									expr: &choiceExpr{
																										pos: position{line: 249, col: 5, offset: 6269},
																										alternatives: []interface{}{
																											&litMatcher{
																												pos:        position{line: 231, col: 6, offset: 5936},
																												val:        "if",
																												ignoreCase: false,
																												want:       "\"if\"",
																											},
																											&litMatcher{
																												pos:        position{line: 232, col: 8, offset: 5950},
																												val:        "then",
																												ignoreCase: false,
																												want:       "\"then\"",
																											},
																											&litMatcher{
																												pos:        position{line: 233, col: 8, offset: 5966},
																												val:        "else",
																												ignoreCase: false,
																												want:       "\"else\"",
																											},
																											&litMatcher{
																												pos:        position{line: 234, col: 7, offset: 5981},
																												val:        "let",
																												ignoreCase: false,
																												want:       "\"let\"",
																											},
																											&litMatcher{
																												pos:        position{line: 235, col: 6, offset: 5994},
																												val:        "in",
																												ignoreCase: false,
																												want:       "\"in\"",
																											},
																											&litMatcher{
																												pos:        position{line: 237, col: 9, offset: 6021},
																												val:        "using",
																												ignoreCase: false,
																												want:       "\"using\"",
																											},
																											&actionExpr{
																												pos: position{line: 239, col: 11, offset: 6059},
																												run: (*parser).callonExpression609,
																												expr: &seqExpr{
																													pos: position{line: 239, col: 11, offset: 6059},
																													exprs: []interface{}{
																														&litMatcher{
																															pos:        position{line: 239, col: 11, offset: 6059},
																															val:        "missing",
																															ignoreCase: false,
																															want:       "\"missing\"",
																														},
																														&notExpr{
																															pos: position{line: 239, col: 21, offset: 6069},
																															expr: &charClassMatcher{
																																pos:        position{line: 121, col: 23, offset: 2785},
																																val:        "[_/-A-Za-z0-9]",
																																chars:      []rune{'_', '/', '-'},
																																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																																ignoreCase: false,
																																inverted:   false,
																															},
																														},
																													},
																												},
																											},
																											&litMatcher{
																												pos:        position{line: 244, col: 10, offset: 6199},
																												val:        "assert",
																												ignoreCase: false,
																												want:       "\"assert\"",
																											},
																											&litMatcher{
																												pos:        position{line: 236, col: 6, offset: 6006},
																												val:        "as",
																												ignoreCase: false,
																												want:       "\"as\"",
																											},
																											&litMatcher{
																												pos:        position{line: 240, col: 12, offset: 6129},
																												val:        "Infinity",
																												ignoreCase: false,
																												want:       "\"Infinity\"",
																											},
																											&litMatcher{
																												pos:        position{line: 241, col: 7, offset: 6148},
																												val:        "NaN",
																												ignoreCase: false,
																												want:       "\"NaN\"",
																											},
																											&litMatcher{
																												pos:        position{line: 238, col: 9, offset: 6039},
																												val:        "merge",
																												ignoreCase: false,
																												want:       "\"merge\"",
																											},
																											&litMatcher{
																												pos:        position{line: 242, col: 8, offset: 6163},
																												val:        "Some",
																												ignoreCase: false,
																												want:       "\"Some\"",
																											},
																											&litMatcher{
																												pos:        position{line: 243, col: 9, offset: 6180},
																												val:        "toMap",
																												ignoreCase: false,
																												want:       "\"toMap\"",
																											},
																											&litMatcher{
																												pos:        position{line: 245, col: 10, offset: 6219},
																												val:        "forall",
																												ignoreCase: false,
																												want:       "\"forall\"",
																											},
																											&litMatcher{
																												pos:        position{line: 245, col: 21, offset: 6230},
																												val:        "∀",
																												ignoreCase: false,
																												want:       "\"∀\"",
																											},
																											&litMatcher{
																												pos:        position{line: 246, col: 8, offset: 6245},
																												val:        "with",
																												ignoreCase: false,
																												want:       "\"with\"",
																											},
																										},
																									},
																								},
																								&charClassMatcher{
																									pos:        position{line: 120, col: 24, offset: 2751},
																									val:        "[_A-Za-z]",
																									chars:      []rune{'_'},
																									ranges:     []rune{'A', 'Z', 'a', 'z'},
																									ignoreCase: false,
																									inverted:   false,
																								},
																								&zeroOrMoreExpr{
																									pos: position{line: 123, col: 43, offset: 2918},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
								&ruleRefExpr{
									pos:  position{line: 525, col: 45, offset: 15122},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 525, col: 47, offset: 15124},
									val:        ":",
									ignoreCase: false,
									want:       "\":\"",
								},
								&ruleRefExpr{
									pos:  position{line: 525, col: 51, offset: 15128},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 525, col: 54, offset: 15131},
									label: "t",
									expr: &ruleRefExpr{
										pos:  position{line: 525, col: 56, offset: 15133},
										name: "Expression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 525, col: 67, offset: 15144},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 525, col: 69, offset: 15146},
									val:        ")",
									ignoreCase: false,
									want:       "\")\"",
								},
								&ruleRefExpr{
									pos:  position{line: 525, col: 73, offset: 15150},
									name: "_",
								},
								&choiceExpr{
									pos: position{line: 303, col: 9, offset: 8080},
									alternatives: []interface{}{
										&litMatcher{
											pos:        position{line: 303, col: 9, offset: 8080},
											val:        "->",
											ignoreCase: false,
											want:       "\"->\"",
										},
										&litMatcher{
											pos:        position{line: 303, col: 16, offset: 8087},
											val:        "→",
											ignoreCase: false,
											want:       "\"→\"",
										},
									},
								},
								&ruleRefExpr{
									pos:  position{line: 525, col: 81, offset: 15158},
									name: "_",
								},
								&labeledExpr{
									pos:   position{line: 525, col: 83, offset: 15160},
									label: "body",
									expr: &ruleRefExpr{
										pos:  position{line: 525, col: 88, offset: 15165},
										name: "Expression",
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 528, col: 7, offset: 15273},
						run: (*parser).callonExpression641,
						expr: &seqExpr{
							pos: position{line: 528, col: 7, offset: 15273},
							exprs: []interface{}{
								&labeledExpr{
									pos:   position{line: 528, col: 7, offset: 15273},
									label: "o",
									expr: &ruleRefExpr{
										pos:  position{line: 528, col: 9, offset: 15275},
										name: "OperatorExpression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 528, col: 28, offset: 15294},
									name: "_",
								},
								&choiceExpr{
									pos: position{line: 303, col: 9, offset: 8080},
									alternatives: []interface{}{
										&litMatcher{
											pos:        position{line: 303, col: 9, offset: 8080},
											val:        "->",
											ignoreCase: false,
											want:       "\"->\"",
										},
										&litMatcher{
											pos:        position{line: 303, col: 16, offset: 8087},
											val:        "→",
											ignoreCase: false,
											want:       "\"→\"",
										},
									},
								},
								&ruleRefExpr{
									pos:  position{line: 528, col: 36, offset: 15302},
									name: "_",
								},
								&labeledExpr{
									pos:   position{line: 528, col: 38, offset: 15304},
									label: "e",
									expr: &ruleRefExpr{
										pos:  position{line: 528, col: 40, offset: 15306},
										name: "Expression",
									},
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 529, col: 7, offset: 15368},
						name: "WithExpression",
					},
					&actionExpr{
						pos: position{line: 530, col: 7, offset: 15389},
						run: (*parser).callonExpression653,
						expr: &seqExpr{
							pos: position{line: 530, col: 7, offset: 15389},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 238, col: 9, offset: 6039},
									val:        "merge",
									ignoreCase: false,
									want:       "\"merge\"",
								},
								&ruleRefExpr{
									pos:  position{line: 530, col: 13, offset: 15395},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 530, col: 16, offset: 15398},
									label: "h",
									expr: &ruleRefExpr{
										pos:  position{line: 530, col: 18, offset: 15400},
										name: "ImportExpression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 530, col: 35, offset: 15417},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 530, col: 38, offset: 15420},
									label: "u",
									expr: &ruleRefExpr{
										pos:  position{line: 530, col: 40, offset: 15422},
										name: "ImportExpression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 530, col: 57, offset: 15439},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 530, col: 59, offset: 15441},
									val:        ":",
									ignoreCase: false,
									want:       "\":\"",
								},
								&ruleRefExpr{
									pos:  position{line: 530, col: 63, offset: 15445},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 530, col: 66, offset: 15448},
									label: "a",
									expr: &ruleRefExpr{
										pos:  position{line: 530, col: 68, offset: 15450},
										name: "ApplicationExpression",
									},
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 533, col: 7, offset: 15571},
						name: "EmptyList",
					},
					&actionExpr{
						pos: position{line: 534, col: 7, offset: 15587},
						run: (*parser).callonExpression668,
						expr: &seqExpr{
							pos: position{line: 534, col: 7, offset: 15587},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 243, col: 9, offset: 6180},
									val:        "toMap",
									ignoreCase: false,
									want:       "\"toMap\"",
								},
								&ruleRefExpr{
									pos:  position{line: 534, col: 13, offset: 15593},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 534, col: 16, offset: 15596},
									label: "e",
									expr: &ruleRefExpr{
										pos:  position{line: 534, col: 18, offset: 15598},
										name: "ImportExpression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 534, col: 35, offset: 15615},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 534, col: 37, offset: 15617},
									val:        ":",
									ignoreCase: false,
									want:       "\":\"",
								},
								&ruleRefExpr{
									pos:  position{line: 534, col: 41, offset: 15621},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 534, col: 44, offset: 15624},
									label: "t",
									expr: &ruleRefExpr{
										pos:  position{line: 534, col: 46, offset: 15626},
										name: "ApplicationExpression",
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 535, col: 7, offset: 15696},
						run: (*parser).callonExpression679,
						expr: &seqExpr{
							pos: position{line: 535, col: 7, offset: 15696},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 244, col: 10, offset: 6199},
									val:        "assert",
									ignoreCase: false,
									want:       "\"assert\"",
								},
								&ruleRefExpr{
									pos:  position{line: 535, col: 14, offset: 15703},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 535, col: 16, offset: 15705},
									val:        ":",
									ignoreCase: false,
									want:       "\":\"",
								},
								&ruleRefExpr{
									pos:  position{line: 535, col: 20, offset: 15709},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 535, col: 23, offset: 15712},
									label: "a",
									expr: &ruleRefExpr{
										pos:  position{line: 535, col: 25, offset: 15714},
										name: "Expression",
									},
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 536, col: 7, offset: 15776},
						name: "AnnotatedExpression",
					},
				},
			},
		},
		{
			name: "Annotation",
			pos:  position{line: 538, col: 1, offset: 15797},
			expr: &actionExpr{
				pos: position{line: 538, col: 14, offset: 15812},
				run: (*parser).callonAnnotation1,
				expr: &seqExpr{
					pos: position{line: 538, col: 14, offset: 15812},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 538, col: 14, offset: 15812},
							val:        ":",
							ignoreCase: false,
							want:       "\":\"",
						},
						&ruleRefExpr{
							pos:  position{line: 538, col: 18, offset: 15816},
							name: "_1",
						},
						&labeledExpr{
							pos:   position{line: 538, col: 21, offset: 15819},
							label: "a",
							expr: &ruleRefExpr{
								pos:  position{line: 538, col: 23, offset: 15821},
								name: "Expression",
							},
						},
					},
				},
			},
		},
		{
			name: "AnnotatedExpression",
			pos:  position{line: 540, col: 1, offset: 15851},
			expr: &actionExpr{
				pos: position{line: 541, col: 1, offset: 15875},
				run: (*parser).callonAnnotatedExpression1,
				expr: &seqExpr{
					pos: position{line: 541, col: 1, offset: 15875},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 541, col: 1, offset: 15875},
							label: "e",
							expr: &ruleRefExpr{
								pos:  position{line: 541, col: 3, offset: 15877},
								name: "OperatorExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 541, col: 22, offset: 15896},
							label: "a",
							expr: &zeroOrOneExpr{
								pos: position{line: 541, col: 24, offset: 15898},
								expr: &seqExpr{
									pos: position{line: 541, col: 25, offset: 15899},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 541, col: 25, offset: 15899},
											name: "_",
										},
										&ruleRefExpr{
											pos:  position{line: 541, col: 27, offset: 15901},
											name: "Annotation",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "EmptyList",
			pos:  position{line: 546, col: 1, offset: 16026},
			expr: &actionExpr{
				pos: position{line: 546, col: 13, offset: 16040},
				run: (*parser).callonEmptyList1,
				expr: &seqExpr{
					pos: position{line: 546, col: 13, offset: 16040},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 546, col: 13, offset: 16040},
							val:        "[",
							ignoreCase: false,
							want:       "\"[\"",
						},
						&ruleRefExpr{
							pos:  position{line: 546, col: 17, offset: 16044},
							name: "_",
						},
						&zeroOrOneExpr{
							pos: position{line: 546, col: 19, offset: 16046},
							expr: &seqExpr{
								pos: position{line: 546, col: 20, offset: 16047},
								exprs: []interface{}{
									&litMatcher{
										pos:        position{line: 546, col: 20, offset: 16047},
										val:        ",",
										ignoreCase: false,
										want:       "\",\"",
									},
									&ruleRefExpr{
										pos:  position{line: 546, col: 24, offset: 16051},
										name: "_",
									},
								},
							},
						},
						&litMatcher{
							pos:        position{line: 546, col: 28, offset: 16055},
							val:        "]",
							ignoreCase: false,
							want:       "\"]\"",
						},
						&ruleRefExpr{
							pos:  position{line: 546, col: 32, offset: 16059},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 546, col: 34, offset: 16061},
							val:        ":",
							ignoreCase: false,
							want:       "\":\"",
						},
						&ruleRefExpr{
							pos:  position{line: 546, col: 38, offset: 16065},
							name: "_1",
						},
						&labeledExpr{
							pos:   position{line: 546, col: 41, offset: 16068},
							label: "a",
							expr: &ruleRefExpr{
								pos:  position{line: 546, col: 43, offset: 16070},
								name: "ApplicationExpression",
							},
						},
					},
				},
			},
		},
		{
			name: "WithExpression",
			pos:  position{line: 550, col: 1, offset: 16138},
			expr: &actionExpr{
				pos: position{line: 551, col: 3, offset: 16159},
				run: (*parser).callonWithExpression1,
				expr: &seqExpr{
					pos: position{line: 551, col: 3, offset: 16159},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 551, col: 3, offset: 16159},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 551, col: 9, offset: 16165},
								name: "ImportExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 551, col: 26, offset: 16182},
							label: "rest",
							expr: &oneOrMoreExpr{
								pos: position{line: 551, col: 31, offset: 16187},
								expr: &seqExpr{
									pos: position{line: 551, col: 32, offset: 16188},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 551, col: 32, offset: 16188},
											name: "_1",
										},
										&litMatcher{
											pos:        position{line: 246, col: 8, offset: 6245},
											val:        "with",
											ignoreCase: false,
											want:       "\"with\"",
										},
										&ruleRefExpr{
											pos:  position{line: 551, col: 40, offset: 16196},
											name: "_1",
										},
										&ruleRefExpr{
											pos:  position{line: 551, col: 43, offset: 16199},
											name: "WithClause",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "WithClause",
			pos:  position{line: 564, col: 1, offset: 16530},
			expr: &seqExpr{
				pos: position{line: 564, col: 14, offset: 16545},
				exprs: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 564, col: 14, offset: 16545},
						name: "FieldPath",
					},
					&ruleRefExpr{
						pos:  position{line: 564, col: 24, offset: 16555},
						name: "_",
					},
					&litMatcher{
						pos:        position{line: 564, col: 26, offset: 16557},
						val:        "=",
						ignoreCase: false,
						want:       "\"=\"",
					},
					&ruleRefExpr{
						pos:  position{line: 564, col: 30, offset: 16561},
						name: "_",
					},
					&ruleRefExpr{
						pos:  position{line: 564, col: 32, offset: 16563},
						name: "OperatorExpression",
					},
				},
			},
		},
		{
			name: "FieldPath",
			pos:  position{line: 566, col: 1, offset: 16583},
			expr: &actionExpr{
				pos: position{line: 566, col: 13, offset: 16597},
				run: (*parser).callonFieldPath1,
				expr: &seqExpr{
					pos: position{line: 566, col: 13, offset: 16597},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 566, col: 13, offset: 16597},
							label: "first",
							expr: &choiceExpr{
								pos: position{line: 139, col: 18, offset: 3403},
								alternatives: []interface{}{
									&actionExpr{
										pos: position{line: 131, col: 9, offset: 3119},
										run: (*parser).callonFieldPath5,
										expr: &seqExpr{
											pos: position{line: 131, col: 9, offset: 3119},
											exprs: []interface{}{
												&litMatcher{
													pos:        position{line: 131, col: 9, offset: 3119},
													val:        "`",
													ignoreCase: false,
													want:       "\"`\"",
												},
												&labeledExpr{
													pos:   position{line: 131, col: 13, offset: 3123},
													label: "label",
													expr: &actionExpr{
														pos: position{line: 129, col: 15, offset: 3060},
														run: (*parser).callonFieldPath9,
														expr: &zeroOrMoreExpr{
															pos: position{line: 129, col: 15, offset: 3060},
															expr: &charClassMatcher{
																pos:        position{line: 128, col: 19, offset: 3023},
																val:        "[ -_a-~]",
																ranges:     []rune{' ', '_', 'a', '~'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
												&litMatcher{
													pos:        position{line: 131, col: 31, offset: 3141},
													val:        "`",
													ignoreCase: false,
													want:       "\"`\"",
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 132, col: 9, offset: 3175},
										run: (*parser).callonFieldPath13,
										expr: &labeledExpr{
											pos:   position{line: 132, col: 9, offset: 3175},
											label: "label",
											expr: &choiceExpr{
												pos: position{line: 122, col: 15, offset: 2816},
												alternatives: []interface{}{
													&actionExpr{
														pos: position{line: 122, col: 15, offset: 2816},
														run: (*parser).callonFieldPath16,
														expr: &seqExpr{
															pos: position{line: 122, col: 15, offset: 2816},
															exprs: []interface{}{
																&choiceExpr{
																	pos: position{line: 249, col: 5, offset: 6269},
																	alternatives: []interface{}{
																		&litMatcher{
																			pos:        position{line: 231, col: 6, offset: 5936},
																			val:        "if",
																			ignoreCase: false,
																			want:       "\"if\"",
																		},
																		&litMatcher{
																			pos:        position{line: 232, col: 8, offset: 5950},
																			val:        "then",
																			ignoreCase: false,
																			want:       "\"then\"",
																		},
																		&litMatcher{
																			pos:        position{line: 233, col: 8, offset: 5966},
																			val:        "else",
																			ignoreCase: false,
																			want:       "\"else\"",
																		},
																		&litMatcher{
																			pos:        position{line: 234, col: 7, offset: 5981},
																			val:        "let",
																			ignoreCase: false,
																			want:       "\"let\"",
																		},
																		&litMatcher{
																			pos:        position{line: 235, col: 6, offset: 5994},
																			val:        "in",
																			ignoreCase: false,
																			want:       "\"in\"",
																		},
																		&litMatcher{
																			pos:        position{line: 237, col: 9, offset: 6021},
																			val:        "using",
																			ignoreCase: false,
																			want:       "\"using\"",
																		},
																		&actionExpr{
																			pos: position{line: 239, col: 11, offset: 6059},
																			run: (*parser).callonFieldPath25,
																			expr: &seqExpr{
																				pos: position{line: 239, col: 11, offset: 6059},
																				exprs: []interface{}{
																					&litMatcher{
																						pos:        position{line: 239, col: 11, offset: 6059},
																						val:        "missing",
																						ignoreCase: false,
																						want:       "\"missing\"",
																					},
																					&notExpr{
																						pos: position{line: 239, col: 21, offset: 6069},
																						expr: &charClassMatcher{
																							pos:        position{line: 121, col: 23, offset: 2785},
																							val:        "[_/-A-Za-z0-9]",
																							chars:      []rune{'_', '/', '-'},
																							ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																					},
																				},
																			},
																		},
																		&litMatcher{
																			pos:        position{line: 244, col: 10, offset: 6199},
																			val:        "assert",
																			ignoreCase: false,
																			want:       "\"assert\"",
																		},
																		&litMatcher{
																			pos:        position{line: 236, col: 6, offset: 6006},
																			val:        "as",
																			ignoreCase: false,
																			want:       "\"as\"",
																		},
																		&litMatcher{
																			pos:        position{line: 240, col: 12, offset: 6129},
																			val:        "Infinity",
																			ignoreCase: false,
																			want:       "\"Infinity\"",
																		},
																		&litMatcher{
																			pos:        position{line: 241, col: 7, offset: 6148},
																			val:        "NaN",
																			ignoreCase: false,
																			want:       "\"NaN\"",
																		},
																		&litMatcher{
																			pos:        position{line: 238, col: 9, offset: 6039},
																			val:        "merge",
																			ignoreCase: false,
																			want:       "\"merge\"",
																		},
																		&litMatcher{
																			pos:        position{line: 242, col: 8, offset: 6163},
																			val:        "Some",
																			ignoreCase: false,
																			want:       "\"Some\"",
																		},
																		&litMatcher{
																			pos:        position{line: 243, col: 9, offset: 6180},
																			val:        "toMap",
																			ignoreCase: false,
																			want:       "\"toMap\"",
																		},
																		&litMatcher{
																			pos:        position{line: 245, col: 10, offset: 6219},
																			val:        "forall",
																			ignoreCase: false,
																			want:       "\"forall\"",
																		},
																		&litMatcher{
																			pos:        position{line: 245, col: 21, offset: 6230},
																			val:        "∀",
																			ignoreCase: false,
																			want:       "\"∀\"",
																		},
																		&litMatcher{
																			pos:        position{line: 246, col: 8, offset: 6245},
																			val:        "with",
																			ignoreCase: false,
																			want:       "\"with\"",
																		},
																	},
																},
																&oneOrMoreExpr{
																	pos: position{line: 122, col: 23, offset: 2824},
																	expr: &charClassMatcher{
																		pos:        position{line: 121, col: 23, offset: 2785},
																		val:        "[_/-A-Za-z0-9]",
																		chars:      []rune{'_', '/', '-'},
																		ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
													&actionExpr{
														pos: position{line: 123, col: 13, offset: 2888},
														run: (*parser).callonFieldPath42,
														expr: &seqExpr{
															pos: position{line: 123, col: 13, offset: 2888},
															exprs: []interface{}{
																&notExpr{
																	pos: position{line: 123, col: 13, offset: 2888},
																	expr: &choiceExpr{
																		pos: position{line: 249, col: 5, offset: 6269},
																		alternatives: []interface{}{
																			&litMatcher{
																				pos:        position{line: 231, col: 6, offset: 5936},
																				val:        "if",
																				ignoreCase: false,
																				want:       "\"if\"",
																			},
																			&litMatcher{
																				pos:        position{line: 232, col: 8, offset: 5950},
																				val:        "then",
																				ignoreCase: false,
																				want:       "\"then\"",
																			},
																			&litMatcher{
																				pos:        position{line: 233, col: 8, offset: 5966},
																				val:        "else",
																				ignoreCase: false,
																				want:       "\"else\"",
																			},
																			&litMatcher{
																				pos:        position{line: 234, col: 7, offset: 5981},
																				val:        "let",
																				ignoreCase: false,
																				want:       "\"let\"",
																			},
																			&litMatcher{
																				pos:        position{line: 235, col: 6, offset: 5994},
																				val:        "in",
																				ignoreCase: false,
																				want:       "\"in\"",
																			},
																			&litMatcher{
																				pos:        position{line: 237, col: 9, offset: 6021},
																				val:        "using",
																				ignoreCase: false,
																				want:       "\"using\"",
																			},
																			&actionExpr{
																				pos: position{line: 239, col: 11, offset: 6059},
																				run: (*parser).callonFieldPath52,
																				expr: &seqExpr{
																					pos: position{line: 239, col: 11, offset: 6059},
																					exprs: []interface{}{
																						&litMatcher{
																							pos:        position{line: 239, col: 11, offset: 6059},
																							val:        "missing",
																							ignoreCase: false,
																							want:       "\"missing\"",
																						},
																						&notExpr{
																							pos: position{line: 239, col: 21, offset: 6069},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																			&litMatcher{
																				pos:        position{line: 244, col: 10, offset: 6199},
																				val:        "assert",
																				ignoreCase: false,
																				want:       "\"assert\"",
																			},
																			&litMatcher{
																				pos:        position{line: 236, col: 6, offset: 6006},
																				val:        "as",
																				ignoreCase: false,
																				want:       "\"as\"",
																			},
																			&litMatcher{
																				pos:        position{line: 240, col: 12, offset: 6129},
																				val:        "Infinity",
																				ignoreCase: false,
																				want:       "\"Infinity\"",
																			},
																			&litMatcher{
																				pos:        position{line: 241, col: 7, offset: 6148},
																				val:        "NaN",
																				ignoreCase: false,
																				want:       "\"NaN\"",
																			},
																			&litMatcher{
																				pos:        position{line: 238, col: 9, offset: 6039},
																				val:        "merge",
																				ignoreCase: false,
																				want:       "\"merge\"",
																			},
																			&litMatcher{
																				pos:        position{line: 242, col: 8, offset: 6163},
																				val:        "Some",
																				ignoreCase: false,
																				want:       "\"Some\"",
																			},
																			&litMatcher{
																				pos:        position{line: 243, col: 9, offset: 6180},
																				val:        "toMap",
																				ignoreCase: false,
																				want:       "\"toMap\"",
																			},
																			&litMatcher{
																				pos:        position{line: 245, col: 10, offset: 6219},
																				val:        "forall",
																				ignoreCase: false,
																				want:       "\"forall\"",
																			},
																			&litMatcher{
																				pos:        position{line: 245, col: 21, offset: 6230},
																				val:        "∀",
																				ignoreCase: false,
																				want:       "\"∀\"",
																			},
																			&litMatcher{
																				pos:        position{line: 246, col: 8, offset: 6245},
																				val:        "with",
																				ignoreCase: false,
																				want:       "\"with\"",
																			},
																		},
																	},
																},
																&charClassMatcher{
																	pos:        position{line: 120, col: 24, offset: 2751},
																	val:        "[_A-Za-z]",
																	chars:      []rune{'_'},
																	ranges:     []rune{'A', 'Z', 'a', 'z'},
																	ignoreCase: false,
																	inverted:   false,
																},
																&zeroOrMoreExpr{
																	pos: position{line: 123, col: 43, offset: 2918},
																	expr: &charClassMatcher{
																		pos:        position{line: 121, col: 23, offset: 2785},
																		val:        "[_/-A-Za-z0-9]",
																		chars:      []rune{'_', '/', '-'},
																		ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 139, col: 29, offset: 3414},
										run: (*parser).callonFieldPath70,
										expr: &litMatcher{
											pos:        position{line: 242, col: 8, offset: 6163},
											val:        "Some",
											ignoreCase: false,
											want:       "\"Some\"",
										},
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 566, col: 34, offset: 16618},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 566, col: 39, offset: 16623},
								expr: &seqExpr{
									pos: position{line: 566, col: 40, offset: 16624},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 566, col: 40, offset: 16624},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 566, col: 42, offset: 16626},
											val:        ".",
											ignoreCase: false,
											want:       "\".\"",
										},
										&ruleRefExpr{
											pos:  position{line: 566, col: 46, offset: 16630},
											name: "_",
										},
										&choiceExpr{
											pos: position{line: 139, col: 18, offset: 3403},
											alternatives: []interface{}{
												&actionExpr{
													pos: position{line: 131, col: 9, offset: 3119},
													run: (*parser).callonFieldPath79,
													expr: &seqExpr{
														pos: position{line: 131, col: 9, offset: 3119},
														exprs: []interface{}{
															&litMatcher{
																pos:        position{line: 131, col: 9, offset: 3119},
																val:        "`",
																ignoreCase: false,
																want:       "\"`\"",
															},
															&labeledExpr{
																pos:   position{line: 131, col: 13, offset: 3123},
																label: "label",
																expr: &actionExpr{
																	pos: position{line: 129, col: 15, offset: 3060},
																	run: (*parser).callonFieldPath83,
																	expr: &zeroOrMoreExpr{
																		pos: position{line: 129, col: 15, offset: 3060},
																		expr: &charClassMatcher{
																			pos:        position{line: 128, col: 19, offset: 3023},
																			val:        "[ -_a-~]",
																			ranges:     []rune{' ', '_', 'a', '~'},
																			ignoreCase: false,
																			inverted:   false,
																		},
																	},
																},
															},
															&litMatcher{
																pos:        position{line: 131, col: 31, offset: 3141},
																val:        "`",
																ignoreCase: false,
																want:       "\"`\"",
															},
														},
													},
												},
												&actionExpr{
													pos: position{line: 132, col: 9, offset: 3175},
													run: (*parser).callonFieldPath87,
													expr: &labeledExpr{
														pos:   position{line: 132, col: 9, offset: 3175},
														label: "label",
														expr: &choiceExpr{
															pos: position{line: 122, col: 15, offset: 2816},
															alternatives: []interface{}{
																&actionExpr{
																	pos: position{line: 122, col: 15, offset: 2816},
																	run: (*parser).callonFieldPath90,
																	expr: &seqExpr{
																		pos: position{line: 122, col: 15, offset: 2816},
																		exprs: []interface{}{
																			&choiceExpr{
																				pos: position{line: 249, col: 5, offset: 6269},
																				alternatives: []interface{}{
																					&litMatcher{
																						pos:        position{line: 231, col: 6, offset: 5936},
																						val:        "if",
																						ignoreCase: false,
																						want:       "\"if\"",
																					},
																					&litMatcher{
																						pos:        position{line: 232, col: 8, offset: 5950},
																						val:        "then",
																						ignoreCase: false,
																						want:       "\"then\"",
																					},
																					&litMatcher{
																						pos:        position{line: 233, col: 8, offset: 5966},
																						val:        "else",
																						ignoreCase: false,
																						want:       "\"else\"",
																					},
																					&litMatcher{
																						pos:        position{line: 234, col: 7, offset: 5981},
																						val:        "let",
																						ignoreCase: false,
																						want:       "\"let\"",
																					},
																					&litMatcher{
																						pos:        position{line: 235, col: 6, offset: 5994},
																						val:        "in",
																						ignoreCase: false,
																						want:       "\"in\"",
																					},
																					&litMatcher{
																						pos:        position{line: 237, col: 9, offset: 6021},
																						val:        "using",
																						ignoreCase: false,
																						want:       "\"using\"",
																					},
																					&actionExpr{
																						pos: position{line: 239, col: 11, offset: 6059},
																						run: (*parser).callonFieldPath99,
																						expr: &seqExpr{
																							pos: position{line: 239, col: 11, offset: 6059},
																							exprs: []interface{}{
																								&litMatcher{
																									pos:        position{line: 239, col: 11, offset: 6059},
																									val:        "missing",
																									ignoreCase: false,
																									want:       "\"missing\"",
																								},
																								&notExpr{
																									pos: position{line: 239, col: 21, offset: 6069},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																					&litMatcher{
																						pos:        position{line: 244, col: 10, offset: 6199},
																						val:        "assert",
																						ignoreCase: false,
																						want:       "\"assert\"",
																					},
																					&litMatcher{
																						pos:        position{line: 236, col: 6, offset: 6006},
																						val:        "as",
																						ignoreCase: false,
																						want:       "\"as\"",
																					},
																					&litMatcher{
																						pos:        position{line: 240, col: 12, offset: 6129},
																						val:        "Infinity",
																						ignoreCase: false,
																						want:       "\"Infinity\"",
																					},
																					&litMatcher{
																						pos:        position{line: 241, col: 7, offset: 6148},
																						val:        "NaN",
																						ignoreCase: false,
																						want:       "\"NaN\"",
																					},
																					&litMatcher{
																						pos:        position{line: 238, col: 9, offset: 6039},
																						val:        "merge",
																						ignoreCase: false,
																						want:       "\"merge\"",
																					},
																					&litMatcher{
																						pos:        position{line: 242, col: 8, offset: 6163},
																						val:        "Some",
																						ignoreCase: false,
																						want:       "\"Some\"",
																					},
																					&litMatcher{
																						pos:        position{line: 243, col: 9, offset: 6180},
																						val:        "toMap",
																						ignoreCase: false,
																						want:       "\"toMap\"",
																					},
																					&litMatcher{
																						pos:        position{line: 245, col: 10, offset: 6219},
																						val:        "forall",
																						ignoreCase: false,
																						want:       "\"forall\"",
																					},
																					&litMatcher{
																						pos:        position{line: 245, col: 21, offset: 6230},
																						val:        "∀",
																						ignoreCase: false,
																						want:       "\"∀\"",
																					},
																					&litMatcher{
																						pos:        position{line: 246, col: 8, offset: 6245},
																						val:        "with",
																						ignoreCase: false,
																						want:       "\"with\"",
																					},
																				},
																			},
																			&oneOrMoreExpr{
																				pos: position{line: 122, col: 23, offset: 2824},
																				expr: &charClassMatcher{
																					pos:        position{line: 121, col: 23, offset: 2785},
																					val:        "[_/-A-Za-z0-9]",
																					chars:      []rune{'_', '/', '-'},
																					ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
																&actionExpr{
																	pos: position{line: 123, col: 13, offset: 2888},
																	run: (*parser).callonFieldPath116,
																	expr: &seqExpr{
																		pos: position{line: 123, col: 13, offset: 2888},
																		exprs: []interface{}{
																			&notExpr{
																				pos: position{line: 123, col: 13, offset: 2888},
																				expr: &choiceExpr{
																					pos: position{line: 249, col: 5, offset: 6269},
																					alternatives: []interface{}{
																						&litMatcher{
																							pos:        position{line: 231, col: 6, offset: 5936},
																							val:        "if",
																							ignoreCase: false,
																							want:       "\"if\"",
																						},
																						&litMatcher{
																							pos:        position{line: 232, col: 8, offset: 5950},
																							val:        "then",
																							ignoreCase: false,
																							want:       "\"then\"",
																						},
																						&litMatcher{
																							pos:        position{line: 233, col: 8, offset: 5966},
																							val:        "else",
																							ignoreCase: false,
																							want:       "\"else\"",
																						},
																						&litMatcher{
																							pos:        position{line: 234, col: 7, offset: 5981},
																							val:        "let",
																							ignoreCase: false,
																							want:       "\"let\"",
																						},
																						&litMatcher{
																							pos:        position{line: 235, col: 6, offset: 5994},
																							val:        "in",
																							ignoreCase: false,
																							want:       "\"in\"",
																						},
																						&litMatcher{
																							pos:        position{line: 237, col: 9, offset: 6021},
																							val:        "using",
																							ignoreCase: false,
																							want:       "\"using\"",
																						},
																						&actionExpr{
																							pos: position{line: 239, col: 11, offset: 6059},
																							run: (*parser).callonFieldPath126,
																							expr: &seqExpr{
																								pos: position{line: 239, col: 11, offset: 6059},
																								exprs: []interface{}{
																									&litMatcher{
																										pos:        position{line: 239, col: 11, offset: 6059},
																										val:        "missing",
																										ignoreCase: false,
																										want:       "\"missing\"",
																									},
																									&notExpr{
																										pos: position{line: 239, col: 21, offset: 6069},
																										expr: &charClassMatcher{
																											pos:        position{line: 121, col: 23, offset: 2785},
																											val:        "[_/-A-Za-z0-9]",
																											chars:      []rune{'_', '/', '-'},
																											ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																											ignoreCase: false,
																											inverted:   false,
																										},
																									},
																								},
																							},
																						},
																						&litMatcher{
																							pos:        position{line: 244, col: 10, offset: 6199},
																							val:        "assert",
																							ignoreCase: false,
																							want:       "\"assert\"",
																						},
																						&litMatcher{
																							pos:        position{line: 236, col: 6, offset: 6006},
																							val:        "as",
																							ignoreCase: false,
																							want:       "\"as\"",
																						},
																						&litMatcher{
																							pos:        position{line: 240, col: 12, offset: 6129},
																							val:        "Infinity",
																							ignoreCase: false,
																							want:       "\"Infinity\"",
																						},
																						&litMatcher{
																							pos:        position{line: 241, col: 7, offset: 6148},
																							val:        "NaN",
																							ignoreCase: false,
																							want:       "\"NaN\"",
																						},
																						&litMatcher{
																							pos:        position{line: 238, col: 9, offset: 6039},
																							val:        "merge",
																							ignoreCase: false,
																							want:       "\"merge\"",
																						},
																						&litMatcher{
																							pos:        position{line: 242, col: 8, offset: 6163},
																							val:        "Some",
																							ignoreCase: false,
																							want:       "\"Some\"",
																						},
																						&litMatcher{
																							pos:        position{line: 243, col: 9, offset: 6180},
																							val:        "toMap",
																							ignoreCase: false,
																							want:       "\"toMap\"",
																						},
																						&litMatcher{
																							pos:        position{line: 245, col: 10, offset: 6219},
																							val:        "forall",
																							ignoreCase: false,
																							want:       "\"forall\"",
																						},
																						&litMatcher{
																							pos:        position{line: 245, col: 21, offset: 6230},
																							val:        "∀",
																							ignoreCase: false,
																							want:       "\"∀\"",
																						},
																						&litMatcher{
																							pos:        position{line: 246, col: 8, offset: 6245},
																							val:        "with",
																							ignoreCase: false,
																							want:       "\"with\"",
																						},
																					},
																				},
																			},
																			&charClassMatcher{
																				pos:        position{line: 120, col: 24, offset: 2751},
																				val:        "[_A-Za-z]",
																				chars:      []rune{'_'},
																				ranges:     []rune{'A', 'Z', 'a', 'z'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&zeroOrMoreExpr{
																				pos: position{line: 123, col: 43, offset: 2918},
																				expr: &charClassMatcher{
																					pos:        position{line: 121, col: 23, offset: 2785},
																					val:        "[_/-A-Za-z0-9]",
																					chars:      []rune{'_', '/', '-'},
																					ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
												&actionExpr{
													pos: position{line: 139, col: 29, offset: 3414},
													run: (*parser).callonFieldPath144,
													expr: &litMatcher{
														pos:        position{line: 242, col: 8, offset: 6163},
														val:        "Some",
														ignoreCase: false,
														want:       "\"Some\"",
													},
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "OperatorExpression",
			pos:  position{line: 576, col: 1, offset: 16870},
			expr: &ruleRefExpr{
				pos:  position{line: 576, col: 22, offset: 16893},
				name: "EquivalentExpression",
			},
		},
		{
			name: "EquivalentExpression",
			pos:  position{line: 578, col: 1, offset: 16915},
			expr: &actionExpr{
				pos: position{line: 578, col: 26, offset: 16942},
				run: (*parser).callonEquivalentExpression1,
				expr: &seqExpr{
					pos: position{line: 578, col: 26, offset: 16942},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 578, col: 26, offset: 16942},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 578, col: 32, offset: 16948},
								name: "ImportAltExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 578, col: 55, offset: 16971},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 578, col: 60, offset: 16976},
								expr: &seqExpr{
									pos: position{line: 578, col: 61, offset: 16977},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 578, col: 61, offset: 16977},
											name: "_",
										},
										&choiceExpr{
											pos: position{line: 300, col: 14, offset: 8009},
											alternatives: []interface{}{
												&litMatcher{
													pos:        position{line: 300, col: 14, offset: 8009},
													val:        "===",
													ignoreCase: false,
													want:       "\"===\"",
												},
												&litMatcher{
													pos:        position{line: 300, col: 22, offset: 8017},
													val:        "≡",
													ignoreCase: false,
													want:       "\"≡\"",
												},
											},
										},
										&ruleRefExpr{
											pos:  position{line: 578, col: 74, offset: 16990},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 578, col: 76, offset: 16992},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 578, col: 78, offset: 16994},
												name: "ImportAltExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "ImportAltExpression",
			pos:  position{line: 580, col: 1, offset: 17068},
			expr: &actionExpr{
				pos: position{line: 580, col: 26, offset: 17095},
				run: (*parser).callonImportAltExpression1,
				expr: &seqExpr{
					pos: position{line: 580, col: 26, offset: 17095},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 580, col: 26, offset: 17095},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 580, col: 32, offset: 17101},
								name: "OrExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 580, col: 55, offset: 17124},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 580, col: 60, offset: 17129},
								expr: &seqExpr{
									pos: position{line: 580, col: 61, offset: 17130},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 580, col: 61, offset: 17130},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 580, col: 63, offset: 17132},
											val:        "?",
											ignoreCase: false,
											want:       "\"?\"",
										},
										&ruleRefExpr{
											pos:  position{line: 580, col: 67, offset: 17136},
											name: "_1",
										},
										&ruleRefExpr{
											pos:  position{line: 580, col: 70, offset: 17139},
											name: "OrExpression",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "OrExpression",
			pos:  position{line: 582, col: 1, offset: 17210},
			expr: &actionExpr{
				pos: position{line: 582, col: 26, offset: 17237},
				run: (*parser).callonOrExpression1,
				expr: &seqExpr{
					pos: position{line: 582, col: 26, offset: 17237},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 582, col: 26, offset: 17237},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 582, col: 32, offset: 17243},
								name: "PlusExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 582, col: 55, offset: 17266},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 582, col: 60, offset: 17271},
								expr: &seqExpr{
									pos: position{line: 582, col: 61, offset: 17272},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 582, col: 61, offset: 17272},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 582, col: 63, offset: 17274},
											val:        "||",
											ignoreCase: false,
											want:       "\"||\"",
										},
										&ruleRefExpr{
											pos:  position{line: 582, col: 68, offset: 17279},
											name: "_",
										},
										&ruleRefExpr{
											pos:  position{line: 582, col: 70, offset: 17281},
											name: "PlusExpression",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "PlusExpression",
			pos:  position{line: 584, col: 1, offset: 17347},
			expr: &actionExpr{
				pos: position{line: 584, col: 26, offset: 17374},
				run: (*parser).callonPlusExpression1,
				expr: &seqExpr{
					pos: position{line: 584, col: 26, offset: 17374},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 584, col: 26, offset: 17374},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 584, col: 32, offset: 17380},
								name: "TextAppendExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 584, col: 55, offset: 17403},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 584, col: 60, offset: 17408},
								expr: &seqExpr{
									pos: position{line: 584, col: 61, offset: 17409},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 584, col: 61, offset: 17409},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 584, col: 63, offset: 17411},
											val:        "+",
											ignoreCase: false,
											want:       "\"+\"",
										},
										&ruleRefExpr{
											pos:  position{line: 584, col: 67, offset: 17415},
											name: "_1",
										},
										&labeledExpr{
											pos:   position{line: 584, col: 70, offset: 17418},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 584, col: 72, offset: 17420},
												name: "TextAppendExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "TextAppendExpression",
			pos:  position{line: 586, col: 1, offset: 17494},
			expr: &actionExpr{
				pos: position{line: 586, col: 26, offset: 17521},
				run: (*parser).callonTextAppendExpression1,
				expr: &seqExpr{
					pos: position{line: 586, col: 26, offset: 17521},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 586, col: 26, offset: 17521},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 586, col: 32, offset: 17527},
								name: "ListAppendExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 586, col: 55, offset: 17550},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 586, col: 60, offset: 17555},
								expr: &seqExpr{
									pos: position{line: 586, col: 61, offset: 17556},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 586, col: 61, offset: 17556},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 586, col: 63, offset: 17558},
											val:        "++",
											ignoreCase: false,
											want:       "\"++\"",
										},
										&ruleRefExpr{
											pos:  position{line: 586, col: 68, offset: 17563},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 586, col: 70, offset: 17565},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 586, col: 72, offset: 17567},
												name: "ListAppendExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "ListAppendExpression",
			pos:  position{line: 588, col: 1, offset: 17647},
			expr: &actionExpr{
				pos: position{line: 588, col: 26, offset: 17674},
				run: (*parser).callonListAppendExpression1,
				expr: &seqExpr{
					pos: position{line: 588, col: 26, offset: 17674},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 588, col: 26, offset: 17674},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 588, col: 32, offset: 17680},
								name: "AndExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 588, col: 55, offset: 17703},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 588, col: 60, offset: 17708},
								expr: &seqExpr{
									pos: position{line: 588, col: 61, offset: 17709},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 588, col: 61, offset: 17709},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 588, col: 63, offset: 17711},
											val:        "#",
											ignoreCase: false,
											want:       "\"#\"",
										},
										&ruleRefExpr{
											pos:  position{line: 588, col: 67, offset: 17715},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 588, col: 69, offset: 17717},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 588, col: 71, offset: 17719},
												name: "AndExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "AndExpression",
			pos:  position{line: 590, col: 1, offset: 17792},
			expr: &actionExpr{
				pos: position{line: 590, col: 26, offset: 17819},
				run: (*parser).callonAndExpression1,
				expr: &seqExpr{
					pos: position{line: 590, col: 26, offset: 17819},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 590, col: 26, offset: 17819},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 590, col: 32, offset: 17825},
								name: "CombineExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 590, col: 55, offset: 17848},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 590, col: 60, offset: 17853},
								expr: &seqExpr{
									pos: position{line: 590, col: 61, offset: 17854},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 590, col: 61, offset: 17854},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 590, col: 63, offset: 17856},
											val:        "&&",
											ignoreCase: false,
											want:       "\"&&\"",
										},
										&ruleRefExpr{
											pos:  position{line: 590, col: 68, offset: 17861},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 590, col: 70, offset: 17863},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 590, col: 72, offset: 17865},
												name: "CombineExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "CombineExpression",
			pos:  position{line: 592, col: 1, offset: 17935},
			expr: &actionExpr{
				pos: position{line: 592, col: 26, offset: 17962},
				run: (*parser).callonCombineExpression1,
				expr: &seqExpr{
					pos: position{line: 592, col: 26, offset: 17962},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 592, col: 26, offset: 17962},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 592, col: 32, offset: 17968},
								name: "PreferExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 592, col: 55, offset: 17991},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 592, col: 60, offset: 17996},
								expr: &seqExpr{
									pos: position{line: 592, col: 61, offset: 17997},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 592, col: 61, offset: 17997},
											name: "_",
										},
										&choiceExpr{
											pos: position{line: 298, col: 11, offset: 7946},
											alternatives: []interface{}{
												&litMatcher{
													pos:        position{line: 298, col: 11, offset: 7946},
													val:        "/\\",
													ignoreCase: false,
													want:       "\"/\\\\\"",
												},
												&litMatcher{
													pos:        position{line: 298, col: 19, offset: 7954},
													val:        "∧",
													ignoreCase: false,
													want:       "\"∧\"",
												},
											},
										},
										&ruleRefExpr{
											pos:  position{line: 592, col: 71, offset: 18007},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 592, col: 73, offset: 18009},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 592, col: 75, offset: 18011},
												name: "PreferExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "PreferExpression",
			pos:  position{line: 594, col: 1, offset: 18088},
			expr: &actionExpr{
				pos: position{line: 594, col: 26, offset: 18115},
				run: (*parser).callonPreferExpression1,
				expr: &seqExpr{
					pos: position{line: 594, col: 26, offset: 18115},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 594, col: 26, offset: 18115},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 594, col: 32, offset: 18121},
								name: "CombineTypesExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 594, col: 55, offset: 18144},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 594, col: 60, offset: 18149},
								expr: &seqExpr{
									pos: position{line: 594, col: 61, offset: 18150},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 594, col: 61, offset: 18150},
											name: "_",
										},
										&choiceExpr{
											pos: position{line: 301, col: 10, offset: 8034},
											alternatives: []interface{}{
												&litMatcher{
													pos:        position{line: 301, col: 10, offset: 8034},
													val:        "//",
													ignoreCase: false,
													want:       "\"//\"",
												},
												&litMatcher{
													pos:        position{line: 301, col: 17, offset: 8041},
													val:        "⫽",
													ignoreCase: false,
													want:       "\"⫽\"",
												},
											},
										},
										&ruleRefExpr{
											pos:  position{line: 594, col: 70, offset: 18159},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 594, col: 72, offset: 18161},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 594, col: 74, offset: 18163},
												name: "CombineTypesExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "CombineTypesExpression",
			pos:  position{line: 596, col: 1, offset: 18257},
			expr: &actionExpr{
				pos: position{line: 596, col: 26, offset: 18284},
				run: (*parser).callonCombineTypesExpression1,
				expr: &seqExpr{
					pos: position{line: 596, col: 26, offset: 18284},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 596, col: 26, offset: 18284},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 596, col: 32, offset: 18290},
								name: "TimesExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 596, col: 55, offset: 18313},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 596, col: 60, offset: 18318},
								expr: &seqExpr{
									pos: position{line: 596, col: 61, offset: 18319},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 596, col: 61, offset: 18319},
											name: "_",
										},
										&choiceExpr{
											pos: position{line: 299, col: 16, offset: 7977},
											alternatives: []interface{}{
												&litMatcher{
													pos:        position{line: 299, col: 16, offset: 7977},
													val:        "//\\\\",
													ignoreCase: false,
													want:       "\"//\\\\\\\\\"",
												},
												&litMatcher{
													pos:        position{line: 299, col: 27, offset: 7988},
													val:        "⩓",
													ignoreCase: false,
													want:       "\"⩓\"",
												},
											},
										},
										&ruleRefExpr{
											pos:  position{line: 596, col: 76, offset: 18334},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 596, col: 78, offset: 18336},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 596, col: 80, offset: 18338},
												name: "TimesExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "TimesExpression",
			pos:  position{line: 598, col: 1, offset: 18418},
			expr: &actionExpr{
				pos: position{line: 598, col: 26, offset: 18445},
				run: (*parser).callonTimesExpression1,
				expr: &seqExpr{
					pos: position{line: 598, col: 26, offset: 18445},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 598, col: 26, offset: 18445},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 598, col: 32, offset: 18451},
								name: "EqualExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 598, col: 55, offset: 18474},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 598, col: 60, offset: 18479},
								expr: &seqExpr{
									pos: position{line: 598, col: 61, offset: 18480},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 598, col: 61, offset: 18480},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 598, col: 63, offset: 18482},
											val:        "*",
											ignoreCase: false,
											want:       "\"*\"",
										},
										&ruleRefExpr{
											pos:  position{line: 598, col: 67, offset: 18486},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 598, col: 69, offset: 18488},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 598, col: 71, offset: 18490},
												name: "EqualExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "EqualExpression",
			pos:  position{line: 600, col: 1, offset: 18560},
			expr: &actionExpr{
				pos: position{line: 600, col: 26, offset: 18587},
				run: (*parser).callonEqualExpression1,
				expr: &seqExpr{
					pos: position{line: 600, col: 26, offset: 18587},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 600, col: 26, offset: 18587},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 600, col: 32, offset: 18593},
								name: "NotEqualExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 600, col: 55, offset: 18616},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 600, col: 60, offset: 18621},
								expr: &seqExpr{
									pos: position{line: 600, col: 61, offset: 18622},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 600, col: 61, offset: 18622},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 600, col: 63, offset: 18624},
											val:        "==",
											ignoreCase: false,
											want:       "\"==\"",
										},
										&ruleRefExpr{
											pos:  position{line: 600, col: 68, offset: 18629},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 600, col: 70, offset: 18631},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 600, col: 72, offset: 18633},
												name: "NotEqualExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "NotEqualExpression",
			pos:  position{line: 602, col: 1, offset: 18703},
			expr: &actionExpr{
				pos: position{line: 602, col: 26, offset: 18730},
				run: (*parser).callonNotEqualExpression1,
				expr: &seqExpr{
					pos: position{line: 602, col: 26, offset: 18730},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 602, col: 26, offset: 18730},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 602, col: 32, offset: 18736},
								name: "ApplicationExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 602, col: 55, offset: 18759},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 602, col: 60, offset: 18764},
								expr: &seqExpr{
									pos: position{line: 602, col: 61, offset: 18765},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 602, col: 61, offset: 18765},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 602, col: 63, offset: 18767},
											val:        "!=",
											ignoreCase: false,
											want:       "\"!=\"",
										},
										&ruleRefExpr{
											pos:  position{line: 602, col: 68, offset: 18772},
											name: "_",
										},
										&labeledExpr{
											pos:   position{line: 602, col: 70, offset: 18774},
											label: "e",
											expr: &ruleRefExpr{
												pos:  position{line: 602, col: 72, offset: 18776},
												name: "ApplicationExpression",
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "ApplicationExpression",
			pos:  position{line: 605, col: 1, offset: 18850},
			expr: &actionExpr{
				pos: position{line: 605, col: 25, offset: 18876},
				run: (*parser).callonApplicationExpression1,
				expr: &seqExpr{
					pos: position{line: 605, col: 25, offset: 18876},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 605, col: 25, offset: 18876},
							label: "f",
							expr: &ruleRefExpr{
								pos:  position{line: 605, col: 27, offset: 18878},
								name: "FirstApplicationExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 605, col: 55, offset: 18906},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 605, col: 60, offset: 18911},
								expr: &seqExpr{
									pos: position{line: 605, col: 61, offset: 18912},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 605, col: 61, offset: 18912},
											name: "_1",
										},
										&ruleRefExpr{
											pos:  position{line: 605, col: 64, offset: 18915},
											name: "ImportExpression",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "FirstApplicationExpression",
			pos:  position{line: 614, col: 1, offset: 19158},
			expr: &choiceExpr{
				pos: position{line: 615, col: 8, offset: 19196},
				alternatives: []interface{}{
					&actionExpr{
						pos: position{line: 615, col: 8, offset: 19196},
						run: (*parser).callonFirstApplicationExpression2,
						expr: &seqExpr{
							pos: position{line: 615, col: 8, offset: 19196},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 238, col: 9, offset: 6039},
									val:        "merge",
									ignoreCase: false,
									want:       "\"merge\"",
								},
								&ruleRefExpr{
									pos:  position{line: 615, col: 14, offset: 19202},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 615, col: 17, offset: 19205},
									label: "h",
									expr: &ruleRefExpr{
										pos:  position{line: 615, col: 19, offset: 19207},
										name: "ImportExpression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 615, col: 36, offset: 19224},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 615, col: 39, offset: 19227},
									label: "u",
									expr: &ruleRefExpr{
										pos:  position{line: 615, col: 41, offset: 19229},
										name: "ImportExpression",
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 618, col: 8, offset: 19332},
						run: (*parser).callonFirstApplicationExpression11,
						expr: &seqExpr{
							pos: position{line: 618, col: 8, offset: 19332},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 242, col: 8, offset: 6163},
									val:        "Some",
									ignoreCase: false,
									want:       "\"Some\"",
								},
								&ruleRefExpr{
									pos:  position{line: 618, col: 13, offset: 19337},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 618, col: 16, offset: 19340},
									label: "e",
									expr: &ruleRefExpr{
										pos:  position{line: 618, col: 18, offset: 19342},
										name: "ImportExpression",
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 619, col: 8, offset: 19397},
						run: (*parser).callonFirstApplicationExpression17,
						expr: &seqExpr{
							pos: position{line: 619, col: 8, offset: 19397},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 243, col: 9, offset: 6180},
									val:        "toMap",
									ignoreCase: false,
									want:       "\"toMap\"",
								},
								&ruleRefExpr{
									pos:  position{line: 619, col: 14, offset: 19403},
									name: "_1",
								},
								&labeledExpr{
									pos:   position{line: 619, col: 17, offset: 19406},
									label: "e",
									expr: &ruleRefExpr{
										pos:  position{line: 619, col: 19, offset: 19408},
										name: "ImportExpression",
									},
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 620, col: 8, offset: 19472},
						name: "ImportExpression",
					},
				},
			},
		},
		{
			name: "ImportExpression",
			pos:  position{line: 622, col: 1, offset: 19490},
			expr: &choiceExpr{
				pos: position{line: 622, col: 20, offset: 19511},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 622, col: 20, offset: 19511},
						name: "Import",
					},
					&ruleRefExpr{
						pos:  position{line: 622, col: 29, offset: 19520},
						name: "CompletionExpression",
					},
				},
			},
		},
		{
			name: "CompletionExpression",
			pos:  position{line: 624, col: 1, offset: 19542},
			expr: &actionExpr{
				pos: position{line: 624, col: 24, offset: 19567},
				run: (*parser).callonCompletionExpression1,
				expr: &seqExpr{
					pos: position{line: 624, col: 24, offset: 19567},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 624, col: 24, offset: 19567},
							label: "a",
							expr: &ruleRefExpr{
								pos:  position{line: 624, col: 26, offset: 19569},
								name: "SelectorExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 624, col: 45, offset: 19588},
							label: "b",
							expr: &zeroOrOneExpr{
								pos: position{line: 624, col: 47, offset: 19590},
								expr: &seqExpr{
									pos: position{line: 624, col: 48, offset: 19591},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 624, col: 48, offset: 19591},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 304, col: 12, offset: 8106},
											val:        "::",
											ignoreCase: false,
											want:       "\"::\"",
										},
										&ruleRefExpr{
											pos:  position{line: 624, col: 59, offset: 19602},
											name: "_",
										},
										&ruleRefExpr{
											pos:  position{line: 624, col: 61, offset: 19604},
											name: "SelectorExpression",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "SelectorExpression",
			pos:  position{line: 631, col: 1, offset: 19755},
			expr: &actionExpr{
				pos: position{line: 631, col: 22, offset: 19778},
				run: (*parser).callonSelectorExpression1,
				expr: &seqExpr{
					pos: position{line: 631, col: 22, offset: 19778},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 631, col: 22, offset: 19778},
							label: "e",
							expr: &ruleRefExpr{
								pos:  position{line: 631, col: 24, offset: 19780},
								name: "PrimitiveExpression",
							},
						},
						&labeledExpr{
							pos:   position{line: 631, col: 44, offset: 19800},
							label: "ls",
							expr: &zeroOrMoreExpr{
								pos: position{line: 631, col: 47, offset: 19803},
								expr: &seqExpr{
									pos: position{line: 631, col: 48, offset: 19804},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 631, col: 48, offset: 19804},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 631, col: 50, offset: 19806},
											val:        ".",
											ignoreCase: false,
											want:       "\".\"",
										},
										&ruleRefExpr{
											pos:  position{line: 631, col: 54, offset: 19810},
											name: "_",
										},
										&ruleRefExpr{
											pos:  position{line: 631, col: 56, offset: 19812},
											name: "Selector",
										},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Selector",
			pos:  position{line: 650, col: 1, offset: 20365},
			expr: &choiceExpr{
				pos: position{line: 650, col: 12, offset: 20378},
				alternatives: []interface{}{
					&actionExpr{
						pos: position{line: 131, col: 9, offset: 3119},
						run: (*parser).callonSelector2,
						expr: &seqExpr{
							pos: position{line: 131, col: 9, offset: 3119},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 131, col: 9, offset: 3119},
									val:        "`",
									ignoreCase: false,
									want:       "\"`\"",
								},
								&labeledExpr{
									pos:   position{line: 131, col: 13, offset: 3123},
									label: "label",
									expr: &actionExpr{
										pos: position{line: 129, col: 15, offset: 3060},
										run: (*parser).callonSelector6,
										expr: &zeroOrMoreExpr{
											pos: position{line: 129, col: 15, offset: 3060},
											expr: &charClassMatcher{
												pos:        position{line: 128, col: 19, offset: 3023},
												val:        "[ -_a-~]",
												ranges:     []rune{' ', '_', 'a', '~'},
												ignoreCase: false,
												inverted:   false,
											},
										},
									},
								},
								&litMatcher{
									pos:        position{line: 131, col: 31, offset: 3141},
									val:        "`",
									ignoreCase: false,
									want:       "\"`\"",
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 132, col: 9, offset: 3175},
						run: (*parser).callonSelector10,
						expr: &labeledExpr{
							pos:   position{line: 132, col: 9, offset: 3175},
							label: "label",
							expr: &choiceExpr{
								pos: position{line: 122, col: 15, offset: 2816},
								alternatives: []interface{}{
									&actionExpr{
										pos: position{line: 122, col: 15, offset: 2816},
										run: (*parser).callonSelector13,
										expr: &seqExpr{
											pos: position{line: 122, col: 15, offset: 2816},
											exprs: []interface{}{
												&choiceExpr{
													pos: position{line: 249, col: 5, offset: 6269},
													alternatives: []interface{}{
														&litMatcher{
															pos:        position{line: 231, col: 6, offset: 5936},
															val:        "if",
															ignoreCase: false,
															want:       "\"if\"",
														},
														&litMatcher{
															pos:        position{line: 232, col: 8, offset: 5950},
															val:        "then",
															ignoreCase: false,
															want:       "\"then\"",
														},
														&litMatcher{
															pos:        position{line: 233, col: 8, offset: 5966},
															val:        "else",
															ignoreCase: false,
															want:       "\"else\"",
														},
														&litMatcher{
															pos:        position{line: 234, col: 7, offset: 5981},
															val:        "let",
															ignoreCase: false,
															want:       "\"let\"",
														},
														&litMatcher{
															pos:        position{line: 235, col: 6, offset: 5994},
															val:        "in",
															ignoreCase: false,
															want:       "\"in\"",
														},
														&litMatcher{
															pos:        position{line: 237, col: 9, offset: 6021},
															val:        "using",
															ignoreCase: false,
															want:       "\"using\"",
														},
														&actionExpr{
															pos: position{line: 239, col: 11, offset: 6059},
															run: (*parser).callonSelector22,
															expr: &seqExpr{
																pos: position{line: 239, col: 11, offset: 6059},
																exprs: []interface{}{
																	&litMatcher{
																		pos:        position{line: 239, col: 11, offset: 6059},
																		val:        "missing",
																		ignoreCase: false,
																		want:       "\"missing\"",
																	},
																	&notExpr{
																		pos: position{line: 239, col: 21, offset: 6069},
																		expr: &charClassMatcher{
																			pos:        position{line: 121, col: 23, offset: 2785},
																			val:        "[_/-A-Za-z0-9]",
																			chars:      []rune{'_', '/', '-'},
																			ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																			ignoreCase: false,
																			inverted:   false,
																		},
																	},
																},
															},
														},
														&litMatcher{
															pos:        position{line: 244, col: 10, offset: 6199},
															val:        "assert",
															ignoreCase: false,
															want:       "\"assert\"",
														},
														&litMatcher{
															pos:        position{line: 236, col: 6, offset: 6006},
															val:        "as",
															ignoreCase: false,
															want:       "\"as\"",
														},
														&litMatcher{
															pos:        position{line: 240, col: 12, offset: 6129},
															val:        "Infinity",
															ignoreCase: false,
															want:       "\"Infinity\"",
														},
														&litMatcher{
															pos:        position{line: 241, col: 7, offset: 6148},
															val:        "NaN",
															ignoreCase: false,
															want:       "\"NaN\"",
														},
														&litMatcher{
															pos:        position{line: 238, col: 9, offset: 6039},
															val:        "merge",
															ignoreCase: false,
															want:       "\"merge\"",
														},
														&litMatcher{
															pos:        position{line: 242, col: 8, offset: 6163},
															val:        "Some",
															ignoreCase: false,
															want:       "\"Some\"",
														},
														&litMatcher{
															pos:        position{line: 243, col: 9, offset: 6180},
															val:        "toMap",
															ignoreCase: false,
															want:       "\"toMap\"",
														},
														&litMatcher{
															pos:        position{line: 245, col: 10, offset: 6219},
															val:        "forall",
															ignoreCase: false,
															want:       "\"forall\"",
														},
														&litMatcher{
															pos:        position{line: 245, col: 21, offset: 6230},
															val:        "∀",
															ignoreCase: false,
															want:       "\"∀\"",
														},
														&litMatcher{
															pos:        position{line: 246, col: 8, offset: 6245},
															val:        "with",
															ignoreCase: false,
															want:       "\"with\"",
														},
													},
												},
												&oneOrMoreExpr{
													pos: position{line: 122, col: 23, offset: 2824},
													expr: &charClassMatcher{
														pos:        position{line: 121, col: 23, offset: 2785},
														val:        "[_/-A-Za-z0-9]",
														chars:      []rune{'_', '/', '-'},
														ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
														ignoreCase: false,
														inverted:   false,
													},
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 123, col: 13, offset: 2888},
										run: (*parser).callonSelector39,
										expr: &seqExpr{
											pos: position{line: 123, col: 13, offset: 2888},
											exprs: []interface{}{
												&notExpr{
													pos: position{line: 123, col: 13, offset: 2888},
													expr: &choiceExpr{
														pos: position{line: 249, col: 5, offset: 6269},
														alternatives: []interface{}{
															&litMatcher{
																pos:        position{line: 231, col: 6, offset: 5936},
																val:        "if",
																ignoreCase: false,
																want:       "\"if\"",
															},
															&litMatcher{
																pos:        position{line: 232, col: 8, offset: 5950},
																val:        "then",
																ignoreCase: false,
																want:       "\"then\"",
															},
															&litMatcher{
																pos:        position{line: 233, col: 8, offset: 5966},
																val:        "else",
																ignoreCase: false,
																want:       "\"else\"",
															},
															&litMatcher{
																pos:        position{line: 234, col: 7, offset: 5981},
																val:        "let",
																ignoreCase: false,
																want:       "\"let\"",
															},
															&litMatcher{
																pos:        position{line: 235, col: 6, offset: 5994},
																val:        "in",
																ignoreCase: false,
																want:       "\"in\"",
															},
															&litMatcher{
																pos:        position{line: 237, col: 9, offset: 6021},
																val:        "using",
																ignoreCase: false,
																want:       "\"using\"",
															},
															&actionExpr{
																pos: position{line: 239, col: 11, offset: 6059},
																run: (*parser).callonSelector49,
																expr: &seqExpr{
																	pos: position{line: 239, col: 11, offset: 6059},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 239, col: 11, offset: 6059},
																			val:        "missing",
																			ignoreCase: false,
																			want:       "\"missing\"",
																		},
																		&notExpr{
																			pos: position{line: 239, col: 21, offset: 6069},
																			expr: &charClassMatcher{
																				pos:        position{line: 121, col: 23, offset: 2785},
																				val:        "[_/-A-Za-z0-9]",
																				chars:      []rune{'_', '/', '-'},
																				ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																		},
																	},
																},
															},
															&litMatcher{
																pos:        position{line: 244, col: 10, offset: 6199},
																val:        "assert",
																ignoreCase: false,
																want:       "\"assert\"",
															},
															&litMatcher{
																pos:        position{line: 236, col: 6, offset: 6006},
																val:        "as",
																ignoreCase: false,
																want:       "\"as\"",
															},
															&litMatcher{
																pos:        position{line: 240, col: 12, offset: 6129},
																val:        "Infinity",
																ignoreCase: false,
																want:       "\"Infinity\"",
															},
															&litMatcher{
																pos:        position{line: 241, col: 7, offset: 6148},
																val:        "NaN",
																ignoreCase: false,
																want:       "\"NaN\"",
															},
															&litMatcher{
																pos:        position{line: 238, col: 9, offset: 6039},
																val:        "merge",
																ignoreCase: false,
																want:       "\"merge\"",
															},
															&litMatcher{
																pos:        position{line: 242, col: 8, offset: 6163},
																val:        "Some",
																ignoreCase: false,
																want:       "\"Some\"",
															},
															&litMatcher{
																pos:        position{line: 243, col: 9, offset: 6180},
																val:        "toMap",
																ignoreCase: false,
																want:       "\"toMap\"",
															},
															&litMatcher{
																pos:        position{line: 245, col: 10, offset: 6219},
																val:        "forall",
																ignoreCase: false,
																want:       "\"forall\"",
															},
															&litMatcher{
																pos:        position{line: 245, col: 21, offset: 6230},
																val:        "∀",
																ignoreCase: false,
																want:       "\"∀\"",
															},
															&litMatcher{
																pos:        position{line: 246, col: 8, offset: 6245},
																val:        "with",
																ignoreCase: false,
																want:       "\"with\"",
															},
														},
													},
												},
												&charClassMatcher{
													pos:        position{line: 120, col: 24, offset: 2751},
													val:        "[_A-Za-z]",
													chars:      []rune{'_'},
													ranges:     []rune{'A', 'Z', 'a', 'z'},
													ignoreCase: false,
													inverted:   false,
												},
												&zeroOrMoreExpr{
													pos: position{line: 123, col: 43, offset: 2918},
													expr: &charClassMatcher{
														pos:        position{line: 121, col: 23, offset: 2785},
														val:        "[_/-A-Za-z0-9]",
														chars:      []rune{'_', '/', '-'},
														ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
														ignoreCase: false,
														inverted:   false,
													},
												},
											},
										},
									},
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 650, col: 23, offset: 20389},
						name: "Labels",
					},
					&ruleRefExpr{
						pos:  position{line: 650, col: 32, offset: 20398},
						name: "TypeSelector",
					},
				},
			},
		},
		{
			name: "Labels",
			pos:  position{line: 652, col: 1, offset: 20412},
			expr: &actionExpr{
				pos: position{line: 653, col: 5, offset: 20427},
				run: (*parser).callonLabels1,
				expr: &seqExpr{
					pos: position{line: 653, col: 5, offset: 20427},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 653, col: 5, offset: 20427},
							val:        "{",
							ignoreCase: false,
							want:       "\"{\"",
						},
						&ruleRefExpr{
							pos:  position{line: 653, col: 9, offset: 20431},
							name: "_",
						},
						&zeroOrOneExpr{
							pos: position{line: 653, col: 11, offset: 20433},
							expr: &seqExpr{
								pos: position{line: 653, col: 13, offset: 20435},
								exprs: []interface{}{
									&litMatcher{
										pos:        position{line: 653, col: 13, offset: 20435},
										val:        ",",
										ignoreCase: false,
										want:       "\",\"",
									},
									&ruleRefExpr{
										pos:  position{line: 653, col: 17, offset: 20439},
										name: "_",
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 653, col: 22, offset: 20444},
							label: "optclauses",
							expr: &zeroOrOneExpr{
								pos: position{line: 653, col: 33, offset: 20455},
								expr: &seqExpr{
									pos: position{line: 653, col: 35, offset: 20457},
									exprs: []interface{}{
										&choiceExpr{
											pos: position{line: 139, col: 18, offset: 3403},
											alternatives: []interface{}{
												&actionExpr{
													pos: position{line: 131, col: 9, offset: 3119},
													run: (*parser).callonLabels13,
													expr: &seqExpr{
														pos: position{line: 131, col: 9, offset: 3119},
														exprs: []interface{}{
															&litMatcher{
																pos:        position{line: 131, col: 9, offset: 3119},
																val:        "`",
																ignoreCase: false,
																want:       "\"`\"",
															},
															&labeledExpr{
																pos:   position{line: 131, col: 13, offset: 3123},
																label: "label",
																expr: &actionExpr{
																	pos: position{line: 129, col: 15, offset: 3060},
																	run: (*parser).callonLabels17,
																	expr: &zeroOrMoreExpr{
																		pos: position{line: 129, col: 15, offset: 3060},
																		expr: &charClassMatcher{
																			pos:        position{line: 128, col: 19, offset: 3023},
																			val:        "[ -_a-~]",
																			ranges:     []rune{' ', '_', 'a', '~'},
																			ignoreCase: false,
																			inverted:   false,
																		},
																	},
																},
															},
															&litMatcher{
																pos:        position{line: 131, col: 31, offset: 3141},
																val:        "`",
																ignoreCase: false,
																want:       "\"`\"",
															},
														},
													},
												},
												&actionExpr{
													pos: position{line: 132, col: 9, offset: 3175},
													run: (*parser).callonLabels21,
													expr: &labeledExpr{
														pos:   position{line: 132, col: 9, offset: 3175},
														label: "label",
														expr: &choiceExpr{
															pos: position{line: 122, col: 15, offset: 2816},
															alternatives: []interface{}{
																&actionExpr{
																	pos: position{line: 122, col: 15, offset: 2816},
																	run: (*parser).callonLabels24,
																	expr: &seqExpr{
																		pos: position{line: 122, col: 15, offset: 2816},
																		exprs: []interface{}{
																			&choiceExpr{
																				pos: position{line: 249, col: 5, offset: 6269},
																				alternatives: []interface{}{
																					&litMatcher{
																						pos:        position{line: 231, col: 6, offset: 5936},
																						val:        "if",
																						ignoreCase: false,
																						want:       "\"if\"",
																					},
																					&litMatcher{
																						pos:        position{line: 232, col: 8, offset: 5950},
																						val:        "then",
																						ignoreCase: false,
																						want:       "\"then\"",
																					},
																					&litMatcher{
																						pos:        position{line: 233, col: 8, offset: 5966},
																						val:        "else",
																						ignoreCase: false,
																						want:       "\"else\"",
																					},
																					&litMatcher{
																						pos:        position{line: 234, col: 7, offset: 5981},
																						val:        "let",
																						ignoreCase: false,
																						want:       "\"let\"",
																					},
																					&litMatcher{
																						pos:        position{line: 235, col: 6, offset: 5994},
																						val:        "in",
																						ignoreCase: false,
																						want:       "\"in\"",
																					},
																					&litMatcher{
																						pos:        position{line: 237, col: 9, offset: 6021},
																						val:        "using",
																						ignoreCase: false,
																						want:       "\"using\"",
																					},
																					&actionExpr{
																						pos: position{line: 239, col: 11, offset: 6059},
																						run: (*parser).callonLabels33,
																						expr: &seqExpr{
																							pos: position{line: 239, col: 11, offset: 6059},
																							exprs: []interface{}{
																								&litMatcher{
																									pos:        position{line: 239, col: 11, offset: 6059},
																									val:        "missing",
																									ignoreCase: false,
																									want:       "\"missing\"",
																								},
																								&notExpr{
																									pos: position{line: 239, col: 21, offset: 6069},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																					&litMatcher{
																						pos:        position{line: 244, col: 10, offset: 6199},
																						val:        "assert",
																						ignoreCase: false,
																						want:       "\"assert\"",
																					},
																					&litMatcher{
																						pos:        position{line: 236, col: 6, offset: 6006},
																						val:        "as",
																						ignoreCase: false,
																						want:       "\"as\"",
																					},
																					&litMatcher{
																						pos:        position{line: 240, col: 12, offset: 6129},
																						val:        "Infinity",
																						ignoreCase: false,
																						want:       "\"Infinity\"",
																					},
																					&litMatcher{
																						pos:        position{line: 241, col: 7, offset: 6148},
																						val:        "NaN",
																						ignoreCase: false,
																						want:       "\"NaN\"",
																					},
																					&litMatcher{
																						pos:        position{line: 238, col: 9, offset: 6039},
																						val:        "merge",
																						ignoreCase: false,
																						want:       "\"merge\"",
																					},
																					&litMatcher{
																						pos:        position{line: 242, col: 8, offset: 6163},
																						val:        "Some",
																						ignoreCase: false,
																						want:       "\"Some\"",
																					},
																					&litMatcher{
																						pos:        position{line: 243, col: 9, offset: 6180},
																						val:        "toMap",
																						ignoreCase: false,
																						want:       "\"toMap\"",
																					},
																					&litMatcher{
																						pos:        position{line: 245, col: 10, offset: 6219},
																						val:        "forall",
																						ignoreCase: false,
																						want:       "\"forall\"",
																					},
																					&litMatcher{
																						pos:        position{line: 245, col: 21, offset: 6230},
																						val:        "∀",
																						ignoreCase: false,
																						want:       "\"∀\"",
																					},
																					&litMatcher{
																						pos:        position{line: 246, col: 8, offset: 6245},
																						val:        "with",
																						ignoreCase: false,
																						want:       "\"with\"",
																					},
																				},
																			},
																			&oneOrMoreExpr{
																				pos: position{line: 122, col: 23, offset: 2824},
																				expr: &charClassMatcher{
																					pos:        position{line: 121, col: 23, offset: 2785},
																					val:        "[_/-A-Za-z0-9]",
																					chars:      []rune{'_', '/', '-'},
																					ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
																&actionExpr{
																	pos: position{line: 123, col: 13, offset: 2888},
																	run: (*parser).callonLabels50,
																	expr: &seqExpr{
																		pos: position{line: 123, col: 13, offset: 2888},
																		exprs: []interface{}{
																			&notExpr{
																				pos: position{line: 123, col: 13, offset: 2888},
																				expr: &choiceExpr{
																					pos: position{line: 249, col: 5, offset: 6269},
																					alternatives: []interface{}{
																						&litMatcher{
																							pos:        position{line: 231, col: 6, offset: 5936},
																							val:        "if",
																							ignoreCase: false,
																							want:       "\"if\"",
																						},
																						&litMatcher{
																							pos:        position{line: 232, col: 8, offset: 5950},
																							val:        "then",
																							ignoreCase: false,
																							want:       "\"then\"",
																						},
																						&litMatcher{
																							pos:        position{line: 233, col: 8, offset: 5966},
																							val:        "else",
																							ignoreCase: false,
																							want:       "\"else\"",
																						},
																						&litMatcher{
																							pos:        position{line: 234, col: 7, offset: 5981},
																							val:        "let",
																							ignoreCase: false,
																							want:       "\"let\"",
																						},
																						&litMatcher{
																							pos:        position{line: 235, col: 6, offset: 5994},
																							val:        "in",
																							ignoreCase: false,
																							want:       "\"in\"",
																						},
																						&litMatcher{
																							pos:        position{line: 237, col: 9, offset: 6021},
																							val:        "using",
																							ignoreCase: false,
																							want:       "\"using\"",
																						},
																						&actionExpr{
																							pos: position{line: 239, col: 11, offset: 6059},
																							run: (*parser).callonLabels60,
																							expr: &seqExpr{
																								pos: position{line: 239, col: 11, offset: 6059},
																								exprs: []interface{}{
																									&litMatcher{
																										pos:        position{line: 239, col: 11, offset: 6059},
																										val:        "missing",
																										ignoreCase: false,
																										want:       "\"missing\"",
																									},
																									&notExpr{
																										pos: position{line: 239, col: 21, offset: 6069},
																										expr: &charClassMatcher{
																											pos:        position{line: 121, col: 23, offset: 2785},
																											val:        "[_/-A-Za-z0-9]",
																											chars:      []rune{'_', '/', '-'},
																											ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																											ignoreCase: false,
																											inverted:   false,
																										},
																									},
																								},
																							},
																						},
																						&litMatcher{
																							pos:        position{line: 244, col: 10, offset: 6199},
																							val:        "assert",
																							ignoreCase: false,
																							want:       "\"assert\"",
																						},
																						&litMatcher{
																							pos:        position{line: 236, col: 6, offset: 6006},
																							val:        "as",
																							ignoreCase: false,
																							want:       "\"as\"",
																						},
																						&litMatcher{
																							pos:        position{line: 240, col: 12, offset: 6129},
																							val:        "Infinity",
																							ignoreCase: false,
																							want:       "\"Infinity\"",
																						},
																						&litMatcher{
																							pos:        position{line: 241, col: 7, offset: 6148},
																							val:        "NaN",
																							ignoreCase: false,
																							want:       "\"NaN\"",
																						},
																						&litMatcher{
																							pos:        position{line: 238, col: 9, offset: 6039},
																							val:        "merge",
																							ignoreCase: false,
																							want:       "\"merge\"",
																						},
																						&litMatcher{
																							pos:        position{line: 242, col: 8, offset: 6163},
																							val:        "Some",
																							ignoreCase: false,
																							want:       "\"Some\"",
																						},
																						&litMatcher{
																							pos:        position{line: 243, col: 9, offset: 6180},
																							val:        "toMap",
																							ignoreCase: false,
																							want:       "\"toMap\"",
																						},
																						&litMatcher{
																							pos:        position{line: 245, col: 10, offset: 6219},
																							val:        "forall",
																							ignoreCase: false,
																							want:       "\"forall\"",
																						},
																						&litMatcher{
																							pos:        position{line: 245, col: 21, offset: 6230},
																							val:        "∀",
																							ignoreCase: false,
																							want:       "\"∀\"",
																						},
																						&litMatcher{
																							pos:        position{line: 246, col: 8, offset: 6245},
																							val:        "with",
																							ignoreCase: false,
																							want:       "\"with\"",
																						},
																					},
																				},
																			},
																			&charClassMatcher{
																				pos:        position{line: 120, col: 24, offset: 2751},
																				val:        "[_A-Za-z]",
																				chars:      []rune{'_'},
																				ranges:     []rune{'A', 'Z', 'a', 'z'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&zeroOrMoreExpr{
																				pos: position{line: 123, col: 43, offset: 2918},
																				expr: &charClassMatcher{
																					pos:        position{line: 121, col: 23, offset: 2785},
																					val:        "[_/-A-Za-z0-9]",
																					chars:      []rune{'_', '/', '-'},
																					ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
												&actionExpr{
													pos: position{line: 139, col: 29, offset: 3414},
													run: (*parser).callonLabels78,
													expr: &litMatcher{
														pos:        position{line: 242, col: 8, offset: 6163},
														val:        "Some",
														ignoreCase: false,
														want:       "\"Some\"",
													},
												},
											},
										},
										&ruleRefExpr{
											pos:  position{line: 653, col: 50, offset: 20472},
											name: "_",
										},
										&zeroOrMoreExpr{
											pos: position{line: 653, col: 52, offset: 20474},
											expr: &seqExpr{
												pos: position{line: 653, col: 53, offset: 20475},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 653, col: 53, offset: 20475},
														val:        ",",
														ignoreCase: false,
														want:       "\",\"",
													},
													&ruleRefExpr{
														pos:  position{line: 653, col: 57, offset: 20479},
														name: "_",
													},
													&choiceExpr{
														pos: position{line: 139, col: 18, offset: 3403},
														alternatives: []interface{}{
															&actionExpr{
																pos: position{line: 131, col: 9, offset: 3119},
																run: (*parser).callonLabels86,
																expr: &seqExpr{
																	pos: position{line: 131, col: 9, offset: 3119},
																	exprs: []interface{}{
																		&litMatcher{
																			pos:        position{line: 131, col: 9, offset: 3119},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																		&labeledExpr{
																			pos:   position{line: 131, col: 13, offset: 3123},
																			label: "label",
																			expr: &actionExpr{
																				pos: position{line: 129, col: 15, offset: 3060},
																				run: (*parser).callonLabels90,
																				expr: &zeroOrMoreExpr{
																					pos: position{line: 129, col: 15, offset: 3060},
																					expr: &charClassMatcher{
																						pos:        position{line: 128, col: 19, offset: 3023},
																						val:        "[ -_a-~]",
																						ranges:     []rune{' ', '_', 'a', '~'},
																						ignoreCase: false,
																						inverted:   false,
																					},
																				},
																			},
																		},
																		&litMatcher{
																			pos:        position{line: 131, col: 31, offset: 3141},
																			val:        "`",
																			ignoreCase: false,
																			want:       "\"`\"",
																		},
																	},
																},
															},
															&actionExpr{
																pos: position{line: 132, col: 9, offset: 3175},
																run: (*parser).callonLabels94,
																expr: &labeledExpr{
																	pos:   position{line: 132, col: 9, offset: 3175},
																	label: "label",
																	expr: &choiceExpr{
																		pos: position{line: 122, col: 15, offset: 2816},
																		alternatives: []interface{}{
																			&actionExpr{
																				pos: position{line: 122, col: 15, offset: 2816},
																				run: (*parser).callonLabels97,
																				expr: &seqExpr{
																					pos: position{line: 122, col: 15, offset: 2816},
																					exprs: []interface{}{
																						&choiceExpr{
																							pos: position{line: 249, col: 5, offset: 6269},
																							alternatives: []interface{}{
																								&litMatcher{
																									pos:        position{line: 231, col: 6, offset: 5936},
																									val:        "if",
																									ignoreCase: false,
																									want:       "\"if\"",
																								},
																								&litMatcher{
																									pos:        position{line: 232, col: 8, offset: 5950},
																									val:        "then",
																									ignoreCase: false,
																									want:       "\"then\"",
																								},
																								&litMatcher{
																									pos:        position{line: 233, col: 8, offset: 5966},
																									val:        "else",
																									ignoreCase: false,
																									want:       "\"else\"",
																								},
																								&litMatcher{
																									pos:        position{line: 234, col: 7, offset: 5981},
																									val:        "let",
																									ignoreCase: false,
																									want:       "\"let\"",
																								},
																								&litMatcher{
																									pos:        position{line: 235, col: 6, offset: 5994},
																									val:        "in",
																									ignoreCase: false,
																									want:       "\"in\"",
																								},
																								&litMatcher{
																									pos:        position{line: 237, col: 9, offset: 6021},
																									val:        "using",
																									ignoreCase: false,
																									want:       "\"using\"",
																								},
																								&actionExpr{
																									pos: position{line: 239, col: 11, offset: 6059},
																									run: (*parser).callonLabels106,
																									expr: &seqExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										exprs: []interface{}{
																											&litMatcher{
																												pos:        position{line: 239, col: 11, offset: 6059},
																												val:        "missing",
																												ignoreCase: false,
																												want:       "\"missing\"",
																											},
																											&notExpr{
																												pos: position{line: 239, col: 21, offset: 6069},
																												expr: &charClassMatcher{
																													pos:        position{line: 121, col: 23, offset: 2785},
																													val:        "[_/-A-Za-z0-9]",
																													chars:      []rune{'_', '/', '-'},
																													ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																													ignoreCase: false,
																													inverted:   false,
																												},
																											},
																										},
																									},
																								},
																								&litMatcher{
																									pos:        position{line: 244, col: 10, offset: 6199},
																									val:        "assert",
																									ignoreCase: false,
																									want:       "\"assert\"",
																								},
																								&litMatcher{
																									pos:        position{line: 236, col: 6, offset: 6006},
																									val:        "as",
																									ignoreCase: false,
																									want:       "\"as\"",
																								},
																								&litMatcher{
																									pos:        position{line: 240, col: 12, offset: 6129},
																									val:        "Infinity",
																									ignoreCase: false,
																									want:       "\"Infinity\"",
																								},
																								&litMatcher{
																									pos:        position{line: 241, col: 7, offset: 6148},
																									val:        "NaN",
																									ignoreCase: false,
																									want:       "\"NaN\"",
																								},
																								&litMatcher{
																									pos:        position{line: 238, col: 9, offset: 6039},
																									val:        "merge",
																									ignoreCase: false,
																									want:       "\"merge\"",
																								},
																								&litMatcher{
																									pos:        position{line: 242, col: 8, offset: 6163},
																									val:        "Some",
																									ignoreCase: false,
																									want:       "\"Some\"",
																								},
																								&litMatcher{
																									pos:        position{line: 243, col: 9, offset: 6180},
																									val:        "toMap",
																									ignoreCase: false,
																									want:       "\"toMap\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 10, offset: 6219},
																									val:        "forall",
																									ignoreCase: false,
																									want:       "\"forall\"",
																								},
																								&litMatcher{
																									pos:        position{line: 245, col: 21, offset: 6230},
																									val:        "∀",
																									ignoreCase: false,
																									want:       "\"∀\"",
																								},
																								&litMatcher{
																									pos:        position{line: 246, col: 8, offset: 6245},
																									val:        "with",
																									ignoreCase: false,
																									want:       "\"with\"",
																								},
																							},
																						},
																						&oneOrMoreExpr{
																							pos: position{line: 122, col: 23, offset: 2824},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																			&actionExpr{
																				pos: position{line: 123, col: 13, offset: 2888},
																				run: (*parser).callonLabels123,
																				expr: &seqExpr{
																					pos: position{line: 123, col: 13, offset: 2888},
																					exprs: []interface{}{
																						&notExpr{
																							pos: position{line: 123, col: 13, offset: 2888},
																							expr: &choiceExpr{
																								pos: position{line: 249, col: 5, offset: 6269},
																								alternatives: []interface{}{
																									&litMatcher{
																										pos:        position{line: 231, col: 6, offset: 5936},
																										val:        "if",
																										ignoreCase: false,
																										want:       "\"if\"",
																									},
																									&litMatcher{
																										pos:        position{line: 232, col: 8, offset: 5950},
																										val:        "then",
																										ignoreCase: false,
																										want:       "\"then\"",
																									},
																									&litMatcher{
																										pos:        position{line: 233, col: 8, offset: 5966},
																										val:        "else",
																										ignoreCase: false,
																										want:       "\"else\"",
																									},
																									&litMatcher{
																										pos:        position{line: 234, col: 7, offset: 5981},
																										val:        "let",
																										ignoreCase: false,
																										want:       "\"let\"",
																									},
																									&litMatcher{
																										pos:        position{line: 235, col: 6, offset: 5994},
																										val:        "in",
																										ignoreCase: false,
																										want:       "\"in\"",
																									},
																									&litMatcher{
																										pos:        position{line: 237, col: 9, offset: 6021},
																										val:        "using",
																										ignoreCase: false,
																										want:       "\"using\"",
																									},
																									&actionExpr{
																										pos: position{line: 239, col: 11, offset: 6059},
																										run: (*parser).callonLabels133,
																										expr: &seqExpr{
																											pos: position{line: 239, col: 11, offset: 6059},
																											exprs: []interface{}{
																												&litMatcher{
																													pos:        position{line: 239, col: 11, offset: 6059},
																													val:        "missing",
																													ignoreCase: false,
																													want:       "\"missing\"",
																												},
																												&notExpr{
																													pos: position{line: 239, col: 21, offset: 6069},
																													expr: &charClassMatcher{
																														pos:        position{line: 121, col: 23, offset: 2785},
																														val:        "[_/-A-Za-z0-9]",
																														chars:      []rune{'_', '/', '-'},
																														ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																														ignoreCase: false,
																														inverted:   false,
																													},
																												},
																											},
																										},
																									},
																									&litMatcher{
																										pos:        position{line: 244, col: 10, offset: 6199},
																										val:        "assert",
																										ignoreCase: false,
																										want:       "\"assert\"",
																									},
																									&litMatcher{
																										pos:        position{line: 236, col: 6, offset: 6006},
																										val:        "as",
																										ignoreCase: false,
																										want:       "\"as\"",
																									},
																									&litMatcher{
																										pos:        position{line: 240, col: 12, offset: 6129},
																										val:        "Infinity",
																										ignoreCase: false,
																										want:       "\"Infinity\"",
																									},
																									&litMatcher{
																										pos:        position{line: 241, col: 7, offset: 6148},
																										val:        "NaN",
																										ignoreCase: false,
																										want:       "\"NaN\"",
																									},
																									&litMatcher{
																										pos:        position{line: 238, col: 9, offset: 6039},
																										val:        "merge",
																										ignoreCase: false,
																										want:       "\"merge\"",
																									},
																									&litMatcher{
																										pos:        position{line: 242, col: 8, offset: 6163},
																										val:        "Some",
																										ignoreCase: false,
																										want:       "\"Some\"",
																									},
																									&litMatcher{
																										pos:        position{line: 243, col: 9, offset: 6180},
																										val:        "toMap",
																										ignoreCase: false,
																										want:       "\"toMap\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 10, offset: 6219},
																										val:        "forall",
																										ignoreCase: false,
																										want:       "\"forall\"",
																									},
																									&litMatcher{
																										pos:        position{line: 245, col: 21, offset: 6230},
																										val:        "∀",
																										ignoreCase: false,
																										want:       "\"∀\"",
																									},
																									&litMatcher{
																										pos:        position{line: 246, col: 8, offset: 6245},
																										val:        "with",
																										ignoreCase: false,
																										want:       "\"with\"",
																									},
																								},
																							},
																						},
																						&charClassMatcher{
																							pos:        position{line: 120, col: 24, offset: 2751},
																							val:        "[_A-Za-z]",
																							chars:      []rune{'_'},
																							ranges:     []rune{'A', 'Z', 'a', 'z'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																						&zeroOrMoreExpr{
																							pos: position{line: 123, col: 43, offset: 2918},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																		},
																	},
																},
															},
															&actionExpr{
																pos: position{line: 139, col: 29, offset: 3414},
																run: (*parser).callonLabels151,
																expr: &litMatcher{
																	pos:        position{line: 242, col: 8, offset: 6163},
																	val:        "Some",
																	ignoreCase: false,
																	want:       "\"Some\"",
																},
															},
														},
													},
													&ruleRefExpr{
														pos:  position{line: 653, col: 74, offset: 20496},
														name: "_",
													},
												},
											},
										},
										&zeroOrOneExpr{
											pos: position{line: 653, col: 79, offset: 20501},
											expr: &seqExpr{
												pos: position{line: 653, col: 80, offset: 20502},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 653, col: 80, offset: 20502},
														val:        ",",
														ignoreCase: false,
														want:       "\",\"",
													},
													&ruleRefExpr{
														pos:  position{line: 653, col: 84, offset: 20506},
														name: "_",
													},
												},
											},
										},
									},
								},
							},
						},
						&litMatcher{
							pos:        position{line: 653, col: 91, offset: 20513},
							val:        "}",
							ignoreCase: false,
							want:       "\"}\"",
						},
					},
				},
			},
		},
		{
			name: "TypeSelector",
			pos:  position{line: 663, col: 1, offset: 20809},
			expr: &actionExpr{
				pos: position{line: 663, col: 16, offset: 20826},
				run: (*parser).callonTypeSelector1,
				expr: &seqExpr{
					pos: position{line: 663, col: 16, offset: 20826},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 663, col: 16, offset: 20826},
							val:        "(",
							ignoreCase: false,
							want:       "\"(\"",
						},
						&ruleRefExpr{
							pos:  position{line: 663, col: 20, offset: 20830},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 663, col: 22, offset: 20832},
							label: "e",
							expr: &ruleRefExpr{
								pos:  position{line: 663, col: 24, offset: 20834},
								name: "Expression",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 663, col: 35, offset: 20845},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 663, col: 37, offset: 20847},
							val:        ")",
							ignoreCase: false,
							want:       "\")\"",
						},
					},
				},
			},
		},
		{
			name: "PrimitiveExpression",
			pos:  position{line: 665, col: 1, offset: 20870},
			expr: &choiceExpr{
				pos: position{line: 666, col: 7, offset: 20900},
				alternatives: []interface{}{
					&labeledExpr{
						pos:   position{line: 316, col: 17, offset: 8381},
						label: "d",
						expr: &actionExpr{
							pos: position{line: 308, col: 24, offset: 8169},
							run: (*parser).callonPrimitiveExpression3,
							expr: &seqExpr{
								pos: position{line: 308, col: 24, offset: 8169},
								exprs: []interface{}{
									&zeroOrOneExpr{
										pos: position{line: 308, col: 24, offset: 8169},
										expr: &charClassMatcher{
											pos:        position{line: 308, col: 24, offset: 8169},
											val:        "[+-]",
											chars:      []rune{'+', '-'},
											ignoreCase: false,
											inverted:   false,
										},
									},
									&oneOrMoreExpr{
										pos: position{line: 308, col: 30, offset: 8175},
										expr: &charClassMatcher{
											pos:        position{line: 116, col: 9, offset: 2692},
											val:        "[0-9]",
											ranges:     []rune{'0', '9'},
											ignoreCase: false,
											inverted:   false,
										},
									},
									&choiceExpr{
										pos: position{line: 308, col: 39, offset: 8184},
										alternatives: []interface{}{
											&seqExpr{
												pos: position{line: 308, col: 39, offset: 8184},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 308, col: 39, offset: 8184},
														val:        ".",
														ignoreCase: false,
														want:       "\".\"",
													},
													&oneOrMoreExpr{
														pos: position{line: 308, col: 43, offset: 8188},
														expr: &charClassMatcher{
															pos:        position{line: 116, col: 9, offset: 2692},
															val:        "[0-9]",
															ranges:     []rune{'0', '9'},
															ignoreCase: false,
															inverted:   false,
														},
													},
													&zeroOrOneExpr{
														pos: position{line: 308, col: 50, offset: 8195},
														expr: &seqExpr{
															pos: position{line: 306, col: 12, offset: 8125},
															exprs: []interface{}{
																&litMatcher{
																	pos:        position{line: 306, col: 12, offset: 8125},
																	val:        "e",
																	ignoreCase: true,
																	want:       "\"e\"i",
																},
																&zeroOrOneExpr{
																	pos: position{line: 306, col: 17, offset: 8130},
																	expr: &charClassMatcher{
																		pos:        position{line: 306, col: 17, offset: 8130},
																		val:        "[+-]",
																		chars:      []rune{'+', '-'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
																&oneOrMoreExpr{
																	pos: position{line: 306, col: 23, offset: 8136},
																	expr: &charClassMatcher{
																		pos:        position{line: 116, col: 9, offset: 2692},
																		val:        "[0-9]",
																		ranges:     []rune{'0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
												},
											},
											&seqExpr{
												pos: position{line: 306, col: 12, offset: 8125},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 306, col: 12, offset: 8125},
														val:        "e",
														ignoreCase: true,
														want:       "\"e\"i",
													},
													&zeroOrOneExpr{
														pos: position{line: 306, col: 17, offset: 8130},
														expr: &charClassMatcher{
															pos:        position{line: 306, col: 17, offset: 8130},
															val:        "[+-]",
															chars:      []rune{'+', '-'},
															ignoreCase: false,
															inverted:   false,
														},
													},
													&oneOrMoreExpr{
														pos: position{line: 306, col: 23, offset: 8136},
														expr: &charClassMatcher{
															pos:        position{line: 116, col: 9, offset: 2692},
															val:        "[0-9]",
															ranges:     []rune{'0', '9'},
															ignoreCase: false,
															inverted:   false,
														},
													},
												},
											},
										},
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 317, col: 5, offset: 8408},
						run: (*parser).callonPrimitiveExpression27,
						expr: &litMatcher{
							pos:        position{line: 317, col: 5, offset: 8408},
							val:        "-Infinity",
							ignoreCase: false,
							want:       "\"-Infinity\"",
						},
					},
					&actionExpr{
						pos: position{line: 318, col: 5, offset: 8465},
						run: (*parser).callonPrimitiveExpression29,
						expr: &litMatcher{
							pos:        position{line: 240, col: 12, offset: 6129},
							val:        "Infinity",
							ignoreCase: false,
							want:       "\"Infinity\"",
						},
					},
					&actionExpr{
						pos: position{line: 319, col: 5, offset: 8517},
						run: (*parser).callonPrimitiveExpression31,
						expr: &litMatcher{
							pos:        position{line: 241, col: 7, offset: 6148},
							val:        "NaN",
							ignoreCase: false,
							want:       "\"NaN\"",
						},
					},
					&actionExpr{
						pos: position{line: 323, col: 3, offset: 8618},
						run: (*parser).callonPrimitiveExpression33,
						expr: &choiceExpr{
							pos: position{line: 323, col: 4, offset: 8619},
							alternatives: []interface{}{
								&seqExpr{
									pos: position{line: 323, col: 4, offset: 8619},
									exprs: []interface{}{
										&litMatcher{
											pos:        position{line: 323, col: 4, offset: 8619},
											val:        "0x",
											ignoreCase: false,
											want:       "\"0x\"",
										},
										&oneOrMoreExpr{
											pos: position{line: 323, col: 9, offset: 8624},
											expr: &choiceExpr{
												pos: position{line: 118, col: 10, offset: 2710},
												alternatives: []interface{}{
													&charClassMatcher{
														pos:        position{line: 116, col: 9, offset: 2692},
														val:        "[0-9]",
														ranges:     []rune{'0', '9'},
														ignoreCase: false,
														inverted:   false,
													},
													&charClassMatcher{
														pos:        position{line: 118, col: 18, offset: 2718},
														val:        "[a-f]i",
														ranges:     []rune{'a', 'f'},
														ignoreCase: true,
														inverted:   false,
													},
												},
											},
										},
									},
								},
								&seqExpr{
									pos: position{line: 323, col: 19, offset: 8634},
									exprs: []interface{}{
										&charClassMatcher{
											pos:        position{line: 323, col: 19, offset: 8634},
											val:        "[1-9]",
											ranges:     []rune{'1', '9'},
											ignoreCase: false,
											inverted:   false,
										},
										&zeroOrMoreExpr{
											pos: position{line: 323, col: 25, offset: 8640},
											expr: &charClassMatcher{
												pos:        position{line: 116, col: 9, offset: 2692},
												val:        "[0-9]",
												ranges:     []rune{'0', '9'},
												ignoreCase: false,
												inverted:   false,
											},
										},
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 328, col: 5, offset: 8776},
						run: (*parser).callonPrimitiveExpression45,
						expr: &seqExpr{
							pos: position{line: 328, col: 5, offset: 8776},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 328, col: 5, offset: 8776},
									val:        "0",
									ignoreCase: false,
									want:       "\"0\"",
								},
								&oneOrMoreExpr{
									pos: position{line: 328, col: 9, offset: 8780},
									expr: &charClassMatcher{
										pos:        position{line: 116, col: 9, offset: 2692},
										val:        "[0-9]",
										ranges:     []rune{'0', '9'},
										ignoreCase: false,
										inverted:   false,
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 329, col: 5, offset: 8865},
						run: (*parser).callonPrimitiveExpression50,
						expr: &litMatcher{
							pos:        position{line: 329, col: 5, offset: 8865},
							val:        "0",
							ignoreCase: false,
							want:       "\"0\"",
						},
					},
					&actionExpr{
						pos: position{line: 332, col: 5, offset: 8923},
						run: (*parser).callonPrimitiveExpression52,
						expr: &seqExpr{
							pos: position{line: 332, col: 5, offset: 8923},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 332, col: 5, offset: 8923},
									val:        "+",
									ignoreCase: false,
									want:       "\"+\"",
								},
								&labeledExpr{
									pos:   position{line: 332, col: 9, offset: 8927},
									label: "n",
									expr: &choiceExpr{
										pos: position{line: 323, col: 3, offset: 8618},
										alternatives: []interface{}{
											&actionExpr{
												pos: position{line: 323, col: 3, offset: 8618},
												run: (*parser).callonPrimitiveExpression57,
												expr: &choiceExpr{
													pos: position{line: 323, col: 4, offset: 8619},
													alternatives: []interface{}{
														&seqExpr{
															pos: position{line: 323, col: 4, offset: 8619},
															exprs: []interface{}{
																&litMatcher{
																	pos:        position{line: 323, col: 4, offset: 8619},
																	val:        "0x",
																	ignoreCase: false,
																	want:       "\"0x\"",
																},
																&oneOrMoreExpr{
																	pos: position{line: 323, col: 9, offset: 8624},
																	expr: &choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																},
															},
														},
														&seqExpr{
															pos: position{line: 323, col: 19, offset: 8634},
															exprs: []interface{}{
																&charClassMatcher{
																	pos:        position{line: 323, col: 19, offset: 8634},
																	val:        "[1-9]",
																	ranges:     []rune{'1', '9'},
																	ignoreCase: false,
																	inverted:   false,
																},
																&zeroOrMoreExpr{
																	pos: position{line: 323, col: 25, offset: 8640},
																	expr: &charClassMatcher{
																		pos:        position{line: 116, col: 9, offset: 2692},
																		val:        "[0-9]",
																		ranges:     []rune{'0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
												},
											},
											&actionExpr{
												pos: position{line: 328, col: 5, offset: 8776},
												run: (*parser).callonPrimitiveExpression69,
												expr: &seqExpr{
													pos: position{line: 328, col: 5, offset: 8776},
													exprs: []interface{}{
														&litMatcher{
															pos:        position{line: 328, col: 5, offset: 8776},
															val:        "0",
															ignoreCase: false,
															want:       "\"0\"",
														},
														&oneOrMoreExpr{
															pos: position{line: 328, col: 9, offset: 8780},
															expr: &charClassMatcher{
																pos:        position{line: 116, col: 9, offset: 2692},
																val:        "[0-9]",
																ranges:     []rune{'0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
											},
											&actionExpr{
												pos: position{line: 329, col: 5, offset: 8865},
												run: (*parser).callonPrimitiveExpression74,
												expr: &litMatcher{
													pos:        position{line: 329, col: 5, offset: 8865},
													val:        "0",
													ignoreCase: false,
													want:       "\"0\"",
												},
											},
										},
									},
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 333, col: 5, offset: 8991},
						run: (*parser).callonPrimitiveExpression76,
						expr: &seqExpr{
							pos: position{line: 333, col: 5, offset: 8991},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 333, col: 5, offset: 8991},
									val:        "-",
									ignoreCase: false,
									want:       "\"-\"",
								},
								&labeledExpr{
									pos:   position{line: 333, col: 9, offset: 8995},
									label: "n",
									expr: &choiceExpr{
										pos: position{line: 323, col: 3, offset: 8618},
										alternatives: []interface{}{
											&actionExpr{
												pos: position{line: 323, col: 3, offset: 8618},
												run: (*parser).callonPrimitiveExpression81,
												expr: &choiceExpr{
													pos: position{line: 323, col: 4, offset: 8619},
													alternatives: []interface{}{
														&seqExpr{
															pos: position{line: 323, col: 4, offset: 8619},
															exprs: []interface{}{
																&litMatcher{
																	pos:        position{line: 323, col: 4, offset: 8619},
																	val:        "0x",
																	ignoreCase: false,
																	want:       "\"0x\"",
																},
																&oneOrMoreExpr{
																	pos: position{line: 323, col: 9, offset: 8624},
																	expr: &choiceExpr{
																		pos: position{line: 118, col: 10, offset: 2710},
																		alternatives: []interface{}{
																			&charClassMatcher{
																				pos:        position{line: 116, col: 9, offset: 2692},
																				val:        "[0-9]",
																				ranges:     []rune{'0', '9'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&charClassMatcher{
																				pos:        position{line: 118, col: 18, offset: 2718},
																				val:        "[a-f]i",
																				ranges:     []rune{'a', 'f'},
																				ignoreCase: true,
																				inverted:   false,
																			},
																		},
																	},
																},
															},
														},
														&seqExpr{
															pos: position{line: 323, col: 19, offset: 8634},
															exprs: []interface{}{
																&charClassMatcher{
																	pos:        position{line: 323, col: 19, offset: 8634},
																	val:        "[1-9]",
																	ranges:     []rune{'1', '9'},
																	ignoreCase: false,
																	inverted:   false,
																},
																&zeroOrMoreExpr{
																	pos: position{line: 323, col: 25, offset: 8640},
																	expr: &charClassMatcher{
																		pos:        position{line: 116, col: 9, offset: 2692},
																		val:        "[0-9]",
																		ranges:     []rune{'0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
												},
											},
											&actionExpr{
												pos: position{line: 328, col: 5, offset: 8776},
												run: (*parser).callonPrimitiveExpression93,
												expr: &seqExpr{
													pos: position{line: 328, col: 5, offset: 8776},
													exprs: []interface{}{
														&litMatcher{
															pos:        position{line: 328, col: 5, offset: 8776},
															val:        "0",
															ignoreCase: false,
															want:       "\"0\"",
														},
														&oneOrMoreExpr{
															pos: position{line: 328, col: 9, offset: 8780},
															expr: &charClassMatcher{
																pos:        position{line: 116, col: 9, offset: 2692},
																val:        "[0-9]",
																ranges:     []rune{'0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
											},
											&actionExpr{
												pos: position{line: 329, col: 5, offset: 8865},
												run: (*parser).callonPrimitiveExpression98,
												expr: &litMatcher{
													pos:        position{line: 329, col: 5, offset: 8865},
													val:        "0",
													ignoreCase: false,
													want:       "\"0\"",
												},
											},
										},
									},
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 669, col: 7, offset: 20962},
						name: "TextLiteral",
					},
					&actionExpr{
						pos: position{line: 670, col: 7, offset: 20980},
						run: (*parser).callonPrimitiveExpression101,
						expr: &seqExpr{
							pos: position{line: 670, col: 7, offset: 20980},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 670, col: 7, offset: 20980},
									val:        "{",
									ignoreCase: false,
									want:       "\"{\"",
								},
								&ruleRefExpr{
									pos:  position{line: 670, col: 11, offset: 20984},
									name: "_",
								},
								&zeroOrOneExpr{
									pos: position{line: 670, col: 13, offset: 20986},
									expr: &seqExpr{
										pos: position{line: 670, col: 14, offset: 20987},
										exprs: []interface{}{
											&litMatcher{
												pos:        position{line: 670, col: 14, offset: 20987},
												val:        ",",
												ignoreCase: false,
												want:       "\",\"",
											},
											&ruleRefExpr{
												pos:  position{line: 670, col: 18, offset: 20991},
												name: "_",
											},
										},
									},
								},
								&labeledExpr{
									pos:   position{line: 670, col: 22, offset: 20995},
									label: "r",
									expr: &ruleRefExpr{
										pos:  position{line: 670, col: 24, offset: 20997},
										name: "RecordTypeOrLiteral",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 670, col: 44, offset: 21017},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 670, col: 46, offset: 21019},
									val:        "}",
									ignoreCase: false,
									want:       "\"}\"",
								},
							},
						},
					},
					&actionExpr{
						pos: position{line: 671, col: 7, offset: 21047},
						run: (*parser).callonPrimitiveExpression113,
						expr: &seqExpr{
							pos: position{line: 671, col: 7, offset: 21047},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 671, col: 7, offset: 21047},
									val:        "<",
									ignoreCase: false,
									want:       "\"<\"",
								},
								&ruleRefExpr{
									pos:  position{line: 671, col: 11, offset: 21051},
									name: "_",
								},
								&zeroOrOneExpr{
									pos: position{line: 671, col: 13, offset: 21053},
									expr: &seqExpr{
										pos: position{line: 671, col: 14, offset: 21054},
										exprs: []interface{}{
											&litMatcher{
												pos:        position{line: 671, col: 14, offset: 21054},
												val:        "|",
												ignoreCase: false,
												want:       "\"|\"",
											},
											&ruleRefExpr{
												pos:  position{line: 671, col: 18, offset: 21058},
												name: "_",
											},
										},
									},
								},
								&labeledExpr{
									pos:   position{line: 671, col: 22, offset: 21062},
									label: "u",
									expr: &ruleRefExpr{
										pos:  position{line: 671, col: 24, offset: 21064},
										name: "UnionType",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 671, col: 34, offset: 21074},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 671, col: 36, offset: 21076},
									val:        ">",
									ignoreCase: false,
									want:       "\">\"",
								},
							},
						},
					},
					&ruleRefExpr{
						pos:  position{line: 672, col: 7, offset: 21104},
						name: "NonEmptyListLiteral",
					},
					&ruleRefExpr{
						pos:  position{line: 673, col: 7, offset: 21130},
						name: "Identifier",
					},
					&actionExpr{
						pos: position{line: 674, col: 7, offset: 21147},
						run: (*parser).callonPrimitiveExpression127,
						expr: &seqExpr{
							pos: position{line: 674, col: 7, offset: 21147},
							exprs: []interface{}{
								&litMatcher{
									pos:        position{line: 674, col: 7, offset: 21147},
									val:        "(",
									ignoreCase: false,
									want:       "\"(\"",
								},
								&ruleRefExpr{
									pos:  position{line: 674, col: 11, offset: 21151},
									name: "_",
								},
								&zeroOrOneExpr{
									pos: position{line: 674, col: 13, offset: 21153},
									expr: &seqExpr{
										pos: position{line: 674, col: 14, offset: 21154},
										exprs: []interface{}{
											&litMatcher{
												pos:        position{line: 674, col: 14, offset: 21154},
												val:        "|",
												ignoreCase: false,
												want:       "\"|\"",
											},
											&ruleRefExpr{
												pos:  position{line: 674, col: 18, offset: 21158},
												name: "_",
											},
										},
									},
								},
								&labeledExpr{
									pos:   position{line: 674, col: 22, offset: 21162},
									label: "e",
									expr: &ruleRefExpr{
										pos:  position{line: 674, col: 24, offset: 21164},
										name: "Expression",
									},
								},
								&ruleRefExpr{
									pos:  position{line: 674, col: 35, offset: 21175},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 674, col: 37, offset: 21177},
									val:        ")",
									ignoreCase: false,
									want:       "\")\"",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "RecordTypeOrLiteral",
			pos:  position{line: 676, col: 1, offset: 21200},
			expr: &choiceExpr{
				pos: position{line: 677, col: 7, offset: 21230},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 677, col: 7, offset: 21230},
						name: "EmptyRecordLiteral",
					},
					&ruleRefExpr{
						pos:  position{line: 678, col: 7, offset: 21255},
						name: "NonEmptyRecordType",
					},
					&ruleRefExpr{
						pos:  position{line: 679, col: 7, offset: 21280},
						name: "NonEmptyRecordLiteral",
					},
					&actionExpr{
						pos: position{line: 680, col: 7, offset: 21308},
						run: (*parser).callonRecordTypeOrLiteral5,
						expr: &litMatcher{
							pos:        position{line: 680, col: 7, offset: 21308},
							val:        "",
							ignoreCase: false,
							want:       "\"\"",
						},
					},
				},
			},
		},
		{
			name: "EmptyRecordLiteral",
			pos:  position{line: 682, col: 1, offset: 21341},
			expr: &actionExpr{
				pos: position{line: 682, col: 22, offset: 21364},
				run: (*parser).callonEmptyRecordLiteral1,
				expr: &seqExpr{
					pos: position{line: 682, col: 22, offset: 21364},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 682, col: 22, offset: 21364},
							val:        "=",
							ignoreCase: false,
							want:       "\"=\"",
						},
						&zeroOrOneExpr{
							pos: position{line: 682, col: 26, offset: 21368},
							expr: &seqExpr{
								pos: position{line: 682, col: 28, offset: 21370},
								exprs: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 682, col: 28, offset: 21370},
										name: "_",
									},
									&litMatcher{
										pos:        position{line: 682, col: 30, offset: 21372},
										val:        ",",
										ignoreCase: false,
										want:       "\",\"",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "MoreRecordType",
			pos:  position{line: 684, col: 1, offset: 21408},
			expr: &actionExpr{
				pos: position{line: 684, col: 18, offset: 21427},
				run: (*parser).callonMoreRecordType1,
				expr: &seqExpr{
					pos: position{line: 684, col: 18, offset: 21427},
					exprs: []interface{}{
						&ruleRefExpr{
							pos:  position{line: 684, col: 18, offset: 21427},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 684, col: 20, offset: 21429},
							val:        ",",
							ignoreCase: false,
							want:       "\",\"",
						},
						&ruleRefExpr{
							pos:  position{line: 684, col: 24, offset: 21433},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 684, col: 26, offset: 21435},
							label: "f",
							expr: &ruleRefExpr{
								pos:  position{line: 684, col: 28, offset: 21437},
								name: "RecordTypeEntry",
							},
						},
					},
				},
			},
		},
		{
			name: "NonEmptyRecordType",
			pos:  position{line: 685, col: 1, offset: 21469},
			expr: &actionExpr{
				pos: position{line: 686, col: 7, offset: 21498},
				run: (*parser).callonNonEmptyRecordType1,
				expr: &seqExpr{
					pos: position{line: 686, col: 7, offset: 21498},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 686, col: 7, offset: 21498},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 686, col: 13, offset: 21504},
								name: "RecordTypeEntry",
							},
						},
						&labeledExpr{
							pos:   position{line: 686, col: 29, offset: 21520},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 686, col: 34, offset: 21525},
								expr: &ruleRefExpr{
									pos:  position{line: 686, col: 34, offset: 21525},
									name: "MoreRecordType",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 686, col: 50, offset: 21541},
							expr: &seqExpr{
								pos: position{line: 686, col: 51, offset: 21542},
								exprs: []interface{}{
									&litMatcher{
										pos:        position{line: 686, col: 51, offset: 21542},
										val:        ",",
										ignoreCase: false,
										want:       "\",\"",
									},
									&ruleRefExpr{
										pos:  position{line: 686, col: 55, offset: 21546},
										name: "_",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "RecordTypeEntry",
			pos:  position{line: 700, col: 1, offset: 21974},
			expr: &actionExpr{
				pos: position{line: 700, col: 19, offset: 21994},
				run: (*parser).callonRecordTypeEntry1,
				expr: &seqExpr{
					pos: position{line: 700, col: 19, offset: 21994},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 700, col: 19, offset: 21994},
							label: "name",
							expr: &choiceExpr{
								pos: position{line: 139, col: 18, offset: 3403},
								alternatives: []interface{}{
									&actionExpr{
										pos: position{line: 131, col: 9, offset: 3119},
										run: (*parser).callonRecordTypeEntry5,
										expr: &seqExpr{
											pos: position{line: 131, col: 9, offset: 3119},
											exprs: []interface{}{
												&litMatcher{
													pos:        position{line: 131, col: 9, offset: 3119},
													val:        "`",
													ignoreCase: false,
													want:       "\"`\"",
												},
												&labeledExpr{
													pos:   position{line: 131, col: 13, offset: 3123},
													label: "label",
													expr: &actionExpr{
														pos: position{line: 129, col: 15, offset: 3060},
														run: (*parser).callonRecordTypeEntry9,
														expr: &zeroOrMoreExpr{
															pos: position{line: 129, col: 15, offset: 3060},
															expr: &charClassMatcher{
																pos:        position{line: 128, col: 19, offset: 3023},
																val:        "[ -_a-~]",
																ranges:     []rune{' ', '_', 'a', '~'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
												&litMatcher{
													pos:        position{line: 131, col: 31, offset: 3141},
													val:        "`",
													ignoreCase: false,
													want:       "\"`\"",
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 132, col: 9, offset: 3175},
										run: (*parser).callonRecordTypeEntry13,
										expr: &labeledExpr{
											pos:   position{line: 132, col: 9, offset: 3175},
											label: "label",
											expr: &choiceExpr{
												pos: position{line: 122, col: 15, offset: 2816},
												alternatives: []interface{}{
													&actionExpr{
														pos: position{line: 122, col: 15, offset: 2816},
														run: (*parser).callonRecordTypeEntry16,
														expr: &seqExpr{
															pos: position{line: 122, col: 15, offset: 2816},
															exprs: []interface{}{
																&choiceExpr{
																	pos: position{line: 249, col: 5, offset: 6269},
																	alternatives: []interface{}{
																		&litMatcher{
																			pos:        position{line: 231, col: 6, offset: 5936},
																			val:        "if",
																			ignoreCase: false,
																			want:       "\"if\"",
																		},
																		&litMatcher{
																			pos:        position{line: 232, col: 8, offset: 5950},
																			val:        "then",
																			ignoreCase: false,
																			want:       "\"then\"",
																		},
																		&litMatcher{
																			pos:        position{line: 233, col: 8, offset: 5966},
																			val:        "else",
																			ignoreCase: false,
																			want:       "\"else\"",
																		},
																		&litMatcher{
																			pos:        position{line: 234, col: 7, offset: 5981},
																			val:        "let",
																			ignoreCase: false,
																			want:       "\"let\"",
																		},
																		&litMatcher{
																			pos:        position{line: 235, col: 6, offset: 5994},
																			val:        "in",
																			ignoreCase: false,
																			want:       "\"in\"",
																		},
																		&litMatcher{
																			pos:        position{line: 237, col: 9, offset: 6021},
																			val:        "using",
																			ignoreCase: false,
																			want:       "\"using\"",
																		},
																		&actionExpr{
																			pos: position{line: 239, col: 11, offset: 6059},
																			run: (*parser).callonRecordTypeEntry25,
																			expr: &seqExpr{
																				pos: position{line: 239, col: 11, offset: 6059},
																				exprs: []interface{}{
																					&litMatcher{
																						pos:        position{line: 239, col: 11, offset: 6059},
																						val:        "missing",
																						ignoreCase: false,
																						want:       "\"missing\"",
																					},
																					&notExpr{
																						pos: position{line: 239, col: 21, offset: 6069},
																						expr: &charClassMatcher{
																							pos:        position{line: 121, col: 23, offset: 2785},
																							val:        "[_/-A-Za-z0-9]",
																							chars:      []rune{'_', '/', '-'},
																							ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																					},
																				},
																			},
																		},
																		&litMatcher{
																			pos:        position{line: 244, col: 10, offset: 6199},
																			val:        "assert",
																			ignoreCase: false,
																			want:       "\"assert\"",
																		},
																		&litMatcher{
																			pos:        position{line: 236, col: 6, offset: 6006},
																			val:        "as",
																			ignoreCase: false,
																			want:       "\"as\"",
																		},
																		&litMatcher{
																			pos:        position{line: 240, col: 12, offset: 6129},
																			val:        "Infinity",
																			ignoreCase: false,
																			want:       "\"Infinity\"",
																		},
																		&litMatcher{
																			pos:        position{line: 241, col: 7, offset: 6148},
																			val:        "NaN",
																			ignoreCase: false,
																			want:       "\"NaN\"",
																		},
																		&litMatcher{
																			pos:        position{line: 238, col: 9, offset: 6039},
																			val:        "merge",
																			ignoreCase: false,
																			want:       "\"merge\"",
																		},
																		&litMatcher{
																			pos:        position{line: 242, col: 8, offset: 6163},
																			val:        "Some",
																			ignoreCase: false,
																			want:       "\"Some\"",
																		},
																		&litMatcher{
																			pos:        position{line: 243, col: 9, offset: 6180},
																			val:        "toMap",
																			ignoreCase: false,
																			want:       "\"toMap\"",
																		},
																		&litMatcher{
																			pos:        position{line: 245, col: 10, offset: 6219},
																			val:        "forall",
																			ignoreCase: false,
																			want:       "\"forall\"",
																		},
																		&litMatcher{
																			pos:        position{line: 245, col: 21, offset: 6230},
																			val:        "∀",
																			ignoreCase: false,
																			want:       "\"∀\"",
																		},
																		&litMatcher{
																			pos:        position{line: 246, col: 8, offset: 6245},
																			val:        "with",
																			ignoreCase: false,
																			want:       "\"with\"",
																		},
																	},
																},
																&oneOrMoreExpr{
																	pos: position{line: 122, col: 23, offset: 2824},
																	expr: &charClassMatcher{
																		pos:        position{line: 121, col: 23, offset: 2785},
																		val:        "[_/-A-Za-z0-9]",
																		chars:      []rune{'_', '/', '-'},
																		ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
													&actionExpr{
														pos: position{line: 123, col: 13, offset: 2888},
														run: (*parser).callonRecordTypeEntry42,
														expr: &seqExpr{
															pos: position{line: 123, col: 13, offset: 2888},
															exprs: []interface{}{
																&notExpr{
																	pos: position{line: 123, col: 13, offset: 2888},
																	expr: &choiceExpr{
																		pos: position{line: 249, col: 5, offset: 6269},
																		alternatives: []interface{}{
																			&litMatcher{
																				pos:        position{line: 231, col: 6, offset: 5936},
																				val:        "if",
																				ignoreCase: false,
																				want:       "\"if\"",
																			},
																			&litMatcher{
																				pos:        position{line: 232, col: 8, offset: 5950},
																				val:        "then",
																				ignoreCase: false,
																				want:       "\"then\"",
																			},
																			&litMatcher{
																				pos:        position{line: 233, col: 8, offset: 5966},
																				val:        "else",
																				ignoreCase: false,
																				want:       "\"else\"",
																			},
																			&litMatcher{
																				pos:        position{line: 234, col: 7, offset: 5981},
																				val:        "let",
																				ignoreCase: false,
																				want:       "\"let\"",
																			},
																			&litMatcher{
																				pos:        position{line: 235, col: 6, offset: 5994},
																				val:        "in",
																				ignoreCase: false,
																				want:       "\"in\"",
																			},
																			&litMatcher{
																				pos:        position{line: 237, col: 9, offset: 6021},
																				val:        "using",
																				ignoreCase: false,
																				want:       "\"using\"",
																			},
																			&actionExpr{
																				pos: position{line: 239, col: 11, offset: 6059},
																				run: (*parser).callonRecordTypeEntry52,
																				expr: &seqExpr{
																					pos: position{line: 239, col: 11, offset: 6059},
																					exprs: []interface{}{
																						&litMatcher{
																							pos:        position{line: 239, col: 11, offset: 6059},
																							val:        "missing",
																							ignoreCase: false,
																							want:       "\"missing\"",
																						},
																						&notExpr{
																							pos: position{line: 239, col: 21, offset: 6069},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																			&litMatcher{
																				pos:        position{line: 244, col: 10, offset: 6199},
																				val:        "assert",
																				ignoreCase: false,
																				want:       "\"assert\"",
																			},
																			&litMatcher{
																				pos:        position{line: 236, col: 6, offset: 6006},
																				val:        "as",
																				ignoreCase: false,
																				want:       "\"as\"",
																			},
																			&litMatcher{
																				pos:        position{line: 240, col: 12, offset: 6129},
																				val:        "Infinity",
																				ignoreCase: false,
																				want:       "\"Infinity\"",
																			},
																			&litMatcher{
																				pos:        position{line: 241, col: 7, offset: 6148},
																				val:        "NaN",
																				ignoreCase: false,
																				want:       "\"NaN\"",
																			},
																			&litMatcher{
																				pos:        position{line: 238, col: 9, offset: 6039},
																				val:        "merge",
																				ignoreCase: false,
																				want:       "\"merge\"",
																			},
																			&litMatcher{
																				pos:        position{line: 242, col: 8, offset: 6163},
																				val:        "Some",
																				ignoreCase: false,
																				want:       "\"Some\"",
																			},
																			&litMatcher{
																				pos:        position{line: 243, col: 9, offset: 6180},
																				val:        "toMap",
																				ignoreCase: false,
																				want:       "\"toMap\"",
																			},
																			&litMatcher{
																				pos:        position{line: 245, col: 10, offset: 6219},
																				val:        "forall",
																				ignoreCase: false,
																				want:       "\"forall\"",
																			},
																			&litMatcher{
																				pos:        position{line: 245, col: 21, offset: 6230},
																				val:        "∀",
																				ignoreCase: false,
																				want:       "\"∀\"",
																			},
																			&litMatcher{
																				pos:        position{line: 246, col: 8, offset: 6245},
																				val:        "with",
																				ignoreCase: false,
																				want:       "\"with\"",
																			},
																		},
																	},
																},
																&charClassMatcher{
																	pos:        position{line: 120, col: 24, offset: 2751},
																	val:        "[_A-Za-z]",
																	chars:      []rune{'_'},
																	ranges:     []rune{'A', 'Z', 'a', 'z'},
																	ignoreCase: false,
																	inverted:   false,
																},
																&zeroOrMoreExpr{
																	pos: position{line: 123, col: 43, offset: 2918},
																	expr: &charClassMatcher{
																		pos:        position{line: 121, col: 23, offset: 2785},
																		val:        "[_/-A-Za-z0-9]",
																		chars:      []rune{'_', '/', '-'},
																		ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 139, col: 29, offset: 3414},
										run: (*parser).callonRecordTypeEntry70,
										expr: &litMatcher{
											pos:        position{line: 242, col: 8, offset: 6163},
											val:        "Some",
											ignoreCase: false,
											want:       "\"Some\"",
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 700, col: 39, offset: 22014},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 700, col: 41, offset: 22016},
							val:        ":",
							ignoreCase: false,
							want:       "\":\"",
						},
						&ruleRefExpr{
							pos:  position{line: 700, col: 45, offset: 22020},
							name: "_1",
						},
						&labeledExpr{
							pos:   position{line: 700, col: 48, offset: 22023},
							label: "expr",
							expr: &ruleRefExpr{
								pos:  position{line: 700, col: 53, offset: 22028},
								name: "Expression",
							},
						},
					},
				},
			},
		},
		{
			name: "MoreRecordLiteral",
			pos:  position{line: 704, col: 1, offset: 22099},
			expr: &actionExpr{
				pos: position{line: 704, col: 21, offset: 22121},
				run: (*parser).callonMoreRecordLiteral1,
				expr: &seqExpr{
					pos: position{line: 704, col: 21, offset: 22121},
					exprs: []interface{}{
						&ruleRefExpr{
							pos:  position{line: 704, col: 21, offset: 22121},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 704, col: 23, offset: 22123},
							val:        ",",
							ignoreCase: false,
							want:       "\",\"",
						},
						&ruleRefExpr{
							pos:  position{line: 704, col: 27, offset: 22127},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 704, col: 29, offset: 22129},
							label: "f",
							expr: &ruleRefExpr{
								pos:  position{line: 704, col: 31, offset: 22131},
								name: "RecordLiteralEntry",
							},
						},
					},
				},
			},
		},
		{
			name: "NonEmptyRecordLiteral",
			pos:  position{line: 705, col: 1, offset: 22166},
			expr: &actionExpr{
				pos: position{line: 706, col: 7, offset: 22198},
				run: (*parser).callonNonEmptyRecordLiteral1,
				expr: &seqExpr{
					pos: position{line: 706, col: 7, offset: 22198},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 706, col: 7, offset: 22198},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 706, col: 13, offset: 22204},
								name: "RecordLiteralEntry",
							},
						},
						&labeledExpr{
							pos:   position{line: 706, col: 32, offset: 22223},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 706, col: 37, offset: 22228},
								expr: &ruleRefExpr{
									pos:  position{line: 706, col: 37, offset: 22228},
									name: "MoreRecordLiteral",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 706, col: 56, offset: 22247},
							expr: &seqExpr{
								pos: position{line: 706, col: 57, offset: 22248},
								exprs: []interface{}{
									&litMatcher{
										pos:        position{line: 706, col: 57, offset: 22248},
										val:        ",",
										ignoreCase: false,
										want:       "\",\"",
									},
									&ruleRefExpr{
										pos:  position{line: 706, col: 61, offset: 22252},
										name: "_",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "RecordLiteralEntry",
			pos:  position{line: 725, col: 1, offset: 22814},
			expr: &actionExpr{
				pos: position{line: 725, col: 22, offset: 22837},
				run: (*parser).callonRecordLiteralEntry1,
				expr: &seqExpr{
					pos: position{line: 725, col: 22, offset: 22837},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 725, col: 22, offset: 22837},
							label: "name",
							expr: &choiceExpr{
								pos: position{line: 139, col: 18, offset: 3403},
								alternatives: []interface{}{
									&actionExpr{
										pos: position{line: 131, col: 9, offset: 3119},
										run: (*parser).callonRecordLiteralEntry5,
										expr: &seqExpr{
											pos: position{line: 131, col: 9, offset: 3119},
											exprs: []interface{}{
												&litMatcher{
													pos:        position{line: 131, col: 9, offset: 3119},
													val:        "`",
													ignoreCase: false,
													want:       "\"`\"",
												},
												&labeledExpr{
													pos:   position{line: 131, col: 13, offset: 3123},
													label: "label",
													expr: &actionExpr{
														pos: position{line: 129, col: 15, offset: 3060},
														run: (*parser).callonRecordLiteralEntry9,
														expr: &zeroOrMoreExpr{
															pos: position{line: 129, col: 15, offset: 3060},
															expr: &charClassMatcher{
																pos:        position{line: 128, col: 19, offset: 3023},
																val:        "[ -_a-~]",
																ranges:     []rune{' ', '_', 'a', '~'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
												&litMatcher{
													pos:        position{line: 131, col: 31, offset: 3141},
													val:        "`",
													ignoreCase: false,
													want:       "\"`\"",
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 132, col: 9, offset: 3175},
										run: (*parser).callonRecordLiteralEntry13,
										expr: &labeledExpr{
											pos:   position{line: 132, col: 9, offset: 3175},
											label: "label",
											expr: &choiceExpr{
												pos: position{line: 122, col: 15, offset: 2816},
												alternatives: []interface{}{
													&actionExpr{
														pos: position{line: 122, col: 15, offset: 2816},
														run: (*parser).callonRecordLiteralEntry16,
														expr: &seqExpr{
															pos: position{line: 122, col: 15, offset: 2816},
															exprs: []interface{}{
																&choiceExpr{
																	pos: position{line: 249, col: 5, offset: 6269},
																	alternatives: []interface{}{
																		&litMatcher{
																			pos:        position{line: 231, col: 6, offset: 5936},
																			val:        "if",
																			ignoreCase: false,
																			want:       "\"if\"",
																		},
																		&litMatcher{
																			pos:        position{line: 232, col: 8, offset: 5950},
																			val:        "then",
																			ignoreCase: false,
																			want:       "\"then\"",
																		},
																		&litMatcher{
																			pos:        position{line: 233, col: 8, offset: 5966},
																			val:        "else",
																			ignoreCase: false,
																			want:       "\"else\"",
																		},
																		&litMatcher{
																			pos:        position{line: 234, col: 7, offset: 5981},
																			val:        "let",
																			ignoreCase: false,
																			want:       "\"let\"",
																		},
																		&litMatcher{
																			pos:        position{line: 235, col: 6, offset: 5994},
																			val:        "in",
																			ignoreCase: false,
																			want:       "\"in\"",
																		},
																		&litMatcher{
																			pos:        position{line: 237, col: 9, offset: 6021},
																			val:        "using",
																			ignoreCase: false,
																			want:       "\"using\"",
																		},
																		&actionExpr{
																			pos: position{line: 239, col: 11, offset: 6059},
																			run: (*parser).callonRecordLiteralEntry25,
																			expr: &seqExpr{
																				pos: position{line: 239, col: 11, offset: 6059},
																				exprs: []interface{}{
																					&litMatcher{
																						pos:        position{line: 239, col: 11, offset: 6059},
																						val:        "missing",
																						ignoreCase: false,
																						want:       "\"missing\"",
																					},
																					&notExpr{
																						pos: position{line: 239, col: 21, offset: 6069},
																						expr: &charClassMatcher{
																							pos:        position{line: 121, col: 23, offset: 2785},
																							val:        "[_/-A-Za-z0-9]",
																							chars:      []rune{'_', '/', '-'},
																							ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																							ignoreCase: false,
																							inverted:   false,
																						},
																					},
																				},
																			},
																		},
																		&litMatcher{
																			pos:        position{line: 244, col: 10, offset: 6199},
																			val:        "assert",
																			ignoreCase: false,
																			want:       "\"assert\"",
																		},
																		&litMatcher{
																			pos:        position{line: 236, col: 6, offset: 6006},
																			val:        "as",
																			ignoreCase: false,
																			want:       "\"as\"",
																		},
																		&litMatcher{
																			pos:        position{line: 240, col: 12, offset: 6129},
																			val:        "Infinity",
																			ignoreCase: false,
																			want:       "\"Infinity\"",
																		},
																		&litMatcher{
																			pos:        position{line: 241, col: 7, offset: 6148},
																			val:        "NaN",
																			ignoreCase: false,
																			want:       "\"NaN\"",
																		},
																		&litMatcher{
																			pos:        position{line: 238, col: 9, offset: 6039},
																			val:        "merge",
																			ignoreCase: false,
																			want:       "\"merge\"",
																		},
																		&litMatcher{
																			pos:        position{line: 242, col: 8, offset: 6163},
																			val:        "Some",
																			ignoreCase: false,
																			want:       "\"Some\"",
																		},
																		&litMatcher{
																			pos:        position{line: 243, col: 9, offset: 6180},
																			val:        "toMap",
																			ignoreCase: false,
																			want:       "\"toMap\"",
																		},
																		&litMatcher{
																			pos:        position{line: 245, col: 10, offset: 6219},
																			val:        "forall",
																			ignoreCase: false,
																			want:       "\"forall\"",
																		},
																		&litMatcher{
																			pos:        position{line: 245, col: 21, offset: 6230},
																			val:        "∀",
																			ignoreCase: false,
																			want:       "\"∀\"",
																		},
																		&litMatcher{
																			pos:        position{line: 246, col: 8, offset: 6245},
																			val:        "with",
																			ignoreCase: false,
																			want:       "\"with\"",
																		},
																	},
																},
																&oneOrMoreExpr{
																	pos: position{line: 122, col: 23, offset: 2824},
																	expr: &charClassMatcher{
																		pos:        position{line: 121, col: 23, offset: 2785},
																		val:        "[_/-A-Za-z0-9]",
																		chars:      []rune{'_', '/', '-'},
																		ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
													&actionExpr{
														pos: position{line: 123, col: 13, offset: 2888},
														run: (*parser).callonRecordLiteralEntry42,
														expr: &seqExpr{
															pos: position{line: 123, col: 13, offset: 2888},
															exprs: []interface{}{
																&notExpr{
																	pos: position{line: 123, col: 13, offset: 2888},
																	expr: &choiceExpr{
																		pos: position{line: 249, col: 5, offset: 6269},
																		alternatives: []interface{}{
																			&litMatcher{
																				pos:        position{line: 231, col: 6, offset: 5936},
																				val:        "if",
																				ignoreCase: false,
																				want:       "\"if\"",
																			},
																			&litMatcher{
																				pos:        position{line: 232, col: 8, offset: 5950},
																				val:        "then",
																				ignoreCase: false,
																				want:       "\"then\"",
																			},
																			&litMatcher{
																				pos:        position{line: 233, col: 8, offset: 5966},
																				val:        "else",
																				ignoreCase: false,
																				want:       "\"else\"",
																			},
																			&litMatcher{
																				pos:        position{line: 234, col: 7, offset: 5981},
																				val:        "let",
																				ignoreCase: false,
																				want:       "\"let\"",
																			},
																			&litMatcher{
																				pos:        position{line: 235, col: 6, offset: 5994},
																				val:        "in",
																				ignoreCase: false,
																				want:       "\"in\"",
																			},
																			&litMatcher{
																				pos:        position{line: 237, col: 9, offset: 6021},
																				val:        "using",
																				ignoreCase: false,
																				want:       "\"using\"",
																			},
																			&actionExpr{
																				pos: position{line: 239, col: 11, offset: 6059},
																				run: (*parser).callonRecordLiteralEntry52,
																				expr: &seqExpr{
																					pos: position{line: 239, col: 11, offset: 6059},
																					exprs: []interface{}{
																						&litMatcher{
																							pos:        position{line: 239, col: 11, offset: 6059},
																							val:        "missing",
																							ignoreCase: false,
																							want:       "\"missing\"",
																						},
																						&notExpr{
																							pos: position{line: 239, col: 21, offset: 6069},
																							expr: &charClassMatcher{
																								pos:        position{line: 121, col: 23, offset: 2785},
																								val:        "[_/-A-Za-z0-9]",
																								chars:      []rune{'_', '/', '-'},
																								ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																								ignoreCase: false,
																								inverted:   false,
																							},
																						},
																					},
																				},
																			},
																			&litMatcher{
																				pos:        position{line: 244, col: 10, offset: 6199},
																				val:        "assert",
																				ignoreCase: false,
																				want:       "\"assert\"",
																			},
																			&litMatcher{
																				pos:        position{line: 236, col: 6, offset: 6006},
																				val:        "as",
																				ignoreCase: false,
																				want:       "\"as\"",
																			},
																			&litMatcher{
																				pos:        position{line: 240, col: 12, offset: 6129},
																				val:        "Infinity",
																				ignoreCase: false,
																				want:       "\"Infinity\"",
																			},
																			&litMatcher{
																				pos:        position{line: 241, col: 7, offset: 6148},
																				val:        "NaN",
																				ignoreCase: false,
																				want:       "\"NaN\"",
																			},
																			&litMatcher{
																				pos:        position{line: 238, col: 9, offset: 6039},
																				val:        "merge",
																				ignoreCase: false,
																				want:       "\"merge\"",
																			},
																			&litMatcher{
																				pos:        position{line: 242, col: 8, offset: 6163},
																				val:        "Some",
																				ignoreCase: false,
																				want:       "\"Some\"",
																			},
																			&litMatcher{
																				pos:        position{line: 243, col: 9, offset: 6180},
																				val:        "toMap",
																				ignoreCase: false,
																				want:       "\"toMap\"",
																			},
																			&litMatcher{
																				pos:        position{line: 245, col: 10, offset: 6219},
																				val:        "forall",
																				ignoreCase: false,
																				want:       "\"forall\"",
																			},
																			&litMatcher{
																				pos:        position{line: 245, col: 21, offset: 6230},
																				val:        "∀",
																				ignoreCase: false,
																				want:       "\"∀\"",
																			},
																			&litMatcher{
																				pos:        position{line: 246, col: 8, offset: 6245},
																				val:        "with",
																				ignoreCase: false,
																				want:       "\"with\"",
																			},
																		},
																	},
																},
																&charClassMatcher{
																	pos:        position{line: 120, col: 24, offset: 2751},
																	val:        "[_A-Za-z]",
																	chars:      []rune{'_'},
																	ranges:     []rune{'A', 'Z', 'a', 'z'},
																	ignoreCase: false,
																	inverted:   false,
																},
																&zeroOrMoreExpr{
																	pos: position{line: 123, col: 43, offset: 2918},
																	expr: &charClassMatcher{
																		pos:        position{line: 121, col: 23, offset: 2785},
																		val:        "[_/-A-Za-z0-9]",
																		chars:      []rune{'_', '/', '-'},
																		ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																		ignoreCase: false,
																		inverted:   false,
																	},
																},
															},
														},
													},
												},
											},
										},
									},
									&actionExpr{
										pos: position{line: 139, col: 29, offset: 3414},
										run: (*parser).callonRecordLiteralEntry70,
										expr: &litMatcher{
											pos:        position{line: 242, col: 8, offset: 6163},
											val:        "Some",
											ignoreCase: false,
											want:       "\"Some\"",
										},
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 725, col: 42, offset: 22857},
							label: "val",
							expr: &choiceExpr{
								pos: position{line: 725, col: 47, offset: 22862},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 725, col: 47, offset: 22862},
										name: "RecordLiteralNormalEntry",
									},
									&litMatcher{
										pos:        position{line: 742, col: 28, offset: 23451},
										val:        "",
										ignoreCase: false,
										want:       "\"\"",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "RecordLiteralNormalEntry",
			pos:  position{line: 733, col: 1, offset: 23109},
			expr: &actionExpr{
				pos: position{line: 733, col: 28, offset: 23138},
				run: (*parser).callonRecordLiteralNormalEntry1,
				expr: &seqExpr{
					pos: position{line: 733, col: 28, offset: 23138},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 733, col: 28, offset: 23138},
							label: "children",
							expr: &zeroOrMoreExpr{
								pos: position{line: 733, col: 37, offset: 23147},
								expr: &seqExpr{
									pos: position{line: 733, col: 38, offset: 23148},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 733, col: 38, offset: 23148},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 733, col: 40, offset: 23150},
											val:        ".",
											ignoreCase: false,
											want:       "\".\"",
										},
										&ruleRefExpr{
											pos:  position{line: 733, col: 44, offset: 23154},
											name: "_",
										},
										&choiceExpr{
											pos: position{line: 139, col: 18, offset: 3403},
											alternatives: []interface{}{
												&actionExpr{
													pos: position{line: 131, col: 9, offset: 3119},
													run: (*parser).callonRecordLiteralNormalEntry10,
													expr: &seqExpr{
														pos: position{line: 131, col: 9, offset: 3119},
														exprs: []interface{}{
															&litMatcher{
																pos:        position{line: 131, col: 9, offset: 3119},
																val:        "`",
																ignoreCase: false,
																want:       "\"`\"",
															},
															&labeledExpr{
																pos:   position{line: 131, col: 13, offset: 3123},
																label: "label",
																expr: &actionExpr{
																	pos: position{line: 129, col: 15, offset: 3060},
																	run: (*parser).callonRecordLiteralNormalEntry14,
																	expr: &zeroOrMoreExpr{
																		pos: position{line: 129, col: 15, offset: 3060},
																		expr: &charClassMatcher{
																			pos:        position{line: 128, col: 19, offset: 3023},
																			val:        "[ -_a-~]",
																			ranges:     []rune{' ', '_', 'a', '~'},
																			ignoreCase: false,
																			inverted:   false,
																		},
																	},
																},
															},
															&litMatcher{
																pos:        position{line: 131, col: 31, offset: 3141},
																val:        "`",
																ignoreCase: false,
																want:       "\"`\"",
															},
														},
													},
												},
												&actionExpr{
													pos: position{line: 132, col: 9, offset: 3175},
													run: (*parser).callonRecordLiteralNormalEntry18,
													expr: &labeledExpr{
														pos:   position{line: 132, col: 9, offset: 3175},
														label: "label",
														expr: &choiceExpr{
															pos: position{line: 122, col: 15, offset: 2816},
															alternatives: []interface{}{
																&actionExpr{
																	pos: position{line: 122, col: 15, offset: 2816},
																	run: (*parser).callonRecordLiteralNormalEntry21,
																	expr: &seqExpr{
																		pos: position{line: 122, col: 15, offset: 2816},
																		exprs: []interface{}{
																			&choiceExpr{
																				pos: position{line: 249, col: 5, offset: 6269},
																				alternatives: []interface{}{
																					&litMatcher{
																						pos:        position{line: 231, col: 6, offset: 5936},
																						val:        "if",
																						ignoreCase: false,
																						want:       "\"if\"",
																					},
																					&litMatcher{
																						pos:        position{line: 232, col: 8, offset: 5950},
																						val:        "then",
																						ignoreCase: false,
																						want:       "\"then\"",
																					},
																					&litMatcher{
																						pos:        position{line: 233, col: 8, offset: 5966},
																						val:        "else",
																						ignoreCase: false,
																						want:       "\"else\"",
																					},
																					&litMatcher{
																						pos:        position{line: 234, col: 7, offset: 5981},
																						val:        "let",
																						ignoreCase: false,
																						want:       "\"let\"",
																					},
																					&litMatcher{
																						pos:        position{line: 235, col: 6, offset: 5994},
																						val:        "in",
																						ignoreCase: false,
																						want:       "\"in\"",
																					},
																					&litMatcher{
																						pos:        position{line: 237, col: 9, offset: 6021},
																						val:        "using",
																						ignoreCase: false,
																						want:       "\"using\"",
																					},
																					&actionExpr{
																						pos: position{line: 239, col: 11, offset: 6059},
																						run: (*parser).callonRecordLiteralNormalEntry30,
																						expr: &seqExpr{
																							pos: position{line: 239, col: 11, offset: 6059},
																							exprs: []interface{}{
																								&litMatcher{
																									pos:        position{line: 239, col: 11, offset: 6059},
																									val:        "missing",
																									ignoreCase: false,
																									want:       "\"missing\"",
																								},
																								&notExpr{
																									pos: position{line: 239, col: 21, offset: 6069},
																									expr: &charClassMatcher{
																										pos:        position{line: 121, col: 23, offset: 2785},
																										val:        "[_/-A-Za-z0-9]",
																										chars:      []rune{'_', '/', '-'},
																										ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																										ignoreCase: false,
																										inverted:   false,
																									},
																								},
																							},
																						},
																					},
																					&litMatcher{
																						pos:        position{line: 244, col: 10, offset: 6199},
																						val:        "assert",
																						ignoreCase: false,
																						want:       "\"assert\"",
																					},
																					&litMatcher{
																						pos:        position{line: 236, col: 6, offset: 6006},
																						val:        "as",
																						ignoreCase: false,
																						want:       "\"as\"",
																					},
																					&litMatcher{
																						pos:        position{line: 240, col: 12, offset: 6129},
																						val:        "Infinity",
																						ignoreCase: false,
																						want:       "\"Infinity\"",
																					},
																					&litMatcher{
																						pos:        position{line: 241, col: 7, offset: 6148},
																						val:        "NaN",
																						ignoreCase: false,
																						want:       "\"NaN\"",
																					},
																					&litMatcher{
																						pos:        position{line: 238, col: 9, offset: 6039},
																						val:        "merge",
																						ignoreCase: false,
																						want:       "\"merge\"",
																					},
																					&litMatcher{
																						pos:        position{line: 242, col: 8, offset: 6163},
																						val:        "Some",
																						ignoreCase: false,
																						want:       "\"Some\"",
																					},
																					&litMatcher{
																						pos:        position{line: 243, col: 9, offset: 6180},
																						val:        "toMap",
																						ignoreCase: false,
																						want:       "\"toMap\"",
																					},
																					&litMatcher{
																						pos:        position{line: 245, col: 10, offset: 6219},
																						val:        "forall",
																						ignoreCase: false,
																						want:       "\"forall\"",
																					},
																					&litMatcher{
																						pos:        position{line: 245, col: 21, offset: 6230},
																						val:        "∀",
																						ignoreCase: false,
																						want:       "\"∀\"",
																					},
																					&litMatcher{
																						pos:        position{line: 246, col: 8, offset: 6245},
																						val:        "with",
																						ignoreCase: false,
																						want:       "\"with\"",
																					},
																				},
																			},
																			&oneOrMoreExpr{
																				pos: position{line: 122, col: 23, offset: 2824},
																				expr: &charClassMatcher{
																					pos:        position{line: 121, col: 23, offset: 2785},
																					val:        "[_/-A-Za-z0-9]",
																					chars:      []rune{'_', '/', '-'},
																					ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
																&actionExpr{
																	pos: position{line: 123, col: 13, offset: 2888},
																	run: (*parser).callonRecordLiteralNormalEntry47,
																	expr: &seqExpr{
																		pos: position{line: 123, col: 13, offset: 2888},
																		exprs: []interface{}{
																			&notExpr{
																				pos: position{line: 123, col: 13, offset: 2888},
																				expr: &choiceExpr{
																					pos: position{line: 249, col: 5, offset: 6269},
																					alternatives: []interface{}{
																						&litMatcher{
																							pos:        position{line: 231, col: 6, offset: 5936},
																							val:        "if",
																							ignoreCase: false,
																							want:       "\"if\"",
																						},
																						&litMatcher{
																							pos:        position{line: 232, col: 8, offset: 5950},
																							val:        "then",
																							ignoreCase: false,
																							want:       "\"then\"",
																						},
																						&litMatcher{
																							pos:        position{line: 233, col: 8, offset: 5966},
																							val:        "else",
																							ignoreCase: false,
																							want:       "\"else\"",
																						},
																						&litMatcher{
																							pos:        position{line: 234, col: 7, offset: 5981},
																							val:        "let",
																							ignoreCase: false,
																							want:       "\"let\"",
																						},
																						&litMatcher{
																							pos:        position{line: 235, col: 6, offset: 5994},
																							val:        "in",
																							ignoreCase: false,
																							want:       "\"in\"",
																						},
																						&litMatcher{
																							pos:        position{line: 237, col: 9, offset: 6021},
																							val:        "using",
																							ignoreCase: false,
																							want:       "\"using\"",
																						},
																						&actionExpr{
																							pos: position{line: 239, col: 11, offset: 6059},
																							run: (*parser).callonRecordLiteralNormalEntry57,
																							expr: &seqExpr{
																								pos: position{line: 239, col: 11, offset: 6059},
																								exprs: []interface{}{
																									&litMatcher{
																										pos:        position{line: 239, col: 11, offset: 6059},
																										val:        "missing",
																										ignoreCase: false,
																										want:       "\"missing\"",
																									},
																									&notExpr{
																										pos: position{line: 239, col: 21, offset: 6069},
																										expr: &charClassMatcher{
																											pos:        position{line: 121, col: 23, offset: 2785},
																											val:        "[_/-A-Za-z0-9]",
																											chars:      []rune{'_', '/', '-'},
																											ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																											ignoreCase: false,
																											inverted:   false,
																										},
																									},
																								},
																							},
																						},
																						&litMatcher{
																							pos:        position{line: 244, col: 10, offset: 6199},
																							val:        "assert",
																							ignoreCase: false,
																							want:       "\"assert\"",
																						},
																						&litMatcher{
																							pos:        position{line: 236, col: 6, offset: 6006},
																							val:        "as",
																							ignoreCase: false,
																							want:       "\"as\"",
																						},
																						&litMatcher{
																							pos:        position{line: 240, col: 12, offset: 6129},
																							val:        "Infinity",
																							ignoreCase: false,
																							want:       "\"Infinity\"",
																						},
																						&litMatcher{
																							pos:        position{line: 241, col: 7, offset: 6148},
																							val:        "NaN",
																							ignoreCase: false,
																							want:       "\"NaN\"",
																						},
																						&litMatcher{
																							pos:        position{line: 238, col: 9, offset: 6039},
																							val:        "merge",
																							ignoreCase: false,
																							want:       "\"merge\"",
																						},
																						&litMatcher{
																							pos:        position{line: 242, col: 8, offset: 6163},
																							val:        "Some",
																							ignoreCase: false,
																							want:       "\"Some\"",
																						},
																						&litMatcher{
																							pos:        position{line: 243, col: 9, offset: 6180},
																							val:        "toMap",
																							ignoreCase: false,
																							want:       "\"toMap\"",
																						},
																						&litMatcher{
																							pos:        position{line: 245, col: 10, offset: 6219},
																							val:        "forall",
																							ignoreCase: false,
																							want:       "\"forall\"",
																						},
																						&litMatcher{
																							pos:        position{line: 245, col: 21, offset: 6230},
																							val:        "∀",
																							ignoreCase: false,
																							want:       "\"∀\"",
																						},
																						&litMatcher{
																							pos:        position{line: 246, col: 8, offset: 6245},
																							val:        "with",
																							ignoreCase: false,
																							want:       "\"with\"",
																						},
																					},
																				},
																			},
																			&charClassMatcher{
																				pos:        position{line: 120, col: 24, offset: 2751},
																				val:        "[_A-Za-z]",
																				chars:      []rune{'_'},
																				ranges:     []rune{'A', 'Z', 'a', 'z'},
																				ignoreCase: false,
																				inverted:   false,
																			},
																			&zeroOrMoreExpr{
																				pos: position{line: 123, col: 43, offset: 2918},
																				expr: &charClassMatcher{
																					pos:        position{line: 121, col: 23, offset: 2785},
																					val:        "[_/-A-Za-z0-9]",
																					chars:      []rune{'_', '/', '-'},
																					ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
															},
														},
													},
												},
												&actionExpr{
													pos: position{line: 139, col: 29, offset: 3414},
													run: (*parser).callonRecordLiteralNormalEntry75,
													expr: &litMatcher{
														pos:        position{line: 242, col: 8, offset: 6163},
														val:        "Some",
														ignoreCase: false,
														want:       "\"Some\"",
													},
												},
											},
										},
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 733, col: 63, offset: 23173},
							name: "_",
						},
						&litMatcher{
							pos:        position{line: 733, col: 65, offset: 23175},
							val:        "=",
							ignoreCase: false,
							want:       "\"=\"",
						},
						&ruleRefExpr{
							pos:  position{line: 733, col: 69, offset: 23179},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 733, col: 71, offset: 23181},
							label: "expr",
							expr: &ruleRefExpr{
								pos:  position{line: 733, col: 76, offset: 23186},
								name: "Expression",
							},
						},
					},
				},
			},
		},
		{
			name: "UnionType",
			pos:  position{line: 744, col: 1, offset: 23455},
			expr: &choiceExpr{
				pos: position{line: 744, col: 13, offset: 23469},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 744, col: 13, offset: 23469},
						name: "NonEmptyUnionType",
					},
					&actionExpr{
						pos: position{line: 746, col: 18, offset: 23524},
						run: (*parser).callonUnionType3,
						expr: &litMatcher{
							pos:        position{line: 746, col: 18, offset: 23524},
							val:        "",
							ignoreCase: false,
							want:       "\"\"",
						},
					},
				},
			},
		},
		{
			name: "NonEmptyUnionType",
			pos:  position{line: 748, col: 1, offset: 23556},
			expr: &actionExpr{
				pos: position{line: 748, col: 21, offset: 23578},
				run: (*parser).callonNonEmptyUnionType1,
				expr: &seqExpr{
					pos: position{line: 748, col: 21, offset: 23578},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 748, col: 21, offset: 23578},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 748, col: 27, offset: 23584},
								name: "UnionTypeEntry",
							},
						},
						&labeledExpr{
							pos:   position{line: 748, col: 42, offset: 23599},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 748, col: 47, offset: 23604},
								expr: &seqExpr{
									pos: position{line: 748, col: 48, offset: 23605},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 748, col: 48, offset: 23605},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 748, col: 50, offset: 23607},
											val:        "|",
											ignoreCase: false,
											want:       "\"|\"",
										},
										&ruleRefExpr{
											pos:  position{line: 748, col: 54, offset: 23611},
											name: "_",
										},
										&ruleRefExpr{
											pos:  position{line: 748, col: 56, offset: 23613},
											name: "UnionTypeEntry",
										},
									},
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 748, col: 73, offset: 23630},
							expr: &seqExpr{
								pos: position{line: 748, col: 74, offset: 23631},
								exprs: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 748, col: 74, offset: 23631},
										name: "_",
									},
									&litMatcher{
										pos:        position{line: 748, col: 76, offset: 23633},
										val:        "|",
										ignoreCase: false,
										want:       "\"|\"",
									},
								},
							},
						},
					},
				},
			},
		},
		{
			name: "UnionTypeEntry",
			pos:  position{line: 773, col: 1, offset: 24465},
			expr: &seqExpr{
				pos: position{line: 773, col: 18, offset: 24484},
				exprs: []interface{}{
					&choiceExpr{
						pos: position{line: 139, col: 18, offset: 3403},
						alternatives: []interface{}{
							&actionExpr{
								pos: position{line: 131, col: 9, offset: 3119},
								run: (*parser).callonUnionTypeEntry3,
								expr: &seqExpr{
									pos: position{line: 131, col: 9, offset: 3119},
									exprs: []interface{}{
										&litMatcher{
											pos:        position{line: 131, col: 9, offset: 3119},
											val:        "`",
											ignoreCase: false,
											want:       "\"`\"",
										},
										&labeledExpr{
											pos:   position{line: 131, col: 13, offset: 3123},
											label: "label",
											expr: &actionExpr{
												pos: position{line: 129, col: 15, offset: 3060},
												run: (*parser).callonUnionTypeEntry7,
												expr: &zeroOrMoreExpr{
													pos: position{line: 129, col: 15, offset: 3060},
													expr: &charClassMatcher{
														pos:        position{line: 128, col: 19, offset: 3023},
														val:        "[ -_a-~]",
														ranges:     []rune{' ', '_', 'a', '~'},
														ignoreCase: false,
														inverted:   false,
													},
												},
											},
										},
										&litMatcher{
											pos:        position{line: 131, col: 31, offset: 3141},
											val:        "`",
											ignoreCase: false,
											want:       "\"`\"",
										},
									},
								},
							},
							&actionExpr{
								pos: position{line: 132, col: 9, offset: 3175},
								run: (*parser).callonUnionTypeEntry11,
								expr: &labeledExpr{
									pos:   position{line: 132, col: 9, offset: 3175},
									label: "label",
									expr: &choiceExpr{
										pos: position{line: 122, col: 15, offset: 2816},
										alternatives: []interface{}{
											&actionExpr{
												pos: position{line: 122, col: 15, offset: 2816},
												run: (*parser).callonUnionTypeEntry14,
												expr: &seqExpr{
													pos: position{line: 122, col: 15, offset: 2816},
													exprs: []interface{}{
														&choiceExpr{
															pos: position{line: 249, col: 5, offset: 6269},
															alternatives: []interface{}{
																&litMatcher{
																	pos:        position{line: 231, col: 6, offset: 5936},
																	val:        "if",
																	ignoreCase: false,
																	want:       "\"if\"",
																},
																&litMatcher{
																	pos:        position{line: 232, col: 8, offset: 5950},
																	val:        "then",
																	ignoreCase: false,
																	want:       "\"then\"",
																},
																&litMatcher{
																	pos:        position{line: 233, col: 8, offset: 5966},
																	val:        "else",
																	ignoreCase: false,
																	want:       "\"else\"",
																},
																&litMatcher{
																	pos:        position{line: 234, col: 7, offset: 5981},
																	val:        "let",
																	ignoreCase: false,
																	want:       "\"let\"",
																},
																&litMatcher{
																	pos:        position{line: 235, col: 6, offset: 5994},
																	val:        "in",
																	ignoreCase: false,
																	want:       "\"in\"",
																},
																&litMatcher{
																	pos:        position{line: 237, col: 9, offset: 6021},
																	val:        "using",
																	ignoreCase: false,
																	want:       "\"using\"",
																},
																&actionExpr{
																	pos: position{line: 239, col: 11, offset: 6059},
																	run: (*parser).callonUnionTypeEntry23,
																	expr: &seqExpr{
																		pos: position{line: 239, col: 11, offset: 6059},
																		exprs: []interface{}{
																			&litMatcher{
																				pos:        position{line: 239, col: 11, offset: 6059},
																				val:        "missing",
																				ignoreCase: false,
																				want:       "\"missing\"",
																			},
																			&notExpr{
																				pos: position{line: 239, col: 21, offset: 6069},
																				expr: &charClassMatcher{
																					pos:        position{line: 121, col: 23, offset: 2785},
																					val:        "[_/-A-Za-z0-9]",
																					chars:      []rune{'_', '/', '-'},
																					ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																					ignoreCase: false,
																					inverted:   false,
																				},
																			},
																		},
																	},
																},
																&litMatcher{
																	pos:        position{line: 244, col: 10, offset: 6199},
																	val:        "assert",
																	ignoreCase: false,
																	want:       "\"assert\"",
																},
																&litMatcher{
																	pos:        position{line: 236, col: 6, offset: 6006},
																	val:        "as",
																	ignoreCase: false,
																	want:       "\"as\"",
																},
																&litMatcher{
																	pos:        position{line: 240, col: 12, offset: 6129},
																	val:        "Infinity",
																	ignoreCase: false,
																	want:       "\"Infinity\"",
																},
																&litMatcher{
																	pos:        position{line: 241, col: 7, offset: 6148},
																	val:        "NaN",
																	ignoreCase: false,
																	want:       "\"NaN\"",
																},
																&litMatcher{
																	pos:        position{line: 238, col: 9, offset: 6039},
																	val:        "merge",
																	ignoreCase: false,
																	want:       "\"merge\"",
																},
																&litMatcher{
																	pos:        position{line: 242, col: 8, offset: 6163},
																	val:        "Some",
																	ignoreCase: false,
																	want:       "\"Some\"",
																},
																&litMatcher{
																	pos:        position{line: 243, col: 9, offset: 6180},
																	val:        "toMap",
																	ignoreCase: false,
																	want:       "\"toMap\"",
																},
																&litMatcher{
																	pos:        position{line: 245, col: 10, offset: 6219},
																	val:        "forall",
																	ignoreCase: false,
																	want:       "\"forall\"",
																},
																&litMatcher{
																	pos:        position{line: 245, col: 21, offset: 6230},
																	val:        "∀",
																	ignoreCase: false,
																	want:       "\"∀\"",
																},
																&litMatcher{
																	pos:        position{line: 246, col: 8, offset: 6245},
																	val:        "with",
																	ignoreCase: false,
																	want:       "\"with\"",
																},
															},
														},
														&oneOrMoreExpr{
															pos: position{line: 122, col: 23, offset: 2824},
															expr: &charClassMatcher{
																pos:        position{line: 121, col: 23, offset: 2785},
																val:        "[_/-A-Za-z0-9]",
																chars:      []rune{'_', '/', '-'},
																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
											},
											&actionExpr{
												pos: position{line: 123, col: 13, offset: 2888},
												run: (*parser).callonUnionTypeEntry40,
												expr: &seqExpr{
													pos: position{line: 123, col: 13, offset: 2888},
													exprs: []interface{}{
														&notExpr{
															pos: position{line: 123, col: 13, offset: 2888},
															expr: &choiceExpr{
																pos: position{line: 249, col: 5, offset: 6269},
																alternatives: []interface{}{
																	&litMatcher{
																		pos:        position{line: 231, col: 6, offset: 5936},
																		val:        "if",
																		ignoreCase: false,
																		want:       "\"if\"",
																	},
																	&litMatcher{
																		pos:        position{line: 232, col: 8, offset: 5950},
																		val:        "then",
																		ignoreCase: false,
																		want:       "\"then\"",
																	},
																	&litMatcher{
																		pos:        position{line: 233, col: 8, offset: 5966},
																		val:        "else",
																		ignoreCase: false,
																		want:       "\"else\"",
																	},
																	&litMatcher{
																		pos:        position{line: 234, col: 7, offset: 5981},
																		val:        "let",
																		ignoreCase: false,
																		want:       "\"let\"",
																	},
																	&litMatcher{
																		pos:        position{line: 235, col: 6, offset: 5994},
																		val:        "in",
																		ignoreCase: false,
																		want:       "\"in\"",
																	},
																	&litMatcher{
																		pos:        position{line: 237, col: 9, offset: 6021},
																		val:        "using",
																		ignoreCase: false,
																		want:       "\"using\"",
																	},
																	&actionExpr{
																		pos: position{line: 239, col: 11, offset: 6059},
																		run: (*parser).callonUnionTypeEntry50,
																		expr: &seqExpr{
																			pos: position{line: 239, col: 11, offset: 6059},
																			exprs: []interface{}{
																				&litMatcher{
																					pos:        position{line: 239, col: 11, offset: 6059},
																					val:        "missing",
																					ignoreCase: false,
																					want:       "\"missing\"",
																				},
																				&notExpr{
																					pos: position{line: 239, col: 21, offset: 6069},
																					expr: &charClassMatcher{
																						pos:        position{line: 121, col: 23, offset: 2785},
																						val:        "[_/-A-Za-z0-9]",
																						chars:      []rune{'_', '/', '-'},
																						ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																						ignoreCase: false,
																						inverted:   false,
																					},
																				},
																			},
																		},
																	},
																	&litMatcher{
																		pos:        position{line: 244, col: 10, offset: 6199},
																		val:        "assert",
																		ignoreCase: false,
																		want:       "\"assert\"",
																	},
																	&litMatcher{
																		pos:        position{line: 236, col: 6, offset: 6006},
																		val:        "as",
																		ignoreCase: false,
																		want:       "\"as\"",
																	},
																	&litMatcher{
																		pos:        position{line: 240, col: 12, offset: 6129},
																		val:        "Infinity",
																		ignoreCase: false,
																		want:       "\"Infinity\"",
																	},
																	&litMatcher{
																		pos:        position{line: 241, col: 7, offset: 6148},
																		val:        "NaN",
																		ignoreCase: false,
																		want:       "\"NaN\"",
																	},
																	&litMatcher{
																		pos:        position{line: 238, col: 9, offset: 6039},
																		val:        "merge",
																		ignoreCase: false,
																		want:       "\"merge\"",
																	},
																	&litMatcher{
																		pos:        position{line: 242, col: 8, offset: 6163},
																		val:        "Some",
																		ignoreCase: false,
																		want:       "\"Some\"",
																	},
																	&litMatcher{
																		pos:        position{line: 243, col: 9, offset: 6180},
																		val:        "toMap",
																		ignoreCase: false,
																		want:       "\"toMap\"",
																	},
																	&litMatcher{
																		pos:        position{line: 245, col: 10, offset: 6219},
																		val:        "forall",
																		ignoreCase: false,
																		want:       "\"forall\"",
																	},
																	&litMatcher{
																		pos:        position{line: 245, col: 21, offset: 6230},
																		val:        "∀",
																		ignoreCase: false,
																		want:       "\"∀\"",
																	},
																	&litMatcher{
																		pos:        position{line: 246, col: 8, offset: 6245},
																		val:        "with",
																		ignoreCase: false,
																		want:       "\"with\"",
																	},
																},
															},
														},
														&charClassMatcher{
															pos:        position{line: 120, col: 24, offset: 2751},
															val:        "[_A-Za-z]",
															chars:      []rune{'_'},
															ranges:     []rune{'A', 'Z', 'a', 'z'},
															ignoreCase: false,
															inverted:   false,
														},
														&zeroOrMoreExpr{
															pos: position{line: 123, col: 43, offset: 2918},
															expr: &charClassMatcher{
																pos:        position{line: 121, col: 23, offset: 2785},
																val:        "[_/-A-Za-z0-9]",
																chars:      []rune{'_', '/', '-'},
																ranges:     []rune{'A', 'Z', 'a', 'z', '0', '9'},
																ignoreCase: false,
																inverted:   false,
															},
														},
													},
												},
											},
										},
									},
								},
							},
							&actionExpr{
								pos: position{line: 139, col: 29, offset: 3414},
								run: (*parser).callonUnionTypeEntry68,
								expr: &litMatcher{
									pos:        position{line: 242, col: 8, offset: 6163},
									val:        "Some",
									ignoreCase: false,
									want:       "\"Some\"",
								},
							},
						},
					},
					&zeroOrOneExpr{
						pos: position{line: 773, col: 33, offset: 24499},
						expr: &seqExpr{
							pos: position{line: 773, col: 34, offset: 24500},
							exprs: []interface{}{
								&ruleRefExpr{
									pos:  position{line: 773, col: 34, offset: 24500},
									name: "_",
								},
								&litMatcher{
									pos:        position{line: 773, col: 36, offset: 24502},
									val:        ":",
									ignoreCase: false,
									want:       "\":\"",
								},
								&ruleRefExpr{
									pos:  position{line: 773, col: 40, offset: 24506},
									name: "_1",
								},
								&ruleRefExpr{
									pos:  position{line: 773, col: 43, offset: 24509},
									name: "Expression",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "MoreList",
			pos:  position{line: 775, col: 1, offset: 24523},
			expr: &actionExpr{
				pos: position{line: 775, col: 12, offset: 24536},
				run: (*parser).callonMoreList1,
				expr: &seqExpr{
					pos: position{line: 775, col: 12, offset: 24536},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 775, col: 12, offset: 24536},
							val:        ",",
							ignoreCase: false,
							want:       "\",\"",
						},
						&ruleRefExpr{
							pos:  position{line: 775, col: 16, offset: 24540},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 775, col: 18, offset: 24542},
							label: "e",
							expr: &ruleRefExpr{
								pos:  position{line: 775, col: 20, offset: 24544},
								name: "Expression",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 775, col: 31, offset: 24555},
							name: "_",
						},
					},
				},
			},
		},
		{
			name: "NonEmptyListLiteral",
			pos:  position{line: 777, col: 1, offset: 24574},
			expr: &actionExpr{
				pos: position{line: 778, col: 7, offset: 24604},
				run: (*parser).callonNonEmptyListLiteral1,
				expr: &seqExpr{
					pos: position{line: 778, col: 7, offset: 24604},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 778, col: 7, offset: 24604},
							val:        "[",
							ignoreCase: false,
							want:       "\"[\"",
						},
						&ruleRefExpr{
							pos:  position{line: 778, col: 11, offset: 24608},
							name: "_",
						},
						&zeroOrOneExpr{
							pos: position{line: 778, col: 13, offset: 24610},
							expr: &seqExpr{
								pos: position{line: 778, col: 14, offset: 24611},
								exprs: []interface{}{
									&litMatcher{
										pos:        position{line: 778, col: 14, offset: 24611},
										val:        ",",
										ignoreCase: false,
										want:       "\",\"",
									},
									&ruleRefExpr{
										pos:  position{line: 778, col: 18, offset: 24615},
										name: "_",
									},
								},
							},
						},
						&labeledExpr{
							pos:   position{line: 778, col: 22, offset: 24619},
							label: "first",
							expr: &ruleRefExpr{
								pos:  position{line: 778, col: 28, offset: 24625},
								name: "Expression",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 778, col: 39, offset: 24636},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 778, col: 41, offset: 24638},
							label: "rest",
							expr: &zeroOrMoreExpr{
								pos: position{line: 778, col: 46, offset: 24643},
								expr: &ruleRefExpr{
									pos:  position{line: 778, col: 46, offset: 24643},
									name: "MoreList",
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 778, col: 56, offset: 24653},
							expr: &seqExpr{
								pos: position{line: 778, col: 57, offset: 24654},
								exprs: []interface{}{
									&litMatcher{
										pos:        position{line: 778, col: 57, offset: 24654},
										val:        ",",
										ignoreCase: false,
										want:       "\",\"",
									},
									&ruleRefExpr{
										pos:  position{line: 778, col: 61, offset: 24658},
										name: "_",
									},
								},
							},
						},
						&litMatcher{
							pos:        position{line: 778, col: 65, offset: 24662},
							val:        "]",
							ignoreCase: false,
							want:       "\"]\"",
						},
					},
				},
			},
		},
		{
			name: "CompleteExpression",
			pos:  position{line: 788, col: 1, offset: 24929},
			expr: &actionExpr{
				pos: position{line: 788, col: 22, offset: 24952},
				run: (*parser).callonCompleteExpression1,
				expr: &seqExpr{
					pos: position{line: 788, col: 22, offset: 24952},
					exprs: []interface{}{
						&ruleRefExpr{
							pos:  position{line: 788, col: 22, offset: 24952},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 788, col: 24, offset: 24954},
							label: "e",
							expr: &ruleRefExpr{
								pos:  position{line: 788, col: 26, offset: 24956},
								name: "Expression",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 788, col: 37, offset: 24967},
							name: "_",
						},
					},
				},
			},
		},
	},
}

func (c *current) onDhallFile1(e interface{}) (interface{}, error) {
	return e, nil
}

func (p *parser) callonDhallFile1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDhallFile1(stack["e"])
}

func (c *current) onBlockCommentContinue9() (interface{}, error) {
	return []byte{'\n'}, nil
}

func (p *parser) callonBlockCommentContinue9() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onBlockCommentContinue9()
}

func (c *current) onWhitespaceChunk3() (interface{}, error) {
	return []byte{'\n'}, nil
}

func (p *parser) callonWhitespaceChunk3() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onWhitespaceChunk3()
}

func (c *current) onWhitespaceChunk9() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonWhitespaceChunk9() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onWhitespaceChunk9()
}

func (c *current) onWhitespaceChunk14() (interface{}, error) {
	return []byte{'\n'}, nil
}

func (p *parser) callonWhitespaceChunk14() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onWhitespaceChunk14()
}

func (c *current) onWhitespaceChunk5(content interface{}) (interface{}, error) {
	return content, nil
}

func (p *parser) callonWhitespaceChunk5() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onWhitespaceChunk5(stack["content"])
}

func (c *current) onDoubleQuoteChunk9() (interface{}, error) {
	return []byte("\b"), nil
}

func (p *parser) callonDoubleQuoteChunk9() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk9()
}

func (c *current) onDoubleQuoteChunk11() (interface{}, error) {
	return []byte("\f"), nil
}

func (p *parser) callonDoubleQuoteChunk11() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk11()
}

func (c *current) onDoubleQuoteChunk13() (interface{}, error) {
	return []byte("\n"), nil
}

func (p *parser) callonDoubleQuoteChunk13() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk13()
}

func (c *current) onDoubleQuoteChunk15() (interface{}, error) {
	return []byte("\r"), nil
}

func (p *parser) callonDoubleQuoteChunk15() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk15()
}

func (c *current) onDoubleQuoteChunk17() (interface{}, error) {
	return []byte("\t"), nil
}

func (p *parser) callonDoubleQuoteChunk17() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk17()
}

func (c *current) onDoubleQuoteChunk24() (interface{}, error) {
	return parseCodepoint(string(c.text))

}

func (p *parser) callonDoubleQuoteChunk24() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk24()
}

func (c *current) onDoubleQuoteChunk38() (interface{}, error) {
	return parseCodepoint(string(c.text[1 : len(c.text)-1]))

}

func (p *parser) callonDoubleQuoteChunk38() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk38()
}

func (c *current) onDoubleQuoteChunk19(u interface{}) (interface{}, error) {
	return u, nil
}

func (p *parser) callonDoubleQuoteChunk19() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk19(stack["u"])
}

func (c *current) onDoubleQuoteChunk3(e interface{}) (interface{}, error) {
	return e, nil
}

func (p *parser) callonDoubleQuoteChunk3() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteChunk3(stack["e"])
}

func (c *current) onDoubleQuoteLiteral1(chunks interface{}) (interface{}, error) {
	var str strings.Builder
	var outChunks Chunks
	for _, chunk := range chunks.([]interface{}) {
		switch e := chunk.(type) {
		case []byte:
			str.Write(e)
		case Term:
			outChunks = append(outChunks, Chunk{str.String(), e})
			str.Reset()
		default:
			return nil, errors.New("can't happen")
		}
	}
	return TextLit{Chunks: outChunks, Suffix: str.String()}, nil
}

func (p *parser) callonDoubleQuoteLiteral1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDoubleQuoteLiteral1(stack["chunks"])
}

func (c *current) onSingleQuoteContinue6() (interface{}, error) {
	return []byte("''"), nil
}

func (p *parser) callonSingleQuoteContinue6() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSingleQuoteContinue6()
}

func (c *current) onSingleQuoteContinue10() (interface{}, error) {
	return []byte("$\u007b"), nil
}

func (p *parser) callonSingleQuoteContinue10() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSingleQuoteContinue10()
}

func (c *current) onSingleQuoteContinue17() (interface{}, error) {
	return []byte{'\n'}, nil
}

func (p *parser) callonSingleQuoteContinue17() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSingleQuoteContinue17()
}

func (c *current) onSingleQuoteLiteral6() (interface{}, error) {
	return []byte{'\n'}, nil
}

func (p *parser) callonSingleQuoteLiteral6() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSingleQuoteLiteral6()
}

func (c *current) onSingleQuoteLiteral1(content interface{}) (interface{}, error) {
	var str strings.Builder
	var outChunks Chunks
	chunk, ok := content.([]interface{})
	for ; ok; chunk, ok = chunk[1].([]interface{}) {
		switch e := chunk[0].(type) {
		case []byte:
			str.Write(e)
		case Term:
			outChunks = append(outChunks, Chunk{str.String(), e})
			str.Reset()
		default:
			return nil, errors.New("unimplemented")
		}
	}
	return removeLeadingCommonIndent(TextLit{Chunks: outChunks, Suffix: str.String()}), nil
}

func (p *parser) callonSingleQuoteLiteral1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSingleQuoteLiteral1(stack["content"])
}

func (c *current) onInterpolation1(e interface{}) (interface{}, error) {
	return e, nil
}

func (p *parser) callonInterpolation1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onInterpolation1(stack["e"])
}

func (c *current) onIdentifier3() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonIdentifier3() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier3()
}

func (c *current) onIdentifier5() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonIdentifier5() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier5()
}

func (c *current) onIdentifier7() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonIdentifier7() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier7()
}

func (c *current) onIdentifier9() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonIdentifier9() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier9()
}

func (c *current) onIdentifier11() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonIdentifier11() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier11()
}

func (c *current) onIdentifier13() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonIdentifier13() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier13()
}

func (c *current) onIdentifier15() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonIdentifier15() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier15()
}

func (c *current) onIdentifier17() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonIdentifier17() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier17()
}

func (c *current) onIdentifier19() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonIdentifier19() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier19()
}

func (c *current) onIdentifier21() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonIdentifier21() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier21()
}

func (c *current) onIdentifier23() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonIdentifier23() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier23()
}

func (c *current) onIdentifier25() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonIdentifier25() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier25()
}

func (c *current) onIdentifier27() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonIdentifier27() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier27()
}

func (c *current) onIdentifier29() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonIdentifier29() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier29()
}

func (c *current) onIdentifier31() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonIdentifier31() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier31()
}

func (c *current) onIdentifier33() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonIdentifier33() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier33()
}

func (c *current) onIdentifier35() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonIdentifier35() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier35()
}

func (c *current) onIdentifier37() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonIdentifier37() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier37()
}

func (c *current) onIdentifier39() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonIdentifier39() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier39()
}

func (c *current) onIdentifier41() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonIdentifier41() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier41()
}

func (c *current) onIdentifier43() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonIdentifier43() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier43()
}

func (c *current) onIdentifier45() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonIdentifier45() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier45()
}

func (c *current) onIdentifier47() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonIdentifier47() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier47()
}

func (c *current) onIdentifier49() (interface{}, error) {
	return True, nil
}

func (p *parser) callonIdentifier49() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier49()
}

func (c *current) onIdentifier51() (interface{}, error) {
	return False, nil
}

func (p *parser) callonIdentifier51() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier51()
}

func (c *current) onIdentifier53() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonIdentifier53() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier53()
}

func (c *current) onIdentifier55() (interface{}, error) {
	return None, nil
}

func (p *parser) callonIdentifier55() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier55()
}

func (c *current) onIdentifier57() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonIdentifier57() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier57()
}

func (c *current) onIdentifier59() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonIdentifier59() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier59()
}

func (c *current) onIdentifier61() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonIdentifier61() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier61()
}

func (c *current) onIdentifier63() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonIdentifier63() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier63()
}

func (c *current) onIdentifier65() (interface{}, error) {
	return List, nil
}

func (p *parser) callonIdentifier65() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier65()
}

func (c *current) onIdentifier67() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonIdentifier67() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier67()
}

func (c *current) onIdentifier69() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonIdentifier69() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier69()
}

func (c *current) onIdentifier71() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonIdentifier71() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onIdentifier71()
}

func (c *current) onDeBruijn8() (interface{}, error) {
	i, err := strconv.ParseInt(string(c.text), 0, 0)
	return NaturalLit(i), err

}

func (p *parser) callonDeBruijn8() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDeBruijn8()
}

func (c *current) onDeBruijn20() (interface{}, error) {
	return nil, errors.New("Natural literals cannot have leading zeros")
}

func (p *parser) callonDeBruijn20() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDeBruijn20()
}

func (c *current) onDeBruijn25() (interface{}, error) {
	return NaturalLit(0), nil
}

func (p *parser) callonDeBruijn25() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDeBruijn25()
}

func (c *current) onDeBruijn1(index interface{}) (interface{}, error) {
	return int(index.(NaturalLit)), nil
}

func (p *parser) callonDeBruijn1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onDeBruijn1(stack["index"])
}

func (c *current) onVariable10() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonVariable10() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable10()
}

func (c *current) onVariable12() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonVariable12() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable12()
}

func (c *current) onVariable14() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonVariable14() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable14()
}

func (c *current) onVariable16() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonVariable16() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable16()
}

func (c *current) onVariable18() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonVariable18() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable18()
}

func (c *current) onVariable20() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonVariable20() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable20()
}

func (c *current) onVariable22() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonVariable22() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable22()
}

func (c *current) onVariable24() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonVariable24() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable24()
}

func (c *current) onVariable26() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonVariable26() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable26()
}

func (c *current) onVariable28() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonVariable28() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable28()
}

func (c *current) onVariable30() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonVariable30() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable30()
}

func (c *current) onVariable32() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonVariable32() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable32()
}

func (c *current) onVariable34() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonVariable34() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable34()
}

func (c *current) onVariable36() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonVariable36() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable36()
}

func (c *current) onVariable38() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonVariable38() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable38()
}

func (c *current) onVariable40() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonVariable40() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable40()
}

func (c *current) onVariable42() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonVariable42() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable42()
}

func (c *current) onVariable44() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonVariable44() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable44()
}

func (c *current) onVariable46() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonVariable46() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable46()
}

func (c *current) onVariable48() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonVariable48() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable48()
}

func (c *current) onVariable50() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonVariable50() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable50()
}

func (c *current) onVariable52() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonVariable52() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable52()
}

func (c *current) onVariable54() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonVariable54() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable54()
}

func (c *current) onVariable56() (interface{}, error) {
	return True, nil
}

func (p *parser) callonVariable56() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable56()
}

func (c *current) onVariable58() (interface{}, error) {
	return False, nil
}

func (p *parser) callonVariable58() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable58()
}

func (c *current) onVariable60() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonVariable60() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable60()
}

func (c *current) onVariable62() (interface{}, error) {
	return None, nil
}

func (p *parser) callonVariable62() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable62()
}

func (c *current) onVariable64() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonVariable64() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable64()
}

func (c *current) onVariable66() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonVariable66() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable66()
}

func (c *current) onVariable68() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonVariable68() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable68()
}

func (c *current) onVariable70() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonVariable70() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable70()
}

func (c *current) onVariable72() (interface{}, error) {
	return List, nil
}

func (p *parser) callonVariable72() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable72()
}

func (c *current) onVariable74() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonVariable74() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable74()
}

func (c *current) onVariable76() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonVariable76() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable76()
}

func (c *current) onVariable78() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonVariable78() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable78()
}

func (c *current) onVariable87() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonVariable87() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable87()
}

func (c *current) onVariable83(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonVariable83() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable83(stack["label"])
}

func (c *current) onVariable103() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonVariable103() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable103()
}

func (c *current) onVariable94() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonVariable94() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable94()
}

func (c *current) onVariable130() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonVariable130() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable130()
}

func (c *current) onVariable120() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonVariable120() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable120()
}

func (c *current) onVariable91(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonVariable91() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable91(stack["label"])
}

func (c *current) onVariable5(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonVariable5() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable5(stack["label"])
}

func (c *current) onVariable152() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonVariable152() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable152()
}

func (c *current) onVariable154() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonVariable154() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable154()
}

func (c *current) onVariable156() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonVariable156() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable156()
}

func (c *current) onVariable158() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonVariable158() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable158()
}

func (c *current) onVariable160() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonVariable160() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable160()
}

func (c *current) onVariable162() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonVariable162() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable162()
}

func (c *current) onVariable164() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonVariable164() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable164()
}

func (c *current) onVariable166() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonVariable166() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable166()
}

func (c *current) onVariable168() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonVariable168() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable168()
}

func (c *current) onVariable170() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonVariable170() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable170()
}

func (c *current) onVariable172() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonVariable172() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable172()
}

func (c *current) onVariable174() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonVariable174() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable174()
}

func (c *current) onVariable176() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonVariable176() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable176()
}

func (c *current) onVariable178() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonVariable178() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable178()
}

func (c *current) onVariable180() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonVariable180() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable180()
}

func (c *current) onVariable182() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonVariable182() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable182()
}

func (c *current) onVariable184() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonVariable184() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable184()
}

func (c *current) onVariable186() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonVariable186() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable186()
}

func (c *current) onVariable188() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonVariable188() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable188()
}

func (c *current) onVariable190() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonVariable190() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable190()
}

func (c *current) onVariable192() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonVariable192() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable192()
}

func (c *current) onVariable194() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonVariable194() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable194()
}

func (c *current) onVariable196() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonVariable196() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable196()
}

func (c *current) onVariable198() (interface{}, error) {
	return True, nil
}

func (p *parser) callonVariable198() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable198()
}

func (c *current) onVariable200() (interface{}, error) {
	return False, nil
}

func (p *parser) callonVariable200() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable200()
}

func (c *current) onVariable202() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonVariable202() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable202()
}

func (c *current) onVariable204() (interface{}, error) {
	return None, nil
}

func (p *parser) callonVariable204() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable204()
}

func (c *current) onVariable206() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonVariable206() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable206()
}

func (c *current) onVariable208() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonVariable208() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable208()
}

func (c *current) onVariable210() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonVariable210() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable210()
}

func (c *current) onVariable212() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonVariable212() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable212()
}

func (c *current) onVariable214() (interface{}, error) {
	return List, nil
}

func (p *parser) callonVariable214() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable214()
}

func (c *current) onVariable216() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonVariable216() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable216()
}

func (c *current) onVariable218() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonVariable218() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable218()
}

func (c *current) onVariable220() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonVariable220() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable220()
}

func (c *current) onVariable228() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonVariable228() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable228()
}

func (c *current) onVariable224(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonVariable224() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable224(stack["label"])
}

func (c *current) onVariable244() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonVariable244() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable244()
}

func (c *current) onVariable235() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonVariable235() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable235()
}

func (c *current) onVariable271() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonVariable271() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable271()
}

func (c *current) onVariable261() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonVariable261() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable261()
}

func (c *current) onVariable232(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonVariable232() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable232(stack["label"])
}

func (c *current) onVariable148(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonVariable148() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable148(stack["label"])
}

func (c *current) onVariable1(name, index interface{}) (interface{}, error) {
	if index != nil {
		return Var{Name: name.(string), Index: index.(int)}, nil
	} else {
		return Var{Name: name.(string)}, nil
	}
}

func (p *parser) callonVariable1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onVariable1(stack["name"], stack["index"])
}

func (c *current) onHttp28() (interface{}, error) {
	addr := net.ParseIP(string(c.text))
	if addr == nil {
		return nil, errors.New("Malformed IPv6 address")
	}
	return string(c.text), nil
}

func (p *parser) callonHttp28() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onHttp28()
}

func (c *current) onHttp4() (interface{}, error) {
	return url.ParseRequestURI(string(c.text))
}

func (p *parser) callonHttp4() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onHttp4()
}

func (c *current) onHttp1(u, usingClause interface{}) (interface{}, error) {
	if usingClause != nil {
		return NewRemoteFile(u.(*url.URL)), errors.New("dhall-golang does not support ❰using❱ clauses")
	}
	return NewRemoteFile(u.(*url.URL)), nil
}

func (p *parser) callonHttp1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onHttp1(stack["u"], stack["usingClause"])
}

func (c *current) onImportType2() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonImportType2() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType2()
}

func (c *current) onImportType19() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonImportType19() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType19()
}

func (c *current) onImportType15(u interface{}) (interface{}, error) {
	return u, nil
}

func (p *parser) callonImportType15() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType15(stack["u"])
}

func (c *current) onImportType26() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonImportType26() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType26()
}

func (c *current) onImportType22(q interface{}) (interface{}, error) {
	return q, nil
}

func (p *parser) callonImportType22() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType22(stack["q"])
}

func (c *current) onImportType11(cs interface{}) (interface{}, error) {
	// urgh, have to convert []interface{} to []string
	components := make([]string, len(cs.([]interface{})))
	for i, component := range cs.([]interface{}) {
		components[i] = component.(string)
	}
	return path.Join(components...), nil
}

func (p *parser) callonImportType11() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType11(stack["cs"])
}

func (c *current) onImportType7(p interface{}) (interface{}, error) {
	return LocalFile(path.Join("..", p.(string))), nil
}

func (p *parser) callonImportType7() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType7(stack["p"])
}

func (c *current) onImportType42() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonImportType42() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType42()
}

func (c *current) onImportType38(u interface{}) (interface{}, error) {
	return u, nil
}

func (p *parser) callonImportType38() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType38(stack["u"])
}

func (c *current) onImportType49() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonImportType49() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType49()
}

func (c *current) onImportType45(q interface{}) (interface{}, error) {
	return q, nil
}

func (p *parser) callonImportType45() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType45(stack["q"])
}

func (c *current) onImportType34(cs interface{}) (interface{}, error) {
	// urgh, have to convert []interface{} to []string
	components := make([]string, len(cs.([]interface{})))
	for i, component := range cs.([]interface{}) {
		components[i] = component.(string)
	}
	return path.Join(components...), nil
}

func (p *parser) callonImportType34() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType34(stack["cs"])
}

func (c *current) onImportType30(p interface{}) (interface{}, error) {
	return LocalFile(p.(string)), nil
}

func (p *parser) callonImportType30() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType30(stack["p"])
}

func (c *current) onImportType65() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonImportType65() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType65()
}

func (c *current) onImportType61(u interface{}) (interface{}, error) {
	return u, nil
}

func (p *parser) callonImportType61() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType61(stack["u"])
}

func (c *current) onImportType72() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonImportType72() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType72()
}

func (c *current) onImportType68(q interface{}) (interface{}, error) {
	return q, nil
}

func (p *parser) callonImportType68() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType68(stack["q"])
}

func (c *current) onImportType57(cs interface{}) (interface{}, error) {
	// urgh, have to convert []interface{} to []string
	components := make([]string, len(cs.([]interface{})))
	for i, component := range cs.([]interface{}) {
		components[i] = component.(string)
	}
	return path.Join(components...), nil
}

func (p *parser) callonImportType57() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType57(stack["cs"])
}

func (c *current) onImportType53(p interface{}) (interface{}, error) {
	return LocalFile(path.Join("~", p.(string))), nil
}

func (p *parser) callonImportType53() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType53(stack["p"])
}

func (c *current) onImportType86() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonImportType86() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType86()
}

func (c *current) onImportType82(u interface{}) (interface{}, error) {
	return u, nil
}

func (p *parser) callonImportType82() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType82(stack["u"])
}

func (c *current) onImportType93() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonImportType93() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType93()
}

func (c *current) onImportType89(q interface{}) (interface{}, error) {
	return q, nil
}

func (p *parser) callonImportType89() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType89(stack["q"])
}

func (c *current) onImportType78(cs interface{}) (interface{}, error) {
	// urgh, have to convert []interface{} to []string
	components := make([]string, len(cs.([]interface{})))
	for i, component := range cs.([]interface{}) {
		components[i] = component.(string)
	}
	return path.Join(components...), nil
}

func (p *parser) callonImportType78() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType78(stack["cs"])
}

func (c *current) onImportType76(p interface{}) (interface{}, error) {
	return LocalFile(path.Join("/", p.(string))), nil
}

func (p *parser) callonImportType76() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType76(stack["p"])
}

func (c *current) onImportType103() (interface{}, error) {
	return EnvVar(string(c.text)), nil
}

func (p *parser) callonImportType103() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType103()
}

func (c *current) onImportType116() (interface{}, error) {
	return []byte{0x22}, nil
}

func (p *parser) callonImportType116() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType116()
}

func (c *current) onImportType118() (interface{}, error) {
	return []byte{0x5c}, nil
}

func (p *parser) callonImportType118() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType118()
}

func (c *current) onImportType120() (interface{}, error) {
	return []byte{0x07}, nil
}

func (p *parser) callonImportType120() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType120()
}

func (c *current) onImportType122() (interface{}, error) {
	return []byte{0x08}, nil
}

func (p *parser) callonImportType122() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType122()
}

func (c *current) onImportType124() (interface{}, error) {
	return []byte{0x0c}, nil
}

func (p *parser) callonImportType124() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType124()
}

func (c *current) onImportType126() (interface{}, error) {
	return []byte{0x0a}, nil
}

func (p *parser) callonImportType126() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType126()
}

func (c *current) onImportType128() (interface{}, error) {
	return []byte{0x0d}, nil
}

func (p *parser) callonImportType128() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType128()
}

func (c *current) onImportType130() (interface{}, error) {
	return []byte{0x09}, nil
}

func (p *parser) callonImportType130() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType130()
}

func (c *current) onImportType132() (interface{}, error) {
	return []byte{0x0b}, nil
}

func (p *parser) callonImportType132() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType132()
}

func (c *current) onImportType112(v interface{}) (interface{}, error) {
	var b strings.Builder
	for _, c := range v.([]interface{}) {
		_, err := b.Write(c.([]byte))
		if err != nil {
			return nil, err
		}
	}
	return EnvVar(b.String()), nil
}

func (p *parser) callonImportType112() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType112(stack["v"])
}

func (c *current) onImportType108(v interface{}) (interface{}, error) {
	return v, nil
}

func (p *parser) callonImportType108() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType108(stack["v"])
}

func (c *current) onImportType98(v interface{}) (interface{}, error) {
	return v, nil
}

func (p *parser) callonImportType98() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportType98(stack["v"])
}

func (c *current) onImportHashed13() (interface{}, error) {
	out := make([]byte, sha256.Size)
	_, err := hex.Decode(out, c.text)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (p *parser) callonImportHashed13() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportHashed13()
}

func (c *current) onImportHashed9(val interface{}) (interface{}, error) {
	return append([]byte{0x12, 0x20}, val.([]byte)...), nil
}

func (p *parser) callonImportHashed9() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportHashed9(stack["val"])
}

func (c *current) onImportHashed1(i, h interface{}) (interface{}, error) {
	out := ImportHashed{Fetchable: i.(Fetchable)}
	if h != nil {
		out.Hash = h.([]interface{})[1].([]byte)
	}
	return out, nil
}

func (p *parser) callonImportHashed1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportHashed1(stack["i"], stack["h"])
}

func (c *current) onImport2(i interface{}) (interface{}, error) {
	return Import{ImportHashed: i.(ImportHashed), ImportMode: RawText}, nil
}

func (p *parser) callonImport2() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImport2(stack["i"])
}

func (c *current) onImport10(i interface{}) (interface{}, error) {
	return Import{ImportHashed: i.(ImportHashed), ImportMode: Location}, nil
}

func (p *parser) callonImport10() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImport10(stack["i"])
}

func (c *current) onImport18(i interface{}) (interface{}, error) {
	return Import{ImportHashed: i.(ImportHashed), ImportMode: Code}, nil
}

func (p *parser) callonImport18() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImport18(stack["i"])
}

func (c *current) onLetBinding12() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonLetBinding12() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding12()
}

func (c *current) onLetBinding14() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonLetBinding14() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding14()
}

func (c *current) onLetBinding16() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonLetBinding16() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding16()
}

func (c *current) onLetBinding18() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonLetBinding18() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding18()
}

func (c *current) onLetBinding20() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonLetBinding20() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding20()
}

func (c *current) onLetBinding22() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonLetBinding22() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding22()
}

func (c *current) onLetBinding24() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonLetBinding24() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding24()
}

func (c *current) onLetBinding26() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonLetBinding26() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding26()
}

func (c *current) onLetBinding28() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonLetBinding28() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding28()
}

func (c *current) onLetBinding30() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonLetBinding30() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding30()
}

func (c *current) onLetBinding32() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonLetBinding32() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding32()
}

func (c *current) onLetBinding34() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonLetBinding34() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding34()
}

func (c *current) onLetBinding36() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonLetBinding36() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding36()
}

func (c *current) onLetBinding38() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonLetBinding38() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding38()
}

func (c *current) onLetBinding40() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonLetBinding40() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding40()
}

func (c *current) onLetBinding42() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonLetBinding42() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding42()
}

func (c *current) onLetBinding44() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonLetBinding44() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding44()
}

func (c *current) onLetBinding46() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonLetBinding46() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding46()
}

func (c *current) onLetBinding48() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonLetBinding48() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding48()
}

func (c *current) onLetBinding50() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonLetBinding50() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding50()
}

func (c *current) onLetBinding52() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonLetBinding52() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding52()
}

func (c *current) onLetBinding54() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonLetBinding54() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding54()
}

func (c *current) onLetBinding56() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonLetBinding56() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding56()
}

func (c *current) onLetBinding58() (interface{}, error) {
	return True, nil
}

func (p *parser) callonLetBinding58() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding58()
}

func (c *current) onLetBinding60() (interface{}, error) {
	return False, nil
}

func (p *parser) callonLetBinding60() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding60()
}

func (c *current) onLetBinding62() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonLetBinding62() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding62()
}

func (c *current) onLetBinding64() (interface{}, error) {
	return None, nil
}

func (p *parser) callonLetBinding64() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding64()
}

func (c *current) onLetBinding66() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonLetBinding66() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding66()
}

func (c *current) onLetBinding68() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonLetBinding68() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding68()
}

func (c *current) onLetBinding70() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonLetBinding70() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding70()
}

func (c *current) onLetBinding72() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonLetBinding72() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding72()
}

func (c *current) onLetBinding74() (interface{}, error) {
	return List, nil
}

func (p *parser) callonLetBinding74() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding74()
}

func (c *current) onLetBinding76() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonLetBinding76() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding76()
}

func (c *current) onLetBinding78() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonLetBinding78() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding78()
}

func (c *current) onLetBinding80() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonLetBinding80() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding80()
}

func (c *current) onLetBinding89() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLetBinding89() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding89()
}

func (c *current) onLetBinding85(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLetBinding85() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding85(stack["label"])
}

func (c *current) onLetBinding105() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonLetBinding105() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding105()
}

func (c *current) onLetBinding96() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLetBinding96() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding96()
}

func (c *current) onLetBinding132() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonLetBinding132() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding132()
}

func (c *current) onLetBinding122() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonLetBinding122() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding122()
}

func (c *current) onLetBinding93(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLetBinding93() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding93(stack["label"])
}

func (c *current) onLetBinding7(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLetBinding7() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding7(stack["label"])
}

func (c *current) onLetBinding154() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonLetBinding154() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding154()
}

func (c *current) onLetBinding156() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonLetBinding156() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding156()
}

func (c *current) onLetBinding158() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonLetBinding158() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding158()
}

func (c *current) onLetBinding160() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonLetBinding160() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding160()
}

func (c *current) onLetBinding162() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonLetBinding162() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding162()
}

func (c *current) onLetBinding164() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonLetBinding164() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding164()
}

func (c *current) onLetBinding166() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonLetBinding166() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding166()
}

func (c *current) onLetBinding168() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonLetBinding168() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding168()
}

func (c *current) onLetBinding170() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonLetBinding170() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding170()
}

func (c *current) onLetBinding172() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonLetBinding172() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding172()
}

func (c *current) onLetBinding174() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonLetBinding174() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding174()
}

func (c *current) onLetBinding176() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonLetBinding176() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding176()
}

func (c *current) onLetBinding178() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonLetBinding178() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding178()
}

func (c *current) onLetBinding180() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonLetBinding180() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding180()
}

func (c *current) onLetBinding182() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonLetBinding182() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding182()
}

func (c *current) onLetBinding184() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonLetBinding184() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding184()
}

func (c *current) onLetBinding186() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonLetBinding186() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding186()
}

func (c *current) onLetBinding188() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonLetBinding188() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding188()
}

func (c *current) onLetBinding190() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonLetBinding190() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding190()
}

func (c *current) onLetBinding192() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonLetBinding192() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding192()
}

func (c *current) onLetBinding194() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonLetBinding194() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding194()
}

func (c *current) onLetBinding196() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonLetBinding196() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding196()
}

func (c *current) onLetBinding198() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonLetBinding198() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding198()
}

func (c *current) onLetBinding200() (interface{}, error) {
	return True, nil
}

func (p *parser) callonLetBinding200() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding200()
}

func (c *current) onLetBinding202() (interface{}, error) {
	return False, nil
}

func (p *parser) callonLetBinding202() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding202()
}

func (c *current) onLetBinding204() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonLetBinding204() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding204()
}

func (c *current) onLetBinding206() (interface{}, error) {
	return None, nil
}

func (p *parser) callonLetBinding206() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding206()
}

func (c *current) onLetBinding208() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonLetBinding208() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding208()
}

func (c *current) onLetBinding210() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonLetBinding210() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding210()
}

func (c *current) onLetBinding212() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonLetBinding212() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding212()
}

func (c *current) onLetBinding214() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonLetBinding214() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding214()
}

func (c *current) onLetBinding216() (interface{}, error) {
	return List, nil
}

func (p *parser) callonLetBinding216() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding216()
}

func (c *current) onLetBinding218() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonLetBinding218() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding218()
}

func (c *current) onLetBinding220() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonLetBinding220() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding220()
}

func (c *current) onLetBinding222() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonLetBinding222() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding222()
}

func (c *current) onLetBinding230() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLetBinding230() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding230()
}

func (c *current) onLetBinding226(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLetBinding226() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding226(stack["label"])
}

func (c *current) onLetBinding246() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonLetBinding246() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding246()
}

func (c *current) onLetBinding237() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLetBinding237() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding237()
}

func (c *current) onLetBinding273() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonLetBinding273() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding273()
}

func (c *current) onLetBinding263() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonLetBinding263() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding263()
}

func (c *current) onLetBinding234(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLetBinding234() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding234(stack["label"])
}

func (c *current) onLetBinding150(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLetBinding150() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding150(stack["label"])
}

func (c *current) onLetBinding1(label, a, v interface{}) (interface{}, error) {
	if a != nil {
		return Binding{
			Variable:   label.(string),
			Annotation: a.([]interface{})[0].(Term),
			Value:      v.(Term),
		}, nil
	} else {
		return Binding{
			Variable: label.(string),
			Value:    v.(Term),
		}, nil
	}
}

func (p *parser) callonLetBinding1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLetBinding1(stack["label"], stack["a"], stack["v"])
}

func (c *current) onExpression15() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonExpression15() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression15()
}

func (c *current) onExpression17() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonExpression17() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression17()
}

func (c *current) onExpression19() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonExpression19() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression19()
}

func (c *current) onExpression21() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonExpression21() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression21()
}

func (c *current) onExpression23() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonExpression23() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression23()
}

func (c *current) onExpression25() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonExpression25() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression25()
}

func (c *current) onExpression27() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonExpression27() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression27()
}

func (c *current) onExpression29() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonExpression29() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression29()
}

func (c *current) onExpression31() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonExpression31() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression31()
}

func (c *current) onExpression33() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonExpression33() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression33()
}

func (c *current) onExpression35() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonExpression35() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression35()
}

func (c *current) onExpression37() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonExpression37() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression37()
}

func (c *current) onExpression39() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonExpression39() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression39()
}

func (c *current) onExpression41() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonExpression41() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression41()
}

func (c *current) onExpression43() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonExpression43() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression43()
}

func (c *current) onExpression45() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonExpression45() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression45()
}

func (c *current) onExpression47() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonExpression47() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression47()
}

func (c *current) onExpression49() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonExpression49() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression49()
}

func (c *current) onExpression51() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonExpression51() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression51()
}

func (c *current) onExpression53() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonExpression53() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression53()
}

func (c *current) onExpression55() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonExpression55() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression55()
}

func (c *current) onExpression57() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonExpression57() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression57()
}

func (c *current) onExpression59() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonExpression59() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression59()
}

func (c *current) onExpression61() (interface{}, error) {
	return True, nil
}

func (p *parser) callonExpression61() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression61()
}

func (c *current) onExpression63() (interface{}, error) {
	return False, nil
}

func (p *parser) callonExpression63() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression63()
}

func (c *current) onExpression65() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonExpression65() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression65()
}

func (c *current) onExpression67() (interface{}, error) {
	return None, nil
}

func (p *parser) callonExpression67() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression67()
}

func (c *current) onExpression69() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonExpression69() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression69()
}

func (c *current) onExpression71() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonExpression71() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression71()
}

func (c *current) onExpression73() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonExpression73() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression73()
}

func (c *current) onExpression75() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonExpression75() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression75()
}

func (c *current) onExpression77() (interface{}, error) {
	return List, nil
}

func (p *parser) callonExpression77() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression77()
}

func (c *current) onExpression79() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonExpression79() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression79()
}

func (c *current) onExpression81() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonExpression81() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression81()
}

func (c *current) onExpression83() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonExpression83() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression83()
}

func (c *current) onExpression92() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonExpression92() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression92()
}

func (c *current) onExpression88(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression88() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression88(stack["label"])
}

func (c *current) onExpression108() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonExpression108() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression108()
}

func (c *current) onExpression99() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonExpression99() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression99()
}

func (c *current) onExpression135() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonExpression135() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression135()
}

func (c *current) onExpression125() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonExpression125() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression125()
}

func (c *current) onExpression96(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression96() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression96(stack["label"])
}

func (c *current) onExpression10(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression10() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression10(stack["label"])
}

func (c *current) onExpression157() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonExpression157() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression157()
}

func (c *current) onExpression159() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonExpression159() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression159()
}

func (c *current) onExpression161() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonExpression161() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression161()
}

func (c *current) onExpression163() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonExpression163() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression163()
}

func (c *current) onExpression165() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonExpression165() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression165()
}

func (c *current) onExpression167() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonExpression167() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression167()
}

func (c *current) onExpression169() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonExpression169() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression169()
}

func (c *current) onExpression171() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonExpression171() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression171()
}

func (c *current) onExpression173() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonExpression173() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression173()
}

func (c *current) onExpression175() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonExpression175() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression175()
}

func (c *current) onExpression177() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonExpression177() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression177()
}

func (c *current) onExpression179() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonExpression179() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression179()
}

func (c *current) onExpression181() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonExpression181() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression181()
}

func (c *current) onExpression183() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonExpression183() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression183()
}

func (c *current) onExpression185() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonExpression185() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression185()
}

func (c *current) onExpression187() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonExpression187() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression187()
}

func (c *current) onExpression189() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonExpression189() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression189()
}

func (c *current) onExpression191() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonExpression191() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression191()
}

func (c *current) onExpression193() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonExpression193() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression193()
}

func (c *current) onExpression195() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonExpression195() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression195()
}

func (c *current) onExpression197() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonExpression197() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression197()
}

func (c *current) onExpression199() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonExpression199() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression199()
}

func (c *current) onExpression201() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonExpression201() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression201()
}

func (c *current) onExpression203() (interface{}, error) {
	return True, nil
}

func (p *parser) callonExpression203() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression203()
}

func (c *current) onExpression205() (interface{}, error) {
	return False, nil
}

func (p *parser) callonExpression205() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression205()
}

func (c *current) onExpression207() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonExpression207() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression207()
}

func (c *current) onExpression209() (interface{}, error) {
	return None, nil
}

func (p *parser) callonExpression209() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression209()
}

func (c *current) onExpression211() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonExpression211() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression211()
}

func (c *current) onExpression213() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonExpression213() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression213()
}

func (c *current) onExpression215() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonExpression215() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression215()
}

func (c *current) onExpression217() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonExpression217() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression217()
}

func (c *current) onExpression219() (interface{}, error) {
	return List, nil
}

func (p *parser) callonExpression219() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression219()
}

func (c *current) onExpression221() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonExpression221() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression221()
}

func (c *current) onExpression223() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonExpression223() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression223()
}

func (c *current) onExpression225() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonExpression225() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression225()
}

func (c *current) onExpression233() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonExpression233() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression233()
}

func (c *current) onExpression229(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression229() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression229(stack["label"])
}

func (c *current) onExpression249() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonExpression249() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression249()
}

func (c *current) onExpression240() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonExpression240() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression240()
}

func (c *current) onExpression276() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonExpression276() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression276()
}

func (c *current) onExpression266() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonExpression266() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression266()
}

func (c *current) onExpression237(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression237() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression237(stack["label"])
}

func (c *current) onExpression153(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression153() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression153(stack["label"])
}

func (c *current) onExpression2(label, t, body interface{}) (interface{}, error) {
	return Lambda{Label: label.(string), Type: t.(Term), Body: body.(Term)}, nil

}

func (p *parser) callonExpression2() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression2(stack["label"], stack["t"], stack["body"])
}

func (c *current) onExpression308(cond, t, f interface{}) (interface{}, error) {
	return If{cond.(Term), t.(Term), f.(Term)}, nil

}

func (p *parser) callonExpression308() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression308(stack["cond"], stack["t"], stack["f"])
}

func (c *current) onExpression324(bindings, b interface{}) (interface{}, error) {
	bs := make([]Binding, len(bindings.([]interface{})))
	for i, binding := range bindings.([]interface{}) {
		bs[i] = binding.(Binding)
	}
	return NewLet(b.(Term), bs...), nil

}

func (p *parser) callonExpression324() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression324(stack["bindings"], stack["b"])
}

func (c *current) onExpression348() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonExpression348() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression348()
}

func (c *current) onExpression350() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonExpression350() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression350()
}

func (c *current) onExpression352() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonExpression352() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression352()
}

func (c *current) onExpression354() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonExpression354() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression354()
}

func (c *current) onExpression356() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonExpression356() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression356()
}

func (c *current) onExpression358() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonExpression358() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression358()
}

func (c *current) onExpression360() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonExpression360() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression360()
}

func (c *current) onExpression362() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonExpression362() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression362()
}

func (c *current) onExpression364() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonExpression364() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression364()
}

func (c *current) onExpression366() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonExpression366() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression366()
}

func (c *current) onExpression368() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonExpression368() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression368()
}

func (c *current) onExpression370() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonExpression370() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression370()
}

func (c *current) onExpression372() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonExpression372() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression372()
}

func (c *current) onExpression374() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonExpression374() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression374()
}

func (c *current) onExpression376() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonExpression376() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression376()
}

func (c *current) onExpression378() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonExpression378() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression378()
}

func (c *current) onExpression380() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonExpression380() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression380()
}

func (c *current) onExpression382() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonExpression382() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression382()
}

func (c *current) onExpression384() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonExpression384() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression384()
}

func (c *current) onExpression386() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonExpression386() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression386()
}

func (c *current) onExpression388() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonExpression388() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression388()
}

func (c *current) onExpression390() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonExpression390() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression390()
}

func (c *current) onExpression392() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonExpression392() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression392()
}

func (c *current) onExpression394() (interface{}, error) {
	return True, nil
}

func (p *parser) callonExpression394() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression394()
}

func (c *current) onExpression396() (interface{}, error) {
	return False, nil
}

func (p *parser) callonExpression396() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression396()
}

func (c *current) onExpression398() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonExpression398() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression398()
}

func (c *current) onExpression400() (interface{}, error) {
	return None, nil
}

func (p *parser) callonExpression400() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression400()
}

func (c *current) onExpression402() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonExpression402() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression402()
}

func (c *current) onExpression404() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonExpression404() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression404()
}

func (c *current) onExpression406() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonExpression406() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression406()
}

func (c *current) onExpression408() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonExpression408() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression408()
}

func (c *current) onExpression410() (interface{}, error) {
	return List, nil
}

func (p *parser) callonExpression410() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression410()
}

func (c *current) onExpression412() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonExpression412() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression412()
}

func (c *current) onExpression414() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonExpression414() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression414()
}

func (c *current) onExpression416() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonExpression416() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression416()
}

func (c *current) onExpression425() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonExpression425() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression425()
}

func (c *current) onExpression421(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression421() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression421(stack["label"])
}

func (c *current) onExpression441() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonExpression441() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression441()
}

func (c *current) onExpression432() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonExpression432() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression432()
}

func (c *current) onExpression468() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonExpression468() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression468()
}

func (c *current) onExpression458() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonExpression458() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression458()
}

func (c *current) onExpression429(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression429() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression429(stack["label"])
}

func (c *current) onExpression343(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression343() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression343(stack["label"])
}

func (c *current) onExpression490() (interface{}, error) {
	return NaturalFold, nil
}

func (p *parser) callonExpression490() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression490()
}

func (c *current) onExpression492() (interface{}, error) {
	return NaturalBuild, nil
}

func (p *parser) callonExpression492() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression492()
}

func (c *current) onExpression494() (interface{}, error) {
	return NaturalIsZero, nil
}

func (p *parser) callonExpression494() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression494()
}

func (c *current) onExpression496() (interface{}, error) {
	return NaturalEven, nil
}

func (p *parser) callonExpression496() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression496()
}

func (c *current) onExpression498() (interface{}, error) {
	return NaturalOdd, nil
}

func (p *parser) callonExpression498() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression498()
}

func (c *current) onExpression500() (interface{}, error) {
	return NaturalToInteger, nil
}

func (p *parser) callonExpression500() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression500()
}

func (c *current) onExpression502() (interface{}, error) {
	return NaturalShow, nil
}

func (p *parser) callonExpression502() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression502()
}

func (c *current) onExpression504() (interface{}, error) {
	return IntegerToDouble, nil
}

func (p *parser) callonExpression504() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression504()
}

func (c *current) onExpression506() (interface{}, error) {
	return IntegerShow, nil
}

func (p *parser) callonExpression506() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression506()
}

func (c *current) onExpression508() (interface{}, error) {
	return IntegerNegate, nil
}

func (p *parser) callonExpression508() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression508()
}

func (c *current) onExpression510() (interface{}, error) {
	return IntegerClamp, nil
}

func (p *parser) callonExpression510() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression510()
}

func (c *current) onExpression512() (interface{}, error) {
	return NaturalSubtract, nil
}

func (p *parser) callonExpression512() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression512()
}

func (c *current) onExpression514() (interface{}, error) {
	return DoubleShow, nil
}

func (p *parser) callonExpression514() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression514()
}

func (c *current) onExpression516() (interface{}, error) {
	return ListBuild, nil
}

func (p *parser) callonExpression516() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression516()
}

func (c *current) onExpression518() (interface{}, error) {
	return ListFold, nil
}

func (p *parser) callonExpression518() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression518()
}

func (c *current) onExpression520() (interface{}, error) {
	return ListLength, nil
}

func (p *parser) callonExpression520() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression520()
}

func (c *current) onExpression522() (interface{}, error) {
	return ListHead, nil
}

func (p *parser) callonExpression522() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression522()
}

func (c *current) onExpression524() (interface{}, error) {
	return ListLast, nil
}

func (p *parser) callonExpression524() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression524()
}

func (c *current) onExpression526() (interface{}, error) {
	return ListIndexed, nil
}

func (p *parser) callonExpression526() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression526()
}

func (c *current) onExpression528() (interface{}, error) {
	return ListReverse, nil
}

func (p *parser) callonExpression528() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression528()
}

func (c *current) onExpression530() (interface{}, error) {
	return TextShow, nil
}

func (p *parser) callonExpression530() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression530()
}

func (c *current) onExpression532() (interface{}, error) {
	return TextReplace, nil
}

func (p *parser) callonExpression532() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression532()
}

func (c *current) onExpression534() (interface{}, error) {
	return Bool, nil
}

func (p *parser) callonExpression534() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression534()
}

func (c *current) onExpression536() (interface{}, error) {
	return True, nil
}

func (p *parser) callonExpression536() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression536()
}

func (c *current) onExpression538() (interface{}, error) {
	return False, nil
}

func (p *parser) callonExpression538() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression538()
}

func (c *current) onExpression540() (interface{}, error) {
	return Optional, nil
}

func (p *parser) callonExpression540() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression540()
}

func (c *current) onExpression542() (interface{}, error) {
	return None, nil
}

func (p *parser) callonExpression542() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression542()
}

func (c *current) onExpression544() (interface{}, error) {
	return Natural, nil
}

func (p *parser) callonExpression544() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression544()
}

func (c *current) onExpression546() (interface{}, error) {
	return Integer, nil
}

func (p *parser) callonExpression546() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression546()
}

func (c *current) onExpression548() (interface{}, error) {
	return Double, nil
}

func (p *parser) callonExpression548() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression548()
}

func (c *current) onExpression550() (interface{}, error) {
	return Text, nil
}

func (p *parser) callonExpression550() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression550()
}

func (c *current) onExpression552() (interface{}, error) {
	return List, nil
}

func (p *parser) callonExpression552() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression552()
}

func (c *current) onExpression554() (interface{}, error) {
	return Type, nil
}

func (p *parser) callonExpression554() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression554()
}

func (c *current) onExpression556() (interface{}, error) {
	return Kind, nil
}

func (p *parser) callonExpression556() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression556()
}

func (c *current) onExpression558() (interface{}, error) {
	return Sort, nil
}

func (p *parser) callonExpression558() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression558()
}

func (c *current) onExpression566() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonExpression566() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression566()
}

func (c *current) onExpression562(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression562() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression562(stack["label"])
}

func (c *current) onExpression582() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonExpression582() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression582()
}

func (c *current) onExpression573() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonExpression573() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression573()
}

func (c *current) onExpression609() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonExpression609() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression609()
}

func (c *current) onExpression599() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonExpression599() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression599()
}

func (c *current) onExpression570(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression570() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression570(stack["label"])
}

func (c *current) onExpression486(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonExpression486() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression486(stack["label"])
}

func (c *current) onExpression333(label, t, body interface{}) (interface{}, error) {
	return Pi{Label: label.(string), Type: t.(Term), Body: body.(Term)}, nil

}

func (p *parser) callonExpression333() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression333(stack["label"], stack["t"], stack["body"])
}

func (c *current) onExpression641(o, e interface{}) (interface{}, error) {
	return NewAnonPi(o.(Term), e.(Term)), nil
}

func (p *parser) callonExpression641() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression641(stack["o"], stack["e"])
}

func (c *current) onExpression653(h, u, a interface{}) (interface{}, error) {
	return Merge{Handler: h.(Term), Union: u.(Term), Annotation: a.(Term)}, nil

}

func (p *parser) callonExpression653() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression653(stack["h"], stack["u"], stack["a"])
}

func (c *current) onExpression668(e, t interface{}) (interface{}, error) {
	return ToMap{e.(Term), t.(Term)}, nil
}

func (p *parser) callonExpression668() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression668(stack["e"], stack["t"])
}

func (c *current) onExpression679(a interface{}) (interface{}, error) {
	return Assert{Annotation: a.(Term)}, nil
}

func (p *parser) callonExpression679() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onExpression679(stack["a"])
}

func (c *current) onAnnotation1(a interface{}) (interface{}, error) {
	return a, nil
}

func (p *parser) callonAnnotation1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onAnnotation1(stack["a"])
}

func (c *current) onAnnotatedExpression1(e, a interface{}) (interface{}, error) {
	if a == nil {
		return e, nil
	}
	return Annot{e.(Term), a.([]interface{})[1].(Term)}, nil

}

func (p *parser) callonAnnotatedExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onAnnotatedExpression1(stack["e"], stack["a"])
}

func (c *current) onEmptyList1(a interface{}) (interface{}, error) {
	return EmptyList{a.(Term)}, nil
}

func (p *parser) callonEmptyList1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onEmptyList1(stack["a"])
}

func (c *current) onWithExpression1(first, rest interface{}) (interface{}, error) {
	out := first.(Term)
	if rest == nil {
		return out, nil
	}
	for _, b := range rest.([]interface{}) {
		withClause := b.([]interface{})[3].([]interface{})
		path := withClause[0].([]string)
		value := withClause[4].(Term)
		out = With{out, path, value}
	}
	return out, nil

}

func (p *parser) callonWithExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onWithExpression1(stack["first"], stack["rest"])
}

func (c *current) onFieldPath9() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonFieldPath9() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath9()
}

func (c *current) onFieldPath5(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonFieldPath5() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath5(stack["label"])
}

func (c *current) onFieldPath25() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonFieldPath25() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath25()
}

func (c *current) onFieldPath16() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonFieldPath16() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath16()
}

func (c *current) onFieldPath52() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonFieldPath52() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath52()
}

func (c *current) onFieldPath42() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonFieldPath42() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath42()
}

func (c *current) onFieldPath13(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonFieldPath13() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath13(stack["label"])
}

func (c *current) onFieldPath70() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonFieldPath70() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath70()
}

func (c *current) onFieldPath83() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonFieldPath83() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath83()
}

func (c *current) onFieldPath79(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonFieldPath79() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath79(stack["label"])
}

func (c *current) onFieldPath99() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonFieldPath99() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath99()
}

func (c *current) onFieldPath90() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonFieldPath90() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath90()
}

func (c *current) onFieldPath126() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonFieldPath126() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath126()
}

func (c *current) onFieldPath116() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonFieldPath116() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath116()
}

func (c *current) onFieldPath87(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonFieldPath87() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath87(stack["label"])
}

func (c *current) onFieldPath144() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonFieldPath144() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath144()
}

func (c *current) onFieldPath1(first, rest interface{}) (interface{}, error) {
	out := []string{first.(string)}
	if rest == nil {
		return out, nil
	}
	for _, b := range rest.([]interface{}) {
		nextField := b.([]interface{})[3].(string)
		out = append(out, nextField)
	}
	return out, nil
}

func (p *parser) callonFieldPath1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFieldPath1(stack["first"], stack["rest"])
}

func (c *current) onEquivalentExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(EquivOp, first, rest), nil
}

func (p *parser) callonEquivalentExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onEquivalentExpression1(stack["first"], stack["rest"])
}

func (c *current) onImportAltExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(ImportAltOp, first, rest), nil
}

func (p *parser) callonImportAltExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onImportAltExpression1(stack["first"], stack["rest"])
}

func (c *current) onOrExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(OrOp, first, rest), nil
}

func (p *parser) callonOrExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onOrExpression1(stack["first"], stack["rest"])
}

func (c *current) onPlusExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(PlusOp, first, rest), nil
}

func (p *parser) callonPlusExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPlusExpression1(stack["first"], stack["rest"])
}

func (c *current) onTextAppendExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(TextAppendOp, first, rest), nil
}

func (p *parser) callonTextAppendExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onTextAppendExpression1(stack["first"], stack["rest"])
}

func (c *current) onListAppendExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(ListAppendOp, first, rest), nil
}

func (p *parser) callonListAppendExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onListAppendExpression1(stack["first"], stack["rest"])
}

func (c *current) onAndExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(AndOp, first, rest), nil
}

func (p *parser) callonAndExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onAndExpression1(stack["first"], stack["rest"])
}

func (c *current) onCombineExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(RecordMergeOp, first, rest), nil
}

func (p *parser) callonCombineExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onCombineExpression1(stack["first"], stack["rest"])
}

func (c *current) onPreferExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(RightBiasedRecordMergeOp, first, rest), nil
}

func (p *parser) callonPreferExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPreferExpression1(stack["first"], stack["rest"])
}

func (c *current) onCombineTypesExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(RecordTypeMergeOp, first, rest), nil
}

func (p *parser) callonCombineTypesExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onCombineTypesExpression1(stack["first"], stack["rest"])
}

func (c *current) onTimesExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(TimesOp, first, rest), nil
}

func (p *parser) callonTimesExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onTimesExpression1(stack["first"], stack["rest"])
}

func (c *current) onEqualExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(EqOp, first, rest), nil
}

func (p *parser) callonEqualExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onEqualExpression1(stack["first"], stack["rest"])
}

func (c *current) onNotEqualExpression1(first, rest interface{}) (interface{}, error) {
	return parseOperator(NeOp, first, rest), nil
}

func (p *parser) callonNotEqualExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onNotEqualExpression1(stack["first"], stack["rest"])
}

func (c *current) onApplicationExpression1(f, rest interface{}) (interface{}, error) {
	e := f.(Term)
	if rest == nil {
		return e, nil
	}
	for _, arg := range rest.([]interface{}) {
		e = Apply(e, arg.([]interface{})[1].(Term))
	}
	return e, nil

}

func (p *parser) callonApplicationExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onApplicationExpression1(stack["f"], stack["rest"])
}

func (c *current) onFirstApplicationExpression2(h, u interface{}) (interface{}, error) {
	return Merge{Handler: h.(Term), Union: u.(Term)}, nil

}

func (p *parser) callonFirstApplicationExpression2() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFirstApplicationExpression2(stack["h"], stack["u"])
}

func (c *current) onFirstApplicationExpression11(e interface{}) (interface{}, error) {
	return Some{e.(Term)}, nil
}

func (p *parser) callonFirstApplicationExpression11() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFirstApplicationExpression11(stack["e"])
}

func (c *current) onFirstApplicationExpression17(e interface{}) (interface{}, error) {
	return ToMap{Record: e.(Term)}, nil
}

func (p *parser) callonFirstApplicationExpression17() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onFirstApplicationExpression17(stack["e"])
}

func (c *current) onCompletionExpression1(a, b interface{}) (interface{}, error) {
	if b == nil {
		return a, nil
	}
	return Op{OpCode: CompleteOp, L: a.(Term), R: b.([]interface{})[3].(Term)}, nil
}

func (p *parser) callonCompletionExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onCompletionExpression1(stack["a"], stack["b"])
}

func (c *current) onSelectorExpression1(e, ls interface{}) (interface{}, error) {
	expr := e.(Term)
	labels := ls.([]interface{})
	for _, labelSelector := range labels {
		selectorIface := labelSelector.([]interface{})[3]
		switch selector := selectorIface.(type) {
		case string:
			expr = Field{expr, selector}
		case []string:
			expr = Project{expr, selector}
		case Term:
			expr = ProjectType{expr, selector}
		default:
			return nil, errors.New("unimplemented")
		}
	}
	return expr, nil
}

func (p *parser) callonSelectorExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSelectorExpression1(stack["e"], stack["ls"])
}

func (c *current) onSelector6() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonSelector6() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSelector6()
}

func (c *current) onSelector2(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonSelector2() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSelector2(stack["label"])
}

func (c *current) onSelector22() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonSelector22() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSelector22()
}

func (c *current) onSelector13() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonSelector13() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSelector13()
}

func (c *current) onSelector49() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonSelector49() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSelector49()
}

func (c *current) onSelector39() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonSelector39() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSelector39()
}

func (c *current) onSelector10(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonSelector10() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onSelector10(stack["label"])
}

func (c *current) onLabels17() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLabels17() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels17()
}

func (c *current) onLabels13(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLabels13() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels13(stack["label"])
}

func (c *current) onLabels33() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonLabels33() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels33()
}

func (c *current) onLabels24() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLabels24() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels24()
}

func (c *current) onLabels60() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonLabels60() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels60()
}

func (c *current) onLabels50() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonLabels50() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels50()
}

func (c *current) onLabels21(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLabels21() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels21(stack["label"])
}

func (c *current) onLabels78() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLabels78() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels78()
}

func (c *current) onLabels90() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLabels90() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels90()
}

func (c *current) onLabels86(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLabels86() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels86(stack["label"])
}

func (c *current) onLabels106() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonLabels106() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels106()
}

func (c *current) onLabels97() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLabels97() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels97()
}

func (c *current) onLabels133() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonLabels133() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels133()
}

func (c *current) onLabels123() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonLabels123() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels123()
}

func (c *current) onLabels94(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonLabels94() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels94(stack["label"])
}

func (c *current) onLabels151() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonLabels151() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels151()
}

func (c *current) onLabels1(optclauses interface{}) (interface{}, error) {
	if optclauses == nil {
		return []string{}, nil
	}
	clauses := optclauses.([]interface{})
	labels := []string{clauses[0].(string)}
	for _, next := range clauses[2].([]interface{}) {
		labels = append(labels, next.([]interface{})[2].(string))
	}
	return labels, nil
}

func (p *parser) callonLabels1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onLabels1(stack["optclauses"])
}

func (c *current) onTypeSelector1(e interface{}) (interface{}, error) {
	return e, nil
}

func (p *parser) callonTypeSelector1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onTypeSelector1(stack["e"])
}

func (c *current) onPrimitiveExpression3() (interface{}, error) {
	d, err := strconv.ParseFloat(string(c.text), 64)
	if err != nil {
		return nil, err
	}
	return DoubleLit(d), nil
}

func (p *parser) callonPrimitiveExpression3() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression3()
}

func (c *current) onPrimitiveExpression27() (interface{}, error) {
	return DoubleLit(math.Inf(-1)), nil
}

func (p *parser) callonPrimitiveExpression27() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression27()
}

func (c *current) onPrimitiveExpression29() (interface{}, error) {
	return DoubleLit(math.Inf(1)), nil
}

func (p *parser) callonPrimitiveExpression29() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression29()
}

func (c *current) onPrimitiveExpression31() (interface{}, error) {
	return DoubleLit(math.NaN()), nil
}

func (p *parser) callonPrimitiveExpression31() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression31()
}

func (c *current) onPrimitiveExpression33() (interface{}, error) {
	i, err := strconv.ParseInt(string(c.text), 0, 0)
	return NaturalLit(i), err

}

func (p *parser) callonPrimitiveExpression33() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression33()
}

func (c *current) onPrimitiveExpression45() (interface{}, error) {
	return nil, errors.New("Natural literals cannot have leading zeros")
}

func (p *parser) callonPrimitiveExpression45() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression45()
}

func (c *current) onPrimitiveExpression50() (interface{}, error) {
	return NaturalLit(0), nil
}

func (p *parser) callonPrimitiveExpression50() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression50()
}

func (c *current) onPrimitiveExpression57() (interface{}, error) {
	i, err := strconv.ParseInt(string(c.text), 0, 0)
	return NaturalLit(i), err

}

func (p *parser) callonPrimitiveExpression57() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression57()
}

func (c *current) onPrimitiveExpression69() (interface{}, error) {
	return nil, errors.New("Natural literals cannot have leading zeros")
}

func (p *parser) callonPrimitiveExpression69() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression69()
}

func (c *current) onPrimitiveExpression74() (interface{}, error) {
	return NaturalLit(0), nil
}

func (p *parser) callonPrimitiveExpression74() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression74()
}

func (c *current) onPrimitiveExpression52(n interface{}) (interface{}, error) {
	return IntegerLit(n.(NaturalLit)), nil
}

func (p *parser) callonPrimitiveExpression52() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression52(stack["n"])
}

func (c *current) onPrimitiveExpression81() (interface{}, error) {
	i, err := strconv.ParseInt(string(c.text), 0, 0)
	return NaturalLit(i), err

}

func (p *parser) callonPrimitiveExpression81() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression81()
}

func (c *current) onPrimitiveExpression93() (interface{}, error) {
	return nil, errors.New("Natural literals cannot have leading zeros")
}

func (p *parser) callonPrimitiveExpression93() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression93()
}

func (c *current) onPrimitiveExpression98() (interface{}, error) {
	return NaturalLit(0), nil
}

func (p *parser) callonPrimitiveExpression98() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression98()
}

func (c *current) onPrimitiveExpression76(n interface{}) (interface{}, error) {
	return IntegerLit(-(n.(NaturalLit))), nil
}

func (p *parser) callonPrimitiveExpression76() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression76(stack["n"])
}

func (c *current) onPrimitiveExpression101(r interface{}) (interface{}, error) {
	return r, nil
}

func (p *parser) callonPrimitiveExpression101() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression101(stack["r"])
}

func (c *current) onPrimitiveExpression113(u interface{}) (interface{}, error) {
	return u, nil
}

func (p *parser) callonPrimitiveExpression113() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression113(stack["u"])
}

func (c *current) onPrimitiveExpression127(e interface{}) (interface{}, error) {
	return e, nil
}

func (p *parser) callonPrimitiveExpression127() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onPrimitiveExpression127(stack["e"])
}

func (c *current) onRecordTypeOrLiteral5() (interface{}, error) {
	return RecordType{}, nil
}

func (p *parser) callonRecordTypeOrLiteral5() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeOrLiteral5()
}

func (c *current) onEmptyRecordLiteral1() (interface{}, error) {
	return RecordLit{}, nil
}

func (p *parser) callonEmptyRecordLiteral1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onEmptyRecordLiteral1()
}

func (c *current) onMoreRecordType1(f interface{}) (interface{}, error) {
	return f, nil
}

func (p *parser) callonMoreRecordType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onMoreRecordType1(stack["f"])
}

func (c *current) onNonEmptyRecordType1(first, rest interface{}) (interface{}, error) {
	fields := rest.([]interface{})
	content := first.(RecordType)
	for _, field := range fields {
		for k, v := range field.(RecordType) {
			if _, ok := content[k]; ok {
				return nil, fmt.Errorf("Duplicate field %s in record", k)
			}
			content[k] = v
		}
	}
	return content, nil

}

func (p *parser) callonNonEmptyRecordType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onNonEmptyRecordType1(stack["first"], stack["rest"])
}

func (c *current) onRecordTypeEntry9() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordTypeEntry9() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry9()
}

func (c *current) onRecordTypeEntry5(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonRecordTypeEntry5() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry5(stack["label"])
}

func (c *current) onRecordTypeEntry25() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonRecordTypeEntry25() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry25()
}

func (c *current) onRecordTypeEntry16() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordTypeEntry16() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry16()
}

func (c *current) onRecordTypeEntry52() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonRecordTypeEntry52() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry52()
}

func (c *current) onRecordTypeEntry42() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonRecordTypeEntry42() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry42()
}

func (c *current) onRecordTypeEntry13(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonRecordTypeEntry13() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry13(stack["label"])
}

func (c *current) onRecordTypeEntry70() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordTypeEntry70() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry70()
}

func (c *current) onRecordTypeEntry1(name, expr interface{}) (interface{}, error) {
	return RecordType{name.(string): expr.(Term)}, nil
}

func (p *parser) callonRecordTypeEntry1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordTypeEntry1(stack["name"], stack["expr"])
}

func (c *current) onMoreRecordLiteral1(f interface{}) (interface{}, error) {
	return f, nil
}

func (p *parser) callonMoreRecordLiteral1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onMoreRecordLiteral1(stack["f"])
}

func (c *current) onNonEmptyRecordLiteral1(first, rest interface{}) (interface{}, error) {
	fields := rest.([]interface{})
	content := first.(RecordLit)
	for _, field := range fields {
		for k, v := range field.(RecordLit) {
			if _, ok := content[k]; ok {
				content[k] = Op{
					OpCode: RecordMergeOp,
					L:      content[k],
					R:      v,
				}
			} else {
				content[k] = v
			}
		}
	}
	return content, nil

}

func (p *parser) callonNonEmptyRecordLiteral1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onNonEmptyRecordLiteral1(stack["first"], stack["rest"])
}

func (c *current) onRecordLiteralEntry9() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordLiteralEntry9() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry9()
}

func (c *current) onRecordLiteralEntry5(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonRecordLiteralEntry5() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry5(stack["label"])
}

func (c *current) onRecordLiteralEntry25() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonRecordLiteralEntry25() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry25()
}

func (c *current) onRecordLiteralEntry16() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordLiteralEntry16() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry16()
}

func (c *current) onRecordLiteralEntry52() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonRecordLiteralEntry52() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry52()
}

func (c *current) onRecordLiteralEntry42() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonRecordLiteralEntry42() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry42()
}

func (c *current) onRecordLiteralEntry13(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonRecordLiteralEntry13() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry13(stack["label"])
}

func (c *current) onRecordLiteralEntry70() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordLiteralEntry70() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry70()
}

func (c *current) onRecordLiteralEntry1(name, val interface{}) (interface{}, error) {
	if _, ok := val.([]byte); ok {
		// punned entry
		return RecordLit{name.(string): Var{Name: name.(string)}}, nil
	}
	return RecordLit{name.(string): val.(Term)}, nil
}

func (p *parser) callonRecordLiteralEntry1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralEntry1(stack["name"], stack["val"])
}

func (c *current) onRecordLiteralNormalEntry14() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordLiteralNormalEntry14() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry14()
}

func (c *current) onRecordLiteralNormalEntry10(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonRecordLiteralNormalEntry10() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry10(stack["label"])
}

func (c *current) onRecordLiteralNormalEntry30() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonRecordLiteralNormalEntry30() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry30()
}

func (c *current) onRecordLiteralNormalEntry21() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordLiteralNormalEntry21() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry21()
}

func (c *current) onRecordLiteralNormalEntry57() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonRecordLiteralNormalEntry57() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry57()
}

func (c *current) onRecordLiteralNormalEntry47() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonRecordLiteralNormalEntry47() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry47()
}

func (c *current) onRecordLiteralNormalEntry18(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonRecordLiteralNormalEntry18() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry18(stack["label"])
}

func (c *current) onRecordLiteralNormalEntry75() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonRecordLiteralNormalEntry75() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry75()
}

func (c *current) onRecordLiteralNormalEntry1(children, expr interface{}) (interface{}, error) {
	rest := expr.(Term)
	for i := len(children.([]interface{})) - 1; i >= 0; i-- {
		child := children.([]interface{})[i].([]interface{})[3].(string)
		rest = RecordLit{child: rest}
	}
	return rest, nil
}

func (p *parser) callonRecordLiteralNormalEntry1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onRecordLiteralNormalEntry1(stack["children"], stack["expr"])
}

func (c *current) onUnionType3() (interface{}, error) {
	return UnionType{}, nil
}

func (p *parser) callonUnionType3() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionType3()
}

func (c *current) onNonEmptyUnionType1(first, rest interface{}) (interface{}, error) {
	alternatives := make(UnionType)
	first2 := first.([]interface{})
	if first2[1] == nil {
		alternatives[first2[0].(string)] = nil
	} else {
		alternatives[first2[0].(string)] = first2[1].([]interface{})[3].(Term)
	}
	if rest == nil {
		return UnionType(alternatives), nil
	}
	for _, alternativeSyntax := range rest.([]interface{}) {
		alternative := alternativeSyntax.([]interface{})[3].([]interface{})
		name := alternative[0].(string)
		if _, ok := alternatives[name]; ok {
			return nil, fmt.Errorf("Duplicate alternative %s in union", name)
		}

		if alternative[1] == nil {
			alternatives[name] = nil
		} else {
			alternatives[name] = alternative[1].([]interface{})[3].(Term)
		}
	}
	return alternatives, nil
}

func (p *parser) callonNonEmptyUnionType1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onNonEmptyUnionType1(stack["first"], stack["rest"])
}

func (c *current) onUnionTypeEntry7() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonUnionTypeEntry7() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionTypeEntry7()
}

func (c *current) onUnionTypeEntry3(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonUnionTypeEntry3() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionTypeEntry3(stack["label"])
}

func (c *current) onUnionTypeEntry23() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonUnionTypeEntry23() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionTypeEntry23()
}

func (c *current) onUnionTypeEntry14() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonUnionTypeEntry14() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionTypeEntry14()
}

func (c *current) onUnionTypeEntry50() (interface{}, error) {
	return Missing{}, nil
}

func (p *parser) callonUnionTypeEntry50() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionTypeEntry50()
}

func (c *current) onUnionTypeEntry40() (interface{}, error) {
	return string(c.text), nil

}

func (p *parser) callonUnionTypeEntry40() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionTypeEntry40()
}

func (c *current) onUnionTypeEntry11(label interface{}) (interface{}, error) {
	return label, nil
}

func (p *parser) callonUnionTypeEntry11() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionTypeEntry11(stack["label"])
}

func (c *current) onUnionTypeEntry68() (interface{}, error) {
	return string(c.text), nil
}

func (p *parser) callonUnionTypeEntry68() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onUnionTypeEntry68()
}

func (c *current) onMoreList1(e interface{}) (interface{}, error) {
	return e, nil
}

func (p *parser) callonMoreList1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onMoreList1(stack["e"])
}

func (c *current) onNonEmptyListLiteral1(first, rest interface{}) (interface{}, error) {
	exprs := rest.([]interface{})
	content := make(NonEmptyList, len(exprs)+1)
	content[0] = first.(Term)
	for i, expr := range exprs {
		content[i+1] = expr.(Term)
	}
	return content, nil

}

func (p *parser) callonNonEmptyListLiteral1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onNonEmptyListLiteral1(stack["first"], stack["rest"])
}

func (c *current) onCompleteExpression1(e interface{}) (interface{}, error) {
	return e, nil
}

func (p *parser) callonCompleteExpression1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onCompleteExpression1(stack["e"])
}

var (
	// errNoRule is returned when the grammar to parse has no rule.
	errNoRule = errors.New("grammar has no rule")

	// errInvalidEntrypoint is returned when the specified entrypoint rule
	// does not exit.
	errInvalidEntrypoint = errors.New("invalid entrypoint")

	// errInvalidEncoding is returned when the source is not properly
	// utf8-encoded.
	errInvalidEncoding = errors.New("invalid encoding")

	// errMaxExprCnt is used to signal that the maximum number of
	// expressions have been parsed.
	errMaxExprCnt = errors.New("max number of expresssions parsed")
)

// Option is a function that can set an option on the parser. It returns
// the previous setting as an Option.
type Option func(*parser) Option

// MaxExpressions creates an Option to stop parsing after the provided
// number of expressions have been parsed, if the value is 0 then the parser will
// parse for as many steps as needed (possibly an infinite number).
//
// The default for maxExprCnt is 0.
func MaxExpressions(maxExprCnt uint64) Option {
	return func(p *parser) Option {
		oldMaxExprCnt := p.maxExprCnt
		p.maxExprCnt = maxExprCnt
		return MaxExpressions(oldMaxExprCnt)
	}
}

// Entrypoint creates an Option to set the rule name to use as entrypoint.
// The rule name must have been specified in the -alternate-entrypoints
// if generating the parser with the -optimize-grammar flag, otherwise
// it may have been optimized out. Passing an empty string sets the
// entrypoint to the first rule in the grammar.
//
// The default is to start parsing at the first rule in the grammar.
func Entrypoint(ruleName string) Option {
	return func(p *parser) Option {
		oldEntrypoint := p.entrypoint
		p.entrypoint = ruleName
		if ruleName == "" {
			p.entrypoint = g.rules[0].name
		}
		return Entrypoint(oldEntrypoint)
	}
}

// AllowInvalidUTF8 creates an Option to allow invalid UTF-8 bytes.
// Every invalid UTF-8 byte is treated as a utf8.RuneError (U+FFFD)
// by character class matchers and is matched by the any matcher.
// The returned matched value, c.text and c.offset are NOT affected.
//
// The default is false.
func AllowInvalidUTF8(b bool) Option {
	return func(p *parser) Option {
		old := p.allowInvalidUTF8
		p.allowInvalidUTF8 = b
		return AllowInvalidUTF8(old)
	}
}

// Recover creates an Option to set the recover flag to b. When set to
// true, this causes the parser to recover from panics and convert it
// to an error. Setting it to false can be useful while debugging to
// access the full stack trace.
//
// The default is true.
func Recover(b bool) Option {
	return func(p *parser) Option {
		old := p.recover
		p.recover = b
		return Recover(old)
	}
}

// GlobalStore creates an Option to set a key to a certain value in
// the globalStore.
func GlobalStore(key string, value interface{}) Option {
	return func(p *parser) Option {
		old := p.cur.globalStore[key]
		p.cur.globalStore[key] = value
		return GlobalStore(key, old)
	}
}

// ParseFile parses the file identified by filename.
func ParseFile(filename string, opts ...Option) (i interface{}, err error) {
	f, err := os.Open(filename)
	if err != nil {
		return nil, err
	}
	defer func() {
		if closeErr := f.Close(); closeErr != nil {
			err = closeErr
		}
	}()
	return ParseReader(filename, f, opts...)
}

// ParseReader parses the data from r using filename as information in the
// error messages.
func ParseReader(filename string, r io.Reader, opts ...Option) (interface{}, error) {
	b, err := ioutil.ReadAll(r)
	if err != nil {
		return nil, err
	}

	return Parse(filename, b, opts...)
}

// Parse parses the data from b using filename as information in the
// error messages.
func Parse(filename string, b []byte, opts ...Option) (interface{}, error) {
	return newParser(filename, b, opts...).parse(g)
}

// position records a position in the text.
type position struct {
	line, col, offset int
}

func (p position) String() string {
	return strconv.Itoa(p.line) + ":" + strconv.Itoa(p.col) + " [" + strconv.Itoa(p.offset) + "]"
}

// savepoint stores all state required to go back to this point in the
// parser.
type savepoint struct {
	position
	rn rune
	w  int
}

type current struct {
	pos  position // start position of the match
	text []byte   // raw text of the match

	// globalStore is a general store for the user to store arbitrary key-value
	// pairs that they need to manage and that they do not want tied to the
	// backtracking of the parser. This is only modified by the user and never
	// rolled back by the parser. It is always up to the user to keep this in a
	// consistent state.
	globalStore storeDict
}

type storeDict map[string]interface{}

// the AST types...

type grammar struct {
	pos   position
	rules []*rule
}

type rule struct {
	pos         position
	name        string
	displayName string
	expr        interface{}
}

type choiceExpr struct {
	pos          position
	alternatives []interface{}
}

type actionExpr struct {
	pos  position
	expr interface{}
	run  func(*parser) (interface{}, error)
}

type recoveryExpr struct {
	pos          position
	expr         interface{}
	recoverExpr  interface{}
	failureLabel []string
}

type seqExpr struct {
	pos   position
	exprs []interface{}
}

type throwExpr struct {
	pos   position
	label string
}

type labeledExpr struct {
	pos   position
	label string
	expr  interface{}
}

type expr struct {
	pos  position
	expr interface{}
}

type andExpr expr
type notExpr expr
type zeroOrOneExpr expr
type zeroOrMoreExpr expr
type oneOrMoreExpr expr

type ruleRefExpr struct {
	pos  position
	name string
}

type andCodeExpr struct {
	pos position
	run func(*parser) (bool, error)
}

type notCodeExpr struct {
	pos position
	run func(*parser) (bool, error)
}

type litMatcher struct {
	pos        position
	val        string
	ignoreCase bool
	want       string
}

type charClassMatcher struct {
	pos             position
	val             string
	basicLatinChars [128]bool
	chars           []rune
	ranges          []rune
	classes         []*unicode.RangeTable
	ignoreCase      bool
	inverted        bool
}

type anyMatcher position

// errList cumulates the errors found by the parser.
type errList []error

func (e *errList) add(err error) {
	*e = append(*e, err)
}

func (e errList) err() error {
	if len(e) == 0 {
		return nil
	}
	e.dedupe()
	return e
}

func (e *errList) dedupe() {
	var cleaned []error
	set := make(map[string]bool)
	for _, err := range *e {
		if msg := err.Error(); !set[msg] {
			set[msg] = true
			cleaned = append(cleaned, err)
		}
	}
	*e = cleaned
}

func (e errList) Error() string {
	switch len(e) {
	case 0:
		return ""
	case 1:
		return e[0].Error()
	default:
		var buf bytes.Buffer

		for i, err := range e {
			if i > 0 {
				buf.WriteRune('\n')
			}
			buf.WriteString(err.Error())
		}
		return buf.String()
	}
}

// parserError wraps an error with a prefix indicating the rule in which
// the error occurred. The original error is stored in the Inner field.
type parserError struct {
	Inner    error
	pos      position
	prefix   string
	expected []string
}

// Error returns the error message.
func (p *parserError) Error() string {
	return p.prefix + ": " + p.Inner.Error()
}

// newParser creates a parser with the specified input source and options.
func newParser(filename string, b []byte, opts ...Option) *parser {
	stats := Stats{
		ChoiceAltCnt: make(map[string]map[string]int),
	}

	p := &parser{
		filename: filename,
		errs:     new(errList),
		data:     b,
		pt:       savepoint{position: position{line: 1}},
		recover:  true,
		cur: current{
			globalStore: make(storeDict),
		},
		maxFailPos:      position{col: 1, line: 1},
		maxFailExpected: make([]string, 0, 20),
		Stats:           &stats,
		// start rule is rule [0] unless an alternate entrypoint is specified
		entrypoint: g.rules[0].name,
	}
	p.setOptions(opts)

	if p.maxExprCnt == 0 {
		p.maxExprCnt = math.MaxUint64
	}

	return p
}

// setOptions applies the options to the parser.
func (p *parser) setOptions(opts []Option) {
	for _, opt := range opts {
		opt(p)
	}
}

type resultTuple struct {
	v   interface{}
	b   bool
	end savepoint
}

const choiceNoMatch = -1

// Stats stores some statistics, gathered during parsing
type Stats struct {
	// ExprCnt counts the number of expressions processed during parsing
	// This value is compared to the maximum number of expressions allowed
	// (set by the MaxExpressions option).
	ExprCnt uint64

	// ChoiceAltCnt is used to count for each ordered choice expression,
	// which alternative is used how may times.
	// These numbers allow to optimize the order of the ordered choice expression
	// to increase the performance of the parser
	//
	// The outer key of ChoiceAltCnt is composed of the name of the rule as well
	// as the line and the column of the ordered choice.
	// The inner key of ChoiceAltCnt is the number (one-based) of the matching alternative.
	// For each alternative the number of matches are counted. If an ordered choice does not
	// match, a special counter is incremented. The name of this counter is set with
	// the parser option Statistics.
	// For an alternative to be included in ChoiceAltCnt, it has to match at least once.
	ChoiceAltCnt map[string]map[string]int
}

type parser struct {
	filename string
	pt       savepoint
	cur      current

	data []byte
	errs *errList

	depth   int
	recover bool

	// rules table, maps the rule identifier to the rule node
	rules map[string]*rule
	// variables stack, map of label to value
	vstack []map[string]interface{}
	// rule stack, allows identification of the current rule in errors
	rstack []*rule

	// parse fail
	maxFailPos            position
	maxFailExpected       []string
	maxFailInvertExpected bool

	// max number of expressions to be parsed
	maxExprCnt uint64
	// entrypoint for the parser
	entrypoint string

	allowInvalidUTF8 bool

	*Stats

	choiceNoMatch string
	// recovery expression stack, keeps track of the currently available recovery expression, these are traversed in reverse
	recoveryStack []map[string]interface{}
}

// push a variable set on the vstack.
func (p *parser) pushV() {
	if cap(p.vstack) == len(p.vstack) {
		// create new empty slot in the stack
		p.vstack = append(p.vstack, nil)
	} else {
		// slice to 1 more
		p.vstack = p.vstack[:len(p.vstack)+1]
	}

	// get the last args set
	m := p.vstack[len(p.vstack)-1]
	if m != nil && len(m) == 0 {
		// empty map, all good
		return
	}

	m = make(map[string]interface{})
	p.vstack[len(p.vstack)-1] = m
}

// pop a variable set from the vstack.
func (p *parser) popV() {
	// if the map is not empty, clear it
	m := p.vstack[len(p.vstack)-1]
	if len(m) > 0 {
		// GC that map
		p.vstack[len(p.vstack)-1] = nil
	}
	p.vstack = p.vstack[:len(p.vstack)-1]
}

// push a recovery expression with its labels to the recoveryStack
func (p *parser) pushRecovery(labels []string, expr interface{}) {
	if cap(p.recoveryStack) == len(p.recoveryStack) {
		// create new empty slot in the stack
		p.recoveryStack = append(p.recoveryStack, nil)
	} else {
		// slice to 1 more
		p.recoveryStack = p.recoveryStack[:len(p.recoveryStack)+1]
	}

	m := make(map[string]interface{}, len(labels))
	for _, fl := range labels {
		m[fl] = expr
	}
	p.recoveryStack[len(p.recoveryStack)-1] = m
}

// pop a recovery expression from the recoveryStack
func (p *parser) popRecovery() {
	// GC that map
	p.recoveryStack[len(p.recoveryStack)-1] = nil

	p.recoveryStack = p.recoveryStack[:len(p.recoveryStack)-1]
}

func (p *parser) addErr(err error) {
	p.addErrAt(err, p.pt.position, []string{})
}

func (p *parser) addErrAt(err error, pos position, expected []string) {
	var buf bytes.Buffer
	if p.filename != "" {
		buf.WriteString(p.filename)
	}
	if buf.Len() > 0 {
		buf.WriteString(":")
	}
	buf.WriteString(fmt.Sprintf("%d:%d (%d)", pos.line, pos.col, pos.offset))
	if len(p.rstack) > 0 {
		if buf.Len() > 0 {
			buf.WriteString(": ")
		}
		rule := p.rstack[len(p.rstack)-1]
		if rule.displayName != "" {
			buf.WriteString("rule " + rule.displayName)
		} else {
			buf.WriteString("rule " + rule.name)
		}
	}
	pe := &parserError{Inner: err, pos: pos, prefix: buf.String(), expected: expected}
	p.errs.add(pe)
}

func (p *parser) failAt(fail bool, pos position, want string) {
	// process fail if parsing fails and not inverted or parsing succeeds and invert is set
	if fail == p.maxFailInvertExpected {
		if pos.offset < p.maxFailPos.offset {
			return
		}

		if pos.offset > p.maxFailPos.offset {
			p.maxFailPos = pos
			p.maxFailExpected = p.maxFailExpected[:0]
		}

		if p.maxFailInvertExpected {
			want = "!" + want
		}
		p.maxFailExpected = append(p.maxFailExpected, want)
	}
}

// read advances the parser to the next rune.
func (p *parser) read() {
	p.pt.offset += p.pt.w
	rn, n := utf8.DecodeRune(p.data[p.pt.offset:])
	p.pt.rn = rn
	p.pt.w = n
	p.pt.col++
	if rn == '\n' {
		p.pt.line++
		p.pt.col = 0
	}

	if rn == utf8.RuneError && n == 1 { // see utf8.DecodeRune
		if !p.allowInvalidUTF8 {
			p.addErr(errInvalidEncoding)
		}
	}
}

// restore parser position to the savepoint pt.
func (p *parser) restore(pt savepoint) {
	if pt.offset == p.pt.offset {
		return
	}
	p.pt = pt
}

// get the slice of bytes from the savepoint start to the current position.
func (p *parser) sliceFrom(start savepoint) []byte {
	return p.data[start.position.offset:p.pt.position.offset]
}

func (p *parser) buildRulesTable(g *grammar) {
	p.rules = make(map[string]*rule, len(g.rules))
	for _, r := range g.rules {
		p.rules[r.name] = r
	}
}

func (p *parser) parse(g *grammar) (val interface{}, err error) {
	if len(g.rules) == 0 {
		p.addErr(errNoRule)
		return nil, p.errs.err()
	}

	// TODO : not super critical but this could be generated
	p.buildRulesTable(g)

	if p.recover {
		// panic can be used in action code to stop parsing immediately
		// and return the panic as an error.
		defer func() {
			if e := recover(); e != nil {
				val = nil
				switch e := e.(type) {
				case error:
					p.addErr(e)
				default:
					p.addErr(fmt.Errorf("%v", e))
				}
				err = p.errs.err()
			}
		}()
	}

	startRule, ok := p.rules[p.entrypoint]
	if !ok {
		p.addErr(errInvalidEntrypoint)
		return nil, p.errs.err()
	}

	p.read() // advance to first rune
	val, ok = p.parseRule(startRule)
	if !ok {
		if len(*p.errs) == 0 {
			// If parsing fails, but no errors have been recorded, the expected values
			// for the farthest parser position are returned as error.
			maxFailExpectedMap := make(map[string]struct{}, len(p.maxFailExpected))
			for _, v := range p.maxFailExpected {
				maxFailExpectedMap[v] = struct{}{}
			}
			expected := make([]string, 0, len(maxFailExpectedMap))
			eof := false
			if _, ok := maxFailExpectedMap["!."]; ok {
				delete(maxFailExpectedMap, "!.")
				eof = true
			}
			for k := range maxFailExpectedMap {
				expected = append(expected, k)
			}
			sort.Strings(expected)
			if eof {
				expected = append(expected, "EOF")
			}
			p.addErrAt(errors.New("no match found, expected: "+listJoin(expected, ", ", "or")), p.maxFailPos, expected)
		}

		return nil, p.errs.err()
	}
	return val, p.errs.err()
}

func listJoin(list []string, sep string, lastSep string) string {
	switch len(list) {
	case 0:
		return ""
	case 1:
		return list[0]
	default:
		return strings.Join(list[:len(list)-1], sep) + " " + lastSep + " " + list[len(list)-1]
	}
}

func (p *parser) parseRule(rule *rule) (interface{}, bool) {
	p.rstack = append(p.rstack, rule)
	p.pushV()
	val, ok := p.parseExpr(rule.expr)
	p.popV()
	p.rstack = p.rstack[:len(p.rstack)-1]
	return val, ok
}

func (p *parser) parseExpr(expr interface{}) (interface{}, bool) {

	p.ExprCnt++
	if p.ExprCnt > p.maxExprCnt {
		panic(errMaxExprCnt)
	}

	var val interface{}
	var ok bool
	switch expr := expr.(type) {
	case *actionExpr:
		val, ok = p.parseActionExpr(expr)
	case *andCodeExpr:
		val, ok = p.parseAndCodeExpr(expr)
	case *andExpr:
		val, ok = p.parseAndExpr(expr)
	case *anyMatcher:
		val, ok = p.parseAnyMatcher(expr)
	case *charClassMatcher:
		val, ok = p.parseCharClassMatcher(expr)
	case *choiceExpr:
		val, ok = p.parseChoiceExpr(expr)
	case *labeledExpr:
		val, ok = p.parseLabeledExpr(expr)
	case *litMatcher:
		val, ok = p.parseLitMatcher(expr)
	case *notCodeExpr:
		val, ok = p.parseNotCodeExpr(expr)
	case *notExpr:
		val, ok = p.parseNotExpr(expr)
	case *oneOrMoreExpr:
		val, ok = p.parseOneOrMoreExpr(expr)
	case *recoveryExpr:
		val, ok = p.parseRecoveryExpr(expr)
	case *ruleRefExpr:
		val, ok = p.parseRuleRefExpr(expr)
	case *seqExpr:
		val, ok = p.parseSeqExpr(expr)
	case *throwExpr:
		val, ok = p.parseThrowExpr(expr)
	case *zeroOrMoreExpr:
		val, ok = p.parseZeroOrMoreExpr(expr)
	case *zeroOrOneExpr:
		val, ok = p.parseZeroOrOneExpr(expr)
	default:
		panic(fmt.Sprintf("unknown expression type %T", expr))
	}
	return val, ok
}

func (p *parser) parseActionExpr(act *actionExpr) (interface{}, bool) {
	start := p.pt
	val, ok := p.parseExpr(act.expr)
	if ok {
		p.cur.pos = start.position
		p.cur.text = p.sliceFrom(start)
		actVal, err := act.run(p)
		if err != nil {
			p.addErrAt(err, start.position, []string{})
		}

		val = actVal
	}
	return val, ok
}

func (p *parser) parseAndCodeExpr(and *andCodeExpr) (interface{}, bool) {

	ok, err := and.run(p)
	if err != nil {
		p.addErr(err)
	}

	return nil, ok
}

func (p *parser) parseAndExpr(and *andExpr) (interface{}, bool) {
	pt := p.pt
	p.pushV()
	_, ok := p.parseExpr(and.expr)
	p.popV()
	p.restore(pt)

	return nil, ok
}

func (p *parser) parseAnyMatcher(any *anyMatcher) (interface{}, bool) {
	if p.pt.rn == utf8.RuneError && p.pt.w == 0 {
		// EOF - see utf8.DecodeRune
		p.failAt(false, p.pt.position, ".")
		return nil, false
	}
	start := p.pt
	p.read()
	p.failAt(true, start.position, ".")
	return p.sliceFrom(start), true
}

func (p *parser) parseCharClassMatcher(chr *charClassMatcher) (interface{}, bool) {
	cur := p.pt.rn
	start := p.pt

	// can't match EOF
	if cur == utf8.RuneError && p.pt.w == 0 { // see utf8.DecodeRune
		p.failAt(false, start.position, chr.val)
		return nil, false
	}

	if chr.ignoreCase {
		cur = unicode.ToLower(cur)
	}

	// try to match in the list of available chars
	for _, rn := range chr.chars {
		if rn == cur {
			if chr.inverted {
				p.failAt(false, start.position, chr.val)
				return nil, false
			}
			p.read()
			p.failAt(true, start.position, chr.val)
			return p.sliceFrom(start), true
		}
	}

	// try to match in the list of ranges
	for i := 0; i < len(chr.ranges); i += 2 {
		if cur >= chr.ranges[i] && cur <= chr.ranges[i+1] {
			if chr.inverted {
				p.failAt(false, start.position, chr.val)
				return nil, false
			}
			p.read()
			p.failAt(true, start.position, chr.val)
			return p.sliceFrom(start), true
		}
	}

	// try to match in the list of Unicode classes
	for _, cl := range chr.classes {
		if unicode.Is(cl, cur) {
			if chr.inverted {
				p.failAt(false, start.position, chr.val)
				return nil, false
			}
			p.read()
			p.failAt(true, start.position, chr.val)
			return p.sliceFrom(start), true
		}
	}

	if chr.inverted {
		p.read()
		p.failAt(true, start.position, chr.val)
		return p.sliceFrom(start), true
	}
	p.failAt(false, start.position, chr.val)
	return nil, false
}

func (p *parser) parseChoiceExpr(ch *choiceExpr) (interface{}, bool) {
	for altI, alt := range ch.alternatives {
		// dummy assignment to prevent compile error if optimized
		_ = altI

		p.pushV()
		val, ok := p.parseExpr(alt)
		p.popV()
		if ok {
			return val, ok
		}
	}
	return nil, false
}

func (p *parser) parseLabeledExpr(lab *labeledExpr) (interface{}, bool) {
	p.pushV()
	val, ok := p.parseExpr(lab.expr)
	p.popV()
	if ok && lab.label != "" {
		m := p.vstack[len(p.vstack)-1]
		m[lab.label] = val
	}
	return val, ok
}

func (p *parser) parseLitMatcher(lit *litMatcher) (interface{}, bool) {
	start := p.pt
	for _, want := range lit.val {
		cur := p.pt.rn
		if lit.ignoreCase {
			cur = unicode.ToLower(cur)
		}
		if cur != want {
			p.failAt(false, start.position, lit.want)
			p.restore(start)
			return nil, false
		}
		p.read()
	}
	p.failAt(true, start.position, lit.want)
	return p.sliceFrom(start), true
}

func (p *parser) parseNotCodeExpr(not *notCodeExpr) (interface{}, bool) {
	ok, err := not.run(p)
	if err != nil {
		p.addErr(err)
	}

	return nil, !ok
}

func (p *parser) parseNotExpr(not *notExpr) (interface{}, bool) {
	pt := p.pt
	p.pushV()
	p.maxFailInvertExpected = !p.maxFailInvertExpected
	_, ok := p.parseExpr(not.expr)
	p.maxFailInvertExpected = !p.maxFailInvertExpected
	p.popV()
	p.restore(pt)

	return nil, !ok
}

func (p *parser) parseOneOrMoreExpr(expr *oneOrMoreExpr) (interface{}, bool) {
	var vals []interface{}

	for {
		p.pushV()
		val, ok := p.parseExpr(expr.expr)
		p.popV()
		if !ok {
			if len(vals) == 0 {
				// did not match once, no match
				return nil, false
			}
			return vals, true
		}
		vals = append(vals, val)
	}
}

func (p *parser) parseRecoveryExpr(recover *recoveryExpr) (interface{}, bool) {

	p.pushRecovery(recover.failureLabel, recover.recoverExpr)
	val, ok := p.parseExpr(recover.expr)
	p.popRecovery()

	return val, ok
}

func (p *parser) parseRuleRefExpr(ref *ruleRefExpr) (interface{}, bool) {
	if ref.name == "" {
		panic(fmt.Sprintf("%s: invalid rule: missing name", ref.pos))
	}

	rule := p.rules[ref.name]
	if rule == nil {
		p.addErr(fmt.Errorf("undefined rule: %s", ref.name))
		return nil, false
	}
	return p.parseRule(rule)
}

func (p *parser) parseSeqExpr(seq *seqExpr) (interface{}, bool) {
	vals := make([]interface{}, 0, len(seq.exprs))

	pt := p.pt
	for _, expr := range seq.exprs {
		val, ok := p.parseExpr(expr)
		if !ok {
			p.restore(pt)
			return nil, false
		}
		vals = append(vals, val)
	}
	return vals, true
}

func (p *parser) parseThrowExpr(expr *throwExpr) (interface{}, bool) {

	for i := len(p.recoveryStack) - 1; i >= 0; i-- {
		if recoverExpr, ok := p.recoveryStack[i][expr.label]; ok {
			if val, ok := p.parseExpr(recoverExpr); ok {
				return val, ok
			}
		}
	}

	return nil, false
}

func (p *parser) parseZeroOrMoreExpr(expr *zeroOrMoreExpr) (interface{}, bool) {
	var vals []interface{}

	for {
		p.pushV()
		val, ok := p.parseExpr(expr.expr)
		p.popV()
		if !ok {
			return vals, true
		}
		vals = append(vals, val)
	}
}

func (p *parser) parseZeroOrOneExpr(expr *zeroOrOneExpr) (interface{}, bool) {
	p.pushV()
	val, _ := p.parseExpr(expr.expr)
	p.popV()
	// whether it matched or not, consider it a match
	return val, true
}
