// Code generated by goyacc -o datemath.y.go datemath.y. DO NOT EDIT.

//line datemath.y:8
package datemath

import __yyfmt__ "fmt"

//line datemath.y:8

import (
	"fmt"
	"math"
	"time"
)

var epoch = time.Unix(0, 0).In(time.UTC)

// convert a list of significant digits to an integer
// assumes most to least significant
// e.g. 5,2,3 -> 523
func digitsToInt(digits ...int) int {
	n := 0
	for i := range digits {
		n += digits[i] * int(math.Pow10(len(digits)-i-1))
	}
	return n
}

//line datemath.y:34
type yySymType struct {
	yys   int
	i64   int64
	i     int
	unit  timeUnit
	month time.Month

	expression           mathExpression
	anchorDateExpression anchorDateExpression
	timeAdjuster         timeAdjuster
	timeAdjusters        []timeAdjuster

	location *time.Location
	time     time.Time
}

const tNOW = 57346
const tPLUS = 57347
const tMINUS = 57348
const tPIPES = 57349
const tBACKSLASH = 57350
const tTIME_DELIMITER = 57351
const tCOLON = 57352
const tDOT = 57353
const tUNIT = 57354
const tUTC = 57355
const tDIGIT = 57356
const tINVALID_TOKEN = 57357

var yyToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"tNOW",
	"tPLUS",
	"tMINUS",
	"tPIPES",
	"tBACKSLASH",
	"tTIME_DELIMITER",
	"tCOLON",
	"tDOT",
	"tUNIT",
	"tUTC",
	"tDIGIT",
	"tINVALID_TOKEN",
}

var yyStatenames = [...]string{}

const yyEofCode = 1
const yyErrCode = 2
const yyInitialStackSize = 16

//line datemath.y:300

//line yacctab:1
var yyExca = [...]int{
	-1, 1,
	1, -1,
	-2, 0,
}

const yyPrivate = 57344

const yyLast = 65

var yyAct = [...]int{
	14, 6, 17, 16, 4, 12, 63, 62, 61, 60,
	40, 42, 59, 56, 10, 54, 53, 23, 52, 24,
	29, 51, 49, 47, 46, 45, 43, 41, 37, 35,
	39, 34, 32, 30, 27, 22, 19, 36, 28, 55,
	57, 44, 17, 16, 21, 15, 11, 18, 20, 1,
	38, 13, 7, 3, 5, 2, 31, 58, 50, 33,
	9, 48, 8, 26, 25,
}

var yyPact = [...]int{
	0, -1000, -1000, 39, 37, 38, -1000, 22, 42, 34,
	21, 37, -1000, 37, 20, 26, -1000, -1000, 19, -1000,
	18, 17, 15, -1000, -1000, 25, 14, -1000, -1000, -3,
	13, 5, 12, 31, 11, 10, -1000, -1000, -1000, 9,
	-1000, -1000, 8, -1000, 7, -1000, 4, 2, -1000, 1,
	28, -1, -1000, 30, -1000, -2, -1000, -5, -1000, -6,
	-7, -8, -1000, -1000,
}

var yyPgo = [...]int{
	0, 0, 64, 63, 62, 61, 60, 59, 58, 57,
	56, 55, 54, 1, 53, 52, 5, 51, 50, 49,
}

var yyR1 = [...]int{
	0, 19, 11, 11, 11, 11, 11, 14, 14, 14,
	14, 18, 18, 18, 12, 12, 12, 13, 13, 13,
	13, 4, 10, 5, 6, 7, 8, 9, 9, 9,
	16, 16, 17, 17, 1, 1, 2, 2, 3, 3,
	15, 15,
}

var yyR2 = [...]int{
	0, 1, 1, 2, 3, 1, 2, 1, 1, 4,
	1, 0, 6, 1, 1, 3, 5, 1, 3, 5,
	7, 4, 2, 2, 2, 2, 2, 1, 2, 3,
	2, 1, 3, 2, 1, 1, 0, 1, 1, 2,
	5, 2,
}

var yyChk = [...]int{
	-1000, -19, -11, -14, 4, -12, -13, -15, -4, -6,
	14, 7, -16, -17, -1, 8, 6, 5, 9, 14,
	6, 10, 14, -16, -16, -2, -3, 14, 12, -13,
	14, -10, 14, -7, 14, 14, 12, 14, -18, -1,
	13, 14, 6, 14, 10, 14, 14, 14, -5, 14,
	-8, 14, 14, 14, 14, 11, 14, 10, -9, 14,
	14, 14, 14, 14,
}

var yyDef = [...]int{
	0, -2, 1, 2, 5, 7, 8, 10, 14, 17,
	0, 3, 6, 31, 36, 0, 34, 35, 0, 41,
	0, 0, 24, 4, 30, 0, 37, 38, 33, 11,
	0, 15, 0, 18, 0, 0, 32, 39, 9, 0,
	13, 24, 0, 22, 0, 25, 21, 0, 16, 0,
	19, 0, 40, 0, 23, 0, 26, 0, 20, 27,
	0, 28, 12, 29,
}

var yyTok1 = [...]int{
	1,
}

var yyTok2 = [...]int{
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15,
}

var yyTok3 = [...]int{
	0,
}

var yyErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{
	{1, 15, "invalid token"},
}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	yyDebug        = 0
	yyErrorVerbose = false
)

type yyLexer interface {
	Lex(lval *yySymType) int
	Error(s string)
}

type yyParser interface {
	Parse(yyLexer) int
	Lookahead() int
}

type yyParserImpl struct {
	lval  yySymType
	stack [yyInitialStackSize]yySymType
	char  int
}

func (p *yyParserImpl) Lookahead() int {
	return p.char
}

func yyNewParser() yyParser {
	return &yyParserImpl{}
}

const yyFlag = -1000

func yyTokname(c int) string {
	if c >= 1 && c-1 < len(yyToknames) {
		if yyToknames[c-1] != "" {
			return yyToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func yyStatname(s int) string {
	if s >= 0 && s < len(yyStatenames) {
		if yyStatenames[s] != "" {
			return yyStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func yyErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !yyErrorVerbose {
		return "syntax error"
	}

	for _, e := range yyErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + yyTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := yyPact[state]
	for tok := TOKSTART; tok-1 < len(yyToknames); tok++ {
		if n := base + tok; n >= 0 && n < yyLast && yyChk[yyAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if yyDef[state] == -2 {
		i := 0
		for yyExca[i] != -1 || yyExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; yyExca[i] >= 0; i += 2 {
			tok := yyExca[i]
			if tok < TOKSTART || yyExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if yyExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += yyTokname(tok)
	}
	return res
}

func yylex1(lex yyLexer, lval *yySymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = yyTok1[0]
		goto out
	}
	if char < len(yyTok1) {
		token = yyTok1[char]
		goto out
	}
	if char >= yyPrivate {
		if char < yyPrivate+len(yyTok2) {
			token = yyTok2[char-yyPrivate]
			goto out
		}
	}
	for i := 0; i < len(yyTok3); i += 2 {
		token = yyTok3[i+0]
		if token == char {
			token = yyTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = yyTok2[1] /* unknown char */
	}
	if yyDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", yyTokname(token), uint(char))
	}
	return char, token
}

func yyParse(yylex yyLexer) int {
	return yyNewParser().Parse(yylex)
}

func (yyrcvr *yyParserImpl) Parse(yylex yyLexer) int {
	var yyn int
	var yyVAL yySymType
	var yyDollar []yySymType
	_ = yyDollar // silence set and not used
	yyS := yyrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	yystate := 0
	yyrcvr.char = -1
	yytoken := -1 // yyrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		yystate = -1
		yyrcvr.char = -1
		yytoken = -1
	}()
	yyp := -1
	goto yystack

ret0:
	return 0

ret1:
	return 1

yystack:
	/* put a state and value onto the stack */
	if yyDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", yyTokname(yytoken), yyStatname(yystate))
	}

	yyp++
	if yyp >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyS[yyp] = yyVAL
	yyS[yyp].yys = yystate

yynewstate:
	yyn = yyPact[yystate]
	if yyn <= yyFlag {
		goto yydefault /* simple state */
	}
	if yyrcvr.char < 0 {
		yyrcvr.char, yytoken = yylex1(yylex, &yyrcvr.lval)
	}
	yyn += yytoken
	if yyn < 0 || yyn >= yyLast {
		goto yydefault
	}
	yyn = yyAct[yyn]
	if yyChk[yyn] == yytoken { /* valid shift */
		yyrcvr.char = -1
		yytoken = -1
		yyVAL = yyrcvr.lval
		yystate = yyn
		if Errflag > 0 {
			Errflag--
		}
		goto yystack
	}

yydefault:
	/* default state action */
	yyn = yyDef[yystate]
	if yyn == -2 {
		if yyrcvr.char < 0 {
			yyrcvr.char, yytoken = yylex1(yylex, &yyrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if yyExca[xi+0] == -1 && yyExca[xi+1] == yystate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			yyn = yyExca[xi+0]
			if yyn < 0 || yyn == yytoken {
				break
			}
		}
		yyn = yyExca[xi+1]
		if yyn < 0 {
			goto ret0
		}
	}
	if yyn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			yylex.Error(yyErrorMessage(yystate, yytoken))
			Nerrs++
			if yyDebug >= 1 {
				__yyfmt__.Printf("%s", yyStatname(yystate))
				__yyfmt__.Printf(" saw %s\n", yyTokname(yytoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for yyp >= 0 {
				yyn = yyPact[yyS[yyp].yys] + yyErrCode
				if yyn >= 0 && yyn < yyLast {
					yystate = yyAct[yyn] /* simulate a shift of "error" */
					if yyChk[yystate] == yyErrCode {
						goto yystack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if yyDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", yyS[yyp].yys)
				}
				yyp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if yyDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", yyTokname(yytoken))
			}
			if yytoken == yyEofCode {
				goto ret1
			}
			yyrcvr.char = -1
			yytoken = -1
			goto yynewstate /* try again in the same state */
		}
	}

	/* reduction by production yyn */
	if yyDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", yyn, yyStatname(yystate))
	}

	yynt := yyn
	yypt := yyp
	_ = yypt // guard against "declared and not used"

	yyp -= yyR2[yyn]
	// yyp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if yyp+1 >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyVAL = yyS[yyp+1]

	/* consult goto table to find next state */
	yyn = yyR1[yyn]
	yyg := yyPgo[yyn]
	yyj := yyg + yyS[yyp].yys + 1

	if yyj >= yyLast {
		yystate = yyAct[yyg]
	} else {
		yystate = yyAct[yyj]
		if yyChk[yystate] != -yyn {
			yystate = yyAct[yyg]
		}
	}
	// dummy call; replaced with literal code
	switch yynt {

	case 1:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:65
		{ // last rule; assign the evaluated time so we can use use it later
			yylex.(*lexerWrapper).expression = yyDollar[1].expression
		}
	case 2:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:77
		{
			yyVAL.expression = newMathExpression(anchorDate(yyDollar[1].time), nil)
		}
	case 3:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:80
		{
			yyVAL.expression = newMathExpression(anchorDate(yyDollar[1].time), nil)
		}
	case 4:
		yyDollar = yyS[yypt-3 : yypt+1]
//line datemath.y:83
		{
			yyVAL.expression = newMathExpression(anchorDate(yyDollar[1].time), yyDollar[3].timeAdjusters)
		}
	case 5:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:86
		{
			yyVAL.expression = newMathExpression(anchorDateNow, nil)
		}
	case 6:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:89
		{
			yyVAL.expression = newMathExpression(anchorDateNow, yyDollar[2].timeAdjusters)
		}
	case 7:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:103
		{
			yyVAL.time = yyDollar[1].time
		}
	case 8:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:107
		{
			yyVAL.time = yyDollar[1].time
		}
	case 9:
		yyDollar = yyS[yypt-4 : yypt+1]
//line datemath.y:111
		{
			yyVAL.time = time.Date(yyDollar[1].time.Year(), yyDollar[1].time.Month(), yyDollar[1].time.Day(), yyDollar[3].time.Hour(), yyDollar[3].time.Minute(), yyDollar[3].time.Second(), yyDollar[3].time.Nanosecond(), yyDollar[4].location)
		}
	case 10:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:115
		{
			yyVAL.time = time.Unix(yyDollar[1].i64/1000, yyDollar[1].i64%1000*1000000)
		}
	case 11:
		yyDollar = yyS[yypt-0 : yypt+1]
//line datemath.y:121
		{
			yyVAL.location = missingTimeZone
		}
	case 12:
		yyDollar = yyS[yypt-6 : yypt+1]
//line datemath.y:125
		{ /* support +/-09:00 style timezone specifiers */
			yyVAL.location = time.FixedZone("$1$2$3:$5$6", yyDollar[1].i*(((yyDollar[2].i*10+yyDollar[3].i)*60*60)+((yyDollar[5].i*10+yyDollar[6].i)*60)))
		}
	case 13:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:129
		{ /* Z */
			yyVAL.location = time.UTC
		}
	case 14:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:135
		{
			yyVAL.time = time.Date(yyDollar[1].i, 1, 1, 0, 0, 0, 0, missingTimeZone)
		}
	case 15:
		yyDollar = yyS[yypt-3 : yypt+1]
//line datemath.y:139
		{
			yyVAL.time = time.Date(yyDollar[1].i, yyDollar[3].month, 1, 0, 0, 0, 0, missingTimeZone)
		}
	case 16:
		yyDollar = yyS[yypt-5 : yypt+1]
//line datemath.y:143
		{
			if yyDollar[5].i > daysIn(yyDollar[3].month, yyDollar[1].i) {
				yylex.Error(fmt.Sprintf("day %d out of bounds for month %d", yyDollar[5].i, yyDollar[3].month))
			}
			yyVAL.time = time.Date(yyDollar[1].i, yyDollar[3].month, yyDollar[5].i, 0, 0, 0, 0, missingTimeZone)
		}
	case 17:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:153
		{
			yyVAL.time = time.Date(epoch.Year(), epoch.Month(), epoch.Day(), yyDollar[1].i, 0, 0, 0, missingTimeZone)
		}
	case 18:
		yyDollar = yyS[yypt-3 : yypt+1]
//line datemath.y:157
		{
			yyVAL.time = time.Date(epoch.Year(), epoch.Month(), epoch.Day(), yyDollar[1].i, yyDollar[3].i, 0, 0, missingTimeZone)
		}
	case 19:
		yyDollar = yyS[yypt-5 : yypt+1]
//line datemath.y:161
		{
			yyVAL.time = time.Date(epoch.Year(), epoch.Month(), epoch.Day(), yyDollar[1].i, yyDollar[3].i, yyDollar[5].i, 0, missingTimeZone)
		}
	case 20:
		yyDollar = yyS[yypt-7 : yypt+1]
//line datemath.y:165
		{
			yyVAL.time = time.Date(epoch.Year(), epoch.Month(), epoch.Day(), yyDollar[1].i, yyDollar[3].i, yyDollar[5].i, yyDollar[7].i, missingTimeZone)
		}
	case 21:
		yyDollar = yyS[yypt-4 : yypt+1]
//line datemath.y:171
		{
			yyVAL.i = digitsToInt(yyDollar[1].i, yyDollar[2].i, yyDollar[3].i, yyDollar[4].i)
		}
	case 22:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:177
		{
			yyVAL.month = time.Month(digitsToInt(yyDollar[1].i, yyDollar[2].i))
			if yyVAL.month > 12 {
				yylex.Error(fmt.Sprintf("month out of bounds %d", yyVAL.month))
			}
		}
	case 23:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:186
		{
			// range validated in `date`
			yyVAL.i = digitsToInt(yyDollar[1].i, yyDollar[2].i)
		}
	case 24:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:193
		{
			yyVAL.i = digitsToInt(yyDollar[1].i, yyDollar[2].i)
			if yyVAL.i > 23 {
				yylex.Error(fmt.Sprintf("hours out of bounds %d", yyVAL.i))
			}
		}
	case 25:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:202
		{
			yyVAL.i = digitsToInt(yyDollar[1].i, yyDollar[2].i)
			if yyVAL.i > 59 {
				yylex.Error(fmt.Sprintf("minutes out of bounds %d", yyVAL.i))
			}
		}
	case 26:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:211
		{
			yyVAL.i = digitsToInt(yyDollar[1].i, yyDollar[2].i)
			if yyVAL.i > 59 {
				yylex.Error(fmt.Sprintf("seconds out of bounds %d", yyVAL.i))
			}
		}
	case 27:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:221
		{
			yyVAL.i = yyDollar[1].i * 100000000
		}
	case 28:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:225
		{
			yyVAL.i = digitsToInt(yyDollar[1].i, yyDollar[2].i) * 10000000
		}
	case 29:
		yyDollar = yyS[yypt-3 : yypt+1]
//line datemath.y:229
		{
			yyVAL.i = digitsToInt(yyDollar[1].i, yyDollar[2].i, yyDollar[3].i) * 1000000
		}
	case 30:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:236
		{
			yyVAL.timeAdjusters = append([]timeAdjuster{yyDollar[1].timeAdjuster}, yyDollar[2].timeAdjusters...)
			/*f, g := $1, $2 // bind to local scope*/
			/*$$ = func(t time.Time) time.Time {*/
			/*return g(f(t))*/
			/*}*/
		}
	case 31:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:244
		{
			yyVAL.timeAdjusters = []timeAdjuster{yyDollar[1].timeAdjuster}
		}
	case 32:
		yyDollar = yyS[yypt-3 : yypt+1]
//line datemath.y:250
		{ /* add units; e.g. +15m */
			yyVAL.timeAdjuster = addUnits(yyDollar[1].i*yyDollar[2].i, yyDollar[3].unit)
		}
	case 33:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:254
		{ /* truncate to specified unit: e.g. /d */
			yyVAL.timeAdjuster = truncateUnits(yyDollar[2].unit)
		}
	case 34:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:260
		{
			yyVAL.i = -1
		}
	case 35:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:264
		{
			yyVAL.i = 1
		}
	case 36:
		yyDollar = yyS[yypt-0 : yypt+1]
//line datemath.y:270
		{ /* default to 1 if no integer specified */
			yyVAL.i = 1
		}
	case 37:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:274
		{
			yyVAL.i = yyDollar[1].i
		}
	case 38:
		yyDollar = yyS[yypt-1 : yypt+1]
//line datemath.y:280
		{
			yyVAL.i = yyDollar[1].i
		}
	case 39:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:284
		{
			yyVAL.i = yyDollar[1].i*10 + yyDollar[2].i
		}
	case 40:
		yyDollar = yyS[yypt-5 : yypt+1]
//line datemath.y:291
		{
			yyVAL.i64 = int64(digitsToInt(yyDollar[1].i, yyDollar[2].i, yyDollar[3].i, yyDollar[4].i, yyDollar[5].i))
		}
	case 41:
		yyDollar = yyS[yypt-2 : yypt+1]
//line datemath.y:295
		{
			yyVAL.i64 = yyDollar[1].i64*10 + int64(yyDollar[2].i)
		}
	}
	goto yystack /* stack new state and value */
}
