// This example sends an OPTIONS request over TCP (or TLS).
package main

import (
	sipgo "github.com/emiago/sipgo/sip"
	"github.com/vulncheck-oss/go-exploit/output"
	"github.com/vulncheck-oss/go-exploit/protocol"
	"github.com/vulncheck-oss/go-exploit/protocol/sip"
)

const (
	host   = "127.0.0.1"
	useTLS = true
)

func main() {
	transport := sip.TCP
	if useTLS {
		transport = sip.TLS
	}
	port := sip.DefaultPorts[transport]
	conn, ok := protocol.MixedConnect(host, port, useTLS)
	if !ok {
		output.PrintfFrameworkError("Connecting to server %s:%d", host, port)

		return
	}
	defer conn.Close()
	reqOpts := sip.NewSipRequestOpts{
		Port:      port,
		Transport: transport,
	}
	req, ok := sip.NewSipRequest(sipgo.OPTIONS, host, &reqOpts)
	if !ok {
		output.PrintfFrameworkError("Creating request to %s with options %+v", host, reqOpts)

		return
	}
	resp, ok := sip.SendAndReceiveTCP(conn, req)
	if ok {
		output.PrintfFrameworkSuccess("Response: %s", resp.String())
	} else {
		output.PrintfFrameworkError("Sending request %s", req.String())
	}
}
