// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package walletobjects provides access to the Google Wallet API.
//
// For product documentation, see: https://developers.google.com/pay/passes
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/walletobjects/v1"
//	...
//	ctx := context.Background()
//	walletobjectsService, err := walletobjects.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	walletobjectsService, err := walletobjects.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	walletobjectsService, err := walletobjects.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package walletobjects // import "google.golang.org/api/walletobjects/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "walletobjects:v1"
const apiName = "walletobjects"
const apiVersion = "v1"
const basePath = "https://walletobjects.googleapis.com/"
const basePathTemplate = "https://walletobjects.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://walletobjects.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Private Service: https://www.googleapis.com/auth/wallet_object.issuer
	WalletObjectIssuerScope = "https://www.googleapis.com/auth/wallet_object.issuer"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/wallet_object.issuer",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Eventticketclass = NewEventticketclassService(s)
	s.Eventticketobject = NewEventticketobjectService(s)
	s.Flightclass = NewFlightclassService(s)
	s.Flightobject = NewFlightobjectService(s)
	s.Genericclass = NewGenericclassService(s)
	s.Genericobject = NewGenericobjectService(s)
	s.Giftcardclass = NewGiftcardclassService(s)
	s.Giftcardobject = NewGiftcardobjectService(s)
	s.Issuer = NewIssuerService(s)
	s.Jwt = NewJwtService(s)
	s.Loyaltyclass = NewLoyaltyclassService(s)
	s.Loyaltyobject = NewLoyaltyobjectService(s)
	s.Media = NewMediaService(s)
	s.Offerclass = NewOfferclassService(s)
	s.Offerobject = NewOfferobjectService(s)
	s.Permissions = NewPermissionsService(s)
	s.Smarttap = NewSmarttapService(s)
	s.Transitclass = NewTransitclassService(s)
	s.Transitobject = NewTransitobjectService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Eventticketclass *EventticketclassService

	Eventticketobject *EventticketobjectService

	Flightclass *FlightclassService

	Flightobject *FlightobjectService

	Genericclass *GenericclassService

	Genericobject *GenericobjectService

	Giftcardclass *GiftcardclassService

	Giftcardobject *GiftcardobjectService

	Issuer *IssuerService

	Jwt *JwtService

	Loyaltyclass *LoyaltyclassService

	Loyaltyobject *LoyaltyobjectService

	Media *MediaService

	Offerclass *OfferclassService

	Offerobject *OfferobjectService

	Permissions *PermissionsService

	Smarttap *SmarttapService

	Transitclass *TransitclassService

	Transitobject *TransitobjectService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewEventticketclassService(s *Service) *EventticketclassService {
	rs := &EventticketclassService{s: s}
	return rs
}

type EventticketclassService struct {
	s *Service
}

func NewEventticketobjectService(s *Service) *EventticketobjectService {
	rs := &EventticketobjectService{s: s}
	return rs
}

type EventticketobjectService struct {
	s *Service
}

func NewFlightclassService(s *Service) *FlightclassService {
	rs := &FlightclassService{s: s}
	return rs
}

type FlightclassService struct {
	s *Service
}

func NewFlightobjectService(s *Service) *FlightobjectService {
	rs := &FlightobjectService{s: s}
	return rs
}

type FlightobjectService struct {
	s *Service
}

func NewGenericclassService(s *Service) *GenericclassService {
	rs := &GenericclassService{s: s}
	return rs
}

type GenericclassService struct {
	s *Service
}

func NewGenericobjectService(s *Service) *GenericobjectService {
	rs := &GenericobjectService{s: s}
	return rs
}

type GenericobjectService struct {
	s *Service
}

func NewGiftcardclassService(s *Service) *GiftcardclassService {
	rs := &GiftcardclassService{s: s}
	return rs
}

type GiftcardclassService struct {
	s *Service
}

func NewGiftcardobjectService(s *Service) *GiftcardobjectService {
	rs := &GiftcardobjectService{s: s}
	return rs
}

type GiftcardobjectService struct {
	s *Service
}

func NewIssuerService(s *Service) *IssuerService {
	rs := &IssuerService{s: s}
	return rs
}

type IssuerService struct {
	s *Service
}

func NewJwtService(s *Service) *JwtService {
	rs := &JwtService{s: s}
	return rs
}

type JwtService struct {
	s *Service
}

func NewLoyaltyclassService(s *Service) *LoyaltyclassService {
	rs := &LoyaltyclassService{s: s}
	return rs
}

type LoyaltyclassService struct {
	s *Service
}

func NewLoyaltyobjectService(s *Service) *LoyaltyobjectService {
	rs := &LoyaltyobjectService{s: s}
	return rs
}

type LoyaltyobjectService struct {
	s *Service
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

func NewOfferclassService(s *Service) *OfferclassService {
	rs := &OfferclassService{s: s}
	return rs
}

type OfferclassService struct {
	s *Service
}

func NewOfferobjectService(s *Service) *OfferobjectService {
	rs := &OfferobjectService{s: s}
	return rs
}

type OfferobjectService struct {
	s *Service
}

func NewPermissionsService(s *Service) *PermissionsService {
	rs := &PermissionsService{s: s}
	return rs
}

type PermissionsService struct {
	s *Service
}

func NewSmarttapService(s *Service) *SmarttapService {
	rs := &SmarttapService{s: s}
	return rs
}

type SmarttapService struct {
	s *Service
}

func NewTransitclassService(s *Service) *TransitclassService {
	rs := &TransitclassService{s: s}
	return rs
}

type TransitclassService struct {
	s *Service
}

func NewTransitobjectService(s *Service) *TransitobjectService {
	rs := &TransitobjectService{s: s}
	return rs
}

type TransitobjectService struct {
	s *Service
}

// ActivationOptions: ActivationOptions for the class
type ActivationOptions struct {
	// ActivationUrl: HTTPS URL that supports REST semantics. Would be used for
	// requesting activation from partners for given valuable, triggered by the
	// users.
	ActivationUrl string `json:"activationUrl,omitempty"`
	// AllowReactivation: Flag to allow users to make activation call from
	// different device. This allows client to render the activation button enabled
	// even if the activationStatus is ACTIVATED but the requested device is
	// different than the current device.
	AllowReactivation bool `json:"allowReactivation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActivationUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivationOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ActivationOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActivationStatus: The activation status of the object. This field includes
// activation status if valuable supports activation.
type ActivationStatus struct {
	// Possible values:
	//   "UNKNOWN_STATE"
	//   "NOT_ACTIVATED" - Not-Activated, this is the default status
	//   "not_activated" - Legacy alias for `NOT_ACTIVATED`. Deprecated.
	//   "ACTIVATED" - Activated
	//   "activated" - Legacy alias for `ACTIVATED`. Deprecated.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ActivationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AddMessageRequest: Resource used when the AddMessage endpoints are called.
type AddMessageRequest struct {
	Message *Message `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AddMessageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddMessageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AirportInfo struct {
	// AirportIataCode: Three character IATA airport code. This is a required field
	// for `origin` and `destination`. Eg: "SFO"
	AirportIataCode string `json:"airportIataCode,omitempty"`
	// AirportNameOverride: Optional field that overrides the airport city name
	// defined by IATA. By default, Google takes the `airportIataCode` provided and
	// maps it to the official airport city name defined by IATA. Official IATA
	// airport city names can be found at IATA airport city names website. For
	// example, for the airport IATA code "LTN", IATA website tells us that the
	// corresponding airport city is "London". If this field is not populated,
	// Google would display "London". However, populating this field with a custom
	// name (eg: "London Luton") would override it.
	AirportNameOverride *LocalizedString `json:"airportNameOverride,omitempty"`
	// Gate: A name of the gate. Eg: "B59" or "59"
	Gate string `json:"gate,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#airportInfo".
	Kind string `json:"kind,omitempty"`
	// Terminal: Terminal name. Eg: "INTL" or "I"
	Terminal string `json:"terminal,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AirportIataCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AirportIataCode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AirportInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AirportInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AppLinkData struct {
	// AndroidAppLinkInfo: Optional information about the partner app link.
	AndroidAppLinkInfo *AppLinkDataAppLinkInfo `json:"androidAppLinkInfo,omitempty"`
	// IosAppLinkInfo: Deprecated. Links to open iOS apps are not supported.
	IosAppLinkInfo *AppLinkDataAppLinkInfo `json:"iosAppLinkInfo,omitempty"`
	// WebAppLinkInfo: Optional information about the partner web link.
	WebAppLinkInfo *AppLinkDataAppLinkInfo `json:"webAppLinkInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AndroidAppLinkInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AndroidAppLinkInfo") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppLinkData) MarshalJSON() ([]byte, error) {
	type NoMethod AppLinkData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AppLinkDataAppLinkInfo struct {
	// AppLogoImage: Deprecated. Image isn't supported in the app link module.
	AppLogoImage *Image `json:"appLogoImage,omitempty"`
	// AppTarget: Target to follow when opening the app link on clients. It will be
	// used by partners to open their app or webpage.
	AppTarget *AppLinkDataAppLinkInfoAppTarget `json:"appTarget,omitempty"`
	// Description: Deprecated. Description isn't supported in the app link module.
	Description *LocalizedString `json:"description,omitempty"`
	// Title: Deprecated. Title isn't supported in the app link module.
	Title *LocalizedString `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppLogoImage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppLogoImage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppLinkDataAppLinkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppLinkDataAppLinkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AppLinkDataAppLinkInfoAppTarget struct {
	// PackageName: Package name for AppTarget. For example: com.google.android.gm
	PackageName string `json:"packageName,omitempty"`
	// TargetUri: URI for AppTarget. The description on the URI must be set. Prefer
	// setting package field instead, if this target is defined for your
	// application.
	TargetUri *Uri `json:"targetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackageName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackageName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppLinkDataAppLinkInfoAppTarget) MarshalJSON() ([]byte, error) {
	type NoMethod AppLinkDataAppLinkInfoAppTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AuthenticationKey struct {
	// Id: Available only to Smart Tap enabled partners. Contact support for
	// additional guidance.
	Id int64 `json:"id,omitempty"`
	// PublicKeyPem: Available only to Smart Tap enabled partners. Contact support
	// for additional guidance.
	PublicKeyPem string `json:"publicKeyPem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthenticationKey) MarshalJSON() ([]byte, error) {
	type NoMethod AuthenticationKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Barcode struct {
	// AlternateText: An optional text that will override the default text that
	// shows under the barcode. This field is intended for a human readable
	// equivalent of the barcode value, used when the barcode cannot be scanned.
	AlternateText string `json:"alternateText,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#barcode".
	Kind string `json:"kind,omitempty"`
	// RenderEncoding: The render encoding for the barcode. When specified, barcode
	// is rendered in the given encoding. Otherwise best known encoding is chosen
	// by Google.
	//
	// Possible values:
	//   "RENDER_ENCODING_UNSPECIFIED"
	//   "UTF_8" - UTF_8 encoding for barcodes. This is only supported for barcode
	// type qrCode.
	RenderEncoding string `json:"renderEncoding,omitempty"`
	// ShowCodeText: Optional text that will be shown when the barcode is hidden
	// behind a click action. This happens in cases where a pass has Smart Tap
	// enabled. If not specified, a default is chosen by Google.
	ShowCodeText *LocalizedString `json:"showCodeText,omitempty"`
	// Type: The type of barcode.
	//
	// Possible values:
	//   "BARCODE_TYPE_UNSPECIFIED"
	//   "AZTEC" - Not supported for Rotating Barcodes.
	//   "aztec" - Legacy alias for `AZTEC`. Deprecated. Not supported for Rotating
	// Barcodes.
	//   "CODE_39" - Not supported for Rotating Barcodes.
	//   "code39" - Legacy alias for `CODE_39`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "CODE_128" - Not supported for Rotating Barcodes.
	//   "code128" - Legacy alias for `CODE_128`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "CODABAR" - Not supported for Rotating Barcodes.
	//   "codabar" - Legacy alias for `CODABAR`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "DATA_MATRIX" - A 2D matrix barcode consisting of black and white. Cells
	// or modules are arranged in either a square or rectangle. Not supported for
	// Rotating Barcodes.
	//   "dataMatrix" - Legacy alias for `DATA_MATRIX`. Deprecated. Not supported
	// for Rotating Barcodes.
	//   "EAN_8" - Not supported for Rotating Barcodes.
	//   "ean8" - Legacy alias for `EAN_8`. Deprecated. Not supported for Rotating
	// Barcodes.
	//   "EAN_13" - Not supported for Rotating Barcodes.
	//   "ean13" - Legacy alias for `EAN_13`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "EAN13" - Legacy alias for `EAN_13`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "ITF_14" - 14 digit ITF code Not supported for Rotating Barcodes.
	//   "itf14" - Legacy alias for `ITF_14`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "PDF_417" - Supported for Rotating Barcodes.
	//   "pdf417" - Legacy alias for `PDF_417`. Deprecated.
	//   "PDF417" - Legacy alias for `PDF_417`. Deprecated.
	//   "QR_CODE" - Supported for Rotating Barcodes.
	//   "qrCode" - Legacy alias for `QR_CODE`. Deprecated.
	//   "qrcode" - Legacy alias for `QR_CODE`. Deprecated.
	//   "UPC_A" - 11 or 12 digit codes Not supported for Rotating Barcodes.
	//   "upcA" - Legacy alias for `UPC_A`. Deprecated. Not supported for Rotating
	// Barcodes.
	//   "TEXT_ONLY" - Renders the field as a text field. The `alternateText` field
	// may not be used with a barcode of type `textOnly`. Not supported for
	// Rotating Barcodes.
	//   "textOnly" - Legacy alias for `TEXT_ONLY`. Deprecated. Not supported for
	// Rotating Barcodes.
	Type string `json:"type,omitempty"`
	// Value: The value encoded in the barcode.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternateText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Barcode) MarshalJSON() ([]byte, error) {
	type NoMethod Barcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BarcodeSectionDetail struct {
	// FieldSelector: A reference to an existing text-based or image field to
	// display.
	FieldSelector *FieldSelector `json:"fieldSelector,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldSelector") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BarcodeSectionDetail) MarshalJSON() ([]byte, error) {
	type NoMethod BarcodeSectionDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Blobstore2Info: Information to read/write to blobstore2.
type Blobstore2Info struct {
	// BlobGeneration: The blob generation id.
	BlobGeneration int64 `json:"blobGeneration,omitempty,string"`
	// BlobId: The blob id, e.g., /blobstore/prod/playground/scotty
	BlobId string `json:"blobId,omitempty"`
	// DownloadReadHandle: Read handle passed from Bigstore -> Scotty for a GCS
	// download. This is a signed, serialized blobstore2.ReadHandle proto which
	// must never be set outside of Bigstore, and is not applicable to non-GCS
	// media downloads.
	DownloadReadHandle string `json:"downloadReadHandle,omitempty"`
	// ReadToken: The blob read token. Needed to read blobs that have not been
	// replicated. Might not be available until the final call.
	ReadToken string `json:"readToken,omitempty"`
	// UploadMetadataContainer: Metadata passed from Blobstore -> Scotty for a new
	// GCS upload. This is a signed, serialized blobstore2.BlobMetadataContainer
	// proto which must never be consumed outside of Bigstore, and is not
	// applicable to non-GCS media uploads.
	UploadMetadataContainer string `json:"uploadMetadataContainer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobGeneration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobGeneration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Blobstore2Info) MarshalJSON() ([]byte, error) {
	type NoMethod Blobstore2Info
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BoardingAndSeatingInfo struct {
	// BoardingDoor: Set this field only if this flight boards through more than
	// one door or bridge and you want to explicitly print the door location on the
	// boarding pass. Most airlines route their passengers to the right door or
	// bridge by refering to doors/bridges by the `seatClass`. In those cases
	// `boardingDoor` should not be set.
	//
	// Possible values:
	//   "BOARDING_DOOR_UNSPECIFIED"
	//   "FRONT"
	//   "front" - Legacy alias for `FRONT`. Deprecated.
	//   "BACK"
	//   "back" - Legacy alias for `BACK`. Deprecated.
	BoardingDoor string `json:"boardingDoor,omitempty"`
	// BoardingGroup: The value of boarding group (or zone) this passenger shall
	// board with. eg: "B" The label for this value will be determined by the
	// `boardingPolicy` field in the `flightClass` referenced by this object.
	BoardingGroup string `json:"boardingGroup,omitempty"`
	// BoardingPosition: The value of boarding position. eg: "76"
	BoardingPosition string `json:"boardingPosition,omitempty"`
	// BoardingPrivilegeImage: A small image shown above the boarding barcode.
	// Airlines can use it to communicate any special boarding privileges. In the
	// event the security program logo is also set, this image might be rendered
	// alongside the logo for that security program.
	BoardingPrivilegeImage *Image `json:"boardingPrivilegeImage,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#boardingAndSeatingInfo".
	Kind string `json:"kind,omitempty"`
	// SeatAssignment: The passenger's seat assignment. To be used when there is no
	// specific identifier to use in `seatNumber`. eg: "assigned at gate"
	SeatAssignment *LocalizedString `json:"seatAssignment,omitempty"`
	// SeatClass: The value of the seat class. eg: "Economy" or "Economy Plus"
	SeatClass string `json:"seatClass,omitempty"`
	// SeatNumber: The value of passenger seat. If there is no specific identifier,
	// use `seatAssignment` instead. eg: "25A"
	SeatNumber string `json:"seatNumber,omitempty"`
	// SequenceNumber: The sequence number on the boarding pass. This usually
	// matches the sequence in which the passengers checked in. Airline might use
	// the number for manual boarding and bag tags. eg: "49"
	SequenceNumber string `json:"sequenceNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoardingDoor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoardingDoor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BoardingAndSeatingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BoardingAndSeatingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BoardingAndSeatingPolicy struct {
	// BoardingPolicy: Indicates the policy the airline uses for boarding. If
	// unset, Google will default to `zoneBased`.
	//
	// Possible values:
	//   "BOARDING_POLICY_UNSPECIFIED"
	//   "ZONE_BASED"
	//   "zoneBased" - Legacy alias for `ZONE_BASED`. Deprecated.
	//   "GROUP_BASED"
	//   "groupBased" - Legacy alias for `GROUP_BASED`. Deprecated.
	//   "BOARDING_POLICY_OTHER"
	//   "boardingPolicyOther" - Legacy alias for `BOARDING_POLICY_OTHER`.
	// Deprecated.
	BoardingPolicy string `json:"boardingPolicy,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#boardingAndSeatingPolicy".
	Kind string `json:"kind,omitempty"`
	// SeatClassPolicy: Seating policy which dictates how we display the seat
	// class. If unset, Google will default to `cabinBased`.
	//
	// Possible values:
	//   "SEAT_CLASS_POLICY_UNSPECIFIED"
	//   "CABIN_BASED"
	//   "cabinBased" - Legacy alias for `CABIN_BASED`. Deprecated.
	//   "CLASS_BASED"
	//   "classBased" - Legacy alias for `CLASS_BASED`. Deprecated.
	//   "TIER_BASED"
	//   "tierBased" - Legacy alias for `TIER_BASED`. Deprecated.
	//   "SEAT_CLASS_POLICY_OTHER"
	//   "seatClassPolicyOther" - Legacy alias for `SEAT_CLASS_POLICY_OTHER`.
	// Deprecated.
	SeatClassPolicy string `json:"seatClassPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoardingPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoardingPolicy") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BoardingAndSeatingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BoardingAndSeatingPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CallbackOptions struct {
	// UpdateRequestUrl: URL for the merchant endpoint that would be called to
	// request updates. The URL should be hosted on HTTPS and robots.txt should
	// allow the URL path to be accessible by UserAgent:Googlebot. Deprecated.
	UpdateRequestUrl string `json:"updateRequestUrl,omitempty"`
	// Url: The HTTPS url configured by the merchant. The URL should be hosted on
	// HTTPS and robots.txt should allow the URL path to be accessible by
	// UserAgent:Googlebot.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UpdateRequestUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpdateRequestUrl") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CallbackOptions) MarshalJSON() ([]byte, error) {
	type NoMethod CallbackOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CardBarcodeSectionDetails struct {
	// FirstBottomDetail: Optional information to display below the barcode.
	FirstBottomDetail *BarcodeSectionDetail `json:"firstBottomDetail,omitempty"`
	// FirstTopDetail: Optional information to display above the barcode. If
	// `secondTopDetail` is defined, this will be displayed to the start side of
	// this detail section.
	FirstTopDetail *BarcodeSectionDetail `json:"firstTopDetail,omitempty"`
	// SecondTopDetail: Optional second piece of information to display above the
	// barcode. If `firstTopDetail` is defined, this will be displayed to the end
	// side of this detail section.
	SecondTopDetail *BarcodeSectionDetail `json:"secondTopDetail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FirstBottomDetail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirstBottomDetail") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CardBarcodeSectionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod CardBarcodeSectionDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CardRowOneItem struct {
	// Item: The item to be displayed in the row. This item will be automatically
	// centered.
	Item *TemplateItem `json:"item,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Item") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Item") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CardRowOneItem) MarshalJSON() ([]byte, error) {
	type NoMethod CardRowOneItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CardRowTemplateInfo struct {
	// OneItem: Template for a row containing one item. Exactly one of "one_item",
	// "two_items", "three_items" must be set.
	OneItem *CardRowOneItem `json:"oneItem,omitempty"`
	// ThreeItems: Template for a row containing three items. Exactly one of
	// "one_item", "two_items", "three_items" must be set.
	ThreeItems *CardRowThreeItems `json:"threeItems,omitempty"`
	// TwoItems: Template for a row containing two items. Exactly one of
	// "one_item", "two_items", "three_items" must be set.
	TwoItems *CardRowTwoItems `json:"twoItems,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OneItem") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OneItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CardRowTemplateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CardRowTemplateInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CardRowThreeItems struct {
	// EndItem: The item to be displayed at the end of the row. This item will be
	// aligned to the right.
	EndItem *TemplateItem `json:"endItem,omitempty"`
	// MiddleItem: The item to be displayed in the middle of the row. This item
	// will be centered between the start and end items.
	MiddleItem *TemplateItem `json:"middleItem,omitempty"`
	// StartItem: The item to be displayed at the start of the row. This item will
	// be aligned to the left.
	StartItem *TemplateItem `json:"startItem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndItem") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CardRowThreeItems) MarshalJSON() ([]byte, error) {
	type NoMethod CardRowThreeItems
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CardRowTwoItems struct {
	// EndItem: The item to be displayed at the end of the row. This item will be
	// aligned to the right.
	EndItem *TemplateItem `json:"endItem,omitempty"`
	// StartItem: The item to be displayed at the start of the row. This item will
	// be aligned to the left.
	StartItem *TemplateItem `json:"startItem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndItem") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CardRowTwoItems) MarshalJSON() ([]byte, error) {
	type NoMethod CardRowTwoItems
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CardTemplateOverride struct {
	// CardRowTemplateInfos: Template information for rows in the card view. At
	// most three rows are allowed to be specified.
	CardRowTemplateInfos []*CardRowTemplateInfo `json:"cardRowTemplateInfos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CardRowTemplateInfos") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CardRowTemplateInfos") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CardTemplateOverride) MarshalJSON() ([]byte, error) {
	type NoMethod CardTemplateOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ClassTemplateInfo struct {
	// CardBarcodeSectionDetails: Specifies extra information to be displayed above
	// and below the barcode.
	CardBarcodeSectionDetails *CardBarcodeSectionDetails `json:"cardBarcodeSectionDetails,omitempty"`
	// CardTemplateOverride: Override for the card view.
	CardTemplateOverride *CardTemplateOverride `json:"cardTemplateOverride,omitempty"`
	// DetailsTemplateOverride: Override for the details view (beneath the card
	// view).
	DetailsTemplateOverride *DetailsTemplateOverride `json:"detailsTemplateOverride,omitempty"`
	// ListTemplateOverride: Override for the passes list view.
	ListTemplateOverride *ListTemplateOverride `json:"listTemplateOverride,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CardBarcodeSectionDetails")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CardBarcodeSectionDetails") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClassTemplateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ClassTemplateInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompositeMedia: A sequence of media data references representing composite
// data. Introduced to support Bigstore composite objects. For details, visit
// http://go/bigstore-composites.
type CompositeMedia struct {
	// BlobRef: Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This
	// should be the byte representation of a blobstore.BlobRef. Since Blobstore is
	// deprecating v1, use blobstore2_info instead. For now, any v2 blob will also
	// be represented in this field as v1 BlobRef.
	BlobRef string `json:"blobRef,omitempty"`
	// Blobstore2Info: Blobstore v2 info, set if reference_type is BLOBSTORE_REF
	// and it refers to a v2 blob.
	Blobstore2Info *Blobstore2Info `json:"blobstore2Info,omitempty"`
	// CosmoBinaryReference: A binary data reference for a media download. Serves
	// as a technology-agnostic binary reference in some Google infrastructure.
	// This value is a serialized storage_cosmo.BinaryReference proto. Storing it
	// as bytes is a hack to get around the fact that the cosmo proto (as well as
	// others it includes) doesn't support JavaScript. This prevents us from
	// including the actual type of this field.
	CosmoBinaryReference string `json:"cosmoBinaryReference,omitempty"`
	// Crc32cHash: crc32.c hash for the payload.
	Crc32cHash int64 `json:"crc32cHash,omitempty"`
	// Inline: Media data, set if reference_type is INLINE
	Inline string `json:"inline,omitempty"`
	// Length: Size of the data, in bytes
	Length int64 `json:"length,omitempty,string"`
	// Md5Hash: MD5 hash for the payload.
	Md5Hash string `json:"md5Hash,omitempty"`
	// ObjectId: Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
	ObjectId *ObjectId `json:"objectId,omitempty"`
	// Path: Path to the data, set if reference_type is PATH
	Path string `json:"path,omitempty"`
	// ReferenceType: Describes what the field reference contains.
	//
	// Possible values:
	//   "PATH" - Reference contains a GFS path or a local path.
	//   "BLOB_REF" - Reference points to a blobstore object. This could be either
	// a v1 blob_ref or a v2 blobstore2_info. Clients should check blobstore2_info
	// first, since v1 is being deprecated.
	//   "INLINE" - Data is included into this proto buffer
	//   "BIGSTORE_REF" - Reference points to a bigstore object
	//   "COSMO_BINARY_REFERENCE" - Indicates the data is stored in
	// cosmo_binary_reference.
	ReferenceType string `json:"referenceType,omitempty"`
	// Sha1Hash: SHA-1 hash for the payload.
	Sha1Hash string `json:"sha1Hash,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobRef") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobRef") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompositeMedia) MarshalJSON() ([]byte, error) {
	type NoMethod CompositeMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContentTypeInfo: Detailed Content-Type information from Scotty. The
// Content-Type of the media will typically be filled in by the header or
// Scotty's best_guess, but this extended information provides the backend with
// more information so that it can make a better decision if needed. This is
// only used on media upload requests from Scotty.
type ContentTypeInfo struct {
	// BestGuess: Scotty's best guess of what the content type of the file is.
	BestGuess string `json:"bestGuess,omitempty"`
	// FromBytes: The content type of the file derived by looking at specific bytes
	// (i.e. "magic bytes") of the actual file.
	FromBytes string `json:"fromBytes,omitempty"`
	// FromFileName: The content type of the file derived from the file extension
	// of the original file name used by the client.
	FromFileName string `json:"fromFileName,omitempty"`
	// FromHeader: The content type of the file as specified in the request
	// headers, multipart headers, or RUPIO start request.
	FromHeader string `json:"fromHeader,omitempty"`
	// FromUrlPath: The content type of the file derived from the file extension of
	// the URL path. The URL path is assumed to represent a file name (which is
	// typically only true for agents that are providing a REST API).
	FromUrlPath string `json:"fromUrlPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BestGuess") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BestGuess") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContentTypeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ContentTypeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DateTime struct {
	// Date: An ISO 8601 extended format date/time. Offset may or may not be
	// required (refer to the parent field's documentation). Time may be specified
	// up to nanosecond precision. Offsets may be specified with seconds precision
	// (even though offset seconds is not part of ISO 8601). For example:
	// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the
	// 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would
	// be 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4
	// hours before UTC (same instant in time as the above example). If the
	// date/time is intended for a physical location in New York, this would be the
	// equivalent of Eastern Daylight Time (EDT). Remember that offset varies in
	// regions that observe Daylight Saving Time (or Summer Time), depending on the
	// time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52
	// seconds after the 19th hour of April 12th, 1985 with no offset information.
	// Providing an offset makes this an absolute instant in time around the world.
	// The date/time will be adjusted based on the user's time zone. For example, a
	// time of `2018-06-19T18:30:00-04:00` will be 18:30:00 for a user in New York
	// and 15:30:00 for a user in Los Angeles. Omitting the offset makes this a
	// local date/time, representing several instants in time around the world. The
	// date/time will always be in the user's current time zone. For example, a
	// time of `2018-06-19T18:30:00` will be 18:30:00 for a user in New York and
	// also 18:30:00 for a user in Los Angeles. This is useful when the same local
	// date/time should apply to many physical locations across several time zones.
	Date string `json:"date,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Date") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Date") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DateTime) MarshalJSON() ([]byte, error) {
	type NoMethod DateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DetailsItemInfo struct {
	// Item: The item to be displayed in the details list.
	Item *TemplateItem `json:"item,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Item") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Item") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DetailsItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DetailsItemInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DetailsTemplateOverride struct {
	// DetailsItemInfos: Information for the "nth" item displayed in the details
	// list.
	DetailsItemInfos []*DetailsItemInfo `json:"detailsItemInfos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetailsItemInfos") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetailsItemInfos") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DetailsTemplateOverride) MarshalJSON() ([]byte, error) {
	type NoMethod DetailsTemplateOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeviceContext: Device context associated with the object.
type DeviceContext struct {
	// DeviceToken: If set, redemption information will only be returned to the
	// given device upon activation of the object. This should not be used as a
	// stable identifier to trace a user's device. It can change across different
	// passes for the same device or even across different activations for the same
	// device. When setting this, callers must also set has_linked_device on the
	// object being activated.
	DeviceToken string `json:"deviceToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeviceContext) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiffChecksumsResponse: Backend response for a Diff get checksums response.
// For details on the Scotty Diff protocol, visit
// http://go/scotty-diff-protocol.
type DiffChecksumsResponse struct {
	// ChecksumsLocation: Exactly one of these fields must be populated. If
	// checksums_location is filled, the server will return the corresponding
	// contents to the user. If object_location is filled, the server will
	// calculate the checksums based on the content there and return that to the
	// user. For details on the format of the checksums, see
	// http://go/scotty-diff-protocol.
	ChecksumsLocation *CompositeMedia `json:"checksumsLocation,omitempty"`
	// ChunkSizeBytes: The chunk size of checksums. Must be a multiple of 256KB.
	ChunkSizeBytes int64 `json:"chunkSizeBytes,omitempty,string"`
	// ObjectLocation: If set, calculate the checksums based on the contents and
	// return them to the caller.
	ObjectLocation *CompositeMedia `json:"objectLocation,omitempty"`
	// ObjectSizeBytes: The total size of the server object.
	ObjectSizeBytes int64 `json:"objectSizeBytes,omitempty,string"`
	// ObjectVersion: The object version of the object the checksums are being
	// returned for.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChecksumsLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChecksumsLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiffChecksumsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DiffChecksumsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiffDownloadResponse: Backend response for a Diff download response. For
// details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
type DiffDownloadResponse struct {
	// ObjectLocation: The original object location.
	ObjectLocation *CompositeMedia `json:"objectLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiffDownloadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DiffDownloadResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiffUploadRequest: A Diff upload request. For details on the Scotty Diff
// protocol, visit http://go/scotty-diff-protocol.
type DiffUploadRequest struct {
	// ChecksumsInfo: The location of the checksums for the new object. Agents must
	// clone the object located here, as the upload server will delete the contents
	// once a response is received. For details on the format of the checksums, see
	// http://go/scotty-diff-protocol.
	ChecksumsInfo *CompositeMedia `json:"checksumsInfo,omitempty"`
	// ObjectInfo: The location of the new object. Agents must clone the object
	// located here, as the upload server will delete the contents once a response
	// is received.
	ObjectInfo *CompositeMedia `json:"objectInfo,omitempty"`
	// ObjectVersion: The object version of the object that is the base version the
	// incoming diff script will be applied to. This field will always be filled
	// in.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChecksumsInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChecksumsInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiffUploadRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DiffUploadRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiffUploadResponse: Backend response for a Diff upload request. For details
// on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
type DiffUploadResponse struct {
	// ObjectVersion: The object version of the object at the server. Must be
	// included in the end notification response. The version in the end
	// notification response must correspond to the new version of the object that
	// is now stored at the server, after the upload.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// OriginalObject: The location of the original file for a diff upload request.
	// Must be filled in if responding to an upload start notification.
	OriginalObject *CompositeMedia `json:"originalObject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiffUploadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DiffUploadResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiffVersionResponse: Backend response for a Diff get version response. For
// details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
type DiffVersionResponse struct {
	// ObjectSizeBytes: The total size of the server object.
	ObjectSizeBytes int64 `json:"objectSizeBytes,omitempty,string"`
	// ObjectVersion: The version of the object stored at the server.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectSizeBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiffVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DiffVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiscoverableProgram: Information about how a class may be discovered and
// instantiated from within the Android Pay app. This is done by searching for
// a loyalty or gift card program and scanning or manually entering.
type DiscoverableProgram struct {
	// MerchantSigninInfo: Information about the ability to signin and add a
	// valuable for this program through a merchant site. Used when
	// MERCHANT_HOSTED_SIGNIN is enabled.
	MerchantSigninInfo *DiscoverableProgramMerchantSigninInfo `json:"merchantSigninInfo,omitempty"`
	// MerchantSignupInfo: Information about the ability to signup and add a
	// valuable for this program through a merchant site. Used when
	// MERCHANT_HOSTED_SIGNUP is enabled.
	MerchantSignupInfo *DiscoverableProgramMerchantSignupInfo `json:"merchantSignupInfo,omitempty"`
	// State: Visibility state of the discoverable program.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "TRUSTED_TESTERS" - Visible only to testers that have access to issuer
	// account.
	//   "trustedTesters" - Legacy alias for `TRUSTED_TESTERS`. Deprecated.
	//   "LIVE" - Visible to all.
	//   "live" - Legacy alias for `LIVE`. Deprecated.
	//   "DISABLED" - Not visible.
	//   "disabled" - Legacy alias for `DISABLED`. Deprecated.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MerchantSigninInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MerchantSigninInfo") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiscoverableProgram) MarshalJSON() ([]byte, error) {
	type NoMethod DiscoverableProgram
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiscoverableProgramMerchantSigninInfo: Information about the merchant hosted
// signin flow for a program.
type DiscoverableProgramMerchantSigninInfo struct {
	// SigninWebsite: The URL to direct the user to for the merchant's signin site.
	SigninWebsite *Uri `json:"signinWebsite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SigninWebsite") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SigninWebsite") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiscoverableProgramMerchantSigninInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DiscoverableProgramMerchantSigninInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiscoverableProgramMerchantSignupInfo: Information about the merchant hosted
// signup flow for a program.
type DiscoverableProgramMerchantSignupInfo struct {
	// SignupSharedDatas:  User data that is sent in a POST request to the signup
	// website URL. This information is encoded and then shared so that the
	// merchant's website can prefill fields used to enroll the user for the
	// discoverable program.
	//
	// Possible values:
	//   "SHARED_DATA_TYPE_UNSPECIFIED"
	//   "FIRST_NAME"
	//   "LAST_NAME"
	//   "STREET_ADDRESS" - single line address field
	//   "ADDRESS_LINE_1" - multi line address fields
	//   "ADDRESS_LINE_2"
	//   "ADDRESS_LINE_3"
	//   "CITY"
	//   "STATE"
	//   "ZIPCODE"
	//   "COUNTRY"
	//   "EMAIL"
	//   "PHONE"
	SignupSharedDatas []string `json:"signupSharedDatas,omitempty"`
	// SignupWebsite: The URL to direct the user to for the merchant's signup site.
	SignupWebsite *Uri `json:"signupWebsite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SignupSharedDatas") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SignupSharedDatas") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiscoverableProgramMerchantSignupInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DiscoverableProgramMerchantSignupInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DownloadParameters: Parameters specific to media downloads.
type DownloadParameters struct {
	// AllowGzipCompression: A boolean to be returned in the response to Scotty.
	// Allows/disallows gzip encoding of the payload content when the server thinks
	// it's advantageous (hence, does not guarantee compression) which allows
	// Scotty to GZip the response to the client.
	AllowGzipCompression bool `json:"allowGzipCompression,omitempty"`
	// IgnoreRange: Determining whether or not Apiary should skip the inclusion of
	// any Content-Range header on its response to Scotty.
	IgnoreRange bool `json:"ignoreRange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowGzipCompression") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowGzipCompression") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DownloadParameters) MarshalJSON() ([]byte, error) {
	type NoMethod DownloadParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventDateTime struct {
	// CustomDoorsOpenLabel: A custom label to use for the doors open value
	// (`doorsOpen`) on the card detail view. This should only be used if the
	// default "Doors Open" label or one of the `doorsOpenLabel` options is not
	// sufficient. Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set.
	// If neither is set, the label will default to "Doors Open", localized. If the
	// doors open field is unset, this label will not be used.
	CustomDoorsOpenLabel *LocalizedString `json:"customDoorsOpenLabel,omitempty"`
	// DoorsOpen: The date/time when the doors open at the venue. This is an ISO
	// 8601 extended format date/time, with or without an offset. Time may be
	// specified up to nanosecond precision. Offsets may be specified with seconds
	// precision (even though offset seconds is not part of ISO 8601). For example:
	// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the
	// 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would
	// be 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4
	// hours before UTC (same instant in time as the above example). If the event
	// were in New York, this would be the equivalent of Eastern Daylight Time
	// (EDT). Remember that offset varies in regions that observe Daylight Saving
	// Time (or Summer Time), depending on the time of the year.
	// `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the
	// 19th hour of April 12th, 1985 with no offset information. The portion of the
	// date/time without the offset is considered the "local date/time". This
	// should be the local date/time at the venue. For example, if the event occurs
	// at the 20th hour of June 5th, 2018 at the venue, the local date/time portion
	// should be `2018-06-05T20:00:00`. If the local date/time at the venue is 4
	// hours before UTC, an offset of `-04:00` may be appended. Without offset
	// information, some rich features may not be available.
	DoorsOpen string `json:"doorsOpen,omitempty"`
	// DoorsOpenLabel: The label to use for the doors open value (`doorsOpen`) on
	// the card detail view. Each available option maps to a set of localized
	// strings, so that translations are shown to the user based on their locale.
	// Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither
	// is set, the label will default to "Doors Open", localized. If the doors open
	// field is unset, this label will not be used.
	//
	// Possible values:
	//   "DOORS_OPEN_LABEL_UNSPECIFIED"
	//   "DOORS_OPEN"
	//   "doorsOpen" - Legacy alias for `DOORS_OPEN`. Deprecated.
	//   "GATES_OPEN"
	//   "gatesOpen" - Legacy alias for `GATES_OPEN`. Deprecated.
	DoorsOpenLabel string `json:"doorsOpenLabel,omitempty"`
	// End: The date/time when the event ends. If the event spans multiple days, it
	// should be the end date/time on the last day. This is an ISO 8601 extended
	// format date/time, with or without an offset. Time may be specified up to
	// nanosecond precision. Offsets may be specified with seconds precision (even
	// though offset seconds is not part of ISO 8601). For example:
	// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the
	// 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would
	// be 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4
	// hours before UTC (same instant in time as the above example). If the event
	// were in New York, this would be the equivalent of Eastern Daylight Time
	// (EDT). Remember that offset varies in regions that observe Daylight Saving
	// Time (or Summer Time), depending on the time of the year.
	// `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the
	// 19th hour of April 12th, 1985 with no offset information. The portion of the
	// date/time without the offset is considered the "local date/time". This
	// should be the local date/time at the venue. For example, if the event occurs
	// at the 20th hour of June 5th, 2018 at the venue, the local date/time portion
	// should be `2018-06-05T20:00:00`. If the local date/time at the venue is 4
	// hours before UTC, an offset of `-04:00` may be appended. Without offset
	// information, some rich features may not be available.
	End string `json:"end,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#eventDateTime".
	Kind string `json:"kind,omitempty"`
	// Start: The date/time when the event starts. If the event spans multiple
	// days, it should be the start date/time on the first day. This is an ISO 8601
	// extended format date/time, with or without an offset. Time may be specified
	// up to nanosecond precision. Offsets may be specified with seconds precision
	// (even though offset seconds is not part of ISO 8601). For example:
	// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the
	// 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would
	// be 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4
	// hours before UTC (same instant in time as the above example). If the event
	// were in New York, this would be the equivalent of Eastern Daylight Time
	// (EDT). Remember that offset varies in regions that observe Daylight Saving
	// Time (or Summer Time), depending on the time of the year.
	// `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the
	// 19th hour of April 12th, 1985 with no offset information. The portion of the
	// date/time without the offset is considered the "local date/time". This
	// should be the local date/time at the venue. For example, if the event occurs
	// at the 20th hour of June 5th, 2018 at the venue, the local date/time portion
	// should be `2018-06-05T20:00:00`. If the local date/time at the venue is 4
	// hours before UTC, an offset of `-04:00` may be appended. Without offset
	// information, some rich features may not be available.
	Start string `json:"start,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomDoorsOpenLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomDoorsOpenLabel") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventDateTime) MarshalJSON() ([]byte, error) {
	type NoMethod EventDateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventReservationInfo struct {
	// ConfirmationCode: The confirmation code of the event reservation. This may
	// also take the form of an "order number", "confirmation number", "reservation
	// number", or other equivalent.
	ConfirmationCode string `json:"confirmationCode,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#eventReservationInfo".
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfirmationCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfirmationCode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventReservationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod EventReservationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventSeat struct {
	// Gate: The gate the ticket holder should enter to get to their seat, such as
	// "A" or "West". This field is localizable so you may translate words or use
	// different alphabets for the characters in an identifier.
	Gate *LocalizedString `json:"gate,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#eventSeat".
	Kind string `json:"kind,omitempty"`
	// Row: The row of the seat, such as "1", E", "BB", or "A5". This field is
	// localizable so you may translate words or use different alphabets for the
	// characters in an identifier.
	Row *LocalizedString `json:"row,omitempty"`
	// Seat: The seat number, such as "1", "2", "3", or any other seat identifier.
	// This field is localizable so you may translate words or use different
	// alphabets for the characters in an identifier.
	Seat *LocalizedString `json:"seat,omitempty"`
	// Section: The section of the seat, such as "121". This field is localizable
	// so you may translate words or use different alphabets for the characters in
	// an identifier.
	Section *LocalizedString `json:"section,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Gate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Gate") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventSeat) MarshalJSON() ([]byte, error) {
	type NoMethod EventSeat
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventTicketClass struct {
	// AllowMultipleUsersPerObject: Deprecated. Use
	// `multipleDevicesAndHoldersAllowedStatus` instead.
	AllowMultipleUsersPerObject bool `json:"allowMultipleUsersPerObject,omitempty"`
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// object that will be used instead.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// CallbackOptions: Callback options to be used to call the issuer back for
	// every save/delete of an object for this class by the end-user. All objects
	// of this class are eligible for the callback.
	CallbackOptions *CallbackOptions `json:"callbackOptions,omitempty"`
	// ClassTemplateInfo: Template information about how the class should be
	// displayed. If unset, Google will fallback to a default set of fields to
	// display.
	ClassTemplateInfo *ClassTemplateInfo `json:"classTemplateInfo,omitempty"`
	// ConfirmationCodeLabel: The label to use for the confirmation code value
	// (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail
	// view. Each available option maps to a set of localized strings, so that
	// translations are shown to the user based on their locale. Both
	// `confirmationCodeLabel` and `customConfirmationCodeLabel` may not be set. If
	// neither is set, the label will default to "Confirmation Code", localized. If
	// the confirmation code field is unset, this label will not be used.
	//
	// Possible values:
	//   "CONFIRMATION_CODE_LABEL_UNSPECIFIED"
	//   "CONFIRMATION_CODE"
	//   "confirmationCode" - Legacy alias for `CONFIRMATION_CODE`. Deprecated.
	//   "CONFIRMATION_NUMBER"
	//   "confirmationNumber" - Legacy alias for `CONFIRMATION_NUMBER`. Deprecated.
	//   "ORDER_NUMBER"
	//   "orderNumber" - Legacy alias for `ORDER_NUMBER`. Deprecated.
	//   "RESERVATION_NUMBER"
	//   "reservationNumber" - Legacy alias for `RESERVATION_NUMBER`. Deprecated.
	ConfirmationCodeLabel string `json:"confirmationCodeLabel,omitempty"`
	// CountryCode: Country code used to display the card's country (when the user
	// is not in that country), as well as to display localized content when
	// content is not available in the user's locale.
	CountryCode string `json:"countryCode,omitempty"`
	// CustomConfirmationCodeLabel: A custom label to use for the confirmation code
	// value (`eventTicketObject.reservationInfo.confirmationCode`) on the card
	// detail view. This should only be used if the default "Confirmation Code"
	// label or one of the `confirmationCodeLabel` options is not sufficient. Both
	// `confirmationCodeLabel` and `customConfirmationCodeLabel` may not be set. If
	// neither is set, the label will default to "Confirmation Code", localized. If
	// the confirmation code field is unset, this label will not be used.
	CustomConfirmationCodeLabel *LocalizedString `json:"customConfirmationCodeLabel,omitempty"`
	// CustomGateLabel: A custom label to use for the gate value
	// (`eventTicketObject.seatInfo.gate`) on the card detail view. This should
	// only be used if the default "Gate" label or one of the `gateLabel` options
	// is not sufficient. Both `gateLabel` and `customGateLabel` may not be set. If
	// neither is set, the label will default to "Gate", localized. If the gate
	// field is unset, this label will not be used.
	CustomGateLabel *LocalizedString `json:"customGateLabel,omitempty"`
	// CustomRowLabel: A custom label to use for the row value
	// (`eventTicketObject.seatInfo.row`) on the card detail view. This should only
	// be used if the default "Row" label or one of the `rowLabel` options is not
	// sufficient. Both `rowLabel` and `customRowLabel` may not be set. If neither
	// is set, the label will default to "Row", localized. If the row field is
	// unset, this label will not be used.
	CustomRowLabel *LocalizedString `json:"customRowLabel,omitempty"`
	// CustomSeatLabel: A custom label to use for the seat value
	// (`eventTicketObject.seatInfo.seat`) on the card detail view. This should
	// only be used if the default "Seat" label or one of the `seatLabel` options
	// is not sufficient. Both `seatLabel` and `customSeatLabel` may not be set. If
	// neither is set, the label will default to "Seat", localized. If the seat
	// field is unset, this label will not be used.
	CustomSeatLabel *LocalizedString `json:"customSeatLabel,omitempty"`
	// CustomSectionLabel: A custom label to use for the section value
	// (`eventTicketObject.seatInfo.section`) on the card detail view. This should
	// only be used if the default "Section" label or one of the `sectionLabel`
	// options is not sufficient. Both `sectionLabel` and `customSectionLabel` may
	// not be set. If neither is set, the label will default to "Section",
	// localized. If the section field is unset, this label will not be used.
	CustomSectionLabel *LocalizedString `json:"customSectionLabel,omitempty"`
	// DateTime: The date & time information of the event.
	DateTime *EventDateTime `json:"dateTime,omitempty"`
	// EnableSmartTap: Identifies whether this class supports Smart Tap. The
	// `redemptionIssuers` and object level `smartTapRedemptionLevel` fields must
	// also be set up correctly in order for a pass to support Smart Tap.
	EnableSmartTap bool `json:"enableSmartTap,omitempty"`
	// EventId: The ID of the event. This ID should be unique for every event in an
	// account. It is used to group tickets together if the user has saved multiple
	// tickets for the same event. It can be at most 64 characters. If provided,
	// the grouping will be stable. Be wary of unintentional collision to avoid
	// grouping tickets that should not be grouped. If you use only one class per
	// event, you can simply set this to the `classId` (with or without the issuer
	// ID portion). If not provided, the platform will attempt to use other data to
	// group tickets (potentially unstable).
	EventId string `json:"eventId,omitempty"`
	// EventName: Required. The name of the event, such as "LA Dodgers at SF
	// Giants".
	EventName *LocalizedString `json:"eventName,omitempty"`
	// FinePrint: The fine print, terms, or conditions of the ticket.
	FinePrint *LocalizedString `json:"finePrint,omitempty"`
	// GateLabel: The label to use for the gate value
	// (`eventTicketObject.seatInfo.gate`) on the card detail view. Each available
	// option maps to a set of localized strings, so that translations are shown to
	// the user based on their locale. Both `gateLabel` and `customGateLabel` may
	// not be set. If neither is set, the label will default to "Gate", localized.
	// If the gate field is unset, this label will not be used.
	//
	// Possible values:
	//   "GATE_LABEL_UNSPECIFIED"
	//   "GATE"
	//   "gate" - Legacy alias for `GATE`. Deprecated.
	//   "DOOR"
	//   "door" - Legacy alias for `DOOR`. Deprecated.
	//   "ENTRANCE"
	//   "entrance" - Legacy alias for `ENTRANCE`. Deprecated.
	GateLabel string `json:"gateLabel,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, nothing will be displayed. The image will display at 100% width.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// HomepageUri: The URI of your application's home page. Populating the URI in
	// this field results in the exact same behavior as populating an URI in
	// linksModuleData (when an object is rendered, a link to the homepage is shown
	// in what would usually be thought of as the linksModuleData section of the
	// object).
	HomepageUri *Uri `json:"homepageUri,omitempty"`
	// Id: Required. The unique identifier for a class. This ID must be unique
	// across all classes from an issuer. This value should follow the format
	// issuer ID. identifier where the former is issued by Google and latter is
	// chosen by you. Your unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// IssuerName: Required. The issuer name. Recommended maximum length is 20
	// characters to ensure full string is displayed on smaller screens.
	IssuerName string `json:"issuerName,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#eventTicketClass".
	Kind string `json:"kind,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the object, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// LocalizedIssuerName: Translated strings for the issuer_name. Recommended
	// maximum length is 20 characters to ensure full string is displayed on
	// smaller screens.
	LocalizedIssuerName *LocalizedString `json:"localizedIssuerName,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Logo: The logo image of the ticket. This image is displayed in the card
	// detail view of the app.
	Logo *Image `json:"logo,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// MultipleDevicesAndHoldersAllowedStatus: Identifies whether multiple users
	// and devices will save the same object referencing this class.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified preference.
	//   "MULTIPLE_HOLDERS" - The Pass object is shareable by a user and can be
	// saved by any number of different users, and on any number of devices.
	// Partners typically use this setup for passes that do not need to be
	// restricted to a single user or pinned to a single device.
	//   "ONE_USER_ALL_DEVICES" - An object can only be saved by one user, but this
	// user can view and use it on multiple of their devices. Once the first user
	// saves the object, no other user will be allowed to view or save it.
	//   "ONE_USER_ONE_DEVICE" - An object can only be saved by one user on a
	// single device. Intended for use by select partners in limited circumstances.
	// An example use case is a transit ticket that should be "device pinned",
	// meaning it can be saved, viewed and used only by a single user on a single
	// device. Contact support for additional information.
	//   "multipleHolders" - Legacy alias for `MULTIPLE_HOLDERS`. Deprecated.
	//   "oneUserAllDevices" - Legacy alias for `ONE_USER_ALL_DEVICES`. Deprecated.
	//   "oneUserOneDevice" - Legacy alias for `ONE_USER_ONE_DEVICE`. Deprecated.
	MultipleDevicesAndHoldersAllowedStatus string `json:"multipleDevicesAndHoldersAllowedStatus,omitempty"`
	// RedemptionIssuers: Identifies which redemption issuers can redeem the pass
	// over Smart Tap. Redemption issuers are identified by their issuer ID.
	// Redemption issuers must have at least one Smart Tap key configured. The
	// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also
	// be set up correctly in order for a pass to support Smart Tap.
	RedemptionIssuers googleapi.Int64s `json:"redemptionIssuers,omitempty"`
	// Review: The review comments set by the platform when a class is marked
	// `approved` or `rejected`.
	Review *Review `json:"review,omitempty"`
	// ReviewStatus: Required. The status of the class. This field can be set to
	// `draft` or `underReview` using the insert, patch, or update API calls. Once
	// the review state is changed from `draft` it may not be changed back to
	// `draft`. You should keep this field to `draft` when the class is under
	// development. A `draft` class cannot be used to create any object. You should
	// set this field to `underReview` when you believe the class is ready for use.
	// The platform will automatically set this field to `approved` and it can be
	// immediately used to create or migrate objects. When updating an already
	// `approved` class you should keep setting this field to `underReview`.
	//
	// Possible values:
	//   "REVIEW_STATUS_UNSPECIFIED"
	//   "UNDER_REVIEW"
	//   "underReview" - Legacy alias for `UNDER_REVIEW`. Deprecated.
	//   "APPROVED"
	//   "approved" - Legacy alias for `APPROVED`. Deprecated.
	//   "REJECTED"
	//   "rejected" - Legacy alias for `REJECTED`. Deprecated.
	//   "DRAFT"
	//   "draft" - Legacy alias for `DRAFT`. Deprecated.
	ReviewStatus string `json:"reviewStatus,omitempty"`
	// RowLabel: The label to use for the row value
	// (`eventTicketObject.seatInfo.row`) on the card detail view. Each available
	// option maps to a set of localized strings, so that translations are shown to
	// the user based on their locale. Both `rowLabel` and `customRowLabel` may not
	// be set. If neither is set, the label will default to "Row", localized. If
	// the row field is unset, this label will not be used.
	//
	// Possible values:
	//   "ROW_LABEL_UNSPECIFIED"
	//   "ROW"
	//   "row" - Legacy alias for `ROW`. Deprecated.
	RowLabel string `json:"rowLabel,omitempty"`
	// SeatLabel: The label to use for the seat value
	// (`eventTicketObject.seatInfo.seat`) on the card detail view. Each available
	// option maps to a set of localized strings, so that translations are shown to
	// the user based on their locale. Both `seatLabel` and `customSeatLabel` may
	// not be set. If neither is set, the label will default to "Seat", localized.
	// If the seat field is unset, this label will not be used.
	//
	// Possible values:
	//   "SEAT_LABEL_UNSPECIFIED"
	//   "SEAT"
	//   "seat" - Legacy alias for `SEAT`. Deprecated.
	SeatLabel string `json:"seatLabel,omitempty"`
	// SectionLabel: The label to use for the section value
	// (`eventTicketObject.seatInfo.section`) on the card detail view. Each
	// available option maps to a set of localized strings, so that translations
	// are shown to the user based on their locale. Both `sectionLabel` and
	// `customSectionLabel` may not be set. If neither is set, the label will
	// default to "Section", localized. If the section field is unset, this label
	// will not be used.
	//
	// Possible values:
	//   "SECTION_LABEL_UNSPECIFIED"
	//   "SECTION"
	//   "section" - Legacy alias for `SECTION`. Deprecated.
	//   "THEATER"
	//   "theater" - Legacy alias for `THEATER`. Deprecated.
	SectionLabel string `json:"sectionLabel,omitempty"`
	// SecurityAnimation: Optional information about the security animation. If
	// this is set a security animation will be rendered on pass details.
	SecurityAnimation *SecurityAnimation `json:"securityAnimation,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the class. For a pass only ten will be displayed, prioritizing those from
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Venue: Event venue details.
	Venue *EventVenue `json:"venue,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`
	// ViewUnlockRequirement: View Unlock Requirement options for the event ticket.
	//
	// Possible values:
	//   "VIEW_UNLOCK_REQUIREMENT_UNSPECIFIED" - Default value, same as
	// UNLOCK_NOT_REQUIRED.
	//   "UNLOCK_NOT_REQUIRED" - Default behavior for all the existing Passes if
	// ViewUnlockRequirement is not set.
	//   "UNLOCK_REQUIRED_TO_VIEW" - Requires the user to unlock their device each
	// time the pass is viewed. If the user removes their device lock after saving
	// the pass, then they will be prompted to create a device lock before the pass
	// can be viewed.
	ViewUnlockRequirement string `json:"viewUnlockRequirement,omitempty"`
	// WideLogo: The wide logo of the ticket. When provided, this will be used in
	// place of the logo in the top left of the card view.
	WideLogo *Image `json:"wideLogo,omitempty"`
	// WordMark: Deprecated.
	WordMark *Image `json:"wordMark,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "AllowMultipleUsersPerObject") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMultipleUsersPerObject") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventTicketClass) MarshalJSON() ([]byte, error) {
	type NoMethod EventTicketClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventTicketClassAddMessageResponse struct {
	// Resource: The updated EventTicketClass resource.
	Resource *EventTicketClass `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventTicketClassAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EventTicketClassAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventTicketClassListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*EventTicketClass `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventTicketClassListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EventTicketClassListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventTicketObject struct {
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// class only object AppLinkData will be displayed.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// Barcode: The barcode type and value.
	Barcode *Barcode `json:"barcode,omitempty"`
	// ClassId: Required. The class associated with this object. The class must be
	// of the same type as this object, must already exist, and must be approved.
	// Class IDs should follow the format issuer ID.identifier where the former is
	// issued by Google and latter is chosen by you.
	ClassId string `json:"classId,omitempty"`
	// ClassReference: A copy of the inherited fields of the parent class. These
	// fields are retrieved during a GET.
	ClassReference *EventTicketClass `json:"classReference,omitempty"`
	// DisableExpirationNotification: Indicates if notifications should explicitly
	// be suppressed. If this field is set to true, regardless of the `messages`
	// field, expiration notifications to the user will be suppressed. By default,
	// this field is set to false. Currently, this can only be set for offers.
	DisableExpirationNotification bool `json:"disableExpirationNotification,omitempty"`
	// FaceValue: The face value of the ticket, matching what would be printed on a
	// physical version of the ticket.
	FaceValue *Money `json:"faceValue,omitempty"`
	// GroupingInfo: Information that controls how passes are grouped together.
	GroupingInfo *GroupingInfo `json:"groupingInfo,omitempty"`
	// HasLinkedDevice: Whether this object is currently linked to a single device.
	// This field is set by the platform when a user saves the object, linking it
	// to their device. Intended for use by select partners. Contact support for
	// additional information.
	HasLinkedDevice bool `json:"hasLinkedDevice,omitempty"`
	// HasUsers: Indicates if the object has users. This field is set by the
	// platform.
	HasUsers bool `json:"hasUsers,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, hero image of the class, if present, will be displayed. If hero
	// image of the class is also not present, nothing will be displayed.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// Id: Required. The unique identifier for an object. This ID must be unique
	// across all objects from an issuer. This value should follow the format
	// issuer ID.identifier where the former is issued by Google and latter is
	// chosen by you. The unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#eventTicketObject".
	Kind string `json:"kind,omitempty"`
	// LinkedObjectIds: linked_object_ids are a list of other objects such as event
	// ticket, loyalty, offer, generic, giftcard, transit and boarding pass that
	// should be automatically attached to this event ticket object. If a user had
	// saved this event ticket, then these linked_object_ids would be automatically
	// pushed to the user's wallet (unless they turned off the setting to receive
	// such linked passes). Make sure that objects present in linked_object_ids are
	// already inserted - if not, calls would fail. Once linked, the linked objects
	// cannot be unlinked. You cannot link objects belonging to another issuer.
	// There is a limit to the number of objects that can be linked to a single
	// object. After the limit is reached, new linked objects in the call will be
	// ignored silently. Object IDs should follow the format issuer ID. identifier
	// where the former is issued by Google and the latter is chosen by you.
	LinkedObjectIds []string `json:"linkedObjectIds,omitempty"`
	// LinkedOfferIds: A list of offer objects linked to this event ticket. The
	// offer objects must already exist. Offer object IDs should follow the format
	// issuer ID. identifier where the former is issued by Google and latter is
	// chosen by you.
	LinkedOfferIds []string `json:"linkedOfferIds,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the class, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// PassConstraints: Pass constraints for the object. Includes limiting NFC and
	// screenshot behaviors.
	PassConstraints *PassConstraints `json:"passConstraints,omitempty"`
	// ReservationInfo: Reservation details for this ticket. This is expected to be
	// shared amongst all tickets that were purchased in the same order.
	ReservationInfo *EventReservationInfo `json:"reservationInfo,omitempty"`
	// RotatingBarcode: The rotating barcode type and value.
	RotatingBarcode *RotatingBarcode `json:"rotatingBarcode,omitempty"`
	// SaveRestrictions: Restrictions on the object that needs to be verified
	// before the user tries to save the pass. Note that this restrictions will
	// only be applied during save time. If the restrictions changed after a user
	// saves the pass, the new restrictions will not be applied to an already saved
	// pass.
	SaveRestrictions *SaveRestrictions `json:"saveRestrictions,omitempty"`
	// SeatInfo: Seating details for this ticket.
	SeatInfo *EventSeat `json:"seatInfo,omitempty"`
	// SmartTapRedemptionValue: The value that will be transmitted to a Smart Tap
	// certified terminal over NFC for this object. The class level fields
	// `enableSmartTap` and `redemptionIssuers` must also be set up correctly in
	// order for the pass to support Smart Tap. Only ASCII characters are
	// supported.
	SmartTapRedemptionValue string `json:"smartTapRedemptionValue,omitempty"`
	// State: Required. The state of the object. This field is used to determine
	// how an object is displayed in the app. For example, an `inactive` object is
	// moved to the "Expired passes" section.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "ACTIVE" - Object is active and displayed to with other active objects.
	//   "active" - Legacy alias for `ACTIVE`. Deprecated.
	//   "COMPLETED"
	//   "completed" - Legacy alias for `COMPLETED`. Deprecated.
	//   "EXPIRED" - Object is no longer valid (`validTimeInterval` passed).
	//   "expired" - Legacy alias for `EXPIRED`. Deprecated.
	//   "INACTIVE"
	//   "inactive" - Legacy alias for `INACTIVE`. Deprecated.
	State string `json:"state,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// TicketHolderName: Name of the ticket holder, if the ticket is assigned to a
	// person. E.g. "John Doe" or "Jane Doe".
	TicketHolderName string `json:"ticketHolderName,omitempty"`
	// TicketNumber: The number of the ticket. This can be a unique identifier
	// across all tickets in an issuer's system, all tickets for the event (e.g.
	// XYZ1234512345), or all tickets in the order (1, 2, 3, etc.).
	TicketNumber string `json:"ticketNumber,omitempty"`
	// TicketType: The type of the ticket, such as "Adult" or "Child", or "VIP" or
	// "Standard".
	TicketType *LocalizedString `json:"ticketType,omitempty"`
	// ValidTimeInterval: The time period this object will be `active` and object
	// can be used. An object's state will be changed to `expired` when this time
	// period has passed.
	ValidTimeInterval *TimeInterval `json:"validTimeInterval,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppLinkData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppLinkData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventTicketObject) MarshalJSON() ([]byte, error) {
	type NoMethod EventTicketObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventTicketObjectAddMessageResponse struct {
	// Resource: The updated EventTicketObject resource.
	Resource *EventTicketObject `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventTicketObjectAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EventTicketObjectAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventTicketObjectListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*EventTicketObject `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventTicketObjectListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EventTicketObjectListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventVenue struct {
	// Address: The address of the venue, such as "24 Willie Mays Plaza\nSan
	// Francisco, CA 94107". Address lines are separated by line feed (`\n`)
	// characters. This is required.
	Address *LocalizedString `json:"address,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#eventVenue".
	Kind string `json:"kind,omitempty"`
	// Name: The name of the venue, such as "AT&T Park". This is required.
	Name *LocalizedString `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventVenue) MarshalJSON() ([]byte, error) {
	type NoMethod EventVenue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExpiryNotification: Indicates that the issuer would like Google Wallet to
// send expiry notifications 2 days prior to the card expiration.
type ExpiryNotification struct {
	// EnableNotification: Indicates if the object needs to have expiry
	// notification enabled.
	EnableNotification bool `json:"enableNotification,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableNotification") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableNotification") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExpiryNotification) MarshalJSON() ([]byte, error) {
	type NoMethod ExpiryNotification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldReference: Reference definition to use with field overrides.
type FieldReference struct {
	// DateFormat: Only valid if the `fieldPath` references a date field. Chooses
	// how the date field will be formatted and displayed in the UI.
	//
	// Possible values:
	//   "DATE_FORMAT_UNSPECIFIED" - Default option when no format is specified,
	// when selected, no formatting will be applied.
	//   "DATE_TIME" - Renders `2018-12-14T13:00:00` as `Dec 14, 1:00 PM` in
	// `en_US`.
	//   "dateTime" - Legacy alias for `DATE_TIME`. Deprecated.
	//   "DATE_ONLY" - Renders `2018-12-14T13:00:00` as `Dec 14` in `en_US`.
	//   "dateOnly" - Legacy alias for `DATE_ONLY`. Deprecated.
	//   "TIME_ONLY" - Renders `2018-12-14T13:00:00` as `1:00 PM` in `en_US`.
	//   "timeOnly" - Legacy alias for `TIME_ONLY`. Deprecated.
	//   "DATE_TIME_YEAR" - Renders `2018-12-14T13:00:00` as `Dec 14, 2018, 1:00
	// PM` in `en_US`.
	//   "dateTimeYear" - Legacy alias for `DATE_TIME_YEAR`. Deprecated.
	//   "DATE_YEAR" - Renders `2018-12-14T13:00:00` as `Dec 14, 2018` in `en_US`.
	//   "dateYear" - Legacy alias for `DATE_YEAR`. Deprecated.
	//   "YEAR_MONTH" - Renders `2018-12-14T13:00:00` as `2018-12`.
	//   "YEAR_MONTH_DAY" - Renders `2018-12-14T13:00:00` as `2018-12-14`.
	DateFormat string `json:"dateFormat,omitempty"`
	// FieldPath: Path to the field being referenced, prefixed with "object" or
	// "class" and separated with dots. For example, it may be the string
	// "object.purchaseDetails.purchasePrice".
	FieldPath string `json:"fieldPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DateFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DateFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldReference) MarshalJSON() ([]byte, error) {
	type NoMethod FieldReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldSelector: Custom field selector to use with field overrides.
type FieldSelector struct {
	// Fields: If more than one reference is supplied, then the first one that
	// references a non-empty field will be displayed.
	Fields []*FieldReference `json:"fields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldSelector) MarshalJSON() ([]byte, error) {
	type NoMethod FieldSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FirstRowOption struct {
	// FieldOption: A reference to the field to be displayed in the first row.
	FieldOption *FieldSelector `json:"fieldOption,omitempty"`
	// Possible values:
	//   "TRANSIT_OPTION_UNSPECIFIED"
	//   "ORIGIN_AND_DESTINATION_NAMES"
	//   "originAndDestinationNames" - Legacy alias for
	// `ORIGIN_AND_DESTINATION_NAMES`. Deprecated.
	//   "ORIGIN_AND_DESTINATION_CODES"
	//   "originAndDestinationCodes" - Legacy alias for
	// `ORIGIN_AND_DESTINATION_CODES`. Deprecated.
	//   "ORIGIN_NAME"
	//   "originName" - Legacy alias for `ORIGIN_NAME`. Deprecated.
	TransitOption string `json:"transitOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldOption") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FirstRowOption) MarshalJSON() ([]byte, error) {
	type NoMethod FirstRowOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightCarrier struct {
	// AirlineAllianceLogo: A logo for the airline alliance, displayed below the QR
	// code that the passenger scans to board.
	AirlineAllianceLogo *Image `json:"airlineAllianceLogo,omitempty"`
	// AirlineLogo: A logo for the airline described by carrierIataCode and
	// localizedAirlineName. This logo will be rendered at the top of the detailed
	// card view.
	AirlineLogo *Image `json:"airlineLogo,omitempty"`
	// AirlineName: A localized name of the airline specified by carrierIataCode.
	// If unset, `issuer_name` or `localized_issuer_name` from `FlightClass` will
	// be used for display purposes. eg: "Swiss Air" for "LX"
	AirlineName *LocalizedString `json:"airlineName,omitempty"`
	// CarrierIataCode: Two character IATA airline code of the marketing carrier
	// (as opposed to operating carrier). Exactly one of this or `carrierIcaoCode`
	// needs to be provided for `carrier` and `operatingCarrier`. eg: "LX" for
	// Swiss Air
	CarrierIataCode string `json:"carrierIataCode,omitempty"`
	// CarrierIcaoCode: Three character ICAO airline code of the marketing carrier
	// (as opposed to operating carrier). Exactly one of this or `carrierIataCode`
	// needs to be provided for `carrier` and `operatingCarrier`. eg: "EZY" for
	// Easy Jet
	CarrierIcaoCode string `json:"carrierIcaoCode,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#flightCarrier".
	Kind string `json:"kind,omitempty"`
	// WideAirlineLogo: The wide logo of the airline. When provided, this will be
	// used in place of the airline logo in the top left of the card view.
	WideAirlineLogo *Image `json:"wideAirlineLogo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AirlineAllianceLogo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AirlineAllianceLogo") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightCarrier) MarshalJSON() ([]byte, error) {
	type NoMethod FlightCarrier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightClass struct {
	// AllowMultipleUsersPerObject: Deprecated. Use
	// `multipleDevicesAndHoldersAllowedStatus` instead.
	AllowMultipleUsersPerObject bool `json:"allowMultipleUsersPerObject,omitempty"`
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// object that will be used instead.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// BoardingAndSeatingPolicy: Policies for boarding and seating. These will
	// inform which labels will be shown to users.
	BoardingAndSeatingPolicy *BoardingAndSeatingPolicy `json:"boardingAndSeatingPolicy,omitempty"`
	// CallbackOptions: Callback options to be used to call the issuer back for
	// every save/delete of an object for this class by the end-user. All objects
	// of this class are eligible for the callback.
	CallbackOptions *CallbackOptions `json:"callbackOptions,omitempty"`
	// ClassTemplateInfo: Template information about how the class should be
	// displayed. If unset, Google will fallback to a default set of fields to
	// display.
	ClassTemplateInfo *ClassTemplateInfo `json:"classTemplateInfo,omitempty"`
	// CountryCode: Country code used to display the card's country (when the user
	// is not in that country), as well as to display localized content when
	// content is not available in the user's locale.
	CountryCode string `json:"countryCode,omitempty"`
	// Destination: Required. Destination airport.
	Destination *AirportInfo `json:"destination,omitempty"`
	// EnableSmartTap: Identifies whether this class supports Smart Tap. The
	// `redemptionIssuers` and object level `smartTapRedemptionLevel` fields must
	// also be set up correctly in order for a pass to support Smart Tap.
	EnableSmartTap bool `json:"enableSmartTap,omitempty"`
	// FlightHeader: Required. Information about the flight carrier and number.
	FlightHeader *FlightHeader `json:"flightHeader,omitempty"`
	// FlightStatus: Status of this flight. If unset, Google will compute status
	// based on data from other sources, such as FlightStats, etc. Note:
	// Google-computed status will not be returned in API responses.
	//
	// Possible values:
	//   "FLIGHT_STATUS_UNSPECIFIED"
	//   "SCHEDULED" - Flight is on time, early, or delayed.
	//   "scheduled" - Legacy alias for `SCHEDULED`. Deprecated.
	//   "ACTIVE" - Flight is in progress (taxiing, taking off, landing, airborne).
	//   "active" - Legacy alias for `ACTIVE`. Deprecated.
	//   "LANDED" - Flight landed at the original destination.
	//   "landed" - Legacy alias for `LANDED`. Deprecated.
	//   "CANCELLED" - Flight is cancelled.
	//   "cancelled" - Legacy alias for `CANCELLED`. Deprecated.
	//   "REDIRECTED" - Flight is airborne but heading to a different airport than
	// the original destination.
	//   "redirected" - Legacy alias for `REDIRECTED`. Deprecated.
	//   "DIVERTED" - Flight has already landed at a different airport than the
	// original destination.
	//   "diverted" - Legacy alias for `DIVERTED`. Deprecated.
	FlightStatus string `json:"flightStatus,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, nothing will be displayed. The image will display at 100% width.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// HomepageUri: The URI of your application's home page. Populating the URI in
	// this field results in the exact same behavior as populating an URI in
	// linksModuleData (when an object is rendered, a link to the homepage is shown
	// in what would usually be thought of as the linksModuleData section of the
	// object).
	HomepageUri *Uri `json:"homepageUri,omitempty"`
	// Id: Required. The unique identifier for a class. This ID must be unique
	// across all classes from an issuer. This value should follow the format
	// issuer ID. identifier where the former is issued by Google and latter is
	// chosen by you. Your unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// IssuerName: Required. The issuer name. Recommended maximum length is 20
	// characters to ensure full string is displayed on smaller screens.
	IssuerName string `json:"issuerName,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#flightClass".
	Kind string `json:"kind,omitempty"`
	// LanguageOverride: If this field is present, boarding passes served to a
	// user's device will always be in this language. Represents the BCP 47
	// language tag. Example values are "en-US", "en-GB", "de", or "de-AT".
	LanguageOverride string `json:"languageOverride,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the object, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// LocalBoardingDateTime: The boarding time as it would be printed on the
	// boarding pass. This is an ISO 8601 extended format date/time without an
	// offset. Time may be specified up to millisecond precision. eg:
	// `2027-03-05T06:30:00` This should be the local date/time at the airport (not
	// a UTC time). Google will reject the request if UTC offset is provided. Time
	// zones will be calculated by Google based on departure airport.
	LocalBoardingDateTime string `json:"localBoardingDateTime,omitempty"`
	// LocalEstimatedOrActualArrivalDateTime: The estimated time the aircraft plans
	// to reach the destination gate (not the runway) or the actual time it reached
	// the gate. This field should be set if at least one of the below is true: -
	// It differs from the scheduled time. Google will use it to calculate the
	// delay. - The aircraft already arrived at the gate. Google will use it to
	// inform the user that the flight has arrived at the gate. This is an ISO 8601
	// extended format date/time without an offset. Time may be specified up to
	// millisecond precision. eg: `2027-03-05T06:30:00` This should be the local
	// date/time at the airport (not a UTC time). Google will reject the request if
	// UTC offset is provided. Time zones will be calculated by Google based on
	// arrival airport.
	LocalEstimatedOrActualArrivalDateTime string `json:"localEstimatedOrActualArrivalDateTime,omitempty"`
	// LocalEstimatedOrActualDepartureDateTime: The estimated time the aircraft
	// plans to pull from the gate or the actual time the aircraft already pulled
	// from the gate. Note: This is not the runway time. This field should be set
	// if at least one of the below is true: - It differs from the scheduled time.
	// Google will use it to calculate the delay. - The aircraft already pulled
	// from the gate. Google will use it to inform the user when the flight
	// actually departed. This is an ISO 8601 extended format date/time without an
	// offset. Time may be specified up to millisecond precision. eg:
	// `2027-03-05T06:30:00` This should be the local date/time at the airport (not
	// a UTC time). Google will reject the request if UTC offset is provided. Time
	// zones will be calculated by Google based on departure airport.
	LocalEstimatedOrActualDepartureDateTime string `json:"localEstimatedOrActualDepartureDateTime,omitempty"`
	// LocalGateClosingDateTime: The gate closing time as it would be printed on
	// the boarding pass. Do not set this field if you do not want to print it in
	// the boarding pass. This is an ISO 8601 extended format date/time without an
	// offset. Time may be specified up to millisecond precision. eg:
	// `2027-03-05T06:30:00` This should be the local date/time at the airport (not
	// a UTC time). Google will reject the request if UTC offset is provided. Time
	// zones will be calculated by Google based on departure airport.
	LocalGateClosingDateTime string `json:"localGateClosingDateTime,omitempty"`
	// LocalScheduledArrivalDateTime: The scheduled time the aircraft plans to
	// reach the destination gate (not the runway). Note: This field should not
	// change too close to the flight time. For updates to departure times (delays,
	// etc), please set `localEstimatedOrActualArrivalDateTime`. This is an ISO
	// 8601 extended format date/time without an offset. Time may be specified up
	// to millisecond precision. eg: `2027-03-05T06:30:00` This should be the local
	// date/time at the airport (not a UTC time). Google will reject the request if
	// UTC offset is provided. Time zones will be calculated by Google based on
	// arrival airport.
	LocalScheduledArrivalDateTime string `json:"localScheduledArrivalDateTime,omitempty"`
	// LocalScheduledDepartureDateTime: Required. The scheduled date and time when
	// the aircraft is expected to depart the gate (not the runway) Note: This
	// field should not change too close to the departure time. For updates to
	// departure times (delays, etc), please set
	// `localEstimatedOrActualDepartureDateTime`. This is an ISO 8601 extended
	// format date/time without an offset. Time may be specified up to millisecond
	// precision. eg: `2027-03-05T06:30:00` This should be the local date/time at
	// the airport (not a UTC time). Google will reject the request if UTC offset
	// is provided. Time zones will be calculated by Google based on departure
	// airport.
	LocalScheduledDepartureDateTime string `json:"localScheduledDepartureDateTime,omitempty"`
	// LocalizedIssuerName: Translated strings for the issuer_name. Recommended
	// maximum length is 20 characters to ensure full string is displayed on
	// smaller screens.
	LocalizedIssuerName *LocalizedString `json:"localizedIssuerName,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// MultipleDevicesAndHoldersAllowedStatus: Identifies whether multiple users
	// and devices will save the same object referencing this class.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified preference.
	//   "MULTIPLE_HOLDERS" - The Pass object is shareable by a user and can be
	// saved by any number of different users, and on any number of devices.
	// Partners typically use this setup for passes that do not need to be
	// restricted to a single user or pinned to a single device.
	//   "ONE_USER_ALL_DEVICES" - An object can only be saved by one user, but this
	// user can view and use it on multiple of their devices. Once the first user
	// saves the object, no other user will be allowed to view or save it.
	//   "ONE_USER_ONE_DEVICE" - An object can only be saved by one user on a
	// single device. Intended for use by select partners in limited circumstances.
	// An example use case is a transit ticket that should be "device pinned",
	// meaning it can be saved, viewed and used only by a single user on a single
	// device. Contact support for additional information.
	//   "multipleHolders" - Legacy alias for `MULTIPLE_HOLDERS`. Deprecated.
	//   "oneUserAllDevices" - Legacy alias for `ONE_USER_ALL_DEVICES`. Deprecated.
	//   "oneUserOneDevice" - Legacy alias for `ONE_USER_ONE_DEVICE`. Deprecated.
	MultipleDevicesAndHoldersAllowedStatus string `json:"multipleDevicesAndHoldersAllowedStatus,omitempty"`
	// Origin: Required. Origin airport.
	Origin *AirportInfo `json:"origin,omitempty"`
	// RedemptionIssuers: Identifies which redemption issuers can redeem the pass
	// over Smart Tap. Redemption issuers are identified by their issuer ID.
	// Redemption issuers must have at least one Smart Tap key configured. The
	// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also
	// be set up correctly in order for a pass to support Smart Tap.
	RedemptionIssuers googleapi.Int64s `json:"redemptionIssuers,omitempty"`
	// Review: The review comments set by the platform when a class is marked
	// `approved` or `rejected`.
	Review *Review `json:"review,omitempty"`
	// ReviewStatus: Required. The status of the class. This field can be set to
	// `draft` or `underReview` using the insert, patch, or update API calls. Once
	// the review state is changed from `draft` it may not be changed back to
	// `draft`. You should keep this field to `draft` when the class is under
	// development. A `draft` class cannot be used to create any object. You should
	// set this field to `underReview` when you believe the class is ready for use.
	// The platform will automatically set this field to `approved` and it can be
	// immediately used to create or migrate objects. When updating an already
	// `approved` class you should keep setting this field to `underReview`.
	//
	// Possible values:
	//   "REVIEW_STATUS_UNSPECIFIED"
	//   "UNDER_REVIEW"
	//   "underReview" - Legacy alias for `UNDER_REVIEW`. Deprecated.
	//   "APPROVED"
	//   "approved" - Legacy alias for `APPROVED`. Deprecated.
	//   "REJECTED"
	//   "rejected" - Legacy alias for `REJECTED`. Deprecated.
	//   "DRAFT"
	//   "draft" - Legacy alias for `DRAFT`. Deprecated.
	ReviewStatus string `json:"reviewStatus,omitempty"`
	// SecurityAnimation: Optional information about the security animation. If
	// this is set a security animation will be rendered on pass details.
	SecurityAnimation *SecurityAnimation `json:"securityAnimation,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the class. For a pass only ten will be displayed, prioritizing those from
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`
	// ViewUnlockRequirement: View Unlock Requirement options for the boarding
	// pass.
	//
	// Possible values:
	//   "VIEW_UNLOCK_REQUIREMENT_UNSPECIFIED" - Default value, same as
	// UNLOCK_NOT_REQUIRED.
	//   "UNLOCK_NOT_REQUIRED" - Default behavior for all the existing Passes if
	// ViewUnlockRequirement is not set.
	//   "UNLOCK_REQUIRED_TO_VIEW" - Requires the user to unlock their device each
	// time the pass is viewed. If the user removes their device lock after saving
	// the pass, then they will be prompted to create a device lock before the pass
	// can be viewed.
	ViewUnlockRequirement string `json:"viewUnlockRequirement,omitempty"`
	// WordMark: Deprecated.
	WordMark *Image `json:"wordMark,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "AllowMultipleUsersPerObject") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMultipleUsersPerObject") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightClass) MarshalJSON() ([]byte, error) {
	type NoMethod FlightClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightClassAddMessageResponse struct {
	// Resource: The updated FlightClass resource.
	Resource *FlightClass `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightClassAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FlightClassAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightClassListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*FlightClass `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightClassListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FlightClassListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightHeader struct {
	// Carrier: Information about airline carrier. This is a required property of
	// `flightHeader`.
	Carrier *FlightCarrier `json:"carrier,omitempty"`
	// FlightNumber: The flight number without IATA carrier code. This field should
	// contain only digits. This is a required property of `flightHeader`. eg:
	// "123"
	FlightNumber string `json:"flightNumber,omitempty"`
	// FlightNumberDisplayOverride: Override value to use for flight number. The
	// default value used for display purposes is carrier + flight_number. If a
	// different value needs to be shown to passengers, use this field to override
	// the default behavior. eg: "XX1234 / YY576"
	FlightNumberDisplayOverride string `json:"flightNumberDisplayOverride,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#flightHeader".
	Kind string `json:"kind,omitempty"`
	// OperatingCarrier: Information about operating airline carrier.
	OperatingCarrier *FlightCarrier `json:"operatingCarrier,omitempty"`
	// OperatingFlightNumber: The flight number used by the operating carrier
	// without IATA carrier code. This field should contain only digits. eg: "234"
	OperatingFlightNumber string `json:"operatingFlightNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Carrier") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Carrier") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightHeader) MarshalJSON() ([]byte, error) {
	type NoMethod FlightHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightObject struct {
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// class only object AppLinkData will be displayed.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// Barcode: The barcode type and value.
	Barcode *Barcode `json:"barcode,omitempty"`
	// BoardingAndSeatingInfo: Passenger specific information about boarding and
	// seating.
	BoardingAndSeatingInfo *BoardingAndSeatingInfo `json:"boardingAndSeatingInfo,omitempty"`
	// ClassId: Required. The class associated with this object. The class must be
	// of the same type as this object, must already exist, and must be approved.
	// Class IDs should follow the format issuer ID.identifier where the former is
	// issued by Google and latter is chosen by you.
	ClassId string `json:"classId,omitempty"`
	// ClassReference: A copy of the inherited fields of the parent class. These
	// fields are retrieved during a GET.
	ClassReference *FlightClass `json:"classReference,omitempty"`
	// DisableExpirationNotification: Indicates if notifications should explicitly
	// be suppressed. If this field is set to true, regardless of the `messages`
	// field, expiration notifications to the user will be suppressed. By default,
	// this field is set to false. Currently, this can only be set for Flights.
	DisableExpirationNotification bool `json:"disableExpirationNotification,omitempty"`
	// GroupingInfo: Information that controls how passes are grouped together.
	GroupingInfo *GroupingInfo `json:"groupingInfo,omitempty"`
	// HasLinkedDevice: Whether this object is currently linked to a single device.
	// This field is set by the platform when a user saves the object, linking it
	// to their device. Intended for use by select partners. Contact support for
	// additional information.
	HasLinkedDevice bool `json:"hasLinkedDevice,omitempty"`
	// HasUsers: Indicates if the object has users. This field is set by the
	// platform.
	HasUsers bool `json:"hasUsers,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, hero image of the class, if present, will be displayed. If hero
	// image of the class is also not present, nothing will be displayed.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// Id: Required. The unique identifier for an object. This ID must be unique
	// across all objects from an issuer. This value should follow the format
	// issuer ID.identifier where the former is issued by Google and latter is
	// chosen by you. The unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#flightObject".
	Kind string `json:"kind,omitempty"`
	// LinkedObjectIds: linked_object_ids are a list of other objects such as event
	// ticket, loyalty, offer, generic, giftcard, transit and boarding pass that
	// should be automatically attached to this flight object. If a user had saved
	// this boarding pass, then these linked_object_ids would be automatically
	// pushed to the user's wallet (unless they turned off the setting to receive
	// such linked passes). Make sure that objects present in linked_object_ids are
	// already inserted - if not, calls would fail. Once linked, the linked objects
	// cannot be unlinked. You cannot link objects belonging to another issuer.
	// There is a limit to the number of objects that can be linked to a single
	// object. After the limit is reached, new linked objects in the call will be
	// ignored silently. Object IDs should follow the format issuer ID. identifier
	// where the former is issued by Google and the latter is chosen by you.
	LinkedObjectIds []string `json:"linkedObjectIds,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the class, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// PassConstraints: Pass constraints for the object. Includes limiting NFC and
	// screenshot behaviors.
	PassConstraints *PassConstraints `json:"passConstraints,omitempty"`
	// PassengerName: Required. Passenger name as it would appear on the boarding
	// pass. eg: "Dave M Gahan" or "Gahan/Dave" or "GAHAN/DAVEM"
	PassengerName string `json:"passengerName,omitempty"`
	// ReservationInfo: Required. Information about flight reservation.
	ReservationInfo *ReservationInfo `json:"reservationInfo,omitempty"`
	// RotatingBarcode: The rotating barcode type and value.
	RotatingBarcode *RotatingBarcode `json:"rotatingBarcode,omitempty"`
	// SaveRestrictions: Restrictions on the object that needs to be verified
	// before the user tries to save the pass. Note that this restrictions will
	// only be applied during save time. If the restrictions changed after a user
	// saves the pass, the new restrictions will not be applied to an already saved
	// pass.
	SaveRestrictions *SaveRestrictions `json:"saveRestrictions,omitempty"`
	// SecurityProgramLogo: An image for the security program that applies to the
	// passenger.
	SecurityProgramLogo *Image `json:"securityProgramLogo,omitempty"`
	// SmartTapRedemptionValue: The value that will be transmitted to a Smart Tap
	// certified terminal over NFC for this object. The class level fields
	// `enableSmartTap` and `redemptionIssuers` must also be set up correctly in
	// order for the pass to support Smart Tap. Only ASCII characters are
	// supported.
	SmartTapRedemptionValue string `json:"smartTapRedemptionValue,omitempty"`
	// State: Required. The state of the object. This field is used to determine
	// how an object is displayed in the app. For example, an `inactive` object is
	// moved to the "Expired passes" section.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "ACTIVE" - Object is active and displayed to with other active objects.
	//   "active" - Legacy alias for `ACTIVE`. Deprecated.
	//   "COMPLETED"
	//   "completed" - Legacy alias for `COMPLETED`. Deprecated.
	//   "EXPIRED" - Object is no longer valid (`validTimeInterval` passed).
	//   "expired" - Legacy alias for `EXPIRED`. Deprecated.
	//   "INACTIVE"
	//   "inactive" - Legacy alias for `INACTIVE`. Deprecated.
	State string `json:"state,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValidTimeInterval: The time period this object will be `active` and object
	// can be used. An object's state will be changed to `expired` when this time
	// period has passed.
	ValidTimeInterval *TimeInterval `json:"validTimeInterval,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppLinkData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppLinkData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightObject) MarshalJSON() ([]byte, error) {
	type NoMethod FlightObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightObjectAddMessageResponse struct {
	// Resource: The updated FlightObject resource.
	Resource *FlightObject `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightObjectAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FlightObjectAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightObjectListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*FlightObject `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightObjectListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FlightObjectListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FrequentFlyerInfo struct {
	// FrequentFlyerNumber: Frequent flyer number. Required for each nested object
	// of kind `walletobjects#frequentFlyerInfo`.
	FrequentFlyerNumber string `json:"frequentFlyerNumber,omitempty"`
	// FrequentFlyerProgramName: Frequent flyer program name. eg: "Lufthansa Miles
	// & More"
	FrequentFlyerProgramName *LocalizedString `json:"frequentFlyerProgramName,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#frequentFlyerInfo".
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FrequentFlyerNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FrequentFlyerNumber") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FrequentFlyerInfo) MarshalJSON() ([]byte, error) {
	type NoMethod FrequentFlyerInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenericClass: Generic Class
type GenericClass struct {
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// object that will be used instead.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// CallbackOptions: Callback options to be used to call the issuer back for
	// every save/delete of an object for this class by the end-user. All objects
	// of this class are eligible for the callback.
	CallbackOptions *CallbackOptions `json:"callbackOptions,omitempty"`
	// ClassTemplateInfo: Template information about how the class should be
	// displayed. If unset, Google will fallback to a default set of fields to
	// display.
	ClassTemplateInfo *ClassTemplateInfo `json:"classTemplateInfo,omitempty"`
	// EnableSmartTap: Available only to Smart Tap enabled partners. Contact
	// support for additional guidance.
	EnableSmartTap bool `json:"enableSmartTap,omitempty"`
	// Id: Required. The unique identifier for the class. This ID must be unique
	// across all from an issuer. This value needs to follow the format
	// `issuerID.identifier` where `issuerID` is issued by Google and `identifier`
	// is chosen by you. The unique identifier can only include alphanumeric
	// characters, `.`, `_`, or `-`.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. If `imageModulesData` is also defined
	// on the object, both will be displayed. Only one of the image from class and
	// one from object level will be rendered when both set.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// LinksModuleData: Links module data. If `linksModuleData` is also defined on
	// the object, both will be displayed. The maximum number of these fields
	// displayed is 10 from class and 10 from object.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// MultipleDevicesAndHoldersAllowedStatus: Identifies whether multiple users
	// and devices will save the same object referencing this class.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified preference.
	//   "MULTIPLE_HOLDERS" - The Pass object is shareable by a user and can be
	// saved by any number of different users, and on any number of devices.
	// Partners typically use this setup for passes that do not need to be
	// restricted to a single user or pinned to a single device.
	//   "ONE_USER_ALL_DEVICES" - An object can only be saved by one user, but this
	// user can view and use it on multiple of their devices. Once the first user
	// saves the object, no other user will be allowed to view or save it.
	//   "ONE_USER_ONE_DEVICE" - An object can only be saved by one user on a
	// single device. Intended for use by select partners in limited circumstances.
	// An example use case is a transit ticket that should be "device pinned",
	// meaning it can be saved, viewed and used only by a single user on a single
	// device. Contact support for additional information.
	//   "multipleHolders" - Legacy alias for `MULTIPLE_HOLDERS`. Deprecated.
	//   "oneUserAllDevices" - Legacy alias for `ONE_USER_ALL_DEVICES`. Deprecated.
	//   "oneUserOneDevice" - Legacy alias for `ONE_USER_ONE_DEVICE`. Deprecated.
	MultipleDevicesAndHoldersAllowedStatus string `json:"multipleDevicesAndHoldersAllowedStatus,omitempty"`
	// RedemptionIssuers: Identifies which redemption issuers can redeem the pass
	// over Smart Tap. Redemption issuers are identified by their issuer ID.
	// Redemption issuers must have at least one Smart Tap key configured. The
	// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also
	// be set up correctly in order for a pass to support Smart Tap.
	RedemptionIssuers googleapi.Int64s `json:"redemptionIssuers,omitempty"`
	// SecurityAnimation: Optional information about the security animation. If
	// this is set a security animation will be rendered on pass details.
	SecurityAnimation *SecurityAnimation `json:"securityAnimation,omitempty"`
	// TextModulesData: Text module data. If `textModulesData` is also defined on
	// the object, both will be displayed. The maximum number of these fields
	// displayed is 10 from class and 10 from object.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the class. For a pass only ten will be displayed, prioritizing those from
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// ViewUnlockRequirement: View Unlock Requirement options for the generic pass.
	//
	// Possible values:
	//   "VIEW_UNLOCK_REQUIREMENT_UNSPECIFIED" - Default value, same as
	// UNLOCK_NOT_REQUIRED.
	//   "UNLOCK_NOT_REQUIRED" - Default behavior for all the existing Passes if
	// ViewUnlockRequirement is not set.
	//   "UNLOCK_REQUIRED_TO_VIEW" - Requires the user to unlock their device each
	// time the pass is viewed. If the user removes their device lock after saving
	// the pass, then they will be prompted to create a device lock before the pass
	// can be viewed.
	ViewUnlockRequirement string `json:"viewUnlockRequirement,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppLinkData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppLinkData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenericClass) MarshalJSON() ([]byte, error) {
	type NoMethod GenericClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenericClassAddMessageResponse: Response to adding a new issuer message to
// the class. This contains the entire updated GenericClass.
type GenericClassAddMessageResponse struct {
	// Resource: The updated EventTicketClass resource.
	Resource *GenericClass `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenericClassAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenericClassAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenericClassListResponse: List response which contains the list of all
// generic classes for a given issuer ID.
type GenericClassListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*GenericClass `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenericClassListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenericClassListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenericObject: Generic Object
type GenericObject struct {
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// class only object AppLinkData will be displayed.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// Barcode: The barcode type and value. If pass does not have a barcode, we can
	// allow the issuer to set Barcode.alternate_text and display just that.
	Barcode *Barcode `json:"barcode,omitempty"`
	// CardTitle: Required. The header of the pass. This is usually the Business
	// name such as "XXX Gym", "AAA Insurance". This field is required and appears
	// in the header row at the very top of the pass.
	CardTitle *LocalizedString `json:"cardTitle,omitempty"`
	// ClassId: Required. The class associated with this object. The class must be
	// of the same type as this object, must already exist, and must be approved.
	// Class IDs should follow the format `issuerID.identifier` where `issuerID` is
	// issued by Google and `identifier` is chosen by you.
	ClassId string `json:"classId,omitempty"`
	// GenericType: Specify which `GenericType` the card belongs to.
	//
	// Possible values:
	//   "GENERIC_TYPE_UNSPECIFIED" - Unspecified generic type.
	//   "GENERIC_SEASON_PASS" - Season pass
	//   "GENERIC_UTILITY_BILLS" - Utility bills
	//   "GENERIC_PARKING_PASS" - Parking pass
	//   "GENERIC_VOUCHER" - Voucher
	//   "GENERIC_GYM_MEMBERSHIP" - Gym membership cards
	//   "GENERIC_LIBRARY_MEMBERSHIP" - Library membership cards
	//   "GENERIC_RESERVATIONS" - Reservations
	//   "GENERIC_AUTO_INSURANCE" - Auto-insurance cards
	//   "GENERIC_HOME_INSURANCE" - Home-insurance cards
	//   "GENERIC_ENTRY_TICKET" - Entry tickets
	//   "GENERIC_RECEIPT" - Receipts
	//   "GENERIC_OTHER" - Other type
	GenericType string `json:"genericType,omitempty"`
	// GroupingInfo: Information that controls how passes are grouped together.
	GroupingInfo *GroupingInfo `json:"groupingInfo,omitempty"`
	// HasUsers: Indicates if the object has users. This field is set by the
	// platform.
	HasUsers bool `json:"hasUsers,omitempty"`
	// Header: Required. The title of the pass, such as "50% off coupon" or
	// "Library card" or "Voucher". This field is required and appears in the title
	// row of the pass detail view.
	Header *LocalizedString `json:"header,omitempty"`
	// HeroImage: Banner image displayed on the front of the card if present. The
	// image will be displayed at 100% width.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set, the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used and if logo is not set, a color would be
	// chosen by Google.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// Id: Required. The unique identifier for an object. This ID must be unique
	// across all objects from an issuer. This value needs to follow the format
	// `issuerID.identifier` where `issuerID` is issued by Google and `identifier`
	// is chosen by you. The unique identifier can only include alphanumeric
	// characters, `.`, `_`, or `-`.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. Only one of the image from class and
	// one from object level will be rendered when both set.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// LinkedObjectIds: linked_object_ids are a list of other objects such as event
	// ticket, loyalty, offer, generic, giftcard, transit and boarding pass that
	// should be automatically attached to this generic object. If a user had saved
	// this generic card, then these linked_object_ids would be automatically
	// pushed to the user's wallet (unless they turned off the setting to receive
	// such linked passes). Make sure that objects present in linked_object_ids are
	// already inserted - if not, calls would fail. Once linked, the linked objects
	// cannot be unlinked. You cannot link objects belonging to another issuer.
	// There is a limit to the number of objects that can be linked to a single
	// object. After the limit is reached, new linked objects in the call will be
	// ignored silently. Object IDs should follow the format issuer ID. identifier
	// where the former is issued by Google and the latter is chosen by you.
	LinkedObjectIds []string `json:"linkedObjectIds,omitempty"`
	// LinksModuleData: Links module data. If `linksModuleData` is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from class and 10 from object.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// Logo: The logo image of the pass. This image is displayed in the card detail
	// view in upper left, and also on the list/thumbnail view. If the logo is not
	// present, the first letter of `cardTitle` would be shown as logo.
	Logo *Image `json:"logo,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// Notifications: The notification settings that are enabled for this object.
	Notifications *Notifications `json:"notifications,omitempty"`
	// PassConstraints: Pass constraints for the object. Includes limiting NFC and
	// screenshot behaviors.
	PassConstraints *PassConstraints `json:"passConstraints,omitempty"`
	// RotatingBarcode: The rotating barcode settings/details.
	RotatingBarcode *RotatingBarcode `json:"rotatingBarcode,omitempty"`
	// SaveRestrictions: Restrictions on the object that needs to be verified
	// before the user tries to save the pass. Note that this restrictions will
	// only be applied during save time. If the restrictions changed after a user
	// saves the pass, the new restrictions will not be applied to an already saved
	// pass.
	SaveRestrictions *SaveRestrictions `json:"saveRestrictions,omitempty"`
	// SmartTapRedemptionValue: The value that will be transmitted to a Smart Tap
	// certified terminal over NFC for this object. The class level fields
	// `enableSmartTap` and `redemptionIssuers` must also be set up correctly in
	// order for the pass to support Smart Tap. Only ASCII characters are
	// supported.
	SmartTapRedemptionValue string `json:"smartTapRedemptionValue,omitempty"`
	// State: The state of the object. This field is used to determine how an
	// object is displayed in the app. For example, an `inactive` object is moved
	// to the "Expired passes" section. If this is not provided, the object would
	// be considered `ACTIVE`.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "ACTIVE" - Object is active and displayed to with other active objects.
	//   "active" - Legacy alias for `ACTIVE`. Deprecated.
	//   "COMPLETED"
	//   "completed" - Legacy alias for `COMPLETED`. Deprecated.
	//   "EXPIRED" - Object is no longer valid (`validTimeInterval` passed).
	//   "expired" - Legacy alias for `EXPIRED`. Deprecated.
	//   "INACTIVE"
	//   "inactive" - Legacy alias for `INACTIVE`. Deprecated.
	State string `json:"state,omitempty"`
	// Subheader: The title label of the pass, such as location where this pass can
	// be used. Appears right above the title in the title row in the pass detail
	// view.
	Subheader *LocalizedString `json:"subheader,omitempty"`
	// TextModulesData: Text module data. If `textModulesData` is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from class and 10 from object.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValidTimeInterval: The time period this object will be considered valid or
	// usable. When the time period is passed, the object will be considered
	// expired, which will affect the rendering on user's devices.
	ValidTimeInterval *TimeInterval `json:"validTimeInterval,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// WideLogo: The wide logo of the pass. When provided, this will be used in
	// place of the logo in the top left of the card view.
	WideLogo *Image `json:"wideLogo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppLinkData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppLinkData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenericObject) MarshalJSON() ([]byte, error) {
	type NoMethod GenericObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenericObjectAddMessageResponse: Response to adding a new issuer message to
// the object. This contains the entire updated GenericObject.
type GenericObjectAddMessageResponse struct {
	// Resource: The updated GenericObject resource.
	Resource *GenericObject `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenericObjectAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenericObjectAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenericObjectListResponse: List response which contains the list of all
// generic objects for a given issuer ID.
type GenericObjectListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*GenericObject `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenericObjectListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenericObjectListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GiftCardClass struct {
	// AllowBarcodeRedemption: Determines whether the merchant supports gift card
	// redemption using barcode. If true, app displays a barcode for the gift card
	// on the Gift card details screen. If false, a barcode is not displayed.
	AllowBarcodeRedemption bool `json:"allowBarcodeRedemption,omitempty"`
	// AllowMultipleUsersPerObject: Deprecated. Use
	// `multipleDevicesAndHoldersAllowedStatus` instead.
	AllowMultipleUsersPerObject bool `json:"allowMultipleUsersPerObject,omitempty"`
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// object that will be used instead.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// CallbackOptions: Callback options to be used to call the issuer back for
	// every save/delete of an object for this class by the end-user. All objects
	// of this class are eligible for the callback.
	CallbackOptions *CallbackOptions `json:"callbackOptions,omitempty"`
	// CardNumberLabel: The label to display for the card number, such as "Card
	// Number".
	CardNumberLabel string `json:"cardNumberLabel,omitempty"`
	// ClassTemplateInfo: Template information about how the class should be
	// displayed. If unset, Google will fallback to a default set of fields to
	// display.
	ClassTemplateInfo *ClassTemplateInfo `json:"classTemplateInfo,omitempty"`
	// CountryCode: Country code used to display the card's country (when the user
	// is not in that country), as well as to display localized content when
	// content is not available in the user's locale.
	CountryCode string `json:"countryCode,omitempty"`
	// EnableSmartTap: Identifies whether this class supports Smart Tap. The
	// `redemptionIssuers` and object level `smartTapRedemptionLevel` fields must
	// also be set up correctly in order for a pass to support Smart Tap.
	EnableSmartTap bool `json:"enableSmartTap,omitempty"`
	// EventNumberLabel: The label to display for event number, such as "Target
	// Event #".
	EventNumberLabel string `json:"eventNumberLabel,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, nothing will be displayed. The image will display at 100% width.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// HomepageUri: The URI of your application's home page. Populating the URI in
	// this field results in the exact same behavior as populating an URI in
	// linksModuleData (when an object is rendered, a link to the homepage is shown
	// in what would usually be thought of as the linksModuleData section of the
	// object).
	HomepageUri *Uri `json:"homepageUri,omitempty"`
	// Id: Required. The unique identifier for a class. This ID must be unique
	// across all classes from an issuer. This value should follow the format
	// issuer ID. identifier where the former is issued by Google and latter is
	// chosen by you. Your unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// IssuerName: Required. The issuer name. Recommended maximum length is 20
	// characters to ensure full string is displayed on smaller screens.
	IssuerName string `json:"issuerName,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#giftCardClass".
	Kind string `json:"kind,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the object, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// LocalizedCardNumberLabel: Translated strings for the card_number_label.
	LocalizedCardNumberLabel *LocalizedString `json:"localizedCardNumberLabel,omitempty"`
	// LocalizedEventNumberLabel: Translated strings for the event_number_label.
	LocalizedEventNumberLabel *LocalizedString `json:"localizedEventNumberLabel,omitempty"`
	// LocalizedIssuerName: Translated strings for the issuer_name. Recommended
	// maximum length is 20 characters to ensure full string is displayed on
	// smaller screens.
	LocalizedIssuerName *LocalizedString `json:"localizedIssuerName,omitempty"`
	// LocalizedMerchantName: Translated strings for the merchant_name. The app may
	// display an ellipsis after the first 20 characters to ensure full string is
	// displayed on smaller screens.
	LocalizedMerchantName *LocalizedString `json:"localizedMerchantName,omitempty"`
	// LocalizedPinLabel: Translated strings for the pin_label.
	LocalizedPinLabel *LocalizedString `json:"localizedPinLabel,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// MerchantName: Merchant name, such as "Adam's Apparel". The app may display
	// an ellipsis after the first 20 characters to ensure full string is displayed
	// on smaller screens.
	MerchantName string `json:"merchantName,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// MultipleDevicesAndHoldersAllowedStatus: Identifies whether multiple users
	// and devices will save the same object referencing this class.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified preference.
	//   "MULTIPLE_HOLDERS" - The Pass object is shareable by a user and can be
	// saved by any number of different users, and on any number of devices.
	// Partners typically use this setup for passes that do not need to be
	// restricted to a single user or pinned to a single device.
	//   "ONE_USER_ALL_DEVICES" - An object can only be saved by one user, but this
	// user can view and use it on multiple of their devices. Once the first user
	// saves the object, no other user will be allowed to view or save it.
	//   "ONE_USER_ONE_DEVICE" - An object can only be saved by one user on a
	// single device. Intended for use by select partners in limited circumstances.
	// An example use case is a transit ticket that should be "device pinned",
	// meaning it can be saved, viewed and used only by a single user on a single
	// device. Contact support for additional information.
	//   "multipleHolders" - Legacy alias for `MULTIPLE_HOLDERS`. Deprecated.
	//   "oneUserAllDevices" - Legacy alias for `ONE_USER_ALL_DEVICES`. Deprecated.
	//   "oneUserOneDevice" - Legacy alias for `ONE_USER_ONE_DEVICE`. Deprecated.
	MultipleDevicesAndHoldersAllowedStatus string `json:"multipleDevicesAndHoldersAllowedStatus,omitempty"`
	// PinLabel: The label to display for the PIN, such as "4-digit PIN".
	PinLabel string `json:"pinLabel,omitempty"`
	// ProgramLogo: The logo of the gift card program or company. This logo is
	// displayed in both the details and list views of the app.
	ProgramLogo *Image `json:"programLogo,omitempty"`
	// RedemptionIssuers: Identifies which redemption issuers can redeem the pass
	// over Smart Tap. Redemption issuers are identified by their issuer ID.
	// Redemption issuers must have at least one Smart Tap key configured. The
	// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also
	// be set up correctly in order for a pass to support Smart Tap.
	RedemptionIssuers googleapi.Int64s `json:"redemptionIssuers,omitempty"`
	// Review: The review comments set by the platform when a class is marked
	// `approved` or `rejected`.
	Review *Review `json:"review,omitempty"`
	// ReviewStatus: Required. The status of the class. This field can be set to
	// `draft` or `underReview` using the insert, patch, or update API calls. Once
	// the review state is changed from `draft` it may not be changed back to
	// `draft`. You should keep this field to `draft` when the class is under
	// development. A `draft` class cannot be used to create any object. You should
	// set this field to `underReview` when you believe the class is ready for use.
	// The platform will automatically set this field to `approved` and it can be
	// immediately used to create or migrate objects. When updating an already
	// `approved` class you should keep setting this field to `underReview`.
	//
	// Possible values:
	//   "REVIEW_STATUS_UNSPECIFIED"
	//   "UNDER_REVIEW"
	//   "underReview" - Legacy alias for `UNDER_REVIEW`. Deprecated.
	//   "APPROVED"
	//   "approved" - Legacy alias for `APPROVED`. Deprecated.
	//   "REJECTED"
	//   "rejected" - Legacy alias for `REJECTED`. Deprecated.
	//   "DRAFT"
	//   "draft" - Legacy alias for `DRAFT`. Deprecated.
	ReviewStatus string `json:"reviewStatus,omitempty"`
	// SecurityAnimation: Optional information about the security animation. If
	// this is set a security animation will be rendered on pass details.
	SecurityAnimation *SecurityAnimation `json:"securityAnimation,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the class. For a pass only ten will be displayed, prioritizing those from
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`
	// ViewUnlockRequirement: View Unlock Requirement options for the gift card.
	//
	// Possible values:
	//   "VIEW_UNLOCK_REQUIREMENT_UNSPECIFIED" - Default value, same as
	// UNLOCK_NOT_REQUIRED.
	//   "UNLOCK_NOT_REQUIRED" - Default behavior for all the existing Passes if
	// ViewUnlockRequirement is not set.
	//   "UNLOCK_REQUIRED_TO_VIEW" - Requires the user to unlock their device each
	// time the pass is viewed. If the user removes their device lock after saving
	// the pass, then they will be prompted to create a device lock before the pass
	// can be viewed.
	ViewUnlockRequirement string `json:"viewUnlockRequirement,omitempty"`
	// WideProgramLogo: The wide logo of the gift card program or company. When
	// provided, this will be used in place of the program logo in the top left of
	// the card view.
	WideProgramLogo *Image `json:"wideProgramLogo,omitempty"`
	// WordMark: Deprecated.
	WordMark *Image `json:"wordMark,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowBarcodeRedemption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowBarcodeRedemption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GiftCardClass) MarshalJSON() ([]byte, error) {
	type NoMethod GiftCardClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GiftCardClassAddMessageResponse struct {
	// Resource: The updated GiftCardClass resource.
	Resource *GiftCardClass `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GiftCardClassAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GiftCardClassAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GiftCardClassListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*GiftCardClass `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GiftCardClassListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GiftCardClassListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GiftCardObject struct {
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// class only object AppLinkData will be displayed.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// Balance: The card's monetary balance.
	Balance *Money `json:"balance,omitempty"`
	// BalanceUpdateTime: The date and time when the balance was last updated.
	// Offset is required. If balance is updated and this property is not provided,
	// system will default to the current time.
	BalanceUpdateTime *DateTime `json:"balanceUpdateTime,omitempty"`
	// Barcode: The barcode type and value.
	Barcode *Barcode `json:"barcode,omitempty"`
	// CardNumber: Required. The card's number.
	CardNumber string `json:"cardNumber,omitempty"`
	// ClassId: Required. The class associated with this object. The class must be
	// of the same type as this object, must already exist, and must be approved.
	// Class IDs should follow the format issuer ID.identifier where the former is
	// issued by Google and latter is chosen by you.
	ClassId string `json:"classId,omitempty"`
	// ClassReference: A copy of the inherited fields of the parent class. These
	// fields are retrieved during a GET.
	ClassReference *GiftCardClass `json:"classReference,omitempty"`
	// DisableExpirationNotification: Indicates if notifications should explicitly
	// be suppressed. If this field is set to true, regardless of the `messages`
	// field, expiration notifications to the user will be suppressed. By default,
	// this field is set to false. Currently, this can only be set for offers.
	DisableExpirationNotification bool `json:"disableExpirationNotification,omitempty"`
	// EventNumber: The card's event number, an optional field used by some gift
	// cards.
	EventNumber string `json:"eventNumber,omitempty"`
	// GroupingInfo: Information that controls how passes are grouped together.
	GroupingInfo *GroupingInfo `json:"groupingInfo,omitempty"`
	// HasLinkedDevice: Whether this object is currently linked to a single device.
	// This field is set by the platform when a user saves the object, linking it
	// to their device. Intended for use by select partners. Contact support for
	// additional information.
	HasLinkedDevice bool `json:"hasLinkedDevice,omitempty"`
	// HasUsers: Indicates if the object has users. This field is set by the
	// platform.
	HasUsers bool `json:"hasUsers,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, hero image of the class, if present, will be displayed. If hero
	// image of the class is also not present, nothing will be displayed.
	HeroImage *Image `json:"heroImage,omitempty"`
	// Id: Required. The unique identifier for an object. This ID must be unique
	// across all objects from an issuer. This value should follow the format
	// issuer ID.identifier where the former is issued by Google and latter is
	// chosen by you. The unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#giftCardObject".
	Kind string `json:"kind,omitempty"`
	// LinkedObjectIds: linked_object_ids are a list of other objects such as event
	// ticket, loyalty, offer, generic, giftcard, transit and boarding pass that
	// should be automatically attached to this giftcard object. If a user had
	// saved this gift card, then these linked_object_ids would be automatically
	// pushed to the user's wallet (unless they turned off the setting to receive
	// such linked passes). Make sure that objects present in linked_object_ids are
	// already inserted - if not, calls would fail. Once linked, the linked objects
	// cannot be unlinked. You cannot link objects belonging to another issuer.
	// There is a limit to the number of objects that can be linked to a single
	// object. After the limit is reached, new linked objects in the call will be
	// ignored silently. Object IDs should follow the format issuer ID. identifier
	// where the former is issued by Google and the latter is chosen by you.
	LinkedObjectIds []string `json:"linkedObjectIds,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the class, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// PassConstraints: Pass constraints for the object. Includes limiting NFC and
	// screenshot behaviors.
	PassConstraints *PassConstraints `json:"passConstraints,omitempty"`
	// Pin: The card's PIN.
	Pin string `json:"pin,omitempty"`
	// RotatingBarcode: The rotating barcode type and value.
	RotatingBarcode *RotatingBarcode `json:"rotatingBarcode,omitempty"`
	// SaveRestrictions: Restrictions on the object that needs to be verified
	// before the user tries to save the pass. Note that this restrictions will
	// only be applied during save time. If the restrictions changed after a user
	// saves the pass, the new restrictions will not be applied to an already saved
	// pass.
	SaveRestrictions *SaveRestrictions `json:"saveRestrictions,omitempty"`
	// SmartTapRedemptionValue: The value that will be transmitted to a Smart Tap
	// certified terminal over NFC for this object. The class level fields
	// `enableSmartTap` and `redemptionIssuers` must also be set up correctly in
	// order for the pass to support Smart Tap. Only ASCII characters are
	// supported.
	SmartTapRedemptionValue string `json:"smartTapRedemptionValue,omitempty"`
	// State: Required. The state of the object. This field is used to determine
	// how an object is displayed in the app. For example, an `inactive` object is
	// moved to the "Expired passes" section.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "ACTIVE" - Object is active and displayed to with other active objects.
	//   "active" - Legacy alias for `ACTIVE`. Deprecated.
	//   "COMPLETED"
	//   "completed" - Legacy alias for `COMPLETED`. Deprecated.
	//   "EXPIRED" - Object is no longer valid (`validTimeInterval` passed).
	//   "expired" - Legacy alias for `EXPIRED`. Deprecated.
	//   "INACTIVE"
	//   "inactive" - Legacy alias for `INACTIVE`. Deprecated.
	State string `json:"state,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValidTimeInterval: The time period this object will be `active` and object
	// can be used. An object's state will be changed to `expired` when this time
	// period has passed.
	ValidTimeInterval *TimeInterval `json:"validTimeInterval,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppLinkData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppLinkData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GiftCardObject) MarshalJSON() ([]byte, error) {
	type NoMethod GiftCardObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GiftCardObjectAddMessageResponse struct {
	// Resource: The updated GiftCardObject resource.
	Resource *GiftCardObject `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GiftCardObjectAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GiftCardObjectAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GiftCardObjectListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*GiftCardObject `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GiftCardObjectListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GiftCardObjectListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GroupingInfo struct {
	// GroupingId: Optional grouping ID for grouping the passes with the same ID
	// visually together. Grouping with different types of passes is allowed.
	GroupingId string `json:"groupingId,omitempty"`
	// SortIndex: Optional index for sorting the passes when they are grouped with
	// other passes. Passes with lower sort index are shown before passes with
	// higher sort index. If unspecified, the value is assumed to be INT_MAX. For
	// two passes with the same sort index, the sorting behavior is undefined.
	SortIndex int64 `json:"sortIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupingId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupingId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroupingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GroupingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Image: Wrapping type for Google hosted images. Next ID: 7
type Image struct {
	// ContentDescription: Description of the image used for accessibility.
	ContentDescription *LocalizedString `json:"contentDescription,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#image".
	Kind string `json:"kind,omitempty"`
	// SourceUri: The URI for the image.
	SourceUri *ImageUri `json:"sourceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentDescription") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentDescription") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ImageModuleData struct {
	// Id: The ID associated with an image module. This field is here to enable
	// ease of management of image modules.
	Id string `json:"id,omitempty"`
	// MainImage: A 100% width image.
	MainImage *Image `json:"mainImage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageModuleData) MarshalJSON() ([]byte, error) {
	type NoMethod ImageModuleData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ImageUri struct {
	// Description: Additional information about the image, which is unused and
	// retained only for backward compatibility.
	Description string `json:"description,omitempty"`
	// LocalizedDescription: Translated strings for the description, which are
	// unused and retained only for backward compatibility.
	LocalizedDescription *LocalizedString `json:"localizedDescription,omitempty"`
	// Uri: The location of the image. URIs must have a scheme.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageUri) MarshalJSON() ([]byte, error) {
	type NoMethod ImageUri
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type InfoModuleData struct {
	// LabelValueRows: A list of collections of labels and values. These will be
	// displayed one after the other in a singular column.
	LabelValueRows     []*LabelValueRow `json:"labelValueRows,omitempty"`
	ShowLastUpdateTime bool             `json:"showLastUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelValueRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelValueRows") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InfoModuleData) MarshalJSON() ([]byte, error) {
	type NoMethod InfoModuleData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Issuer struct {
	// CallbackOptions: Allows the issuer to provide their callback settings.
	CallbackOptions *CallbackOptions `json:"callbackOptions,omitempty"`
	// ContactInfo: Issuer contact information.
	ContactInfo *IssuerContactInfo `json:"contactInfo,omitempty"`
	// HomepageUrl: URL for the issuer's home page.
	HomepageUrl string `json:"homepageUrl,omitempty"`
	// IssuerId: The unique identifier for an issuer account. This is automatically
	// generated when the issuer is inserted.
	IssuerId int64 `json:"issuerId,omitempty,string"`
	// Name: The account name of the issuer.
	Name string `json:"name,omitempty"`
	// SmartTapMerchantData: Available only to Smart Tap enabled partners. Contact
	// support for additional guidance.
	SmartTapMerchantData *SmartTapMerchantData `json:"smartTapMerchantData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CallbackOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CallbackOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Issuer) MarshalJSON() ([]byte, error) {
	type NoMethod Issuer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type IssuerContactInfo struct {
	// AlertsEmails: Email addresses which will receive alerts.
	AlertsEmails []string `json:"alertsEmails,omitempty"`
	// Email: The primary contact email address.
	Email string `json:"email,omitempty"`
	// Name: The primary contact name.
	Name string `json:"name,omitempty"`
	// Phone: The primary contact phone number.
	Phone string `json:"phone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlertsEmails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlertsEmails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IssuerContactInfo) MarshalJSON() ([]byte, error) {
	type NoMethod IssuerContactInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type IssuerListResponse struct {
	// Resources: Resources corresponding to the list request.
	Resources []*Issuer `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IssuerListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod IssuerListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type IssuerToUserInfo struct {
	// Possible values:
	//   "ACTION_UNSPECIFIED"
	//   "S2AP"
	//   "s2ap" - Legacy alias for `S2AP`. Deprecated.
	//   "SIGN_UP"
	//   "signUp" - Legacy alias for `SIGN_UP`. Deprecated.
	Action     string      `json:"action,omitempty"`
	SignUpInfo *SignUpInfo `json:"signUpInfo,omitempty"`
	// Url: Currently not used, consider deprecating.
	Url string `json:"url,omitempty"`
	// Value: JSON web token for action S2AP.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IssuerToUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod IssuerToUserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type JwtInsertResponse struct {
	// Resources: Data that corresponds to the ids of the provided classes and
	// objects in the JWT. resources will only include the non-empty arrays (i.e.
	// if the JWT only includes eventTicketObjects, then that is the only field
	// that will be present in resources).
	Resources *Resources `json:"resources,omitempty"`
	// SaveUri: A URI that, when opened, will allow the end user to save the
	// object(s) identified in the JWT to their Google account.
	SaveUri string `json:"saveUri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JwtInsertResponse) MarshalJSON() ([]byte, error) {
	type NoMethod JwtInsertResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type JwtResource struct {
	// Jwt: A string representing a JWT of the format described at
	// https://developers.google.com/wallet/reference/rest/v1/Jwt
	Jwt string `json:"jwt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Jwt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Jwt") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JwtResource) MarshalJSON() ([]byte, error) {
	type NoMethod JwtResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LabelValue: A pair of text strings to be displayed in the details view. Note
// we no longer display LabelValue/LabelValueRow as a table, instead a list of
// items.
type LabelValue struct {
	// Label: The label for a specific row and column. Recommended maximum is 15
	// characters for a two-column layout and 30 characters for a one-column
	// layout.
	Label string `json:"label,omitempty"`
	// LocalizedLabel: Translated strings for the label. Recommended maximum is 15
	// characters for a two-column layout and 30 characters for a one-column
	// layout.
	LocalizedLabel *LocalizedString `json:"localizedLabel,omitempty"`
	// LocalizedValue: Translated strings for the value. Recommended maximum is 15
	// characters for a two-column layout and 30 characters for a one-column
	// layout.
	LocalizedValue *LocalizedString `json:"localizedValue,omitempty"`
	// Value: The value for a specific row and column. Recommended maximum is 15
	// characters for a two-column layout and 30 characters for a one-column
	// layout.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Label") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LabelValue) MarshalJSON() ([]byte, error) {
	type NoMethod LabelValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LabelValueRow struct {
	// Columns: A list of labels and values. These will be displayed in a singular
	// column, one after the other, not in multiple columns, despite the field
	// name.
	Columns []*LabelValue `json:"columns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LabelValueRow) MarshalJSON() ([]byte, error) {
	type NoMethod LabelValueRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LatLongPoint struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#latLongPoint".
	Kind string `json:"kind,omitempty"`
	// Latitude: The latitude specified as any value in the range of -90.0 through
	// +90.0, both inclusive. Values outside these bounds will be rejected.
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: The longitude specified in the range -180.0 through +180.0, both
	// inclusive. Values outside these bounds will be rejected.
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LatLongPoint) MarshalJSON() ([]byte, error) {
	type NoMethod LatLongPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *LatLongPoint) UnmarshalJSON(data []byte) error {
	type NoMethod LatLongPoint
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

type LinksModuleData struct {
	// Uris: The list of URIs.
	Uris []*Uri `json:"uris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uris") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uris") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinksModuleData) MarshalJSON() ([]byte, error) {
	type NoMethod LinksModuleData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListTemplateOverride struct {
	// FirstRowOption: Specifies from a predefined set of options or from a
	// reference to the field what will be displayed in the first row. To set this
	// override, set the FirstRowOption.fieldOption to the FieldSelector of your
	// choice.
	FirstRowOption *FirstRowOption `json:"firstRowOption,omitempty"`
	// SecondRowOption: A reference to the field to be displayed in the second row.
	// This option is only displayed if there are not multiple user objects in a
	// group. If there is a group, the second row will always display a field
	// shared by all objects. To set this override, please set secondRowOption to
	// the FieldSelector of you choice.
	SecondRowOption *FieldSelector `json:"secondRowOption,omitempty"`
	// ThirdRowOption: An unused/deprecated field. Setting it will have no effect
	// on what the user sees.
	ThirdRowOption *FieldSelector `json:"thirdRowOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FirstRowOption") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirstRowOption") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTemplateOverride) MarshalJSON() ([]byte, error) {
	type NoMethod ListTemplateOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LocalizedString struct {
	// DefaultValue: Contains the string to be displayed if no appropriate
	// translation is available.
	DefaultValue *TranslatedString `json:"defaultValue,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#localizedString".
	Kind string `json:"kind,omitempty"`
	// TranslatedValues: Contains the translations for the string.
	TranslatedValues []*TranslatedString `json:"translatedValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalizedString) MarshalJSON() ([]byte, error) {
	type NoMethod LocalizedString
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LoyaltyClass struct {
	// AccountIdLabel: The account ID label, such as "Member ID." Recommended
	// maximum length is 15 characters to ensure full string is displayed on
	// smaller screens.
	AccountIdLabel string `json:"accountIdLabel,omitempty"`
	// AccountNameLabel: The account name label, such as "Member Name." Recommended
	// maximum length is 15 characters to ensure full string is displayed on
	// smaller screens.
	AccountNameLabel string `json:"accountNameLabel,omitempty"`
	// AllowMultipleUsersPerObject: Deprecated. Use
	// `multipleDevicesAndHoldersAllowedStatus` instead.
	AllowMultipleUsersPerObject bool `json:"allowMultipleUsersPerObject,omitempty"`
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// object that will be used instead.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// CallbackOptions: Callback options to be used to call the issuer back for
	// every save/delete of an object for this class by the end-user. All objects
	// of this class are eligible for the callback.
	CallbackOptions *CallbackOptions `json:"callbackOptions,omitempty"`
	// ClassTemplateInfo: Template information about how the class should be
	// displayed. If unset, Google will fallback to a default set of fields to
	// display.
	ClassTemplateInfo *ClassTemplateInfo `json:"classTemplateInfo,omitempty"`
	// CountryCode: Country code used to display the card's country (when the user
	// is not in that country), as well as to display localized content when
	// content is not available in the user's locale.
	CountryCode string `json:"countryCode,omitempty"`
	// DiscoverableProgram: Information about how the class may be discovered and
	// instantiated from within the Google Pay app.
	DiscoverableProgram *DiscoverableProgram `json:"discoverableProgram,omitempty"`
	// EnableSmartTap: Identifies whether this class supports Smart Tap. The
	// `redemptionIssuers` and one of object level `smartTapRedemptionLevel`,
	// barcode.value`, or `accountId` fields must also be set up correctly in order
	// for a pass to support Smart Tap.
	EnableSmartTap bool `json:"enableSmartTap,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, nothing will be displayed. The image will display at 100% width.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// HomepageUri: The URI of your application's home page. Populating the URI in
	// this field results in the exact same behavior as populating an URI in
	// linksModuleData (when an object is rendered, a link to the homepage is shown
	// in what would usually be thought of as the linksModuleData section of the
	// object).
	HomepageUri *Uri `json:"homepageUri,omitempty"`
	// Id: Required. The unique identifier for a class. This ID must be unique
	// across all classes from an issuer. This value should follow the format
	// issuer ID. identifier where the former is issued by Google and latter is
	// chosen by you. Your unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// IssuerName: Required. The issuer name. Recommended maximum length is 20
	// characters to ensure full string is displayed on smaller screens.
	IssuerName string `json:"issuerName,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#loyaltyClass".
	Kind string `json:"kind,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the object, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// LocalizedAccountIdLabel: Translated strings for the account_id_label.
	// Recommended maximum length is 15 characters to ensure full string is
	// displayed on smaller screens.
	LocalizedAccountIdLabel *LocalizedString `json:"localizedAccountIdLabel,omitempty"`
	// LocalizedAccountNameLabel: Translated strings for the account_name_label.
	// Recommended maximum length is 15 characters to ensure full string is
	// displayed on smaller screens.
	LocalizedAccountNameLabel *LocalizedString `json:"localizedAccountNameLabel,omitempty"`
	// LocalizedIssuerName: Translated strings for the issuer_name. Recommended
	// maximum length is 20 characters to ensure full string is displayed on
	// smaller screens.
	LocalizedIssuerName *LocalizedString `json:"localizedIssuerName,omitempty"`
	// LocalizedProgramName: Translated strings for the program_name. The app may
	// display an ellipsis after the first 20 characters to ensure full string is
	// displayed on smaller screens.
	LocalizedProgramName *LocalizedString `json:"localizedProgramName,omitempty"`
	// LocalizedRewardsTier: Translated strings for the rewards_tier. Recommended
	// maximum length is 7 characters to ensure full string is displayed on smaller
	// screens.
	LocalizedRewardsTier *LocalizedString `json:"localizedRewardsTier,omitempty"`
	// LocalizedRewardsTierLabel: Translated strings for the rewards_tier_label.
	// Recommended maximum length is 9 characters to ensure full string is
	// displayed on smaller screens.
	LocalizedRewardsTierLabel *LocalizedString `json:"localizedRewardsTierLabel,omitempty"`
	// LocalizedSecondaryRewardsTier: Translated strings for the
	// secondary_rewards_tier.
	LocalizedSecondaryRewardsTier *LocalizedString `json:"localizedSecondaryRewardsTier,omitempty"`
	// LocalizedSecondaryRewardsTierLabel: Translated strings for the
	// secondary_rewards_tier_label.
	LocalizedSecondaryRewardsTierLabel *LocalizedString `json:"localizedSecondaryRewardsTierLabel,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// MultipleDevicesAndHoldersAllowedStatus: Identifies whether multiple users
	// and devices will save the same object referencing this class.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified preference.
	//   "MULTIPLE_HOLDERS" - The Pass object is shareable by a user and can be
	// saved by any number of different users, and on any number of devices.
	// Partners typically use this setup for passes that do not need to be
	// restricted to a single user or pinned to a single device.
	//   "ONE_USER_ALL_DEVICES" - An object can only be saved by one user, but this
	// user can view and use it on multiple of their devices. Once the first user
	// saves the object, no other user will be allowed to view or save it.
	//   "ONE_USER_ONE_DEVICE" - An object can only be saved by one user on a
	// single device. Intended for use by select partners in limited circumstances.
	// An example use case is a transit ticket that should be "device pinned",
	// meaning it can be saved, viewed and used only by a single user on a single
	// device. Contact support for additional information.
	//   "multipleHolders" - Legacy alias for `MULTIPLE_HOLDERS`. Deprecated.
	//   "oneUserAllDevices" - Legacy alias for `ONE_USER_ALL_DEVICES`. Deprecated.
	//   "oneUserOneDevice" - Legacy alias for `ONE_USER_ONE_DEVICE`. Deprecated.
	MultipleDevicesAndHoldersAllowedStatus string `json:"multipleDevicesAndHoldersAllowedStatus,omitempty"`
	// ProgramLogo: Required. The logo of the loyalty program or company. This logo
	// is displayed in both the details and list views of the app.
	ProgramLogo *Image `json:"programLogo,omitempty"`
	// ProgramName: Required. The program name, such as "Adam's Apparel". The app
	// may display an ellipsis after the first 20 characters to ensure full string
	// is displayed on smaller screens.
	ProgramName string `json:"programName,omitempty"`
	// RedemptionIssuers: Identifies which redemption issuers can redeem the pass
	// over Smart Tap. Redemption issuers are identified by their issuer ID.
	// Redemption issuers must have at least one Smart Tap key configured. The
	// `enableSmartTap` and one of object level `smartTapRedemptionValue`,
	// barcode.value`, or `accountId` fields must also be set up correctly in order
	// for a pass to support Smart Tap.
	RedemptionIssuers googleapi.Int64s `json:"redemptionIssuers,omitempty"`
	// Review: The review comments set by the platform when a class is marked
	// `approved` or `rejected`.
	Review *Review `json:"review,omitempty"`
	// ReviewStatus: Required. The status of the class. This field can be set to
	// `draft` or `underReview` using the insert, patch, or update API calls. Once
	// the review state is changed from `draft` it may not be changed back to
	// `draft`. You should keep this field to `draft` when the class is under
	// development. A `draft` class cannot be used to create any object. You should
	// set this field to `underReview` when you believe the class is ready for use.
	// The platform will automatically set this field to `approved` and it can be
	// immediately used to create or migrate objects. When updating an already
	// `approved` class you should keep setting this field to `underReview`.
	//
	// Possible values:
	//   "REVIEW_STATUS_UNSPECIFIED"
	//   "UNDER_REVIEW"
	//   "underReview" - Legacy alias for `UNDER_REVIEW`. Deprecated.
	//   "APPROVED"
	//   "approved" - Legacy alias for `APPROVED`. Deprecated.
	//   "REJECTED"
	//   "rejected" - Legacy alias for `REJECTED`. Deprecated.
	//   "DRAFT"
	//   "draft" - Legacy alias for `DRAFT`. Deprecated.
	ReviewStatus string `json:"reviewStatus,omitempty"`
	// RewardsTier: The rewards tier, such as "Gold" or "Platinum." Recommended
	// maximum length is 7 characters to ensure full string is displayed on smaller
	// screens.
	RewardsTier string `json:"rewardsTier,omitempty"`
	// RewardsTierLabel: The rewards tier label, such as "Rewards Tier."
	// Recommended maximum length is 9 characters to ensure full string is
	// displayed on smaller screens.
	RewardsTierLabel string `json:"rewardsTierLabel,omitempty"`
	// SecondaryRewardsTier: The secondary rewards tier, such as "Gold" or
	// "Platinum."
	SecondaryRewardsTier string `json:"secondaryRewardsTier,omitempty"`
	// SecondaryRewardsTierLabel: The secondary rewards tier label, such as
	// "Rewards Tier."
	SecondaryRewardsTierLabel string `json:"secondaryRewardsTierLabel,omitempty"`
	// SecurityAnimation: Optional information about the security animation. If
	// this is set a security animation will be rendered on pass details.
	SecurityAnimation *SecurityAnimation `json:"securityAnimation,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the class. For a pass only ten will be displayed, prioritizing those from
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`
	// ViewUnlockRequirement: View Unlock Requirement options for the loyalty card.
	//
	// Possible values:
	//   "VIEW_UNLOCK_REQUIREMENT_UNSPECIFIED" - Default value, same as
	// UNLOCK_NOT_REQUIRED.
	//   "UNLOCK_NOT_REQUIRED" - Default behavior for all the existing Passes if
	// ViewUnlockRequirement is not set.
	//   "UNLOCK_REQUIRED_TO_VIEW" - Requires the user to unlock their device each
	// time the pass is viewed. If the user removes their device lock after saving
	// the pass, then they will be prompted to create a device lock before the pass
	// can be viewed.
	ViewUnlockRequirement string `json:"viewUnlockRequirement,omitempty"`
	// WideProgramLogo: The wide logo of the loyalty program or company. When
	// provided, this will be used in place of the program logo in the top left of
	// the card view.
	WideProgramLogo *Image `json:"wideProgramLogo,omitempty"`
	// WordMark: Deprecated.
	WordMark *Image `json:"wordMark,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountIdLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountIdLabel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyClass) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LoyaltyClassAddMessageResponse struct {
	// Resource: The updated LoyaltyClass resource.
	Resource *LoyaltyClass `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyClassAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyClassAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LoyaltyClassListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*LoyaltyClass `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyClassListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyClassListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LoyaltyObject struct {
	// AccountId: The loyalty account identifier. Recommended maximum length is 20
	// characters.
	AccountId string `json:"accountId,omitempty"`
	// AccountName: The loyalty account holder name, such as "John Smith."
	// Recommended maximum length is 20 characters to ensure full string is
	// displayed on smaller screens.
	AccountName string `json:"accountName,omitempty"`
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// class only object AppLinkData will be displayed.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// Barcode: The barcode type and value.
	Barcode *Barcode `json:"barcode,omitempty"`
	// ClassId: Required. The class associated with this object. The class must be
	// of the same type as this object, must already exist, and must be approved.
	// Class IDs should follow the format issuer ID.identifier where the former is
	// issued by Google and latter is chosen by you.
	ClassId string `json:"classId,omitempty"`
	// ClassReference: A copy of the inherited fields of the parent class. These
	// fields are retrieved during a GET.
	ClassReference *LoyaltyClass `json:"classReference,omitempty"`
	// DisableExpirationNotification: Indicates if notifications should explicitly
	// be suppressed. If this field is set to true, regardless of the `messages`
	// field, expiration notifications to the user will be suppressed. By default,
	// this field is set to false. Currently, this can only be set for offers.
	DisableExpirationNotification bool `json:"disableExpirationNotification,omitempty"`
	// GroupingInfo: Information that controls how passes are grouped together.
	GroupingInfo *GroupingInfo `json:"groupingInfo,omitempty"`
	// HasLinkedDevice: Whether this object is currently linked to a single device.
	// This field is set by the platform when a user saves the object, linking it
	// to their device. Intended for use by select partners. Contact support for
	// additional information.
	HasLinkedDevice bool `json:"hasLinkedDevice,omitempty"`
	// HasUsers: Indicates if the object has users. This field is set by the
	// platform.
	HasUsers bool `json:"hasUsers,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, hero image of the class, if present, will be displayed. If hero
	// image of the class is also not present, nothing will be displayed.
	HeroImage *Image `json:"heroImage,omitempty"`
	// Id: Required. The unique identifier for an object. This ID must be unique
	// across all objects from an issuer. This value should follow the format
	// issuer ID.identifier where the former is issued by Google and latter is
	// chosen by you. The unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#loyaltyObject".
	Kind string `json:"kind,omitempty"`
	// LinkedObjectIds: linked_object_ids are a list of other objects such as event
	// ticket, loyalty, offer, generic, giftcard, transit and boarding pass that
	// should be automatically attached to this loyalty object. If a user had saved
	// this loyalty card, then these linked_object_ids would be automatically
	// pushed to the user's wallet (unless they turned off the setting to receive
	// such linked passes). Make sure that objects present in linked_object_ids are
	// already inserted - if not, calls would fail. Once linked, the linked objects
	// cannot be unlinked. You cannot link objects belonging to another issuer.
	// There is a limit to the number of objects that can be linked to a single
	// object. After the limit is reached, new linked objects in the call will be
	// ignored silently. Object IDs should follow the format issuer ID. identifier
	// where the former is issued by Google and the latter is chosen by you.
	LinkedObjectIds []string `json:"linkedObjectIds,omitempty"`
	// LinkedOfferIds: A list of offer objects linked to this loyalty card. The
	// offer objects must already exist. Offer object IDs should follow the format
	// issuer ID. identifier where the former is issued by Google and latter is
	// chosen by you.
	LinkedOfferIds []string `json:"linkedOfferIds,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the class, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// LoyaltyPoints: The loyalty reward points label, balance, and type.
	LoyaltyPoints *LoyaltyPoints `json:"loyaltyPoints,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// PassConstraints: Pass constraints for the object. Includes limiting NFC and
	// screenshot behaviors.
	PassConstraints *PassConstraints `json:"passConstraints,omitempty"`
	// RotatingBarcode: The rotating barcode type and value.
	RotatingBarcode *RotatingBarcode `json:"rotatingBarcode,omitempty"`
	// SaveRestrictions: Restrictions on the object that needs to be verified
	// before the user tries to save the pass. Note that this restrictions will
	// only be applied during save time. If the restrictions changed after a user
	// saves the pass, the new restrictions will not be applied to an already saved
	// pass.
	SaveRestrictions *SaveRestrictions `json:"saveRestrictions,omitempty"`
	// SecondaryLoyaltyPoints: The secondary loyalty reward points label, balance,
	// and type. Shown in addition to the primary loyalty points.
	SecondaryLoyaltyPoints *LoyaltyPoints `json:"secondaryLoyaltyPoints,omitempty"`
	// SmartTapRedemptionValue: The value that will be transmitted to a Smart Tap
	// certified terminal over NFC for this object. The class level fields
	// `enableSmartTap` and `redemptionIssuers` must also be set up correctly in
	// order for the pass to support Smart Tap. Only ASCII characters are
	// supported. If this value is not set but the class level fields
	// `enableSmartTap` and `redemptionIssuers` are set up correctly, the
	// `barcode.value` or the `accountId` fields are used as fallback if present.
	SmartTapRedemptionValue string `json:"smartTapRedemptionValue,omitempty"`
	// State: Required. The state of the object. This field is used to determine
	// how an object is displayed in the app. For example, an `inactive` object is
	// moved to the "Expired passes" section.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "ACTIVE" - Object is active and displayed to with other active objects.
	//   "active" - Legacy alias for `ACTIVE`. Deprecated.
	//   "COMPLETED"
	//   "completed" - Legacy alias for `COMPLETED`. Deprecated.
	//   "EXPIRED" - Object is no longer valid (`validTimeInterval` passed).
	//   "expired" - Legacy alias for `EXPIRED`. Deprecated.
	//   "INACTIVE"
	//   "inactive" - Legacy alias for `INACTIVE`. Deprecated.
	State string `json:"state,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValidTimeInterval: The time period this object will be `active` and object
	// can be used. An object's state will be changed to `expired` when this time
	// period has passed.
	ValidTimeInterval *TimeInterval `json:"validTimeInterval,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyObject) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LoyaltyObjectAddMessageResponse struct {
	// Resource: The updated LoyaltyObject resource.
	Resource *LoyaltyObject `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyObjectAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyObjectAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LoyaltyObjectListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*LoyaltyObject `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyObjectListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyObjectListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LoyaltyPoints struct {
	// Balance: The account holder's loyalty point balance, such as "500" or
	// "$10.00". Recommended maximum length is 7 characters. This is a required
	// field of `loyaltyPoints` and `secondaryLoyaltyPoints`.
	Balance *LoyaltyPointsBalance `json:"balance,omitempty"`
	// Label: The loyalty points label, such as "Points". Recommended maximum
	// length is 9 characters.
	Label string `json:"label,omitempty"`
	// LocalizedLabel: Translated strings for the label. Recommended maximum length
	// is 9 characters.
	LocalizedLabel *LocalizedString `json:"localizedLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Balance") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Balance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyPoints) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyPoints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LoyaltyPointsBalance struct {
	// Double: The double form of a balance. Only one of these subtypes (string,
	// int, double, money) should be populated.
	Double float64 `json:"double,omitempty"`
	// Int: The integer form of a balance. Only one of these subtypes (string, int,
	// double, money) should be populated.
	Int int64 `json:"int,omitempty"`
	// Money: The money form of a balance. Only one of these subtypes (string, int,
	// double, money) should be populated.
	Money *Money `json:"money,omitempty"`
	// String: The string form of a balance. Only one of these subtypes (string,
	// int, double, money) should be populated.
	String string `json:"string,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Double") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Double") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoyaltyPointsBalance) MarshalJSON() ([]byte, error) {
	type NoMethod LoyaltyPointsBalance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *LoyaltyPointsBalance) UnmarshalJSON(data []byte) error {
	type NoMethod LoyaltyPointsBalance
	var s1 struct {
		Double gensupport.JSONFloat64 `json:"double"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Double = float64(s1.Double)
	return nil
}

// Media: A reference to data stored on the filesystem, on GFS or in blobstore.
type Media struct {
	// Algorithm: Deprecated, use one of explicit hash type fields instead.
	// Algorithm used for calculating the hash. As of 2011/01/21, "MD5" is the only
	// possible value for this field. New values may be added at any time.
	Algorithm string `json:"algorithm,omitempty"`
	// BigstoreObjectRef: Use object_id instead.
	BigstoreObjectRef string `json:"bigstoreObjectRef,omitempty"`
	// BlobRef: Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This
	// should be the byte representation of a blobstore.BlobRef. Since Blobstore is
	// deprecating v1, use blobstore2_info instead. For now, any v2 blob will also
	// be represented in this field as v1 BlobRef.
	BlobRef string `json:"blobRef,omitempty"`
	// Blobstore2Info: Blobstore v2 info, set if reference_type is BLOBSTORE_REF
	// and it refers to a v2 blob.
	Blobstore2Info *Blobstore2Info `json:"blobstore2Info,omitempty"`
	// CompositeMedia: A composite media composed of one or more media objects, set
	// if reference_type is COMPOSITE_MEDIA. The media length field must be set to
	// the sum of the lengths of all composite media objects. Note: All composite
	// media must have length specified.
	CompositeMedia []*CompositeMedia `json:"compositeMedia,omitempty"`
	// ContentType: MIME type of the data
	ContentType string `json:"contentType,omitempty"`
	// ContentTypeInfo: Extended content type information provided for Scotty
	// uploads.
	ContentTypeInfo *ContentTypeInfo `json:"contentTypeInfo,omitempty"`
	// CosmoBinaryReference: A binary data reference for a media download. Serves
	// as a technology-agnostic binary reference in some Google infrastructure.
	// This value is a serialized storage_cosmo.BinaryReference proto. Storing it
	// as bytes is a hack to get around the fact that the cosmo proto (as well as
	// others it includes) doesn't support JavaScript. This prevents us from
	// including the actual type of this field.
	CosmoBinaryReference string `json:"cosmoBinaryReference,omitempty"`
	// Crc32cHash: For Scotty Uploads: Scotty-provided hashes for uploads For
	// Scotty Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY
	// TEAM.) A Hash provided by the agent to be used to verify the data being
	// downloaded. Currently only supported for inline payloads. Further, only
	// crc32c_hash is currently supported.
	Crc32cHash int64 `json:"crc32cHash,omitempty"`
	// DiffChecksumsResponse: Set if reference_type is DIFF_CHECKSUMS_RESPONSE.
	DiffChecksumsResponse *DiffChecksumsResponse `json:"diffChecksumsResponse,omitempty"`
	// DiffDownloadResponse: Set if reference_type is DIFF_DOWNLOAD_RESPONSE.
	DiffDownloadResponse *DiffDownloadResponse `json:"diffDownloadResponse,omitempty"`
	// DiffUploadRequest: Set if reference_type is DIFF_UPLOAD_REQUEST.
	DiffUploadRequest *DiffUploadRequest `json:"diffUploadRequest,omitempty"`
	// DiffUploadResponse: Set if reference_type is DIFF_UPLOAD_RESPONSE.
	DiffUploadResponse *DiffUploadResponse `json:"diffUploadResponse,omitempty"`
	// DiffVersionResponse: Set if reference_type is DIFF_VERSION_RESPONSE.
	DiffVersionResponse *DiffVersionResponse `json:"diffVersionResponse,omitempty"`
	// DownloadParameters: Parameters for a media download.
	DownloadParameters *DownloadParameters `json:"downloadParameters,omitempty"`
	// Filename: Original file name
	Filename string `json:"filename,omitempty"`
	// Hash: Deprecated, use one of explicit hash type fields instead. These two
	// hash related fields will only be populated on Scotty based media uploads and
	// will contain the content of the hash group in the NotificationRequest:
	// http://cs/#google3/blobstore2/api/scotty/service/proto/upload_listener.proto&q=class:Hash
	// Hex encoded hash value of the uploaded media.
	Hash string `json:"hash,omitempty"`
	// HashVerified: For Scotty uploads only. If a user sends a hash code and the
	// backend has requested that Scotty verify the upload against the client hash,
	// Scotty will perform the check on behalf of the backend and will reject it if
	// the hashes don't match. This is set to true if Scotty performed this
	// verification.
	HashVerified bool `json:"hashVerified,omitempty"`
	// Inline: Media data, set if reference_type is INLINE
	Inline string `json:"inline,omitempty"`
	// IsPotentialRetry: |is_potential_retry| is set false only when Scotty is
	// certain that it has not sent the request before. When a client resumes an
	// upload, this field must be set true in agent calls, because Scotty cannot be
	// certain that it has never sent the request before due to potential failure
	// in the session state persistence.
	IsPotentialRetry bool `json:"isPotentialRetry,omitempty"`
	// Length: Size of the data, in bytes
	Length int64 `json:"length,omitempty,string"`
	// Md5Hash: Scotty-provided MD5 hash for an upload.
	Md5Hash string `json:"md5Hash,omitempty"`
	// MediaId: Media id to forward to the operation GetMedia. Can be set if
	// reference_type is GET_MEDIA.
	MediaId string `json:"mediaId,omitempty"`
	// ObjectId: Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
	ObjectId *ObjectId `json:"objectId,omitempty"`
	// Path: Path to the data, set if reference_type is PATH
	Path string `json:"path,omitempty"`
	// ReferenceType: Describes what the field reference contains.
	//
	// Possible values:
	//   "PATH" - Reference contains a GFS path or a local path.
	//   "BLOB_REF" - Reference points to a blobstore object. This could be either
	// a v1 blob_ref or a v2 blobstore2_info. Clients should check blobstore2_info
	// first, since v1 is being deprecated.
	//   "INLINE" - Data is included into this proto buffer
	//   "GET_MEDIA" - Data should be accessed from the current service using the
	// operation GetMedia.
	//   "COMPOSITE_MEDIA" - The content for this media object is stored across
	// multiple partial media objects under the composite_media field.
	//   "BIGSTORE_REF" - Reference points to a bigstore object
	//   "DIFF_VERSION_RESPONSE" - Indicates the data is stored in
	// diff_version_response.
	//   "DIFF_CHECKSUMS_RESPONSE" - Indicates the data is stored in
	// diff_checksums_response.
	//   "DIFF_DOWNLOAD_RESPONSE" - Indicates the data is stored in
	// diff_download_response.
	//   "DIFF_UPLOAD_REQUEST" - Indicates the data is stored in
	// diff_upload_request.
	//   "DIFF_UPLOAD_RESPONSE" - Indicates the data is stored in
	// diff_upload_response.
	//   "COSMO_BINARY_REFERENCE" - Indicates the data is stored in
	// cosmo_binary_reference.
	//   "ARBITRARY_BYTES" - Informs Scotty to generate a response payload with the
	// size specified in the length field. The contents of the payload are
	// generated by Scotty and are undefined. This is useful for testing download
	// speeds between the user and Scotty without involving a real payload source.
	// Note: range is not supported when using arbitrary_bytes.
	ReferenceType string `json:"referenceType,omitempty"`
	// Sha1Hash: Scotty-provided SHA1 hash for an upload.
	Sha1Hash string `json:"sha1Hash,omitempty"`
	// Sha256Hash: Scotty-provided SHA256 hash for an upload.
	Sha256Hash string `json:"sha256Hash,omitempty"`
	// Timestamp: Time at which the media data was last updated, in milliseconds
	// since UNIX epoch
	Timestamp uint64 `json:"timestamp,omitempty,string"`
	// Token: A unique fingerprint/version id for the media data
	Token string `json:"token,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Algorithm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Algorithm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Media) MarshalJSON() ([]byte, error) {
	type NoMethod Media
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MediaRequestInfo: Extra information added to operations that support Scotty
// media requests.
type MediaRequestInfo struct {
	// CurrentBytes: The number of current bytes uploaded or downloaded.
	CurrentBytes int64 `json:"currentBytes,omitempty,string"`
	// CustomData: Data to be copied to backend requests. Custom data is returned
	// to Scotty in the agent_state field, which Scotty will then provide in
	// subsequent upload notifications.
	CustomData string `json:"customData,omitempty"`
	// DiffObjectVersion: Set if the http request info is diff encoded. The value
	// of this field is the version number of the base revision. This is
	// corresponding to Apiary's mediaDiffObjectVersion
	// (//depot/google3/java/com/google/api/server/media/variable/DiffObjectVersionV
	// ariable.java). See go/esf-scotty-diff-upload for more information.
	DiffObjectVersion string `json:"diffObjectVersion,omitempty"`
	// FinalStatus: The existence of the final_status field indicates that this is
	// the last call to the agent for this request_id.
	// http://google3/uploader/agent/scotty_agent.proto?l=737&rcl=347601929
	FinalStatus int64 `json:"finalStatus,omitempty"`
	// NotificationType: The type of notification received from Scotty.
	//
	// Possible values:
	//   "START" - Such requests signals the start of a request containing media
	// upload. Only the media field(s) in the inserted/updated resource are set.
	// The response should either return an error or succeed. On success, responses
	// don't need to contain anything.
	//   "PROGRESS" - Such requests signals that the upload has progressed and that
	// the backend might want to access the media file specified in relevant fields
	// in the resource. Only the media field(s) in the inserted/updated resource
	// are set. The response should either return an error or succeed. On success,
	// responses don't need to contain anything.
	//   "END" - Such requests signals the end of a request containing media
	// upload. END should be handled just like normal Insert/Upload requests, that
	// is, they should process the request and return a complete resource in the
	// response. Pointers to media data (a GFS path usually) appear in the relevant
	// fields in the inserted/updated resource. See gdata.Media in data.proto.
	//   "RESPONSE_SENT" - Such requests occur after an END and signal that the
	// response has been sent back to the client. RESPONSE_SENT is only sent to the
	// backend if it is configured to receive them. The response does not need to
	// contain anything.
	//   "ERROR" - Such requests indicate that an error occurred while processing
	// the request. ERROR is only sent to the backend if it is configured to
	// receive them. It is not guaranteed that all errors will result in this
	// notification to the backend, even if the backend requests them. Since these
	// requests are just for informational purposes, the response does not need to
	// contain anything.
	NotificationType string `json:"notificationType,omitempty"`
	// RequestId: The Scotty request ID.
	RequestId string `json:"requestId,omitempty"`
	// RequestReceivedParamsServingInfo: The partition of the Scotty server
	// handling this request. type is
	// uploader_service.RequestReceivedParamsServingInfo
	// LINT.IfChange(request_received_params_serving_info_annotations)
	// LINT.ThenChange()
	RequestReceivedParamsServingInfo string `json:"requestReceivedParamsServingInfo,omitempty"`
	// TotalBytes: The total size of the file.
	TotalBytes int64 `json:"totalBytes,omitempty,string"`
	// TotalBytesIsEstimated: Whether the total bytes field contains an estimated
	// data.
	TotalBytesIsEstimated bool `json:"totalBytesIsEstimated,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MediaRequestInfo) MarshalJSON() ([]byte, error) {
	type NoMethod MediaRequestInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Message: A message that will be displayed with a Valuable
type Message struct {
	// Body: The message body.
	Body string `json:"body,omitempty"`
	// DisplayInterval: The period of time that the message will be displayed to
	// users. You can define both a `startTime` and `endTime` for each message. A
	// message is displayed immediately after a Wallet Object is inserted unless a
	// `startTime` is set. The message will appear in a list of messages
	// indefinitely if `endTime` is not provided.
	DisplayInterval *TimeInterval `json:"displayInterval,omitempty"`
	// Header: The message header.
	Header string `json:"header,omitempty"`
	// Id: The ID associated with a message. This field is here to enable ease of
	// management of messages. Notice ID values could possibly duplicate across
	// multiple messages in the same class/instance, and care must be taken to
	// select a reasonable ID for each message.
	Id string `json:"id,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#walletObjectMessage".
	Kind string `json:"kind,omitempty"`
	// LocalizedBody: Translated strings for the message body.
	LocalizedBody *LocalizedString `json:"localizedBody,omitempty"`
	// LocalizedHeader: Translated strings for the message header.
	LocalizedHeader *LocalizedString `json:"localizedHeader,omitempty"`
	// MessageType: The message type.
	//
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED"
	//   "TEXT" - Renders the message as text on the card details screen. This is
	// the default message type.
	//   "text" - Legacy alias for `TEXT`. Deprecated.
	//   "EXPIRATION_NOTIFICATION" - Note: This enum is currently not supported.
	//   "expirationNotification" - Legacy alias for `EXPIRATION_NOTIFICATION`.
	// Deprecated.
	//   "TEXT_AND_NOTIFY" - Renders the message as text on the card details screen
	// and as an Android notification.
	MessageType string `json:"messageType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Body") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Body") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Message) MarshalJSON() ([]byte, error) {
	type NoMethod Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ModifyLinkedOfferObjects struct {
	// AddLinkedOfferObjectIds: The linked offer object ids to add to the object.
	AddLinkedOfferObjectIds []string `json:"addLinkedOfferObjectIds,omitempty"`
	// RemoveLinkedOfferObjectIds: The linked offer object ids to remove from the
	// object.
	RemoveLinkedOfferObjectIds []string `json:"removeLinkedOfferObjectIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddLinkedOfferObjectIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddLinkedOfferObjectIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyLinkedOfferObjects) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyLinkedOfferObjects
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ModifyLinkedOfferObjectsRequest struct {
	// LinkedOfferObjectIds: The linked offer object ids to add or remove from the
	// object.
	LinkedOfferObjectIds *ModifyLinkedOfferObjects `json:"linkedOfferObjectIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LinkedOfferObjectIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LinkedOfferObjectIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModifyLinkedOfferObjectsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyLinkedOfferObjectsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModuleViewConstraints: Constraints that all must be met for the module to be
// shown.
type ModuleViewConstraints struct {
	// DisplayInterval: The period of time that the module will be displayed to
	// users. Can define both a `startTime` and `endTime`. The module is displayed
	// immediately after insertion unless a `startTime` is set. The module is
	// displayed indefinitely if `endTime` is not set.
	DisplayInterval *TimeInterval `json:"displayInterval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayInterval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayInterval") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModuleViewConstraints) MarshalJSON() ([]byte, error) {
	type NoMethod ModuleViewConstraints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Money struct {
	// CurrencyCode: The currency code, such as "USD" or "EUR."
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#money".
	Kind string `json:"kind,omitempty"`
	// Micros: The unit of money amount in micros. For example, $1 USD would be
	// represented as 1000000 micros.
	Micros int64 `json:"micros,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Money) MarshalJSON() ([]byte, error) {
	type NoMethod Money
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Notifications: Indicates if the object needs to have notification enabled.
// We support only one of ExpiryNotification/UpcomingNotification.
// `expiryNotification` takes precedence over `upcomingNotification`. In other
// words if `expiryNotification` is set, we ignore the `upcomingNotification`
// field.
type Notifications struct {
	// ExpiryNotification: A notification would be triggered at a specific time
	// before the card expires.
	ExpiryNotification *ExpiryNotification `json:"expiryNotification,omitempty"`
	// UpcomingNotification: A notification would be triggered at a specific time
	// before the card becomes usable.
	UpcomingNotification *UpcomingNotification `json:"upcomingNotification,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpiryNotification") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpiryNotification") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Notifications) MarshalJSON() ([]byte, error) {
	type NoMethod Notifications
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ObjectId: This is a copy of the tech.blob.ObjectId proto, which could not be
// used directly here due to transitive closure issues with JavaScript support;
// see http://b/8801763.
type ObjectId struct {
	// BucketName: The name of the bucket to which this object belongs.
	BucketName string `json:"bucketName,omitempty"`
	// Generation: Generation of the object. Generations are monotonically
	// increasing across writes, allowing them to be be compared to determine which
	// generation is newer. If this is omitted in a request, then you are
	// requesting the live object. See http://go/bigstore-versions
	Generation int64 `json:"generation,omitempty,string"`
	// ObjectName: The name of the object.
	ObjectName string `json:"objectName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ObjectId) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OfferClass struct {
	// AllowMultipleUsersPerObject: Deprecated. Use
	// `multipleDevicesAndHoldersAllowedStatus` instead.
	AllowMultipleUsersPerObject bool `json:"allowMultipleUsersPerObject,omitempty"`
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// object that will be used instead.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// CallbackOptions: Callback options to be used to call the issuer back for
	// every save/delete of an object for this class by the end-user. All objects
	// of this class are eligible for the callback.
	CallbackOptions *CallbackOptions `json:"callbackOptions,omitempty"`
	// ClassTemplateInfo: Template information about how the class should be
	// displayed. If unset, Google will fallback to a default set of fields to
	// display.
	ClassTemplateInfo *ClassTemplateInfo `json:"classTemplateInfo,omitempty"`
	// CountryCode: Country code used to display the card's country (when the user
	// is not in that country), as well as to display localized content when
	// content is not available in the user's locale.
	CountryCode string `json:"countryCode,omitempty"`
	// Details: The details of the offer.
	Details string `json:"details,omitempty"`
	// EnableSmartTap: Identifies whether this class supports Smart Tap. The
	// `redemptionIssuers` and object level `smartTapRedemptionLevel` fields must
	// also be set up correctly in order for a pass to support Smart Tap.
	EnableSmartTap bool `json:"enableSmartTap,omitempty"`
	// FinePrint: The fine print or terms of the offer, such as "20% off any
	// t-shirt at Adam's Apparel."
	FinePrint string `json:"finePrint,omitempty"`
	// HelpUri: The help link for the offer, such as
	// `http://myownpersonaldomain.com/help`
	HelpUri *Uri `json:"helpUri,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, nothing will be displayed. The image will display at 100% width.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// HomepageUri: The URI of your application's home page. Populating the URI in
	// this field results in the exact same behavior as populating an URI in
	// linksModuleData (when an object is rendered, a link to the homepage is shown
	// in what would usually be thought of as the linksModuleData section of the
	// object).
	HomepageUri *Uri `json:"homepageUri,omitempty"`
	// Id: Required. The unique identifier for a class. This ID must be unique
	// across all classes from an issuer. This value should follow the format
	// issuer ID. identifier where the former is issued by Google and latter is
	// chosen by you. Your unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// IssuerName: Required. The issuer name. Recommended maximum length is 20
	// characters to ensure full string is displayed on smaller screens.
	IssuerName string `json:"issuerName,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#offerClass".
	Kind string `json:"kind,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the object, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// LocalizedDetails: Translated strings for the details.
	LocalizedDetails *LocalizedString `json:"localizedDetails,omitempty"`
	// LocalizedFinePrint: Translated strings for the fine_print.
	LocalizedFinePrint *LocalizedString `json:"localizedFinePrint,omitempty"`
	// LocalizedIssuerName: Translated strings for the issuer_name. Recommended
	// maximum length is 20 characters to ensure full string is displayed on
	// smaller screens.
	LocalizedIssuerName *LocalizedString `json:"localizedIssuerName,omitempty"`
	// LocalizedProvider: Translated strings for the provider. Recommended maximum
	// length is 12 characters to ensure full string is displayed on smaller
	// screens.
	LocalizedProvider *LocalizedString `json:"localizedProvider,omitempty"`
	// LocalizedShortTitle: Translated strings for the short title. Recommended
	// maximum length is 20 characters.
	LocalizedShortTitle *LocalizedString `json:"localizedShortTitle,omitempty"`
	// LocalizedTitle: Translated strings for the title. Recommended maximum length
	// is 60 characters to ensure full string is displayed on smaller screens.
	LocalizedTitle *LocalizedString `json:"localizedTitle,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// MultipleDevicesAndHoldersAllowedStatus: Identifies whether multiple users
	// and devices will save the same object referencing this class.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified preference.
	//   "MULTIPLE_HOLDERS" - The Pass object is shareable by a user and can be
	// saved by any number of different users, and on any number of devices.
	// Partners typically use this setup for passes that do not need to be
	// restricted to a single user or pinned to a single device.
	//   "ONE_USER_ALL_DEVICES" - An object can only be saved by one user, but this
	// user can view and use it on multiple of their devices. Once the first user
	// saves the object, no other user will be allowed to view or save it.
	//   "ONE_USER_ONE_DEVICE" - An object can only be saved by one user on a
	// single device. Intended for use by select partners in limited circumstances.
	// An example use case is a transit ticket that should be "device pinned",
	// meaning it can be saved, viewed and used only by a single user on a single
	// device. Contact support for additional information.
	//   "multipleHolders" - Legacy alias for `MULTIPLE_HOLDERS`. Deprecated.
	//   "oneUserAllDevices" - Legacy alias for `ONE_USER_ALL_DEVICES`. Deprecated.
	//   "oneUserOneDevice" - Legacy alias for `ONE_USER_ONE_DEVICE`. Deprecated.
	MultipleDevicesAndHoldersAllowedStatus string `json:"multipleDevicesAndHoldersAllowedStatus,omitempty"`
	// Provider: Required. The offer provider (either the aggregator name or
	// merchant name). Recommended maximum length is 12 characters to ensure full
	// string is displayed on smaller screens.
	Provider string `json:"provider,omitempty"`
	// RedemptionChannel: Required. The redemption channels applicable to this
	// offer.
	//
	// Possible values:
	//   "REDEMPTION_CHANNEL_UNSPECIFIED"
	//   "INSTORE"
	//   "instore" - Legacy alias for `INSTORE`. Deprecated.
	//   "ONLINE"
	//   "online" - Legacy alias for `ONLINE`. Deprecated.
	//   "BOTH"
	//   "both" - Legacy alias for `BOTH`. Deprecated.
	//   "TEMPORARY_PRICE_REDUCTION"
	//   "temporaryPriceReduction" - Legacy alias for `TEMPORARY_PRICE_REDUCTION`.
	// Deprecated.
	RedemptionChannel string `json:"redemptionChannel,omitempty"`
	// RedemptionIssuers: Identifies which redemption issuers can redeem the pass
	// over Smart Tap. Redemption issuers are identified by their issuer ID.
	// Redemption issuers must have at least one Smart Tap key configured. The
	// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also
	// be set up correctly in order for a pass to support Smart Tap.
	RedemptionIssuers googleapi.Int64s `json:"redemptionIssuers,omitempty"`
	// Review: The review comments set by the platform when a class is marked
	// `approved` or `rejected`.
	Review *Review `json:"review,omitempty"`
	// ReviewStatus: Required. The status of the class. This field can be set to
	// `draft` or The status of the class. This field can be set to `draft` or
	// `underReview` using the insert, patch, or update API calls. Once the review
	// state is changed from `draft` it may not be changed back to `draft`. You
	// should keep this field to `draft` when the class is under development. A
	// `draft` class cannot be used to create any object. You should set this field
	// to `underReview` when you believe the class is ready for use. The platform
	// will automatically set this field to `approved` and it can be immediately
	// used to create or migrate objects. When updating an already `approved` class
	// you should keep setting this field to `underReview`.
	//
	// Possible values:
	//   "REVIEW_STATUS_UNSPECIFIED"
	//   "UNDER_REVIEW"
	//   "underReview" - Legacy alias for `UNDER_REVIEW`. Deprecated.
	//   "APPROVED"
	//   "approved" - Legacy alias for `APPROVED`. Deprecated.
	//   "REJECTED"
	//   "rejected" - Legacy alias for `REJECTED`. Deprecated.
	//   "DRAFT"
	//   "draft" - Legacy alias for `DRAFT`. Deprecated.
	ReviewStatus string `json:"reviewStatus,omitempty"`
	// SecurityAnimation: Optional information about the security animation. If
	// this is set a security animation will be rendered on pass details.
	SecurityAnimation *SecurityAnimation `json:"securityAnimation,omitempty"`
	// ShortTitle: A shortened version of the title of the offer, such as "20%
	// off," shown to users as a quick reference to the offer contents. Recommended
	// maximum length is 20 characters.
	ShortTitle string `json:"shortTitle,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// Title: Required. The title of the offer, such as "20% off any t-shirt."
	// Recommended maximum length is 60 characters to ensure full string is
	// displayed on smaller screens.
	Title string `json:"title,omitempty"`
	// TitleImage: The title image of the offer. This image is displayed in both
	// the details and list views of the app.
	TitleImage *Image `json:"titleImage,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the class. For a pass only ten will be displayed, prioritizing those from
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`
	// ViewUnlockRequirement: View Unlock Requirement options for the offer.
	//
	// Possible values:
	//   "VIEW_UNLOCK_REQUIREMENT_UNSPECIFIED" - Default value, same as
	// UNLOCK_NOT_REQUIRED.
	//   "UNLOCK_NOT_REQUIRED" - Default behavior for all the existing Passes if
	// ViewUnlockRequirement is not set.
	//   "UNLOCK_REQUIRED_TO_VIEW" - Requires the user to unlock their device each
	// time the pass is viewed. If the user removes their device lock after saving
	// the pass, then they will be prompted to create a device lock before the pass
	// can be viewed.
	ViewUnlockRequirement string `json:"viewUnlockRequirement,omitempty"`
	// WideTitleImage: The wide title image of the offer. When provided, this will
	// be used in place of the title image in the top left of the card view.
	WideTitleImage *Image `json:"wideTitleImage,omitempty"`
	// WordMark: Deprecated.
	WordMark *Image `json:"wordMark,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "AllowMultipleUsersPerObject") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMultipleUsersPerObject") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OfferClass) MarshalJSON() ([]byte, error) {
	type NoMethod OfferClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OfferClassAddMessageResponse struct {
	// Resource: The updated OfferClass resource.
	Resource *OfferClass `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OfferClassAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OfferClassAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OfferClassListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*OfferClass `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OfferClassListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OfferClassListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OfferObject struct {
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// class only object AppLinkData will be displayed.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// Barcode: The barcode type and value.
	Barcode *Barcode `json:"barcode,omitempty"`
	// ClassId: Required. The class associated with this object. The class must be
	// of the same type as this object, must already exist, and must be approved.
	// Class IDs should follow the format issuer ID.identifier where the former is
	// issued by Google and latter is chosen by you.
	ClassId string `json:"classId,omitempty"`
	// ClassReference: A copy of the inherited fields of the parent class. These
	// fields are retrieved during a GET.
	ClassReference *OfferClass `json:"classReference,omitempty"`
	// DisableExpirationNotification: Indicates if notifications should explicitly
	// be suppressed. If this field is set to true, regardless of the `messages`
	// field, expiration notifications to the user will be suppressed. By default,
	// this field is set to false. Currently, this can only be set for offers.
	DisableExpirationNotification bool `json:"disableExpirationNotification,omitempty"`
	// GroupingInfo: Information that controls how passes are grouped together.
	GroupingInfo *GroupingInfo `json:"groupingInfo,omitempty"`
	// HasLinkedDevice: Whether this object is currently linked to a single device.
	// This field is set by the platform when a user saves the object, linking it
	// to their device. Intended for use by select partners. Contact support for
	// additional information.
	HasLinkedDevice bool `json:"hasLinkedDevice,omitempty"`
	// HasUsers: Indicates if the object has users. This field is set by the
	// platform.
	HasUsers bool `json:"hasUsers,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, hero image of the class, if present, will be displayed. If hero
	// image of the class is also not present, nothing will be displayed.
	HeroImage *Image `json:"heroImage,omitempty"`
	// Id: Required. The unique identifier for an object. This ID must be unique
	// across all objects from an issuer. This value should follow the format
	// issuer ID.identifier where the former is issued by Google and latter is
	// chosen by you. The unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#offerObject".
	Kind string `json:"kind,omitempty"`
	// LinkedObjectIds: linked_object_ids are a list of other objects such as event
	// ticket, loyalty, offer, generic, giftcard, transit and boarding pass that
	// should be automatically attached to this offer object. If a user had saved
	// this offer, then these linked_object_ids would be automatically pushed to
	// the user's wallet (unless they turned off the setting to receive such linked
	// passes). Make sure that objects present in linked_object_ids are already
	// inserted - if not, calls would fail. Once linked, the linked objects cannot
	// be unlinked. You cannot link objects belonging to another issuer. There is a
	// limit to the number of objects that can be linked to a single object. After
	// the limit is reached, new linked objects in the call will be ignored
	// silently. Object IDs should follow the format issuer ID.identifier where the
	// former is issued by Google and the latter is chosen by you.
	LinkedObjectIds []string `json:"linkedObjectIds,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the class, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// PassConstraints: Pass constraints for the object. Includes limiting NFC and
	// screenshot behaviors.
	PassConstraints *PassConstraints `json:"passConstraints,omitempty"`
	// RotatingBarcode: The rotating barcode type and value.
	RotatingBarcode *RotatingBarcode `json:"rotatingBarcode,omitempty"`
	// SaveRestrictions: Restrictions on the object that needs to be verified
	// before the user tries to save the pass. Note that this restrictions will
	// only be applied during save time. If the restrictions changed after a user
	// saves the pass, the new restrictions will not be applied to an already saved
	// pass.
	SaveRestrictions *SaveRestrictions `json:"saveRestrictions,omitempty"`
	// SmartTapRedemptionValue: The value that will be transmitted to a Smart Tap
	// certified terminal over NFC for this object. The class level fields
	// `enableSmartTap` and `redemptionIssuers` must also be set up correctly in
	// order for the pass to support Smart Tap. Only ASCII characters are
	// supported.
	SmartTapRedemptionValue string `json:"smartTapRedemptionValue,omitempty"`
	// State: Required. The state of the object. This field is used to determine
	// how an object is displayed in the app. For example, an `inactive` object is
	// moved to the "Expired passes" section.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "ACTIVE" - Object is active and displayed to with other active objects.
	//   "active" - Legacy alias for `ACTIVE`. Deprecated.
	//   "COMPLETED"
	//   "completed" - Legacy alias for `COMPLETED`. Deprecated.
	//   "EXPIRED" - Object is no longer valid (`validTimeInterval` passed).
	//   "expired" - Legacy alias for `EXPIRED`. Deprecated.
	//   "INACTIVE"
	//   "inactive" - Legacy alias for `INACTIVE`. Deprecated.
	State string `json:"state,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// ValidTimeInterval: The time period this object will be `active` and object
	// can be used. An object's state will be changed to `expired` when this time
	// period has passed.
	ValidTimeInterval *TimeInterval `json:"validTimeInterval,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppLinkData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppLinkData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OfferObject) MarshalJSON() ([]byte, error) {
	type NoMethod OfferObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OfferObjectAddMessageResponse struct {
	// Resource: The updated OfferObject resource.
	Resource *OfferObject `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OfferObjectAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OfferObjectAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OfferObjectListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*OfferObject `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OfferObjectListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OfferObjectListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Pagination struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#pagination".
	Kind string `json:"kind,omitempty"`
	// NextPageToken: Page token to send to fetch the next page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ResultsPerPage: Number of results returned in this page.
	ResultsPerPage int64 `json:"resultsPerPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Pagination) MarshalJSON() ([]byte, error) {
	type NoMethod Pagination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PassConstraints: Container for any constraints that may be placed on passes.
type PassConstraints struct {
	// NfcConstraint: The NFC constraints for the pass.
	//
	// Possible values:
	//   "NFC_CONSTRAINT_UNSPECIFIED" - Default value, no specified constraint.
	//   "BLOCK_PAYMENT" - Payment cards will not be conveyed while the pass is
	// open.
	//   "BLOCK_CLOSED_LOOP_TRANSIT" - Closed loop transit cards will not be
	// conveyed while the pass is open.
	NfcConstraint []string `json:"nfcConstraint,omitempty"`
	// ScreenshotEligibility: The screenshot eligibility for the pass.
	//
	// Possible values:
	//   "SCREENSHOT_ELIGIBILITY_UNSPECIFIED" - Default value, same as ELIGIBLE.
	//   "ELIGIBLE" - Default behavior for all existing Passes if
	// ScreenshotEligibility is not set. Allows screenshots to be taken on Android
	// devices.
	//   "INELIGIBLE" - Disallows screenshots to be taken on Android devices. Note
	// that older versions of Wallet may still allow screenshots to be taken.
	ScreenshotEligibility string `json:"screenshotEligibility,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NfcConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NfcConstraint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PassConstraints) MarshalJSON() ([]byte, error) {
	type NoMethod PassConstraints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Permission struct {
	// EmailAddress: The email address of the user, group, or service account to
	// which this permission refers to.
	EmailAddress string `json:"emailAddress,omitempty"`
	// Role: The role granted by this permission.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "OWNER"
	//   "owner" - Legacy alias for `OWNER`. Deprecated.
	//   "READER"
	//   "reader" - Legacy alias for `READER`. Deprecated.
	//   "WRITER"
	//   "writer" - Legacy alias for `WRITER`. Deprecated.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Permission) MarshalJSON() ([]byte, error) {
	type NoMethod Permission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Permissions struct {
	// IssuerId: ID of the issuer the list of permissions refer to.
	IssuerId int64 `json:"issuerId,omitempty,string"`
	// Permissions: The complete list of permissions for the issuer account.
	Permissions []*Permission `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IssuerId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssuerId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Permissions) MarshalJSON() ([]byte, error) {
	type NoMethod Permissions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PurchaseDetails struct {
	// AccountId: ID of the account used to purchase the ticket.
	AccountId string `json:"accountId,omitempty"`
	// ConfirmationCode: The confirmation code for the purchase. This may be the
	// same for multiple different tickets and is used to group tickets together.
	ConfirmationCode string `json:"confirmationCode,omitempty"`
	// PurchaseDateTime: The purchase date/time of the ticket. This is an ISO 8601
	// extended format date/time, with or without an offset. Time may be specified
	// up to nanosecond precision. Offsets may be specified with seconds precision
	// (even though offset seconds is not part of ISO 8601). For example:
	// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the
	// 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would
	// be 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4
	// hours before UTC (same instant in time as the above example). If the event
	// were in New York, this would be the equivalent of Eastern Daylight Time
	// (EDT). Remember that offset varies in regions that observe Daylight Saving
	// Time (or Summer Time), depending on the time of the year.
	// `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the
	// 19th hour of April 12th, 1985 with no offset information. Without offset
	// information, some rich features may not be available.
	PurchaseDateTime string `json:"purchaseDateTime,omitempty"`
	// PurchaseReceiptNumber: Receipt number/identifier for tracking the ticket
	// purchase via the body that sold the ticket.
	PurchaseReceiptNumber string `json:"purchaseReceiptNumber,omitempty"`
	// TicketCost: The cost of the ticket.
	TicketCost *TicketCost `json:"ticketCost,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PurchaseDetails) MarshalJSON() ([]byte, error) {
	type NoMethod PurchaseDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ReservationInfo struct {
	// ConfirmationCode: Confirmation code needed to check into this flight. This
	// is the number that the passenger would enter into a kiosk at the airport to
	// look up the flight and print a boarding pass.
	ConfirmationCode string `json:"confirmationCode,omitempty"`
	// EticketNumber: E-ticket number.
	EticketNumber string `json:"eticketNumber,omitempty"`
	// FrequentFlyerInfo: Frequent flyer membership information.
	FrequentFlyerInfo *FrequentFlyerInfo `json:"frequentFlyerInfo,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#reservationInfo".
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfirmationCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfirmationCode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReservationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ReservationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Resources struct {
	// EventTicketClasses: A list of event ticket classes.
	EventTicketClasses []*EventTicketClass `json:"eventTicketClasses,omitempty"`
	// EventTicketObjects: A list of event ticket objects.
	EventTicketObjects []*EventTicketObject `json:"eventTicketObjects,omitempty"`
	// FlightClasses: A list of flight classes.
	FlightClasses []*FlightClass `json:"flightClasses,omitempty"`
	// FlightObjects: A list of flight objects.
	FlightObjects []*FlightObject `json:"flightObjects,omitempty"`
	// GenericClasses: A list of generic classes.
	GenericClasses []*GenericClass `json:"genericClasses,omitempty"`
	// GenericObjects: A list of generic objects.
	GenericObjects []*GenericObject `json:"genericObjects,omitempty"`
	// GiftCardClasses: A list of gift card classes.
	GiftCardClasses []*GiftCardClass `json:"giftCardClasses,omitempty"`
	// GiftCardObjects: A list of gift card objects.
	GiftCardObjects []*GiftCardObject `json:"giftCardObjects,omitempty"`
	// LoyaltyClasses: A list of loyalty classes.
	LoyaltyClasses []*LoyaltyClass `json:"loyaltyClasses,omitempty"`
	// LoyaltyObjects: A list of loyalty objects.
	LoyaltyObjects []*LoyaltyObject `json:"loyaltyObjects,omitempty"`
	// OfferClasses: A list of offer classes.
	OfferClasses []*OfferClass `json:"offerClasses,omitempty"`
	// OfferObjects: A list of offer objects.
	OfferObjects []*OfferObject `json:"offerObjects,omitempty"`
	// TransitClasses: A list of transit classes.
	TransitClasses []*TransitClass `json:"transitClasses,omitempty"`
	// TransitObjects: A list of transit objects.
	TransitObjects []*TransitObject `json:"transitObjects,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EventTicketClasses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EventTicketClasses") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Resources) MarshalJSON() ([]byte, error) {
	type NoMethod Resources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Review struct {
	Comments string `json:"comments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Comments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Comments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Review) MarshalJSON() ([]byte, error) {
	type NoMethod Review
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RotatingBarcode struct {
	// AlternateText: An optional text that will override the default text that
	// shows under the barcode. This field is intended for a human readable
	// equivalent of the barcode value, used when the barcode cannot be scanned.
	AlternateText string `json:"alternateText,omitempty"`
	// InitialRotatingBarcodeValues: Input only. NOTE: This feature is only
	// available for the transit vertical. Optional set of initial rotating barcode
	// values. This allows a small subset of barcodes to be included with the
	// object. Further rotating barcode values must be uploaded with the
	// UploadRotatingBarcodeValues endpoint.
	InitialRotatingBarcodeValues *RotatingBarcodeValues `json:"initialRotatingBarcodeValues,omitempty"`
	// RenderEncoding: The render encoding for the barcode. When specified, barcode
	// is rendered in the given encoding. Otherwise best known encoding is chosen
	// by Google.
	//
	// Possible values:
	//   "RENDER_ENCODING_UNSPECIFIED"
	//   "UTF_8" - UTF_8 encoding for barcodes. This is only supported for barcode
	// type qrCode.
	RenderEncoding string `json:"renderEncoding,omitempty"`
	// ShowCodeText: Optional text that will be shown when the barcode is hidden
	// behind a click action. This happens in cases where a pass has Smart Tap
	// enabled. If not specified, a default is chosen by Google.
	ShowCodeText *LocalizedString `json:"showCodeText,omitempty"`
	// TotpDetails: Details used to evaluate the {totp_value_n} substitutions.
	TotpDetails *RotatingBarcodeTotpDetails `json:"totpDetails,omitempty"`
	// Type: The type of this barcode.
	//
	// Possible values:
	//   "BARCODE_TYPE_UNSPECIFIED"
	//   "AZTEC" - Not supported for Rotating Barcodes.
	//   "aztec" - Legacy alias for `AZTEC`. Deprecated. Not supported for Rotating
	// Barcodes.
	//   "CODE_39" - Not supported for Rotating Barcodes.
	//   "code39" - Legacy alias for `CODE_39`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "CODE_128" - Not supported for Rotating Barcodes.
	//   "code128" - Legacy alias for `CODE_128`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "CODABAR" - Not supported for Rotating Barcodes.
	//   "codabar" - Legacy alias for `CODABAR`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "DATA_MATRIX" - A 2D matrix barcode consisting of black and white. Cells
	// or modules are arranged in either a square or rectangle. Not supported for
	// Rotating Barcodes.
	//   "dataMatrix" - Legacy alias for `DATA_MATRIX`. Deprecated. Not supported
	// for Rotating Barcodes.
	//   "EAN_8" - Not supported for Rotating Barcodes.
	//   "ean8" - Legacy alias for `EAN_8`. Deprecated. Not supported for Rotating
	// Barcodes.
	//   "EAN_13" - Not supported for Rotating Barcodes.
	//   "ean13" - Legacy alias for `EAN_13`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "EAN13" - Legacy alias for `EAN_13`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "ITF_14" - 14 digit ITF code Not supported for Rotating Barcodes.
	//   "itf14" - Legacy alias for `ITF_14`. Deprecated. Not supported for
	// Rotating Barcodes.
	//   "PDF_417" - Supported for Rotating Barcodes.
	//   "pdf417" - Legacy alias for `PDF_417`. Deprecated.
	//   "PDF417" - Legacy alias for `PDF_417`. Deprecated.
	//   "QR_CODE" - Supported for Rotating Barcodes.
	//   "qrCode" - Legacy alias for `QR_CODE`. Deprecated.
	//   "qrcode" - Legacy alias for `QR_CODE`. Deprecated.
	//   "UPC_A" - 11 or 12 digit codes Not supported for Rotating Barcodes.
	//   "upcA" - Legacy alias for `UPC_A`. Deprecated. Not supported for Rotating
	// Barcodes.
	//   "TEXT_ONLY" - Renders the field as a text field. The `alternateText` field
	// may not be used with a barcode of type `textOnly`. Not supported for
	// Rotating Barcodes.
	//   "textOnly" - Legacy alias for `TEXT_ONLY`. Deprecated. Not supported for
	// Rotating Barcodes.
	Type string `json:"type,omitempty"`
	// ValuePattern: String encoded barcode value. This string supports the
	// following substitutions: * {totp_value_n}: Replaced with the TOTP value (see
	// TotpDetails.parameters). * {totp_timestamp_millis}: Replaced with the
	// timestamp (millis since epoch) at which the barcode was generated. *
	// {totp_timestamp_seconds}: Replaced with the timestamp (seconds since epoch)
	// at which the barcode was generated.
	ValuePattern string `json:"valuePattern,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternateText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotatingBarcode) MarshalJSON() ([]byte, error) {
	type NoMethod RotatingBarcode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RotatingBarcodeTotpDetails: Configuration for the time-based OTP
// substitutions. See https://tools.ietf.org/html/rfc6238
type RotatingBarcodeTotpDetails struct {
	// Algorithm: The TOTP algorithm used to generate the OTP.
	//
	// Possible values:
	//   "TOTP_ALGORITHM_UNSPECIFIED"
	//   "TOTP_SHA1" - TOTP algorithm from RFC 6238 with the SHA1 hash function
	Algorithm string `json:"algorithm,omitempty"`
	// Parameters: The TOTP parameters for each of the {totp_value_*}
	// substitutions. The TotpParameters at index n is used for the {totp_value_n}
	// substitution.
	Parameters []*RotatingBarcodeTotpDetailsTotpParameters `json:"parameters,omitempty"`
	// PeriodMillis: The time interval used for the TOTP value generation, in
	// milliseconds.
	PeriodMillis int64 `json:"periodMillis,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Algorithm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Algorithm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotatingBarcodeTotpDetails) MarshalJSON() ([]byte, error) {
	type NoMethod RotatingBarcodeTotpDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RotatingBarcodeTotpDetailsTotpParameters: Configuration for the key and
// value length. See https://www.rfc-editor.org/rfc/rfc4226#section-5.3
type RotatingBarcodeTotpDetailsTotpParameters struct {
	// Key: The secret key used for the TOTP value generation, encoded as a Base16
	// string.
	Key string `json:"key,omitempty"`
	// ValueLength: The length of the TOTP value in decimal digits.
	ValueLength int64 `json:"valueLength,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotatingBarcodeTotpDetailsTotpParameters) MarshalJSON() ([]byte, error) {
	type NoMethod RotatingBarcodeTotpDetailsTotpParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RotatingBarcodeValues: A payload containing many barcode values and start
// date/time.
type RotatingBarcodeValues struct {
	// PeriodMillis: Required. The amount of time each barcode is valid for.
	PeriodMillis int64 `json:"periodMillis,omitempty,string"`
	// StartDateTime: Required. The date/time the first barcode is valid from.
	// Barcodes will be rotated through using period_millis defined on the object's
	// RotatingBarcodeValueInfo. This is an ISO 8601 extended format date/time,
	// with an offset. Time may be specified up to nanosecond precision. Offsets
	// may be specified with seconds precision (even though offset seconds is not
	// part of ISO 8601). For example: `1985-04-12T23:20:50.52Z` would be 20
	// minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in UTC.
	// `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
	// the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time
	// as the above example). If the event were in New York, this would be the
	// equivalent of Eastern Daylight Time (EDT). Remember that offset varies in
	// regions that observe Daylight Saving Time (or Summer Time), depending on the
	// time of the year.
	StartDateTime string `json:"startDateTime,omitempty"`
	// Values: Required. The values to encode in the barcode. At least one value is
	// required.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PeriodMillis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PeriodMillis") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotatingBarcodeValues) MarshalJSON() ([]byte, error) {
	type NoMethod RotatingBarcodeValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SaveRestrictions: Defines restrictions on the object that will be verified
// during save. Note: this is an advanced feature, please contact Google for
// implementation support.
type SaveRestrictions struct {
	// RestrictToEmailSha256: Restrict the save of the referencing object to the
	// given email address only. This is the hex output of SHA256 sum of the email
	// address, all lowercase and without any notations like "." or "+", except
	// "@". For example, for example@example.com, this value will be
	// 31c5543c1734d25c7206f5fd591525d0295bec6fe84ff82f946a34fe970a1e66 and for
	// Example@example.com, this value will be
	// bc34f262c93ad7122763684ccea6f07fb7f5d8a2d11e60ce15a6f43fe70ce632 If email
	// address of the logged-in user who tries to save this pass does not match
	// with the defined value here, users won't be allowed to save this pass. They
	// will instead be prompted with an error to contact the issuer. This
	// information should be gathered from the user with an explicit consent via
	// Sign in with Google integration
	// https://developers.google.com/identity/authentication. Please contact with
	// support before using Save Restrictions.
	RestrictToEmailSha256 string `json:"restrictToEmailSha256,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RestrictToEmailSha256") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RestrictToEmailSha256") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SaveRestrictions) MarshalJSON() ([]byte, error) {
	type NoMethod SaveRestrictions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SecurityAnimation struct {
	// AnimationType: Type of animation.
	//
	// Possible values:
	//   "ANIMATION_UNSPECIFIED"
	//   "FOIL_SHIMMER" - Default Foil & Shimmer animation
	//   "foilShimmer" - Legacy alias for `FOIL_SHIMMER`. Deprecated.
	AnimationType string `json:"animationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnimationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnimationType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityAnimation) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityAnimation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SignUpInfo struct {
	// ClassId: ID of the class the user can sign up for.
	ClassId string `json:"classId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClassId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClassId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SignUpInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SignUpInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SmartTap struct {
	// Id: The unique identifier for a smart tap. This value should follow the
	// format issuer ID.identifier where the former is issued by Google and latter
	// is the Smart Tap id. The Smart Tap id is a Base64 encoded string which
	// represents the id which was generated by the Google Pay app.
	Id string `json:"id,omitempty"`
	// Infos: Communication from merchant to user.
	Infos []*IssuerToUserInfo `json:"infos,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#smartTap".
	Kind string `json:"kind,omitempty"`
	// MerchantId: Smart Tap merchant ID of who engaged in the Smart Tap
	// interaction.
	MerchantId int64 `json:"merchantId,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SmartTap) MarshalJSON() ([]byte, error) {
	type NoMethod SmartTap
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SmartTapMerchantData struct {
	// AuthenticationKeys: Available only to Smart Tap enabled partners. Contact
	// support for additional guidance.
	AuthenticationKeys []*AuthenticationKey `json:"authenticationKeys,omitempty"`
	// SmartTapMerchantId: Available only to Smart Tap enabled partners. Contact
	// support for additional guidance.
	SmartTapMerchantId int64 `json:"smartTapMerchantId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AuthenticationKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthenticationKeys") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SmartTapMerchantData) MarshalJSON() ([]byte, error) {
	type NoMethod SmartTapMerchantData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TemplateItem struct {
	// FirstValue: A reference to a field to display. If both `firstValue` and
	// `secondValue` are populated, they will both appear as one item with a slash
	// between them. For example, values A and B would be shown as "A / B".
	FirstValue *FieldSelector `json:"firstValue,omitempty"`
	// PredefinedItem: A predefined item to display. Only one of `firstValue` or
	// `predefinedItem` may be set.
	//
	// Possible values:
	//   "PREDEFINED_ITEM_UNSPECIFIED"
	//   "FREQUENT_FLYER_PROGRAM_NAME_AND_NUMBER"
	//   "frequentFlyerProgramNameAndNumber" - Legacy alias for
	// `FREQUENT_FLYER_PROGRAM_NAME_AND_NUMBER`. Deprecated.
	//   "FLIGHT_NUMBER_AND_OPERATING_FLIGHT_NUMBER"
	//   "flightNumberAndOperatingFlightNumber" - Legacy alias for
	// `FLIGHT_NUMBER_AND_OPERATING_FLIGHT_NUMBER`. Deprecated.
	PredefinedItem string `json:"predefinedItem,omitempty"`
	// SecondValue: A reference to a field to display. This may only be populated
	// if the `firstValue` field is populated.
	SecondValue *FieldSelector `json:"secondValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FirstValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FirstValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TemplateItem) MarshalJSON() ([]byte, error) {
	type NoMethod TemplateItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextModuleData: Data for Text module. All fields are optional. Header will
// be displayed if available, different types of bodies will be concatenated if
// they are defined.
type TextModuleData struct {
	// Body: The body of the Text Module, which is defined as an uninterrupted
	// string. Recommended maximum length is 500 characters to ensure full string
	// is displayed on smaller screens.
	Body string `json:"body,omitempty"`
	// Header: The header of the Text Module. Recommended maximum length is 35
	// characters to ensure full string is displayed on smaller screens.
	Header string `json:"header,omitempty"`
	// Id: The ID associated with a text module. This field is here to enable ease
	// of management of text modules and referencing them in template overrides.
	// The ID should only include alphanumeric characters, '_', or '-'. It can not
	// include dots, as dots are used to separate fields within
	// FieldReference.fieldPaths in template overrides.
	Id string `json:"id,omitempty"`
	// LocalizedBody: Translated strings for the body. Recommended maximum length
	// is 500 characters to ensure full string is displayed on smaller screens.
	LocalizedBody *LocalizedString `json:"localizedBody,omitempty"`
	// LocalizedHeader: Translated strings for the header. Recommended maximum
	// length is 35 characters to ensure full string is displayed on smaller
	// screens.
	LocalizedHeader *LocalizedString `json:"localizedHeader,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Body") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Body") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextModuleData) MarshalJSON() ([]byte, error) {
	type NoMethod TextModuleData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TicketCost struct {
	// DiscountMessage: A message describing any kind of discount that was applied.
	DiscountMessage *LocalizedString `json:"discountMessage,omitempty"`
	// FaceValue: The face value of the ticket.
	FaceValue *Money `json:"faceValue,omitempty"`
	// PurchasePrice: The actual purchase price of the ticket, after tax and/or
	// discounts.
	PurchasePrice *Money `json:"purchasePrice,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiscountMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscountMessage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TicketCost) MarshalJSON() ([]byte, error) {
	type NoMethod TicketCost
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TicketLeg struct {
	// ArrivalDateTime: The date/time of arrival. This is an ISO 8601 extended
	// format date/time, with or without an offset. Time may be specified up to
	// nanosecond precision. Offsets may be specified with seconds precision (even
	// though offset seconds is not part of ISO 8601). For example:
	// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the
	// 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would
	// be 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4
	// hours before UTC (same instant in time as the above example). If the event
	// were in New York, this would be the equivalent of Eastern Daylight Time
	// (EDT). Remember that offset varies in regions that observe Daylight Saving
	// Time (or Summer Time), depending on the time of the year.
	// `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the
	// 19th hour of April 12th, 1985 with no offset information. The portion of the
	// date/time without the offset is considered the "local date/time". This
	// should be the local date/time at the destination station. For example, if
	// the event occurs at the 20th hour of June 5th, 2018 at the destination
	// station, the local date/time portion should be `2018-06-05T20:00:00`. If the
	// local date/time at the destination station is 4 hours before UTC, an offset
	// of `-04:00` may be appended. Without offset information, some rich features
	// may not be available.
	ArrivalDateTime string `json:"arrivalDateTime,omitempty"`
	// Carriage: The train or ship name/number that the passsenger needs to board.
	Carriage string `json:"carriage,omitempty"`
	// DepartureDateTime: The date/time of departure. This is required if there is
	// no validity time interval set on the transit object. This is an ISO 8601
	// extended format date/time, with or without an offset. Time may be specified
	// up to nanosecond precision. Offsets may be specified with seconds precision
	// (even though offset seconds is not part of ISO 8601). For example:
	// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the
	// 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would
	// be 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4
	// hours before UTC (same instant in time as the above example). If the event
	// were in New York, this would be the equivalent of Eastern Daylight Time
	// (EDT). Remember that offset varies in regions that observe Daylight Saving
	// Time (or Summer Time), depending on the time of the year.
	// `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the
	// 19th hour of April 12th, 1985 with no offset information. The portion of the
	// date/time without the offset is considered the "local date/time". This
	// should be the local date/time at the origin station. For example, if the
	// departure occurs at the 20th hour of June 5th, 2018 at the origin station,
	// the local date/time portion should be `2018-06-05T20:00:00`. If the local
	// date/time at the origin station is 4 hours before UTC, an offset of `-04:00`
	// may be appended. Without offset information, some rich features may not be
	// available.
	DepartureDateTime string `json:"departureDateTime,omitempty"`
	// DestinationName: The destination name.
	DestinationName *LocalizedString `json:"destinationName,omitempty"`
	// DestinationStationCode: The destination station code.
	DestinationStationCode string `json:"destinationStationCode,omitempty"`
	// FareName: Short description/name of the fare for this leg of travel. Eg
	// "Anytime Single Use".
	FareName *LocalizedString `json:"fareName,omitempty"`
	// OriginName: The name of the origin station. This is required if
	// `desinationName` is present or if `originStationCode` is not present.
	OriginName *LocalizedString `json:"originName,omitempty"`
	// OriginStationCode: The origin station code. This is required if
	// `destinationStationCode` is present or if `originName` is not present.
	OriginStationCode string `json:"originStationCode,omitempty"`
	// Platform: The platform or gate where the passenger can board the carriage.
	Platform string `json:"platform,omitempty"`
	// TicketSeat: The reserved seat for the passenger(s). If more than one seat is
	// to be specified then use the `ticketSeats` field instead. Both `ticketSeat`
	// and `ticketSeats` may not be set.
	TicketSeat *TicketSeat `json:"ticketSeat,omitempty"`
	// TicketSeats: The reserved seat for the passenger(s). If only one seat is to
	// be specified then use the `ticketSeat` field instead. Both `ticketSeat` and
	// `ticketSeats` may not be set.
	TicketSeats []*TicketSeat `json:"ticketSeats,omitempty"`
	// TransitOperatorName: The name of the transit operator that is operating this
	// leg of a trip.
	TransitOperatorName *LocalizedString `json:"transitOperatorName,omitempty"`
	// TransitTerminusName: Terminus station or destination of the train/bus/etc.
	TransitTerminusName *LocalizedString `json:"transitTerminusName,omitempty"`
	// Zone: The zone of boarding within the platform.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArrivalDateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArrivalDateTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TicketLeg) MarshalJSON() ([]byte, error) {
	type NoMethod TicketLeg
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TicketRestrictions struct {
	// OtherRestrictions: Extra restrictions that don't fall under the "route" or
	// "time" categories.
	OtherRestrictions *LocalizedString `json:"otherRestrictions,omitempty"`
	// RouteRestrictions: Restrictions about routes that may be taken. For example,
	// this may be the string "Reserved CrossCountry trains only".
	RouteRestrictions *LocalizedString `json:"routeRestrictions,omitempty"`
	// RouteRestrictionsDetails: More details about the above `routeRestrictions`.
	RouteRestrictionsDetails *LocalizedString `json:"routeRestrictionsDetails,omitempty"`
	// TimeRestrictions: Restrictions about times this ticket may be used.
	TimeRestrictions *LocalizedString `json:"timeRestrictions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OtherRestrictions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OtherRestrictions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TicketRestrictions) MarshalJSON() ([]byte, error) {
	type NoMethod TicketRestrictions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TicketSeat struct {
	// Coach: The identifier of the train car or coach in which the ticketed seat
	// is located. Eg. "10"
	Coach string `json:"coach,omitempty"`
	// CustomFareClass: A custome fare class to be used if no `fareClass` applies.
	// Both `fareClass` and `customFareClass` may not be set.
	CustomFareClass *LocalizedString `json:"customFareClass,omitempty"`
	// FareClass: The fare class of the ticketed seat.
	//
	// Possible values:
	//   "FARE_CLASS_UNSPECIFIED"
	//   "ECONOMY"
	//   "economy" - Legacy alias for `ECONOMY`. Deprecated.
	//   "FIRST"
	//   "first" - Legacy alias for `FIRST`. Deprecated.
	//   "BUSINESS"
	//   "business" - Legacy alias for `BUSINESS`. Deprecated.
	FareClass string `json:"fareClass,omitempty"`
	// Seat: The identifier of where the ticketed seat is located. Eg. "42". If
	// there is no specific identifier, use `seatAssigment` instead.
	Seat string `json:"seat,omitempty"`
	// SeatAssignment: The passenger's seat assignment. Eg. "no specific seat". To
	// be used when there is no specific identifier to use in `seat`.
	SeatAssignment *LocalizedString `json:"seatAssignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Coach") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Coach") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TicketSeat) MarshalJSON() ([]byte, error) {
	type NoMethod TicketSeat
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TimeInterval struct {
	// End: End time of the interval. Offset is not required. If an offset is
	// provided and `start` time is set, `start` must also include an offset.
	End *DateTime `json:"end,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#timeInterval".
	Kind string `json:"kind,omitempty"`
	// Start: Start time of the interval. Offset is not required. If an offset is
	// provided and `end` time is set, `end` must also include an offset.
	Start *DateTime `json:"start,omitempty"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeInterval) MarshalJSON() ([]byte, error) {
	type NoMethod TimeInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TransitClass struct {
	// ActivationOptions: Activation options for an activatable ticket.
	ActivationOptions *ActivationOptions `json:"activationOptions,omitempty"`
	// AllowMultipleUsersPerObject: Deprecated. Use
	// `multipleDevicesAndHoldersAllowedStatus` instead.
	AllowMultipleUsersPerObject bool `json:"allowMultipleUsersPerObject,omitempty"`
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// object that will be used instead.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// CallbackOptions: Callback options to be used to call the issuer back for
	// every save/delete of an object for this class by the end-user. All objects
	// of this class are eligible for the callback.
	CallbackOptions *CallbackOptions `json:"callbackOptions,omitempty"`
	// ClassTemplateInfo: Template information about how the class should be
	// displayed. If unset, Google will fallback to a default set of fields to
	// display.
	ClassTemplateInfo *ClassTemplateInfo `json:"classTemplateInfo,omitempty"`
	// CountryCode: Country code used to display the card's country (when the user
	// is not in that country), as well as to display localized content when
	// content is not available in the user's locale.
	CountryCode string `json:"countryCode,omitempty"`
	// CustomCarriageLabel: A custom label to use for the carriage value
	// (`transitObject.ticketLeg.carriage`).
	CustomCarriageLabel *LocalizedString `json:"customCarriageLabel,omitempty"`
	// CustomCoachLabel: A custom label to use for the coach value
	// (`transitObject.ticketLeg.ticketSeat.coach`).
	CustomCoachLabel *LocalizedString `json:"customCoachLabel,omitempty"`
	// CustomConcessionCategoryLabel: A custom label to use for the transit
	// concession category value (`transitObject.concessionCategory`).
	CustomConcessionCategoryLabel *LocalizedString `json:"customConcessionCategoryLabel,omitempty"`
	// CustomConfirmationCodeLabel: A custom label to use for the confirmation code
	// value (`transitObject.purchaseDetails.confirmationCode`).
	CustomConfirmationCodeLabel *LocalizedString `json:"customConfirmationCodeLabel,omitempty"`
	// CustomDiscountMessageLabel: A custom label to use for the transit discount
	// message value (`transitObject.purchaseDetails.ticketCost.discountMessage`).
	CustomDiscountMessageLabel *LocalizedString `json:"customDiscountMessageLabel,omitempty"`
	// CustomFareClassLabel: A custom label to use for the fare class value
	// (`transitObject.ticketLeg.ticketSeat.fareClass`).
	CustomFareClassLabel *LocalizedString `json:"customFareClassLabel,omitempty"`
	// CustomFareNameLabel: A custom label to use for the transit fare name value
	// (`transitObject.ticketLeg.fareName`).
	CustomFareNameLabel *LocalizedString `json:"customFareNameLabel,omitempty"`
	// CustomOtherRestrictionsLabel: A custom label to use for the other
	// restrictions value (`transitObject.ticketRestrictions.otherRestrictions`).
	CustomOtherRestrictionsLabel *LocalizedString `json:"customOtherRestrictionsLabel,omitempty"`
	// CustomPlatformLabel: A custom label to use for the boarding platform value
	// (`transitObject.ticketLeg.platform`).
	CustomPlatformLabel *LocalizedString `json:"customPlatformLabel,omitempty"`
	// CustomPurchaseFaceValueLabel: A custom label to use for the purchase face
	// value (`transitObject.purchaseDetails.ticketCost.faceValue`).
	CustomPurchaseFaceValueLabel *LocalizedString `json:"customPurchaseFaceValueLabel,omitempty"`
	// CustomPurchasePriceLabel: A custom label to use for the purchase price value
	// (`transitObject.purchaseDetails.ticketCost.purchasePrice`).
	CustomPurchasePriceLabel *LocalizedString `json:"customPurchasePriceLabel,omitempty"`
	// CustomPurchaseReceiptNumberLabel: A custom label to use for the purchase
	// receipt number value
	// (`transitObject.purchaseDetails.purchaseReceiptNumber`).
	CustomPurchaseReceiptNumberLabel *LocalizedString `json:"customPurchaseReceiptNumberLabel,omitempty"`
	// CustomRouteRestrictionsDetailsLabel: A custom label to use for the route
	// restrictions details value
	// (`transitObject.ticketRestrictions.routeRestrictionsDetails`).
	CustomRouteRestrictionsDetailsLabel *LocalizedString `json:"customRouteRestrictionsDetailsLabel,omitempty"`
	// CustomRouteRestrictionsLabel: A custom label to use for the route
	// restrictions value (`transitObject.ticketRestrictions.routeRestrictions`).
	CustomRouteRestrictionsLabel *LocalizedString `json:"customRouteRestrictionsLabel,omitempty"`
	// CustomSeatLabel: A custom label to use for the seat location value
	// (`transitObject.ticketLeg.ticketSeat.seat`).
	CustomSeatLabel *LocalizedString `json:"customSeatLabel,omitempty"`
	// CustomTicketNumberLabel: A custom label to use for the ticket number value
	// (`transitObject.ticketNumber`).
	CustomTicketNumberLabel *LocalizedString `json:"customTicketNumberLabel,omitempty"`
	// CustomTimeRestrictionsLabel: A custom label to use for the time restrictions
	// details value (`transitObject.ticketRestrictions.timeRestrictions`).
	CustomTimeRestrictionsLabel *LocalizedString `json:"customTimeRestrictionsLabel,omitempty"`
	// CustomTransitTerminusNameLabel: A custom label to use for the transit
	// terminus name value (`transitObject.ticketLeg.transitTerminusName`).
	CustomTransitTerminusNameLabel *LocalizedString `json:"customTransitTerminusNameLabel,omitempty"`
	// CustomZoneLabel: A custom label to use for the boarding zone value
	// (`transitObject.ticketLeg.zone`).
	CustomZoneLabel *LocalizedString `json:"customZoneLabel,omitempty"`
	// EnableSingleLegItinerary: Controls the display of the single-leg itinerary
	// for this class. By default, an itinerary will only display for multi-leg
	// trips.
	EnableSingleLegItinerary bool `json:"enableSingleLegItinerary,omitempty"`
	// EnableSmartTap: Identifies whether this class supports Smart Tap. The
	// `redemptionIssuers` and object level `smartTapRedemptionLevel` fields must
	// also be set up correctly in order for a pass to support Smart Tap.
	EnableSmartTap bool `json:"enableSmartTap,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, nothing will be displayed. The image will display at 100% width.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// HomepageUri: The URI of your application's home page. Populating the URI in
	// this field results in the exact same behavior as populating an URI in
	// linksModuleData (when an object is rendered, a link to the homepage is shown
	// in what would usually be thought of as the linksModuleData section of the
	// object).
	HomepageUri *Uri `json:"homepageUri,omitempty"`
	// Id: Required. The unique identifier for a class. This ID must be unique
	// across all classes from an issuer. This value should follow the format
	// issuer ID. identifier where the former is issued by Google and latter is
	// chosen by you. Your unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// IssuerName: Required. The issuer name. Recommended maximum length is 20
	// characters to ensure full string is displayed on smaller screens.
	IssuerName string `json:"issuerName,omitempty"`
	// LanguageOverride: If this field is present, transit tickets served to a
	// user's device will always be in this language. Represents the BCP 47
	// language tag. Example values are "en-US", "en-GB", "de", or "de-AT".
	LanguageOverride string `json:"languageOverride,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the object, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// LocalizedIssuerName: Translated strings for the issuer_name. Recommended
	// maximum length is 20 characters to ensure full string is displayed on
	// smaller screens.
	LocalizedIssuerName *LocalizedString `json:"localizedIssuerName,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Logo: Required. The logo image of the ticket. This image is displayed in the
	// card detail view of the app.
	Logo *Image `json:"logo,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// MultipleDevicesAndHoldersAllowedStatus: Identifies whether multiple users
	// and devices will save the same object referencing this class.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unspecified preference.
	//   "MULTIPLE_HOLDERS" - The Pass object is shareable by a user and can be
	// saved by any number of different users, and on any number of devices.
	// Partners typically use this setup for passes that do not need to be
	// restricted to a single user or pinned to a single device.
	//   "ONE_USER_ALL_DEVICES" - An object can only be saved by one user, but this
	// user can view and use it on multiple of their devices. Once the first user
	// saves the object, no other user will be allowed to view or save it.
	//   "ONE_USER_ONE_DEVICE" - An object can only be saved by one user on a
	// single device. Intended for use by select partners in limited circumstances.
	// An example use case is a transit ticket that should be "device pinned",
	// meaning it can be saved, viewed and used only by a single user on a single
	// device. Contact support for additional information.
	//   "multipleHolders" - Legacy alias for `MULTIPLE_HOLDERS`. Deprecated.
	//   "oneUserAllDevices" - Legacy alias for `ONE_USER_ALL_DEVICES`. Deprecated.
	//   "oneUserOneDevice" - Legacy alias for `ONE_USER_ONE_DEVICE`. Deprecated.
	MultipleDevicesAndHoldersAllowedStatus string `json:"multipleDevicesAndHoldersAllowedStatus,omitempty"`
	// RedemptionIssuers: Identifies which redemption issuers can redeem the pass
	// over Smart Tap. Redemption issuers are identified by their issuer ID.
	// Redemption issuers must have at least one Smart Tap key configured. The
	// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also
	// be set up correctly in order for a pass to support Smart Tap.
	RedemptionIssuers googleapi.Int64s `json:"redemptionIssuers,omitempty"`
	// Review: The review comments set by the platform when a class is marked
	// `approved` or `rejected`.
	Review *Review `json:"review,omitempty"`
	// ReviewStatus: Required. The status of the class. This field can be set to
	// `draft` or `underReview` using the insert, patch, or update API calls. Once
	// the review state is changed from `draft` it may not be changed back to
	// `draft`. You should keep this field to `draft` when the class is under
	// development. A `draft` class cannot be used to create any object. You should
	// set this field to `underReview` when you believe the class is ready for use.
	// The platform will automatically set this field to `approved` and it can be
	// immediately used to create or migrate objects. When updating an already
	// `approved` class you should keep setting this field to `underReview`.
	//
	// Possible values:
	//   "REVIEW_STATUS_UNSPECIFIED"
	//   "UNDER_REVIEW"
	//   "underReview" - Legacy alias for `UNDER_REVIEW`. Deprecated.
	//   "APPROVED"
	//   "approved" - Legacy alias for `APPROVED`. Deprecated.
	//   "REJECTED"
	//   "rejected" - Legacy alias for `REJECTED`. Deprecated.
	//   "DRAFT"
	//   "draft" - Legacy alias for `DRAFT`. Deprecated.
	ReviewStatus string `json:"reviewStatus,omitempty"`
	// SecurityAnimation: Optional information about the security animation. If
	// this is set a security animation will be rendered on pass details.
	SecurityAnimation *SecurityAnimation `json:"securityAnimation,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// TransitOperatorName: The name of the transit operator.
	TransitOperatorName *LocalizedString `json:"transitOperatorName,omitempty"`
	// TransitType: Required. The type of transit this class represents, such as
	// "bus".
	//
	// Possible values:
	//   "TRANSIT_TYPE_UNSPECIFIED"
	//   "BUS"
	//   "bus" - Legacy alias for `BUS`. Deprecated.
	//   "RAIL"
	//   "rail" - Legacy alias for `RAIL`. Deprecated.
	//   "TRAM"
	//   "tram" - Legacy alias for `TRAM`. Deprecated.
	//   "FERRY"
	//   "ferry" - Legacy alias for `FERRY`. Deprecated.
	//   "OTHER"
	//   "other" - Legacy alias for `OTHER`. Deprecated.
	TransitType string `json:"transitType,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the class. For a pass only ten will be displayed, prioritizing those from
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`
	// ViewUnlockRequirement: View Unlock Requirement options for the transit
	// ticket.
	//
	// Possible values:
	//   "VIEW_UNLOCK_REQUIREMENT_UNSPECIFIED" - Default value, same as
	// UNLOCK_NOT_REQUIRED.
	//   "UNLOCK_NOT_REQUIRED" - Default behavior for all the existing Passes if
	// ViewUnlockRequirement is not set.
	//   "UNLOCK_REQUIRED_TO_VIEW" - Requires the user to unlock their device each
	// time the pass is viewed. If the user removes their device lock after saving
	// the pass, then they will be prompted to create a device lock before the pass
	// can be viewed.
	ViewUnlockRequirement string `json:"viewUnlockRequirement,omitempty"`
	// Watermark: Watermark image to display on the user's device.
	Watermark *Image `json:"watermark,omitempty"`
	// WideLogo: The wide logo of the ticket. When provided, this will be used in
	// place of the logo in the top left of the card view.
	WideLogo *Image `json:"wideLogo,omitempty"`
	// WordMark: Deprecated.
	WordMark *Image `json:"wordMark,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActivationOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitClass) MarshalJSON() ([]byte, error) {
	type NoMethod TransitClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TransitClassAddMessageResponse struct {
	// Resource: The updated TransitClass resource.
	Resource *TransitClass `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitClassAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TransitClassAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TransitClassListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*TransitClass `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitClassListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TransitClassListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TransitObject struct {
	// ActivationStatus: The activation status for the object. Required if the
	// class has `activationOptions` set.
	ActivationStatus *ActivationStatus `json:"activationStatus,omitempty"`
	// AppLinkData: Optional app or website link that will be displayed as a button
	// on the front of the pass. If AppLinkData is provided for the corresponding
	// class only object AppLinkData will be displayed.
	AppLinkData *AppLinkData `json:"appLinkData,omitempty"`
	// Barcode: The barcode type and value.
	Barcode *Barcode `json:"barcode,omitempty"`
	// ClassId: Required. The class associated with this object. The class must be
	// of the same type as this object, must already exist, and must be approved.
	// Class IDs should follow the format issuer ID.identifier where the former is
	// issued by Google and latter is chosen by you.
	ClassId string `json:"classId,omitempty"`
	// ClassReference: A copy of the inherited fields of the parent class. These
	// fields are retrieved during a GET.
	ClassReference *TransitClass `json:"classReference,omitempty"`
	// ConcessionCategory: The concession category for the ticket.
	//
	// Possible values:
	//   "CONCESSION_CATEGORY_UNSPECIFIED"
	//   "ADULT"
	//   "adult" - Legacy alias for `ADULT`. Deprecated.
	//   "CHILD"
	//   "child" - Legacy alias for `CHILD`. Deprecated.
	//   "SENIOR"
	//   "senior" - Legacy alias for `SENIOR`. Deprecated.
	ConcessionCategory string `json:"concessionCategory,omitempty"`
	// CustomConcessionCategory: A custom concession category to use when
	// `concessionCategory` does not provide the right option. Both
	// `concessionCategory` and `customConcessionCategory` may not be set.
	CustomConcessionCategory *LocalizedString `json:"customConcessionCategory,omitempty"`
	// CustomTicketStatus: A custom status to use for the ticket status value when
	// `ticketStatus` does not provide the right option. Both `ticketStatus` and
	// `customTicketStatus` may not be set.
	CustomTicketStatus *LocalizedString `json:"customTicketStatus,omitempty"`
	// DeviceContext: Device context associated with the object.
	DeviceContext *DeviceContext `json:"deviceContext,omitempty"`
	// DisableExpirationNotification: Indicates if notifications should explicitly
	// be suppressed. If this field is set to true, regardless of the `messages`
	// field, expiration notifications to the user will be suppressed. By default,
	// this field is set to false. Currently, this can only be set for offers.
	DisableExpirationNotification bool `json:"disableExpirationNotification,omitempty"`
	// GroupingInfo: Information that controls how passes are grouped together.
	GroupingInfo *GroupingInfo `json:"groupingInfo,omitempty"`
	// HasLinkedDevice: Whether this object is currently linked to a single device.
	// This field is set by the platform when a user saves the object, linking it
	// to their device. Intended for use by select partners. Contact support for
	// additional information.
	HasLinkedDevice bool `json:"hasLinkedDevice,omitempty"`
	// HasUsers: Indicates if the object has users. This field is set by the
	// platform.
	HasUsers bool `json:"hasUsers,omitempty"`
	// HeroImage: Optional banner image displayed on the front of the card. If none
	// is present, hero image of the class, if present, will be displayed. If hero
	// image of the class is also not present, nothing will be displayed.
	HeroImage *Image `json:"heroImage,omitempty"`
	// HexBackgroundColor: The background color for the card. If not set the
	// dominant color of the hero image is used, and if no hero image is set, the
	// dominant color of the logo is used. The format is #rrggbb where rrggbb is a
	// hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version
	// of the RGB triplet which is #rgb, such as `#fc0`.
	HexBackgroundColor string `json:"hexBackgroundColor,omitempty"`
	// Id: Required. The unique identifier for an object. This ID must be unique
	// across all objects from an issuer. This value should follow the format
	// issuer ID.identifier where the former is issued by Google and latter is
	// chosen by you. The unique identifier should only include alphanumeric
	// characters, '.', '_', or '-'.
	Id string `json:"id,omitempty"`
	// ImageModulesData: Image module data. The maximum number of these fields
	// displayed is 1 from object level and 1 for class object level.
	ImageModulesData []*ImageModuleData `json:"imageModulesData,omitempty"`
	// InfoModuleData: Deprecated. Use textModulesData instead.
	InfoModuleData *InfoModuleData `json:"infoModuleData,omitempty"`
	// LinkedObjectIds: linked_object_ids are a list of other objects such as event
	// ticket, loyalty, offer, generic, giftcard, transit and boarding pass that
	// should be automatically attached to this transit object. If a user had saved
	// this transit card, then these linked_object_ids would be automatically
	// pushed to the user's wallet (unless they turned off the setting to receive
	// such linked passes). Make sure that objects present in linked_object_ids are
	// already inserted - if not, calls would fail. Once linked, the linked objects
	// cannot be unlinked. You cannot link objects belonging to another issuer.
	// There is a limit to the number of objects that can be linked to a single
	// object. After the limit is reached, new linked objects in the call will be
	// ignored silently. Object IDs should follow the format issuer ID. identifier
	// where the former is issued by Google and the latter is chosen by you.
	LinkedObjectIds []string `json:"linkedObjectIds,omitempty"`
	// LinksModuleData: Links module data. If links module data is also defined on
	// the class, both will be displayed.
	LinksModuleData *LinksModuleData `json:"linksModuleData,omitempty"`
	// Locations: Note: This field is currently not supported to trigger geo
	// notifications.
	Locations []*LatLongPoint `json:"locations,omitempty"`
	// Messages: An array of messages displayed in the app. All users of this
	// object will receive its associated messages. The maximum number of these
	// fields is 10.
	Messages []*Message `json:"messages,omitempty"`
	// PassConstraints: Pass constraints for the object. Includes limiting NFC and
	// screenshot behaviors.
	PassConstraints *PassConstraints `json:"passConstraints,omitempty"`
	// PassengerNames: The name(s) of the passengers the ticket is assigned to. The
	// above `passengerType` field is meant to give Google context on this field.
	PassengerNames string `json:"passengerNames,omitempty"`
	// PassengerType: The number of passengers.
	//
	// Possible values:
	//   "PASSENGER_TYPE_UNSPECIFIED"
	//   "SINGLE_PASSENGER"
	//   "singlePassenger" - Legacy alias for `SINGLE_PASSENGER`. Deprecated.
	//   "MULTIPLE_PASSENGERS"
	//   "multiplePassengers" - Legacy alias for `MULTIPLE_PASSENGERS`. Deprecated.
	PassengerType string `json:"passengerType,omitempty"`
	// PurchaseDetails: Purchase details for this ticket.
	PurchaseDetails *PurchaseDetails `json:"purchaseDetails,omitempty"`
	// RotatingBarcode: The rotating barcode type and value.
	RotatingBarcode *RotatingBarcode `json:"rotatingBarcode,omitempty"`
	// SaveRestrictions: Restrictions on the object that needs to be verified
	// before the user tries to save the pass. Note that this restrictions will
	// only be applied during save time. If the restrictions changed after a user
	// saves the pass, the new restrictions will not be applied to an already saved
	// pass.
	SaveRestrictions *SaveRestrictions `json:"saveRestrictions,omitempty"`
	// SmartTapRedemptionValue: The value that will be transmitted to a Smart Tap
	// certified terminal over NFC for this object. The class level fields
	// `enableSmartTap` and `redemptionIssuers` must also be set up correctly in
	// order for the pass to support Smart Tap. Only ASCII characters are
	// supported.
	SmartTapRedemptionValue string `json:"smartTapRedemptionValue,omitempty"`
	// State: Required. The state of the object. This field is used to determine
	// how an object is displayed in the app. For example, an `inactive` object is
	// moved to the "Expired passes" section.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "ACTIVE" - Object is active and displayed to with other active objects.
	//   "active" - Legacy alias for `ACTIVE`. Deprecated.
	//   "COMPLETED"
	//   "completed" - Legacy alias for `COMPLETED`. Deprecated.
	//   "EXPIRED" - Object is no longer valid (`validTimeInterval` passed).
	//   "expired" - Legacy alias for `EXPIRED`. Deprecated.
	//   "INACTIVE"
	//   "inactive" - Legacy alias for `INACTIVE`. Deprecated.
	State string `json:"state,omitempty"`
	// TextModulesData: Text module data. If text module data is also defined on
	// the class, both will be displayed. The maximum number of these fields
	// displayed is 10 from the object and 10 from the class.
	TextModulesData []*TextModuleData `json:"textModulesData,omitempty"`
	// TicketLeg: A single ticket leg contains departure and arrival information
	// along with boarding and seating information. If more than one leg is to be
	// specified then use the `ticketLegs` field instead. Both `ticketLeg` and
	// `ticketLegs` may not be set.
	TicketLeg *TicketLeg `json:"ticketLeg,omitempty"`
	// TicketLegs: Each ticket may contain one or more legs. Each leg contains
	// departure and arrival information along with boarding and seating
	// information. If only one leg is to be specified then use the `ticketLeg`
	// field instead. Both `ticketLeg` and `ticketLegs` may not be set.
	TicketLegs []*TicketLeg `json:"ticketLegs,omitempty"`
	// TicketNumber: The number of the ticket. This is a unique identifier for the
	// ticket in the transit operator's system.
	TicketNumber string `json:"ticketNumber,omitempty"`
	// TicketRestrictions: Information about what kind of restrictions there are on
	// using this ticket. For example, which days of the week it must be used, or
	// which routes are allowed to be taken.
	TicketRestrictions *TicketRestrictions `json:"ticketRestrictions,omitempty"`
	// TicketStatus: The status of the ticket. For states which affect display, use
	// the `state` field instead.
	//
	// Possible values:
	//   "TICKET_STATUS_UNSPECIFIED"
	//   "USED"
	//   "used" - Legacy alias for `USED`. Deprecated.
	//   "REFUNDED"
	//   "refunded" - Legacy alias for `REFUNDED`. Deprecated.
	//   "EXCHANGED"
	//   "exchanged" - Legacy alias for `EXCHANGED`. Deprecated.
	TicketStatus string `json:"ticketStatus,omitempty"`
	// TripId: This id is used to group tickets together if the user has saved
	// multiple tickets for the same trip.
	TripId string `json:"tripId,omitempty"`
	// TripType: Required. The type of trip this transit object represents. Used to
	// determine the pass title and/or which symbol to use between the origin and
	// destination.
	//
	// Possible values:
	//   "TRIP_TYPE_UNSPECIFIED"
	//   "ROUND_TRIP"
	//   "roundTrip" - Legacy alias for `ROUND_TRIP`. Deprecated.
	//   "ONE_WAY"
	//   "oneWay" - Legacy alias for `ONE_WAY`. Deprecated.
	TripType string `json:"tripType,omitempty"`
	// ValidTimeInterval: The time period this object will be `active` and object
	// can be used. An object's state will be changed to `expired` when this time
	// period has passed.
	ValidTimeInterval *TimeInterval `json:"validTimeInterval,omitempty"`
	// ValueAddedModuleData: Optional value added module data. Maximum of ten on
	// the object.
	ValueAddedModuleData []*ValueAddedModuleData `json:"valueAddedModuleData,omitempty"`
	// Version: Deprecated
	Version int64 `json:"version,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActivationStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitObject) MarshalJSON() ([]byte, error) {
	type NoMethod TransitObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TransitObjectAddMessageResponse struct {
	// Resource: The updated TransitObject resource.
	Resource *TransitObject `json:"resource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitObjectAddMessageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TransitObjectAddMessageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TransitObjectListResponse struct {
	// Pagination: Pagination of the response.
	Pagination *Pagination `json:"pagination,omitempty"`
	// Resources: Resources corresponding to the list request.
	Resources []*TransitObject `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Pagination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Pagination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitObjectListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TransitObjectListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransitObjectUploadRotatingBarcodeValuesRequest: Request to upload rotating
// barcode values.
type TransitObjectUploadRotatingBarcodeValuesRequest struct {
	// Blob: A reference to the rotating barcode values payload that was uploaded.
	Blob *Media `json:"blob,omitempty"`
	// MediaRequestInfo: Extra information about the uploaded media.
	MediaRequestInfo *MediaRequestInfo `json:"mediaRequestInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blob") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blob") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransitObjectUploadRotatingBarcodeValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TransitObjectUploadRotatingBarcodeValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransitObjectUploadRotatingBarcodeValuesResponse: Response for uploading
// rotating barcode values.
type TransitObjectUploadRotatingBarcodeValuesResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

type TranslatedString struct {
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#translatedString".
	Kind string `json:"kind,omitempty"`
	// Language: Represents the BCP 47 language tag. Example values are "en-US",
	// "en-GB", "de", or "de-AT".
	Language string `json:"language,omitempty"`
	// Value: The UTF-8 encoded translated string.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TranslatedString) MarshalJSON() ([]byte, error) {
	type NoMethod TranslatedString
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpcomingNotification: Indicates that the issuer would like Google Wallet to
// send an upcoming card validity notification 1 day before card becomes
// valid/usable.
type UpcomingNotification struct {
	// EnableNotification: Indicates if the object needs to have upcoming
	// notification enabled.
	EnableNotification bool `json:"enableNotification,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableNotification") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableNotification") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpcomingNotification) MarshalJSON() ([]byte, error) {
	type NoMethod UpcomingNotification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Uri struct {
	// Description: The URI's title appearing in the app as text. Recommended
	// maximum is 20 characters to ensure full string is displayed on smaller
	// screens. Note that in some contexts this text is not used, such as when
	// `description` is part of an image.
	Description string `json:"description,omitempty"`
	// Id: The ID associated with a uri. This field is here to enable ease of
	// management of uris.
	Id string `json:"id,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "walletobjects#uri".
	Kind string `json:"kind,omitempty"`
	// LocalizedDescription: Translated strings for the description. Recommended
	// maximum is 20 characters to ensure full string is displayed on smaller
	// screens.
	LocalizedDescription *LocalizedString `json:"localizedDescription,omitempty"`
	// Uri: The location of a web page, image, or other resource. URIs in the
	// `LinksModuleData` module can have different prefixes indicating the type of
	// URI (a link to a web page, a link to a map, a telephone number, or an email
	// address). URIs must have a scheme.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Uri) MarshalJSON() ([]byte, error) {
	type NoMethod Uri
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValueAddedModuleData: Data for Value Added module. Required fields are
// header and uri.
type ValueAddedModuleData struct {
	// Body: Body to be displayed on the module. Character limit is 50 and longer
	// strings will be truncated.
	Body *LocalizedString `json:"body,omitempty"`
	// Header: Header to be displayed on the module. Character limit is 60 and
	// longer strings will be truncated.
	Header *LocalizedString `json:"header,omitempty"`
	// Image: Image to be displayed on the module. Recommended image ratio is 1:1.
	// Images will be resized to fit this ratio.
	Image *Image `json:"image,omitempty"`
	// SortIndex: The index for sorting the modules. Modules with a lower sort
	// index are shown before modules with a higher sort index. If unspecified, the
	// sort index is assumed to be INT_MAX. For two modules with the same index,
	// the sorting behavior is undefined.
	SortIndex int64 `json:"sortIndex,omitempty"`
	// Uri: URI that the module leads to on click. This can be a web link or a deep
	// link as mentioned in
	// https://developer.android.com/training/app-links/deep-linking.
	Uri string `json:"uri,omitempty"`
	// ViewConstraints: Constraints that all must be met for the module to be
	// shown.
	ViewConstraints *ModuleViewConstraints `json:"viewConstraints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Body") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Body") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValueAddedModuleData) MarshalJSON() ([]byte, error) {
	type NoMethod ValueAddedModuleData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EventticketclassAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the event ticket class referenced by the given
// class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketclassService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *EventticketclassAddmessageCall {
	c := &EventticketclassAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketclassAddmessageCall) Fields(s ...googleapi.Field) *EventticketclassAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketclassAddmessageCall) Context(ctx context.Context) *EventticketclassAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketclassAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketclassAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketClass/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketclass.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketClassAddMessageResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EventticketclassAddmessageCall) Do(opts ...googleapi.CallOption) (*EventTicketClassAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketClassAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketclassGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the event ticket class with the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketclassService) Get(resourceId string) *EventticketclassGetCall {
	c := &EventticketclassGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketclassGetCall) Fields(s ...googleapi.Field) *EventticketclassGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EventticketclassGetCall) IfNoneMatch(entityTag string) *EventticketclassGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketclassGetCall) Context(ctx context.Context) *EventticketclassGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketclassGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketclassGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketclass.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketClass.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketclassGetCall) Do(opts ...googleapi.CallOption) (*EventTicketClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketclassInsertCall struct {
	s                *Service
	eventticketclass *EventTicketClass
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Insert: Inserts an event ticket class with the given ID and properties.
func (r *EventticketclassService) Insert(eventticketclass *EventTicketClass) *EventticketclassInsertCall {
	c := &EventticketclassInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.eventticketclass = eventticketclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketclassInsertCall) Fields(s ...googleapi.Field) *EventticketclassInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketclassInsertCall) Context(ctx context.Context) *EventticketclassInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketclassInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketclassInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventticketclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketclass.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketClass.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketclassInsertCall) Do(opts ...googleapi.CallOption) (*EventTicketClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketclassListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all event ticket classes for a given issuer ID.
func (r *EventticketclassService) List() *EventticketclassListCall {
	c := &EventticketclassListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// IssuerId sets the optional parameter "issuerId": The ID of the issuer
// authorized to list classes.
func (c *EventticketclassListCall) IssuerId(issuerId int64) *EventticketclassListCall {
	c.urlParams_.Set("issuerId", fmt.Sprint(issuerId))
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *EventticketclassListCall) MaxResults(maxResults int64) *EventticketclassListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` classes are
// available in a list. For example, if you have a list of 200 classes and you
// call list with `maxResults` set to 20, list will return the first 20 classes
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 classes.
func (c *EventticketclassListCall) Token(token string) *EventticketclassListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketclassListCall) Fields(s ...googleapi.Field) *EventticketclassListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EventticketclassListCall) IfNoneMatch(entityTag string) *EventticketclassListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketclassListCall) Context(ctx context.Context) *EventticketclassListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketclassListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketclassListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketclass.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketClassListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EventticketclassListCall) Do(opts ...googleapi.CallOption) (*EventTicketClassListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketClassListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketclassPatchCall struct {
	s                *Service
	resourceId       string
	eventticketclass *EventTicketClass
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Patch: Updates the event ticket class referenced by the given class ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketclassService) Patch(resourceId string, eventticketclass *EventTicketClass) *EventticketclassPatchCall {
	c := &EventticketclassPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.eventticketclass = eventticketclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketclassPatchCall) Fields(s ...googleapi.Field) *EventticketclassPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketclassPatchCall) Context(ctx context.Context) *EventticketclassPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketclassPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketclassPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventticketclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketclass.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketClass.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketclassPatchCall) Do(opts ...googleapi.CallOption) (*EventTicketClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketclassUpdateCall struct {
	s                *Service
	resourceId       string
	eventticketclass *EventTicketClass
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Update: Updates the event ticket class referenced by the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketclassService) Update(resourceId string, eventticketclass *EventTicketClass) *EventticketclassUpdateCall {
	c := &EventticketclassUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.eventticketclass = eventticketclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketclassUpdateCall) Fields(s ...googleapi.Field) *EventticketclassUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketclassUpdateCall) Context(ctx context.Context) *EventticketclassUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketclassUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketclassUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventticketclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketclass.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketClass.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketclassUpdateCall) Do(opts ...googleapi.CallOption) (*EventTicketClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketobjectAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the event ticket object referenced by the
// given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketobjectService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *EventticketobjectAddmessageCall {
	c := &EventticketobjectAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketobjectAddmessageCall) Fields(s ...googleapi.Field) *EventticketobjectAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketobjectAddmessageCall) Context(ctx context.Context) *EventticketobjectAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketobjectAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketobjectAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketObject/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketobject.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketObjectAddMessageResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EventticketobjectAddmessageCall) Do(opts ...googleapi.CallOption) (*EventTicketObjectAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketObjectAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketobjectGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the event ticket object with the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketobjectService) Get(resourceId string) *EventticketobjectGetCall {
	c := &EventticketobjectGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketobjectGetCall) Fields(s ...googleapi.Field) *EventticketobjectGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EventticketobjectGetCall) IfNoneMatch(entityTag string) *EventticketobjectGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketobjectGetCall) Context(ctx context.Context) *EventticketobjectGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketobjectGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketobjectGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketobject.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketObject.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketobjectGetCall) Do(opts ...googleapi.CallOption) (*EventTicketObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketobjectInsertCall struct {
	s                 *Service
	eventticketobject *EventTicketObject
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Insert: Inserts an event ticket object with the given ID and properties.
func (r *EventticketobjectService) Insert(eventticketobject *EventTicketObject) *EventticketobjectInsertCall {
	c := &EventticketobjectInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.eventticketobject = eventticketobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketobjectInsertCall) Fields(s ...googleapi.Field) *EventticketobjectInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketobjectInsertCall) Context(ctx context.Context) *EventticketobjectInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketobjectInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketobjectInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventticketobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketobject.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketObject.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketobjectInsertCall) Do(opts ...googleapi.CallOption) (*EventTicketObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketobjectListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all event ticket objects for a given issuer ID.
func (r *EventticketobjectService) List() *EventticketobjectListCall {
	c := &EventticketobjectListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// ClassId sets the optional parameter "classId": The ID of the class whose
// objects will be listed.
func (c *EventticketobjectListCall) ClassId(classId string) *EventticketobjectListCall {
	c.urlParams_.Set("classId", classId)
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *EventticketobjectListCall) MaxResults(maxResults int64) *EventticketobjectListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` objects are
// available in a list. For example, if you have a list of 200 objects and you
// call list with `maxResults` set to 20, list will return the first 20 objects
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 objects.
func (c *EventticketobjectListCall) Token(token string) *EventticketobjectListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketobjectListCall) Fields(s ...googleapi.Field) *EventticketobjectListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EventticketobjectListCall) IfNoneMatch(entityTag string) *EventticketobjectListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketobjectListCall) Context(ctx context.Context) *EventticketobjectListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketobjectListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketobjectListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketobject.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketObjectListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EventticketobjectListCall) Do(opts ...googleapi.CallOption) (*EventTicketObjectListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketObjectListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketobjectModifylinkedofferobjectsCall struct {
	s                               *Service
	resourceId                      string
	modifylinkedofferobjectsrequest *ModifyLinkedOfferObjectsRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Modifylinkedofferobjects: Modifies linked offer objects for the event ticket
// object with the given ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketobjectService) Modifylinkedofferobjects(resourceId string, modifylinkedofferobjectsrequest *ModifyLinkedOfferObjectsRequest) *EventticketobjectModifylinkedofferobjectsCall {
	c := &EventticketobjectModifylinkedofferobjectsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.modifylinkedofferobjectsrequest = modifylinkedofferobjectsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketobjectModifylinkedofferobjectsCall) Fields(s ...googleapi.Field) *EventticketobjectModifylinkedofferobjectsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketobjectModifylinkedofferobjectsCall) Context(ctx context.Context) *EventticketobjectModifylinkedofferobjectsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketobjectModifylinkedofferobjectsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketobjectModifylinkedofferobjectsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.modifylinkedofferobjectsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketObject/{resourceId}/modifyLinkedOfferObjects")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketobject.modifylinkedofferobjects" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketObject.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketobjectModifylinkedofferobjectsCall) Do(opts ...googleapi.CallOption) (*EventTicketObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketobjectPatchCall struct {
	s                 *Service
	resourceId        string
	eventticketobject *EventTicketObject
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Updates the event ticket object referenced by the given object ID.
// This method supports patch semantics.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketobjectService) Patch(resourceId string, eventticketobject *EventTicketObject) *EventticketobjectPatchCall {
	c := &EventticketobjectPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.eventticketobject = eventticketobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketobjectPatchCall) Fields(s ...googleapi.Field) *EventticketobjectPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketobjectPatchCall) Context(ctx context.Context) *EventticketobjectPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketobjectPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketobjectPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventticketobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketobject.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketObject.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketobjectPatchCall) Do(opts ...googleapi.CallOption) (*EventTicketObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type EventticketobjectUpdateCall struct {
	s                 *Service
	resourceId        string
	eventticketobject *EventTicketObject
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Update: Updates the event ticket object referenced by the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *EventticketobjectService) Update(resourceId string, eventticketobject *EventTicketObject) *EventticketobjectUpdateCall {
	c := &EventticketobjectUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.eventticketobject = eventticketobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EventticketobjectUpdateCall) Fields(s ...googleapi.Field) *EventticketobjectUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EventticketobjectUpdateCall) Context(ctx context.Context) *EventticketobjectUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EventticketobjectUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EventticketobjectUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.eventticketobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/eventTicketObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.eventticketobject.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *EventTicketObject.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EventticketobjectUpdateCall) Do(opts ...googleapi.CallOption) (*EventTicketObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EventTicketObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightclassAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the flight class referenced by the given class
// ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *FlightclassService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *FlightclassAddmessageCall {
	c := &FlightclassAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightclassAddmessageCall) Fields(s ...googleapi.Field) *FlightclassAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightclassAddmessageCall) Context(ctx context.Context) *FlightclassAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightclassAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightclassAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightClass/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightclass.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightClassAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FlightclassAddmessageCall) Do(opts ...googleapi.CallOption) (*FlightClassAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightClassAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightclassGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the flight class with the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *FlightclassService) Get(resourceId string) *FlightclassGetCall {
	c := &FlightclassGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightclassGetCall) Fields(s ...googleapi.Field) *FlightclassGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FlightclassGetCall) IfNoneMatch(entityTag string) *FlightclassGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightclassGetCall) Context(ctx context.Context) *FlightclassGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightclassGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightclassGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightclass.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightClass.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FlightclassGetCall) Do(opts ...googleapi.CallOption) (*FlightClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightclassInsertCall struct {
	s           *Service
	flightclass *FlightClass
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Insert: Inserts an flight class with the given ID and properties.
func (r *FlightclassService) Insert(flightclass *FlightClass) *FlightclassInsertCall {
	c := &FlightclassInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.flightclass = flightclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightclassInsertCall) Fields(s ...googleapi.Field) *FlightclassInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightclassInsertCall) Context(ctx context.Context) *FlightclassInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightclassInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightclassInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.flightclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightclass.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightClass.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FlightclassInsertCall) Do(opts ...googleapi.CallOption) (*FlightClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightclassListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all flight classes for a given issuer ID.
func (r *FlightclassService) List() *FlightclassListCall {
	c := &FlightclassListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// IssuerId sets the optional parameter "issuerId": The ID of the issuer
// authorized to list classes.
func (c *FlightclassListCall) IssuerId(issuerId int64) *FlightclassListCall {
	c.urlParams_.Set("issuerId", fmt.Sprint(issuerId))
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *FlightclassListCall) MaxResults(maxResults int64) *FlightclassListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` classes are
// available in a list. For example, if you have a list of 200 classes and you
// call list with `maxResults` set to 20, list will return the first 20 classes
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 classes.
func (c *FlightclassListCall) Token(token string) *FlightclassListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightclassListCall) Fields(s ...googleapi.Field) *FlightclassListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FlightclassListCall) IfNoneMatch(entityTag string) *FlightclassListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightclassListCall) Context(ctx context.Context) *FlightclassListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightclassListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightclassListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightclass.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightClassListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FlightclassListCall) Do(opts ...googleapi.CallOption) (*FlightClassListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightClassListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightclassPatchCall struct {
	s           *Service
	resourceId  string
	flightclass *FlightClass
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates the flight class referenced by the given class ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *FlightclassService) Patch(resourceId string, flightclass *FlightClass) *FlightclassPatchCall {
	c := &FlightclassPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.flightclass = flightclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightclassPatchCall) Fields(s ...googleapi.Field) *FlightclassPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightclassPatchCall) Context(ctx context.Context) *FlightclassPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightclassPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightclassPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.flightclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightclass.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightClass.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FlightclassPatchCall) Do(opts ...googleapi.CallOption) (*FlightClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightclassUpdateCall struct {
	s           *Service
	resourceId  string
	flightclass *FlightClass
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates the flight class referenced by the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *FlightclassService) Update(resourceId string, flightclass *FlightClass) *FlightclassUpdateCall {
	c := &FlightclassUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.flightclass = flightclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightclassUpdateCall) Fields(s ...googleapi.Field) *FlightclassUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightclassUpdateCall) Context(ctx context.Context) *FlightclassUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightclassUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightclassUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.flightclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightclass.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightClass.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FlightclassUpdateCall) Do(opts ...googleapi.CallOption) (*FlightClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightobjectAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the flight object referenced by the given
// object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *FlightobjectService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *FlightobjectAddmessageCall {
	c := &FlightobjectAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightobjectAddmessageCall) Fields(s ...googleapi.Field) *FlightobjectAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightobjectAddmessageCall) Context(ctx context.Context) *FlightobjectAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightobjectAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightobjectAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightObject/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightobject.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightObjectAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FlightobjectAddmessageCall) Do(opts ...googleapi.CallOption) (*FlightObjectAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightObjectAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightobjectGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the flight object with the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *FlightobjectService) Get(resourceId string) *FlightobjectGetCall {
	c := &FlightobjectGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightobjectGetCall) Fields(s ...googleapi.Field) *FlightobjectGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FlightobjectGetCall) IfNoneMatch(entityTag string) *FlightobjectGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightobjectGetCall) Context(ctx context.Context) *FlightobjectGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightobjectGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightobjectGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightobject.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FlightobjectGetCall) Do(opts ...googleapi.CallOption) (*FlightObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightobjectInsertCall struct {
	s            *Service
	flightobject *FlightObject
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Insert: Inserts an flight object with the given ID and properties.
func (r *FlightobjectService) Insert(flightobject *FlightObject) *FlightobjectInsertCall {
	c := &FlightobjectInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.flightobject = flightobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightobjectInsertCall) Fields(s ...googleapi.Field) *FlightobjectInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightobjectInsertCall) Context(ctx context.Context) *FlightobjectInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightobjectInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightobjectInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.flightobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightobject.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FlightobjectInsertCall) Do(opts ...googleapi.CallOption) (*FlightObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightobjectListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all flight objects for a given issuer ID.
func (r *FlightobjectService) List() *FlightobjectListCall {
	c := &FlightobjectListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// ClassId sets the optional parameter "classId": The ID of the class whose
// objects will be listed.
func (c *FlightobjectListCall) ClassId(classId string) *FlightobjectListCall {
	c.urlParams_.Set("classId", classId)
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *FlightobjectListCall) MaxResults(maxResults int64) *FlightobjectListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` objects are
// available in a list. For example, if you have a list of 200 objects and you
// call list with `maxResults` set to 20, list will return the first 20 objects
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 objects.
func (c *FlightobjectListCall) Token(token string) *FlightobjectListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightobjectListCall) Fields(s ...googleapi.Field) *FlightobjectListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FlightobjectListCall) IfNoneMatch(entityTag string) *FlightobjectListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightobjectListCall) Context(ctx context.Context) *FlightobjectListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightobjectListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightobjectListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightobject.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightObjectListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FlightobjectListCall) Do(opts ...googleapi.CallOption) (*FlightObjectListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightObjectListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightobjectPatchCall struct {
	s            *Service
	resourceId   string
	flightobject *FlightObject
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates the flight object referenced by the given object ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *FlightobjectService) Patch(resourceId string, flightobject *FlightObject) *FlightobjectPatchCall {
	c := &FlightobjectPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.flightobject = flightobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightobjectPatchCall) Fields(s ...googleapi.Field) *FlightobjectPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightobjectPatchCall) Context(ctx context.Context) *FlightobjectPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightobjectPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightobjectPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.flightobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightobject.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FlightobjectPatchCall) Do(opts ...googleapi.CallOption) (*FlightObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type FlightobjectUpdateCall struct {
	s            *Service
	resourceId   string
	flightobject *FlightObject
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Update: Updates the flight object referenced by the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *FlightobjectService) Update(resourceId string, flightobject *FlightObject) *FlightobjectUpdateCall {
	c := &FlightobjectUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.flightobject = flightobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightobjectUpdateCall) Fields(s ...googleapi.Field) *FlightobjectUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightobjectUpdateCall) Context(ctx context.Context) *FlightobjectUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightobjectUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightobjectUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.flightobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/flightObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.flightobject.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlightObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FlightobjectUpdateCall) Do(opts ...googleapi.CallOption) (*FlightObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlightObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericclassAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the generic class referenced by the given
// class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GenericclassService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *GenericclassAddmessageCall {
	c := &GenericclassAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericclassAddmessageCall) Fields(s ...googleapi.Field) *GenericclassAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericclassAddmessageCall) Context(ctx context.Context) *GenericclassAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericclassAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericclassAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericClass/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericclass.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericClassAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GenericclassAddmessageCall) Do(opts ...googleapi.CallOption) (*GenericClassAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericClassAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericclassGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the generic class with the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value needs to follow the format
//     `issuerID.identifier` where `issuerID` is issued by Google and
//     `identifier` is chosen by you. The unique identifier can only include
//     alphanumeric characters, `.`, `_`, or `-`.
func (r *GenericclassService) Get(resourceId string) *GenericclassGetCall {
	c := &GenericclassGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericclassGetCall) Fields(s ...googleapi.Field) *GenericclassGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GenericclassGetCall) IfNoneMatch(entityTag string) *GenericclassGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericclassGetCall) Context(ctx context.Context) *GenericclassGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericclassGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericclassGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericclass.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GenericclassGetCall) Do(opts ...googleapi.CallOption) (*GenericClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericclassInsertCall struct {
	s            *Service
	genericclass *GenericClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Insert: Inserts a generic class with the given ID and properties.
func (r *GenericclassService) Insert(genericclass *GenericClass) *GenericclassInsertCall {
	c := &GenericclassInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.genericclass = genericclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericclassInsertCall) Fields(s ...googleapi.Field) *GenericclassInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericclassInsertCall) Context(ctx context.Context) *GenericclassInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericclassInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericclassInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.genericclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericclass.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GenericclassInsertCall) Do(opts ...googleapi.CallOption) (*GenericClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericclassListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all generic classes for a given issuer ID.
func (r *GenericclassService) List() *GenericclassListCall {
	c := &GenericclassListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// IssuerId sets the optional parameter "issuerId": The ID of the issuer
// authorized to list classes.
func (c *GenericclassListCall) IssuerId(issuerId int64) *GenericclassListCall {
	c.urlParams_.Set("issuerId", fmt.Sprint(issuerId))
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *GenericclassListCall) MaxResults(maxResults int64) *GenericclassListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` classes are
// available in a list. For example, if you have a list of 200 classes and you
// call list with `maxResults` set to 20, list will return the first 20 classes
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 classes.
func (c *GenericclassListCall) Token(token string) *GenericclassListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericclassListCall) Fields(s ...googleapi.Field) *GenericclassListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GenericclassListCall) IfNoneMatch(entityTag string) *GenericclassListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericclassListCall) Context(ctx context.Context) *GenericclassListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericclassListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericclassListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericclass.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericClassListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GenericclassListCall) Do(opts ...googleapi.CallOption) (*GenericClassListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericClassListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericclassPatchCall struct {
	s            *Service
	resourceId   string
	genericclass *GenericClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates the generic class referenced by the given class ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value needs to follow the format
//     `issuerID.identifier` where `issuerID` is issued by Google and
//     `identifier` is chosen by you. The unique identifier can only include
//     alphanumeric characters, `.`, `_`, or `-`.
func (r *GenericclassService) Patch(resourceId string, genericclass *GenericClass) *GenericclassPatchCall {
	c := &GenericclassPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.genericclass = genericclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericclassPatchCall) Fields(s ...googleapi.Field) *GenericclassPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericclassPatchCall) Context(ctx context.Context) *GenericclassPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericclassPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericclassPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.genericclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericclass.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GenericclassPatchCall) Do(opts ...googleapi.CallOption) (*GenericClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericclassUpdateCall struct {
	s            *Service
	resourceId   string
	genericclass *GenericClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Update: Updates the Generic class referenced by the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value needs to follow the format
//     `issuerID.identifier` where `issuerID` is issued by Google and
//     `identifier` is chosen by you. The unique identifier can only include
//     alphanumeric characters, `.`, `_`, or `-`.
func (r *GenericclassService) Update(resourceId string, genericclass *GenericClass) *GenericclassUpdateCall {
	c := &GenericclassUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.genericclass = genericclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericclassUpdateCall) Fields(s ...googleapi.Field) *GenericclassUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericclassUpdateCall) Context(ctx context.Context) *GenericclassUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericclassUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericclassUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.genericclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericclass.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GenericclassUpdateCall) Do(opts ...googleapi.CallOption) (*GenericClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericobjectAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the generic object referenced by the given
// object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GenericobjectService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *GenericobjectAddmessageCall {
	c := &GenericobjectAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericobjectAddmessageCall) Fields(s ...googleapi.Field) *GenericobjectAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericobjectAddmessageCall) Context(ctx context.Context) *GenericobjectAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericobjectAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericobjectAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericObject/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericobject.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericObjectAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GenericobjectAddmessageCall) Do(opts ...googleapi.CallOption) (*GenericObjectAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericObjectAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericobjectGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the generic object with the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value needs to follow the format
//     `issuerID.identifier` where `issuerID` is issued by Google and
//     `identifier` is chosen by you. The unique identifier can only include
//     alphanumeric characters, `.`, `_`, or `-`.
func (r *GenericobjectService) Get(resourceId string) *GenericobjectGetCall {
	c := &GenericobjectGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericobjectGetCall) Fields(s ...googleapi.Field) *GenericobjectGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GenericobjectGetCall) IfNoneMatch(entityTag string) *GenericobjectGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericobjectGetCall) Context(ctx context.Context) *GenericobjectGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericobjectGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericobjectGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericobject.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GenericobjectGetCall) Do(opts ...googleapi.CallOption) (*GenericObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericobjectInsertCall struct {
	s             *Service
	genericobject *GenericObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Insert: Inserts a generic object with the given ID and properties.
func (r *GenericobjectService) Insert(genericobject *GenericObject) *GenericobjectInsertCall {
	c := &GenericobjectInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.genericobject = genericobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericobjectInsertCall) Fields(s ...googleapi.Field) *GenericobjectInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericobjectInsertCall) Context(ctx context.Context) *GenericobjectInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericobjectInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericobjectInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.genericobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericobject.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GenericobjectInsertCall) Do(opts ...googleapi.CallOption) (*GenericObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericobjectListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all generic objects for a given issuer ID.
func (r *GenericobjectService) List() *GenericobjectListCall {
	c := &GenericobjectListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// ClassId sets the optional parameter "classId": The ID of the class whose
// objects will be listed.
func (c *GenericobjectListCall) ClassId(classId string) *GenericobjectListCall {
	c.urlParams_.Set("classId", classId)
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *GenericobjectListCall) MaxResults(maxResults int64) *GenericobjectListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` objects are
// available in a list. For example, if you have a list of 200 objects and you
// call list with `maxResults` set to 20, list will return the first 20 objects
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 objects.
func (c *GenericobjectListCall) Token(token string) *GenericobjectListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericobjectListCall) Fields(s ...googleapi.Field) *GenericobjectListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GenericobjectListCall) IfNoneMatch(entityTag string) *GenericobjectListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericobjectListCall) Context(ctx context.Context) *GenericobjectListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericobjectListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericobjectListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericobject.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericObjectListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GenericobjectListCall) Do(opts ...googleapi.CallOption) (*GenericObjectListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericObjectListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericobjectPatchCall struct {
	s             *Service
	resourceId    string
	genericobject *GenericObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates the generic object referenced by the given object ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value needs to follow the format
//     `issuerID.identifier` where `issuerID` is issued by Google and
//     `identifier` is chosen by you. The unique identifier can only include
//     alphanumeric characters, `.`, `_`, or `-`.
func (r *GenericobjectService) Patch(resourceId string, genericobject *GenericObject) *GenericobjectPatchCall {
	c := &GenericobjectPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.genericobject = genericobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericobjectPatchCall) Fields(s ...googleapi.Field) *GenericobjectPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericobjectPatchCall) Context(ctx context.Context) *GenericobjectPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericobjectPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericobjectPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.genericobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericobject.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GenericobjectPatchCall) Do(opts ...googleapi.CallOption) (*GenericObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GenericobjectUpdateCall struct {
	s             *Service
	resourceId    string
	genericobject *GenericObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Update: Updates the generic object referenced by the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value needs to follow the format
//     `issuerID.identifier` where `issuerID` is issued by Google and
//     `identifier` is chosen by you. The unique identifier can only include
//     alphanumeric characters, `.`, `_`, or `-`.
func (r *GenericobjectService) Update(resourceId string, genericobject *GenericObject) *GenericobjectUpdateCall {
	c := &GenericobjectUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.genericobject = genericobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GenericobjectUpdateCall) Fields(s ...googleapi.Field) *GenericobjectUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GenericobjectUpdateCall) Context(ctx context.Context) *GenericobjectUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GenericobjectUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GenericobjectUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.genericobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/genericObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.genericobject.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenericObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GenericobjectUpdateCall) Do(opts ...googleapi.CallOption) (*GenericObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenericObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardclassAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the gift card class referenced by the given
// class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GiftcardclassService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *GiftcardclassAddmessageCall {
	c := &GiftcardclassAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardclassAddmessageCall) Fields(s ...googleapi.Field) *GiftcardclassAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardclassAddmessageCall) Context(ctx context.Context) *GiftcardclassAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardclassAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardclassAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardClass/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardclass.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardClassAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GiftcardclassAddmessageCall) Do(opts ...googleapi.CallOption) (*GiftCardClassAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardClassAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardclassGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the gift card class with the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GiftcardclassService) Get(resourceId string) *GiftcardclassGetCall {
	c := &GiftcardclassGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardclassGetCall) Fields(s ...googleapi.Field) *GiftcardclassGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GiftcardclassGetCall) IfNoneMatch(entityTag string) *GiftcardclassGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardclassGetCall) Context(ctx context.Context) *GiftcardclassGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardclassGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardclassGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardclass.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GiftcardclassGetCall) Do(opts ...googleapi.CallOption) (*GiftCardClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardclassInsertCall struct {
	s             *Service
	giftcardclass *GiftCardClass
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Insert: Inserts an gift card class with the given ID and properties.
func (r *GiftcardclassService) Insert(giftcardclass *GiftCardClass) *GiftcardclassInsertCall {
	c := &GiftcardclassInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.giftcardclass = giftcardclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardclassInsertCall) Fields(s ...googleapi.Field) *GiftcardclassInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardclassInsertCall) Context(ctx context.Context) *GiftcardclassInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardclassInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardclassInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.giftcardclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardclass.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GiftcardclassInsertCall) Do(opts ...googleapi.CallOption) (*GiftCardClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardclassListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all gift card classes for a given issuer ID.
func (r *GiftcardclassService) List() *GiftcardclassListCall {
	c := &GiftcardclassListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// IssuerId sets the optional parameter "issuerId": The ID of the issuer
// authorized to list classes.
func (c *GiftcardclassListCall) IssuerId(issuerId int64) *GiftcardclassListCall {
	c.urlParams_.Set("issuerId", fmt.Sprint(issuerId))
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *GiftcardclassListCall) MaxResults(maxResults int64) *GiftcardclassListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` classes are
// available in a list. For example, if you have a list of 200 classes and you
// call list with `maxResults` set to 20, list will return the first 20 classes
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 classes.
func (c *GiftcardclassListCall) Token(token string) *GiftcardclassListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardclassListCall) Fields(s ...googleapi.Field) *GiftcardclassListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GiftcardclassListCall) IfNoneMatch(entityTag string) *GiftcardclassListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardclassListCall) Context(ctx context.Context) *GiftcardclassListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardclassListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardclassListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardclass.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardClassListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GiftcardclassListCall) Do(opts ...googleapi.CallOption) (*GiftCardClassListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardClassListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardclassPatchCall struct {
	s             *Service
	resourceId    string
	giftcardclass *GiftCardClass
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates the gift card class referenced by the given class ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GiftcardclassService) Patch(resourceId string, giftcardclass *GiftCardClass) *GiftcardclassPatchCall {
	c := &GiftcardclassPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.giftcardclass = giftcardclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardclassPatchCall) Fields(s ...googleapi.Field) *GiftcardclassPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardclassPatchCall) Context(ctx context.Context) *GiftcardclassPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardclassPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardclassPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.giftcardclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardclass.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GiftcardclassPatchCall) Do(opts ...googleapi.CallOption) (*GiftCardClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardclassUpdateCall struct {
	s             *Service
	resourceId    string
	giftcardclass *GiftCardClass
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Update: Updates the gift card class referenced by the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GiftcardclassService) Update(resourceId string, giftcardclass *GiftCardClass) *GiftcardclassUpdateCall {
	c := &GiftcardclassUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.giftcardclass = giftcardclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardclassUpdateCall) Fields(s ...googleapi.Field) *GiftcardclassUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardclassUpdateCall) Context(ctx context.Context) *GiftcardclassUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardclassUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardclassUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.giftcardclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardclass.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GiftcardclassUpdateCall) Do(opts ...googleapi.CallOption) (*GiftCardClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardobjectAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the gift card object referenced by the given
// object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GiftcardobjectService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *GiftcardobjectAddmessageCall {
	c := &GiftcardobjectAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardobjectAddmessageCall) Fields(s ...googleapi.Field) *GiftcardobjectAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardobjectAddmessageCall) Context(ctx context.Context) *GiftcardobjectAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardobjectAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardobjectAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardObject/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardobject.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardObjectAddMessageResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GiftcardobjectAddmessageCall) Do(opts ...googleapi.CallOption) (*GiftCardObjectAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardObjectAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardobjectGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the gift card object with the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GiftcardobjectService) Get(resourceId string) *GiftcardobjectGetCall {
	c := &GiftcardobjectGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardobjectGetCall) Fields(s ...googleapi.Field) *GiftcardobjectGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GiftcardobjectGetCall) IfNoneMatch(entityTag string) *GiftcardobjectGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardobjectGetCall) Context(ctx context.Context) *GiftcardobjectGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardobjectGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardobjectGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardobject.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GiftcardobjectGetCall) Do(opts ...googleapi.CallOption) (*GiftCardObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardobjectInsertCall struct {
	s              *Service
	giftcardobject *GiftCardObject
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Insert: Inserts an gift card object with the given ID and properties.
func (r *GiftcardobjectService) Insert(giftcardobject *GiftCardObject) *GiftcardobjectInsertCall {
	c := &GiftcardobjectInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.giftcardobject = giftcardobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardobjectInsertCall) Fields(s ...googleapi.Field) *GiftcardobjectInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardobjectInsertCall) Context(ctx context.Context) *GiftcardobjectInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardobjectInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardobjectInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.giftcardobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardobject.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GiftcardobjectInsertCall) Do(opts ...googleapi.CallOption) (*GiftCardObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardobjectListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all gift card objects for a given issuer ID.
func (r *GiftcardobjectService) List() *GiftcardobjectListCall {
	c := &GiftcardobjectListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// ClassId sets the optional parameter "classId": The ID of the class whose
// objects will be listed.
func (c *GiftcardobjectListCall) ClassId(classId string) *GiftcardobjectListCall {
	c.urlParams_.Set("classId", classId)
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *GiftcardobjectListCall) MaxResults(maxResults int64) *GiftcardobjectListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` objects are
// available in a list. For example, if you have a list of 200 objects and you
// call list with `maxResults` set to 20, list will return the first 20 objects
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 objects.
func (c *GiftcardobjectListCall) Token(token string) *GiftcardobjectListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardobjectListCall) Fields(s ...googleapi.Field) *GiftcardobjectListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GiftcardobjectListCall) IfNoneMatch(entityTag string) *GiftcardobjectListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardobjectListCall) Context(ctx context.Context) *GiftcardobjectListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardobjectListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardobjectListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardobject.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardObjectListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GiftcardobjectListCall) Do(opts ...googleapi.CallOption) (*GiftCardObjectListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardObjectListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardobjectPatchCall struct {
	s              *Service
	resourceId     string
	giftcardobject *GiftCardObject
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Updates the gift card object referenced by the given object ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GiftcardobjectService) Patch(resourceId string, giftcardobject *GiftCardObject) *GiftcardobjectPatchCall {
	c := &GiftcardobjectPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.giftcardobject = giftcardobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardobjectPatchCall) Fields(s ...googleapi.Field) *GiftcardobjectPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardobjectPatchCall) Context(ctx context.Context) *GiftcardobjectPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardobjectPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardobjectPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.giftcardobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardobject.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GiftcardobjectPatchCall) Do(opts ...googleapi.CallOption) (*GiftCardObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GiftcardobjectUpdateCall struct {
	s              *Service
	resourceId     string
	giftcardobject *GiftCardObject
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Update: Updates the gift card object referenced by the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *GiftcardobjectService) Update(resourceId string, giftcardobject *GiftCardObject) *GiftcardobjectUpdateCall {
	c := &GiftcardobjectUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.giftcardobject = giftcardobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GiftcardobjectUpdateCall) Fields(s ...googleapi.Field) *GiftcardobjectUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GiftcardobjectUpdateCall) Context(ctx context.Context) *GiftcardobjectUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GiftcardobjectUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GiftcardobjectUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.giftcardobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/giftCardObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.giftcardobject.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *GiftCardObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GiftcardobjectUpdateCall) Do(opts ...googleapi.CallOption) (*GiftCardObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GiftCardObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type IssuerGetCall struct {
	s            *Service
	resourceId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the issuer with the given issuer ID.
//
// - resourceId: The unique identifier for an issuer.
func (r *IssuerService) Get(resourceId int64) *IssuerGetCall {
	c := &IssuerGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IssuerGetCall) Fields(s ...googleapi.Field) *IssuerGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *IssuerGetCall) IfNoneMatch(entityTag string) *IssuerGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IssuerGetCall) Context(ctx context.Context) *IssuerGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IssuerGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IssuerGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/issuer/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": strconv.FormatInt(c.resourceId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.issuer.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Issuer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *IssuerGetCall) Do(opts ...googleapi.CallOption) (*Issuer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Issuer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type IssuerInsertCall struct {
	s          *Service
	issuer     *Issuer
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Inserts an issuer with the given ID and properties.
func (r *IssuerService) Insert(issuer *Issuer) *IssuerInsertCall {
	c := &IssuerInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.issuer = issuer
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IssuerInsertCall) Fields(s ...googleapi.Field) *IssuerInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IssuerInsertCall) Context(ctx context.Context) *IssuerInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IssuerInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IssuerInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.issuer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/issuer")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.issuer.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Issuer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *IssuerInsertCall) Do(opts ...googleapi.CallOption) (*Issuer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Issuer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type IssuerListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all issuers shared to the caller.
func (r *IssuerService) List() *IssuerListCall {
	c := &IssuerListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IssuerListCall) Fields(s ...googleapi.Field) *IssuerListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *IssuerListCall) IfNoneMatch(entityTag string) *IssuerListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IssuerListCall) Context(ctx context.Context) *IssuerListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IssuerListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IssuerListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/issuer")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.issuer.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *IssuerListResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *IssuerListCall) Do(opts ...googleapi.CallOption) (*IssuerListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IssuerListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type IssuerPatchCall struct {
	s          *Service
	resourceId int64
	issuer     *Issuer
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the issuer referenced by the given issuer ID. This method
// supports patch semantics.
//
// - resourceId: The unique identifier for an issuer.
func (r *IssuerService) Patch(resourceId int64, issuer *Issuer) *IssuerPatchCall {
	c := &IssuerPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.issuer = issuer
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IssuerPatchCall) Fields(s ...googleapi.Field) *IssuerPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IssuerPatchCall) Context(ctx context.Context) *IssuerPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IssuerPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IssuerPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.issuer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/issuer/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": strconv.FormatInt(c.resourceId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.issuer.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Issuer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *IssuerPatchCall) Do(opts ...googleapi.CallOption) (*Issuer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Issuer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type IssuerUpdateCall struct {
	s          *Service
	resourceId int64
	issuer     *Issuer
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the issuer referenced by the given issuer ID.
//
// - resourceId: The unique identifier for an issuer.
func (r *IssuerService) Update(resourceId int64, issuer *Issuer) *IssuerUpdateCall {
	c := &IssuerUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.issuer = issuer
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IssuerUpdateCall) Fields(s ...googleapi.Field) *IssuerUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IssuerUpdateCall) Context(ctx context.Context) *IssuerUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IssuerUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IssuerUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.issuer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/issuer/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": strconv.FormatInt(c.resourceId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.issuer.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Issuer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *IssuerUpdateCall) Do(opts ...googleapi.CallOption) (*Issuer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Issuer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type JwtInsertCall struct {
	s           *Service
	jwtresource *JwtResource
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Insert: Inserts the resources in the JWT.
func (r *JwtService) Insert(jwtresource *JwtResource) *JwtInsertCall {
	c := &JwtInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.jwtresource = jwtresource
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JwtInsertCall) Fields(s ...googleapi.Field) *JwtInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *JwtInsertCall) Context(ctx context.Context) *JwtInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JwtInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JwtInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.jwtresource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/jwt")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.jwt.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *JwtInsertResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *JwtInsertCall) Do(opts ...googleapi.CallOption) (*JwtInsertResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &JwtInsertResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyclassAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the loyalty class referenced by the given
// class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyclassService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *LoyaltyclassAddmessageCall {
	c := &LoyaltyclassAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyclassAddmessageCall) Fields(s ...googleapi.Field) *LoyaltyclassAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyclassAddmessageCall) Context(ctx context.Context) *LoyaltyclassAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyclassAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyclassAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyClass/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyclass.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyClassAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LoyaltyclassAddmessageCall) Do(opts ...googleapi.CallOption) (*LoyaltyClassAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyClassAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyclassGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the loyalty class with the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyclassService) Get(resourceId string) *LoyaltyclassGetCall {
	c := &LoyaltyclassGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyclassGetCall) Fields(s ...googleapi.Field) *LoyaltyclassGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LoyaltyclassGetCall) IfNoneMatch(entityTag string) *LoyaltyclassGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyclassGetCall) Context(ctx context.Context) *LoyaltyclassGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyclassGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyclassGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyclass.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyclassGetCall) Do(opts ...googleapi.CallOption) (*LoyaltyClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyclassInsertCall struct {
	s            *Service
	loyaltyclass *LoyaltyClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Insert: Inserts an loyalty class with the given ID and properties.
func (r *LoyaltyclassService) Insert(loyaltyclass *LoyaltyClass) *LoyaltyclassInsertCall {
	c := &LoyaltyclassInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.loyaltyclass = loyaltyclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyclassInsertCall) Fields(s ...googleapi.Field) *LoyaltyclassInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyclassInsertCall) Context(ctx context.Context) *LoyaltyclassInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyclassInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyclassInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loyaltyclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyclass.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyclassInsertCall) Do(opts ...googleapi.CallOption) (*LoyaltyClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyclassListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all loyalty classes for a given issuer ID.
func (r *LoyaltyclassService) List() *LoyaltyclassListCall {
	c := &LoyaltyclassListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// IssuerId sets the optional parameter "issuerId": The ID of the issuer
// authorized to list classes.
func (c *LoyaltyclassListCall) IssuerId(issuerId int64) *LoyaltyclassListCall {
	c.urlParams_.Set("issuerId", fmt.Sprint(issuerId))
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *LoyaltyclassListCall) MaxResults(maxResults int64) *LoyaltyclassListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` classes are
// available in a list. For example, if you have a list of 200 classes and you
// call list with `maxResults` set to 20, list will return the first 20 classes
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 classes.
func (c *LoyaltyclassListCall) Token(token string) *LoyaltyclassListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyclassListCall) Fields(s ...googleapi.Field) *LoyaltyclassListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LoyaltyclassListCall) IfNoneMatch(entityTag string) *LoyaltyclassListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyclassListCall) Context(ctx context.Context) *LoyaltyclassListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyclassListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyclassListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyclass.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyClassListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LoyaltyclassListCall) Do(opts ...googleapi.CallOption) (*LoyaltyClassListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyClassListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyclassPatchCall struct {
	s            *Service
	resourceId   string
	loyaltyclass *LoyaltyClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates the loyalty class referenced by the given class ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyclassService) Patch(resourceId string, loyaltyclass *LoyaltyClass) *LoyaltyclassPatchCall {
	c := &LoyaltyclassPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.loyaltyclass = loyaltyclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyclassPatchCall) Fields(s ...googleapi.Field) *LoyaltyclassPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyclassPatchCall) Context(ctx context.Context) *LoyaltyclassPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyclassPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyclassPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loyaltyclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyclass.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyclassPatchCall) Do(opts ...googleapi.CallOption) (*LoyaltyClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyclassUpdateCall struct {
	s            *Service
	resourceId   string
	loyaltyclass *LoyaltyClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Update: Updates the loyalty class referenced by the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyclassService) Update(resourceId string, loyaltyclass *LoyaltyClass) *LoyaltyclassUpdateCall {
	c := &LoyaltyclassUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.loyaltyclass = loyaltyclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyclassUpdateCall) Fields(s ...googleapi.Field) *LoyaltyclassUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyclassUpdateCall) Context(ctx context.Context) *LoyaltyclassUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyclassUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyclassUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loyaltyclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyclass.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyclassUpdateCall) Do(opts ...googleapi.CallOption) (*LoyaltyClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyobjectAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the loyalty object referenced by the given
// object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyobjectService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *LoyaltyobjectAddmessageCall {
	c := &LoyaltyobjectAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyobjectAddmessageCall) Fields(s ...googleapi.Field) *LoyaltyobjectAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyobjectAddmessageCall) Context(ctx context.Context) *LoyaltyobjectAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyobjectAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyobjectAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyObject/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyobject.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyObjectAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LoyaltyobjectAddmessageCall) Do(opts ...googleapi.CallOption) (*LoyaltyObjectAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyObjectAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyobjectGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the loyalty object with the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyobjectService) Get(resourceId string) *LoyaltyobjectGetCall {
	c := &LoyaltyobjectGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyobjectGetCall) Fields(s ...googleapi.Field) *LoyaltyobjectGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LoyaltyobjectGetCall) IfNoneMatch(entityTag string) *LoyaltyobjectGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyobjectGetCall) Context(ctx context.Context) *LoyaltyobjectGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyobjectGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyobjectGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyobject.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyobjectGetCall) Do(opts ...googleapi.CallOption) (*LoyaltyObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyobjectInsertCall struct {
	s             *Service
	loyaltyobject *LoyaltyObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Insert: Inserts an loyalty object with the given ID and properties.
func (r *LoyaltyobjectService) Insert(loyaltyobject *LoyaltyObject) *LoyaltyobjectInsertCall {
	c := &LoyaltyobjectInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.loyaltyobject = loyaltyobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyobjectInsertCall) Fields(s ...googleapi.Field) *LoyaltyobjectInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyobjectInsertCall) Context(ctx context.Context) *LoyaltyobjectInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyobjectInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyobjectInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loyaltyobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyobject.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyobjectInsertCall) Do(opts ...googleapi.CallOption) (*LoyaltyObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyobjectListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all loyalty objects for a given issuer ID.
func (r *LoyaltyobjectService) List() *LoyaltyobjectListCall {
	c := &LoyaltyobjectListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// ClassId sets the optional parameter "classId": The ID of the class whose
// objects will be listed.
func (c *LoyaltyobjectListCall) ClassId(classId string) *LoyaltyobjectListCall {
	c.urlParams_.Set("classId", classId)
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *LoyaltyobjectListCall) MaxResults(maxResults int64) *LoyaltyobjectListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` objects are
// available in a list. For example, if you have a list of 200 objects and you
// call list with `maxResults` set to 20, list will return the first 20 objects
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 objects.
func (c *LoyaltyobjectListCall) Token(token string) *LoyaltyobjectListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyobjectListCall) Fields(s ...googleapi.Field) *LoyaltyobjectListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LoyaltyobjectListCall) IfNoneMatch(entityTag string) *LoyaltyobjectListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyobjectListCall) Context(ctx context.Context) *LoyaltyobjectListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyobjectListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyobjectListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyobject.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyObjectListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LoyaltyobjectListCall) Do(opts ...googleapi.CallOption) (*LoyaltyObjectListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyObjectListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyobjectModifylinkedofferobjectsCall struct {
	s                               *Service
	resourceId                      string
	modifylinkedofferobjectsrequest *ModifyLinkedOfferObjectsRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Modifylinkedofferobjects: Modifies linked offer objects for the loyalty
// object with the given ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyobjectService) Modifylinkedofferobjects(resourceId string, modifylinkedofferobjectsrequest *ModifyLinkedOfferObjectsRequest) *LoyaltyobjectModifylinkedofferobjectsCall {
	c := &LoyaltyobjectModifylinkedofferobjectsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.modifylinkedofferobjectsrequest = modifylinkedofferobjectsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyobjectModifylinkedofferobjectsCall) Fields(s ...googleapi.Field) *LoyaltyobjectModifylinkedofferobjectsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyobjectModifylinkedofferobjectsCall) Context(ctx context.Context) *LoyaltyobjectModifylinkedofferobjectsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyobjectModifylinkedofferobjectsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyobjectModifylinkedofferobjectsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.modifylinkedofferobjectsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyObject/{resourceId}/modifyLinkedOfferObjects")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyobject.modifylinkedofferobjects" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyobjectModifylinkedofferobjectsCall) Do(opts ...googleapi.CallOption) (*LoyaltyObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyobjectPatchCall struct {
	s             *Service
	resourceId    string
	loyaltyobject *LoyaltyObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates the loyalty object referenced by the given object ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyobjectService) Patch(resourceId string, loyaltyobject *LoyaltyObject) *LoyaltyobjectPatchCall {
	c := &LoyaltyobjectPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.loyaltyobject = loyaltyobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyobjectPatchCall) Fields(s ...googleapi.Field) *LoyaltyobjectPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyobjectPatchCall) Context(ctx context.Context) *LoyaltyobjectPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyobjectPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyobjectPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loyaltyobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyobject.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyobjectPatchCall) Do(opts ...googleapi.CallOption) (*LoyaltyObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type LoyaltyobjectUpdateCall struct {
	s             *Service
	resourceId    string
	loyaltyobject *LoyaltyObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Update: Updates the loyalty object referenced by the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *LoyaltyobjectService) Update(resourceId string, loyaltyobject *LoyaltyObject) *LoyaltyobjectUpdateCall {
	c := &LoyaltyobjectUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.loyaltyobject = loyaltyobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LoyaltyobjectUpdateCall) Fields(s ...googleapi.Field) *LoyaltyobjectUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LoyaltyobjectUpdateCall) Context(ctx context.Context) *LoyaltyobjectUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LoyaltyobjectUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LoyaltyobjectUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.loyaltyobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/loyaltyObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.loyaltyobject.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *LoyaltyObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LoyaltyobjectUpdateCall) Do(opts ...googleapi.CallOption) (*LoyaltyObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LoyaltyObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MediaDownloadCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Download: Downloads rotating barcode values for the transit object
// referenced by the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *MediaService) Download(resourceId string) *MediaDownloadCall {
	c := &MediaDownloadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MediaDownloadCall) Fields(s ...googleapi.Field) *MediaDownloadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *MediaDownloadCall) IfNoneMatch(entityTag string) *MediaDownloadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do and Download methods.
func (c *MediaDownloadCall) Context(ctx context.Context) *MediaDownloadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MediaDownloadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaDownloadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitObject/{resourceId}/downloadRotatingBarcodeValues")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Download fetches the API endpoint's "media" value, instead of the normal
// API response value. If the returned error is nil, the Response is guaranteed to
// have a 2xx status code. Callers must close the Response.Body as usual.
func (c *MediaDownloadCall) Download(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("media")
	if err != nil {
		return nil, err
	}
	if err := googleapi.CheckResponse(res); err != nil {
		res.Body.Close()
		return nil, gensupport.WrapError(err)
	}
	return res, nil
}

// Do executes the "walletobjects.media.download" call.
// Any non-2xx status code is an error. Response headers are in either
// *Media.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *MediaDownloadCall) Do(opts ...googleapi.CallOption) (*Media, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Media{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MediaUploadCall struct {
	s                                               *Service
	resourceId                                      string
	transitobjectuploadrotatingbarcodevaluesrequest *TransitObjectUploadRotatingBarcodeValuesRequest
	urlParams_                                      gensupport.URLParams
	mediaInfo_                                      *gensupport.MediaInfo
	ctx_                                            context.Context
	header_                                         http.Header
}

// Upload: Uploads rotating barcode values for the transit object referenced by
// the given object ID. Note the max upload size is specified in
// google3/production/config/cdd/apps-upload/customers/payments-consumer-passes/
// config.gcl and enforced by Scotty.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *MediaService) Upload(resourceId string, transitobjectuploadrotatingbarcodevaluesrequest *TransitObjectUploadRotatingBarcodeValuesRequest) *MediaUploadCall {
	c := &MediaUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.transitobjectuploadrotatingbarcodevaluesrequest = transitobjectuploadrotatingbarcodevaluesrequest
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk size
// may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the upload
// request will be determined by sniffing the contents of r, unless a
// MediaOption generated by googleapi.ContentType is supplied.
// At most one of Media and ResumableMedia may be set.
func (c *MediaUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *MediaUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be canceled
// with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType identifies the
// MIME media type of the upload, such as "image/png". If mediaType is "", it
// will be auto-detected. The provided ctx will supersede any context
// previously provided to the Context method.
func (c *MediaUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *MediaUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called after every
// chunk. It should be a low-latency function in order to not slow down the
// upload operation. This should only be called when using ResumableMedia (as
// opposed to Media).
func (c *MediaUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *MediaUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MediaUploadCall) Fields(s ...googleapi.Field) *MediaUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *MediaUploadCall) Context(ctx context.Context) *MediaUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MediaUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.transitobjectuploadrotatingbarcodevaluesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitObject/{resourceId}/uploadRotatingBarcodeValues")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/walletobjects/v1/transitObject/{resourceId}/uploadRotatingBarcodeValues")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.media.upload" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitObjectUploadRotatingBarcodeValuesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MediaUploadCall) Do(opts ...googleapi.CallOption) (*TransitObjectUploadRotatingBarcodeValuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &TransitObjectUploadRotatingBarcodeValuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferclassAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the offer class referenced by the given class
// ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *OfferclassService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *OfferclassAddmessageCall {
	c := &OfferclassAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferclassAddmessageCall) Fields(s ...googleapi.Field) *OfferclassAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferclassAddmessageCall) Context(ctx context.Context) *OfferclassAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferclassAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferclassAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerClass/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerclass.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferClassAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OfferclassAddmessageCall) Do(opts ...googleapi.CallOption) (*OfferClassAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferClassAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferclassGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the offer class with the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *OfferclassService) Get(resourceId string) *OfferclassGetCall {
	c := &OfferclassGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferclassGetCall) Fields(s ...googleapi.Field) *OfferclassGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OfferclassGetCall) IfNoneMatch(entityTag string) *OfferclassGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferclassGetCall) Context(ctx context.Context) *OfferclassGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferclassGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferclassGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerclass.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferClass.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OfferclassGetCall) Do(opts ...googleapi.CallOption) (*OfferClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferclassInsertCall struct {
	s          *Service
	offerclass *OfferClass
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Inserts an offer class with the given ID and properties.
func (r *OfferclassService) Insert(offerclass *OfferClass) *OfferclassInsertCall {
	c := &OfferclassInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.offerclass = offerclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferclassInsertCall) Fields(s ...googleapi.Field) *OfferclassInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferclassInsertCall) Context(ctx context.Context) *OfferclassInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferclassInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferclassInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.offerclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerclass.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferClass.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OfferclassInsertCall) Do(opts ...googleapi.CallOption) (*OfferClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferclassListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all offer classes for a given issuer ID.
func (r *OfferclassService) List() *OfferclassListCall {
	c := &OfferclassListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// IssuerId sets the optional parameter "issuerId": The ID of the issuer
// authorized to list classes.
func (c *OfferclassListCall) IssuerId(issuerId int64) *OfferclassListCall {
	c.urlParams_.Set("issuerId", fmt.Sprint(issuerId))
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *OfferclassListCall) MaxResults(maxResults int64) *OfferclassListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` classes are
// available in a list. For example, if you have a list of 200 classes and you
// call list with `maxResults` set to 20, list will return the first 20 classes
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 classes.
func (c *OfferclassListCall) Token(token string) *OfferclassListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferclassListCall) Fields(s ...googleapi.Field) *OfferclassListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OfferclassListCall) IfNoneMatch(entityTag string) *OfferclassListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferclassListCall) Context(ctx context.Context) *OfferclassListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferclassListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferclassListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerclass.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferClassListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OfferclassListCall) Do(opts ...googleapi.CallOption) (*OfferClassListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferClassListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferclassPatchCall struct {
	s          *Service
	resourceId string
	offerclass *OfferClass
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the offer class referenced by the given class ID. This method
// supports patch semantics.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *OfferclassService) Patch(resourceId string, offerclass *OfferClass) *OfferclassPatchCall {
	c := &OfferclassPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.offerclass = offerclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferclassPatchCall) Fields(s ...googleapi.Field) *OfferclassPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferclassPatchCall) Context(ctx context.Context) *OfferclassPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferclassPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferclassPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.offerclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerclass.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferClass.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OfferclassPatchCall) Do(opts ...googleapi.CallOption) (*OfferClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferclassUpdateCall struct {
	s          *Service
	resourceId string
	offerclass *OfferClass
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the offer class referenced by the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *OfferclassService) Update(resourceId string, offerclass *OfferClass) *OfferclassUpdateCall {
	c := &OfferclassUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.offerclass = offerclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferclassUpdateCall) Fields(s ...googleapi.Field) *OfferclassUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferclassUpdateCall) Context(ctx context.Context) *OfferclassUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferclassUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferclassUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.offerclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerclass.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferClass.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OfferclassUpdateCall) Do(opts ...googleapi.CallOption) (*OfferClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferobjectAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the offer object referenced by the given
// object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *OfferobjectService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *OfferobjectAddmessageCall {
	c := &OfferobjectAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferobjectAddmessageCall) Fields(s ...googleapi.Field) *OfferobjectAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferobjectAddmessageCall) Context(ctx context.Context) *OfferobjectAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferobjectAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferobjectAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerObject/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerobject.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferObjectAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OfferobjectAddmessageCall) Do(opts ...googleapi.CallOption) (*OfferObjectAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferObjectAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferobjectGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the offer object with the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *OfferobjectService) Get(resourceId string) *OfferobjectGetCall {
	c := &OfferobjectGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferobjectGetCall) Fields(s ...googleapi.Field) *OfferobjectGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OfferobjectGetCall) IfNoneMatch(entityTag string) *OfferobjectGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferobjectGetCall) Context(ctx context.Context) *OfferobjectGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferobjectGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferobjectGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerobject.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferObject.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OfferobjectGetCall) Do(opts ...googleapi.CallOption) (*OfferObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferobjectInsertCall struct {
	s           *Service
	offerobject *OfferObject
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Insert: Inserts an offer object with the given ID and properties.
func (r *OfferobjectService) Insert(offerobject *OfferObject) *OfferobjectInsertCall {
	c := &OfferobjectInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.offerobject = offerobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferobjectInsertCall) Fields(s ...googleapi.Field) *OfferobjectInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferobjectInsertCall) Context(ctx context.Context) *OfferobjectInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferobjectInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferobjectInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.offerobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerobject.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferObject.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OfferobjectInsertCall) Do(opts ...googleapi.CallOption) (*OfferObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferobjectListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all offer objects for a given issuer ID.
func (r *OfferobjectService) List() *OfferobjectListCall {
	c := &OfferobjectListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// ClassId sets the optional parameter "classId": The ID of the class whose
// objects will be listed.
func (c *OfferobjectListCall) ClassId(classId string) *OfferobjectListCall {
	c.urlParams_.Set("classId", classId)
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *OfferobjectListCall) MaxResults(maxResults int64) *OfferobjectListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` objects are
// available in a list. For example, if you have a list of 200 objects and you
// call list with `maxResults` set to 20, list will return the first 20 objects
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 objects.
func (c *OfferobjectListCall) Token(token string) *OfferobjectListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferobjectListCall) Fields(s ...googleapi.Field) *OfferobjectListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OfferobjectListCall) IfNoneMatch(entityTag string) *OfferobjectListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferobjectListCall) Context(ctx context.Context) *OfferobjectListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferobjectListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferobjectListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerobject.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferObjectListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OfferobjectListCall) Do(opts ...googleapi.CallOption) (*OfferObjectListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferObjectListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferobjectPatchCall struct {
	s           *Service
	resourceId  string
	offerobject *OfferObject
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates the offer object referenced by the given object ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *OfferobjectService) Patch(resourceId string, offerobject *OfferObject) *OfferobjectPatchCall {
	c := &OfferobjectPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.offerobject = offerobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferobjectPatchCall) Fields(s ...googleapi.Field) *OfferobjectPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferobjectPatchCall) Context(ctx context.Context) *OfferobjectPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferobjectPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferobjectPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.offerobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerobject.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferObject.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OfferobjectPatchCall) Do(opts ...googleapi.CallOption) (*OfferObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OfferobjectUpdateCall struct {
	s           *Service
	resourceId  string
	offerobject *OfferObject
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates the offer object referenced by the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *OfferobjectService) Update(resourceId string, offerobject *OfferObject) *OfferobjectUpdateCall {
	c := &OfferobjectUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.offerobject = offerobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OfferobjectUpdateCall) Fields(s ...googleapi.Field) *OfferobjectUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OfferobjectUpdateCall) Context(ctx context.Context) *OfferobjectUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OfferobjectUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OfferobjectUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.offerobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/offerObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.offerobject.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *OfferObject.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OfferobjectUpdateCall) Do(opts ...googleapi.CallOption) (*OfferObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OfferObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type PermissionsGetCall struct {
	s            *Service
	resourceId   int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the permissions for the given issuer id.
//
//   - resourceId: The unique identifier for an issuer. This ID must be unique
//     across all issuers.
func (r *PermissionsService) Get(resourceId int64) *PermissionsGetCall {
	c := &PermissionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PermissionsGetCall) Fields(s ...googleapi.Field) *PermissionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PermissionsGetCall) IfNoneMatch(entityTag string) *PermissionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PermissionsGetCall) Context(ctx context.Context) *PermissionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PermissionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PermissionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/permissions/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": strconv.FormatInt(c.resourceId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.permissions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Permissions.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PermissionsGetCall) Do(opts ...googleapi.CallOption) (*Permissions, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Permissions{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type PermissionsUpdateCall struct {
	s           *Service
	resourceId  int64
	permissions *Permissions
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates the permissions for the given issuer.
//
//   - resourceId: The unique identifier for an issuer. This ID must be unique
//     across all issuers.
func (r *PermissionsService) Update(resourceId int64, permissions *Permissions) *PermissionsUpdateCall {
	c := &PermissionsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.permissions = permissions
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PermissionsUpdateCall) Fields(s ...googleapi.Field) *PermissionsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PermissionsUpdateCall) Context(ctx context.Context) *PermissionsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PermissionsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PermissionsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.permissions)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/permissions/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": strconv.FormatInt(c.resourceId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.permissions.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Permissions.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PermissionsUpdateCall) Do(opts ...googleapi.CallOption) (*Permissions, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Permissions{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type SmarttapInsertCall struct {
	s          *Service
	smarttap   *SmartTap
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Inserts the smart tap.
func (r *SmarttapService) Insert(smarttap *SmartTap) *SmarttapInsertCall {
	c := &SmarttapInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.smarttap = smarttap
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SmarttapInsertCall) Fields(s ...googleapi.Field) *SmarttapInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SmarttapInsertCall) Context(ctx context.Context) *SmarttapInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SmarttapInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SmarttapInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.smarttap)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/smartTap")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.smarttap.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *SmartTap.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SmarttapInsertCall) Do(opts ...googleapi.CallOption) (*SmartTap, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SmartTap{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitclassAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the transit class referenced by the given
// class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *TransitclassService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *TransitclassAddmessageCall {
	c := &TransitclassAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitclassAddmessageCall) Fields(s ...googleapi.Field) *TransitclassAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitclassAddmessageCall) Context(ctx context.Context) *TransitclassAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitclassAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitclassAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitClass/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitclass.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitClassAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TransitclassAddmessageCall) Do(opts ...googleapi.CallOption) (*TransitClassAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitClassAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitclassGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the transit class with the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *TransitclassService) Get(resourceId string) *TransitclassGetCall {
	c := &TransitclassGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitclassGetCall) Fields(s ...googleapi.Field) *TransitclassGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TransitclassGetCall) IfNoneMatch(entityTag string) *TransitclassGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitclassGetCall) Context(ctx context.Context) *TransitclassGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitclassGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitclassGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitclass.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TransitclassGetCall) Do(opts ...googleapi.CallOption) (*TransitClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitclassInsertCall struct {
	s            *Service
	transitclass *TransitClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Insert: Inserts a transit class with the given ID and properties.
func (r *TransitclassService) Insert(transitclass *TransitClass) *TransitclassInsertCall {
	c := &TransitclassInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.transitclass = transitclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitclassInsertCall) Fields(s ...googleapi.Field) *TransitclassInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitclassInsertCall) Context(ctx context.Context) *TransitclassInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitclassInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitclassInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.transitclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitclass.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TransitclassInsertCall) Do(opts ...googleapi.CallOption) (*TransitClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitclassListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all transit classes for a given issuer ID.
func (r *TransitclassService) List() *TransitclassListCall {
	c := &TransitclassListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// IssuerId sets the optional parameter "issuerId": The ID of the issuer
// authorized to list classes.
func (c *TransitclassListCall) IssuerId(issuerId int64) *TransitclassListCall {
	c.urlParams_.Set("issuerId", fmt.Sprint(issuerId))
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *TransitclassListCall) MaxResults(maxResults int64) *TransitclassListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` classes are
// available in a list. For example, if you have a list of 200 classes and you
// call list with `maxResults` set to 20, list will return the first 20 classes
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 classes.
func (c *TransitclassListCall) Token(token string) *TransitclassListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitclassListCall) Fields(s ...googleapi.Field) *TransitclassListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TransitclassListCall) IfNoneMatch(entityTag string) *TransitclassListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitclassListCall) Context(ctx context.Context) *TransitclassListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitclassListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitclassListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitClass")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitclass.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitClassListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TransitclassListCall) Do(opts ...googleapi.CallOption) (*TransitClassListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitClassListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitclassPatchCall struct {
	s            *Service
	resourceId   string
	transitclass *TransitClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates the transit class referenced by the given class ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *TransitclassService) Patch(resourceId string, transitclass *TransitClass) *TransitclassPatchCall {
	c := &TransitclassPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.transitclass = transitclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitclassPatchCall) Fields(s ...googleapi.Field) *TransitclassPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitclassPatchCall) Context(ctx context.Context) *TransitclassPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitclassPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitclassPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.transitclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitclass.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TransitclassPatchCall) Do(opts ...googleapi.CallOption) (*TransitClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitclassUpdateCall struct {
	s            *Service
	resourceId   string
	transitclass *TransitClass
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Update: Updates the transit class referenced by the given class ID.
//
//   - resourceId: The unique identifier for a class. This ID must be unique
//     across all classes from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *TransitclassService) Update(resourceId string, transitclass *TransitClass) *TransitclassUpdateCall {
	c := &TransitclassUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.transitclass = transitclass
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitclassUpdateCall) Fields(s ...googleapi.Field) *TransitclassUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitclassUpdateCall) Context(ctx context.Context) *TransitclassUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitclassUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitclassUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.transitclass)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitClass/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitclass.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitClass.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TransitclassUpdateCall) Do(opts ...googleapi.CallOption) (*TransitClass, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitClass{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitobjectAddmessageCall struct {
	s                 *Service
	resourceId        string
	addmessagerequest *AddMessageRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Addmessage: Adds a message to the transit object referenced by the given
// object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *TransitobjectService) Addmessage(resourceId string, addmessagerequest *AddMessageRequest) *TransitobjectAddmessageCall {
	c := &TransitobjectAddmessageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.addmessagerequest = addmessagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitobjectAddmessageCall) Fields(s ...googleapi.Field) *TransitobjectAddmessageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitobjectAddmessageCall) Context(ctx context.Context) *TransitobjectAddmessageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitobjectAddmessageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitobjectAddmessageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addmessagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitObject/{resourceId}/addMessage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitobject.addmessage" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitObjectAddMessageResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TransitobjectAddmessageCall) Do(opts ...googleapi.CallOption) (*TransitObjectAddMessageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitObjectAddMessageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitobjectGetCall struct {
	s            *Service
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the transit object with the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *TransitobjectService) Get(resourceId string) *TransitobjectGetCall {
	c := &TransitobjectGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitobjectGetCall) Fields(s ...googleapi.Field) *TransitobjectGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TransitobjectGetCall) IfNoneMatch(entityTag string) *TransitobjectGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitobjectGetCall) Context(ctx context.Context) *TransitobjectGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitobjectGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitobjectGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitobject.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TransitobjectGetCall) Do(opts ...googleapi.CallOption) (*TransitObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitobjectInsertCall struct {
	s             *Service
	transitobject *TransitObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Insert: Inserts an transit object with the given ID and properties.
func (r *TransitobjectService) Insert(transitobject *TransitObject) *TransitobjectInsertCall {
	c := &TransitobjectInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.transitobject = transitobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitobjectInsertCall) Fields(s ...googleapi.Field) *TransitobjectInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitobjectInsertCall) Context(ctx context.Context) *TransitobjectInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitobjectInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitobjectInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.transitobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitobject.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TransitobjectInsertCall) Do(opts ...googleapi.CallOption) (*TransitObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitobjectListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of all transit objects for a given issuer ID.
func (r *TransitobjectService) List() *TransitobjectListCall {
	c := &TransitobjectListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// ClassId sets the optional parameter "classId": The ID of the class whose
// objects will be listed.
func (c *TransitobjectListCall) ClassId(classId string) *TransitobjectListCall {
	c.urlParams_.Set("classId", classId)
	return c
}

// MaxResults sets the optional parameter "maxResults": Identifies the max
// number of results returned by a list. All results are returned if
// `maxResults` isn't defined.
func (c *TransitobjectListCall) MaxResults(maxResults int64) *TransitobjectListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// Token sets the optional parameter "token": Used to get the next set of
// results if `maxResults` is specified, but more than `maxResults` objects are
// available in a list. For example, if you have a list of 200 objects and you
// call list with `maxResults` set to 20, list will return the first 20 objects
// and a token. Call list again with `maxResults` set to 20 and the token to
// get the next 20 objects.
func (c *TransitobjectListCall) Token(token string) *TransitobjectListCall {
	c.urlParams_.Set("token", token)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitobjectListCall) Fields(s ...googleapi.Field) *TransitobjectListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TransitobjectListCall) IfNoneMatch(entityTag string) *TransitobjectListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitobjectListCall) Context(ctx context.Context) *TransitobjectListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitobjectListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitobjectListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitObject")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitobject.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitObjectListResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TransitobjectListCall) Do(opts ...googleapi.CallOption) (*TransitObjectListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitObjectListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitobjectPatchCall struct {
	s             *Service
	resourceId    string
	transitobject *TransitObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates the transit object referenced by the given object ID. This
// method supports patch semantics.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *TransitobjectService) Patch(resourceId string, transitobject *TransitObject) *TransitobjectPatchCall {
	c := &TransitobjectPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.transitobject = transitobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitobjectPatchCall) Fields(s ...googleapi.Field) *TransitobjectPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitobjectPatchCall) Context(ctx context.Context) *TransitobjectPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitobjectPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitobjectPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.transitobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitobject.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TransitobjectPatchCall) Do(opts ...googleapi.CallOption) (*TransitObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TransitobjectUpdateCall struct {
	s             *Service
	resourceId    string
	transitobject *TransitObject
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Update: Updates the transit object referenced by the given object ID.
//
//   - resourceId: The unique identifier for an object. This ID must be unique
//     across all objects from an issuer. This value should follow the format
//     issuer ID. identifier where the former is issued by Google and latter is
//     chosen by you. Your unique identifier should only include alphanumeric
//     characters, '.', '_', or '-'.
func (r *TransitobjectService) Update(resourceId string, transitobject *TransitObject) *TransitobjectUpdateCall {
	c := &TransitobjectUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resourceId = resourceId
	c.transitobject = transitobject
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TransitobjectUpdateCall) Fields(s ...googleapi.Field) *TransitobjectUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TransitobjectUpdateCall) Context(ctx context.Context) *TransitobjectUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TransitobjectUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TransitobjectUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.transitobject)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "walletobjects/v1/transitObject/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "walletobjects.transitobject.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *TransitObject.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TransitobjectUpdateCall) Do(opts ...googleapi.CallOption) (*TransitObject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TransitObject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
