// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/aiplatform/v1beta1/schema/trainingjob/definition/automl_image_classification.proto

package definition

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type AutoMlImageClassificationInputs_ModelType int32

const (
	// Should not be set.
	AutoMlImageClassificationInputs_MODEL_TYPE_UNSPECIFIED AutoMlImageClassificationInputs_ModelType = 0
	// A Model best tailored to be used within Google Cloud, and which cannot
	// be exported.
	// Default.
	AutoMlImageClassificationInputs_CLOUD AutoMlImageClassificationInputs_ModelType = 1
	// A model that, in addition to being available within Google
	// Cloud, can also be exported (see ModelService.ExportModel) as TensorFlow
	// or Core ML model and used on a mobile or edge device afterwards.
	// Expected to have low latency, but may have lower prediction
	// quality than other mobile models.
	AutoMlImageClassificationInputs_MOBILE_TF_LOW_LATENCY_1 AutoMlImageClassificationInputs_ModelType = 2
	// A model that, in addition to being available within Google
	// Cloud, can also be exported (see ModelService.ExportModel) as TensorFlow
	// or Core ML model and used on a mobile or edge device with afterwards.
	AutoMlImageClassificationInputs_MOBILE_TF_VERSATILE_1 AutoMlImageClassificationInputs_ModelType = 3
	// A model that, in addition to being available within Google
	// Cloud, can also be exported (see ModelService.ExportModel) as TensorFlow
	// or Core ML model and used on a mobile or edge device afterwards.
	// Expected to have a higher latency, but should also have a higher
	// prediction quality than other mobile models.
	AutoMlImageClassificationInputs_MOBILE_TF_HIGH_ACCURACY_1 AutoMlImageClassificationInputs_ModelType = 4
)

// Enum value maps for AutoMlImageClassificationInputs_ModelType.
var (
	AutoMlImageClassificationInputs_ModelType_name = map[int32]string{
		0: "MODEL_TYPE_UNSPECIFIED",
		1: "CLOUD",
		2: "MOBILE_TF_LOW_LATENCY_1",
		3: "MOBILE_TF_VERSATILE_1",
		4: "MOBILE_TF_HIGH_ACCURACY_1",
	}
	AutoMlImageClassificationInputs_ModelType_value = map[string]int32{
		"MODEL_TYPE_UNSPECIFIED":    0,
		"CLOUD":                     1,
		"MOBILE_TF_LOW_LATENCY_1":   2,
		"MOBILE_TF_VERSATILE_1":     3,
		"MOBILE_TF_HIGH_ACCURACY_1": 4,
	}
)

func (x AutoMlImageClassificationInputs_ModelType) Enum() *AutoMlImageClassificationInputs_ModelType {
	p := new(AutoMlImageClassificationInputs_ModelType)
	*p = x
	return p
}

func (x AutoMlImageClassificationInputs_ModelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoMlImageClassificationInputs_ModelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_enumTypes[0].Descriptor()
}

func (AutoMlImageClassificationInputs_ModelType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_enumTypes[0]
}

func (x AutoMlImageClassificationInputs_ModelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoMlImageClassificationInputs_ModelType.Descriptor instead.
func (AutoMlImageClassificationInputs_ModelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescGZIP(), []int{1, 0}
}

type AutoMlImageClassificationMetadata_SuccessfulStopReason int32

const (
	// Should not be set.
	AutoMlImageClassificationMetadata_SUCCESSFUL_STOP_REASON_UNSPECIFIED AutoMlImageClassificationMetadata_SuccessfulStopReason = 0
	// The inputs.budgetMilliNodeHours had been reached.
	AutoMlImageClassificationMetadata_BUDGET_REACHED AutoMlImageClassificationMetadata_SuccessfulStopReason = 1
	// Further training of the Model ceased to increase its quality, since it
	// already has converged.
	AutoMlImageClassificationMetadata_MODEL_CONVERGED AutoMlImageClassificationMetadata_SuccessfulStopReason = 2
)

// Enum value maps for AutoMlImageClassificationMetadata_SuccessfulStopReason.
var (
	AutoMlImageClassificationMetadata_SuccessfulStopReason_name = map[int32]string{
		0: "SUCCESSFUL_STOP_REASON_UNSPECIFIED",
		1: "BUDGET_REACHED",
		2: "MODEL_CONVERGED",
	}
	AutoMlImageClassificationMetadata_SuccessfulStopReason_value = map[string]int32{
		"SUCCESSFUL_STOP_REASON_UNSPECIFIED": 0,
		"BUDGET_REACHED":                     1,
		"MODEL_CONVERGED":                    2,
	}
)

func (x AutoMlImageClassificationMetadata_SuccessfulStopReason) Enum() *AutoMlImageClassificationMetadata_SuccessfulStopReason {
	p := new(AutoMlImageClassificationMetadata_SuccessfulStopReason)
	*p = x
	return p
}

func (x AutoMlImageClassificationMetadata_SuccessfulStopReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoMlImageClassificationMetadata_SuccessfulStopReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_enumTypes[1].Descriptor()
}

func (AutoMlImageClassificationMetadata_SuccessfulStopReason) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_enumTypes[1]
}

func (x AutoMlImageClassificationMetadata_SuccessfulStopReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoMlImageClassificationMetadata_SuccessfulStopReason.Descriptor instead.
func (AutoMlImageClassificationMetadata_SuccessfulStopReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescGZIP(), []int{2, 0}
}

// A TrainingJob that trains and uploads an AutoML Image Classification Model.
type AutoMlImageClassification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input parameters of this TrainingJob.
	Inputs *AutoMlImageClassificationInputs `protobuf:"bytes,1,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// The metadata information.
	Metadata *AutoMlImageClassificationMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *AutoMlImageClassification) Reset() {
	*x = AutoMlImageClassification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlImageClassification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlImageClassification) ProtoMessage() {}

func (x *AutoMlImageClassification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlImageClassification.ProtoReflect.Descriptor instead.
func (*AutoMlImageClassification) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescGZIP(), []int{0}
}

func (x *AutoMlImageClassification) GetInputs() *AutoMlImageClassificationInputs {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *AutoMlImageClassification) GetMetadata() *AutoMlImageClassificationMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type AutoMlImageClassificationInputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ModelType AutoMlImageClassificationInputs_ModelType `protobuf:"varint,1,opt,name=model_type,json=modelType,proto3,enum=google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationInputs_ModelType" json:"model_type,omitempty"`
	// The ID of the `base` model. If it is specified, the new model will be
	// trained based on the `base` model. Otherwise, the new model will be
	// trained from scratch. The `base` model must be in the same
	// Project and Location as the new Model to train, and have the same
	// modelType.
	BaseModelId string `protobuf:"bytes,2,opt,name=base_model_id,json=baseModelId,proto3" json:"base_model_id,omitempty"`
	// The training budget of creating this model, expressed in milli node
	// hours i.e. 1,000 value in this field means 1 node hour. The actual
	// metadata.costMilliNodeHours will be equal or less than this value.
	// If further model training ceases to provide any improvements, it will
	// stop without using the full budget and the metadata.successfulStopReason
	// will be `model-converged`.
	// Note, node_hour  = actual_hour * number_of_nodes_involved.
	// For modelType `cloud`(default), the budget must be between 8,000
	// and 800,000 milli node hours, inclusive. The default value is 192,000
	// which represents one day in wall time, considering 8 nodes are used.
	// For model types `mobile-tf-low-latency-1`, `mobile-tf-versatile-1`,
	// `mobile-tf-high-accuracy-1`, the training budget must be between
	// 1,000 and 100,000 milli node hours, inclusive.
	// The default value is 24,000 which represents one day in wall time on a
	// single node that is used.
	BudgetMilliNodeHours int64 `protobuf:"varint,3,opt,name=budget_milli_node_hours,json=budgetMilliNodeHours,proto3" json:"budget_milli_node_hours,omitempty"`
	// Use the entire training budget. This disables the early stopping feature.
	// When false the early stopping feature is enabled, which means that
	// AutoML Image Classification might stop training before the entire
	// training budget has been used.
	DisableEarlyStopping bool `protobuf:"varint,4,opt,name=disable_early_stopping,json=disableEarlyStopping,proto3" json:"disable_early_stopping,omitempty"`
	// If false, a single-label (multi-class) Model will be trained (i.e.
	// assuming that for each image just up to one annotation may be
	// applicable). If true, a multi-label Model will be trained (i.e.
	// assuming that for each image multiple annotations may be applicable).
	MultiLabel bool `protobuf:"varint,5,opt,name=multi_label,json=multiLabel,proto3" json:"multi_label,omitempty"`
}

func (x *AutoMlImageClassificationInputs) Reset() {
	*x = AutoMlImageClassificationInputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlImageClassificationInputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlImageClassificationInputs) ProtoMessage() {}

func (x *AutoMlImageClassificationInputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlImageClassificationInputs.ProtoReflect.Descriptor instead.
func (*AutoMlImageClassificationInputs) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescGZIP(), []int{1}
}

func (x *AutoMlImageClassificationInputs) GetModelType() AutoMlImageClassificationInputs_ModelType {
	if x != nil {
		return x.ModelType
	}
	return AutoMlImageClassificationInputs_MODEL_TYPE_UNSPECIFIED
}

func (x *AutoMlImageClassificationInputs) GetBaseModelId() string {
	if x != nil {
		return x.BaseModelId
	}
	return ""
}

func (x *AutoMlImageClassificationInputs) GetBudgetMilliNodeHours() int64 {
	if x != nil {
		return x.BudgetMilliNodeHours
	}
	return 0
}

func (x *AutoMlImageClassificationInputs) GetDisableEarlyStopping() bool {
	if x != nil {
		return x.DisableEarlyStopping
	}
	return false
}

func (x *AutoMlImageClassificationInputs) GetMultiLabel() bool {
	if x != nil {
		return x.MultiLabel
	}
	return false
}

type AutoMlImageClassificationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The actual training cost of creating this model, expressed in
	// milli node hours, i.e. 1,000 value in this field means 1 node hour.
	// Guaranteed to not exceed inputs.budgetMilliNodeHours.
	CostMilliNodeHours int64 `protobuf:"varint,1,opt,name=cost_milli_node_hours,json=costMilliNodeHours,proto3" json:"cost_milli_node_hours,omitempty"`
	// For successful job completions, this is the reason why the job has
	// finished.
	SuccessfulStopReason AutoMlImageClassificationMetadata_SuccessfulStopReason `protobuf:"varint,2,opt,name=successful_stop_reason,json=successfulStopReason,proto3,enum=google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationMetadata_SuccessfulStopReason" json:"successful_stop_reason,omitempty"`
}

func (x *AutoMlImageClassificationMetadata) Reset() {
	*x = AutoMlImageClassificationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlImageClassificationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlImageClassificationMetadata) ProtoMessage() {}

func (x *AutoMlImageClassificationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlImageClassificationMetadata.ProtoReflect.Descriptor instead.
func (*AutoMlImageClassificationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescGZIP(), []int{2}
}

func (x *AutoMlImageClassificationMetadata) GetCostMilliNodeHours() int64 {
	if x != nil {
		return x.CostMilliNodeHours
	}
	return 0
}

func (x *AutoMlImageClassificationMetadata) GetSuccessfulStopReason() AutoMlImageClassificationMetadata_SuccessfulStopReason {
	if x != nil {
		return x.SuccessfulStopReason
	}
	return AutoMlImageClassificationMetadata_SUCCESSFUL_STOP_REASON_UNSPECIFIED
}

var File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDesc = []byte{
	0x0a, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x91,
	0x02, 0x0a, 0x19, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x76, 0x0a, 0x06,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f,
	0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x4d, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x52, 0x06, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x7c, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0xe9, 0x03, 0x0a, 0x1f, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x87, 0x01, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x68, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62,
	0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x4d, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x22, 0x0a, 0x0d, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x61, 0x73, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x17, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d,
	0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69, 0x6c,
	0x6c, 0x69, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x73, 0x74, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x22, 0x89, 0x01, 0x0a, 0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x43, 0x4c, 0x4f, 0x55, 0x44, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x4f, 0x42, 0x49, 0x4c,
	0x45, 0x5f, 0x54, 0x46, 0x5f, 0x4c, 0x4f, 0x57, 0x5f, 0x4c, 0x41, 0x54, 0x45, 0x4e, 0x43, 0x59,
	0x5f, 0x31, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x4f, 0x42, 0x49, 0x4c, 0x45, 0x5f, 0x54,
	0x46, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x41, 0x54, 0x49, 0x4c, 0x45, 0x5f, 0x31, 0x10, 0x03, 0x12,
	0x1d, 0x0a, 0x19, 0x4d, 0x4f, 0x42, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x46, 0x5f, 0x48, 0x49, 0x47,
	0x48, 0x5f, 0x41, 0x43, 0x43, 0x55, 0x52, 0x41, 0x43, 0x59, 0x5f, 0x31, 0x10, 0x04, 0x22, 0xed,
	0x02, 0x0a, 0x21, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x15, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x6c,
	0x6c, 0x69, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x12, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x4e, 0x6f,
	0x64, 0x65, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0xab, 0x01, 0x0a, 0x16, 0x73, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x66, 0x75, 0x6c, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52,
	0x14, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x53, 0x74, 0x6f, 0x70, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x67, 0x0a, 0x14, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x66, 0x75, 0x6c, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x26, 0x0a,
	0x22, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x46, 0x55, 0x4c, 0x5f, 0x53, 0x54, 0x4f, 0x50,
	0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x42, 0x55, 0x44, 0x47, 0x45, 0x54, 0x5f,
	0x52, 0x45, 0x41, 0x43, 0x48, 0x45, 0x44, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x4f, 0x44,
	0x45, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x47, 0x45, 0x44, 0x10, 0x02, 0x42, 0xce,
	0x01, 0x0a, 0x41, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x1e, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x4c, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x67, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x6a, 0x6f, 0x62, 0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x3b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_goTypes = []interface{}{
	(AutoMlImageClassificationInputs_ModelType)(0),              // 0: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationInputs.ModelType
	(AutoMlImageClassificationMetadata_SuccessfulStopReason)(0), // 1: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationMetadata.SuccessfulStopReason
	(*AutoMlImageClassification)(nil),                           // 2: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassification
	(*AutoMlImageClassificationInputs)(nil),                     // 3: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationInputs
	(*AutoMlImageClassificationMetadata)(nil),                   // 4: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationMetadata
}
var file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_depIdxs = []int32{
	3, // 0: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassification.inputs:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationInputs
	4, // 1: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassification.metadata:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationMetadata
	0, // 2: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationInputs.model_type:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationInputs.ModelType
	1, // 3: google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationMetadata.successful_stop_reason:type_name -> google.cloud.aiplatform.v1beta1.schema.trainingjob.definition.AutoMlImageClassificationMetadata.SuccessfulStopReason
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() {
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_init()
}
func file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlImageClassification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlImageClassificationInputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlImageClassificationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto = out.File
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_schema_trainingjob_definition_automl_image_classification_proto_depIdxs = nil
}
