// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/analytics/data/v1beta/data.proto

package data

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents aggregation of metrics.
type MetricAggregation int32

const (
	// Unspecified operator.
	MetricAggregation_METRIC_AGGREGATION_UNSPECIFIED MetricAggregation = 0
	// SUM operator.
	MetricAggregation_TOTAL MetricAggregation = 1
	// Minimum operator.
	MetricAggregation_MINIMUM MetricAggregation = 5
	// Maximum operator.
	MetricAggregation_MAXIMUM MetricAggregation = 6
	// Count operator.
	MetricAggregation_COUNT MetricAggregation = 4
)

// Enum value maps for MetricAggregation.
var (
	MetricAggregation_name = map[int32]string{
		0: "METRIC_AGGREGATION_UNSPECIFIED",
		1: "TOTAL",
		5: "MINIMUM",
		6: "MAXIMUM",
		4: "COUNT",
	}
	MetricAggregation_value = map[string]int32{
		"METRIC_AGGREGATION_UNSPECIFIED": 0,
		"TOTAL":                          1,
		"MINIMUM":                        5,
		"MAXIMUM":                        6,
		"COUNT":                          4,
	}
)

func (x MetricAggregation) Enum() *MetricAggregation {
	p := new(MetricAggregation)
	*p = x
	return p
}

func (x MetricAggregation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricAggregation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[0].Descriptor()
}

func (MetricAggregation) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[0]
}

func (x MetricAggregation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricAggregation.Descriptor instead.
func (MetricAggregation) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{0}
}

// A metric's value type.
type MetricType int32

const (
	// Unspecified type.
	MetricType_METRIC_TYPE_UNSPECIFIED MetricType = 0
	// Integer type.
	MetricType_TYPE_INTEGER MetricType = 1
	// Floating point type.
	MetricType_TYPE_FLOAT MetricType = 2
	// A duration of seconds; a special floating point type.
	MetricType_TYPE_SECONDS MetricType = 4
	// A duration in milliseconds; a special floating point type.
	MetricType_TYPE_MILLISECONDS MetricType = 5
	// A duration in minutes; a special floating point type.
	MetricType_TYPE_MINUTES MetricType = 6
	// A duration in hours; a special floating point type.
	MetricType_TYPE_HOURS MetricType = 7
	// A custom metric of standard type; a special floating point type.
	MetricType_TYPE_STANDARD MetricType = 8
	// An amount of money; a special floating point type.
	MetricType_TYPE_CURRENCY MetricType = 9
	// A length in feet; a special floating point type.
	MetricType_TYPE_FEET MetricType = 10
	// A length in miles; a special floating point type.
	MetricType_TYPE_MILES MetricType = 11
	// A length in meters; a special floating point type.
	MetricType_TYPE_METERS MetricType = 12
	// A length in kilometers; a special floating point type.
	MetricType_TYPE_KILOMETERS MetricType = 13
)

// Enum value maps for MetricType.
var (
	MetricType_name = map[int32]string{
		0:  "METRIC_TYPE_UNSPECIFIED",
		1:  "TYPE_INTEGER",
		2:  "TYPE_FLOAT",
		4:  "TYPE_SECONDS",
		5:  "TYPE_MILLISECONDS",
		6:  "TYPE_MINUTES",
		7:  "TYPE_HOURS",
		8:  "TYPE_STANDARD",
		9:  "TYPE_CURRENCY",
		10: "TYPE_FEET",
		11: "TYPE_MILES",
		12: "TYPE_METERS",
		13: "TYPE_KILOMETERS",
	}
	MetricType_value = map[string]int32{
		"METRIC_TYPE_UNSPECIFIED": 0,
		"TYPE_INTEGER":            1,
		"TYPE_FLOAT":              2,
		"TYPE_SECONDS":            4,
		"TYPE_MILLISECONDS":       5,
		"TYPE_MINUTES":            6,
		"TYPE_HOURS":              7,
		"TYPE_STANDARD":           8,
		"TYPE_CURRENCY":           9,
		"TYPE_FEET":               10,
		"TYPE_MILES":              11,
		"TYPE_METERS":             12,
		"TYPE_KILOMETERS":         13,
	}
)

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[1].Descriptor()
}

func (MetricType) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[1]
}

func (x MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricType.Descriptor instead.
func (MetricType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{1}
}

// Categories of data that you may be restricted from viewing on certain GA4
// properties.
type RestrictedMetricType int32

const (
	// Unspecified type.
	RestrictedMetricType_RESTRICTED_METRIC_TYPE_UNSPECIFIED RestrictedMetricType = 0
	// Cost metrics such as `adCost`.
	RestrictedMetricType_COST_DATA RestrictedMetricType = 1
	// Revenue metrics such as `purchaseRevenue`.
	RestrictedMetricType_REVENUE_DATA RestrictedMetricType = 2
)

// Enum value maps for RestrictedMetricType.
var (
	RestrictedMetricType_name = map[int32]string{
		0: "RESTRICTED_METRIC_TYPE_UNSPECIFIED",
		1: "COST_DATA",
		2: "REVENUE_DATA",
	}
	RestrictedMetricType_value = map[string]int32{
		"RESTRICTED_METRIC_TYPE_UNSPECIFIED": 0,
		"COST_DATA":                          1,
		"REVENUE_DATA":                       2,
	}
)

func (x RestrictedMetricType) Enum() *RestrictedMetricType {
	p := new(RestrictedMetricType)
	*p = x
	return p
}

func (x RestrictedMetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestrictedMetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[2].Descriptor()
}

func (RestrictedMetricType) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[2]
}

func (x RestrictedMetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestrictedMetricType.Descriptor instead.
func (RestrictedMetricType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{2}
}

// The compatibility types for a single dimension or metric.
type Compatibility int32

const (
	// Unspecified compatibility.
	Compatibility_COMPATIBILITY_UNSPECIFIED Compatibility = 0
	// The dimension or metric is compatible. This dimension or metric can be
	// successfully added to a report.
	Compatibility_COMPATIBLE Compatibility = 1
	// The dimension or metric is incompatible. This dimension or metric cannot be
	// successfully added to a report.
	Compatibility_INCOMPATIBLE Compatibility = 2
)

// Enum value maps for Compatibility.
var (
	Compatibility_name = map[int32]string{
		0: "COMPATIBILITY_UNSPECIFIED",
		1: "COMPATIBLE",
		2: "INCOMPATIBLE",
	}
	Compatibility_value = map[string]int32{
		"COMPATIBILITY_UNSPECIFIED": 0,
		"COMPATIBLE":                1,
		"INCOMPATIBLE":              2,
	}
)

func (x Compatibility) Enum() *Compatibility {
	p := new(Compatibility)
	*p = x
	return p
}

func (x Compatibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Compatibility) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[3].Descriptor()
}

func (Compatibility) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[3]
}

func (x Compatibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Compatibility.Descriptor instead.
func (Compatibility) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{3}
}

// The match type of a string filter
type Filter_StringFilter_MatchType int32

const (
	// Unspecified
	Filter_StringFilter_MATCH_TYPE_UNSPECIFIED Filter_StringFilter_MatchType = 0
	// Exact match of the string value.
	Filter_StringFilter_EXACT Filter_StringFilter_MatchType = 1
	// Begins with the string value.
	Filter_StringFilter_BEGINS_WITH Filter_StringFilter_MatchType = 2
	// Ends with the string value.
	Filter_StringFilter_ENDS_WITH Filter_StringFilter_MatchType = 3
	// Contains the string value.
	Filter_StringFilter_CONTAINS Filter_StringFilter_MatchType = 4
	// Full regular expression match with the string value.
	Filter_StringFilter_FULL_REGEXP Filter_StringFilter_MatchType = 5
	// Partial regular expression match with the string value.
	Filter_StringFilter_PARTIAL_REGEXP Filter_StringFilter_MatchType = 6
)

// Enum value maps for Filter_StringFilter_MatchType.
var (
	Filter_StringFilter_MatchType_name = map[int32]string{
		0: "MATCH_TYPE_UNSPECIFIED",
		1: "EXACT",
		2: "BEGINS_WITH",
		3: "ENDS_WITH",
		4: "CONTAINS",
		5: "FULL_REGEXP",
		6: "PARTIAL_REGEXP",
	}
	Filter_StringFilter_MatchType_value = map[string]int32{
		"MATCH_TYPE_UNSPECIFIED": 0,
		"EXACT":                  1,
		"BEGINS_WITH":            2,
		"ENDS_WITH":              3,
		"CONTAINS":               4,
		"FULL_REGEXP":            5,
		"PARTIAL_REGEXP":         6,
	}
)

func (x Filter_StringFilter_MatchType) Enum() *Filter_StringFilter_MatchType {
	p := new(Filter_StringFilter_MatchType)
	*p = x
	return p
}

func (x Filter_StringFilter_MatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Filter_StringFilter_MatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[4].Descriptor()
}

func (Filter_StringFilter_MatchType) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[4]
}

func (x Filter_StringFilter_MatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Filter_StringFilter_MatchType.Descriptor instead.
func (Filter_StringFilter_MatchType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{7, 0, 0}
}

// The operation applied to a numeric filter
type Filter_NumericFilter_Operation int32

const (
	// Unspecified.
	Filter_NumericFilter_OPERATION_UNSPECIFIED Filter_NumericFilter_Operation = 0
	// Equal
	Filter_NumericFilter_EQUAL Filter_NumericFilter_Operation = 1
	// Less than
	Filter_NumericFilter_LESS_THAN Filter_NumericFilter_Operation = 2
	// Less than or equal
	Filter_NumericFilter_LESS_THAN_OR_EQUAL Filter_NumericFilter_Operation = 3
	// Greater than
	Filter_NumericFilter_GREATER_THAN Filter_NumericFilter_Operation = 4
	// Greater than or equal
	Filter_NumericFilter_GREATER_THAN_OR_EQUAL Filter_NumericFilter_Operation = 5
)

// Enum value maps for Filter_NumericFilter_Operation.
var (
	Filter_NumericFilter_Operation_name = map[int32]string{
		0: "OPERATION_UNSPECIFIED",
		1: "EQUAL",
		2: "LESS_THAN",
		3: "LESS_THAN_OR_EQUAL",
		4: "GREATER_THAN",
		5: "GREATER_THAN_OR_EQUAL",
	}
	Filter_NumericFilter_Operation_value = map[string]int32{
		"OPERATION_UNSPECIFIED": 0,
		"EQUAL":                 1,
		"LESS_THAN":             2,
		"LESS_THAN_OR_EQUAL":    3,
		"GREATER_THAN":          4,
		"GREATER_THAN_OR_EQUAL": 5,
	}
)

func (x Filter_NumericFilter_Operation) Enum() *Filter_NumericFilter_Operation {
	p := new(Filter_NumericFilter_Operation)
	*p = x
	return p
}

func (x Filter_NumericFilter_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Filter_NumericFilter_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[5].Descriptor()
}

func (Filter_NumericFilter_Operation) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[5]
}

func (x Filter_NumericFilter_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Filter_NumericFilter_Operation.Descriptor instead.
func (Filter_NumericFilter_Operation) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{7, 2, 0}
}

// Rule to order the string dimension values by.
type OrderBy_DimensionOrderBy_OrderType int32

const (
	// Unspecified.
	OrderBy_DimensionOrderBy_ORDER_TYPE_UNSPECIFIED OrderBy_DimensionOrderBy_OrderType = 0
	// Alphanumeric sort by Unicode code point. For example, "2" < "A" < "X" <
	// "b" < "z".
	OrderBy_DimensionOrderBy_ALPHANUMERIC OrderBy_DimensionOrderBy_OrderType = 1
	// Case insensitive alphanumeric sort by lower case Unicode code point.
	// For example, "2" < "A" < "b" < "X" < "z".
	OrderBy_DimensionOrderBy_CASE_INSENSITIVE_ALPHANUMERIC OrderBy_DimensionOrderBy_OrderType = 2
	// Dimension values are converted to numbers before sorting. For example
	// in NUMERIC sort, "25" < "100", and in `ALPHANUMERIC` sort, "100" <
	// "25". Non-numeric dimension values all have equal ordering value below
	// all numeric values.
	OrderBy_DimensionOrderBy_NUMERIC OrderBy_DimensionOrderBy_OrderType = 3
)

// Enum value maps for OrderBy_DimensionOrderBy_OrderType.
var (
	OrderBy_DimensionOrderBy_OrderType_name = map[int32]string{
		0: "ORDER_TYPE_UNSPECIFIED",
		1: "ALPHANUMERIC",
		2: "CASE_INSENSITIVE_ALPHANUMERIC",
		3: "NUMERIC",
	}
	OrderBy_DimensionOrderBy_OrderType_value = map[string]int32{
		"ORDER_TYPE_UNSPECIFIED":        0,
		"ALPHANUMERIC":                  1,
		"CASE_INSENSITIVE_ALPHANUMERIC": 2,
		"NUMERIC":                       3,
	}
)

func (x OrderBy_DimensionOrderBy_OrderType) Enum() *OrderBy_DimensionOrderBy_OrderType {
	p := new(OrderBy_DimensionOrderBy_OrderType)
	*p = x
	return p
}

func (x OrderBy_DimensionOrderBy_OrderType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrderBy_DimensionOrderBy_OrderType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[6].Descriptor()
}

func (OrderBy_DimensionOrderBy_OrderType) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[6]
}

func (x OrderBy_DimensionOrderBy_OrderType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrderBy_DimensionOrderBy_OrderType.Descriptor instead.
func (OrderBy_DimensionOrderBy_OrderType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{8, 1, 0}
}

// The granularity used to interpret the `startOffset` and `endOffset` for the
// extended reporting date range for a cohort report.
type CohortsRange_Granularity int32

const (
	// Should never be specified.
	CohortsRange_GRANULARITY_UNSPECIFIED CohortsRange_Granularity = 0
	// Daily granularity. Commonly used if the cohort's `dateRange` is a single
	// day and the request contains `cohortNthDay`.
	CohortsRange_DAILY CohortsRange_Granularity = 1
	// Weekly granularity. Commonly used if the cohort's `dateRange` is a week
	// in duration (starting on Sunday and ending on Saturday) and the request
	// contains `cohortNthWeek`.
	CohortsRange_WEEKLY CohortsRange_Granularity = 2
	// Monthly granularity. Commonly used if the cohort's `dateRange` is a month
	// in duration and the request contains `cohortNthMonth`.
	CohortsRange_MONTHLY CohortsRange_Granularity = 3
)

// Enum value maps for CohortsRange_Granularity.
var (
	CohortsRange_Granularity_name = map[int32]string{
		0: "GRANULARITY_UNSPECIFIED",
		1: "DAILY",
		2: "WEEKLY",
		3: "MONTHLY",
	}
	CohortsRange_Granularity_value = map[string]int32{
		"GRANULARITY_UNSPECIFIED": 0,
		"DAILY":                   1,
		"WEEKLY":                  2,
		"MONTHLY":                 3,
	}
)

func (x CohortsRange_Granularity) Enum() *CohortsRange_Granularity {
	p := new(CohortsRange_Granularity)
	*p = x
	return p
}

func (x CohortsRange_Granularity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CohortsRange_Granularity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[7].Descriptor()
}

func (CohortsRange_Granularity) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[7]
}

func (x CohortsRange_Granularity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CohortsRange_Granularity.Descriptor instead.
func (CohortsRange_Granularity) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{12, 0}
}

// Justifications for why this metric is blocked.
type MetricMetadata_BlockedReason int32

const (
	// Will never be specified in API response.
	MetricMetadata_BLOCKED_REASON_UNSPECIFIED MetricMetadata_BlockedReason = 0
	// If present, your access is blocked to revenue related metrics for this
	// property, and this metric is revenue related.
	MetricMetadata_NO_REVENUE_METRICS MetricMetadata_BlockedReason = 1
	// If present, your access is blocked to cost related metrics for this
	// property, and this metric is cost related.
	MetricMetadata_NO_COST_METRICS MetricMetadata_BlockedReason = 2
)

// Enum value maps for MetricMetadata_BlockedReason.
var (
	MetricMetadata_BlockedReason_name = map[int32]string{
		0: "BLOCKED_REASON_UNSPECIFIED",
		1: "NO_REVENUE_METRICS",
		2: "NO_COST_METRICS",
	}
	MetricMetadata_BlockedReason_value = map[string]int32{
		"BLOCKED_REASON_UNSPECIFIED": 0,
		"NO_REVENUE_METRICS":         1,
		"NO_COST_METRICS":            2,
	}
)

func (x MetricMetadata_BlockedReason) Enum() *MetricMetadata_BlockedReason {
	p := new(MetricMetadata_BlockedReason)
	*p = x
	return p
}

func (x MetricMetadata_BlockedReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricMetadata_BlockedReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1beta_data_proto_enumTypes[8].Descriptor()
}

func (MetricMetadata_BlockedReason) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1beta_data_proto_enumTypes[8]
}

func (x MetricMetadata_BlockedReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricMetadata_BlockedReason.Descriptor instead.
func (MetricMetadata_BlockedReason) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{26, 0}
}

// A contiguous set of days: startDate, startDate + 1, ..., endDate. Requests
// are allowed up to 4 date ranges.
type DateRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The inclusive start date for the query in the format `YYYY-MM-DD`. Cannot
	// be after `end_date`. The format `NdaysAgo`, `yesterday`, or `today` is also
	// accepted, and in that case, the date is inferred based on the property's
	// reporting time zone.
	StartDate string `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The inclusive end date for the query in the format `YYYY-MM-DD`. Cannot
	// be before `start_date`. The format `NdaysAgo`, `yesterday`, or `today` is
	// also accepted, and in that case, the date is inferred based on the
	// property's reporting time zone.
	EndDate string `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Assigns a name to this date range. The dimension `dateRange` is valued to
	// this name in a report response. If set, cannot begin with `date_range_` or
	// `RESERVED_`. If not set, date ranges are named by their zero based index in
	// the request: `date_range_0`, `date_range_1`, etc.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DateRange) Reset() {
	*x = DateRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateRange) ProtoMessage() {}

func (x *DateRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateRange.ProtoReflect.Descriptor instead.
func (*DateRange) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{0}
}

func (x *DateRange) GetStartDate() string {
	if x != nil {
		return x.StartDate
	}
	return ""
}

func (x *DateRange) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

func (x *DateRange) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A contiguous set of minutes: startMinutesAgo, startMinutesAgo + 1, ...,
// endMinutesAgo. Requests are allowed up to 2 minute ranges.
type MinuteRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The inclusive start minute for the query as a number of minutes before now.
	// For example, `"startMinutesAgo": 29` specifies the report should include
	// event data from 29 minutes ago and after. Cannot be after `endMinutesAgo`.
	//
	// If unspecified, `startMinutesAgo` is defaulted to 29. Standard Analytics
	// properties can request up to the last 30 minutes of event data
	// (`startMinutesAgo <= 29`), and Google Analytics 360 properties can request
	// up to the last 60 minutes of event data (`startMinutesAgo <= 59`).
	StartMinutesAgo *int32 `protobuf:"varint,1,opt,name=start_minutes_ago,json=startMinutesAgo,proto3,oneof" json:"start_minutes_ago,omitempty"`
	// The inclusive end minute for the query as a number of minutes before now.
	// Cannot be before `startMinutesAgo`. For example, `"endMinutesAgo": 15`
	// specifies the report should include event data from prior to 15 minutes
	// ago.
	//
	// If unspecified, `endMinutesAgo` is defaulted to 0. Standard Analytics
	// properties can request any minute in the last 30 minutes of event data
	// (`endMinutesAgo <= 29`), and Google Analytics 360 properties can request
	// any minute in the last 60 minutes of event data (`endMinutesAgo <= 59`).
	EndMinutesAgo *int32 `protobuf:"varint,2,opt,name=end_minutes_ago,json=endMinutesAgo,proto3,oneof" json:"end_minutes_ago,omitempty"`
	// Assigns a name to this minute range. The dimension `dateRange` is valued to
	// this name in a report response. If set, cannot begin with `date_range_` or
	// `RESERVED_`. If not set, minute ranges are named by their zero based index
	// in the request: `date_range_0`, `date_range_1`, etc.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *MinuteRange) Reset() {
	*x = MinuteRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MinuteRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MinuteRange) ProtoMessage() {}

func (x *MinuteRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MinuteRange.ProtoReflect.Descriptor instead.
func (*MinuteRange) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{1}
}

func (x *MinuteRange) GetStartMinutesAgo() int32 {
	if x != nil && x.StartMinutesAgo != nil {
		return *x.StartMinutesAgo
	}
	return 0
}

func (x *MinuteRange) GetEndMinutesAgo() int32 {
	if x != nil && x.EndMinutesAgo != nil {
		return *x.EndMinutesAgo
	}
	return 0
}

func (x *MinuteRange) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Dimensions are attributes of your data. For example, the dimension city
// indicates the city from which an event originates. Dimension values in report
// responses are strings; for example, city could be "Paris" or "New York".
// Requests are allowed up to 9 dimensions.
type Dimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the dimension. See the [API
	// Dimensions](https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#dimensions)
	// for the list of dimension names.
	//
	// If `dimensionExpression` is specified, `name` can be any string that you
	// would like within the allowed character set. For example if a
	// `dimensionExpression` concatenates `country` and `city`, you could call
	// that dimension `countryAndCity`. Dimension names that you choose must match
	// the regular expression `^[a-zA-Z0-9_]$`.
	//
	// Dimensions are referenced by `name` in `dimensionFilter`, `orderBys`,
	// `dimensionExpression`, and `pivots`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One dimension can be the result of an expression of multiple dimensions.
	// For example, dimension "country, city": concatenate(country, ", ", city).
	DimensionExpression *DimensionExpression `protobuf:"bytes,2,opt,name=dimension_expression,json=dimensionExpression,proto3" json:"dimension_expression,omitempty"`
}

func (x *Dimension) Reset() {
	*x = Dimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dimension) ProtoMessage() {}

func (x *Dimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dimension.ProtoReflect.Descriptor instead.
func (*Dimension) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{2}
}

func (x *Dimension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Dimension) GetDimensionExpression() *DimensionExpression {
	if x != nil {
		return x.DimensionExpression
	}
	return nil
}

// Used to express a dimension which is the result of a formula of multiple
// dimensions. Example usages:
// 1) lower_case(dimension)
// 2) concatenate(dimension1, symbol, dimension2).
type DimensionExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of dimension expression for `DimensionExpression`.
	//
	// Types that are assignable to OneExpression:
	//	*DimensionExpression_LowerCase
	//	*DimensionExpression_UpperCase
	//	*DimensionExpression_Concatenate
	OneExpression isDimensionExpression_OneExpression `protobuf_oneof:"one_expression"`
}

func (x *DimensionExpression) Reset() {
	*x = DimensionExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionExpression) ProtoMessage() {}

func (x *DimensionExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionExpression.ProtoReflect.Descriptor instead.
func (*DimensionExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{3}
}

func (m *DimensionExpression) GetOneExpression() isDimensionExpression_OneExpression {
	if m != nil {
		return m.OneExpression
	}
	return nil
}

func (x *DimensionExpression) GetLowerCase() *DimensionExpression_CaseExpression {
	if x, ok := x.GetOneExpression().(*DimensionExpression_LowerCase); ok {
		return x.LowerCase
	}
	return nil
}

func (x *DimensionExpression) GetUpperCase() *DimensionExpression_CaseExpression {
	if x, ok := x.GetOneExpression().(*DimensionExpression_UpperCase); ok {
		return x.UpperCase
	}
	return nil
}

func (x *DimensionExpression) GetConcatenate() *DimensionExpression_ConcatenateExpression {
	if x, ok := x.GetOneExpression().(*DimensionExpression_Concatenate); ok {
		return x.Concatenate
	}
	return nil
}

type isDimensionExpression_OneExpression interface {
	isDimensionExpression_OneExpression()
}

type DimensionExpression_LowerCase struct {
	// Used to convert a dimension value to lower case.
	LowerCase *DimensionExpression_CaseExpression `protobuf:"bytes,4,opt,name=lower_case,json=lowerCase,proto3,oneof"`
}

type DimensionExpression_UpperCase struct {
	// Used to convert a dimension value to upper case.
	UpperCase *DimensionExpression_CaseExpression `protobuf:"bytes,5,opt,name=upper_case,json=upperCase,proto3,oneof"`
}

type DimensionExpression_Concatenate struct {
	// Used to combine dimension values to a single dimension.
	// For example, dimension "country, city": concatenate(country, ", ", city).
	Concatenate *DimensionExpression_ConcatenateExpression `protobuf:"bytes,6,opt,name=concatenate,proto3,oneof"`
}

func (*DimensionExpression_LowerCase) isDimensionExpression_OneExpression() {}

func (*DimensionExpression_UpperCase) isDimensionExpression_OneExpression() {}

func (*DimensionExpression_Concatenate) isDimensionExpression_OneExpression() {}

// The quantitative measurements of a report. For example, the metric
// `eventCount` is the total number of events. Requests are allowed up to 10
// metrics.
type Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the metric. See the [API
	// Metrics](https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#metrics)
	// for the list of metric names.
	//
	// If `expression` is specified, `name` can be any string that you would like
	// within the allowed character set. For example if `expression` is
	// `screenPageViews/sessions`, you could call that metric's name =
	// `viewsPerSession`. Metric names that you choose must match the regular
	// expression `^[a-zA-Z0-9_]$`.
	//
	// Metrics are referenced by `name` in `metricFilter`, `orderBys`, and metric
	// `expression`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A mathematical expression for derived metrics. For example, the metric
	// Event count per user is `eventCount/totalUsers`.
	Expression string `protobuf:"bytes,2,opt,name=expression,proto3" json:"expression,omitempty"`
	// Indicates if a metric is invisible in the report response. If a metric is
	// invisible, the metric will not produce a column in the response, but can be
	// used in `metricFilter`, `orderBys`, or a metric `expression`.
	Invisible bool `protobuf:"varint,3,opt,name=invisible,proto3" json:"invisible,omitempty"`
}

func (x *Metric) Reset() {
	*x = Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metric.ProtoReflect.Descriptor instead.
func (*Metric) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{4}
}

func (x *Metric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Metric) GetExpression() string {
	if x != nil {
		return x.Expression
	}
	return ""
}

func (x *Metric) GetInvisible() bool {
	if x != nil {
		return x.Invisible
	}
	return false
}

// To express dimension or metric filters.
// The fields in the same FilterExpression need to be either all dimensions or
// all metrics.
type FilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of filter expression for `FilterExpression`.
	//
	// Types that are assignable to Expr:
	//	*FilterExpression_AndGroup
	//	*FilterExpression_OrGroup
	//	*FilterExpression_NotExpression
	//	*FilterExpression_Filter
	Expr isFilterExpression_Expr `protobuf_oneof:"expr"`
}

func (x *FilterExpression) Reset() {
	*x = FilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterExpression) ProtoMessage() {}

func (x *FilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterExpression.ProtoReflect.Descriptor instead.
func (*FilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{5}
}

func (m *FilterExpression) GetExpr() isFilterExpression_Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (x *FilterExpression) GetAndGroup() *FilterExpressionList {
	if x, ok := x.GetExpr().(*FilterExpression_AndGroup); ok {
		return x.AndGroup
	}
	return nil
}

func (x *FilterExpression) GetOrGroup() *FilterExpressionList {
	if x, ok := x.GetExpr().(*FilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *FilterExpression) GetNotExpression() *FilterExpression {
	if x, ok := x.GetExpr().(*FilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *FilterExpression) GetFilter() *Filter {
	if x, ok := x.GetExpr().(*FilterExpression_Filter); ok {
		return x.Filter
	}
	return nil
}

type isFilterExpression_Expr interface {
	isFilterExpression_Expr()
}

type FilterExpression_AndGroup struct {
	// The FilterExpressions in and_group have an AND relationship.
	AndGroup *FilterExpressionList `protobuf:"bytes,1,opt,name=and_group,json=andGroup,proto3,oneof"`
}

type FilterExpression_OrGroup struct {
	// The FilterExpressions in or_group have an OR relationship.
	OrGroup *FilterExpressionList `protobuf:"bytes,2,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type FilterExpression_NotExpression struct {
	// The FilterExpression is NOT of not_expression.
	NotExpression *FilterExpression `protobuf:"bytes,3,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type FilterExpression_Filter struct {
	// A primitive filter.
	// All fields in filter in same FilterExpression needs to be either all
	// dimensions or metrics.
	Filter *Filter `protobuf:"bytes,4,opt,name=filter,proto3,oneof"`
}

func (*FilterExpression_AndGroup) isFilterExpression_Expr() {}

func (*FilterExpression_OrGroup) isFilterExpression_Expr() {}

func (*FilterExpression_NotExpression) isFilterExpression_Expr() {}

func (*FilterExpression_Filter) isFilterExpression_Expr() {}

// A list of filter expressions.
type FilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of filter expressions.
	Expressions []*FilterExpression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *FilterExpressionList) Reset() {
	*x = FilterExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterExpressionList) ProtoMessage() {}

func (x *FilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterExpressionList.ProtoReflect.Descriptor instead.
func (*FilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{6}
}

func (x *FilterExpressionList) GetExpressions() []*FilterExpression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// An expression to filter dimension or metric values.
type Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension name or metric name. Must be a name defined in dimensions
	// or metrics.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Specify one type of filter for `Filter`.
	//
	// Types that are assignable to OneFilter:
	//	*Filter_StringFilter_
	//	*Filter_InListFilter_
	//	*Filter_NumericFilter_
	//	*Filter_BetweenFilter_
	OneFilter isFilter_OneFilter `protobuf_oneof:"one_filter"`
}

func (x *Filter) Reset() {
	*x = Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{7}
}

func (x *Filter) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (m *Filter) GetOneFilter() isFilter_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *Filter) GetStringFilter() *Filter_StringFilter {
	if x, ok := x.GetOneFilter().(*Filter_StringFilter_); ok {
		return x.StringFilter
	}
	return nil
}

func (x *Filter) GetInListFilter() *Filter_InListFilter {
	if x, ok := x.GetOneFilter().(*Filter_InListFilter_); ok {
		return x.InListFilter
	}
	return nil
}

func (x *Filter) GetNumericFilter() *Filter_NumericFilter {
	if x, ok := x.GetOneFilter().(*Filter_NumericFilter_); ok {
		return x.NumericFilter
	}
	return nil
}

func (x *Filter) GetBetweenFilter() *Filter_BetweenFilter {
	if x, ok := x.GetOneFilter().(*Filter_BetweenFilter_); ok {
		return x.BetweenFilter
	}
	return nil
}

type isFilter_OneFilter interface {
	isFilter_OneFilter()
}

type Filter_StringFilter_ struct {
	// Strings related filter.
	StringFilter *Filter_StringFilter `protobuf:"bytes,3,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

type Filter_InListFilter_ struct {
	// A filter for in list values.
	InListFilter *Filter_InListFilter `protobuf:"bytes,4,opt,name=in_list_filter,json=inListFilter,proto3,oneof"`
}

type Filter_NumericFilter_ struct {
	// A filter for numeric or date values.
	NumericFilter *Filter_NumericFilter `protobuf:"bytes,5,opt,name=numeric_filter,json=numericFilter,proto3,oneof"`
}

type Filter_BetweenFilter_ struct {
	// A filter for two values.
	BetweenFilter *Filter_BetweenFilter `protobuf:"bytes,6,opt,name=between_filter,json=betweenFilter,proto3,oneof"`
}

func (*Filter_StringFilter_) isFilter_OneFilter() {}

func (*Filter_InListFilter_) isFilter_OneFilter() {}

func (*Filter_NumericFilter_) isFilter_OneFilter() {}

func (*Filter_BetweenFilter_) isFilter_OneFilter() {}

// The sort options.
type OrderBy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of order by for `OrderBy`.
	//
	// Types that are assignable to OneOrderBy:
	//	*OrderBy_Metric
	//	*OrderBy_Dimension
	//	*OrderBy_Pivot
	OneOrderBy isOrderBy_OneOrderBy `protobuf_oneof:"one_order_by"`
	// If true, sorts by descending order.
	Desc bool `protobuf:"varint,4,opt,name=desc,proto3" json:"desc,omitempty"`
}

func (x *OrderBy) Reset() {
	*x = OrderBy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrderBy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrderBy) ProtoMessage() {}

func (x *OrderBy) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrderBy.ProtoReflect.Descriptor instead.
func (*OrderBy) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{8}
}

func (m *OrderBy) GetOneOrderBy() isOrderBy_OneOrderBy {
	if m != nil {
		return m.OneOrderBy
	}
	return nil
}

func (x *OrderBy) GetMetric() *OrderBy_MetricOrderBy {
	if x, ok := x.GetOneOrderBy().(*OrderBy_Metric); ok {
		return x.Metric
	}
	return nil
}

func (x *OrderBy) GetDimension() *OrderBy_DimensionOrderBy {
	if x, ok := x.GetOneOrderBy().(*OrderBy_Dimension); ok {
		return x.Dimension
	}
	return nil
}

func (x *OrderBy) GetPivot() *OrderBy_PivotOrderBy {
	if x, ok := x.GetOneOrderBy().(*OrderBy_Pivot); ok {
		return x.Pivot
	}
	return nil
}

func (x *OrderBy) GetDesc() bool {
	if x != nil {
		return x.Desc
	}
	return false
}

type isOrderBy_OneOrderBy interface {
	isOrderBy_OneOrderBy()
}

type OrderBy_Metric struct {
	// Sorts results by a metric's values.
	Metric *OrderBy_MetricOrderBy `protobuf:"bytes,1,opt,name=metric,proto3,oneof"`
}

type OrderBy_Dimension struct {
	// Sorts results by a dimension's values.
	Dimension *OrderBy_DimensionOrderBy `protobuf:"bytes,2,opt,name=dimension,proto3,oneof"`
}

type OrderBy_Pivot struct {
	// Sorts results by a metric's values within a pivot column group.
	Pivot *OrderBy_PivotOrderBy `protobuf:"bytes,3,opt,name=pivot,proto3,oneof"`
}

func (*OrderBy_Metric) isOrderBy_OneOrderBy() {}

func (*OrderBy_Dimension) isOrderBy_OneOrderBy() {}

func (*OrderBy_Pivot) isOrderBy_OneOrderBy() {}

// Describes the visible dimension columns and rows in the report response.
type Pivot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dimension names for visible columns in the report response. Including
	// "dateRange" produces a date range column; for each row in the response,
	// dimension values in the date range column will indicate the corresponding
	// date range from the request.
	FieldNames []string `protobuf:"bytes,1,rep,name=field_names,json=fieldNames,proto3" json:"field_names,omitempty"`
	// Specifies how dimensions are ordered in the pivot. In the first Pivot, the
	// OrderBys determine Row and PivotDimensionHeader ordering; in subsequent
	// Pivots, the OrderBys determine only PivotDimensionHeader ordering.
	// Dimensions specified in these OrderBys must be a subset of
	// Pivot.field_names.
	OrderBys []*OrderBy `protobuf:"bytes,2,rep,name=order_bys,json=orderBys,proto3" json:"order_bys,omitempty"`
	// The row count of the start row. The first row is counted as row 0.
	Offset int64 `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	// The number of unique combinations of dimension values to return in this
	// pivot. The `limit` parameter is required. A `limit` of 10,000 is common for
	// single pivot requests.
	//
	// The product of the `limit` for each `pivot` in a `RunPivotReportRequest`
	// must not exceed 100,000. For example, a two pivot request with `limit:
	// 1000` in each pivot will fail because the product is `1,000,000`.
	Limit int64 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// Aggregate the metrics by dimensions in this pivot using the specified
	// metric_aggregations.
	MetricAggregations []MetricAggregation `protobuf:"varint,5,rep,packed,name=metric_aggregations,json=metricAggregations,proto3,enum=google.analytics.data.v1beta.MetricAggregation" json:"metric_aggregations,omitempty"`
}

func (x *Pivot) Reset() {
	*x = Pivot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pivot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pivot) ProtoMessage() {}

func (x *Pivot) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pivot.ProtoReflect.Descriptor instead.
func (*Pivot) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{9}
}

func (x *Pivot) GetFieldNames() []string {
	if x != nil {
		return x.FieldNames
	}
	return nil
}

func (x *Pivot) GetOrderBys() []*OrderBy {
	if x != nil {
		return x.OrderBys
	}
	return nil
}

func (x *Pivot) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *Pivot) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *Pivot) GetMetricAggregations() []MetricAggregation {
	if x != nil {
		return x.MetricAggregations
	}
	return nil
}

// The specification of cohorts for a cohort report.
//
// Cohort reports create a time series of user retention for the cohort. For
// example, you could select the cohort of users that were acquired in the first
// week of September and follow that cohort for the next six weeks. Selecting
// the users acquired in the first week of September cohort is specified in the
// `cohort` object. Following that cohort for the next six weeks is specified in
// the `cohortsRange` object.
//
// For examples, see [Cohort Report
// Examples](https://developers.google.com/analytics/devguides/reporting/data/v1/advanced#cohort_report_examples).
//
// The report response could show a weekly time series where say your app has
// retained 60% of this cohort after three weeks and 25% of this cohort after
// six weeks. These two percentages can be calculated by the metric
// `cohortActiveUsers/cohortTotalUsers` and will be separate rows in the report.
type CohortSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the selection criteria to group users into cohorts.
	//
	// Most cohort reports define only a single cohort. If multiple cohorts are
	// specified, each cohort can be recognized in the report by their name.
	Cohorts []*Cohort `protobuf:"bytes,1,rep,name=cohorts,proto3" json:"cohorts,omitempty"`
	// Cohort reports follow cohorts over an extended reporting date range. This
	// range specifies an offset duration to follow the cohorts over.
	CohortsRange *CohortsRange `protobuf:"bytes,2,opt,name=cohorts_range,json=cohortsRange,proto3" json:"cohorts_range,omitempty"`
	// Optional settings for a cohort report.
	CohortReportSettings *CohortReportSettings `protobuf:"bytes,3,opt,name=cohort_report_settings,json=cohortReportSettings,proto3" json:"cohort_report_settings,omitempty"`
}

func (x *CohortSpec) Reset() {
	*x = CohortSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CohortSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CohortSpec) ProtoMessage() {}

func (x *CohortSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CohortSpec.ProtoReflect.Descriptor instead.
func (*CohortSpec) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{10}
}

func (x *CohortSpec) GetCohorts() []*Cohort {
	if x != nil {
		return x.Cohorts
	}
	return nil
}

func (x *CohortSpec) GetCohortsRange() *CohortsRange {
	if x != nil {
		return x.CohortsRange
	}
	return nil
}

func (x *CohortSpec) GetCohortReportSettings() *CohortReportSettings {
	if x != nil {
		return x.CohortReportSettings
	}
	return nil
}

// Defines a cohort selection criteria. A cohort is a group of users who share
// a common characteristic. For example, users with the same `firstSessionDate`
// belong to the same cohort.
type Cohort struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Assigns a name to this cohort. The dimension `cohort` is valued to this
	// name in a report response. If set, cannot begin with `cohort_` or
	// `RESERVED_`. If not set, cohorts are named by their zero based index
	// `cohort_0`, `cohort_1`, etc.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Dimension used by the cohort. Required and only supports
	// `firstSessionDate`.
	Dimension string `protobuf:"bytes,2,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// The cohort selects users whose first touch date is between start date and
	// end date defined in the `dateRange`. This `dateRange` does not specify the
	// full date range of event data that is present in a cohort report. In a
	// cohort report, this `dateRange` is extended by the granularity and offset
	// present in the `cohortsRange`; event data for the extended reporting date
	// range is present in a cohort report.
	//
	// In a cohort request, this `dateRange` is required and the `dateRanges` in
	// the `RunReportRequest` or `RunPivotReportRequest` must be unspecified.
	//
	// This `dateRange` should generally be aligned with the cohort's granularity.
	// If `CohortsRange` uses daily granularity, this `dateRange` can be a single
	// day. If `CohortsRange` uses weekly granularity, this `dateRange` can be
	// aligned to a week boundary, starting at Sunday and ending Saturday. If
	// `CohortsRange` uses monthly granularity, this `dateRange` can be aligned to
	// a month, starting at the first and ending on the last day of the month.
	DateRange *DateRange `protobuf:"bytes,3,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
}

func (x *Cohort) Reset() {
	*x = Cohort{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cohort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cohort) ProtoMessage() {}

func (x *Cohort) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cohort.ProtoReflect.Descriptor instead.
func (*Cohort) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{11}
}

func (x *Cohort) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cohort) GetDimension() string {
	if x != nil {
		return x.Dimension
	}
	return ""
}

func (x *Cohort) GetDateRange() *DateRange {
	if x != nil {
		return x.DateRange
	}
	return nil
}

// Configures the extended reporting date range for a cohort report. Specifies
// an offset duration to follow the cohorts over.
type CohortsRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The granularity used to interpret the `startOffset` and
	// `endOffset` for the extended reporting date range for a cohort report.
	Granularity CohortsRange_Granularity `protobuf:"varint,1,opt,name=granularity,proto3,enum=google.analytics.data.v1beta.CohortsRange_Granularity" json:"granularity,omitempty"`
	// `startOffset` specifies the start date of the extended reporting date range
	// for a cohort report. `startOffset` is commonly set to 0 so that reports
	// contain data from the acquisition of the cohort forward.
	//
	// If `granularity` is `DAILY`, the `startDate` of the extended reporting date
	// range is `startDate` of the cohort plus `startOffset` days.
	//
	// If `granularity` is `WEEKLY`, the `startDate` of the extended reporting
	// date range is `startDate` of the cohort plus `startOffset * 7` days.
	//
	// If `granularity` is `MONTHLY`, the `startDate` of the extended reporting
	// date range is `startDate` of the cohort plus `startOffset * 30` days.
	StartOffset int32 `protobuf:"varint,2,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Required. `endOffset` specifies the end date of the extended reporting date
	// range for a cohort report. `endOffset` can be any positive integer but is
	// commonly set to 5 to 10 so that reports contain data on the cohort for the
	// next several granularity time periods.
	//
	// If `granularity` is `DAILY`, the `endDate` of the extended reporting date
	// range is `endDate` of the cohort plus `endOffset` days.
	//
	// If `granularity` is `WEEKLY`, the `endDate` of the extended reporting date
	// range is `endDate` of the cohort plus `endOffset * 7` days.
	//
	// If `granularity` is `MONTHLY`, the `endDate` of the extended reporting date
	// range is `endDate` of the cohort plus `endOffset * 30` days.
	EndOffset int32 `protobuf:"varint,3,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
}

func (x *CohortsRange) Reset() {
	*x = CohortsRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CohortsRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CohortsRange) ProtoMessage() {}

func (x *CohortsRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CohortsRange.ProtoReflect.Descriptor instead.
func (*CohortsRange) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{12}
}

func (x *CohortsRange) GetGranularity() CohortsRange_Granularity {
	if x != nil {
		return x.Granularity
	}
	return CohortsRange_GRANULARITY_UNSPECIFIED
}

func (x *CohortsRange) GetStartOffset() int32 {
	if x != nil {
		return x.StartOffset
	}
	return 0
}

func (x *CohortsRange) GetEndOffset() int32 {
	if x != nil {
		return x.EndOffset
	}
	return 0
}

// Optional settings of a cohort report.
type CohortReportSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, accumulates the result from first touch day to the end day. Not
	// supported in `RunReportRequest`.
	Accumulate bool `protobuf:"varint,1,opt,name=accumulate,proto3" json:"accumulate,omitempty"`
}

func (x *CohortReportSettings) Reset() {
	*x = CohortReportSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CohortReportSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CohortReportSettings) ProtoMessage() {}

func (x *CohortReportSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CohortReportSettings.ProtoReflect.Descriptor instead.
func (*CohortReportSettings) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{13}
}

func (x *CohortReportSettings) GetAccumulate() bool {
	if x != nil {
		return x.Accumulate
	}
	return false
}

// Response's metadata carrying additional information about the report content.
type ResponseMetaData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, indicates some buckets of dimension combinations are rolled into
	// "(other)" row. This can happen for high cardinality reports.
	DataLossFromOtherRow bool `protobuf:"varint,3,opt,name=data_loss_from_other_row,json=dataLossFromOtherRow,proto3" json:"data_loss_from_other_row,omitempty"`
	// Describes the schema restrictions actively enforced in creating this
	// report. To learn more, see [Access and data-restriction
	// management](https://support.google.com/analytics/answer/10851388).
	SchemaRestrictionResponse *ResponseMetaData_SchemaRestrictionResponse `protobuf:"bytes,4,opt,name=schema_restriction_response,json=schemaRestrictionResponse,proto3,oneof" json:"schema_restriction_response,omitempty"`
	// The currency code used in this report. Intended to be used in formatting
	// currency metrics like `purchaseRevenue` for visualization. If currency_code
	// was specified in the request, this response parameter will echo the request
	// parameter; otherwise, this response parameter is the property's current
	// currency_code.
	//
	// Currency codes are string encodings of currency types from the ISO 4217
	// standard (https://en.wikipedia.org/wiki/ISO_4217); for example "USD",
	// "EUR", "JPY". To learn more, see
	// https://support.google.com/analytics/answer/9796179.
	CurrencyCode *string `protobuf:"bytes,5,opt,name=currency_code,json=currencyCode,proto3,oneof" json:"currency_code,omitempty"`
	// The property's current timezone. Intended to be used to interpret
	// time-based dimensions like `hour` and `minute`. Formatted as strings from
	// the IANA Time Zone database (https://www.iana.org/time-zones); for example
	// "America/New_York" or "Asia/Tokyo".
	TimeZone *string `protobuf:"bytes,6,opt,name=time_zone,json=timeZone,proto3,oneof" json:"time_zone,omitempty"`
	// If empty reason is specified, the report is empty for this reason.
	EmptyReason *string `protobuf:"bytes,7,opt,name=empty_reason,json=emptyReason,proto3,oneof" json:"empty_reason,omitempty"`
}

func (x *ResponseMetaData) Reset() {
	*x = ResponseMetaData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMetaData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMetaData) ProtoMessage() {}

func (x *ResponseMetaData) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMetaData.ProtoReflect.Descriptor instead.
func (*ResponseMetaData) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{14}
}

func (x *ResponseMetaData) GetDataLossFromOtherRow() bool {
	if x != nil {
		return x.DataLossFromOtherRow
	}
	return false
}

func (x *ResponseMetaData) GetSchemaRestrictionResponse() *ResponseMetaData_SchemaRestrictionResponse {
	if x != nil {
		return x.SchemaRestrictionResponse
	}
	return nil
}

func (x *ResponseMetaData) GetCurrencyCode() string {
	if x != nil && x.CurrencyCode != nil {
		return *x.CurrencyCode
	}
	return ""
}

func (x *ResponseMetaData) GetTimeZone() string {
	if x != nil && x.TimeZone != nil {
		return *x.TimeZone
	}
	return ""
}

func (x *ResponseMetaData) GetEmptyReason() string {
	if x != nil && x.EmptyReason != nil {
		return *x.EmptyReason
	}
	return ""
}

// Describes a dimension column in the report. Dimensions requested in a report
// produce column entries within rows and DimensionHeaders. However, dimensions
// used exclusively within filters or expressions do not produce columns in a
// report; correspondingly, those dimensions do not produce headers.
type DimensionHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DimensionHeader) Reset() {
	*x = DimensionHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionHeader) ProtoMessage() {}

func (x *DimensionHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionHeader.ProtoReflect.Descriptor instead.
func (*DimensionHeader) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{15}
}

func (x *DimensionHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Describes a metric column in the report. Visible metrics requested in a
// report produce column entries within rows and MetricHeaders. However,
// metrics used exclusively within filters or expressions do not produce columns
// in a report; correspondingly, those metrics do not produce headers.
type MetricHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metric's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The metric's data type.
	Type MetricType `protobuf:"varint,2,opt,name=type,proto3,enum=google.analytics.data.v1beta.MetricType" json:"type,omitempty"`
}

func (x *MetricHeader) Reset() {
	*x = MetricHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricHeader) ProtoMessage() {}

func (x *MetricHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricHeader.ProtoReflect.Descriptor instead.
func (*MetricHeader) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{16}
}

func (x *MetricHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetricHeader) GetType() MetricType {
	if x != nil {
		return x.Type
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

// Dimensions' values in a single pivot.
type PivotHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The size is the same as the cardinality of the corresponding dimension
	// combinations.
	PivotDimensionHeaders []*PivotDimensionHeader `protobuf:"bytes,1,rep,name=pivot_dimension_headers,json=pivotDimensionHeaders,proto3" json:"pivot_dimension_headers,omitempty"`
	// The cardinality of the pivot. The total number of rows for this pivot's
	// fields regardless of how the parameters `offset` and `limit` are specified
	// in the request.
	RowCount int32 `protobuf:"varint,2,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
}

func (x *PivotHeader) Reset() {
	*x = PivotHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PivotHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PivotHeader) ProtoMessage() {}

func (x *PivotHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PivotHeader.ProtoReflect.Descriptor instead.
func (*PivotHeader) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{17}
}

func (x *PivotHeader) GetPivotDimensionHeaders() []*PivotDimensionHeader {
	if x != nil {
		return x.PivotDimensionHeaders
	}
	return nil
}

func (x *PivotHeader) GetRowCount() int32 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

// Summarizes dimension values from a row for this pivot.
type PivotDimensionHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Values of multiple dimensions in a pivot.
	DimensionValues []*DimensionValue `protobuf:"bytes,1,rep,name=dimension_values,json=dimensionValues,proto3" json:"dimension_values,omitempty"`
}

func (x *PivotDimensionHeader) Reset() {
	*x = PivotDimensionHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PivotDimensionHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PivotDimensionHeader) ProtoMessage() {}

func (x *PivotDimensionHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PivotDimensionHeader.ProtoReflect.Descriptor instead.
func (*PivotDimensionHeader) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{18}
}

func (x *PivotDimensionHeader) GetDimensionValues() []*DimensionValue {
	if x != nil {
		return x.DimensionValues
	}
	return nil
}

// Report data for each row.
// For example if RunReportRequest contains:
//
// ```none
// "dimensions": [
//
//	{
//	  "name": "eventName"
//	},
//	{
//	  "name": "countryId"
//	}
//
// ],
// "metrics": [
//
//	{
//	  "name": "eventCount"
//	}
//
// ]
// ```
//
// One row with 'in_app_purchase' as the eventName, 'JP' as the countryId, and
// 15 as the eventCount, would be:
//
// ```none
// "dimensionValues": [
//
//	{
//	  "value": "in_app_purchase"
//	},
//	{
//	  "value": "JP"
//	}
//
// ],
// "metricValues": [
//
//	{
//	  "value": "15"
//	}
//
// ]
// ```
type Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of requested dimension values. In a PivotReport, dimension_values
	// are only listed for dimensions included in a pivot.
	DimensionValues []*DimensionValue `protobuf:"bytes,1,rep,name=dimension_values,json=dimensionValues,proto3" json:"dimension_values,omitempty"`
	// List of requested visible metric values.
	MetricValues []*MetricValue `protobuf:"bytes,2,rep,name=metric_values,json=metricValues,proto3" json:"metric_values,omitempty"`
}

func (x *Row) Reset() {
	*x = Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Row.ProtoReflect.Descriptor instead.
func (*Row) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{19}
}

func (x *Row) GetDimensionValues() []*DimensionValue {
	if x != nil {
		return x.DimensionValues
	}
	return nil
}

func (x *Row) GetMetricValues() []*MetricValue {
	if x != nil {
		return x.MetricValues
	}
	return nil
}

// The value of a dimension.
type DimensionValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One kind of dimension value
	//
	// Types that are assignable to OneValue:
	//	*DimensionValue_Value
	OneValue isDimensionValue_OneValue `protobuf_oneof:"one_value"`
}

func (x *DimensionValue) Reset() {
	*x = DimensionValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionValue) ProtoMessage() {}

func (x *DimensionValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionValue.ProtoReflect.Descriptor instead.
func (*DimensionValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{20}
}

func (m *DimensionValue) GetOneValue() isDimensionValue_OneValue {
	if m != nil {
		return m.OneValue
	}
	return nil
}

func (x *DimensionValue) GetValue() string {
	if x, ok := x.GetOneValue().(*DimensionValue_Value); ok {
		return x.Value
	}
	return ""
}

type isDimensionValue_OneValue interface {
	isDimensionValue_OneValue()
}

type DimensionValue_Value struct {
	// Value as a string if the dimension type is a string.
	Value string `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

func (*DimensionValue_Value) isDimensionValue_OneValue() {}

// The value of a metric.
type MetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of metric value
	//
	// Types that are assignable to OneValue:
	//	*MetricValue_Value
	OneValue isMetricValue_OneValue `protobuf_oneof:"one_value"`
}

func (x *MetricValue) Reset() {
	*x = MetricValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricValue) ProtoMessage() {}

func (x *MetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricValue.ProtoReflect.Descriptor instead.
func (*MetricValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{21}
}

func (m *MetricValue) GetOneValue() isMetricValue_OneValue {
	if m != nil {
		return m.OneValue
	}
	return nil
}

func (x *MetricValue) GetValue() string {
	if x, ok := x.GetOneValue().(*MetricValue_Value); ok {
		return x.Value
	}
	return ""
}

type isMetricValue_OneValue interface {
	isMetricValue_OneValue()
}

type MetricValue_Value struct {
	// Measurement value. See MetricHeader for type.
	Value string `protobuf:"bytes,4,opt,name=value,proto3,oneof"`
}

func (*MetricValue_Value) isMetricValue_OneValue() {}

// To represent a number.
type NumericValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of a numeric value
	//
	// Types that are assignable to OneValue:
	//	*NumericValue_Int64Value
	//	*NumericValue_DoubleValue
	OneValue isNumericValue_OneValue `protobuf_oneof:"one_value"`
}

func (x *NumericValue) Reset() {
	*x = NumericValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NumericValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NumericValue) ProtoMessage() {}

func (x *NumericValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NumericValue.ProtoReflect.Descriptor instead.
func (*NumericValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{22}
}

func (m *NumericValue) GetOneValue() isNumericValue_OneValue {
	if m != nil {
		return m.OneValue
	}
	return nil
}

func (x *NumericValue) GetInt64Value() int64 {
	if x, ok := x.GetOneValue().(*NumericValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *NumericValue) GetDoubleValue() float64 {
	if x, ok := x.GetOneValue().(*NumericValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

type isNumericValue_OneValue interface {
	isNumericValue_OneValue()
}

type NumericValue_Int64Value struct {
	// Integer value
	Int64Value int64 `protobuf:"varint,1,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type NumericValue_DoubleValue struct {
	// Double value
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*NumericValue_Int64Value) isNumericValue_OneValue() {}

func (*NumericValue_DoubleValue) isNumericValue_OneValue() {}

// Current state of all quotas for this Analytics Property. If any quota for a
// property is exhausted, all requests to that property will return Resource
// Exhausted errors.
type PropertyQuota struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Standard Analytics Properties can use up to 25,000 tokens per day;
	// Analytics 360 Properties can use 250,000 tokens per day. Most requests
	// consume fewer than 10 tokens.
	TokensPerDay *QuotaStatus `protobuf:"bytes,1,opt,name=tokens_per_day,json=tokensPerDay,proto3" json:"tokens_per_day,omitempty"`
	// Standard Analytics Properties can use up to 5,000 tokens per hour;
	// Analytics 360 Properties can use 50,000 tokens per hour. An API request
	// consumes a single number of tokens, and that number is deducted from both
	// the hourly and daily quotas.
	TokensPerHour *QuotaStatus `protobuf:"bytes,2,opt,name=tokens_per_hour,json=tokensPerHour,proto3" json:"tokens_per_hour,omitempty"`
	// Standard Analytics Properties can send up to 10 concurrent requests;
	// Analytics 360 Properties can use up to 50 concurrent requests.
	ConcurrentRequests *QuotaStatus `protobuf:"bytes,3,opt,name=concurrent_requests,json=concurrentRequests,proto3" json:"concurrent_requests,omitempty"`
	// Standard Analytics Properties and cloud project pairs can have up to 10
	// server errors per hour; Analytics 360 Properties and cloud project pairs
	// can have up to 50 server errors per hour.
	ServerErrorsPerProjectPerHour *QuotaStatus `protobuf:"bytes,4,opt,name=server_errors_per_project_per_hour,json=serverErrorsPerProjectPerHour,proto3" json:"server_errors_per_project_per_hour,omitempty"`
	// Analytics Properties can send up to 120 requests with potentially
	// thresholded dimensions per hour. In a batch request, each report request
	// is individually counted for this quota if the request contains potentially
	// thresholded dimensions.
	PotentiallyThresholdedRequestsPerHour *QuotaStatus `protobuf:"bytes,5,opt,name=potentially_thresholded_requests_per_hour,json=potentiallyThresholdedRequestsPerHour,proto3" json:"potentially_thresholded_requests_per_hour,omitempty"`
}

func (x *PropertyQuota) Reset() {
	*x = PropertyQuota{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyQuota) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyQuota) ProtoMessage() {}

func (x *PropertyQuota) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyQuota.ProtoReflect.Descriptor instead.
func (*PropertyQuota) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{23}
}

func (x *PropertyQuota) GetTokensPerDay() *QuotaStatus {
	if x != nil {
		return x.TokensPerDay
	}
	return nil
}

func (x *PropertyQuota) GetTokensPerHour() *QuotaStatus {
	if x != nil {
		return x.TokensPerHour
	}
	return nil
}

func (x *PropertyQuota) GetConcurrentRequests() *QuotaStatus {
	if x != nil {
		return x.ConcurrentRequests
	}
	return nil
}

func (x *PropertyQuota) GetServerErrorsPerProjectPerHour() *QuotaStatus {
	if x != nil {
		return x.ServerErrorsPerProjectPerHour
	}
	return nil
}

func (x *PropertyQuota) GetPotentiallyThresholdedRequestsPerHour() *QuotaStatus {
	if x != nil {
		return x.PotentiallyThresholdedRequestsPerHour
	}
	return nil
}

// Current state for a particular quota group.
type QuotaStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Quota consumed by this request.
	Consumed int32 `protobuf:"varint,1,opt,name=consumed,proto3" json:"consumed,omitempty"`
	// Quota remaining after this request.
	Remaining int32 `protobuf:"varint,2,opt,name=remaining,proto3" json:"remaining,omitempty"`
}

func (x *QuotaStatus) Reset() {
	*x = QuotaStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuotaStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaStatus) ProtoMessage() {}

func (x *QuotaStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaStatus.ProtoReflect.Descriptor instead.
func (*QuotaStatus) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{24}
}

func (x *QuotaStatus) GetConsumed() int32 {
	if x != nil {
		return x.Consumed
	}
	return 0
}

func (x *QuotaStatus) GetRemaining() int32 {
	if x != nil {
		return x.Remaining
	}
	return 0
}

// Explains a dimension.
type DimensionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This dimension's name. Useable in [Dimension](#Dimension)'s `name`. For
	// example, `eventName`.
	ApiName string `protobuf:"bytes,1,opt,name=api_name,json=apiName,proto3" json:"api_name,omitempty"`
	// This dimension's name within the Google Analytics user interface. For
	// example, `Event name`.
	UiName string `protobuf:"bytes,2,opt,name=ui_name,json=uiName,proto3" json:"ui_name,omitempty"`
	// Description of how this dimension is used and calculated.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Still usable but deprecated names for this dimension. If populated, this
	// dimension is available by either `apiName` or one of `deprecatedApiNames`
	// for a period of time. After the deprecation period, the dimension will be
	// available only by `apiName`.
	DeprecatedApiNames []string `protobuf:"bytes,4,rep,name=deprecated_api_names,json=deprecatedApiNames,proto3" json:"deprecated_api_names,omitempty"`
	// True if the dimension is a custom dimension for this property.
	CustomDefinition bool `protobuf:"varint,5,opt,name=custom_definition,json=customDefinition,proto3" json:"custom_definition,omitempty"`
	// The display name of the category that this dimension belongs to. Similar
	// dimensions and metrics are categorized together.
	Category string `protobuf:"bytes,7,opt,name=category,proto3" json:"category,omitempty"`
}

func (x *DimensionMetadata) Reset() {
	*x = DimensionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionMetadata) ProtoMessage() {}

func (x *DimensionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionMetadata.ProtoReflect.Descriptor instead.
func (*DimensionMetadata) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{25}
}

func (x *DimensionMetadata) GetApiName() string {
	if x != nil {
		return x.ApiName
	}
	return ""
}

func (x *DimensionMetadata) GetUiName() string {
	if x != nil {
		return x.UiName
	}
	return ""
}

func (x *DimensionMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DimensionMetadata) GetDeprecatedApiNames() []string {
	if x != nil {
		return x.DeprecatedApiNames
	}
	return nil
}

func (x *DimensionMetadata) GetCustomDefinition() bool {
	if x != nil {
		return x.CustomDefinition
	}
	return false
}

func (x *DimensionMetadata) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

// Explains a metric.
type MetricMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A metric name. Useable in [Metric](#Metric)'s `name`. For example,
	// `eventCount`.
	ApiName string `protobuf:"bytes,1,opt,name=api_name,json=apiName,proto3" json:"api_name,omitempty"`
	// This metric's name within the Google Analytics user interface. For example,
	// `Event count`.
	UiName string `protobuf:"bytes,2,opt,name=ui_name,json=uiName,proto3" json:"ui_name,omitempty"`
	// Description of how this metric is used and calculated.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Still usable but deprecated names for this metric. If populated, this
	// metric is available by either `apiName` or one of `deprecatedApiNames`
	// for a period of time. After the deprecation period, the metric will be
	// available only by `apiName`.
	DeprecatedApiNames []string `protobuf:"bytes,4,rep,name=deprecated_api_names,json=deprecatedApiNames,proto3" json:"deprecated_api_names,omitempty"`
	// The type of this metric.
	Type MetricType `protobuf:"varint,5,opt,name=type,proto3,enum=google.analytics.data.v1beta.MetricType" json:"type,omitempty"`
	// The mathematical expression for this derived metric. Can be used in
	// [Metric](#Metric)'s `expression` field for equivalent reports. Most metrics
	// are not expressions, and for non-expressions, this field is empty.
	Expression string `protobuf:"bytes,6,opt,name=expression,proto3" json:"expression,omitempty"`
	// True if the metric is a custom metric for this property.
	CustomDefinition bool `protobuf:"varint,7,opt,name=custom_definition,json=customDefinition,proto3" json:"custom_definition,omitempty"`
	// If reasons are specified, your access is blocked to this metric for this
	// property. API requests from you to this property for this metric will
	// succeed; however, the report will contain only zeros for this metric. API
	// requests with metric filters on blocked metrics will fail. If reasons are
	// empty, you have access to this metric.
	//
	// To learn more, see [Access and data-restriction
	// management](https://support.google.com/analytics/answer/10851388).
	BlockedReasons []MetricMetadata_BlockedReason `protobuf:"varint,8,rep,packed,name=blocked_reasons,json=blockedReasons,proto3,enum=google.analytics.data.v1beta.MetricMetadata_BlockedReason" json:"blocked_reasons,omitempty"`
	// The display name of the category that this metrics belongs to. Similar
	// dimensions and metrics are categorized together.
	Category string `protobuf:"bytes,10,opt,name=category,proto3" json:"category,omitempty"`
}

func (x *MetricMetadata) Reset() {
	*x = MetricMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricMetadata) ProtoMessage() {}

func (x *MetricMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricMetadata.ProtoReflect.Descriptor instead.
func (*MetricMetadata) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{26}
}

func (x *MetricMetadata) GetApiName() string {
	if x != nil {
		return x.ApiName
	}
	return ""
}

func (x *MetricMetadata) GetUiName() string {
	if x != nil {
		return x.UiName
	}
	return ""
}

func (x *MetricMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MetricMetadata) GetDeprecatedApiNames() []string {
	if x != nil {
		return x.DeprecatedApiNames
	}
	return nil
}

func (x *MetricMetadata) GetType() MetricType {
	if x != nil {
		return x.Type
	}
	return MetricType_METRIC_TYPE_UNSPECIFIED
}

func (x *MetricMetadata) GetExpression() string {
	if x != nil {
		return x.Expression
	}
	return ""
}

func (x *MetricMetadata) GetCustomDefinition() bool {
	if x != nil {
		return x.CustomDefinition
	}
	return false
}

func (x *MetricMetadata) GetBlockedReasons() []MetricMetadata_BlockedReason {
	if x != nil {
		return x.BlockedReasons
	}
	return nil
}

func (x *MetricMetadata) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

// The compatibility for a single dimension.
type DimensionCompatibility struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension metadata contains the API name for this compatibility
	// information. The dimension metadata also contains other helpful information
	// like the UI name and description.
	DimensionMetadata *DimensionMetadata `protobuf:"bytes,1,opt,name=dimension_metadata,json=dimensionMetadata,proto3,oneof" json:"dimension_metadata,omitempty"`
	// The compatibility of this dimension. If the compatibility is COMPATIBLE,
	// this dimension can be successfully added to the report.
	Compatibility *Compatibility `protobuf:"varint,2,opt,name=compatibility,proto3,enum=google.analytics.data.v1beta.Compatibility,oneof" json:"compatibility,omitempty"`
}

func (x *DimensionCompatibility) Reset() {
	*x = DimensionCompatibility{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionCompatibility) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionCompatibility) ProtoMessage() {}

func (x *DimensionCompatibility) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionCompatibility.ProtoReflect.Descriptor instead.
func (*DimensionCompatibility) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{27}
}

func (x *DimensionCompatibility) GetDimensionMetadata() *DimensionMetadata {
	if x != nil {
		return x.DimensionMetadata
	}
	return nil
}

func (x *DimensionCompatibility) GetCompatibility() Compatibility {
	if x != nil && x.Compatibility != nil {
		return *x.Compatibility
	}
	return Compatibility_COMPATIBILITY_UNSPECIFIED
}

// The compatibility for a single metric.
type MetricCompatibility struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metric metadata contains the API name for this compatibility
	// information. The metric metadata also contains other helpful information
	// like the UI name and description.
	MetricMetadata *MetricMetadata `protobuf:"bytes,1,opt,name=metric_metadata,json=metricMetadata,proto3,oneof" json:"metric_metadata,omitempty"`
	// The compatibility of this metric. If the compatibility is COMPATIBLE,
	// this metric can be successfully added to the report.
	Compatibility *Compatibility `protobuf:"varint,2,opt,name=compatibility,proto3,enum=google.analytics.data.v1beta.Compatibility,oneof" json:"compatibility,omitempty"`
}

func (x *MetricCompatibility) Reset() {
	*x = MetricCompatibility{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricCompatibility) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricCompatibility) ProtoMessage() {}

func (x *MetricCompatibility) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricCompatibility.ProtoReflect.Descriptor instead.
func (*MetricCompatibility) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{28}
}

func (x *MetricCompatibility) GetMetricMetadata() *MetricMetadata {
	if x != nil {
		return x.MetricMetadata
	}
	return nil
}

func (x *MetricCompatibility) GetCompatibility() Compatibility {
	if x != nil && x.Compatibility != nil {
		return *x.Compatibility
	}
	return Compatibility_COMPATIBILITY_UNSPECIFIED
}

// Used to convert a dimension value to a single case.
type DimensionExpression_CaseExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a dimension. The name must refer back to a name in dimensions
	// field of the request.
	DimensionName string `protobuf:"bytes,1,opt,name=dimension_name,json=dimensionName,proto3" json:"dimension_name,omitempty"`
}

func (x *DimensionExpression_CaseExpression) Reset() {
	*x = DimensionExpression_CaseExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionExpression_CaseExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionExpression_CaseExpression) ProtoMessage() {}

func (x *DimensionExpression_CaseExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionExpression_CaseExpression.ProtoReflect.Descriptor instead.
func (*DimensionExpression_CaseExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{3, 0}
}

func (x *DimensionExpression_CaseExpression) GetDimensionName() string {
	if x != nil {
		return x.DimensionName
	}
	return ""
}

// Used to combine dimension values to a single dimension.
type DimensionExpression_ConcatenateExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Names of dimensions. The names must refer back to names in the dimensions
	// field of the request.
	DimensionNames []string `protobuf:"bytes,1,rep,name=dimension_names,json=dimensionNames,proto3" json:"dimension_names,omitempty"`
	// The delimiter placed between dimension names.
	//
	// Delimiters are often single characters such as "|" or "," but can be
	// longer strings. If a dimension value contains the delimiter, both will be
	// present in response with no distinction. For example if dimension 1 value
	// = "US,FR", dimension 2 value = "JP", and delimiter = ",", then the
	// response will contain "US,FR,JP".
	Delimiter string `protobuf:"bytes,2,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
}

func (x *DimensionExpression_ConcatenateExpression) Reset() {
	*x = DimensionExpression_ConcatenateExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DimensionExpression_ConcatenateExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionExpression_ConcatenateExpression) ProtoMessage() {}

func (x *DimensionExpression_ConcatenateExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionExpression_ConcatenateExpression.ProtoReflect.Descriptor instead.
func (*DimensionExpression_ConcatenateExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{3, 1}
}

func (x *DimensionExpression_ConcatenateExpression) GetDimensionNames() []string {
	if x != nil {
		return x.DimensionNames
	}
	return nil
}

func (x *DimensionExpression_ConcatenateExpression) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

// The filter for string
type Filter_StringFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The match type for this filter.
	MatchType Filter_StringFilter_MatchType `protobuf:"varint,1,opt,name=match_type,json=matchType,proto3,enum=google.analytics.data.v1beta.Filter_StringFilter_MatchType" json:"match_type,omitempty"`
	// The string value used for the matching.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// If true, the string value is case sensitive.
	CaseSensitive bool `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *Filter_StringFilter) Reset() {
	*x = Filter_StringFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter_StringFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter_StringFilter) ProtoMessage() {}

func (x *Filter_StringFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter_StringFilter.ProtoReflect.Descriptor instead.
func (*Filter_StringFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{7, 0}
}

func (x *Filter_StringFilter) GetMatchType() Filter_StringFilter_MatchType {
	if x != nil {
		return x.MatchType
	}
	return Filter_StringFilter_MATCH_TYPE_UNSPECIFIED
}

func (x *Filter_StringFilter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Filter_StringFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// The result needs to be in a list of string values.
type Filter_InListFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of string values.
	// Must be non-empty.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	// If true, the string value is case sensitive.
	CaseSensitive bool `protobuf:"varint,2,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *Filter_InListFilter) Reset() {
	*x = Filter_InListFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter_InListFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter_InListFilter) ProtoMessage() {}

func (x *Filter_InListFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter_InListFilter.ProtoReflect.Descriptor instead.
func (*Filter_InListFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{7, 1}
}

func (x *Filter_InListFilter) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *Filter_InListFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// Filters for numeric or date values.
type Filter_NumericFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation type for this filter.
	Operation Filter_NumericFilter_Operation `protobuf:"varint,1,opt,name=operation,proto3,enum=google.analytics.data.v1beta.Filter_NumericFilter_Operation" json:"operation,omitempty"`
	// A numeric value or a date value.
	Value *NumericValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Filter_NumericFilter) Reset() {
	*x = Filter_NumericFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter_NumericFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter_NumericFilter) ProtoMessage() {}

func (x *Filter_NumericFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter_NumericFilter.ProtoReflect.Descriptor instead.
func (*Filter_NumericFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{7, 2}
}

func (x *Filter_NumericFilter) GetOperation() Filter_NumericFilter_Operation {
	if x != nil {
		return x.Operation
	}
	return Filter_NumericFilter_OPERATION_UNSPECIFIED
}

func (x *Filter_NumericFilter) GetValue() *NumericValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// To express that the result needs to be between two numbers (inclusive).
type Filter_BetweenFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Begins with this number.
	FromValue *NumericValue `protobuf:"bytes,1,opt,name=from_value,json=fromValue,proto3" json:"from_value,omitempty"`
	// Ends with this number.
	ToValue *NumericValue `protobuf:"bytes,2,opt,name=to_value,json=toValue,proto3" json:"to_value,omitempty"`
}

func (x *Filter_BetweenFilter) Reset() {
	*x = Filter_BetweenFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter_BetweenFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter_BetweenFilter) ProtoMessage() {}

func (x *Filter_BetweenFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter_BetweenFilter.ProtoReflect.Descriptor instead.
func (*Filter_BetweenFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{7, 3}
}

func (x *Filter_BetweenFilter) GetFromValue() *NumericValue {
	if x != nil {
		return x.FromValue
	}
	return nil
}

func (x *Filter_BetweenFilter) GetToValue() *NumericValue {
	if x != nil {
		return x.ToValue
	}
	return nil
}

// Sorts by metric values.
type OrderBy_MetricOrderBy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A metric name in the request to order by.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
}

func (x *OrderBy_MetricOrderBy) Reset() {
	*x = OrderBy_MetricOrderBy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrderBy_MetricOrderBy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrderBy_MetricOrderBy) ProtoMessage() {}

func (x *OrderBy_MetricOrderBy) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrderBy_MetricOrderBy.ProtoReflect.Descriptor instead.
func (*OrderBy_MetricOrderBy) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{8, 0}
}

func (x *OrderBy_MetricOrderBy) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

// Sorts by dimension values.
type OrderBy_DimensionOrderBy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A dimension name in the request to order by.
	DimensionName string `protobuf:"bytes,1,opt,name=dimension_name,json=dimensionName,proto3" json:"dimension_name,omitempty"`
	// Controls the rule for dimension value ordering.
	OrderType OrderBy_DimensionOrderBy_OrderType `protobuf:"varint,2,opt,name=order_type,json=orderType,proto3,enum=google.analytics.data.v1beta.OrderBy_DimensionOrderBy_OrderType" json:"order_type,omitempty"`
}

func (x *OrderBy_DimensionOrderBy) Reset() {
	*x = OrderBy_DimensionOrderBy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrderBy_DimensionOrderBy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrderBy_DimensionOrderBy) ProtoMessage() {}

func (x *OrderBy_DimensionOrderBy) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrderBy_DimensionOrderBy.ProtoReflect.Descriptor instead.
func (*OrderBy_DimensionOrderBy) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{8, 1}
}

func (x *OrderBy_DimensionOrderBy) GetDimensionName() string {
	if x != nil {
		return x.DimensionName
	}
	return ""
}

func (x *OrderBy_DimensionOrderBy) GetOrderType() OrderBy_DimensionOrderBy_OrderType {
	if x != nil {
		return x.OrderType
	}
	return OrderBy_DimensionOrderBy_ORDER_TYPE_UNSPECIFIED
}

// Sorts by a pivot column group.
type OrderBy_PivotOrderBy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// In the response to order by, order rows by this column. Must be a metric
	// name from the request.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// Used to select a dimension name and value pivot. If multiple pivot
	// selections are given, the sort occurs on rows where all pivot selection
	// dimension name and value pairs match the row's dimension name and value
	// pair.
	PivotSelections []*OrderBy_PivotOrderBy_PivotSelection `protobuf:"bytes,2,rep,name=pivot_selections,json=pivotSelections,proto3" json:"pivot_selections,omitempty"`
}

func (x *OrderBy_PivotOrderBy) Reset() {
	*x = OrderBy_PivotOrderBy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrderBy_PivotOrderBy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrderBy_PivotOrderBy) ProtoMessage() {}

func (x *OrderBy_PivotOrderBy) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrderBy_PivotOrderBy.ProtoReflect.Descriptor instead.
func (*OrderBy_PivotOrderBy) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{8, 2}
}

func (x *OrderBy_PivotOrderBy) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

func (x *OrderBy_PivotOrderBy) GetPivotSelections() []*OrderBy_PivotOrderBy_PivotSelection {
	if x != nil {
		return x.PivotSelections
	}
	return nil
}

// A pair of dimension names and values. Rows with this dimension pivot pair
// are ordered by the metric's value.
//
// For example if pivots = {{"browser", "Chrome"}} and
// metric_name = "Sessions",
// then the rows will be sorted based on Sessions in Chrome.
//
//	---------|----------|----------------|----------|----------------
//	         |  Chrome  |    Chrome      |  Safari  |     Safari
//	---------|----------|----------------|----------|----------------
//	 Country | Sessions | Pages/Sessions | Sessions | Pages/Sessions
//	---------|----------|----------------|----------|----------------
//	    US   |    2     |       2        |     3    |        1
//	---------|----------|----------------|----------|----------------
//	  Canada |    3     |       1        |     4    |        1
//	---------|----------|----------------|----------|----------------
type OrderBy_PivotOrderBy_PivotSelection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Must be a dimension name from the request.
	DimensionName string `protobuf:"bytes,1,opt,name=dimension_name,json=dimensionName,proto3" json:"dimension_name,omitempty"`
	// Order by only when the named dimension is this value.
	DimensionValue string `protobuf:"bytes,2,opt,name=dimension_value,json=dimensionValue,proto3" json:"dimension_value,omitempty"`
}

func (x *OrderBy_PivotOrderBy_PivotSelection) Reset() {
	*x = OrderBy_PivotOrderBy_PivotSelection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrderBy_PivotOrderBy_PivotSelection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrderBy_PivotOrderBy_PivotSelection) ProtoMessage() {}

func (x *OrderBy_PivotOrderBy_PivotSelection) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrderBy_PivotOrderBy_PivotSelection.ProtoReflect.Descriptor instead.
func (*OrderBy_PivotOrderBy_PivotSelection) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{8, 2, 0}
}

func (x *OrderBy_PivotOrderBy_PivotSelection) GetDimensionName() string {
	if x != nil {
		return x.DimensionName
	}
	return ""
}

func (x *OrderBy_PivotOrderBy_PivotSelection) GetDimensionValue() string {
	if x != nil {
		return x.DimensionValue
	}
	return ""
}

// The schema restrictions actively enforced in creating this report. To learn
// more, see [Access and data-restriction
// management](https://support.google.com/analytics/answer/10851388).
type ResponseMetaData_SchemaRestrictionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All restrictions actively enforced in creating the report. For example,
	// `purchaseRevenue` always has the restriction type `REVENUE_DATA`.
	// However, this active response restriction is only populated if the user's
	// custom role disallows access to `REVENUE_DATA`.
	ActiveMetricRestrictions []*ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction `protobuf:"bytes,1,rep,name=active_metric_restrictions,json=activeMetricRestrictions,proto3" json:"active_metric_restrictions,omitempty"`
}

func (x *ResponseMetaData_SchemaRestrictionResponse) Reset() {
	*x = ResponseMetaData_SchemaRestrictionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMetaData_SchemaRestrictionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMetaData_SchemaRestrictionResponse) ProtoMessage() {}

func (x *ResponseMetaData_SchemaRestrictionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMetaData_SchemaRestrictionResponse.ProtoReflect.Descriptor instead.
func (*ResponseMetaData_SchemaRestrictionResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{14, 0}
}

func (x *ResponseMetaData_SchemaRestrictionResponse) GetActiveMetricRestrictions() []*ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction {
	if x != nil {
		return x.ActiveMetricRestrictions
	}
	return nil
}

// A metric actively restricted in creating the report.
type ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the restricted metric.
	MetricName *string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3,oneof" json:"metric_name,omitempty"`
	// The reason for this metric's restriction.
	RestrictedMetricTypes []RestrictedMetricType `protobuf:"varint,2,rep,packed,name=restricted_metric_types,json=restrictedMetricTypes,proto3,enum=google.analytics.data.v1beta.RestrictedMetricType" json:"restricted_metric_types,omitempty"`
}

func (x *ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction) Reset() {
	*x = ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction) ProtoMessage() {}

func (x *ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1beta_data_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction.ProtoReflect.Descriptor instead.
func (*ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1beta_data_proto_rawDescGZIP(), []int{14, 0, 0}
}

func (x *ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction) GetMetricName() string {
	if x != nil && x.MetricName != nil {
		return *x.MetricName
	}
	return ""
}

func (x *ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction) GetRestrictedMetricTypes() []RestrictedMetricType {
	if x != nil {
		return x.RestrictedMetricTypes
	}
	return nil
}

var File_google_analytics_data_v1beta_data_proto protoreflect.FileDescriptor

var file_google_analytics_data_v1beta_data_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x22, 0x59, 0x0a, 0x09, 0x44, 0x61, 0x74, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x0b, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x73, 0x5f, 0x61, 0x67, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x41, 0x67, 0x6f,
	0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74,
	0x65, 0x73, 0x5f, 0x61, 0x67, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x0d,
	0x65, 0x6e, 0x64, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x41, 0x67, 0x6f, 0x88, 0x01, 0x01,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6d,
	0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x61, 0x67, 0x6f, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x65,
	0x6e, 0x64, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x61, 0x67, 0x6f, 0x22, 0x85,
	0x01, 0x0a, 0x09, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x64, 0x0a, 0x14, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x13, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf3, 0x03, 0x0a, 0x13, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x61,
	0x0a, 0x0a, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x43, 0x61, 0x73,
	0x65, 0x12, 0x61, 0x0a, 0x0a, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x75, 0x70, 0x70, 0x65, 0x72,
	0x43, 0x61, 0x73, 0x65, 0x12, 0x6b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x6e,
	0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e,
	0x63, 0x61, 0x74, 0x65, 0x6e, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x6e, 0x61, 0x74,
	0x65, 0x1a, 0x37, 0x0a, 0x0e, 0x43, 0x61, 0x73, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x5e, 0x0a, 0x15, 0x43, 0x6f,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x6e, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09,
	0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x42, 0x10, 0x0a, 0x0e, 0x6f, 0x6e,
	0x65, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0x0a, 0x06,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e,
	0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69,
	0x6e, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x22, 0xd7, 0x02, 0x0a, 0x10, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a,
	0x09, 0x61, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x4f, 0x0a, 0x08, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x57, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x6f, 0x74,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x65, 0x78,
	0x70, 0x72, 0x22, 0x68, 0x0a, 0x14, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x81, 0x0a, 0x0a,
	0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x59, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x49,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x69,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5b, 0x0a, 0x0e, 0x6e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69,
	0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5b, 0x0a, 0x0e, 0x62, 0x65, 0x74, 0x77,
	0x65, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x1a, 0xaf, 0x02, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65,
	0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22,
	0x85, 0x01, 0x0a, 0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a,
	0x16, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x58, 0x41,
	0x43, 0x54, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x53, 0x5f, 0x57,
	0x49, 0x54, 0x48, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x4e, 0x44, 0x53, 0x5f, 0x57, 0x49,
	0x54, 0x48, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x53,
	0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x52, 0x45, 0x47, 0x45, 0x58,
	0x50, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x52,
	0x45, 0x47, 0x45, 0x58, 0x50, 0x10, 0x06, 0x1a, 0x4d, 0x0a, 0x0c, 0x49, 0x6e, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x1a, 0xb5, 0x02, 0x0a, 0x0d, 0x4e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x45,
	0x53, 0x53, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x45, 0x53,
	0x53, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10,
	0x03, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41,
	0x4e, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54,
	0x48, 0x41, 0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x05, 0x1a, 0xa1,
	0x01, 0x0a, 0x0d, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x49, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x09, 0x66, 0x72, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x74,
	0x6f, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x74, 0x6f, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x22, 0xdc, 0x06, 0x0a, 0x07, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x4d, 0x0a, 0x06,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x56, 0x0a, 0x09, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x48, 0x00, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x05, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x2e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x48, 0x00, 0x52, 0x05, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x64, 0x65, 0x73, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x64,
	0x65, 0x73, 0x63, 0x1a, 0x30, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x85, 0x02, 0x0a, 0x10, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x5f, 0x0a, 0x0a, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x2e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x2e, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x69, 0x0a, 0x09, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x41,
	0x4c, 0x50, 0x48, 0x41, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x01, 0x12, 0x21, 0x0a,
	0x1d, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56,
	0x45, 0x5f, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x03, 0x1a, 0xff, 0x01,
	0x0a, 0x0c, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x1f,
	0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x6c, 0x0a, 0x10, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x2e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x2e, 0x50, 0x69,
	0x76, 0x6f, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x70, 0x69,
	0x76, 0x6f, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x60, 0x0a,
	0x0e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x25, 0x0a, 0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x0e, 0x0a, 0x0c, 0x6f, 0x6e, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x22,
	0xfc, 0x01, 0x0a, 0x05, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x09, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x52, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x60, 0x0a, 0x13,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x87,
	0x02, 0x0a, 0x0a, 0x43, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3e, 0x0a,
	0x07, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f,
	0x68, 0x6f, 0x72, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x4f, 0x0a,
	0x0d, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x0c, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x68,
	0x0a, 0x16, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f,
	0x68, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x14, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x06, 0x43, 0x6f, 0x68,
	0x6f, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0xfa, 0x01,
	0x0a, 0x0c, 0x43, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x58,
	0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e,
	0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x52, 0x0b, 0x67, 0x72, 0x61,
	0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x65,
	0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x4e, 0x0a, 0x0b, 0x47, 0x72,
	0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x52, 0x41,
	0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0b, 0x0a,
	0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x03, 0x22, 0x36, 0x0a, 0x14, 0x43, 0x6f,
	0x68, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x65, 0x22, 0x9c, 0x06, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12, 0x36, 0x0a, 0x18, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x6c, 0x6f, 0x73, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f,
	0x72, 0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x64, 0x61, 0x74, 0x61, 0x4c,
	0x6f, 0x73, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x52, 0x6f, 0x77, 0x12,
	0x8d, 0x01, 0x0a, 0x1b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x44, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48,
	0x00, 0x52, 0x19, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x28, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x08,
	0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x03, 0x52, 0x0b, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x1a, 0xfa, 0x02, 0x0a, 0x19, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x9e, 0x01, 0x0a, 0x1a, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x18, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xbb, 0x01, 0x0a, 0x17, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24,
	0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x6a, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x72, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x72, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65,
	0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x22, 0x25, 0x0a, 0x0f, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x0b, 0x50,
	0x69, 0x76, 0x6f, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x6a, 0x0a, 0x17, 0x70, 0x69,
	0x76, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x69, 0x76, 0x6f, 0x74,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x15, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x6f, 0x0a, 0x14, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x57, 0x0a, 0x10, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x22, 0xae, 0x01, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x57, 0x0a, 0x10,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x35, 0x0a, 0x0e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x0b, 0x0a, 0x09, 0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x32, 0x0a, 0x0b,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x63, 0x0a, 0x0c, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x6e, 0x65, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8b, 0x04, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x4f, 0x0a, 0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x50, 0x65, 0x72, 0x44, 0x61, 0x79, 0x12, 0x51, 0x0a, 0x0f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x12, 0x5a, 0x0a, 0x13, 0x63,
	0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x74, 0x0a, 0x22, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x1d,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x50, 0x65, 0x72, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x12, 0x83, 0x01,
	0x0a, 0x29, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x25, 0x70, 0x6f,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x48,
	0x6f, 0x75, 0x72, 0x22, 0x47, 0x0a, 0x0b, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x12, 0x1c,
	0x0a, 0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x22, 0xe4, 0x01, 0x0a,
	0x11, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x70, 0x69, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a,
	0x07, 0x75, 0x69, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x75, 0x69, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x70, 0x69, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x22, 0x82, 0x04, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x70, 0x69, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x69, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x75, 0x69, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x41, 0x70, 0x69, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x3c,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x0f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x0e,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x22, 0x5c, 0x0a, 0x0d, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x42,
	0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x4e,
	0x4f, 0x5f, 0x52, 0x45, 0x56, 0x45, 0x4e, 0x55, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43,
	0x53, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x4f, 0x5f, 0x43, 0x4f, 0x53, 0x54, 0x5f, 0x4d,
	0x45, 0x54, 0x52, 0x49, 0x43, 0x53, 0x10, 0x02, 0x22, 0xfe, 0x01, 0x0a, 0x16, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x12, 0x63, 0x0a, 0x12, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x11, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x48, 0x01, 0x52, 0x0d,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01,
	0x42, 0x15, 0x0a, 0x13, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0xef, 0x01, 0x0a, 0x13, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x12, 0x5a, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a,
	0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x48, 0x01, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x88, 0x01, 0x01, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2a, 0x67, 0x0a, 0x11, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x1e, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x41, 0x47, 0x47, 0x52, 0x45,
	0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x4f, 0x54, 0x41, 0x4c, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x4e, 0x49, 0x4d, 0x55, 0x4d, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07,
	0x4d, 0x41, 0x58, 0x49, 0x4d, 0x55, 0x4d, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x4f, 0x55,
	0x4e, 0x54, 0x10, 0x04, 0x2a, 0x81, 0x02, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x10, 0x0a, 0x0c, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52,
	0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x4c, 0x4f, 0x41, 0x54,
	0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e,
	0x44, 0x53, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x49, 0x4c,
	0x4c, 0x49, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x53, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x53, 0x10, 0x06, 0x12, 0x0e, 0x0a,
	0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x07, 0x12, 0x11, 0x0a,
	0x0d, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x08,
	0x12, 0x11, 0x0a, 0x0d, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43,
	0x59, 0x10, 0x09, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x45, 0x45, 0x54,
	0x10, 0x0a, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x49, 0x4c, 0x45, 0x53,
	0x10, 0x0b, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x45, 0x52,
	0x53, 0x10, 0x0c, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4b, 0x49, 0x4c, 0x4f,
	0x4d, 0x45, 0x54, 0x45, 0x52, 0x53, 0x10, 0x0d, 0x2a, 0x5f, 0x0a, 0x14, 0x52, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x26, 0x0a, 0x22, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x4d,
	0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x53, 0x54,
	0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x56, 0x45, 0x4e,
	0x55, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x02, 0x2a, 0x50, 0x0a, 0x0d, 0x43, 0x6f, 0x6d,
	0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f,
	0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4d,
	0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x43,
	0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x42, 0x79, 0x0a, 0x20, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42,
	0x11, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x41, 0x70, 0x69, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_data_v1beta_data_proto_rawDescOnce sync.Once
	file_google_analytics_data_v1beta_data_proto_rawDescData = file_google_analytics_data_v1beta_data_proto_rawDesc
)

func file_google_analytics_data_v1beta_data_proto_rawDescGZIP() []byte {
	file_google_analytics_data_v1beta_data_proto_rawDescOnce.Do(func() {
		file_google_analytics_data_v1beta_data_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_data_v1beta_data_proto_rawDescData)
	})
	return file_google_analytics_data_v1beta_data_proto_rawDescData
}

var file_google_analytics_data_v1beta_data_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_analytics_data_v1beta_data_proto_msgTypes = make([]protoimpl.MessageInfo, 41)
var file_google_analytics_data_v1beta_data_proto_goTypes = []interface{}{
	(MetricAggregation)(0),                             // 0: google.analytics.data.v1beta.MetricAggregation
	(MetricType)(0),                                    // 1: google.analytics.data.v1beta.MetricType
	(RestrictedMetricType)(0),                          // 2: google.analytics.data.v1beta.RestrictedMetricType
	(Compatibility)(0),                                 // 3: google.analytics.data.v1beta.Compatibility
	(Filter_StringFilter_MatchType)(0),                 // 4: google.analytics.data.v1beta.Filter.StringFilter.MatchType
	(Filter_NumericFilter_Operation)(0),                // 5: google.analytics.data.v1beta.Filter.NumericFilter.Operation
	(OrderBy_DimensionOrderBy_OrderType)(0),            // 6: google.analytics.data.v1beta.OrderBy.DimensionOrderBy.OrderType
	(CohortsRange_Granularity)(0),                      // 7: google.analytics.data.v1beta.CohortsRange.Granularity
	(MetricMetadata_BlockedReason)(0),                  // 8: google.analytics.data.v1beta.MetricMetadata.BlockedReason
	(*DateRange)(nil),                                  // 9: google.analytics.data.v1beta.DateRange
	(*MinuteRange)(nil),                                // 10: google.analytics.data.v1beta.MinuteRange
	(*Dimension)(nil),                                  // 11: google.analytics.data.v1beta.Dimension
	(*DimensionExpression)(nil),                        // 12: google.analytics.data.v1beta.DimensionExpression
	(*Metric)(nil),                                     // 13: google.analytics.data.v1beta.Metric
	(*FilterExpression)(nil),                           // 14: google.analytics.data.v1beta.FilterExpression
	(*FilterExpressionList)(nil),                       // 15: google.analytics.data.v1beta.FilterExpressionList
	(*Filter)(nil),                                     // 16: google.analytics.data.v1beta.Filter
	(*OrderBy)(nil),                                    // 17: google.analytics.data.v1beta.OrderBy
	(*Pivot)(nil),                                      // 18: google.analytics.data.v1beta.Pivot
	(*CohortSpec)(nil),                                 // 19: google.analytics.data.v1beta.CohortSpec
	(*Cohort)(nil),                                     // 20: google.analytics.data.v1beta.Cohort
	(*CohortsRange)(nil),                               // 21: google.analytics.data.v1beta.CohortsRange
	(*CohortReportSettings)(nil),                       // 22: google.analytics.data.v1beta.CohortReportSettings
	(*ResponseMetaData)(nil),                           // 23: google.analytics.data.v1beta.ResponseMetaData
	(*DimensionHeader)(nil),                            // 24: google.analytics.data.v1beta.DimensionHeader
	(*MetricHeader)(nil),                               // 25: google.analytics.data.v1beta.MetricHeader
	(*PivotHeader)(nil),                                // 26: google.analytics.data.v1beta.PivotHeader
	(*PivotDimensionHeader)(nil),                       // 27: google.analytics.data.v1beta.PivotDimensionHeader
	(*Row)(nil),                                        // 28: google.analytics.data.v1beta.Row
	(*DimensionValue)(nil),                             // 29: google.analytics.data.v1beta.DimensionValue
	(*MetricValue)(nil),                                // 30: google.analytics.data.v1beta.MetricValue
	(*NumericValue)(nil),                               // 31: google.analytics.data.v1beta.NumericValue
	(*PropertyQuota)(nil),                              // 32: google.analytics.data.v1beta.PropertyQuota
	(*QuotaStatus)(nil),                                // 33: google.analytics.data.v1beta.QuotaStatus
	(*DimensionMetadata)(nil),                          // 34: google.analytics.data.v1beta.DimensionMetadata
	(*MetricMetadata)(nil),                             // 35: google.analytics.data.v1beta.MetricMetadata
	(*DimensionCompatibility)(nil),                     // 36: google.analytics.data.v1beta.DimensionCompatibility
	(*MetricCompatibility)(nil),                        // 37: google.analytics.data.v1beta.MetricCompatibility
	(*DimensionExpression_CaseExpression)(nil),         // 38: google.analytics.data.v1beta.DimensionExpression.CaseExpression
	(*DimensionExpression_ConcatenateExpression)(nil),  // 39: google.analytics.data.v1beta.DimensionExpression.ConcatenateExpression
	(*Filter_StringFilter)(nil),                        // 40: google.analytics.data.v1beta.Filter.StringFilter
	(*Filter_InListFilter)(nil),                        // 41: google.analytics.data.v1beta.Filter.InListFilter
	(*Filter_NumericFilter)(nil),                       // 42: google.analytics.data.v1beta.Filter.NumericFilter
	(*Filter_BetweenFilter)(nil),                       // 43: google.analytics.data.v1beta.Filter.BetweenFilter
	(*OrderBy_MetricOrderBy)(nil),                      // 44: google.analytics.data.v1beta.OrderBy.MetricOrderBy
	(*OrderBy_DimensionOrderBy)(nil),                   // 45: google.analytics.data.v1beta.OrderBy.DimensionOrderBy
	(*OrderBy_PivotOrderBy)(nil),                       // 46: google.analytics.data.v1beta.OrderBy.PivotOrderBy
	(*OrderBy_PivotOrderBy_PivotSelection)(nil),        // 47: google.analytics.data.v1beta.OrderBy.PivotOrderBy.PivotSelection
	(*ResponseMetaData_SchemaRestrictionResponse)(nil), // 48: google.analytics.data.v1beta.ResponseMetaData.SchemaRestrictionResponse
	(*ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction)(nil), // 49: google.analytics.data.v1beta.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction
}
var file_google_analytics_data_v1beta_data_proto_depIdxs = []int32{
	12, // 0: google.analytics.data.v1beta.Dimension.dimension_expression:type_name -> google.analytics.data.v1beta.DimensionExpression
	38, // 1: google.analytics.data.v1beta.DimensionExpression.lower_case:type_name -> google.analytics.data.v1beta.DimensionExpression.CaseExpression
	38, // 2: google.analytics.data.v1beta.DimensionExpression.upper_case:type_name -> google.analytics.data.v1beta.DimensionExpression.CaseExpression
	39, // 3: google.analytics.data.v1beta.DimensionExpression.concatenate:type_name -> google.analytics.data.v1beta.DimensionExpression.ConcatenateExpression
	15, // 4: google.analytics.data.v1beta.FilterExpression.and_group:type_name -> google.analytics.data.v1beta.FilterExpressionList
	15, // 5: google.analytics.data.v1beta.FilterExpression.or_group:type_name -> google.analytics.data.v1beta.FilterExpressionList
	14, // 6: google.analytics.data.v1beta.FilterExpression.not_expression:type_name -> google.analytics.data.v1beta.FilterExpression
	16, // 7: google.analytics.data.v1beta.FilterExpression.filter:type_name -> google.analytics.data.v1beta.Filter
	14, // 8: google.analytics.data.v1beta.FilterExpressionList.expressions:type_name -> google.analytics.data.v1beta.FilterExpression
	40, // 9: google.analytics.data.v1beta.Filter.string_filter:type_name -> google.analytics.data.v1beta.Filter.StringFilter
	41, // 10: google.analytics.data.v1beta.Filter.in_list_filter:type_name -> google.analytics.data.v1beta.Filter.InListFilter
	42, // 11: google.analytics.data.v1beta.Filter.numeric_filter:type_name -> google.analytics.data.v1beta.Filter.NumericFilter
	43, // 12: google.analytics.data.v1beta.Filter.between_filter:type_name -> google.analytics.data.v1beta.Filter.BetweenFilter
	44, // 13: google.analytics.data.v1beta.OrderBy.metric:type_name -> google.analytics.data.v1beta.OrderBy.MetricOrderBy
	45, // 14: google.analytics.data.v1beta.OrderBy.dimension:type_name -> google.analytics.data.v1beta.OrderBy.DimensionOrderBy
	46, // 15: google.analytics.data.v1beta.OrderBy.pivot:type_name -> google.analytics.data.v1beta.OrderBy.PivotOrderBy
	17, // 16: google.analytics.data.v1beta.Pivot.order_bys:type_name -> google.analytics.data.v1beta.OrderBy
	0,  // 17: google.analytics.data.v1beta.Pivot.metric_aggregations:type_name -> google.analytics.data.v1beta.MetricAggregation
	20, // 18: google.analytics.data.v1beta.CohortSpec.cohorts:type_name -> google.analytics.data.v1beta.Cohort
	21, // 19: google.analytics.data.v1beta.CohortSpec.cohorts_range:type_name -> google.analytics.data.v1beta.CohortsRange
	22, // 20: google.analytics.data.v1beta.CohortSpec.cohort_report_settings:type_name -> google.analytics.data.v1beta.CohortReportSettings
	9,  // 21: google.analytics.data.v1beta.Cohort.date_range:type_name -> google.analytics.data.v1beta.DateRange
	7,  // 22: google.analytics.data.v1beta.CohortsRange.granularity:type_name -> google.analytics.data.v1beta.CohortsRange.Granularity
	48, // 23: google.analytics.data.v1beta.ResponseMetaData.schema_restriction_response:type_name -> google.analytics.data.v1beta.ResponseMetaData.SchemaRestrictionResponse
	1,  // 24: google.analytics.data.v1beta.MetricHeader.type:type_name -> google.analytics.data.v1beta.MetricType
	27, // 25: google.analytics.data.v1beta.PivotHeader.pivot_dimension_headers:type_name -> google.analytics.data.v1beta.PivotDimensionHeader
	29, // 26: google.analytics.data.v1beta.PivotDimensionHeader.dimension_values:type_name -> google.analytics.data.v1beta.DimensionValue
	29, // 27: google.analytics.data.v1beta.Row.dimension_values:type_name -> google.analytics.data.v1beta.DimensionValue
	30, // 28: google.analytics.data.v1beta.Row.metric_values:type_name -> google.analytics.data.v1beta.MetricValue
	33, // 29: google.analytics.data.v1beta.PropertyQuota.tokens_per_day:type_name -> google.analytics.data.v1beta.QuotaStatus
	33, // 30: google.analytics.data.v1beta.PropertyQuota.tokens_per_hour:type_name -> google.analytics.data.v1beta.QuotaStatus
	33, // 31: google.analytics.data.v1beta.PropertyQuota.concurrent_requests:type_name -> google.analytics.data.v1beta.QuotaStatus
	33, // 32: google.analytics.data.v1beta.PropertyQuota.server_errors_per_project_per_hour:type_name -> google.analytics.data.v1beta.QuotaStatus
	33, // 33: google.analytics.data.v1beta.PropertyQuota.potentially_thresholded_requests_per_hour:type_name -> google.analytics.data.v1beta.QuotaStatus
	1,  // 34: google.analytics.data.v1beta.MetricMetadata.type:type_name -> google.analytics.data.v1beta.MetricType
	8,  // 35: google.analytics.data.v1beta.MetricMetadata.blocked_reasons:type_name -> google.analytics.data.v1beta.MetricMetadata.BlockedReason
	34, // 36: google.analytics.data.v1beta.DimensionCompatibility.dimension_metadata:type_name -> google.analytics.data.v1beta.DimensionMetadata
	3,  // 37: google.analytics.data.v1beta.DimensionCompatibility.compatibility:type_name -> google.analytics.data.v1beta.Compatibility
	35, // 38: google.analytics.data.v1beta.MetricCompatibility.metric_metadata:type_name -> google.analytics.data.v1beta.MetricMetadata
	3,  // 39: google.analytics.data.v1beta.MetricCompatibility.compatibility:type_name -> google.analytics.data.v1beta.Compatibility
	4,  // 40: google.analytics.data.v1beta.Filter.StringFilter.match_type:type_name -> google.analytics.data.v1beta.Filter.StringFilter.MatchType
	5,  // 41: google.analytics.data.v1beta.Filter.NumericFilter.operation:type_name -> google.analytics.data.v1beta.Filter.NumericFilter.Operation
	31, // 42: google.analytics.data.v1beta.Filter.NumericFilter.value:type_name -> google.analytics.data.v1beta.NumericValue
	31, // 43: google.analytics.data.v1beta.Filter.BetweenFilter.from_value:type_name -> google.analytics.data.v1beta.NumericValue
	31, // 44: google.analytics.data.v1beta.Filter.BetweenFilter.to_value:type_name -> google.analytics.data.v1beta.NumericValue
	6,  // 45: google.analytics.data.v1beta.OrderBy.DimensionOrderBy.order_type:type_name -> google.analytics.data.v1beta.OrderBy.DimensionOrderBy.OrderType
	47, // 46: google.analytics.data.v1beta.OrderBy.PivotOrderBy.pivot_selections:type_name -> google.analytics.data.v1beta.OrderBy.PivotOrderBy.PivotSelection
	49, // 47: google.analytics.data.v1beta.ResponseMetaData.SchemaRestrictionResponse.active_metric_restrictions:type_name -> google.analytics.data.v1beta.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction
	2,  // 48: google.analytics.data.v1beta.ResponseMetaData.SchemaRestrictionResponse.ActiveMetricRestriction.restricted_metric_types:type_name -> google.analytics.data.v1beta.RestrictedMetricType
	49, // [49:49] is the sub-list for method output_type
	49, // [49:49] is the sub-list for method input_type
	49, // [49:49] is the sub-list for extension type_name
	49, // [49:49] is the sub-list for extension extendee
	0,  // [0:49] is the sub-list for field type_name
}

func init() { file_google_analytics_data_v1beta_data_proto_init() }
func file_google_analytics_data_v1beta_data_proto_init() {
	if File_google_analytics_data_v1beta_data_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_data_v1beta_data_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MinuteRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrderBy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pivot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CohortSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cohort); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CohortsRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CohortReportSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMetaData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PivotHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PivotDimensionHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NumericValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyQuota); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuotaStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionCompatibility); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricCompatibility); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionExpression_CaseExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DimensionExpression_ConcatenateExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter_StringFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter_InListFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter_NumericFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Filter_BetweenFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrderBy_MetricOrderBy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrderBy_DimensionOrderBy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrderBy_PivotOrderBy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrderBy_PivotOrderBy_PivotSelection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMetaData_SchemaRestrictionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1beta_data_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMetaData_SchemaRestrictionResponse_ActiveMetricRestriction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_analytics_data_v1beta_data_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1beta_data_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*DimensionExpression_LowerCase)(nil),
		(*DimensionExpression_UpperCase)(nil),
		(*DimensionExpression_Concatenate)(nil),
	}
	file_google_analytics_data_v1beta_data_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*FilterExpression_AndGroup)(nil),
		(*FilterExpression_OrGroup)(nil),
		(*FilterExpression_NotExpression)(nil),
		(*FilterExpression_Filter)(nil),
	}
	file_google_analytics_data_v1beta_data_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Filter_StringFilter_)(nil),
		(*Filter_InListFilter_)(nil),
		(*Filter_NumericFilter_)(nil),
		(*Filter_BetweenFilter_)(nil),
	}
	file_google_analytics_data_v1beta_data_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*OrderBy_Metric)(nil),
		(*OrderBy_Dimension)(nil),
		(*OrderBy_Pivot)(nil),
	}
	file_google_analytics_data_v1beta_data_proto_msgTypes[14].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1beta_data_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*DimensionValue_Value)(nil),
	}
	file_google_analytics_data_v1beta_data_proto_msgTypes[21].OneofWrappers = []interface{}{
		(*MetricValue_Value)(nil),
	}
	file_google_analytics_data_v1beta_data_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*NumericValue_Int64Value)(nil),
		(*NumericValue_DoubleValue)(nil),
	}
	file_google_analytics_data_v1beta_data_proto_msgTypes[27].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1beta_data_proto_msgTypes[28].OneofWrappers = []interface{}{}
	file_google_analytics_data_v1beta_data_proto_msgTypes[40].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_data_v1beta_data_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   41,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_analytics_data_v1beta_data_proto_goTypes,
		DependencyIndexes: file_google_analytics_data_v1beta_data_proto_depIdxs,
		EnumInfos:         file_google_analytics_data_v1beta_data_proto_enumTypes,
		MessageInfos:      file_google_analytics_data_v1beta_data_proto_msgTypes,
	}.Build()
	File_google_analytics_data_v1beta_data_proto = out.File
	file_google_analytics_data_v1beta_data_proto_rawDesc = nil
	file_google_analytics_data_v1beta_data_proto_goTypes = nil
	file_google_analytics_data_v1beta_data_proto_depIdxs = nil
}
