/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.resolver;

import java.io.File;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.vcs.internal.VersionControlRepositoryConnection;
import org.gradle.vcs.internal.resolver.VcsVersionSelectionCache;
import org.gradle.vcs.internal.resolver.VcsVersionWorkingDirResolver;

@ThreadSafe
public class OncePerBuildInvocationVcsVersionWorkingDirResolver
implements VcsVersionWorkingDirResolver {
    private final ProducerGuard<String> perRepoGuard = ProducerGuard.adaptive();
    private final VcsVersionSelectionCache inMemoryCache;
    private final VcsVersionWorkingDirResolver delegate;

    public OncePerBuildInvocationVcsVersionWorkingDirResolver(VcsVersionSelectionCache inMemoryCache, VcsVersionWorkingDirResolver delegate) {
        this.inMemoryCache = inMemoryCache;
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public File selectVersion(final ModuleComponentSelector selector, final VersionControlRepositoryConnection repository) {
        return (File)this.perRepoGuard.guardByKey((Object)repository.getUniqueId(), (Supplier)new Supplier<File>(){

            @Override
            @Nullable
            public File get() {
                File workingDir = OncePerBuildInvocationVcsVersionWorkingDirResolver.this.inMemoryCache.getWorkingDirForSelector(repository, selector.getVersionConstraint());
                if (workingDir == null) {
                    workingDir = OncePerBuildInvocationVcsVersionWorkingDirResolver.this.delegate.selectVersion(selector, repository);
                    if (workingDir == null) {
                        return null;
                    }
                    OncePerBuildInvocationVcsVersionWorkingDirResolver.this.inMemoryCache.putWorkingDirForSelector(repository, selector.getVersionConstraint(), workingDir);
                }
                return workingDir;
            }
        });
    }
}

