/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ProjectReportsPluginConvention;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.DefaultProjectReportsPluginConvention;
import org.gradle.api.reporting.dependencies.HtmlDependencyReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.api.tasks.diagnostics.PropertyReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.util.internal.WrapUtil;

public abstract class ProjectReportsPlugin
implements Plugin<Project> {
    public static final String TASK_REPORT = "taskReport";
    public static final String PROPERTY_REPORT = "propertyReport";
    public static final String DEPENDENCY_REPORT = "dependencyReport";
    public static final String HTML_DEPENDENCY_REPORT = "htmlDependencyReport";
    public static final String PROJECT_REPORT = "projectReport";

    public void apply(final Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        final ProjectReportsPluginConvention convention = (ProjectReportsPluginConvention)project.getObjects().newInstance(DefaultProjectReportsPluginConvention.class, new Object[]{project});
        DeprecationLogger.whileDisabled((Runnable)new Runnable(){

            @Override
            public void run() {
                project.getConvention().getPlugins().put("projectReports", convention);
            }
        });
        project.getTasks().register(TASK_REPORT, TaskReportTask.class, taskReportTask -> {
            taskReportTask.getProjectReportDirectory().convention(project.getLayout().dir(project.provider(() -> (File)DeprecationLogger.whileDisabled(() -> convention.getProjectReportDir()))));
            taskReportTask.setDescription("Generates a report about your tasks.");
            taskReportTask.conventionMapping("outputFile", () -> ((RegularFile)taskReportTask.getProjectReportDirectory().file("tasks.txt").get()).getAsFile());
            taskReportTask.conventionMapping("projects", () -> WrapUtil.toSet((Object[])new Project[]{project}));
        });
        project.getTasks().register(PROPERTY_REPORT, PropertyReportTask.class, propertyReportTask -> {
            propertyReportTask.getProjectReportDirectory().convention(project.getLayout().dir(project.provider(() -> (File)DeprecationLogger.whileDisabled(() -> convention.getProjectReportDir()))));
            propertyReportTask.setDescription("Generates a report about your properties.");
            propertyReportTask.conventionMapping("outputFile", () -> ((RegularFile)propertyReportTask.getProjectReportDirectory().file("properties.txt").get()).getAsFile());
            propertyReportTask.conventionMapping("projects", () -> WrapUtil.toSet((Object[])new Project[]{project}));
        });
        project.getTasks().register(DEPENDENCY_REPORT, DependencyReportTask.class, dependencyReportTask -> {
            dependencyReportTask.getProjectReportDirectory().convention(project.getLayout().dir(project.provider(() -> (File)DeprecationLogger.whileDisabled(() -> convention.getProjectReportDir()))));
            dependencyReportTask.setDescription("Generates a report about your library dependencies.");
            dependencyReportTask.conventionMapping("outputFile", () -> ((RegularFile)dependencyReportTask.getProjectReportDirectory().file("dependencies.txt").get()).getAsFile());
            dependencyReportTask.conventionMapping("projects", () -> WrapUtil.toSet((Object[])new Project[]{project}));
        });
        project.getTasks().register(HTML_DEPENDENCY_REPORT, HtmlDependencyReportTask.class, htmlDependencyReportTask -> {
            htmlDependencyReportTask.getProjectReportDirectory().convention(project.getLayout().dir(project.provider(() -> (File)DeprecationLogger.whileDisabled(() -> convention.getProjectReportDir()))));
            htmlDependencyReportTask.setDescription("Generates an HTML report about your library dependencies.");
            htmlDependencyReportTask.getReports().getHtml().getOutputLocation().convention(htmlDependencyReportTask.getProjectReportDirectory().dir("dependencies"));
            htmlDependencyReportTask.conventionMapping("projects", () -> WrapUtil.toSet((Object[])new Project[]{project}));
        });
        project.getTasks().register(PROJECT_REPORT, projectReportTask -> {
            projectReportTask.dependsOn(new Object[]{TASK_REPORT, PROPERTY_REPORT, DEPENDENCY_REPORT, HTML_DEPENDENCY_REPORT});
            projectReportTask.setDescription("Generates a report about your project.");
            projectReportTask.setGroup("reporting");
        });
    }
}

