package unused

// Functions defined in the Go runtime that may be called through
// compiler magic or via assembly.
var runtimeFuncs = map[string]bool{
	// Copied from cmd/compile/internal/typecheck/builtin.go, var runtimeDecls
	"newobject":               true,
	"panicindex":              true,
	"panicslice":              true,
	"panicdivide":             true,
	"panicmakeslicelen":       true,
	"throwinit":               true,
	"panicwrap":               true,
	"gopanic":                 true,
	"gorecover":               true,
	"goschedguarded":          true,
	"printbool":               true,
	"printfloat":              true,
	"printint":                true,
	"printhex":                true,
	"printuint":               true,
	"printcomplex":            true,
	"printstring":             true,
	"printpointer":            true,
	"printiface":              true,
	"printeface":              true,
	"printslice":              true,
	"printnl":                 true,
	"printsp":                 true,
	"printlock":               true,
	"printunlock":             true,
	"concatstring2":           true,
	"concatstring3":           true,
	"concatstring4":           true,
	"concatstring5":           true,
	"concatstrings":           true,
	"cmpstring":               true,
	"intstring":               true,
	"slicebytetostring":       true,
	"slicebytetostringtmp":    true,
	"slicerunetostring":       true,
	"stringtoslicebyte":       true,
	"stringtoslicerune":       true,
	"slicecopy":               true,
	"slicestringcopy":         true,
	"decoderune":              true,
	"countrunes":              true,
	"convI2I":                 true,
	"convT16":                 true,
	"convT32":                 true,
	"convT64":                 true,
	"convTstring":             true,
	"convTslice":              true,
	"convT2E":                 true,
	"convT2Enoptr":            true,
	"convT2I":                 true,
	"convT2Inoptr":            true,
	"assertE2I":               true,
	"assertE2I2":              true,
	"assertI2I":               true,
	"assertI2I2":              true,
	"panicdottypeE":           true,
	"panicdottypeI":           true,
	"panicnildottype":         true,
	"ifaceeq":                 true,
	"efaceeq":                 true,
	"fastrand":                true,
	"makemap64":               true,
	"makemap":                 true,
	"makemap_small":           true,
	"mapaccess1":              true,
	"mapaccess1_fast32":       true,
	"mapaccess1_fast64":       true,
	"mapaccess1_faststr":      true,
	"mapaccess1_fat":          true,
	"mapaccess2":              true,
	"mapaccess2_fast32":       true,
	"mapaccess2_fast64":       true,
	"mapaccess2_faststr":      true,
	"mapaccess2_fat":          true,
	"mapassign":               true,
	"mapassign_fast32":        true,
	"mapassign_fast32ptr":     true,
	"mapassign_fast64":        true,
	"mapassign_fast64ptr":     true,
	"mapassign_faststr":       true,
	"mapiterinit":             true,
	"mapdelete":               true,
	"mapdelete_fast32":        true,
	"mapdelete_fast64":        true,
	"mapdelete_faststr":       true,
	"mapiternext":             true,
	"mapclear":                true,
	"makechan64":              true,
	"makechan":                true,
	"chanrecv1":               true,
	"chanrecv2":               true,
	"chansend1":               true,
	"closechan":               true,
	"writeBarrier":            true,
	"typedmemmove":            true,
	"typedmemclr":             true,
	"typedslicecopy":          true,
	"selectnbsend":            true,
	"selectnbrecv":            true,
	"selectnbrecv2":           true,
	"selectsetpc":             true,
	"selectgo":                true,
	"block":                   true,
	"makeslice":               true,
	"makeslice64":             true,
	"growslice":               true,
	"memmove":                 true,
	"memclrNoHeapPointers":    true,
	"memclrHasPointers":       true,
	"memequal":                true,
	"memequal8":               true,
	"memequal16":              true,
	"memequal32":              true,
	"memequal64":              true,
	"memequal128":             true,
	"int64div":                true,
	"uint64div":               true,
	"int64mod":                true,
	"uint64mod":               true,
	"float64toint64":          true,
	"float64touint64":         true,
	"float64touint32":         true,
	"int64tofloat64":          true,
	"uint64tofloat64":         true,
	"uint32tofloat64":         true,
	"complex128div":           true,
	"racefuncenter":           true,
	"racefuncenterfp":         true,
	"racefuncexit":            true,
	"raceread":                true,
	"racewrite":               true,
	"racereadrange":           true,
	"racewriterange":          true,
	"msanread":                true,
	"msanwrite":               true,
	"x86HasPOPCNT":            true,
	"x86HasSSE41":             true,
	"arm64HasATOMICS":         true,
	"mallocgc":                true,
	"panicshift":              true,
	"panicmakeslicecap":       true,
	"goPanicIndex":            true,
	"goPanicIndexU":           true,
	"goPanicSliceAlen":        true,
	"goPanicSliceAlenU":       true,
	"goPanicSliceAcap":        true,
	"goPanicSliceAcapU":       true,
	"goPanicSliceB":           true,
	"goPanicSliceBU":          true,
	"goPanicSlice3Alen":       true,
	"goPanicSlice3AlenU":      true,
	"goPanicSlice3Acap":       true,
	"goPanicSlice3AcapU":      true,
	"goPanicSlice3B":          true,
	"goPanicSlice3BU":         true,
	"goPanicSlice3C":          true,
	"goPanicSlice3CU":         true,
	"goPanicSliceConvert":     true,
	"printuintptr":            true,
	"convT":                   true,
	"convTnoptr":              true,
	"makeslicecopy":           true,
	"unsafeslicecheckptr":     true,
	"panicunsafeslicelen":     true,
	"panicunsafeslicenilptr":  true,
	"unsafestringcheckptr":    true,
	"panicunsafestringlen":    true,
	"panicunsafestringnilptr": true,
	"mulUintptr":              true,
	"memequal0":               true,
	"f32equal":                true,
	"f64equal":                true,
	"c64equal":                true,
	"c128equal":               true,
	"strequal":                true,
	"interequal":              true,
	"nilinterequal":           true,
	"memhash":                 true,
	"memhash0":                true,
	"memhash8":                true,
	"memhash16":               true,
	"memhash32":               true,
	"memhash64":               true,
	"memhash128":              true,
	"f32hash":                 true,
	"f64hash":                 true,
	"c64hash":                 true,
	"c128hash":                true,
	"strhash":                 true,
	"interhash":               true,
	"nilinterhash":            true,
	"int64tofloat32":          true,
	"uint64tofloat32":         true,
	"getcallerpc":             true,
	"getcallersp":             true,
	"msanmove":                true,
	"asanread":                true,
	"asanwrite":               true,
	"checkptrAlignment":       true,
	"checkptrArithmetic":      true,
	"libfuzzerTraceCmp1":      true,
	"libfuzzerTraceCmp2":      true,
	"libfuzzerTraceCmp4":      true,
	"libfuzzerTraceCmp8":      true,
	"libfuzzerTraceConstCmp1": true,
	"libfuzzerTraceConstCmp2": true,
	"libfuzzerTraceConstCmp4": true,
	"libfuzzerTraceConstCmp8": true,
	"libfuzzerHookStrCmp":     true,
	"libfuzzerHookEqualFold":  true,
	"addCovMeta":              true,
	"x86HasFMA":               true,
	"armHasVFPv4":             true,

	// Extracted from assembly code in the standard library, with the exception of the runtime package itself
	"abort":                 true,
	"aeshashbody":           true,
	"args":                  true,
	"asminit":               true,
	"badctxt":               true,
	"badmcall2":             true,
	"badmcall":              true,
	"badmorestackg0":        true,
	"badmorestackgsignal":   true,
	"badsignal2":            true,
	"callbackasm1":          true,
	"callCfunction":         true,
	"cgocallback_gofunc":    true,
	"cgocallbackg":          true,
	"checkgoarm":            true,
	"check":                 true,
	"debugCallCheck":        true,
	"debugCallWrap":         true,
	"emptyfunc":             true,
	"entersyscall":          true,
	"exit":                  true,
	"exits":                 true,
	"exitsyscall":           true,
	"externalthreadhandler": true,
	"findnull":              true,
	"goexit1":               true,
	"gostring":              true,
	"i386_set_ldt":          true,
	"_initcgo":              true,
	"init_thread_tls":       true,
	"ldt0setup":             true,
	"libpreinit":            true,
	"load_g":                true,
	"morestack":             true,
	"mstart":                true,
	"nacl_sysinfo":          true,
	"nanotimeQPC":           true,
	"nanotime":              true,
	"newosproc0":            true,
	"newproc":               true,
	"newstack":              true,
	"noted":                 true,
	"nowQPC":                true,
	"osinit":                true,
	"printf":                true,
	"racecallback":          true,
	"reflectcallmove":       true,
	"reginit":               true,
	"rt0_go":                true,
	"save_g":                true,
	"schedinit":             true,
	"setldt":                true,
	"settls":                true,
	"sighandler":            true,
	"sigprofNonGo":          true,
	"sigtrampgo":            true,
	"_sigtramp":             true,
	"sigtramp":              true,
	"stackcheck":            true,
	"syscall_chdir":         true,
	"syscall_chroot":        true,
	"syscall_close":         true,
	"syscall_dup2":          true,
	"syscall_execve":        true,
	"syscall_exit":          true,
	"syscall_fcntl":         true,
	"syscall_forkx":         true,
	"syscall_gethostname":   true,
	"syscall_getpid":        true,
	"syscall_ioctl":         true,
	"syscall_pipe":          true,
	"syscall_rawsyscall6":   true,
	"syscall_rawSyscall6":   true,
	"syscall_rawsyscall":    true,
	"syscall_RawSyscall":    true,
	"syscall_rawsysvicall6": true,
	"syscall_setgid":        true,
	"syscall_setgroups":     true,
	"syscall_setpgid":       true,
	"syscall_setsid":        true,
	"syscall_setuid":        true,
	"syscall_syscall6":      true,
	"syscall_syscall":       true,
	"syscall_Syscall":       true,
	"syscall_sysvicall6":    true,
	"syscall_wait4":         true,
	"syscall_write":         true,
	"traceback":             true,
	"tstart":                true,
	"usplitR0":              true,
	"wbBufFlush":            true,
	"write":                 true,

	// Other runtime functions that can get called in non-standard ways
	"bgsweep":             true,
	"memhash_varlen":      true,
	"strhashFallback":     true,
	"asanregisterglobals": true,
	"cgoUse":              true,
	"cgoCheckPointer":     true,
	"cgoCheckResult":      true,
	"_cgo_panic_internal": true,
	"addExitHook":         true,
}

var runtimeCoverageFuncs = map[string]bool{
	"initHook":            true,
	"markProfileEmitted":  true,
	"processCoverTestDir": true,
}
