/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class SystemInfo {
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = SystemInfo.getRtVersion(JAVA_VERSION);
    public static final String JAVA_VENDOR = System.getProperty("java.vm.vendor", "Unknown");
    public static final boolean isAarch64 = OS_ARCH.equals("aarch64");
    public static final boolean isWindows = SystemInfoRt.isWindows;
    public static final boolean isMac = SystemInfoRt.isMac;
    public static final boolean isLinux = SystemInfoRt.isLinux;
    public static final boolean isFreeBSD = SystemInfoRt.isFreeBSD;
    public static final boolean isSolaris = SystemInfoRt.isSolaris;
    public static final boolean isUnix = SystemInfoRt.isUnix;
    public static final boolean isChromeOS = isLinux && SystemInfo.isCrostini();
    public static final boolean isOracleJvm = Strings.indexOfIgnoreCase(JAVA_VENDOR, "Oracle", 0) >= 0;
    public static final boolean isIbmJvm = Strings.indexOfIgnoreCase(JAVA_VENDOR, "IBM", 0) >= 0;
    public static final boolean isAzulJvm = Strings.indexOfIgnoreCase(JAVA_VENDOR, "Azul", 0) >= 0;
    public static final boolean isJetBrainsJvm = Strings.indexOfIgnoreCase(JAVA_VENDOR, "JetBrains", 0) >= 0;
    public static final boolean isWin8OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.2");
    public static final boolean isWin10OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("10.0");
    public static final boolean isWin11OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("11.0");
    public static final boolean isXWindow = SystemInfoRt.isXWindow;
    public static final boolean isWayland;
    public static final boolean isGNOME;
    public static final boolean isKDE;
    public static final boolean isXfce;
    public static final boolean isI3;
    public static final boolean isMacSystemMenu;
    public static final boolean isFileSystemCaseSensitive;
    private static final Supplier<Boolean> ourHasXdgOpen;
    private static final Supplier<Boolean> ourHasXdgMime;
    public static final boolean isMacOSCatalina;
    public static final boolean isMacOSBigSur;
    public static final boolean isMacOSMonterey;
    public static final boolean isMacOSVentura;
    public static final boolean isMacOSSonoma;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean is32Bit;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean is64Bit;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isMacOSLeopard;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isMacOSMountainLion;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isMacOSMojave;

    private static String getRtVersion(String fallback) {
        String rtVersion = System.getProperty("java.runtime.version");
        return rtVersion != null && Character.isDigit(rtVersion.charAt(0)) ? rtVersion : fallback;
    }

    private static boolean isCrostini() {
        return new File("/dev/.cros_milestone").exists();
    }

    public static boolean isOsVersionAtLeast(@NotNull String version2) {
        if (version2 == null) {
            SystemInfo.$$$reportNull$$$0(0);
        }
        return StringUtil.compareVersionNumbers(OS_VERSION, version2) >= 0;
    }

    public static String getOsName() {
        return isMac ? "macOS" : OS_NAME;
    }

    static {
        if (isXWindow) {
            isWayland = System.getenv("WAYLAND_DISPLAY") != null;
            String desktop = System.getenv("XDG_CURRENT_DESKTOP");
            String gdmSession = System.getenv("GDMSESSION");
            isGNOME = desktop != null && desktop.contains("GNOME") || gdmSession != null && gdmSession.contains("gnome");
            isKDE = !isGNOME && (desktop != null && desktop.contains("KDE") || System.getenv("KDE_FULL_SESSION") != null);
            isXfce = !isGNOME && !isKDE && desktop != null && desktop.contains("XFCE");
            isI3 = !isGNOME && !isKDE && !isXfce && desktop != null && desktop.contains("i3");
        } else {
            isI3 = false;
            isXfce = false;
            isKDE = false;
            isGNOME = false;
            isWayland = false;
        }
        isMacSystemMenu = isMac && (SystemInfoRt.isJBSystemMenu || Boolean.getBoolean("apple.laf.useScreenMenuBar"));
        isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
        ourHasXdgOpen = isXWindow ? PathExecLazyValue.create("xdg-open") : () -> false;
        ourHasXdgMime = isXWindow ? PathExecLazyValue.create("xdg-mime") : () -> false;
        isMacOSCatalina = isMac && SystemInfo.isOsVersionAtLeast("10.15");
        isMacOSBigSur = isMac && SystemInfo.isOsVersionAtLeast("10.16");
        isMacOSMonterey = isMac && SystemInfo.isOsVersionAtLeast("12.0");
        isMacOSVentura = isMac && SystemInfo.isOsVersionAtLeast("13.0");
        isMacOSSonoma = isMac && SystemInfo.isOsVersionAtLeast("14.0");
        is32Bit = CpuArch.CURRENT.width == 32;
        is64Bit = CpuArch.CURRENT.width == 64;
        isMacOSLeopard = isMac;
        isMacOSMountainLion = isMac;
        isMacOSMojave = isMac;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/SystemInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/SystemInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMajorVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSVersionCode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMajorVersionCode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMinorVersionCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOsVersionAtLeast";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSVersionCode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSMajorVersionCode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSMinorVersionCode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSVersionParts";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

