/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.indexing.impl.IndexStorageUtil;
import com.intellij.util.io.CorruptionException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentMapWal;
import com.intellij.util.io.PersistentMapWalPlayer;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.io.WalEvent;
import com.intellij.util.io.WalRecord;
import com.intellij.util.io.WriteAheadLogKt;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a)\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a]\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u0012\"\u0004\b\u0002\u0010\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00162\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00190 H\u0002\u00a2\u0006\u0002\u0010!\u001aB\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u00120#\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016\u001a(\u0010$\u001a\b\u0012\u0004\u0012\u0002H&0%\"\u0004\b\u0000\u0010&2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\u001e\u001a0\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)\"\u0004\b\u0000\u0010&2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\u001e\u001aJ\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u00120,\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016\u001a:\u0010-\u001a\u0004\u0018\u00010\u001c\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0002\u001a)\u0010.\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00122\u0006\u0010/\u001a\u0002H\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0002\u00a2\u0006\u0002\u00100\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\"\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"VERSION", "", "checksumGen", "Lkotlin/Function0;", "Ljava/util/zip/CRC32;", "debugWalRecords", "", "getDebugWalRecords", "()Z", "setDebugWalRecords", "(Z)V", "integerExternalizer", "Lcom/intellij/util/io/EnumeratorIntegerDescriptor;", "getIntegerExternalizer", "()Lcom/intellij/util/io/EnumeratorIntegerDescriptor;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "readData", "V", "array", "", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "([BLcom/intellij/util/io/DataExternalizer;)Ljava/lang/Object;", "restoreFromWal", "R", "K", "walFile", "Ljava/nio/file/Path;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "accumulator", "Lcom/intellij/util/io/Accumulator;", "(Ljava/nio/file/Path;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;Lcom/intellij/util/io/Accumulator;)Ljava/lang/Object;", "restoreHashMapFromWal", "", "restoreMemoryEnumeratorFromWal", "", "Data", "dataDescriptor", "restorePersistentEnumeratorFromWal", "Lcom/intellij/util/io/PersistentEnumerator;", "outputMapFile", "restorePersistentMapFromWal", "Lcom/intellij/util/io/PersistentMap;", "tryCompact", "writeData", "value", "(Ljava/lang/Object;Lcom/intellij/util/io/DataExternalizer;)[B", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nwriteAheadLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 writeAheadLog.kt\ncom/intellij/util/io/WriteAheadLogKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,514:1\n1#2:515\n1324#3,3:516\n10#4:519\n*S KotlinDebug\n*F\n+ 1 writeAheadLog.kt\ncom/intellij/util/io/WriteAheadLogKt\n*L\n327#1:516,3\n43#1:519\n*E\n"})
public final class WriteAheadLogKt {
    @NotNull
    private static final Function0<CRC32> checksumGen = checksumGen.1.INSTANCE;
    private static volatile boolean debugWalRecords;
    @NotNull
    private static final Logger log;

    public static final boolean getDebugWalRecords() {
        return debugWalRecords;
    }

    private static final EnumeratorIntegerDescriptor getIntegerExternalizer() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(enumeratorIntegerDescriptor, "INSTANCE");
        return enumeratorIntegerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final <K, V> Path tryCompact(Path walFile, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer) {
        boolean bl;
        WalEvent walEvent;
        Object object;
        if (!Files.exists(walFile, new LinkOption[0])) {
            return null;
        }
        Map<Object, IntLinkedOpenHashSet> map = IndexStorageUtil.createKeyDescriptorHashedMap(keyDescriptor);
        Intrinsics.checkNotNullExpressionValue(map, "createKeyDescriptorHashedMap(...)");
        Map<Object, IntLinkedOpenHashSet> keyToLastEvent = map;
        Closeable closeable = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        Object object2 = null;
        try {
            PersistentMapWalPlayer it = (PersistentMapWalPlayer)closeable;
            boolean bl2 = false;
            int eventCount = 0;
            object = it.readWal().iterator();
            while (object.hasNext()) {
                WalEvent walEvent2 = object.next();
                walEvent = walEvent2;
                if (walEvent instanceof WalEvent.AppendEvent) {
                    ((IntSet)keyToLastEvent.computeIfAbsent(walEvent2.getKey(), WriteAheadLogKt::tryCompact$lambda$3$lambda$0)).add(eventCount);
                } else if (walEvent instanceof WalEvent.PutEvent) {
                    void set;
                    IntLinkedOpenHashSet intLinkedOpenHashSet;
                    IntLinkedOpenHashSet intLinkedOpenHashSet2 = intLinkedOpenHashSet = new IntLinkedOpenHashSet();
                    Object k = walEvent2.getKey();
                    Map<Object, IntLinkedOpenHashSet> map2 = keyToLastEvent;
                    boolean bl3 = false;
                    set.add(eventCount);
                    Unit unit = Unit.INSTANCE;
                    map2.put(k, intLinkedOpenHashSet);
                } else if (walEvent instanceof WalEvent.RemoveEvent) {
                    keyToLastEvent.put(walEvent2.getKey(), new IntLinkedOpenHashSet());
                } else if (walEvent instanceof WalEvent.CorruptionEvent) {
                    throw new CorruptionException("wal has been corrupted");
                }
                ((IntSet)keyToLastEvent.computeIfAbsent(walEvent2.getKey(), WriteAheadLogKt::tryCompact$lambda$3$lambda$2)).add(eventCount);
                ++eventCount;
            }
            bl = keyToLastEvent.size() * 2 < eventCount;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object2);
        }
        boolean shouldCompact = bl;
        if (!shouldCompact) {
            return null;
        }
        Path compactedWalFile = walFile.resolveSibling(walFile.getFileName() + "_compacted");
        object2 = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        Throwable throwable = null;
        try {
            PersistentMapWalPlayer walPlayer = (PersistentMapWalPlayer)object2;
            boolean bl4 = false;
            boolean bl5 = walPlayer.getUseCompression$intellij_platform_util();
            Intrinsics.checkNotNull(compactedWalFile);
            ExecutorService executorService = ConcurrencyUtil.newSameThreadExecutorService();
            Intrinsics.checkNotNullExpressionValue(executorService, "newSameThreadExecutorService(...)");
            object = new PersistentMapWal(keyDescriptor, valueExternalizer, bl5, compactedWalFile, executorService, false, 32, null);
            Throwable throwable2 = null;
            try {
                PersistentMapWal compactedWal = (PersistentMapWal)object;
                boolean bl6 = false;
                Sequence $this$forEachIndexed$iv = walPlayer.readWal();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                Iterator iterator2 = $this$forEachIndexed$iv.iterator();
                while (iterator2.hasNext()) {
                    IntSet events;
                    void walEvent3;
                    int n;
                    WalEvent item$iv = iterator2.next();
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    WalEvent walEvent4 = item$iv;
                    int index = n;
                    boolean bl7 = false;
                    Object key = walEvent3.getKey();
                    if ((IntSet)keyToLastEvent.get(key) == null) {
                        throw new IOException("No events found for key =  " + key);
                    }
                    if (!events.contains(index)) continue;
                    void var25_38 = walEvent3;
                    if (var25_38 instanceof WalEvent.AppendEvent) {
                        compactedWal.appendData(key, arg_0 -> WriteAheadLogKt.tryCompact$lambda$7$lambda$6$lambda$5$lambda$4((WalEvent)walEvent3, arg_0));
                        continue;
                    }
                    if (var25_38 instanceof WalEvent.PutEvent) {
                        compactedWal.put(key, ((WalEvent.PutEvent)walEvent3).getValue());
                        continue;
                    }
                    if (var25_38 instanceof WalEvent.RemoveEvent || !(var25_38 instanceof WalEvent.CorruptionEvent)) continue;
                    throw new CorruptionException("wal has been corrupted");
                }
                walEvent = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, throwable);
        }
        return compactedWalFile;
    }

    private static final <V> V readData(byte[] array, DataExternalizer<V> valueExternalizer) {
        return valueExternalizer.read(new DataInputStream(new ByteArrayInputStream(array)));
    }

    private static final <V> byte[] writeData(V value2, DataExternalizer<V> valueExternalizer) {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        valueExternalizer.save(new DataOutputStream(baos), value2);
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    private static final IntLinkedOpenHashSet tryCompact$lambda$3$lambda$0(Object it) {
        return new IntLinkedOpenHashSet();
    }

    private static final IntLinkedOpenHashSet tryCompact$lambda$3$lambda$2(Object it) {
        return new IntLinkedOpenHashSet();
    }

    private static final void tryCompact$lambda$7$lambda$6$lambda$5$lambda$4(WalEvent $walEvent, DataOutput out) {
        Intrinsics.checkNotNullParameter($walEvent, "$walEvent");
        Intrinsics.checkNotNullParameter(out, "out");
        out.write(((WalEvent.AppendEvent)$walEvent).getData());
    }

    public static final /* synthetic */ EnumeratorIntegerDescriptor access$getIntegerExternalizer() {
        return WriteAheadLogKt.getIntegerExternalizer();
    }

    public static final /* synthetic */ Path access$tryCompact(Path walFile, KeyDescriptor keyDescriptor, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.tryCompact(walFile, keyDescriptor, valueExternalizer);
    }

    public static final /* synthetic */ byte[] access$writeData(Object value2, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.writeData(value2, valueExternalizer);
    }

    public static final /* synthetic */ Function0 access$getChecksumGen$p() {
        return checksumGen;
    }

    public static final /* synthetic */ Object access$readData(byte[] array, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.readData(array, valueExternalizer);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WalRecord.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        log = logger;
    }
}

