/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.AbstractFirMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.AbstractMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.MetadataUtilsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirKLibSerializerExtension;
import org.jetbrains.kotlin.fir.serialization.FirKlibSerializationKt;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirKlibMetadataSerializer;", "Lorg/jetbrains/kotlin/cli/metadata/AbstractFirMetadataSerializer;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "serialize", "Lorg/jetbrains/kotlin/cli/metadata/AbstractMetadataSerializer$OutputInfo;", "analysisResult", "", "Lorg/jetbrains/kotlin/fir/pipeline/ModuleCompilerAnalyzedOutput;", "destDir", "Ljava/io/File;", "cli"})
@SourceDebugExtension(value={"SMAP\nFirKlibMetadataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirKlibMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirKlibMetadataSerializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n381#2,7:79\n1053#3:86\n*S KotlinDebug\n*F\n+ 1 FirKlibMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirKlibMetadataSerializer\n*L\n50#1:79,7\n64#1:86\n*E\n"})
public class FirKlibMetadataSerializer
extends AbstractFirMetadataSerializer {
    public FirKlibMetadataSerializer(@NotNull CompilerConfiguration configuration2, @NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(environment, "environment");
        super(configuration2, environment);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected AbstractMetadataSerializer.OutputInfo serialize(@NotNull List<ModuleCompilerAnalyzedOutput> analysisResult2, @NotNull File destDir) {
        Intrinsics.checkNotNullParameter(analysisResult2, "analysisResult");
        Intrinsics.checkNotNullParameter(destDir, "destDir");
        Map fragments = new LinkedHashMap();
        for (ModuleCompilerAnalyzedOutput output : analysisResult2) {
            FirSession session2 = output.component1();
            ScopeSession scopeSession = output.component2();
            List<FirFile> fir = output.component3();
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.getEnvironment().getConfiguration());
            for (FirFile firFile : fir) {
                Object object;
                void $this$getOrPut$iv;
                ProtoBuf.PackageFragment packageFragment = FirKlibSerializationKt.serializeSingleFirFile$default(firFile, session2, scopeSession, null, new FirKLibSerializerExtension(session2, scopeSession, FirProviderKt.getFirProvider(session2), this.getMetadataVersion(), null, false, false, null), languageVersionSettings, false, 64, null);
                Map map = fragments;
                String key$iv = UtilsKt.getPackageFqName(firFile).asString();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List list = (List)object;
                byte[] byArray = packageFragment.toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
                list.add(byArray);
            }
        }
        KlibMetadataProtoBuf.Header.Builder header = KlibMetadataProtoBuf.Header.newBuilder();
        header.setModuleName(FirModuleDataKt.getModuleData(CollectionsKt.last(analysisResult2).getSession()).getName().asString());
        if (CommonConfigurationKeysKt.getLanguageVersionSettings(this.getConfiguration()).isPreRelease()) {
            header.setFlags(2);
        }
        List fragmentNames = new ArrayList();
        List fragmentParts = new ArrayList();
        Object $this$sortedBy$iv22 = fragments.entrySet();
        boolean $i$f$sortedBy = false;
        for (Object $this$sortedBy$iv22 : CollectionsKt.sortedWith($this$sortedBy$iv22, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((String)it.getKey())));
            }
        })) {
            String fqName = (String)$this$sortedBy$iv22.getKey();
            List fragment = (List)$this$sortedBy$iv22.getValue();
            ((Collection)fragmentNames).add(fqName);
            ((Collection)fragmentParts).add(fragment);
            header.addPackageFragmentName(fqName);
        }
        byte[] module2 = header.build().toByteArray();
        Intrinsics.checkNotNull(module2);
        SerializedMetadata serializedMetadata = new SerializedMetadata(module2, fragmentParts, fragmentNames);
        MetadataUtilsKt.buildKotlinMetadataLibrary(this.getConfiguration(), serializedMetadata, destDir);
        return null;
    }
}

