/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstEvaluationContext;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer;", "", "context", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;)V", "visitAnnotations", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "transformAnnotations", "annotationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "transformAnnotation", "annotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "transformAnnotationArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "valueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "transformVarArg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "transformSingleArg", "expectedType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "convertToConstIfPossible", "type", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrConstAnnotationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstAnnotationTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 IrConstEvaluationContext.kt\norg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1863#2:88\n1864#2:97\n1863#2,2:98\n107#3,8:89\n1#4:100\n*S KotlinDebug\n*F\n+ 1 IrConstAnnotationTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer\n*L\n27#1:88\n27#1:97\n55#1:98,2\n28#1:89,8\n*E\n"})
public abstract class IrConstAnnotationTransformer {
    @NotNull
    private final IrConstEvaluationContext context;

    public IrConstAnnotationTransformer(@NotNull IrConstEvaluationContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    public abstract void visitAnnotations(@NotNull IrElement var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void transformAnnotations(@NotNull IrAnnotationContainer annotationContainer) {
        Intrinsics.checkNotNullParameter(annotationContainer, "annotationContainer");
        IrDeclaration irDeclaration2 = annotationContainer instanceof IrDeclaration ? (IrDeclaration)annotationContainer : null;
        boolean declarationIsFakeOverride = Intrinsics.areEqual(irDeclaration2 != null ? irDeclaration2.getOrigin() : null, IrDeclarationOrigin.Companion.getFAKE_OVERRIDE());
        Iterable $this$forEach$iv = annotationContainer.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            IrConstructorCall annotation = (IrConstructorCall)element$iv;
            boolean bl = false;
            IrConstEvaluationContext irConstEvaluationContext = this.context;
            boolean saveConstants$iv = !declarationIsFakeOverride;
            boolean $i$f$saveConstantsOnCondition = false;
            boolean oldValue$iv = IrConstEvaluationContext.access$getShouldSaveEvaluatedConstants$p((IrConstEvaluationContext)this_$iv);
            IrConstEvaluationContext.access$setShouldSaveEvaluatedConstants$p((IrConstEvaluationContext)this_$iv, saveConstants$iv);
            try {
                boolean bl2 = false;
                this.transformAnnotation(annotation);
            }
            finally {
                IrConstEvaluationContext.access$setShouldSaveEvaluatedConstants$p((IrConstEvaluationContext)this_$iv, oldValue$iv);
            }
        }
    }

    private final void transformAnnotation(IrConstructorCall annotation) {
        if (annotation.getType() instanceof IrErrorType) {
            return;
        }
        int n = annotation.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression arg;
            if (annotation.getValueArgument(i) == null) continue;
            annotation.putValueArgument(i, this.transformAnnotationArgument(arg, ((IrConstructor)annotation.getSymbol().getOwner()).getValueParameters().get(i)));
        }
        this.context.saveInConstTracker(annotation);
    }

    private final IrExpression transformAnnotationArgument(IrExpression argument, IrValueParameter valueParameter2) {
        return argument instanceof IrVararg ? (IrExpression)this.transformVarArg((IrVararg)argument) : this.transformSingleArg(argument, valueParameter2.getType());
    }

    private final IrVararg transformVarArg(IrVararg $this$transformVarArg) {
        if ($this$transformVarArg.getElements().isEmpty()) {
            return $this$transformVarArg;
        }
        IrVarargImpl newIrVararg = BuildersKt.IrVarargImpl($this$transformVarArg.getStartOffset(), $this$transformVarArg.getEndOffset(), $this$transformVarArg.getType(), $this$transformVarArg.getVarargElementType());
        for (IrVarargElement element : $this$transformVarArg.getElements()) {
            IrVarargElement arg;
            IrElementBase irElementBase = element instanceof IrSpreadElement ? (IrSpreadElement)element : null;
            IrVarargElement irVarargElement = irElementBase != null && (irElementBase = irElementBase.getExpression()) != null ? (IrVarargElement)((Object)irElementBase) : (arg = element);
            if (arg instanceof IrVararg) {
                Iterable $this$forEach$iv = this.transformVarArg((IrVararg)arg).getElements();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl = false;
                    IrExpressionsKt.addElement(newIrVararg, it);
                }
                continue;
            }
            if (arg instanceof IrExpression) {
                IrExpression irExpression = this.transformSingleArg((IrExpression)arg, $this$transformVarArg.getVarargElementType());
                if (irExpression != null) {
                    IrVarargElement p0 = irExpression;
                    boolean bl = false;
                    IrExpressionsKt.addElement(newIrVararg, p0);
                }
                continue;
            }
            IrExpressionsKt.addElement(newIrVararg, arg);
        }
        return newIrVararg;
    }

    private final IrExpression transformSingleArg(IrExpression $this$transformSingleArg, IrType expectedType) {
        IrExpression irExpression;
        if ($this$transformSingleArg instanceof IrGetClass && ((IrGetClass)$this$transformSingleArg).getArgument().getType() instanceof IrErrorType) {
            irExpression = null;
        } else if ($this$transformSingleArg instanceof IrGetEnumValue || $this$transformSingleArg instanceof IrClassReference) {
            irExpression = $this$transformSingleArg;
        } else if ($this$transformSingleArg instanceof IrConstructorCall && IrTypeUtilsKt.isAnnotation($this$transformSingleArg.getType())) {
            this.transformAnnotation((IrConstructorCall)$this$transformSingleArg);
            irExpression = $this$transformSingleArg;
        } else if (this.context.canBeInterpreted($this$transformSingleArg)) {
            irExpression = this.convertToConstIfPossible(this.context.interpret($this$transformSingleArg, true), expectedType);
        } else {
            throw new IllegalStateException(("Cannot evaluate IR expression in annotation:\n " + DumpIrTreeKt.dump$default($this$transformSingleArg, null, 1, null)).toString());
        }
        return irExpression;
    }

    private final IrExpression convertToConstIfPossible(IrExpression $this$convertToConstIfPossible, IrType type2) {
        IrExpression irExpression;
        if (!($this$convertToConstIfPossible instanceof IrConst) || type2 instanceof IrErrorType) {
            irExpression = $this$convertToConstIfPossible;
        } else if (IrTypePredicatesKt.isArray(type2)) {
            Intrinsics.checkNotNull(type2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrType irType = IrTypesKt.getTypeOrNull(CollectionsKt.single(((IrSimpleType)type2).getArguments()));
            Intrinsics.checkNotNull(irType);
            irExpression = this.convertToConstIfPossible($this$convertToConstIfPossible, irType);
        } else {
            irExpression = UtilsKt.isPrimitiveArray(type2) ? this.convertToConstIfPossible($this$convertToConstIfPossible, $this$convertToConstIfPossible.getType()) : (IrExpression)IrUtilsKt.toIrConst(((IrConst)$this$convertToConstIfPossible).getValue(), type2, $this$convertToConstIfPossible.getStartOffset(), $this$convertToConstIfPossible.getEndOffset());
        }
        return irExpression;
    }
}

