/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class MidFunction
implements Function {
    private static final long serialVersionUID = 4190365695032245709L;

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        Type startType = parameters.getType(1);
        Object startValue = parameters.getValue(1);
        Type lengthType = parameters.getType(2);
        Object lengthValue = parameters.getValue(2);
        String text = typeRegistry.convertToText(textType, textValue);
        Number start = typeRegistry.convertToNumber(startType, startValue);
        Number length = typeRegistry.convertToNumber(lengthType, lengthValue);
        if (length.doubleValue() < 0.0 || start.doubleValue() < 1.0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(TextType.TYPE, MidFunction.process(text, start.intValue(), length.intValue()));
    }

    public static String process(String text, int start, int lengthValue) {
        int startValue = start - 1;
        if (startValue >= text.length() || startValue < 0) {
            return "";
        }
        if (lengthValue + startValue > text.length()) {
            lengthValue = text.length() - startValue;
        }
        return text.substring(startValue, startValue + lengthValue);
    }

    public String getCanonicalName() {
        return "MID";
    }
}

