/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.configuration;

import com.sshtools.daemon.configuration.AllowedSubsystem;
import com.sshtools.daemon.session.SessionChannelServer;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerConfiguration
extends DefaultHandler {
    private static Log log = LogFactory.getLog(ServerConfiguration.class);
    private Map allowedSubsystems = new HashMap();
    private Map serverHostKeys = new HashMap();
    private List allowedAuthentications = new ArrayList();
    private List requiredAuthentications = new ArrayList();
    private int commandPort = 12222;
    private int port = 22;
    private String listenAddress = "0.0.0.0";
    private int maxConnections = 10;
    private int maxAuthentications = 5;
    private String terminalProvider = "";
    private String authorizationFile = "authorization.xml";
    private String userConfigDirectory = "%D/.ssh2";
    private String authenticationBanner = "";
    private boolean allowTcpForwarding = true;
    private String currentElement = null;
    private Class sessionChannelImpl = SessionChannelServer.class;

    public ServerConfiguration(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this.reload(in);
    }

    public void reload(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this.allowedSubsystems.clear();
        this.serverHostKeys.clear();
        this.allowedAuthentications.clear();
        this.requiredAuthentications.clear();
        this.commandPort = 12222;
        this.port = 22;
        this.listenAddress = "0.0.0.0";
        this.maxConnections = 10;
        this.maxAuthentications = 5;
        this.terminalProvider = "";
        this.authorizationFile = "authorization.xml";
        this.userConfigDirectory = "%D/.ssh2";
        this.authenticationBanner = "";
        this.allowTcpForwarding = true;
        this.currentElement = null;
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)this);
    }

    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        block16: {
            if (this.currentElement == null) {
                if (!qname.equals("ServerConfiguration")) {
                    throw new SAXException("Unexpected root element " + qname);
                }
            } else if (this.currentElement.equals("ServerConfiguration")) {
                if (qname.equals("ServerHostKey")) {
                    String privateKey = attrs.getValue("PrivateKeyFile");
                    if (privateKey == null) {
                        throw new SAXException("Required attributes missing from <ServerHostKey> element");
                    }
                    log.debug("ServerHostKey PrivateKeyFile=" + privateKey);
                    File f = new File(privateKey);
                    if (!f.exists()) {
                        privateKey = String.valueOf(ConfigurationLoader.getConfigurationDirectory()) + privateKey;
                        f = new File(privateKey);
                    }
                    try {
                        if (f.exists()) {
                            SshPrivateKeyFile pkf = SshPrivateKeyFile.parse(f);
                            SshPrivateKey key = pkf.toPrivateKey(null);
                            this.serverHostKeys.put(key.getAlgorithmName(), key);
                            break block16;
                        }
                        log.warn("Private key file '" + privateKey + "' could not be found");
                    }
                    catch (InvalidSshKeyException ex) {
                        log.warn("Failed to load private key '" + privateKey, ex);
                    }
                    catch (IOException ioe) {
                        log.warn("Failed to load private key '" + privateKey, ioe);
                    }
                } else if (qname.equals("Subsystem")) {
                    String type = attrs.getValue("Type");
                    String name = attrs.getValue("Name");
                    String provider = attrs.getValue("Provider");
                    if (type == null || name == null || provider == null) {
                        throw new SAXException("Required attributes missing from <Subsystem> element");
                    }
                    log.debug("Subsystem Type=" + type + " Name=" + name + " Provider=" + provider);
                    this.allowedSubsystems.put(name, new AllowedSubsystem(type, name, provider));
                } else if (!(qname.equals("AuthenticationBanner") || qname.equals("MaxConnections") || qname.equals("MaxAuthentications") || qname.equals("ListenAddress") || qname.equals("Port") || qname.equals("CommandPort") || qname.equals("TerminalProvider") || qname.equals("AllowedAuthentication") || qname.equals("RequiredAuthentication") || qname.equals("AuthorizationFile") || qname.equals("UserConfigDirectory") || qname.equals("AllowTcpForwarding"))) {
                    throw new SAXException("Unexpected <" + qname + "> element after SshAPIConfiguration");
                }
            }
        }
        this.currentElement = qname;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (this.currentElement != null) {
            if (this.currentElement.equals("AuthenticationBanner")) {
                this.authenticationBanner = value;
                log.debug("AuthenticationBanner=" + this.authenticationBanner);
            } else if (this.currentElement.equals("MaxConnections")) {
                this.maxConnections = Integer.parseInt(value);
                log.debug("MaxConnections=" + value);
            } else if (this.currentElement.equals("ListenAddress")) {
                this.listenAddress = value;
                log.debug("ListenAddress=" + this.listenAddress);
            } else if (this.currentElement.equals("Port")) {
                this.port = Integer.parseInt(value);
                log.debug("Port=" + value);
            } else if (this.currentElement.equals("CommandPort")) {
                this.commandPort = Integer.parseInt(value);
                log.debug("CommandPort=" + value);
            } else if (this.currentElement.equals("TerminalProvider")) {
                this.terminalProvider = value;
                log.debug("TerminalProvider=" + this.terminalProvider);
            } else if (this.currentElement.equals("AllowedAuthentication")) {
                if (!this.allowedAuthentications.contains(value)) {
                    this.allowedAuthentications.add(value);
                    log.debug("AllowedAuthentication=" + value);
                }
            } else if (this.currentElement.equals("RequiredAuthentication")) {
                if (!this.requiredAuthentications.contains(value)) {
                    this.requiredAuthentications.add(value);
                    log.debug("RequiredAuthentication=" + value);
                }
            } else if (this.currentElement.equals("AuthorizationFile")) {
                this.authorizationFile = value;
                log.debug("AuthorizationFile=" + this.authorizationFile);
            } else if (this.currentElement.equals("UserConfigDirectory")) {
                this.userConfigDirectory = value;
                log.debug("UserConfigDirectory=" + this.userConfigDirectory);
            } else if (this.currentElement.equals("SessionChannelImpl")) {
                try {
                    this.sessionChannelImpl = ConfigurationLoader.getExtensionClass(value);
                }
                catch (Exception e) {
                    log.error("Failed to load SessionChannelImpl " + value, e);
                }
            } else if (this.currentElement.equals("MaxAuthentications")) {
                this.maxAuthentications = Integer.parseInt(value);
                log.debug("MaxAuthentications=" + value);
            } else if (this.currentElement.equals("AllowTcpForwarding")) {
                this.allowTcpForwarding = Boolean.valueOf(value);
            }
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.currentElement != null) {
            if (!this.currentElement.equals(qname)) {
                throw new SAXException("Unexpected end element found <" + qname + ">");
            }
            if (this.currentElement.equals("ServerConfiguration")) {
                this.currentElement = null;
            } else if (this.currentElement.equals("AuthenticationBanner") || this.currentElement.equals("ServerHostKey") || this.currentElement.equals("Subsystem") || this.currentElement.equals("MaxConnections") || this.currentElement.equals("MaxAuthentications") || this.currentElement.equals("ListenAddress") || this.currentElement.equals("Port") || this.currentElement.equals("CommandPort") || this.currentElement.equals("TerminalProvider") || this.currentElement.equals("AllowedAuthentication") || this.currentElement.equals("RequiredAuthentication") || this.currentElement.equals("AuthorizationFile") || this.currentElement.equals("UserConfigDirectory") || this.currentElement.equals("AllowTcpForwarding")) {
                this.currentElement = "ServerConfiguration";
            }
        } else {
            throw new SAXException("Unexpected end element <" + qname + "> found");
        }
    }

    public List getRequiredAuthentications() {
        return this.requiredAuthentications;
    }

    public List getAllowedAuthentications() {
        return this.allowedAuthentications;
    }

    public boolean getAllowTcpForwarding() {
        return this.allowTcpForwarding;
    }

    public String getAuthenticationBanner() {
        return this.authenticationBanner;
    }

    public int getCommandPort() {
        return this.commandPort;
    }

    public String getUserConfigDirectory() {
        return this.userConfigDirectory;
    }

    public String getAuthorizationFile() {
        return this.authorizationFile;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxAuthentications() {
        return this.maxAuthentications;
    }

    public int getPort() {
        return this.port;
    }

    public Map getServerHostKeys() {
        return this.serverHostKeys;
    }

    public Map getSubsystems() {
        return this.allowedSubsystems;
    }

    public String getTerminalProvider() {
        return this.terminalProvider;
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = String.valueOf(xml) + "<!-- Server configuration file - If filenames are not absolute they are assummed to be in the same directory as this configuration file. -->\n";
        xml = String.valueOf(xml) + "<ServerConfiguration>\n";
        xml = String.valueOf(xml) + "   <!-- The available host keys for server authentication -->\n";
        for (Map.Entry entry : this.serverHostKeys.entrySet()) {
            xml = String.valueOf(xml) + "   <ServerHostKey PrivateKeyFile=\"" + entry.getValue() + "\"/>\n";
        }
        xml = String.valueOf(xml) + "   <!-- Add any number of subsystem elements here -->\n";
        Iterator it = this.allowedSubsystems.entrySet().iterator();
        while (it.hasNext()) {
            AllowedSubsystem subsystem = (AllowedSubsystem)it.next().getValue();
            xml = String.valueOf(xml) + "   <Subsystem Name=\"" + subsystem.getName() + "\" Type=\"" + subsystem.getType() + "\" Provider=\"" + subsystem.getProvider() + "\"/>\n";
        }
        xml = String.valueOf(xml) + "   <!-- Display the following authentication banner before authentication -->\n";
        xml = String.valueOf(xml) + "   <AuthenticationBanner>" + this.authenticationBanner + "</AuthenticationBanner>\n";
        xml = String.valueOf(xml) + "   <!-- The maximum number of connected sessions available -->\n";
        xml = String.valueOf(xml) + "   <MaxConnections>" + String.valueOf(this.maxConnections) + "</MaxConnections>\n";
        xml = String.valueOf(xml) + "   <!-- The maximum number of authentication attemtps for each connection -->\n";
        xml = String.valueOf(xml) + "   <MaxAuthentications>" + String.valueOf(this.maxAuthentications) + "</MaxAuthentications>\n";
        xml = String.valueOf(xml) + "   <!-- Bind to the following address to listen for connections -->\n";
        xml = String.valueOf(xml) + "   <ListenAddress>" + this.listenAddress + "</ListenAddress>\n";
        xml = String.valueOf(xml) + "   <!-- The port to listen to -->\n";
        xml = String.valueOf(xml) + "   <Port>" + String.valueOf(this.port) + "</Port>\n";
        xml = String.valueOf(xml) + "   <!-- Listen on the following port (on localhost) for server commands such as stop -->\n";
        xml = String.valueOf(xml) + "   <CommandPort>" + String.valueOf(this.commandPort) + "</CommandPort>\n";
        xml = String.valueOf(xml) + "   <!-- Specify the executable that provides the default shell -->\n";
        xml = String.valueOf(xml) + "   <TerminalProvider>" + this.terminalProvider + "</TerminalProvider>\n";
        xml = String.valueOf(xml) + "   <!-- Specify any number of allowed authentications -->\n";
        it = this.allowedAuthentications.iterator();
        while (it.hasNext()) {
            xml = String.valueOf(xml) + "   <AllowedAuthentication>" + it.next().toString() + "</AllowedAuthentication>\n";
        }
        xml = String.valueOf(xml) + "   <!-- Specify any number of required authentications -->\n";
        it = this.requiredAuthentications.iterator();
        while (it.hasNext()) {
            xml = String.valueOf(xml) + "   <RequiredAuthentication>" + it.next().toString() + "</RequiredAuthentication>\n";
        }
        xml = String.valueOf(xml) + "   <!-- The users authorizations file -->\n";
        xml = String.valueOf(xml) + "   <AuthorizationFile>" + this.authorizationFile + "</AuthorizationFile>\n";
        xml = String.valueOf(xml) + "   <!-- The users configuration directory where files such as AuthorizationFile are found. For users home directory specify %D For users name specify %U  -->\n";
        xml = String.valueOf(xml) + "   <UserConfigDirectory>" + this.userConfigDirectory + "</UserConfigDirectory>\n";
        xml = String.valueOf(xml) + "<AllowTcpForwarding>" + String.valueOf(this.allowTcpForwarding) + "</AllowTcpForwarding>\n";
        xml = String.valueOf(xml) + "</ServerConfiguration>\n";
        return xml;
    }
}

