/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.ColorHelper;

public final class Colorizer {
    private static Object Self;
    private static int testcount;
    private static Colorizer myColorizer;
    private static final int S = 30;
    private static final int s = 40;
    private static final int R = 31;
    private static final int r = 41;
    private static final int G = 32;
    private static final int g = 42;
    private static final int Y = 33;
    private static final int y = 43;
    private static final int B = 34;
    private static final int b = 44;
    private static final int M = 35;
    private static final int m = 45;
    private static final int C = 36;
    private static final int c = 46;
    private static final int W = 37;
    private static final int w = 47;
    private static final int f = 1;
    private static final int d = 22;
    private static final int i = 3;
    private static final int j = 23;
    private static final int u = 4;
    private static final int v = 24;
    private static final int e = 5;
    private static final int n = 25;
    private static final int h = 8;
    private static final int a = 0;
    private int[] colortranslation = new int[128];
    private int leng;

    static {
        testcount = 0;
    }

    private Colorizer() {
        this.colortranslation[83] = 30;
        this.colortranslation[82] = 31;
        this.colortranslation[71] = 32;
        this.colortranslation[89] = 33;
        this.colortranslation[66] = 34;
        this.colortranslation[77] = 35;
        this.colortranslation[67] = 36;
        this.colortranslation[87] = 37;
        this.colortranslation[115] = 40;
        this.colortranslation[114] = 41;
        this.colortranslation[103] = 42;
        this.colortranslation[121] = 43;
        this.colortranslation[98] = 44;
        this.colortranslation[109] = 45;
        this.colortranslation[99] = 46;
        this.colortranslation[119] = 47;
        this.colortranslation[102] = 1;
        this.colortranslation[100] = 22;
        this.colortranslation[105] = 3;
        this.colortranslation[106] = 23;
        this.colortranslation[117] = 4;
        this.colortranslation[118] = 24;
        this.colortranslation[101] = 5;
        this.colortranslation[110] = 25;
        this.colortranslation[104] = 8;
        this.colortranslation[97] = 0;
        Self = this;
    }

    public String colorize(String str, boolean support) {
        StringBuffer out = new StringBuffer(str.length() + 20);
        int parsecursor = 0;
        int foundcursor = 0;
        boolean done = false;
        while (!done) {
            foundcursor = str.indexOf(1, parsecursor);
            if (foundcursor != -1) {
                out.append(str.substring(parsecursor, foundcursor));
                if (support) {
                    out.append(this.addEscapeSequence(str.substring(foundcursor + 1, foundcursor + 2)));
                }
                parsecursor = foundcursor + 2;
                continue;
            }
            out.append(str.substring(parsecursor, str.length()));
            done = true;
        }
        if (support) {
            out.append(this.addEscapeSequence("a"));
        }
        return out.toString();
    }

    private String addEscapeSequence(String attribute) {
        StringBuffer tmpbuf = new StringBuffer(10);
        byte[] tmpbytes = attribute.getBytes();
        byte key = tmpbytes[0];
        tmpbuf.append('\u001b');
        tmpbuf.append('[');
        tmpbuf.append(new Integer(this.colortranslation[key]).toString());
        tmpbuf.append('m');
        return tmpbuf.toString();
    }

    public static Colorizer getReference() {
        if (Self != null) {
            return (Colorizer)Self;
        }
        return new Colorizer();
    }

    private static void announceResult(boolean res) {
        if (res) {
            System.out.println("[#" + testcount + "] ok.");
        } else {
            System.out.println("[#" + testcount + "] failed (see possible StackTrace).");
        }
    }

    private static void announceTest(String what) {
        System.out.println("Test #" + ++testcount + " [" + what + "]:");
    }

    private static void bfcolorTest(String color) {
        System.out.println("->" + myColorizer.colorize(ColorHelper.boldcolorizeText("COLOR", color), true) + "<-");
    }

    private static void fcolorTest(String color) {
        System.out.println("->" + myColorizer.colorize(ColorHelper.colorizeText("COLOR", color), true) + "<-");
    }

    private static void bcolorTest(String color) {
        System.out.println("->" + myColorizer.colorize(ColorHelper.colorizeBackground("     ", color), true) + "<-");
    }

    public static void main(String[] args) {
        try {
            Colorizer.announceTest("Instantiation");
            myColorizer = Colorizer.getReference();
            Colorizer.announceResult(true);
            Colorizer.announceTest("Textcolor Tests");
            Colorizer.fcolorTest("S");
            Colorizer.fcolorTest("R");
            Colorizer.fcolorTest("G");
            Colorizer.fcolorTest("Y");
            Colorizer.fcolorTest("B");
            Colorizer.fcolorTest("M");
            Colorizer.fcolorTest("C");
            Colorizer.fcolorTest("W");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Bold textcolor Tests");
            Colorizer.bfcolorTest("S");
            Colorizer.bfcolorTest("R");
            Colorizer.bfcolorTest("G");
            Colorizer.bfcolorTest("Y");
            Colorizer.bfcolorTest("B");
            Colorizer.bfcolorTest("M");
            Colorizer.bfcolorTest("C");
            Colorizer.bfcolorTest("W");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Background Tests");
            Colorizer.bcolorTest("S");
            Colorizer.bcolorTest("R");
            Colorizer.bcolorTest("G");
            Colorizer.bcolorTest("Y");
            Colorizer.bcolorTest("B");
            Colorizer.bcolorTest("M");
            Colorizer.bcolorTest("C");
            Colorizer.bcolorTest("W");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Mixed Color Tests");
            System.out.println("->" + myColorizer.colorize(ColorHelper.colorizeText("COLOR", "W", "B"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.colorizeText("COLOR", "Y", "G"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.boldcolorizeText("COLOR", "W", "B"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.boldcolorizeText("COLOR", "Y", "G"), true) + "<-");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Style Tests");
            System.out.println("->" + myColorizer.colorize(ColorHelper.boldText("Bold"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.italicText("Italic"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.underlinedText("Underlined"), true) + "<-");
            System.out.println("->" + myColorizer.colorize(ColorHelper.blinkingText("Blinking"), true) + "<-");
            Colorizer.announceResult(true);
            Colorizer.announceTest("Visible length test");
            String colorized = ColorHelper.boldcolorizeText("STRING", "Y");
            System.out.println("->" + myColorizer.colorize(colorized, true) + "<-");
            System.out.println("Visible length=" + ColorHelper.getVisibleLength(colorized));
            colorized = String.valueOf(ColorHelper.boldcolorizeText("BANNER", "W", "B")) + ColorHelper.colorizeText("COLOR", "W", "B") + ColorHelper.underlinedText("UNDER");
            System.out.println("->" + myColorizer.colorize(colorized, true) + "<-");
            System.out.println("Visible length=" + ColorHelper.getVisibleLength(colorized));
            Colorizer.announceResult(true);
        }
        catch (Exception e) {
            Colorizer.announceResult(false);
            e.printStackTrace();
        }
    }
}

