/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.data;

import edu.harvard.mgh.purcell.gCLINE.data.KeyWords;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileInfo
extends DefaultMutableTreeNode
implements KeyWords {
    private String filename;
    private String globalDisc;
    private String localDisc;

    public void setLocalDisc(String newDisc) {
        this.localDisc = newDisc;
        this.removeAllChildren();
        if (!this.globalDisc.equals("") || !this.localDisc.equals("")) {
            this.add(new DefaultMutableTreeNode(String.valueOf(this.globalDisc) + "; " + this.localDisc));
        }
    }

    public String getLocalDisc() {
        return this.localDisc;
    }

    public void setGlobalDisc(String newDisc) {
        this.globalDisc = newDisc;
        this.removeAllChildren();
        if (!this.globalDisc.equals("") || !this.localDisc.equals("")) {
            this.add(new DefaultMutableTreeNode(String.valueOf(this.globalDisc) + "; " + this.localDisc));
        }
    }

    public String getGlobalDisc() {
        return this.globalDisc;
    }

    public static String fileName(String file) {
        if (file == null) {
            return null;
        }
        String[] temp = null;
        String tfile = file;
        if (tfile.endsWith("\"")) {
            tfile = tfile.substring(0, tfile.length() - 1);
        }
        if (tfile.contains("/")) {
            temp = tfile.split("/");
        } else if (tfile.contains("\\")) {
            temp = tfile.split("\\\\");
        } else {
            return tfile;
        }
        return temp[temp.length - 1];
    }

    public static String quote(String given) {
        String ans = given;
        if (!(!given.matches(".*\\s+.*") || given.startsWith("\"") && given.endsWith("\""))) {
            ans = "\"" + ans + "\"";
        }
        return ans;
    }

    public FileInfo(String name, String local, String global) {
        this.filename = FileInfo.fileName(name);
        this.globalDisc = global != null ? global : "";
        this.localDisc = local != null ? local : "";
        if (!this.globalDisc.equals("") || !this.localDisc.equals("")) {
            super.add(new DefaultMutableTreeNode(String.valueOf(global) + "; " + local));
        }
    }

    public FileInfo() {
        this("", "", "");
    }

    public String getDiscription() {
        return String.valueOf(this.globalDisc) + "; " + this.localDisc;
    }

    public Element asElement(Document d) {
        Element file = d.createElement("entity");
        file.setAttribute("name", this.filename);
        file.setTextContent(this.getLocalDisc());
        return file;
    }

    public String toString() {
        String ans = this.filename;
        return ans;
    }

    public static void main(String[] args) {
        String tester = "something with spaces";
        System.out.println(tester);
        System.out.println(FileInfo.quote(tester));
        String tester2 = "something_wihtout_spaces";
        System.out.println(tester2);
        System.out.println(FileInfo.quote(tester2));
    }
}

