/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.fife.ui.EscapableDialog;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextfilechooser.DirectoryTree;

public class RDirectoryChooser
extends EscapableDialog {
    private JButton okButton;
    private JButton cancelButton;
    private DirectoryTree directoryTree;
    private String chosenDirectory;

    public RDirectoryChooser() {
        this((Frame)null);
    }

    public RDirectoryChooser(Dialog parent) {
        this(parent, null);
    }

    public RDirectoryChooser(Frame parent) {
        this(parent, null);
    }

    public RDirectoryChooser(Dialog parent, String title) {
        super(parent);
        this.init(parent, title);
    }

    public RDirectoryChooser(Frame parent, String title) {
        super(parent);
        this.init(parent, title);
    }

    public String getChosenDirectory() {
        return this.chosenDirectory;
    }

    public void escapePressed() {
        this.chosenDirectory = null;
        super.escapePressed();
    }

    private void init(Window parent, String title) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        Listener listener = new Listener();
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextfilechooser.DirectoryChooser");
        ResizableFrameContentPane contentPane = new ResizableFrameContentPane(new BorderLayout());
        contentPane.setBorder(UIUtil.getEmpty5Border());
        JPanel treePanel = new JPanel(new GridLayout(1, 1));
        this.directoryTree = new DirectoryTree();
        this.directoryTree.getSelectionModel().addTreeSelectionListener(listener);
        this.directoryTree.addPropertyChangeListener(listener);
        RScrollPane scrollPane = new RScrollPane(this.directoryTree);
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        treePanel.add(scrollPane);
        contentPane.add(treePanel);
        this.okButton = UIUtil.newButton(msg, "OK", "OKMnemonic");
        this.okButton.setEnabled(false);
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(listener);
        this.cancelButton = UIUtil.newButton(msg, "Cancel", "CancelMnemonic");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(listener);
        Container buttons = UIUtil.createButtonFooter(this.okButton, this.cancelButton);
        contentPane.add((Component)buttons, "South");
        this.setContentPane(contentPane);
        this.setTitle(title == null ? msg.getString("DefaultTitle") : title);
        this.applyComponentOrientation(orientation);
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(parent);
    }

    public boolean setChosenDirectory(File dir) {
        return this.directoryTree.setSelectedFile(dir);
    }

    private class Listener
    implements ActionListener,
    TreeSelectionListener,
    PropertyChangeListener {
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("OK")) {
                RDirectoryChooser.this.chosenDirectory = RDirectoryChooser.this.directoryTree.getSelectedFileName();
                RDirectoryChooser.this.setVisible(false);
            } else if (actionCommand.equals("Cancel")) {
                RDirectoryChooser.this.escapePressed();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if (property.equals("FileSystemTree.treeWillExpand")) {
                RDirectoryChooser.this.setCursor(Cursor.getPredefinedCursor(3));
            } else if (property.equals("FileSystemTree.treeExpanded")) {
                RDirectoryChooser.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            RDirectoryChooser.this.okButton.setEnabled(e.getNewLeadSelectionPath() != null);
        }
    }
}

